<?php
/**
* @package GameMonetize CMS 
*/

set_time_limit(0);
session_start();
date_default_timezone_set( 'UTC' ); // GameMonetize.com calculates offsets from UTC
define('CORE_PILOT', true);

if ( !defined( 'ABSPATH' ) ) 
    define('ABSPATH', dirname(dirname(dirname(__FILE__))) . '/');

$time = ceil( time() );
$date = date("j/m/y g:iA", $time);
$access = true;
if ( td_installing() ) {
    require_once( ABSPATH . 'assets/includes/config.php');
    require_once ABSPATH . 'assets/includes/tables.php';

    /**
    * Connecting to MySql server
    */
    $GameMonetizeConnect = @new mysqli($dbGM['host'], $dbGM['user'], $dbGM['pass'], $dbGM['name']);

    /**
    * Set up connection charset
    */
    //$GameMonetizeConnect->set_charset("utf8");

    /**
    * Check connection status
    */
    if ($GameMonetizeConnect->connect_errno) 
        exit($GameMonetizeConnect->connect_errno);
    require_once ABSPATH . 'assets/classes/load.php';
    require_once ABSPATH . 'gm-content/addons/load.php';
    require_once ABSPATH . 'assets/includes/engine.php';
}


/* 
* General functions 
*/
function is_logged() 
{

    if (isset($_COOKIE["gm_ac_u"]) && isset($_COOKIE["gm_ac_p"])) 
    {
        $userId = (int) secureEncode($_COOKIE["gm_ac_u"]);
        $userPass = secureEncode($_COOKIE["gm_ac_p"]);

        global $GameMonetizeConnect;
        $query = $GameMonetizeConnect->query("SELECT id FROM ".ACCOUNTS." WHERE id=$userId AND password='$userPass' AND active=1");
        $fetch = $query->num_rows;
        
        return $fetch;
    }
}

function is_admin() 
{
    global $userData;
    return (is_logged() && $userData['admin']) ? true : false;
}

function is_page( $page ) {
    static $this_page = '';
    switch ($page) {
        case 'play':
            $this_page = 'play' === $_GET['p'] && !empty($_GET['id']) && getGame2($_GET['id']);
        break;

        case 'admin':
            $this_page = 'admin' === $_GET['p'];
        break;
        
        case 'home':
        default:
            $this_page = 'home' === $_GET['p'];
        break;
    }
    return (bool) ($this_page) ? true : false;
}


function title_tag() 
{
    return '<title>' . td_title() . '</title>';
}


function td_title($name_display=true, $sep1='&middot;', $sep2='&raquo;') 
{
    global $config, $lang;
    if (!isset($_GET['p'])) {
        $_GET['p'] = 'home';
    }

    switch ($_GET['p']) {
        case 'home':
            $cat=$_GET["cat"];;
            if($cat<>""){
                $cat = str_replace('-', '.', $cat); 
                $cat = ucfirst($cat);
                return $cat . " Games - Play Games Online Free at GameFree.Games";
            }
        break;
        case 'index':
            $set = $lang['page_home'];
        break;
        case 'categories':
            return "Categories - " . $config['site_name'];
        break;
        case 'new-games':
            return "New Games - " . $config['site_name'];
        break; 
        case 'best-games':
            return "Best Games - " . $config['site_name'];
        break;
        case 'about':
            return "About us - " . $config['site_name'];
        break;
        case 'featured-games':
           return "Featured Games - " . $config['site_name'];
        break;
        case 'played-games':
            return "Played - " . $config['site_name'];
        break;
        case 'terms':
            return "Terms - " . $config['site_name'];
        break;
        case 'privacy':
            return "Privacy Policy - " . $config['site_name'];
        break;  
        case 'tags':
            return "Tags - " . $config['site_name'];
        break;
        case 'search':
            return "Search - " . $config['site_name'];
        break;
        case 'setting':
            if (isset($_GET['section']) && !empty($_GET['section'])) {
                $page_section = $_GET['section'];
                if ($page_section == 'info') {
                    $set = $lang['page_setting'].' '.$sep2.' '.$lang['page_section_info'];
                } elseif ($page_section == 'avatar') {
                    $set = $lang['page_setting'].' '.$sep2.' '.$lang['page_section_avatar'];
                } elseif ($page_section == 'theme') {
                    $set = $lang['page_setting'].' '.$sep2.' '.$lang['page_section_theme'];
                } elseif ($page_section == 'password') {
                    $set = $lang['page_setting'].' '.$sep2.' '.$lang['page_section_password'];
                } else {
                    $set = $lang['page_section_not_found'];
                }
            } else {
                $set = $lang['page_section_not_found'];
            }
            
        break;
        case 'profile':
            if (isset($_GET['id']) && !empty($_GET['id'])) {
                if (getData($_GET['id'], 'id') == true) {
                    $username_titled = getData($_GET['id'], 'name');
                    $set = $username_titled['name'];
                } else {
                    $set = $lang['page_user_not_found'];
                }
            } else {
                $set = $lang['page_user_not_found'];
            }
        break;
        case 'search':
            if (isset($_GET['q']) && !empty($_GET['q'])) {
                $set = $lang['page_search'].' '.$sep2.' '.$_GET['q'];
            } else {
                $set = $lang['page_search'];
            }
        break;
        case 'play':
            if (isset($_GET['id']) && !empty($_GET['id'])) {
                if (getGame2($_GET['id'], 'id') == true) {
                    $gamename_titled = getGame2($_GET['id'], 'name');
                    $set = $gamename_titled['name'];
                } else {
                    $set = $lang['page_game_not_found'];
                }
            } else {
                $set = $lang['page_game_not_found'];
            }
        break;
        case 'admin':
            if (isset($_GET['section']) && !empty($_GET['section'])) {
                $page_section = $_GET['section'];
                if ($page_section == 'global') {
                    $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_global'];
                } elseif ($page_section == 'addgame') {
                    $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_addgame'];
                } elseif ($page_section == 'setting') {
                    $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_setting'];
                } elseif ($page_section == 'games') {
                    if (isset($_GET['action']) && !empty($_GET['action'])) {
                        $section_page = $_GET['action'];
                        if ($section_page == 'edit') {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_games'].' &rsaquo; '.$lang['admin_game_edit'];
                        } else {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_games'].' &rsaquo; '.$lang['page_section_not_found'];
                        }
                    } else {
                        $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_games'];
                    }
                } elseif ($page_section == 'categories') {
                    if (isset($_GET['action']) && !empty($_GET['action'])) {
                        $section_page = $_GET['action'];
                        if ($section_page == 'add') {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_categories'].' &rsaquo; '.$lang['admin_category_add'];
                        } elseif ($section_page == 'edit') {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_categories'].' &rsaquo; '.$lang['admin_category_edit'];
                        } else {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_categories'].' &rsaquo; '.$lang['page_section_not_found'];
                        }
                    } else {
                        $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_categories'];
                    }
                } elseif ($page_section == 'users') {
                    if (isset($_GET['action']) && !empty($_GET['action'])) {
                        $section_page = $_GET['action'];
                        if ($section_page == 'edit') {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_users'].' &rsaquo; '.$lang['admin_user_edit'];
                        } else {
                            $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_users'].' &rsaquo; '.$lang['page_section_not_found'];
                        }
                    } else {
                        $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_users'];
                    }
                } elseif ($page_section == 'ads') {
                    $set = $lang['page_admin'].' '.$sep2.' '.$lang['page_admin_section_ads'];
                } else {
                    $set = $lang['page_section_not_found'];
                }
            } else {
                $set = $lang['page_section_not_found'];
            }        
        break;
        case 'login':
            $set = $lang['page_login'];
        break;
        case 'signup':
            $set = $lang['page_signup'];
        break;
        case 'error':
        default:
            $set = $lang['page_error'];
        break;
    }

    if ($name_display) {
        return $config['site_name'];
    } else {
        return $set;
    }
}

function slugify($text) {
  // replace non letter or digits by -
  $text = preg_replace('~[^\pL\d]+~u', '-', $text);

  // transliterate
  $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

  // remove unwanted characters
  $text = preg_replace('~[^-\w]+~', '', $text);

  // trim
  $text = trim($text, '-');

  // remove duplicate -
  $text = preg_replace('~-+~', '-', $text);

  // lowercase
  $text = strtolower($text);

  if (empty($text)) {
    return 'n-a';
  }

  return $text;
}

function urlState($url, $type=false) 
{
    if ($type == true) {
        return urlencode($url);
    }
    elseif($type == false) {
        return urldecode($url);
    }
}


function siteUrl() 
{
    global $config;
    return $config['site_url'];
}


function shortStr($str, $len, $pnt=true) 
{
    if (strlen($str) > $len) {
        if ($pnt == true) {
            $str = mb_substr($str, 0, $len, 'UTF-8')."…";
        } else {
            $str = mb_substr($str, 0, $len, 'UTF-8');
        }
    }
    return $str;
}

function secureEncode($string) 
{
    global $GameMonetizeConnect;
    $string = trim($string);
    if (!$GameMonetizeConnect->connect_errno) {
    $string = mysqli_real_escape_string($GameMonetizeConnect, $string);
    }
    $string = htmlspecialchars($string, ENT_QUOTES);
    $string = str_replace('\\r\\n', '<br>',$string);
    $string = str_replace('\\r', '<br>',$string);
    $string = str_replace('\\n\\n', '<br>',$string);
    $string = str_replace('\\n', '<br>',$string);
    $string = str_replace('\\n', '<br>',$string);
    $string = stripslashes($string);
    $string = str_replace('&amp;#', '&#',$string);
    
    return $string;
}


function decodeHTML($string) 
{
    return $string = htmlspecialchars_decode($string);
}


function addslashes__recursive($var)
{
    if (!is_array($var))
    return addslashes($var);
    $new_var = array();
    foreach ($var as $k => $v)$new_var[addslashes($k)]=addslashes__recursive($v);
    return $new_var;
}

$_POST=addslashes__recursive($_POST);
$_GET=addslashes__recursive($_GET);
$_REQUEST=addslashes__recursive($_REQUEST);
$_SERVER=addslashes__recursive($_SERVER);
$_COOKIE=addslashes__recursive($_COOKIE);

function get_game_container_src($get_game_id, $get_game_width, $get_game_height) 
{
    $get_game_data = getGame($get_game_id);
    $urlgame = $get_game_data['file'];

    $game_get_source = '<iframe src="'.$urlgame.'" id="game-player" width="100%" height="100%" frameborder="0" scrolling="no" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';

    return $game_get_source;
}


function gameFileUrl($file_url, $import) 
{
    if ($import == 1) {
        $game_url = siteUrl() . '/data-games/' . $file_url;
    }
    else {
        $game_url = $file_url;
    }
    return $game_url;
}


function gameImageUrl($image_url, $import) 
{
    global $config;

    if ($import == 1) {
        $url = siteUrl().'/'.$image_url;
    }
    else {
        if ($image_url == '') {
            $url = $config['theme_path'] . '/image/data-game/default_game-thumb.png';
        }
        else {
            $url = $image_url;
        }
    }
    return $url;
}


function gameData($row_data) 
{
    global $userData;

    $game = array('game_id' => $row_data['game_id'], 'game_name' => $row_data['game_name'], 'instructions' => nl2br($row_data['instructions']), 'plays' => number_format($row_data['plays'], 0, '', '.'), 'category' => $row_data['category']);
    
    $game['name'] = $row_data['name'];
    $game['description'] = $row_data['description'];
    $game['game_url'] = siteUrl().'/game/' . slugify($game['name']);
    $game['file_url'] = gameFileUrl($row_data['file'], $row_data['import']);
    $game['file'] = $row_data['file'];
    $game['embed'] = get_game_container_src($game['game_id'], $row_data['w'], $row_data['h']);
    $game['image_url'] = gameImageUrl($row_data['image'], $row_data['import']);
    $game['featured'] = "";
    if( $row_data['featured']  == "1") {
        $game['featured'] = "<span class='featured_icon'></span>";
    }

    if (is_logged() && $userData['admin'] == 1) {
        $game['admin_edit'] = '<button data-href="'.siteUrl().'/admin/games/edit/'.$row_data['game_id'].'" class="stt-adm-button top-gm-btn fa fa-pencil"></button>';
    }
    else {
        $game['admin_edit'] = '';
    }

    $game['date_added'] = date('d/m/y', $row_data['date_added']);

    return $game;
}


function getGame($gid=0) 
{
    global $GameMonetizeConnect;
    
    $gid = secureEncode($gid);
    $sql_query_game = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE game_id='{$gid}'");
    if ($sql_query_game->num_rows == 1) {
        if ($game = $sql_query_game->fetch_array()) {
            return $game;
        }
    }
}

function getGame2($id) 
{
    global $GameMonetizeConnect;

    $sql_query_game = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE game_name='{$id}'");
    if ($sql_query_game->num_rows == 1) {
        if ($game = $sql_query_game->fetch_array()) {
            return $game;
        }
    }
}


function getAvatar($avatar_id=0, $gender=1, $avatar_size='large') 
{
    $userGet_media = getMedia($avatar_id);

    if ($avatar_id != 0) {
        $avatar_picture = $userGet_media[''.$avatar_size.''];
    } else {
        if ($gender == 2) {
            $avatar_picture = siteUrl()."/static/avatar-female.png";
        } else {
            $avatar_picture = siteUrl()."/static/avatar-male.png";
        }
    }

    return $avatar_picture;
}


function getInfo($user_id=0) 
{
    global $GameMonetizeConnect;

    if (empty($user_id) or !is_numeric($user_id) or $user_id < 1) {
        return false;
    }

    $user_id = secureEncode($user_id);

    $user_info = "SELECT gender,about FROM ".USERS." WHERE user_id = '{$user_id}'";
    $user_info_query = $GameMonetizeConnect->query($user_info);

    if ($user_info_query->num_rows == 1) {
        if ($user = $user_info_query->fetch_array()) {
            return $user;
        }
    }
}

function getData($user_id=0, $query_select='*') 
{
    global $GameMonetizeConnect;

    if (is_numeric($user_id)) {
        $user_id_type = "id = " . $user_id;
    } elseif (preg_match('/[A-Za-z0-9_]/', $user_id)) {
        $user_id_type = "username = '{$user_id}'";
    } else {
        return false;
    }

    $user_id = secureEncode($user_id);
    $user_data = "SELECT $query_select FROM ".ACCOUNTS." WHERE " . $user_id_type;
    $user_data_query = $GameMonetizeConnect->query($user_data);

    if ($user_data_query->num_rows == 1) {
        if ($user = $user_data_query->fetch_array()) {
            return $user;
        }
    }
}

function getMedia($file_id=0) 
{
    global $GameMonetizeConnect;
    
    if (empty($file_id) or !is_numeric($file_id) or $file_id < 1) {
        return false;
    }
    
    $file_id = secureEncode($file_id);
    $query_one = "SELECT * FROM ".MEDIA." WHERE id=$file_id";
    $sql_query_one = $GameMonetizeConnect->query($query_one);
    
    if ($sql_query_one->num_rows == 1) {
        $sql_fetch_one = mysqli_fetch_assoc($sql_query_one);
        $sql_fetch_one['complete'] = siteUrl().'/'.$sql_fetch_one['url'] . '.' . $sql_fetch_one['extension'];
        $sql_fetch_one['large'] = siteUrl().'/'.$sql_fetch_one['url'] . '_100x75.' . $sql_fetch_one['extension'];
        $sql_fetch_one['medium'] = siteUrl().'/'.$sql_fetch_one['url'] . '_100x100.' . $sql_fetch_one['extension'];
        $sql_fetch_one['thumb'] = siteUrl().'/'.$sql_fetch_one['url'] . '_thumb.' . $sql_fetch_one['extension'];

        return $sql_fetch_one;
    }
}


function uploadMedia($upload) 
{
    if ($GLOBALS['access'] !== true) {
        return false;
    }
    
    global $GameMonetizeConnect;
    set_time_limit(0);
    
    if (!file_exists('data-photo/' . date('Y'))) {
        mkdir('data-photo/' . date('Y'), 0777, true);
    }
    
    if (!file_exists('data-photo/' . date('Y') . '/' . date('m'))) {
        mkdir('data-photo/' . date('Y') . '/' . date('m'), 0777, true);
    }
    
    $photo_dir = 'data-photo/' . date('Y') . '/' . date('m');
    
    if (is_uploaded_file($upload['tmp_name'])) {
        $upload['name'] = secureEncode($upload['name']);
        $name = preg_replace('/([^A-Za-z0-9_\-\.]+)/i', '', $upload['name']);
        $ext = strtolower(substr($upload['name'], strrpos($upload['name'], '.') + 1, strlen($upload['name']) - strrpos($upload['name'], '.')));
        
        if ($upload['size'] > 1024) {
            
            if (preg_match('/(jpg|jpeg|png)/', $ext)) {
                
                list($width, $height) = getimagesize($upload['tmp_name']);
                
                $query_one = "INSERT INTO " . MEDIA . " (extension, name, type) VALUES ('$ext','$name','photo')";
                $sql_query_one = $GameMonetizeConnect->query($query_one);
                
                if ($sql_query_one) {
                    $sql_id = mysqli_insert_id($GameMonetizeConnect);
                    $original_file_name = $photo_dir . '/' . generateKey() . '_' . $sql_id . '_' . md5($sql_id);
                    $original_file = $original_file_name . '.' . $ext;
                    
                    if (move_uploaded_file($upload['tmp_name'], $original_file)) {
                        $min_size = $width;
                        
                        if ($width > $height) {
                            $min_size = $height;
                        }
                        
                        $min_size = floor($min_size);
                        
                        if ($min_size > 920) {
                            $min_size = 920;
                        }
                        
                        $imageSizes = array(
                            'thumb' => array(
                                'type' => 'crop',
                                'width' => 64,
                                'height' => 64,
                                'name' => $original_file_name . '_thumb'
                            ),
                            '100x100' => array(
                                'type' => 'crop',
                                'width' => $min_size,
                                'height' => $min_size,
                                'name' => $original_file_name . '_100x100'
                            ),
                            '100x75' => array(
                                'type' => 'crop',
                                'width' => $min_size,
                                'height' => floor($min_size * 0.75),
                                'name' => $original_file_name . '_100x75'
                            )
                        );
                        
                        foreach ($imageSizes as $ratio => $data) {
                            $save_file = $data['name'] . '.' . $ext;
                            processMedia($data['type'], $original_file, $save_file, $data['width'], $data['height']);
                        }
                        
                        processMedia('resize', $original_file, $original_file, $min_size, 0);
                        $GameMonetizeConnect->query("UPDATE " . MEDIA . " SET url='$original_file_name' WHERE id=$sql_id");
                        $get = array(
                            'id' => $sql_id,
                            'extension' => $ext,
                            'name' => $name,
                            'url' => $original_file_name
                        );
                        
                        return $get;
                    }
                }
            }
        }
    }
}


function uploadGameMedia($upload, $gamename)  
{
   if ($GLOBALS['access'] !== true) return false;
    
    global $GameMonetizeConnect;
    set_time_limit(0);
    
    if (!file_exists('images/')) {
        mkdir('images/', 0777, true);
    }
    
    $photo_dir = 'images/';
    
    if (is_uploaded_file($upload['tmp_name'])) {
        $upload['name'] = secureEncode($upload['name']);
        $name = preg_replace('/([^A-Za-z0-9_\-\.]+)/i', '', $upload['name']);
        $ext = strtolower(substr($upload['name'], strrpos($upload['name'], '.') + 1, strlen($upload['name']) - strrpos($upload['name'], '.')));
        
        if ($upload['size'] > 1024) {
            
            if (preg_match('/(jpg|jpeg|png)/', $ext)) {
                
                list($width, $height) = getimagesize($upload['tmp_name']);

                    $original_file_name = $photo_dir . $gamename . '.' . $ext;
                    
                    if (move_uploaded_file($upload['tmp_name'], $original_file_name)) {

                        $original_file_name = '/' . $photo_dir . $gamename;

                        $get = array(
                            'extension' => $ext,
                            'name' => $name,
                            'url' => $original_file_name
                        );
                        
                        return $get;
                    }
                }
            }
    }
}

function uploadGameMediaCategory($upload, $categoryname) 
{
    if ($GLOBALS['access'] !== true) return false;
    
    global $GameMonetizeConnect;
    set_time_limit(0);
    
    if (!file_exists('cat/')) {
        mkdir('cat/', 0777, true);
    }
    
    $photo_dir = 'cat/';
    
    if (is_uploaded_file($upload['tmp_name'])) {
        $upload['name'] = secureEncode($upload['name']);
        $name = preg_replace('/([^A-Za-z0-9_\-\.]+)/i', '', $upload['name']);
        $ext = strtolower(substr($upload['name'], strrpos($upload['name'], '.') + 1, strlen($upload['name']) - strrpos($upload['name'], '.')));
        
        if ($upload['size'] > 1024) {
            
            if (preg_match('/(jpg|jpeg|png)/', $ext)) {
                
                list($width, $height) = getimagesize($upload['tmp_name']);

                    $original_file_name = $photo_dir . $categoryname . '.' . $ext;
                    
                    if (move_uploaded_file($upload['tmp_name'], $original_file_name)) {

                        $original_file_name = '/' . $photo_dir . $categoryname;

                        $get = array(
                            'extension' => $ext,
                            'name' => $name,
                            'url' => $original_file_name
                        );
                        
                        return $get;
                    }
                }
            }
    }
}


function processMedia($run, $photo_src, $save_src, $width=0, $height=0, $quality=80) 
{
    
    if (!is_numeric($quality) or $quality < 0 or $quality > 100) {
        $quality = 80;
    }

    if (file_exists($photo_src)) {
        
        if (strrpos($photo_src, '.')) {
            $ext = substr($photo_src, strrpos($photo_src,'.') + 1, strlen($photo_src) - strrpos($photo_src, '.'));
            $fxt = (!in_array($ext, array('jpeg', 'png'))) ? "jpeg" : $ext;
        } else {
            $ext = $fxt = 0;
        }
        
        if (preg_match('/(jpg|jpeg|png)/', $ext)) {
            list($photo_width, $photo_height) = getimagesize($photo_src);
            $create_from = "imagecreatefrom" . $fxt;
            $photo_source = $create_from($photo_src);
            
            if ($run == "crop") {
                
                if ($width > 0 && $height > 0) {
                    $crop_width = $photo_width;
                    $crop_height = $photo_height;
                    $k_w = 1;
                    $k_h = 1;
                    $dst_x = 0;
                    $dst_y = 0;
                    $src_x = 0;
                    $src_y = 0;
                    
                    if ($width == 0 or $width > $photo_width) {
                        $width = $photo_width;
                    }
                    
                    if ($height == 0 or $height > $photo_height) {
                        $height = $photo_height;
                    }
                    
                    $crop_width = $width;
                    $crop_height = $height;
                    
                    if ($crop_width > $photo_width) {
                        $dst_x = ($crop_width - $photo_width) / 2;
                    }
                    
                    if ($crop_height > $photo_height) {
                        $dst_y = ($crop_height - $photo_height) / 2;
                    }
                    
                    if ($crop_width < $photo_width || $crop_height < $photo_height) {
                        $k_w = $crop_width / $photo_width;
                        $k_h = $crop_height / $photo_height;
                        
                        if ($crop_height > $photo_height) {
                            $src_x  = ($photo_width - $crop_width) / 2;
                        } elseif ($crop_width > $photo_width) {
                            $src_y  = ($photo_height - $crop_height) / 2;
                        } else {
                            
                            if ($k_h > $k_w) {
                                $src_x = round(($photo_width - ($crop_width / $k_h)) / 2);
                            } else {
                                $src_y = round(($photo_height - ($crop_height / $k_w)) / 2);
                            }
                        }
                    }
                    
                    $crop_image = @imagecreatetruecolor($crop_width, $crop_height);
                    
                    if ($ext == "png") {
                        @imagesavealpha($crop_image, true);
                        @imagefill($crop_image, 0, 0, @imagecolorallocatealpha($crop_image, 0, 0, 0, 127));
                    }
                    
                    @imagecopyresampled($crop_image, $photo_source ,$dst_x, $dst_y, $src_x, $src_y, $crop_width - 2 * $dst_x, $crop_height - 2 * $dst_y, $photo_width - 2 * $src_x, $photo_height - 2 * $src_y);

                    @imageinterlace($crop_image, true);
                    @imagejpeg($crop_image, $save_src, $quality);
                    @imagedestroy($crop_image);
                }
            } elseif ($run == "resize") {
                
                if ($width == 0 && $height == 0) {
                    return false;
                }
                
                if ($width > 0 && $height == 0) {
                    $resize_width = $width;
                    $resize_ratio = $resize_width / $photo_width;
                    $resize_height = floor($photo_height * $resize_ratio);
                } elseif ($width == 0 && $height > 0) {
                    $resize_height = $height;
                    $resize_ratio = $resize_height / $photo_height;
                    $resize_width = floor($photo_width * $resize_ratio);
                } elseif ($width > 0 && $height > 0) {
                    $resize_width = $width;
                    $resize_height = $height;
                }
                
                if ($resize_width > 0 && $resize_height > 0) {
                    $resize_image = @imagecreatetruecolor($resize_width, $resize_height);
                    
                    if ($ext == "png") {
                        @imagesavealpha($resize_image, true);
                        @imagefill($resize_image, 0, 0, @imagecolorallocatealpha($resize_image, 0, 0, 0, 127));
                    }
                    
                    @imagecopyresampled($resize_image, $photo_source, 0, 0, 0, 0, $resize_width, $resize_height, $photo_width, $photo_height);

                    @imageinterlace($resize_image, true);
                    @imagejpeg($resize_image, $save_src, $quality);
                    @imagedestroy($resize_image);
                }
            } elseif ($run == "scale") {
                
                if ($width == 0) {
                    $width = 100;
                }
                
                if ($height == 0) {
                    $height = 100;
                }
                
                $scale_width = $photo_width * ($width / 100);
                $scale_height = $photo_height * ($height / 100);
                $scale_image = @imagecreatetruecolor($scale_width, $scale_height);
                
                if ($ext == "png") {
                    @imagesavealpha($scale_image, true);
                    @imagefill($scale_image, 0, 0, imagecolorallocatealpha($scale_image, 0, 0, 0, 127));
                }
                
                @imagecopyresampled($scale_image, $photo_source, 0, 0, 0, 0, $scale_width, $scale_height, $photo_width, $photo_height);

                @imageinterlace($scale_image, true);
                @imagejpeg($scale_image, $save_src, $quality);
                @imagedestroy($scale_image);
            }
        }
    }
} 


function generateKey($minlength=5, $maxlength=5, $uselower=true, $useupper=true, $usenumbers=true, $usespecial=false) 
{
    $charset = '';
    
    if ($uselower) {
        $charset .= "abcdefghijklmnopqrstuvwxyz";
    }
    
    if ($useupper) {
        $charset .= "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    }
    
    if ($usenumbers) {
        $charset .= "123456789";
    }
    
    if ($usespecial) {
        $charset .= "~@#$%^*()_+-={}|][";
    }
    
    if ($minlength > $maxlength) {
        $length = mt_rand($maxlength, $minlength);
    } else {
        $length = mt_rand($minlength, $maxlength);
    }
    
    $key = '';
    
    for ($i = 0; $i < $length; $i++) {
        $key .= $charset[(mt_rand(0, strlen($charset) - 1))];
    }
    
    return $key;
}

function dateState($date, $type=1) 
{
    $date_state = '';
    if ($type == 1) {
        $date_state = date("j/m/y", $date);
    }
    elseif ($type == 2) {
         $date_state = date("j/m/Y", $date);
    }
    elseif ($type == 3) {
         $date_state = date("j-m-y", $date);
    }
    elseif ($type == 4) {
         $date_state = date("j-m-Y", $date);
    }
    elseif ($type == 5) {
         $date_state = date("j/m/y g:i A", $date);
    }
    elseif ($type == 6) {
         $date_state = date("j/m/Y g:i A", $date);
    }
    elseif ($type == 7) {
         $date_state = date("j-m-y g:i A", $date);
    }
    elseif ($type == 8) {
         $date_state = date("j-m-Y g:i A", $date);
    }
    return $date_state;
}

function numberFormat($num) 
{
    $suffixes = array('', 'k', 'M', 'G', 'T');
        $suffixIndex = 0;
    
        while(abs($num) >= 1000 && $suffixIndex < sizeof($suffixes))
        {
            $suffixIndex++;
            $num /= 1000;
        }
    
        return (
            $num > 0
                ? floor($num * 1000) / 1000
                : ceil($num * 1000) / 1000
            )
            . $suffixes[$suffixIndex];
}


function listMenu($s1, $s2) 
{
    if ($s1 == $s2) {
        return 'active';
    } else {
        return false;
    }
}


function getADS($type='728x90') 
{
   global $GameMonetizeConnect, $config;

    $sql_query_ads = $GameMonetizeConnect->query("SELECT * FROM ".ADS."");
    
    if ($sql_query_ads->num_rows == true) {
        $ads_select = $sql_query_ads->fetch_array();
        if ($type == '728x90') {
            $ads_select['728x90'] = $ads_select['728x90'];
        } elseif ($type == '300x250') {
            $ads_select['300x250'] = $ads_select['300x250'];
        } elseif ($type == '600x300') {
          $ads_select['600x300'] = $ads_select['600x300'];
        } elseif ($type == '728x90_main') {
            $ads_select['728x90_main'] = $ads_select['728x90_main'];
        } elseif ($type == '300x250_main') {
            if(!empty($ads_select['300x250_main'])) {
                      $ads_select['300x250_main'] = '<div class="post post-trick" style="position: absolute; left: 0px; top: 0px;">
                <span class="ad-desc-left"><img src="' . $config['theme_path'] . '/image/bg_a728.png" alt=""></span>
                <div style="text-align:center;margin:0 auto;width:300px; height:250px;margin-top:9px;">
                '. $ads_select['300x250_main'] .'
                </div>
                <span class="ad-desc-right"><img src="' . $config['theme_path'] . '/image/bg_a728.png" alt=""></span>
            </div>';
            }
        } elseif ($type == 'ads_video') {
            $ads_select['ads_video'] = $ads_select['ads_video'];
        }

        return $ads_select[$type];
    } else {
        return false;
    }
}


function feedID($data, $str=4, $key='x1') 
{
    $pro1 = substr($data, -$str); # Select last $str digits
    $pro2 = $pro1.$key;
    return $pro2;
}


function searchGames($sch_query='') 
{
    global $GameMonetizeConnect;
    $q_result = array();
    
    if (!isset($sch_query) or empty($sch_query)) {
        return $q_result;
    }
    
    $sch_query = secureEncode($sch_query);

    $sql_query = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE name LIKE '%$sch_query%' AND published='1' ORDER BY name ASC");

    if ($sql_query->num_rows > 0) {
        while ($sql_fetch = $sql_query->fetch_array()) {
            $q_result[] = $sql_fetch;
        }
    }
    
    return $q_result;
}


function lastUser($type='logged', $limit=5) 
{
    global $GameMonetizeConnect;
    $q_lb_user = array();

    if ($type == 'logged') {
        $last_users_logged = $GameMonetizeConnect->query("SELECT avatar_id,name,username,id FROM ".ACCOUNTS." ORDER BY last_logged DESC LIMIT ".$limit);
        while ($last_user = $last_users_logged->fetch_array()) {
            $q_lb_user[] = $last_user;
        }
    } elseif ($type == 'registered') {
        $last_users_registered = $GameMonetizeConnect->query("SELECT avatar_id,name,username,id FROM ".ACCOUNTS." ORDER BY registration_date DESC LIMIT ".$limit);
        while ($last_user = $last_users_registered->fetch_array()) {
            $q_lb_user[] = $last_user;
        }
    }

    return $q_lb_user;
}


function getStats($type='games', $num_format=true) 
{
    global $GameMonetizeConnect;

    if ($type == 'games') {
        $stats_query = $GameMonetizeConnect->query("SELECT game_id FROM ".GAMES." WHERE game_id!=0");
    } elseif ($type == 'users') {
        $stats_query = $GameMonetizeConnect->query("SELECT id FROM ".ACCOUNTS." WHERE id!=0");
    } elseif ($type == 'categories') {
        $stats_query = $GameMonetizeConnect->query("SELECT id FROM ".CATEGORIES." WHERE id!=0");
    } elseif ($type == 'catalog_games') {
        $stats_query = $GameMonetizeConnect->query("SELECT id FROM ".CATALOG." WHERE id!=0");
    }

    if ($num_format) {
        return numberFormat($stats_query->num_rows);
    } else {
        return $stats_query->num_rows;
    }
}


function incCheck($array, $entry, $type='check') 
{
    foreach ($array as $c_array) {
        if ($type == 'check') {
            if (stripos(strtolower($entry), strtolower($c_array)) !== false) {
                return true;
            }
        }
        elseif ($type == 'scan') {
            if ($c_array == $entry) {
                return true;
            }
        }
    }
}


/**
* @since 2.0.1
*/

function untrailingslashit($string) 
{
    return rtrim( $string, '/\\' );
}


function trailingslashit($string) 
{
    return untrailingslashit( $string ) . '/';
}


function addon_path($file) 
{
    return trailingslashit( dirname($file) );
}


function td_installing($install_step=0) 
{
    if ($install_step == 1) {
        return ( file_exists( ABSPATH . 'assets/includes/config.php') ) ? true : false;
    } elseif ($install_step == 2) {
        return ( file_exists( ABSPATH . 'assets/includes/install-blank.php') ) ? true : false;
    } else {
        return ( file_exists( ABSPATH . 'assets/includes/config.php') && file_exists( ABSPATH . 'assets/includes/install-blank.php') ) ? true : false;
    }
}


function get_addons($type) 
{
    if (! isset($_SESSION['addons'][$type])) {
        return false;
    }

    $get = $_SESSION['addons'][$type];

    if ( !is_array($get) ) {
        return false;
    }

    return $get;
}


function addon() 
{
    $params = func_get_args();
    $countParams = func_num_args();
    $type = $params[0];
    $args = "";
    unset($params[0]);

    if (is_array ($type)) {
        $return_type = $type[1];

        if (isset ($type[2])) {
            if ($type[2] == "no_append") {
                $noAppend = true;
            }
        }

        $type = $type[0];
    }

    if ( isset($params[1]) ) {
        $args = $params[1];
    }

    if ($countParams > 2) {
        $args = $params[($countParams - 1)];
    }
        
    $get_addons = get_addons($type);

    if ( is_array($get_addons) ) {
        foreach ($get_addons as $name) {
            $adds = call_user_func_array($name, $params);

            if ( !empty($adds) ) {
                if ( $return_type == "string" ) {
                    if ( is_array($args) ) {
                        $args = "";
                    }

                    if (isset ($noAppend)) {
                        $args = "";
                    }
                        
                    $args .= $adds;
                }
                elseif ( $return_type == "array" ) {
                    $args = array_merge($args, $adds);
                }
                else {
                    return false;
                }
            }
        }
    }

    return $args;
}


function register_addon($type, $func) 
{
    $name = $func;
    $func_invalid = (preg_match('/[A-Za-z0-9_]/i', $name)) ? false : true;

    if ( isset($_SESSION['addons'][$type][$name]) ) {
        return false;
    }
        
    if ( !preg_match('/[A-Za-z0-9_]/i', $type) or $func_invalid) {
        return false;
    }

    $type = strtolower($type);
    $_SESSION['addons'][$type][$name] = $func;
}


function call_addon() 
{
    $args = func_get_args();
    $type = $args[0];
    $func = $args[1];
    unset($args[0], $args[1]);

    return call_user_func_array($func, $args);
}

function getFeaturedGames() 
{
    global $GameMonetizeConnect;
   
    $query_gm_topStar = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE featured='1' ORDER BY rand() LIMIT 5");
        if ($query_gm_topStar->num_rows != 0) {
            while ($topStar = $query_gm_topStar->fetch_array()) {
                $game_top = gameData($topStar);
                $game_get_source .= '<li class="adsmall" style="display:none"><a href="'.$game_top['game_url'].'">
               <div class="gameicon" style="background-image: url('.$game_top['image_url'].'); background-size: cover;border-radius: 3px;background-position-x: 50%;background-position-y: 30%;height: 100%;width:100%;background-repeat: no-repeat;"></div>
                </a></li>';
            }
        }
        return $game_get_source;
}

function getSidebarWidget($type='top-star') 
{
    global $GameMonetizeConnect, $themeData, $lang, $config;
    if ($type == 'top-star') {
        $query_gm_topStar = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE featured='1' ORDER BY rand() LIMIT 6");
        $top_star_list = '';
        if ($query_gm_topStar->num_rows != 0) {
            while ($topStar = $query_gm_topStar->fetch_array()) {
                $game_top = gameData($topStar);
                $themeData['widget_topstar_url'] = $game_top['game_url'];
                $themeData['widget_topstar_image'] = $game_top['image_url'];
                $themeData['widget_topstar_name'] = $game_top['name'];
                $themeData['widget_topstar_rating'] = $topStar['rating'];
                $top_star_list .= \GameMonetize\UI::view('game/sections/widget-each/top-stars-list');
            }
        } else {
            $top_star_list .= \GameMonetize\UI::view('game/sections/widget-each/top-stars-notfound');
        }
        $themeData['widget_sidebar_top_star_list'] = $top_star_list;
        return \GameMonetize\UI::view('game/sections/widget.top-stars');
    }

     elseif ($type == 'top-star2') {
        $query_gm_topStar = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE featured='1' ORDER BY rand() LIMIT 6");
        $top_star_list = '';
        if ($query_gm_topStar->num_rows != 0) {
            while ($topStar = $query_gm_topStar->fetch_array()) {
                $game_top = gameData($topStar);
                $themeData['widget_topstar_url'] = $game_top['game_url'];
                $themeData['widget_topstar_image'] = $game_top['image_url'];
                $themeData['widget_topstar_name'] = $game_top['name'];
                $themeData['widget_topstar_rating'] = $topStar['rating'];
                $top_star_list .= \GameMonetize\UI::view('game/sections/widget-each/top-stars-list');
            }
        } else {
            $top_star_list .= \GameMonetize\UI::view('game/sections/widget-each/top-stars-notfound');
        }
        $themeData['widget_sidebar_top_star_list'] = $top_star_list;
        return \GameMonetize\UI::view('game/sections/widget.top-stars');
    }

    elseif ($type == 'top-user') {

        $query_gm_topStar = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE published='1' ORDER BY rand() LIMIT 17");
        $top_users_list = '';
        if ($query_gm_topStar->num_rows != 0) {
            while ($topStar = $query_gm_topStar->fetch_array()) {
                $game_top = gameData($topStar);
                $themeData['widget_topstar_url'] = $game_top['game_url'];
                $themeData['widget_topstar_image'] = $game_top['image_url'];
                $themeData['widget_topstar_name'] = $game_top['name'];
                $themeData['widget_topstar_rating'] = $topStar['rating'];
                $top_users_list .= \GameMonetize\UI::view('game/sections/widget-each/top-users-list');
            }
        } else {
            $top_users_list .= \GameMonetize\UI::view('game/sections/widget-each/top-stars-notfound');
        }
        $themeData['widget_sidebar_top_users_list'] = $top_users_list;
        return \GameMonetize\UI::view('game/sections/widget.top-users');
    }

    elseif ($type == 'random') {
        $query_gm_Random = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE published='1' ORDER BY featured, rand() desc LIMIT 30");
        $random_games_list = '';
        if ($query_gm_Random->num_rows != 0) {
            while ($gRandom = $query_gm_Random->fetch_array()) {
                $gmRandom = gameData($gRandom);
                $themeData['random_game_url'] = $gmRandom['game_url'];
                $themeData['random_game_image'] = $gmRandom['image_url'];
                $themeData['random_game_name'] = $gmRandom['name'];
                $themeData['random_game_rating'] = $gRandom['rating'];
                $random_games_list .= \GameMonetize\UI::view('game/sections/widget-each/random-games-list');
            }
        } else {
            $random_games_list .= \GameMonetize\UI::view('game/sections/widget-each/random-games-notfound');
        }

        $themeData['widget_sidebar_random_list'] = $random_games_list;
        return \GameMonetize\UI::view('game/sections/widget.random-games');
    }
}


function getCarouselWidget($type='carousel_random_games', $items=2) 
{
    global $GameMonetizeConnect, $themeData, $userData, $lang, $config;

    switch ( $type ) {
        case 'carousel_random_games':
            $query_gm_Random = $GameMonetizeConnect->query("SELECT * FROM ".GAMES." WHERE published='1' ORDER BY rand() LIMIT 20");
            $carousel_random_games_list = '';
            if ($query_gm_Random->num_rows > 0) {
                while ($gRandom = $query_gm_Random->fetch_array()) {
                    $gmRandom = gameData($gRandom);
                    $themeData['random_game_url'] = $gmRandom['game_url'];
                    $themeData['random_game_image'] = $gmRandom['image_url'];
                    $themeData['random_game_name'] = $gmRandom['name'];
                    $themeData['random_game_rating'] = $gRandom['rating'];
                    $carousel_random_games_list .= \GameMonetize\UI::view('widgets/carousel-random-games/item');
                }
            } else {
                $carousel_random_games_list .= '';
            }
            $themeData['carousel_random_games_items'] = $items;
            $themeData['carousel_random_list'] = $carousel_random_games_list;
            // return \GameMonetize\UI::view('widgets/carousel-random-games/container');
        break;

    }
}


function db_array_install($site_url, $site_title, $admin_user, $admin_password, $admin_email) 
{
    $db = array();

    $db[0] = "CREATE TABLE IF NOT EXISTS `gm_account` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `name` text COLLATE utf8_unicode_ci NOT NULL,
                `username` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `password` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `admin` enum('0','1') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
                `email` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `avatar_id` int(11) NOT NULL,
                `xp` int(11) NOT NULL,
                `language` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `profile_theme` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'style-1',
                `ip` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `registration_date` int(11) NOT NULL,
                `last_logged` int(11) NOT NULL,
                `last_update_info` int(11) NOT NULL,
                `active` enum('1','0') COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (`id`) 
            ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[1] = "INSERT INTO `gm_account` (`id`, `name`, `username`, `password`, `admin`, `email`, `xp`, `language`, `profile_theme`, `ip`, `registration_date`, `active`) VALUES (1, 'Administrator', '{$admin_user}', '{$admin_password}', '1', 'admin@admin.com', 0, 'english', 'style-1', '::0', 1478417322, '1')";
    # >>
    $db[2] = "CREATE TABLE IF NOT EXISTS `gm_users` (
                `user_id` int(11) NOT NULL,
                `gender` enum('1','2') CHARACTER SET utf8 NOT NULL DEFAULT '1',
                `about` text COLLATE utf8_unicode_ci NOT NULL,
                UNIQUE KEY `user_id` (`user_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[3] = "INSERT INTO `gm_users` (`user_id`, `gender`) VALUES (1, '1')";
    # >>
    $db[4] = "CREATE TABLE IF NOT EXISTS `gm_ads` (
                `id` int(11) NOT NULL,
                `728x90` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                `300x250` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                `600x300` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                `728x90_main` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                `300x250_main` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                `ads_video` varchar(700) COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[5] = "INSERT INTO `gm_ads` (`id`, `728x90`, `300x250`, `600x300`, `728x90_main`, `300x250_main`, `ads_video`) VALUES (1, '', '', '', '', '', '')";
    # >>
    $db[6] = "CREATE TABLE IF NOT EXISTS `gm_categories` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `category_pilot` varchar(250) CHARACTER SET utf8 NOT NULL,
                `name` text COLLATE utf8_unicode_ci NOT NULL,
                `image` varchar(400) COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[7] = "INSERT INTO `gm_categories` (`id`, `category_pilot`, `name`, `image`) VALUES
(1, 'action-games', 'Action Games', '/cat/action-games.jpg'),
(2, 'racing-games', 'Racing Games', '/cat/racing-games.png'),
(3, 'shooting-games', 'Shooting Games', '/cat/shooting-games.jpg'),
(4, 'arcade-games', 'Arcade Games', '/cat/arcade-games.jpg'),
(5, 'puzzle-games', 'Puzzle Games', '/cat/puzzle-games.jpg'),
(6, 'strategy-games', 'Strategy Games', '/cat/strategy-games.png'),
(7, 'multiplayer-games', 'Multiplayer Games', '/cat/multiplayer-games.jpg'),
(8, 'sports-games', 'Sports Games', '/cat/sports-games.png'),
(9, 'fighting-games', 'Fighting Games', '/cat/fighting-games.png');";
    # >>
    $db[10] = "CREATE TABLE IF NOT EXISTS `gm_games` (
                `game_id` int(11) NOT NULL AUTO_INCREMENT,
                `catalog_id` varchar(250) CHARACTER SET latin1 NOT NULL,
                `game_name` varchar(250) CHARACTER SET latin1 NOT NULL,
                `name` varchar(250) COLLATE latin1_swedish_ci NOT NULL,
                `image` varchar(500) COLLATE latin1_swedish_ci NOT NULL,
                `import` enum('0','1') COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
                `category` int(11) NOT NULL,
                `plays` int(11) NOT NULL,
                `rating` enum('0','0.5','1','1.5','2','2.5','3','3.5','4','4.5','5') COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
                `description` varchar(5000) COLLATE latin1_swedish_ci NOT NULL,
                `instructions` varchar(600) COLLATE latin1_swedish_ci NOT NULL,
                `file` varchar(500) COLLATE latin1_swedish_ci NOT NULL,
                `game_type` varchar(250) COLLATE latin1_swedish_ci NOT NULL,
                `w` int(10) NOT NULL,
                `h` int(10) NOT NULL,
                `date_added` int(11) NOT NULL,
                `published` enum('0','1') COLLATE latin1_swedish_ci NOT NULL,
                `featured` enum('0','1') COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
                `mobile` int(255) NOT NULL,
                `featured_sorting` varchar(255) NOT NULL,
                `field_1` varchar(500) NOT NULL,
                `field_2` varchar(500) NOT NULL,
                `field_3` varchar(500) NOT NULL,
                `field_4` varchar(500) NOT NULL,
                `field_5` varchar(500) NOT NULL,
                `field_6` varchar(500) NOT NULL,
                `field_7` varchar(500) NOT NULL,
                `field_8` varchar(500) NOT NULL,
                `field_9` varchar(500) NOT NULL,
                `field_10` varchar(500) NOT NULL,
                PRIMARY KEY (`game_id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci";

    # >>
    $db[16] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1, 'gamemonetize-1447', 'pizza-ninja-mania', 'Pizza Ninja Mania', 'https://img.gamemonetize.com/a5687ulj1xahqiaiy04cudesyul5jmxt/512x384.jpg', '0', 0, 0, '0', 'Pizza ingredients juggling through the air, ninja slicing skills needed! Customers need to be served quickly and also love to see the entertainment. So grab a knife and do your job! Play in each game mode and be the best! Also new types of bonuses await!', '', 'https://html5.gamemonetize.com/a5687ulj1xahqiaiy04cudesyul5jmxt/', 'html5', 600, 800, 1576076683, '1', '0'),
(2, 'gamemonetize-1446', 'wrestle-online', 'Wrestle Online', 'https://img.gamemonetize.com/dqa5wkouob7ff5gqs387s3ua4lnjdkiq/512x384.jpg', '0', 0, 12, '0', 'Jump up as you try to knock your opponent out. Play single player mode, two player mode or online multiplayer mode. Collect coins to unlock new skins in this fun multiplayer game.', '', 'https://html5.gamemonetize.com/dqa5wkouob7ff5gqs387s3ua4lnjdkiq/', 'html5', 800, 600, 1576076683, '1', '0'),
(3, 'gamemonetize-1445', 'town-bus-driver', 'Town Bus Driver', 'https://img.gamemonetize.com/sgs955s7l9l3afnvbeksmihkfa8ry75q/512x384.jpg', '0', 2, 1, '0', 'The hardest part of driving and learning how to drive is mastering how to park without scratching or denting your new car. Town Driver allow you to drive around the parking lot simulating new life skills required for a car safety in the correct spot. Will you be able to park all the cars without leaving a scratch?', '', 'https://html5.gamemonetize.com/sgs955s7l9l3afnvbeksmihkfa8ry75q/', 'html5', 800, 600, 1576076683, '1', '0'),
(4, 'gamemonetize-1444', '3d-billiard-8-ball-pool', '3d Billiard 8 ball Pool', 'https://img.gamemonetize.com/jf2a06o1z5ezy7stb7c4lmm13syg12yk/512x384.jpg', '0', 8, 1, '0', 'Famous variety of billiards. The goal of the game is to score all the balls of one group (either “striped” or “solid”) after robbery, and at the end to score the ball with the number 8. Whoever does this, he becomes the winner of the game.', '', 'https://html5.gamemonetize.com/jf2a06o1z5ezy7stb7c4lmm13syg12yk/', 'html5', 800, 600, 1576076683, '1', '0'),
(5, 'gamemonetize-1443', 'my-perfect-bride-wedding-dress-up', 'My Perfect Bride Wedding Dress Up', 'https://img.gamemonetize.com/o9k6h9fskjgvyqfbenqu8lhrgf9s9egy/512x384.jpg', '0', 1, 1, '0', 'It&#039;s your big day, so why settle for looking good when you can look perfect? Getting married is a special occasion, and the bride needs to look and feel beautiful. In this dress-up game, click through the hair, accessory, and make-up options to get the perfect look for this blushing bride&#039;s wedding day.', '', 'https://html5.gamemonetize.com/o9k6h9fskjgvyqfbenqu8lhrgf9s9egy/', 'html5', 500, 750, 1576076683, '1', '0'),
(6, 'gamemonetize-1442', 'prom-queen-dress-up-high-school', 'Prom Queen Dress Up High School', 'https://img.gamemonetize.com/f8x3crntylr78dyr70ja18m9ia9kiixy/512x384.jpg', '0', 1, 1, '0', 'Choose beautiful outfits, fashionable dresses and stylish hairstyles for high school girls who are soon graduating from school. In September, the girls plan to go on to College, Institute or University. But now may, school ends, the graduation party is approaching, and the most important question is what to wear fashionable, modern, elegant for the holiday?', '', 'https://html5.gamemonetize.com/f8x3crntylr78dyr70ja18m9ia9kiixy/', 'html5', 450, 750, 1576076683, '1', '0'),
(7, 'gamemonetize-1441', 'block-puzzle-star', 'Block Puzzle Star', 'https://img.gamemonetize.com/ai2f44hil8mf7u5b8411dm83s1dyfhbp/512x384.jpg', '0', 5, 0, '0', 'Click on 3 or more connected stars of the same color to eliminate the stars and get a star bomb under certain conditions.', '', 'https://html5.gamemonetize.com/ai2f44hil8mf7u5b8411dm83s1dyfhbp/', 'html5', 640, 960, 1576076683, '1', '0'),
(8, 'gamemonetize-1440', 'ace-plane-decisive-battle', 'Ace plane decisive battle', 'https://img.gamemonetize.com/a1i2o00hl13xeegd3vli22mm5sk7gqfq/512x384.jpg', '0', 5, 0, '0', 'Control your fighter, dodge local attacks, survive, and get high scores', '', 'https://html5.gamemonetize.com/a1i2o00hl13xeegd3vli22mm5sk7gqfq/', 'html5', 320, 480, 1576076683, '1', '0'),
(9, 'gamemonetize-1439', 'dream-dolly-designer', 'Dream Dolly Designer', 'https://img.gamemonetize.com/38goragog2ic0szndwi6vqld9bbmjyin/512x384.jpg', '0', 1, 0, '0', 'Do you girls like playing with dolls? What if you could have as many dolls as you wish and take them everywhere with you? All you need to do is get Dream Dolly Designer - Doll Game right away! Create your dream dolls in one of the most wonderful games for girls! You can customize every detail of your doll, from facial features, to hair, makeup, outfit and even the packaging box! Get the fun started in a realistic and fun doll creator game.', '', 'https://html5.gamemonetize.com/38goragog2ic0szndwi6vqld9bbmjyin/', 'html5', 500, 750, 1576076683, '1', '0'),
(10, 'gamemonetize-1438', 'dress-up-wheel', 'Dress Up Wheel', 'https://img.gamemonetize.com/80fcgr157d60gyw59udrfjgjll0gtli2/512x384.jpg', '0', 1, 0, '0', 'Girls, are you ready to see how lucky you are? Join Mira in one of the most amazing dress up games and find out what the wheel has prepared for you. Prove your fashion skills and test your luck! Which fashion style do you hope to unlock first? Spin the dress up wheel and let it guide you through 4 different styles: retro, classy, rockstar and school style. Mira can&#039;t wait to see what clothes you&#039;ll get. You will have a great time creating stylish outfits for our sweet fashionista!', '', 'https://html5.gamemonetize.com/80fcgr157d60gyw59udrfjgjll0gtli2/', 'html5', 500, 750, 1576076683, '1', '0'),
(11, 'gamemonetize-1437', 'barber-cut', 'Barber Cut', 'https://img.gamemonetize.com/x7h07vpri80xenqa2bctdihg0m3280s5/512x384.jpg', '0', 4, 0, '0', 'Barber Cut Brand new Satisfying Game with Hair Cut , Just Swipe Your Trimmer cut the Hair in shop of the Barber , Play role of Barber and Earn the Money have fun with Customers Hair Styles .', '', 'https://html5.gamemonetize.com/x7h07vpri80xenqa2bctdihg0m3280s5/', 'html5', 450, 750, 1576076683, '1', '0'),
(12, 'gamemonetize-1436', 'life-and-death-ninja', 'Life and death ninja', 'https://img.gamemonetize.com/ztmb2o2xmo3lzjh7igpo8yq2ixuso25n/512x384.jpg', '0', 4, 0, '0', 'Mouse control lets the ninja climb up, avoid the traps and see how many points you can get', '', 'https://html5.gamemonetize.com/ztmb2o2xmo3lzjh7igpo8yq2ixuso25n/', 'html5', 624, 1040, 1576076683, '1', '0'),
(13, 'gamemonetize-1435', 'the-impossible-dash', 'The Impossible Dash', 'https://img.gamemonetize.com/0nymmbejllbo5qewsrvbly2xp4fujglj/512x384.jpg', '0', 4, 0, '0', 'The Impossible Dash is a click-moving game, the game has 7 levels with different obstacles, you need to click to move so as not to collide with obstacles. This is a funny game and lively sound. Wish you happy.', '', 'https://html5.gamemonetize.com/0nymmbejllbo5qewsrvbly2xp4fujglj/', 'html5', 800, 600, 1576076683, '1', '0'),
(14, 'gamemonetize-1434', 'lovely-christmas-slide', 'Lovely Christmas Slide', 'https://img.gamemonetize.com/c842twvnn3212ajjspzldmr827ttldlx/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of lovely christmas. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/c842twvnn3212ajjspzldmr827ttldlx/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(15, 'gamemonetize-1433', 'christmas-mahjong-2019', 'Christmas Mahjong 2019', 'https://img.gamemonetize.com/pzvy1xjicqi1hz1uzgn2p34w5pczrc3g/512x384.jpg', '0', 5, 0, '0', 'Combine 2 of the same christmas mahjong tiles to remove them from the board. You only can use free tiles. A free tile is not covered by another stone and at least 1 side (left or right) is open.You have 25 levels to challenge in this mahjong games. You can play this mahjong game as many times as you like (with different challenge).', '', 'https://html5.gamemonetize.com/pzvy1xjicqi1hz1uzgn2p34w5pczrc3g/', 'html5', 800, 480, 1576076683, '1', '0'),
(16, 'gamemonetize-1432', 'santa-gift-race', 'Santa Gift Race', 'https://img.gamemonetize.com/818wk1cler26dq7rpyomlp6w0qn17mtf/512x384.jpg', '0', 2, 0, '0', 'In this Christmas game, Santa is on his way to collect presents. But this time he is with his motorbike. Your job is to control the bike and to collect more gifts as you can, so you will make more children happy this year.', '', 'https://html5.gamemonetize.com/818wk1cler26dq7rpyomlp6w0qn17mtf/', 'html5', 860, 480, 1576076683, '1', '0'),
(17, 'gamemonetize-1431', 'christmas-trend-2019-riding-boots', 'Christmas Trend 2019 Riding Boots', 'https://img.gamemonetize.com/noe53u362f9xwqgkd59uyhijr53fbt6y/512x384.jpg', '0', 1, 0, '0', 'Eliza and Tiara are famous fashionistas among princesses. They always want to be in trend! This year, Christmas riding boots are incredibly popular, combined with long sweaters and short dresses or skirts. It is ideal for strolling through the Christmas streets. Complement your look with a cozy scarf, cute hat or fur headphones. Do not forget to grab a clutch. Let&#039;s enjoy the holiday in style!', '', 'https://html5.gamemonetize.com/noe53u362f9xwqgkd59uyhijr53fbt6y/', 'html5', 800, 600, 1576076683, '1', '0'),
(18, 'gamemonetize-1430', 'zombies-night-2', 'Zombies Night 2', 'https://img.gamemonetize.com/7xc6769oze1twzvd46paczg8pe2sc53j/512x384.jpg', '0', 3, 0, '0', 'Zombies Night is a first person shooting game. This is a second part of this shooting game. In the dark night zombies come out and attack city. Your mission is to protect the city and kill all zombies. Use mouse to shoot and aim, R for reload, G for grenade and 1-6 number to change weapons. Enjoy!', '', 'https://html5.gamemonetize.com/7xc6769oze1twzvd46paczg8pe2sc53j/', 'html5', 1280, 720, 1576076683, '1', '0'),
(19, 'gamemonetize-1429', 'fz-foosball', 'FZ FoosBall', 'https://img.gamemonetize.com/eywam29gwpkday25nufp9z26ftfos0j6/512x384.jpg', '0', 8, 0, '0', 'FZ FoosBall - HTML5 games. use your skill to play game. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/eywam29gwpkday25nufp9z26ftfos0j6/', 'html5', 800, 600, 1576076683, '1', '0'),
(20, 'gamemonetize-1428', 'baby-sisters-christmas-day', 'Baby Sisters Christmas Day', 'https://img.gamemonetize.com/0zpwi6orqxxmon1h8rthxonvm300vkpw/512x384.jpg', '0', 1, 0, '0', 'The baby sisters Bella and Mia are planning their Christmas party. Give them ideas for their outlook and party hall decoration. Wish them happy Christmas!', '', 'https://html5.gamemonetize.com/0zpwi6orqxxmon1h8rthxonvm300vkpw/', 'html5', 800, 600, 1576076683, '1', '0'),
(21, 'gamemonetize-1427', 'infinity-battlefield-ops', 'Infinity Battlefield Ops', 'https://img.gamemonetize.com/rko2tmgf6e58yquufwod2nwxg7cfzk4r/512x384.jpg', '0', 3, 0, '0', 'It’s time to take an action in the battlefield as an army commando and experience the best FPS shooting adventure. Shoot to kill in special ops with different army guns and survive in this survival action. You need to develop the strategy against enemies then you will be able to win the sniper ops commando shooter game.', '', 'https://html5.gamemonetize.com/rko2tmgf6e58yquufwod2nwxg7cfzk4r/', 'html5', 960, 640, 1576076683, '1', '0'),
(22, 'gamemonetize-1426', 'clash-of-blocks', 'Clash of Blocks', 'https://img.gamemonetize.com/l7bzeu9rnblbms80475ptxw9jgv2usgg/512x384.jpg', '0', 5, 0, '0', 'In Clash of Blocks 2, your job is to strategically place your own block so that it rolls out faster than your opponents. Your goal is to win majority of the board, to have your color take up the majority of the board! Can you get a 60% majority? Or 70%? Or 80%? Or even over 90%?', '', 'https://html5.gamemonetize.com/l7bzeu9rnblbms80475ptxw9jgv2usgg/', 'html5', 500, 750, 1576076683, '1', '0'),
(23, 'gamemonetize-1425', 'cinderella-dress-up', 'Cinderella Dress Up', 'https://img.gamemonetize.com/eftk5uktx50nzz6xbl8y521h91tfz4ie/512x384.jpg', '0', 1, 0, '0', 'Cinderella goes to the ball, where she will meet a handsome Prince. Before such an important event, Princess Cinderella needs to be brought to a beauty salon and dressed together with other princesses, fairies and brides. How else can girls develop a sense of style and the ability to dress fashionably and stylishly as not through dress-up games for girls, where princesses, fairies and brides are just waiting for young fashion lovers to start dressing and dressing them in the most beautiful.', '', 'https://html5.gamemonetize.com/eftk5uktx50nzz6xbl8y521h91tfz4ie/', 'html5', 450, 750, 1576076683, '1', '0'),
(24, 'gamemonetize-1424', 'ludo-online-xmas', 'Ludo Online Xmas', 'https://img.gamemonetize.com/5bhq6b55mpkspxnmjjbsi213ig3ie3lj/512x384.jpg', '0', 7, 0, '0', 'Have fun with friends during Christmas holidays by playing Ludo Online Xmas game. The game has 3 modes: - Vs Bot: Playing against the computer (offline) - Online: Playing with randomly matched people - Private: Playing with your friends, simply share a private code and connect to each other. Merry Christmas! Play now!', '', 'https://html5.gamemonetize.com/5bhq6b55mpkspxnmjjbsi213ig3ie3lj/', 'html5', 960, 640, 1576076683, '1', '0'),
(25, 'gamemonetize-1423', 'christmas-2019-puzzle', 'Christmas 2019 Puzzle', 'https://img.gamemonetize.com/cv8zdbnow24gwnm7t7lvqdsw4xsnp182/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Christmas 2019 Puzzle. All images is with the christmas 2019. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/cv8zdbnow24gwnm7t7lvqdsw4xsnp182/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(26, 'gamemonetize-1422', 'captain-of-the-sea-difference', 'Captain Of The Sea Difference', 'https://img.gamemonetize.com/jtldja08kzzunv6e9sjzx2i58yu9d0nx/512x384.jpg', '0', 5, 0, '0', 'Captain of the Sea Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/jtldja08kzzunv6e9sjzx2i58yu9d0nx/', 'html5', 1280, 720, 1576076683, '1', '0'),
(27, 'gamemonetize-1421', 'santa-gravity-run', 'Santa Gravity Run', 'https://img.gamemonetize.com/33mfamh63m7g1cr8rtq4b59ltp6s1hz5/512x384.jpg', '0', 4, 0, '0', 'Switch the gravity to control your Santa to avoid the obstacles and reach the door. 12 levels to go. Play now!', '', 'https://html5.gamemonetize.com/33mfamh63m7g1cr8rtq4b59ltp6s1hz5/', 'html5', 1280, 720, 1576076683, '1', '0'),
(28, 'gamemonetize-1420', 'yamaha-2020-slide', 'Yamaha 2020 Slide', 'https://img.gamemonetize.com/58o2tshpk5iraa6jm4mr876u2lnnitsn/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of yamaha 2020. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/58o2tshpk5iraa6jm4mr876u2lnnitsn/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(29, 'gamemonetize-1419', 'christmas-carols-jigsaw', 'Christmas Carols Jigsaw', 'https://img.gamemonetize.com/kbij7josr9vq4ddrl5e8c3ahv0uym9a7/512x384.jpg', '0', 5, 0, '0', 'Christmas Carols Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/kbij7josr9vq4ddrl5e8c3ahv0uym9a7/', 'html5', 1280, 720, 1576076683, '1', '0'),
(30, 'gamemonetize-1418', 'winter-dash', 'Winter Dash', 'https://img.gamemonetize.com/4oouuhdnkfvcfxvhzm99gy8gcbysoh9s/512x384.jpg', '0', 1, 0, '0', 'Winter Dash is an online Arcade game that you can play for free. This game is suitable for all ages. Your objective is to jump and fly through all obstacles, collect as many gifts as possible and hit its finish line. Shop new characters when collecting a gifts. Have fun playing.', '', 'https://html5.gamemonetize.com/4oouuhdnkfvcfxvhzm99gy8gcbysoh9s/', 'html5', 854, 480, 1576076683, '1', '0'),
(31, 'gamemonetize-1417', 'basketball-run-shots', 'Basketball Run Shots', 'https://img.gamemonetize.com/o8ue9c4a48q55d71rz9ml9dc97hq970x/512x384.jpg', '0', 8, 0, '0', 'Ready to shoot some hoops? Grab a ball and start dunking! Dunk Shot Runner is a burning hot arcade game that anybody can enjoy! Shoot the hoops and become the next basketball star!', '', 'https://html5.gamemonetize.com/o8ue9c4a48q55d71rz9ml9dc97hq970x/', 'html5', 600, 800, 1576076683, '1', '0'),
(32, 'gamemonetize-1416', 'bump-io', 'Bump.io', 'https://img.gamemonetize.com/6ei41d81g4bj7alkgvudj88fvws7y5n4/512x384.jpg', '0', 8, 0, '0', 'There are 16 cars are involved in competition.you must avoid collisions with monsters and boundaries for win.Impact vehicles get energy and Kill vehicles to get volume growth.', '', 'https://html5.gamemonetize.com/6ei41d81g4bj7alkgvudj88fvws7y5n4/', 'html5', 800, 600, 1576076683, '1', '1'),
(33, 'gamemonetize-1415', 'cool-arabian-princess-dress-up', 'Cool Arabian Princess Dress Up', 'https://img.gamemonetize.com/8boiygm44nmvzm0yjcrx55hx2xfzxnf5/512x384.jpg', '0', 1, 0, '0', '&quot;Arabian Princess Dress Up&quot; is a new dress up game about fashion and princesses for girls who like Arab and Oriental culture, Oriental style in clothes, Arabic language, Arabic dances and dress up games. You have the opportunity to plunge into the world of Arab princesses and see the modern Arabic style!', '', 'https://html5.gamemonetize.com/8boiygm44nmvzm0yjcrx55hx2xfzxnf5/', 'html5', 450, 750, 1576076683, '1', '0'),
(34, 'gamemonetize-1414', 'wedding-dress-up-bride', 'Wedding Dress Up Bride', 'https://img.gamemonetize.com/1rdznpve37h4due1m33b1pwxsgjwzjs1/512x384.jpg', '0', 1, 0, '0', 'Princesses today are very happy, because they are brides and today they have a wedding! Each of the princesses will marry a handsome Prince! Dress up 4 princesses for the wedding! Every bride has dreamed of a wedding for so long, and finally this important day for every girl has come. They go to the wedding salon!', '', 'https://html5.gamemonetize.com/1rdznpve37h4due1m33b1pwxsgjwzjs1/', 'html5', 450, 750, 1576076683, '1', '0'),
(35, 'gamemonetize-1413', 'breadvation', 'Breadvation', 'https://img.gamemonetize.com/utcplbg1qtze0dso3xjsrvhyq8917py2/512x384.jpg', '0', 4, 0, '0', 'Dodge breads as you can, in a environment that is harder at the time pass. Beats your highscore!', '', 'https://html5.gamemonetize.com/utcplbg1qtze0dso3xjsrvhyq8917py2/', 'html5', 1024, 576, 1576076683, '1', '0'),
(36, 'gamemonetize-1412', 'cinderella-prince-charming', 'Cinderella Prince Charming', 'https://img.gamemonetize.com/3w4y0vezv5uvloj176sh0i5fuzuefomi/512x384.jpg', '0', 1, 0, '0', 'In this new game for girls you can dress both Princess Cinderella (bride) and Prince (groom), on one screen. Tomorrow they have a wedding, so you need to pick up for the bride and groom beautiful wedding dresses!', '', 'https://html5.gamemonetize.com/3w4y0vezv5uvloj176sh0i5fuzuefomi/', 'html5', 450, 750, 1576076683, '1', '0'),
(37, 'gamemonetize-1411', 'fashion-show-dress-up', 'Fashion Show Dress Up', 'https://img.gamemonetize.com/2khl7gxuphuouf2etvkkeppw61yms6rv/512x384.jpg', '0', 1, 0, '0', 'If you are a real fashionista and dream of becoming a supermodel to walk on the red carpet and show designer clothes. Imagine that you are a super star, supermodel and celebrity, and dressed in stylish, super-fashionable, chic outfits! Try to dress the girls fashionistas in the best, most stylish dresses and outfits and choose them the most fun hairstyles.', '', 'https://html5.gamemonetize.com/2khl7gxuphuouf2etvkkeppw61yms6rv/', 'html5', 450, 750, 1576076683, '1', '0'),
(38, 'gamemonetize-1410', 'rope-help', 'Rope Help', 'https://img.gamemonetize.com/ynw1br6gk2kx7g7u6r6wdobueft7yvgw/512x384.jpg', '0', 4, 0, '0', 'Help all stickmen from a big fire by the rope. Control the rope, overcome the obstacles, complete challenging and unique puzzle.', '', 'https://html5.gamemonetize.com/ynw1br6gk2kx7g7u6r6wdobueft7yvgw/', 'html5', 800, 600, 1576076683, '1', '0'),
(39, 'gamemonetize-1409', 'push-balls', 'Push Balls', 'https://img.gamemonetize.com/b094h08bmyrta82r5j5oasdpi0hlk3tw/512x384.jpg', '0', 5, 0, '0', 'Push Balls is actually a ball puzzle game with 3D blocks and platforms. There are always some special towers that could launch the limited pointed quantity of balls to fill up the holes on the block platforms.', '', 'https://html5.gamemonetize.com/b094h08bmyrta82r5j5oasdpi0hlk3tw/', 'html5', 450, 750, 1576076683, '1', '0'),
(40, 'gamemonetize-1408', 'ferrari-812-gts-puzzle', 'Ferrari 812 GTS Puzzle', 'https://img.gamemonetize.com/fxg954197o3dc437nl4tja96312v9wkp/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Ferrari 812 GTS. All images is with the ferrari 812 gts. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/fxg954197o3dc437nl4tja96312v9wkp/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(41, 'gamemonetize-1407', 'lol-surprise-dolls-dress-up', 'LOL Surprise Dolls Dress Up', 'https://img.gamemonetize.com/g74bxlu63a262xpftguqe9j1xnghiuuz/512x384.jpg', '0', 1, 0, '0', 'Do you like makeup and dress up doll eggs surprise? Then this game for you. Many people like lol our dolls surprise. Dress up them and have fun!', '', 'https://html5.gamemonetize.com/g74bxlu63a262xpftguqe9j1xnghiuuz/', 'html5', 500, 750, 1576076683, '1', '0'),
(42, 'gamemonetize-1406', 'fun-rope-unroll', 'Fun Rope Unroll', 'https://img.gamemonetize.com/kkivkd8lhwhn8a823lrst6nj8p492i7m/512x384.jpg', '0', 5, 0, '0', 'Just Swipe to Unroll the Rope and Unlock the Beautiful Object Have Fun.', '', 'https://html5.gamemonetize.com/kkivkd8lhwhn8a823lrst6nj8p492i7m/', 'html5', 450, 750, 1576076683, '1', '0'),
(43, 'gamemonetize-1405', 'christmas-survival-fps', 'Christmas Survival FPS', 'https://img.gamemonetize.com/v31w25ovnkbpk1yfh62dbwrfl3066q21/512x384.jpg', '0', 3, 0, '0', 'Features • Christmas theme • Multiplayer or single-player gameplay • Multiple game modes • In-game weapons and armor shop', '', 'https://html5.gamemonetize.com/v31w25ovnkbpk1yfh62dbwrfl3066q21/', 'html5', 960, 600, 1576076683, '1', '0'),
(44, 'gamemonetize-1404', 'cube-shift', 'Cube Shift', 'https://img.gamemonetize.com/4lvl5h8xn4j9657o4t9vi9pp56dqy2e3/512x384.jpg', '0', 8, 0, '0', 'Change the cube&#039;s shape to pass the obstacles.', '', 'https://html5.gamemonetize.com/4lvl5h8xn4j9657o4t9vi9pp56dqy2e3/', 'html5', 600, 800, 1576076683, '1', '0'),
(45, 'gamemonetize-1403', 'push-block', 'Push Block', 'https://img.gamemonetize.com/u163ydpy6twyemqucqitdwdrnvv0reql/512x384.jpg', '0', 4, 0, '0', 'Now use you finger push all the blocks to destination!Be careful about the obstacles on the road!', '', 'https://html5.gamemonetize.com/u163ydpy6twyemqucqitdwdrnvv0reql/', 'html5', 800, 600, 1576076683, '1', '0'),
(46, 'gamemonetize-1402', 'gun-master', 'Gun Master', 'https://img.gamemonetize.com/pwdegq61brqa7sf4a99entemxkoxzt1o/512x384.jpg', '0', 3, 0, '0', 'Help our hero to kill all his enemies. You can get different guns from different ways, the only thing you need to do is aim at the bad guys and shoot them! Have fun!', '', 'https://html5.gamemonetize.com/pwdegq61brqa7sf4a99entemxkoxzt1o/', 'html5', 800, 600, 1576076683, '1', '0'),
(47, 'gamemonetize-1401', 'santa-hidden-presents', 'Santa Hidden Presents', 'https://img.gamemonetize.com/limjbf9hf8wgeasfsdy6f4xbmek32lmn/512x384.jpg', '0', 5, 0, '0', 'Christmas is coming and you need to find the gifts that Santa Claus brought you. So it is in this Christmas game. Find all the hidden gifts and move on to the next level. Try to play the whole game. You a limited with time, but that is interesting in this game. The pressure will make the game more interesting.', '', 'https://html5.gamemonetize.com/limjbf9hf8wgeasfsdy6f4xbmek32lmn/', 'html5', 1280, 720, 1576076683, '1', '0'),
(48, 'gamemonetize-1400', 'merry-christmas-truck', 'Merry Christmas Truck', 'https://img.gamemonetize.com/8pqlwfq9k60be4xv53qkuus4w4c80zg8/512x384.jpg', '0', 5, 0, '0', 'Another great jigsaw game with Christmas Trucks. Start to play and try to pass all 12 levels in this interesting festive game. Select the level of difficulty and start the game.', '', 'https://html5.gamemonetize.com/8pqlwfq9k60be4xv53qkuus4w4c80zg8/', 'html5', 1280, 720, 1576076683, '1', '0'),
(49, 'gamemonetize-1399', 'house-coloring-book', 'House Coloring Book', 'https://img.gamemonetize.com/guv399wrj7dttmygj23oneottek7anzr/512x384.jpg', '0', 1, 0, '0', 'BTS House Coloring Book is an online game that you can play for free. Do you like coloring book? If you like, House Coloring Book, coloring book that belongs to you, you can create your own color world. Choose any house image you want to paint to fill it, and then use the brush to choose the color you like. I believe that you can make a colorful and perfect painting.', '', 'https://html5.gamemonetize.com/guv399wrj7dttmygj23oneottek7anzr/', 'html5', 854, 480, 1576076683, '1', '0'),
(50, 'gamemonetize-1398', 'santa-gift-adventure', 'Santa Gift Adventure', 'https://img.gamemonetize.com/gdm0slhamxs3cdiscar2rlc0ki1dt4y9/512x384.jpg', '0', 1, 0, '0', 'Xmas is coming. Santa need gifts for childrens. Help Santa to collect more giftss to all childrens but be carefull, snow Yeti keep that gifts for them. Good luck!', '', 'https://html5.gamemonetize.com/gdm0slhamxs3cdiscar2rlc0ki1dt4y9/', 'html5', 1280, 720, 1576076683, '1', '0'),
(51, 'gamemonetize-1397', 'tank-attack', 'Tank Attack', 'https://img.gamemonetize.com/joe6t4nbwredfqolczkk3d98tzywdefw/512x384.jpg', '0', 3, 0, '0', 'In this game you need to destroy all other tanks opponent. Watch on tank health and destroy all other tanks. You can shoot with gun, machine gun or napalm bomb. Hide behind walls and be safe.', '', 'https://html5.gamemonetize.com/joe6t4nbwredfqolczkk3d98tzywdefw/', 'html5', 1660, 960, 1576076683, '1', '0'),
(52, 'gamemonetize-1396', 'paper-io-2', 'Paper.IO 2', 'https://img.gamemonetize.com/1skj7a1hu68a1p31ag4ywljq4gb18oma/512x384.jpg', '0', 3, 0, '0', 'Capture new territories and defeat enemies in the new exciting game Paper.io 2Each player starts out with a small island, make it larger by adding new areas to it, but watch out for enemies. You are safe on your own turf but once you are outside you become vulnerable. Protect your tail from opponents and don&#039;t hesitate to counter attack!', '', 'https://html5.gamemonetize.com/1skj7a1hu68a1p31ag4ywljq4gb18oma/', 'html5', 800, 600, 1576076683, '1', '0'),
(53, 'gamemonetize-1395', 'critical-strike-2', 'Critical Strike 2', 'https://img.gamemonetize.com/acqbhcj5o9j6fritnws909u3v66tv986/512x384.jpg', '0', 7, 0, '0', 'Are you ready for combat ? New First Person Shooter game with weapons skins. Show your skills.You are in a huge battlefield against real enemies. Choose your team and keep your brigade up and steady. You can choose; your combat style, strategy and gun strike online When you feel ready to battle: pull the trigger and start the fight gun strike assault ! - New Weapons Skins - Battle Royale Map Added - 20 New maps ( Dust2, MiniAssault, Iceworld, Castle ) - Improved Graphics for Counter terrorists', '', 'https://html5.gamemonetize.com/acqbhcj5o9j6fritnws909u3v66tv986/', 'html5', 960, 600, 1576076683, '1', '0'),
(54, 'gamemonetize-1394', 'pixel-dino-run', 'Pixel Dino Run', 'https://img.gamemonetize.com/8qbbg84vdtvzc5u59yktd8f53qdubkik/512x384.jpg', '0', 4, 0, '0', 'Pixel Dino Run is a fun game to run and jump, the more points you make the faster the dinosaur will run. [How to play] Tap the screen to make the dinosaur jump and when the dinosaur is high you can touch the screen to fall to the ground quickly.', '', 'https://html5.gamemonetize.com/8qbbg84vdtvzc5u59yktd8f53qdubkik/', 'html5', 800, 450, 1576076683, '1', '0'),
(55, 'gamemonetize-1393', 'anime-princess-dressup', 'Anime Princess DressUp', 'https://img.gamemonetize.com/yn3d15x1qnatsmaydks4q3fa3iqyzwgx/512x384.jpg', '0', 1, 0, '0', 'This new makeover game features 6 cute princesses drawn in anime style, 4 backgrounds and 240+ items (hairstyles, dresses, tops, skirts, accessories and lot more) which can be mixed and matched to create millions of combinations.', '', 'https://html5.gamemonetize.com/yn3d15x1qnatsmaydks4q3fa3iqyzwgx/', 'html5', 500, 750, 1576076683, '1', '0'),
(56, 'gamemonetize-1392', 'cubes-king', 'Cubes King', 'https://img.gamemonetize.com/vjf0xw1pesi63rn62l65sm7cryig3m1z/512x384.jpg', '0', 5, 0, '0', 'How to Cubes King Game Tap to Fill Blocks and Cubes Fill Blocks and Cubes like King', '', 'https://html5.gamemonetize.com/vjf0xw1pesi63rn62l65sm7cryig3m1z/', 'html5', 450, 750, 1576076683, '1', '0'),
(57, 'gamemonetize-1391', 'angry-cat-shot', 'Angry Cat Shot', 'https://img.gamemonetize.com/4qz9litbesb85ff0j62zwdfwl7hmjc2n/512x384.jpg', '0', 3, 0, '0', 'In Angry Cat Shot, get ready to take control of a crazy cat who is obsessed with collecting stars! Felines don&#039;t have wings, but that doesn&#039;t mean they can&#039;t travel in the air. Grab your helmet, and complete each level with success.', '', 'https://html5.gamemonetize.com/4qz9litbesb85ff0j62zwdfwl7hmjc2n/', 'html5', 800, 450, 1576076683, '1', '0'),
(58, 'gamemonetize-1390', 'anime-princess-dress-up', 'Anime Princess Dress Up', 'https://img.gamemonetize.com/x0y68e9inx9j47o65h3kddxv789u93t7/512x384.jpg', '0', 1, 0, '0', 'In this new game about princesses you are waiting for anime princesses (6 girls with different skin tone), 4 backgrounds and more than 240 items (fashionable hairstyles, beautiful dresses, tops, skirts, stylish accessories and more), of which you can make millions of combinations.', '', 'https://html5.gamemonetize.com/x0y68e9inx9j47o65h3kddxv789u93t7/', 'html5', 450, 750, 1576076683, '1', '0'),
(59, 'gamemonetize-1389', 'fairy-dress-up', 'Fairy Dress Up', 'https://img.gamemonetize.com/c7pp36he30nu3o7th6oqh7dih7gzg4bt/512x384.jpg', '0', 1, 0, '0', 'Fairy dress Up game in which you can dress fairy dolls in beautiful dresses, skirts, jackets, shoes, wings, jewelry! Pick up beautiful hairstyles, hats, magic wands and other accessories in the game about fairies. For this new game for girls, we have come up with not only clothes, but each fairy still has cute Pets.', '', 'https://html5.gamemonetize.com/c7pp36he30nu3o7th6oqh7dih7gzg4bt/', 'html5', 450, 750, 1576076683, '1', '0'),
(60, 'gamemonetize-1388', 'cut-wood', 'Cut Wood', 'https://img.gamemonetize.com/58u0g22wvbidssulafbidhcjprrf3e19/512x384.jpg', '0', 4, 0, '0', 'Cut Wood features: - 2 game modes - good graphics and sounds', '', 'https://html5.gamemonetize.com/58u0g22wvbidssulafbidhcjprrf3e19/', 'html5', 960, 540, 1576076683, '1', '0'),
(61, 'gamemonetize-1387', 'fill-ball', 'Fill Ball', 'https://img.gamemonetize.com/sw80tzcmn772xr84fdq1soke8rg3nfkf/512x384.jpg', '0', 1, 0, '0', 'Fire Balls D is a casual game controlled by simple touch It will keep you for hours Hold down to make your point shoot forward and watch the moving obstaclesa', '', 'https://html5.gamemonetize.com/sw80tzcmn772xr84fdq1soke8rg3nfkf/', 'html5', 800, 600, 1576076683, '1', '0'),
(62, 'gamemonetize-1386', 'hextris', 'Hextris', 'https://img.gamemonetize.com/ejbhiyruzvut682ybs4nxxxjkiy3o862/512x384.jpg', '0', 5, 0, '0', 'Hextris, A match 3 games where you can spend the time all day long playing this game.', '', 'https://html5.gamemonetize.com/ejbhiyruzvut682ybs4nxxxjkiy3o862/', 'html5', 800, 600, 1576076683, '1', '0'),
(63, 'gamemonetize-1385', 'gymnastics-dress-up', 'Gymnastics Dress Up', 'https://img.gamemonetize.com/56g3lkem9rks464jlx0bmykjo35idplj/512x384.jpg', '0', 1, 0, '0', '&quot;Gymnastics Dress Up&quot; is a new dress up game for girls and girls who love sports, rhythmic gymnastics, bright costumes and for those who like to pick up outfits and fashionable images!', '', 'https://html5.gamemonetize.com/56g3lkem9rks464jlx0bmykjo35idplj/', 'html5', 450, 750, 1576076683, '1', '0'),
(64, 'gamemonetize-1384', 'penguin-battle-christmas', 'Penguin Battle Christmas', 'https://img.gamemonetize.com/k1lzbvtv0vu7mvnl8efcvum66s1mrdfc/512x384.jpg', '0', 4, 0, '0', 'Penguin Battle Christmas - An army of snowmen are determined to ransack this poor penguin’s cabin! Help the bodacious bird defend his home in this action game. Purchase weapon upgrades and new clothing items to upgrate skills personage! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/k1lzbvtv0vu7mvnl8efcvum66s1mrdfc/', 'html5', 800, 600, 1576076683, '1', '0'),
(65, 'gamemonetize-1383', 'bmw-x6-puzzle', 'BMW X6 Puzzle', 'https://img.gamemonetize.com/yxsfvuln3g56thvuiudk9t2aippwffae/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: BMW X6 Puzzle. All images is with the BMW x6. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/yxsfvuln3g56thvuiudk9t2aippwffae/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(66, 'gamemonetize-1382', 'christmas-2019-mahjong-connect', 'Christmas 2019 Mahjong Connect', 'https://img.gamemonetize.com/xcrq3skgenugwvnje6i5mpei6h7micqf/512x384.jpg', '0', 5, 0, '0', 'Connect all the christmas mahjong pieces and clear the board in this html5 christmas puzzle games.', '', 'https://html5.gamemonetize.com/xcrq3skgenugwvnje6i5mpei6h7micqf/', 'html5', 800, 600, 1576076683, '1', '0'),
(67, 'gamemonetize-1381', 'snake-worm', 'Snake Worm', 'https://img.gamemonetize.com/z7c0jypovj55qac45pm6sm4rgftnqtnp/512x384.jpg', '0', 5, 0, '0', 'This is interesting snake game where you need to collect dots and to avoid other worms, or the game will over. You can increase your speed to avoid other worms or to collect more dots. Watch on your energy and try to play longer as you can.', '', 'https://html5.gamemonetize.com/z7c0jypovj55qac45pm6sm4rgftnqtnp/', 'html5', 860, 480, 1576076683, '1', '0'),
(68, 'gamemonetize-1380', 'christmas-cookies-match-3', 'Christmas Cookies Match 3', 'https://img.gamemonetize.com/duqw8lxz4pjw5r1lcipnqbp6ugtw2waf/512x384.jpg', '0', 5, 0, '0', 'Christmas Cookies Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. Enjoy the game!', '', 'https://html5.gamemonetize.com/duqw8lxz4pjw5r1lcipnqbp6ugtw2waf/', 'html5', 1280, 720, 1576076683, '1', '0'),
(69, 'gamemonetize-1379', 'hot-rod-jigsaw-puzzle', 'Hot Rod Jigsaw Puzzle', 'https://img.gamemonetize.com/h5m8fq2vvckcshp0jed1eo2mip4esu99/512x384.jpg', '0', 5, 1, '0', 'Hot Rod Jigsaw Puzzle is an online game that you can play for free. Are you interested in cool cars and hot rods? This game is suitable for players who like cars and jigsaw puzzles. Do you have the confidence to complete a picture in the fastest time? The game has three different levels of difficulty to choose from. Have fun playing.', '', 'https://html5.gamemonetize.com/h5m8fq2vvckcshp0jed1eo2mip4esu99/', 'html5', 854, 480, 1576076683, '1', '0'),
(70, 'gamemonetize-1378', 'santa-or-thief', 'Santa or Thief?', 'https://img.gamemonetize.com/g79htxt6jn23e4p50ckl5qqzloyktj3a/512x384.jpg', '0', 5, 0, '0', 'Merry Christmas! Kids have got their gifts from santa but its not over yet infact game begins for you We celebrate XMAS with gifts. Who dont like gifts even thieves too. Yes So we have made this funny game Santa or Thief Where you will be a thief who is dressed up like santa. So you need to be beware of kids and collect gifts To make it more fun there are cool powers like invisible paint gift magnet and moreSuit up and play Santa or Thief.', '', 'https://html5.gamemonetize.com/g79htxt6jn23e4p50ckl5qqzloyktj3a/', 'html5', 640, 1136, 1576076683, '1', '0'),
(71, 'gamemonetize-1377', 'jingle-jetpack', 'Jingle Jetpack', 'https://img.gamemonetize.com/1h0rpfwt512uknlm2so880g153siow4p/512x384.jpg', '0', 5, 0, '0', 'The most exciting action game is back to help Santa to deliver all gifts. Strap on a bullet-powered jetpack to dodge lasers, electric fields and all the missiles that come your way. You need to get out of there alive! Collect coins and buy new power ups and skins to reach new scores and deliver all Chritsmas to the world', '', 'https://html5.gamemonetize.com/1h0rpfwt512uknlm2so880g153siow4p/', 'html5', 800, 450, 1576076683, '1', '1'),
(72, 'gamemonetize-1376', 'cyber-truck-drive-simulator', 'Cyber Truck Drive Simulator', 'https://img.gamemonetize.com/7xk1ek5ya108fojn7b3df0ajdx2k5jhc/512x384.jpg', '0', 2, 0, '0', 'The most talked-about new car recently, Cyber ​​Truck Drive Simulator gives you a unique experience. Realistic physics, sound effects and advanced interface allows you to have a nice time. In Cyber ​​Truck Drive Simulator, your goal is to collect the flags on the map in such a way that the damage to the car is minimal. And before time runs out :) Cyber ​​Truck Drive Simulator gives you the real mi simulator experience with realistic physics.', '', 'https://html5.gamemonetize.com/7xk1ek5ya108fojn7b3df0ajdx2k5jhc/', 'html5', 900, 600, 1576076683, '1', '0'),
(73, 'gamemonetize-1375', 'ball-hook', 'Ball Hook', 'https://img.gamemonetize.com/ndzk1a2doccyqbel6f92u3015tg2whqj/512x384.jpg', '0', 4, 0, '0', 'The most addictive stack Poke game with Ball Hook , super fun and addictive one touch casual game.Press and hold on the screen and let the ball go up without touching the obstacles! And Reach top of the Tower Have Fun.', '', 'https://html5.gamemonetize.com/ndzk1a2doccyqbel6f92u3015tg2whqj/', 'html5', 500, 750, 1576076683, '1', '0'),
(74, 'gamemonetize-1374', 'swing-rider-2', 'Swing Rider 2', 'https://img.gamemonetize.com/uxsnkk69xenkdjpxz55zpc4jnfjyrc0m/512x384.jpg', '0', 4, 0, '0', 'You will play as a super boy who has to swing with his web throughout the city. It is really fantastic to move across the city with his power. Become the most courageous and fearless swing rider! To protect the city you have to look from the sky by swinging. So swing as much as you can with your rope!', '', 'https://html5.gamemonetize.com/uxsnkk69xenkdjpxz55zpc4jnfjyrc0m/', 'html5', 900, 600, 1576076683, '1', '0'),
(75, 'gamemonetize-1373', 'shift-run', 'Shift Run', 'https://img.gamemonetize.com/ywq3bhpuhzuqnl0kroioumd7hl562tq1/512x384.jpg', '0', 4, 1, '0', 'Just Swipe to Adjust Angle and Shift Direction, New Addictive Concept. Have Fun with Run, Jump, roll, Skater, Make Stunts. Enjoy the TOP Trending game.', '', 'https://html5.gamemonetize.com/ywq3bhpuhzuqnl0kroioumd7hl562tq1/', 'html5', 450, 750, 1576076683, '1', '0'),
(76, 'gamemonetize-1372', 'arabian-princess-dress-up', 'Arabian Princess Dress Up', 'https://img.gamemonetize.com/jp4z6gsqgrm157jtu6yx6txcmej3lds5/512x384.jpg', '0', 1, 0, '0', '«Arabian Princess Dress Up» is a new girls makeover game for those, who are interested in Arab culture, oriental fashion, Arabic language and Arab dance. Now you have the opportunity to plunge into the world of Arab princesses and take a look at actual Arabian style! If you like different cultures, pretty dresses and girls makeover games – this game is for you!', '', 'https://html5.gamemonetize.com/jp4z6gsqgrm157jtu6yx6txcmej3lds5/', 'html5', 500, 750, 1576076683, '1', '0'),
(77, 'gamemonetize-1371', 'ballerina-magazine-dress-up', 'Ballerina Magazine Dress Up', 'https://img.gamemonetize.com/e8l0knzjpiyvrmy6xfjvkhqjvudym7w0/512x384.jpg', '0', 1, 0, '0', 'Have you always dreamed of being a ballerina? It&#039;s your moment to shine along with our adorable ballet dancers. Enter one of the most beautiful dress up games for girls and let your dreams come true!', '', 'https://html5.gamemonetize.com/e8l0knzjpiyvrmy6xfjvkhqjvudym7w0/', 'html5', 500, 750, 1576076683, '1', '0'),
(78, 'gamemonetize-1370', 'chic-wedding-salon', 'Chic Wedding Salon', 'https://img.gamemonetize.com/o6b6hpuj96jk6wh2zq61813ujsofa8sy/512x384.jpg', '0', 4, 0, '0', 'Planning a wedding can be really hard. Become a wedding planner and be part of a beautiful story in one of the cutest wedding games for girls!', '', 'https://html5.gamemonetize.com/o6b6hpuj96jk6wh2zq61813ujsofa8sy/', 'html5', 500, 750, 1576076683, '1', '0'),
(79, 'gamemonetize-1369', 'bird-quest-adventure-flappy', 'Bird Quest: Adventure Flappy', 'https://img.gamemonetize.com/mrx4okvoe74v4oces6r4r8c5gv0g3lxq/512x384.jpg', '0', 4, 0, '0', 'In Bird Quest you must dodge obstacles and monsters by collecting coins, stars and diamonds, grab everything to get more points and buy new legendary birds!', '', 'https://html5.gamemonetize.com/mrx4okvoe74v4oces6r4r8c5gv0g3lxq/', 'html5', 800, 450, 1576076683, '1', '0'),
(80, 'gamemonetize-1368', 'cheerleader-magazine-dress-up', 'Cheerleader Magazine Dress Up', 'https://img.gamemonetize.com/ejjt3pdqh4wwy8081iutwc43384bn891/512x384.jpg', '0', 4, 0, '0', 'Cheer up with the sweet cheerleaders! Enter their sporty world and show off your fashion sense in one of the most beautiful dress up game for girls. Cheerleading is more than a sport! Prove that you are the best fashion advisor and put together some stylish outfits for our amazing cheerleaders.', '', 'https://html5.gamemonetize.com/ejjt3pdqh4wwy8081iutwc43384bn891/', 'html5', 500, 750, 1576076683, '1', '0'),
(81, 'gamemonetize-1367', 'love-story', 'Love Story', 'https://img.gamemonetize.com/88oyar0nu3q1iuj2nquv5zgy6yb579ig/512x384.jpg', '0', 1, 0, '0', 'At last this day has come! Dream guy invited you for a walk! You can choose the most fashionable outfits, evening dresses, and images for this important day. You have every chance to become the Queen of the ball, conquer all and become the king and Queen, because at your disposal more than 300 items of clothing, accessories, shoes and hairstyles in our fashion boutique!', '', 'https://html5.gamemonetize.com/88oyar0nu3q1iuj2nquv5zgy6yb579ig/', 'html5', 450, 750, 1576076683, '1', '0'),
(82, 'gamemonetize-1366', 'lay-eggs', 'Lay Eggs', 'https://img.gamemonetize.com/93arx3e1chgrwotvsmmf7ei7ruqjjrlt/512x384.jpg', '0', 4, 0, '0', 'The bird want to go home, but There are many obstacles on the road. Can you help the bird go home safely?', '', 'https://html5.gamemonetize.com/93arx3e1chgrwotvsmmf7ei7ruqjjrlt/', 'html5', 800, 600, 1576076683, '1', '0'),
(83, 'gamemonetize-1365', 'overloaded-bus', 'Overloaded Bus', 'https://img.gamemonetize.com/g5jr2ontve2haep8hjskag1l4wgt0ilh/512x384.jpg', '0', 4, 0, '0', 'Tap to Drop and Pick up the Passengers, Avoid Explode, Don’t be Overloaded Heavy Crowd Bus Have Fun. Can you complete all 100 levels?', '', 'https://html5.gamemonetize.com/g5jr2ontve2haep8hjskag1l4wgt0ilh/', 'html5', 500, 750, 1576076683, '1', '0'),
(84, 'gamemonetize-1364', 'lol-dress-up', 'LOL Dress Up', 'https://img.gamemonetize.com/tg3h4740qfuual380u83gvwdpde0gos9/512x384.jpg', '0', 1, 0, '0', 'A new game for all doll fans and for those who love to discover new dress up games! Choose the right clothes, accessories and even eye color to create your unique doll! New bright avatar maker is now at your disposal!', '', 'https://html5.gamemonetize.com/tg3h4740qfuual380u83gvwdpde0gos9/', 'html5', 450, 750, 1576076683, '1', '0'),
(85, 'gamemonetize-1363', 'dentist-doctor', 'Dentist Doctor', 'https://img.gamemonetize.com/b6yat7entyeh9uz1r54g42ee22cx9wzl/512x384.jpg', '0', 1, 0, '0', 'To be a dentist is not that simple but is an awesome job! … and we’re looking for a new member in our team. Try your skills and help the patients get better and become an awesome dentist! Features: • Multiple characters to choose from • Multiple accesories', '', 'https://html5.gamemonetize.com/b6yat7entyeh9uz1r54g42ee22cx9wzl/', 'html5', 540, 720, 1576076683, '1', '0'),
(86, 'gamemonetize-1362', 'word-search-puzzle', 'Word Search Puzzle', 'https://img.gamemonetize.com/arkay8kmsbm14s0vvm25un5nhyu2wpk7/512x384.jpg', '0', 1, 0, '0', 'The chef mixed up the letters and now you need to help him recreate the words for new recipes. Drag on the letters to create a word. Features: • Challenging gameplay • Multiple categories • Online score saving', '', 'https://html5.gamemonetize.com/arkay8kmsbm14s0vvm25un5nhyu2wpk7/', 'html5', 540, 720, 1576076683, '1', '0'),
(87, 'gamemonetize-1361', 'love-snowballs-xmas', 'Love Snowballs Xmas', 'https://img.gamemonetize.com/oftmb7fdups9fikqcr8ethxg0zse6umv/512x384.jpg', '0', 5, 0, '0', 'Draw lines to help each pair of Snowmen to get back together. Be their hero! Play now!', '', 'https://html5.gamemonetize.com/oftmb7fdups9fikqcr8ethxg0zse6umv/', 'html5', 960, 540, 1576076683, '1', '0'),
(88, 'gamemonetize-1360', 'christmas-art-2019-slide', 'Christmas Art 2019 Slide', 'https://img.gamemonetize.com/ijewoz4ru8nf5z07ewh9h9opq9ngqvv8/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of the christmas art 2019. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/ijewoz4ru8nf5z07ewh9h9opq9ngqvv8/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(89, 'gamemonetize-1359', 'cadillac-ct4-puzzle', 'Cadillac CT4 Puzzle', 'https://img.gamemonetize.com/jrlqih9tzg2g0cv1e1fsm7he6lvre9nx/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Cadillac CT4 Puzzle. All images is with the cadillac ct4. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/jrlqih9tzg2g0cv1e1fsm7he6lvre9nx/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(90, 'gamemonetize-1358', 'rock-music', 'Rock Music', 'https://img.gamemonetize.com/jfgumxuk87omvxwf1j4ab08oz3hzy62i/512x384.jpg', '0', 5, 0, '0', 'Casual Music Game (Rock Music) developed for fun of all people, in the style of guitar hero, from children to adults. Save as many points as you can by pressing music buttons and do not miss the beat. The designs are very colorful and beautiful!', '', 'https://html5.gamemonetize.com/jfgumxuk87omvxwf1j4ab08oz3hzy62i/', 'html5', 450, 800, 1576076683, '1', '0'),
(91, 'gamemonetize-1357', 'santa-running', 'Santa Running', 'https://img.gamemonetize.com/8mjkcfs0qsy52qgsd830ixcjr2qsr6o0/512x384.jpg', '0', 5, 0, '0', 'Christmas is coming, Our cute Santa decides to prepare some gifts for you. Can you help him? There are 21 levels waiting for you, Jump and avoid the obstacles to collect more and more gifts. Can you complete all the levels? Have a good time in Running Santa!', '', 'https://html5.gamemonetize.com/8mjkcfs0qsy52qgsd830ixcjr2qsr6o0/', 'html5', 1056, 594, 1576076683, '1', '0'),
(92, 'gamemonetize-1356', 'angry-santa-claus', 'Angry Santa Claus', 'https://img.gamemonetize.com/0d3gpo2y90i3r2vm292vbov5124pcbkc/512x384.jpg', '0', 5, 0, '0', 'Angry Santa Claus is fun action game suitable for all ages. Help our Santa collect as many gifts as possible. Avoid the red devils on the way and the obstacles as well. Have fun playing.', '', 'https://html5.gamemonetize.com/0d3gpo2y90i3r2vm292vbov5124pcbkc/', 'html5', 480, 854, 1576076683, '1', '0'),
(93, 'gamemonetize-1355', 'santa-gift-delivery-truck', 'Santa Gift Delivery Truck', 'https://img.gamemonetize.com/dq49257blje909pgtstmhtlhwrcjcenq/512x384.jpg', '0', 2, 0, '0', 'Hip Hip Hurrrryyy!!! Merry Christmas to all of you and now it&#039;s time to deliver some Christmas gifts as a santa in santa gift delivery games and christmas gift ...', '', 'https://html5.gamemonetize.com/dq49257blje909pgtstmhtlhwrcjcenq/', 'html5', 800, 600, 1576076683, '1', '0'),
(94, 'gamemonetize-1354', 'box-run', 'Box Run', 'https://img.gamemonetize.com/dmtlprkil7h1qaiuo5xolpwze7wu5uoj/512x384.jpg', '0', 2, 0, '0', 'Box Run is a touch and hold game. Boxes of the same color touch each other to earn points, if different boxes touch each other you will end the game. Wish you have fun.', '', 'https://html5.gamemonetize.com/dmtlprkil7h1qaiuo5xolpwze7wu5uoj/', 'html5', 460, 680, 1576076683, '1', '0'),
(95, 'gamemonetize-1353', 'park-the-beetle', 'Park the Beetle', 'https://img.gamemonetize.com/4dlvpdlg27xtv4jpb13ldyi6saqhfizk/512x384.jpg', '0', 2, 0, '0', 'Hop on the driver&#039;s seat and drive your car to designated parking spot. Avoid objects and other cars at all costs or you will loose. A lot of different cars, incredibly realistic graphics, interesting levels and other cool things is waiting for you in this addicting game.', '', 'https://html5.gamemonetize.com/4dlvpdlg27xtv4jpb13ldyi6saqhfizk/', 'html5', 854, 480, 1576076683, '1', '0'),
(96, 'gamemonetize-1352', 'swing-city', 'Swing City', 'https://img.gamemonetize.com/4rui2qnione0dx01j7vfh4lv5yk1qzuu/512x384.jpg', '0', 4, 0, '0', 'Test your skills with Swing City! The physics based game where you swing across the city and avoid signs, cars and more! How far can you go? Collect coins and discover secrets to unlock more characters and prizes! Swing like a hero!', '', 'https://html5.gamemonetize.com/4rui2qnione0dx01j7vfh4lv5yk1qzuu/', 'html5', 450, 750, 1576076683, '1', '0'),
(97, 'gamemonetize-1351', 'cool-snakes', 'Cool Snakes', 'https://img.gamemonetize.com/8o8zz5cnvpg4pzo3sjrhmhs9jf2hhjwq/512x384.jpg', '0', 1, 0, '0', 'Cool Snakes is slithering snakes game in 3d snowy world. Become the grand snake in game by eating others and grow longer. Collect powers ups to grow faster. Good Luck', '', 'https://html5.gamemonetize.com/8o8zz5cnvpg4pzo3sjrhmhs9jf2hhjwq/', 'html5', 900, 540, 1576076683, '1', '0')";
$db[17] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(98, 'gamemonetize-1350', 'criatures-defense', 'Criatures Defense', 'https://img.gamemonetize.com/v6n37gn8393blfz7dmoeublre91e9zu5/512x384.jpg', '0', 3, 0, '0', 'Get ready to defend your fortress against powerful waves of various units. They form huge waves of deadly enemies, that will erase your fortress if you won&#039;t stop them. Use primary gun to shoot them, additional system will do it automatically. Activate weapons from the bottom panel for targeted strike. Complete levels and upgrade.', '', 'https://html5.gamemonetize.com/v6n37gn8393blfz7dmoeublre91e9zu5/', 'html5', 800, 500, 1576076683, '1', '0'),
(99, 'gamemonetize-1349', 'road-turn', 'Road Turn', 'https://img.gamemonetize.com/5eautsw3kjh2kphmbr1a531hna5dzya4/512x384.jpg', '0', 4, 0, '0', 'Now you job is direct traffic.For aovid to happen traffic accidents.you must control the car to turn after straight-going cars passes.', '', 'https://html5.gamemonetize.com/5eautsw3kjh2kphmbr1a531hna5dzya4/', 'html5', 800, 600, 1576076683, '1', '0'),
(100, 'gamemonetize-1348', 'drive-taxi', 'Drive Taxi', 'https://img.gamemonetize.com/3uqfw29xsq6rl39s31d8ggr2t3gn8dbb/512x384.jpg', '0', 4, 0, '0', 'Now drive your taxi to pick up all the passengers and deliver them to your destination!Don&#039;t forget the passengers, but also be careful about the cars on the road!', '', 'https://html5.gamemonetize.com/3uqfw29xsq6rl39s31d8ggr2t3gn8dbb/', 'html5', 800, 600, 1576076683, '1', '0'),
(101, 'gamemonetize-1347', 'drive-boat', 'Drive Boat', 'https://img.gamemonetize.com/y27xvyyhxv56gc0a3m10rchtoz8ek3cj/512x384.jpg', '0', 4, 0, '0', 'Now drive your boat to pick up all the passengers and deliver them to your destination!Don&#039;t forget the passengers, but also be careful about the boats on the river!', '', 'https://html5.gamemonetize.com/y27xvyyhxv56gc0a3m10rchtoz8ek3cj/', 'html5', 800, 600, 1576076683, '1', '0'),
(102, 'gamemonetize-1346', 'dream-boyfriend-maker', 'Dream Boyfriend Maker', 'https://img.gamemonetize.com/veiqjdot6hb4vwcwjs7eqp37h812n0cj/512x384.jpg', '0', 1, 0, '0', 'You asked us so many times and we finally did it! Boys dress up game - «Dream Boyfriend Maker»! There are so many girls dress up games, but what about boys? Now you can dress up guys with modern clothes and make fashionable outfits! Make your ideal boyfriend!', '', 'https://html5.gamemonetize.com/veiqjdot6hb4vwcwjs7eqp37h812n0cj/', 'html5', 500, 750, 1576076683, '1', '0'),
(103, 'gamemonetize-1345', 'rope-unroll', 'Rope Unroll', 'https://img.gamemonetize.com/vln97w1n0wqewi2gtd82r3relzbhsv4n/512x384.jpg', '0', 5, 0, '0', 'Here New Trending Game, Just Swipe to Unroll the Rope and Unlock the Beautifull Object Have Fun. Use mouse to play.', '', 'https://html5.gamemonetize.com/vln97w1n0wqewi2gtd82r3relzbhsv4n/', 'html5', 500, 750, 1576076683, '1', '0'),
(104, 'gamemonetize-1344', 'traffic-go', 'Traffic Go', 'https://img.gamemonetize.com/s5rwzms9stcl1uxgj1dgqy1a62dt7k90/512x384.jpg', '0', 5, 0, '0', 'Cross the streets without hitting cars and get to the goal', '', 'https://html5.gamemonetize.com/s5rwzms9stcl1uxgj1dgqy1a62dt7k90/', 'html5', 800, 600, 1576076683, '1', '0'),
(105, 'gamemonetize-1343', 'bubble-shooter-kids', 'Bubble Shooter Kids', 'https://img.gamemonetize.com/3mfdwtp357hyz00brjmxtaxutspvhlyl/512x384.jpg', '0', 5, 0, '0', 'Bubble Shooter Kids features: - amazing graphics - multiple levels - power-ups', '', 'https://html5.gamemonetize.com/3mfdwtp357hyz00brjmxtaxutspvhlyl/', 'html5', 540, 720, 1576076683, '1', '0'),
(106, 'gamemonetize-1342', 'break-the-snowman-xmas', 'Break The Snowman Xmas', 'https://img.gamemonetize.com/a0luz1ov5klxhoa1j9og5fv5imkixn57/512x384.jpg', '0', 5, 0, '0', 'Move your snowman cleverly, touch the target one to break them. 40 levels to play, can you complete them all? Merry Christmas! Play now!', '', 'https://html5.gamemonetize.com/a0luz1ov5klxhoa1j9og5fv5imkixn57/', 'html5', 960, 540, 1576076683, '1', '0'),
(107, 'gamemonetize-1341', 'top-model-dress-up', 'Top Model Dress Up', 'https://img.gamemonetize.com/bg4a9mz47ru3wut54dbryk1oeiacg7ir/512x384.jpg', '0', 1, 0, '0', 'Do you want to dress like a supermodel or a superstar? Try your fashionista style on virtual doll characters in our new dress up game about models and celebrities!', '', 'https://html5.gamemonetize.com/bg4a9mz47ru3wut54dbryk1oeiacg7ir/', 'html5', 450, 750, 1576076683, '1', '0'),
(108, 'gamemonetize-1340', 'unblock-that', 'Unblock That', 'https://img.gamemonetize.com/ddj3po8z23tfxxfqi2z447ngx1jk41ai/512x384.jpg', '0', 5, 0, '0', 'Unblock That is a simple and addictive puzzle game. The goal is to unblock the red block out of the board by sliding the other blocks out of the way. Do it with the minimal amount of moves.  The game comes with 4 difficulties ranging from Beginner to Expert. Unblock That can help you train your brain and keep you mentally fit everyday.', '', 'https://html5.gamemonetize.com/ddj3po8z23tfxxfqi2z447ngx1jk41ai/', 'html5', 600, 800, 1576076683, '1', '0'),
(109, 'gamemonetize-1339', 'pen-art', 'Pen Art', 'https://img.gamemonetize.com/pt0l5nzr6vvafzr7rj5wgaevvh2oebq3/512x384.jpg', '0', 4, 0, '0', 'Just Tap to Draw Art images to avoid Obstacles. Have Fun! Enjoy the TOP Trending game.', '', 'https://html5.gamemonetize.com/pt0l5nzr6vvafzr7rj5wgaevvh2oebq3/', 'html5', 450, 750, 1576076683, '1', '0'),
(110, 'gamemonetize-1338', 'mahjong-flowers', 'Mahjong Flowers', 'https://img.gamemonetize.com/o2kdjmcc4q3fzrcjka8665qw6fq4olkc/512x384.jpg', '0', 5, 0, '0', 'Relax and improve your memory and ability at the same time with the worldwide favourite adaptation of the traditional chinese game Mahjong. Match the correct tiles until you clean the whole game field of the very last tile. Try it as fast as possible to gain a golden star that reflects your perception and skill.', '', 'https://html5.gamemonetize.com/o2kdjmcc4q3fzrcjka8665qw6fq4olkc/', 'html5', 800, 600, 1576076683, '1', '0'),
(111, 'gamemonetize-1337', 'dress-up-games-for-girls', 'Dress up Games for Girls', 'https://img.gamemonetize.com/7qnbp6j7yzhb3r6c9fd05poqz4pu7mtf/512x384.jpg', '0', 1, 0, '0', 'Princesses have the most fashionable dresses, the best hairstyles, a variety of accessories and impeccable taste! These girls love to go to the beauty salon and change into new beautiful outfits!', '', 'https://html5.gamemonetize.com/7qnbp6j7yzhb3r6c9fd05poqz4pu7mtf/', 'html5', 500, 800, 1576076683, '1', '0'),
(112, 'gamemonetize-1336', 'jewel-pop', 'Jewel Pop', 'https://img.gamemonetize.com/67u3mkrfs6fd5c3mjg2htccbzkkirltx/512x384.jpg', '0', 5, 0, '0', 'Get ready to match and pop some colourful balloons! Crush through blocks and other obstacles standing in your way. The classic turn based match-3 arcade with lots of challenging levels awaits you!', '', 'https://html5.gamemonetize.com/67u3mkrfs6fd5c3mjg2htccbzkkirltx/', 'html5', 600, 800, 1576076683, '1', '0'),
(113, 'gamemonetize-1335', 'jewel-magic-xmas', 'Jewel Magic Xmas', 'https://img.gamemonetize.com/qab5o8hs56u4uytktnjzs991p42opqog/512x384.jpg', '0', 5, 0, '0', 'Already in Christmas mood? The classic turn based triplet matching arcade with Christmas decorations awaits you! Match triplets while solving puzzles in lots of different challenging levels. Also you can spin the lucky wheel daily to get boosters to help you. Have a jolly time! Merry matching Christmas with jolly jewels!', '', 'https://html5.gamemonetize.com/qab5o8hs56u4uytktnjzs991p42opqog/', 'html5', 800, 600, 1576076683, '1', '0'),
(114, 'gamemonetize-1334', 'bowling-hit-3d', 'Bowling Hit 3D', 'https://img.gamemonetize.com/8gyhq5ekdr4lx5diowxvl4wb1lubpamy/512x384.jpg', '0', 4, 0, '0', 'Play the best bowling game in amazing realistic 3d graphics. Test your bowling skills in the NO 1 bowling game. Bowl more Strikes and become the bowling king.', '', 'https://html5.gamemonetize.com/8gyhq5ekdr4lx5diowxvl4wb1lubpamy/', 'html5', 450, 750, 1576076683, '1', '0'),
(115, 'gamemonetize-1333', 'witch-to-princess-makeover', 'Witch to Princess Makeover', 'https://img.gamemonetize.com/qeq1wwsv32l8gagr7rmgs6njkfxdrq2h/512x384.jpg', '0', 1, 0, '0', 'The beautiful Princess was cursed and transformed into a witch. Help her preparing the right potion and turn herself back into a princess, get ready for the ball and meet Prince Charming. Features: • Multiple skins • Multiple dresses and accessories to choose from', '', 'https://html5.gamemonetize.com/qeq1wwsv32l8gagr7rmgs6njkfxdrq2h/', 'html5', 540, 720, 1576076683, '1', '0'),
(116, 'gamemonetize-1332', 'hole-run', 'Hole Run', 'https://img.gamemonetize.com/c7j2n6z1p9pi4f88yk23849sdf8r0fhd/512x384.jpg', '0', 4, 0, '0', 'Here Swipe the hole to Eat all Blocks and Shapes to Save Ball. Have Fun! Enjoy the TOP Trending game.', '', 'https://html5.gamemonetize.com/c7j2n6z1p9pi4f88yk23849sdf8r0fhd/', 'html5', 450, 750, 1576076683, '1', '0'),
(117, 'gamemonetize-1331', 'jump-in-the-circle', 'Jump In The Circle', 'https://img.gamemonetize.com/q4v5i3fjqdfaidn1t7vaw8i1teeyd964/512x384.jpg', '0', 4, 0, '0', 'Jump in the circle and obtain points for reach the best score and gems for purchase new skins', '', 'https://html5.gamemonetize.com/q4v5i3fjqdfaidn1t7vaw8i1teeyd964/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(118, 'gamemonetize-1330', 'bts-music-instrument-coloring-book', 'BTS Music Instrument Coloring Book', 'https://img.gamemonetize.com/muv6slfuo1y1dzigh86ovtvkt9y7t4of/512x384.jpg', '0', 5, 0, '0', 'BTS Music Instrument Coloring Book is an online game that you can play for free. Splash out some colors over and around the instruments. Discover the magical happiness that colors could give to a single drawing.', '', 'https://html5.gamemonetize.com/muv6slfuo1y1dzigh86ovtvkt9y7t4of/', 'html5', 854, 480, 1576076683, '1', '0'),
(119, 'gamemonetize-1329', 'flipping-color-box', 'Flipping Color Box', 'https://img.gamemonetize.com/0uqe1x4ewie1l0zvk8tqkh1uadza5yb6/512x384.jpg', '0', 5, 1, '0', 'Cube Flip! Make the jumping cube flip to land with the color match and complete the color dash levels. Jump after jump you will advance to harder levels where you will have to put all your focus skills and concentration to pass through the color dash, so you will be able to get to the top of the mountain and become the Color Cube Flip Master in our classic addicting game.', '', 'https://html5.gamemonetize.com/0uqe1x4ewie1l0zvk8tqkh1uadza5yb6/', 'html5', 960, 540, 1576076683, '1', '0'),
(120, 'gamemonetize-1328', 'christmas-truck-jigsaw', 'Christmas Truck Jigsaw', 'https://img.gamemonetize.com/t6l8wd09myt0k1byid7v0zst0av6j2ld/512x384.jpg', '0', 5, 0, '0', 'This is jigsaw game with Christmas Trucks. Chose with how many pieces you want to play and try to put the pieces in right position to get the image with Christmas Truck. You can chose between five images. Try to play and enjoy in Holidays.', '', 'https://html5.gamemonetize.com/t6l8wd09myt0k1byid7v0zst0av6j2ld/', 'html5', 1280, 900, 1576076683, '1', '0'),
(121, 'gamemonetize-1327', 'christmas-deer-jigsaw', 'Christmas Deer Jigsaw', 'https://img.gamemonetize.com/9xceb9og5hiaemaveb2y3il6uctzhczq/512x384.jpg', '0', 5, 0, '0', 'Christmas Deer Jigsaw is a fun online puzzle game. Drag the pieces into right position using mouse. Solving puzzles is relaxing, rewarding, and keeps your brain sharp. You need to spend $1000 to be able to purchase one of the following pictures. You have three modes for each picture from which the hardest mode brings more money. You have a total of 10 pictures.', '', 'https://html5.gamemonetize.com/9xceb9og5hiaemaveb2y3il6uctzhczq/', 'html5', 960, 640, 1576076683, '1', '0'),
(122, 'gamemonetize-1326', 'monster-ball', 'Monster Ball', 'https://img.gamemonetize.com/ayx3yxt95ilaprixawfwmon2sg7yclwm/512x384.jpg', '0', 1, 0, '0', 'Monster Ball is a game simple and fun for kid. Just click and get high score.', '', 'https://html5.gamemonetize.com/ayx3yxt95ilaprixawfwmon2sg7yclwm/', 'html5', 600, 660, 1576076683, '1', '0'),
(123, 'gamemonetize-1325', 'gn-knife-up', 'GN Knife Up', 'https://img.gamemonetize.com/8ypjju9r5l1ssv4rla4niawj33yonvbw/512x384.jpg', '0', 4, 0, '0', 'This is a knife-throwing game, when you hit an apple you get points. Go as far as higher points when hit in the green area.', '', 'https://html5.gamemonetize.com/8ypjju9r5l1ssv4rla4niawj33yonvbw/', 'html5', 800, 660, 1576076683, '1', '0'),
(124, 'gamemonetize-1324', 'tripolygon', 'Tripolygon', 'https://img.gamemonetize.com/dv63wh581re1i2uufnso0dl6xrlu9x4m/512x384.jpg', '0', 5, 0, '0', 'Tripolygon is a game of rotating triangles in color to destroy the bars. There are 3 colors, turning the right color will be able to go further.', '', 'https://html5.gamemonetize.com/dv63wh581re1i2uufnso0dl6xrlu9x4m/', 'html5', 800, 600, 1576076683, '1', '0'),
(125, 'gamemonetize-1323', 'arithmetic-line', 'Arithmetic Line', 'https://img.gamemonetize.com/6em3shsk3320vulxvf97djc1f61f04q6/512x384.jpg', '0', 5, 0, '0', 'This is a game mix between calculation and ingenuity. Above the head there will be a problem, you need to calculate and find out the operation to answer. While finding the answer you need to avoid collisions with miscalculation. Have fun and good lucky.', '', 'https://html5.gamemonetize.com/6em3shsk3320vulxvf97djc1f61f04q6/', 'html5', 500, 680, 1576076683, '1', '0'),
(126, 'gamemonetize-1322', 'dunk-jump', 'Dunk Jump', 'https://img.gamemonetize.com/d6b2o4cccg15jlu7vo0d6ma2m86fph63/512x384.jpg', '0', 8, 0, '0', 'Dunk Jump is a mouse click game to get stars. The more stars you can buy other balls. It is a simple game no less ingenious, wish you have fun and good luck.', '', 'https://html5.gamemonetize.com/d6b2o4cccg15jlu7vo0d6ma2m86fph63/', 'html5', 800, 660, 1576076683, '1', '0'),
(127, 'gamemonetize-1321', 'gn-red-ball', 'GN Red Ball', 'https://img.gamemonetize.com/kl47x7zyhxocexq4a2xof2i1go0q1bem/512x384.jpg', '0', 8, 0, '0', 'This is a game that uses the calculation and adjustment of blocks to put the marble in the last position. Good lucky and fun.', '', 'https://html5.gamemonetize.com/kl47x7zyhxocexq4a2xof2i1go0q1bem/', 'html5', 800, 660, 1576076683, '1', '0'),
(128, 'gamemonetize-1320', 'ball-adventure', 'Ball Adventure', 'https://img.gamemonetize.com/euuizjrtxrzwpfj79hry7iyafodlm931/512x384.jpg', '0', 4, 0, '0', 'Features • A fun 3D skill game • 10 awesome levels to play', '', 'https://html5.gamemonetize.com/euuizjrtxrzwpfj79hry7iyafodlm931/', 'html5', 960, 600, 1576076683, '1', '0'),
(129, 'gamemonetize-1319', 'vacation-summer-dress-up', 'Vacation Summer Dress Up', 'https://img.gamemonetize.com/1xzd8bh40no0f1cbd2l77bblfbaf2u83/512x384.jpg', '0', 1, 0, '0', 'Hurray! Finally came the fun holidays! Time to go on a summer vacation at the sea and bring your fashionable girlfriends! Create your unforgettable summer story. At your disposal 225 unique fashion items for shopping with best friends for free!', '', 'https://html5.gamemonetize.com/1xzd8bh40no0f1cbd2l77bblfbaf2u83/', 'html5', 500, 800, 1576076683, '1', '0'),
(130, 'gamemonetize-1318', 'knife-smash', 'Knife Smash', 'https://img.gamemonetize.com/3cpadfbj1qzazaoqgb1d0a03i5mdexri/512x384.jpg', '0', 3, 0, '0', 'Do you like throwing stuff? Like knives at random spinning targets? Then this is the ultimate challenge for you! Time your actions, aim carefully and become the knife master! Can you beat all the levels? Very simple one-touch gameplay, but challenging to master! Can you collect all the ridiculous knives?', '', 'https://html5.gamemonetize.com/3cpadfbj1qzazaoqgb1d0a03i5mdexri/', 'html5', 600, 800, 1576076683, '1', '0'),
(131, 'gamemonetize-1317', 'ludo-legend', 'Ludo Legend', 'https://img.gamemonetize.com/jubi7s8v0430vl7hkxhtqsyqnlaa7loq/512x384.jpg', '0', 5, 0, '0', 'Play a game of Ludo! Everyones favourite board game! Play alone or with your friends on one device! Just pass it on! Colorful design and easy mechanics will keep you playing for hours!', '', 'https://html5.gamemonetize.com/jubi7s8v0430vl7hkxhtqsyqnlaa7loq/', 'html5', 500, 800, 1576076683, '1', '0'),
(132, 'gamemonetize-1316', 'cute-mermaid-dress-up', 'Cute Mermaid Dress Up', 'https://img.gamemonetize.com/3fzhcft02zrxnb0nwourethxmtq0bg8f/512x384.jpg', '0', 1, 0, '0', 'Mermaids-fabulous inhabitants of the amazing underwater world! They have wonderful hair, beautiful swimsuits and unusual fish tails. Mermaids can sing wonderfully and, as they say, love to lure sailors to the seabed with their sweet voice and enchanting beauty. But most of all, like all girls, mermaids love games-dress up and choose a new, the most fashionable and stylish outfits!', '', 'https://html5.gamemonetize.com/3fzhcft02zrxnb0nwourethxmtq0bg8f/', 'html5', 500, 800, 1576076683, '1', '0'),
(133, 'gamemonetize-1315', 'drag-racing-club', 'Drag Racing Club', 'https://img.gamemonetize.com/bxtkxihg5nyvyvd1840yd67ko0g84ojg/512x384.jpg', '0', 2, 0, '0', 'Enter the thrilling world of street drag racing in this unique game. Start as an unknown outsider and race your way to the top. Prove everyone that you&#039;re the best racer in the city. To achieve that, you will have to buy or win great cars from your opponents. Then tune them up into powerful racing machines. Drive on!', '', 'https://html5.gamemonetize.com/bxtkxihg5nyvyvd1840yd67ko0g84ojg/', 'html5', 800, 600, 1576076683, '1', '1'),
(134, 'gamemonetize-1314', 'stickman-sniper-3', 'Stickman Sniper 3', 'https://img.gamemonetize.com/46umfc49bzgl2nf80gm60x2r7puy2746/512x384.jpg', '0', 9, 0, '0', 'Take down all of your targets in this fun online stickman sniper game.', '', 'https://html5.gamemonetize.com/46umfc49bzgl2nf80gm60x2r7puy2746/', 'html5', 800, 600, 1576076683, '1', '0'),
(135, 'gamemonetize-1313', 'line-color-3d', 'Line Color 3D', 'https://img.gamemonetize.com/eehn9vpi76cx2z12rweps8270t1t3i9h/512x384.jpg', '0', 9, 0, '0', 'Tap and hold to paint the road. Can you paint all the way to finish line?', '', 'https://html5.gamemonetize.com/eehn9vpi76cx2z12rweps8270t1t3i9h/', 'html5', 800, 600, 1576076683, '1', '0'),
(136, 'gamemonetize-1312', 'train-taxi', 'Train Taxi', 'https://img.gamemonetize.com/r6ozr2cc8zsis1lzyarlf54rv9lcncye/512x384.jpg', '0', 9, 0, '0', 'Collect all the people to complete a level. The more passengers you have, the longer the train gets! Be aware of your tail, avoid the crash!', '', 'https://html5.gamemonetize.com/r6ozr2cc8zsis1lzyarlf54rv9lcncye/', 'html5', 800, 600, 1576076683, '1', '0'),
(137, 'gamemonetize-1311', 'jungle-temple-blast', 'Jungle Temple Blast', 'https://img.gamemonetize.com/0mmgwzl3f2oq7l2yvc6ng7pue8hiq0qq/512x384.jpg', '0', 4, 0, '0', 'Hidden deep in the jungle stands an ancient structure known among explorers as the Crystal Temple. Stories say it holds an unimaginable trove of gems and jewels - but only the best puzzle solvers can help themselves to its riches. Blast your way through hundreds of clever match 3 puzzles, crush gems and jewels, explore the secret jungle temple and recover ancient riches in this exciting treasure hunt adventure!', '', 'https://html5.gamemonetize.com/0mmgwzl3f2oq7l2yvc6ng7pue8hiq0qq/', 'html5', 450, 750, 1576076683, '1', '0'),
(138, 'gamemonetize-1310', 'popstar-girls-dress-up', 'PopStar Girls Dress Up', 'https://img.gamemonetize.com/iebl0jtxrcqviro82wcvre785kn4qri8/512x384.jpg', '0', 4, 0, '0', 'Show off your pop star style in this fun makeup and dress up game where you’re the STAR! It’s time to dress up the pop star for a huge show! Start with your famous fashion doll and take her to the spa where you can give her a facial. Cleanse, exfoliate, tone and moisturize her skin to make her glow. Pamper her with all natural oils and luxurious body treatments. It’s a day at the spa fit for a queen!', '', 'https://html5.gamemonetize.com/iebl0jtxrcqviro82wcvre785kn4qri8/', 'html5', 500, 750, 1576076683, '1', '0'),
(139, 'gamemonetize-1309', 'city-metro-bus-simulator', 'City Metro Bus Simulator', 'https://img.gamemonetize.com/qz5wes51mnvpjm5x83fbdcnw866zm3rc/512x384.jpg', '0', 2, 0, '0', 'You are a bus driver and you have to do your job by dropping off the passengers in every bus station they need, you can drive in the city or country side. Features • Multiple bus skins • 2 environments • Multiple levels', '', 'https://html5.gamemonetize.com/qz5wes51mnvpjm5x83fbdcnw866zm3rc/', 'html5', 960, 540, 1576076683, '1', '0'),
(140, 'gamemonetize-1308', 'rings-fall', 'Rings Fall', 'https://img.gamemonetize.com/6r6en2r2e549cr8g0mozm0ztj9s76ulc/512x384.jpg', '0', 4, 0, '0', 'Interesting arcade game, throw off all the rings in the goal, it can be difficult, you need to think, but the game only becomes more interesting with each level.', '', 'https://html5.gamemonetize.com/6r6en2r2e549cr8g0mozm0ztj9s76ulc/', 'html5', 350, 750, 1576076683, '1', '0'),
(141, 'gamemonetize-1307', 'unicorn-dress-up-girls', 'Unicorn Dress Up Girls', 'https://img.gamemonetize.com/b6g6z3xfd2olm2rxknd1gr03csa6upb5/512x384.jpg', '0', 1, 0, '0', 'A unicorn is a fabulous horse with a horn on its head. In our new game about unicorns you can dress up 8 magic horses in wonderful outfits. Unicorns vary in color and character, so each unicorn needs its own special outfit! Get a real beauty salon with Pets-unicorns.', '', 'https://html5.gamemonetize.com/b6g6z3xfd2olm2rxknd1gr03csa6upb5/', 'html5', 500, 800, 1576076683, '1', '0'),
(142, 'gamemonetize-1306', 'my-little-pony-unicorn-dress-up', 'My Little Pony Unicorn Dress Up', 'https://img.gamemonetize.com/en1s5wvzuu97bxfkery96ziy8ql2ei6s/512x384.jpg', '0', 4, 0, '0', 'If you love to dress up games and make up games, then come see these rainbow pony unicorn who are just waiting for amazing makeovers and new wonderful dressups! How should these unicorn look: fancy, stylish, royal, casual? Show your fashion talent and your sence fashionista to create the best outfit for each Little Pony Unicorn in our new makeover game.', '', 'https://html5.gamemonetize.com/en1s5wvzuu97bxfkery96ziy8ql2ei6s/', 'html5', 500, 750, 1576076683, '1', '0'),
(143, 'gamemonetize-1305', 'panda-commander-air-combat', 'Panda Commander Air Combat', 'https://img.gamemonetize.com/teqj2rn3a0f4vf2u51tqabgp2qfbrz7k/512x384.jpg', '0', 4, 0, '0', 'General Panda! We’re in danger, you’re our only hope! Your mission is to kill all the monster air force and return safe to the base.', '', 'https://html5.gamemonetize.com/teqj2rn3a0f4vf2u51tqabgp2qfbrz7k/', 'html5', 540, 720, 1576076683, '1', '0'),
(144, 'gamemonetize-1304', 'superbike-slide', 'Superbike Slide', 'https://img.gamemonetize.com/t2ygbvo4twe69g24qk9yul67a6sg45hy/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of the superbike. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/t2ygbvo4twe69g24qk9yul67a6sg45hy/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(145, 'gamemonetize-1303', 'candy-xmas', 'Candy Xmas', 'https://img.gamemonetize.com/245cr0kjwz25n4ogqrq0d1wb6oeqjevm/512x384.jpg', '0', 4, 0, '0', 'Xmas is coming. Santa need candys for childrens. Help Santa to collect more candys to all childrens but be carefull, snow Yeti keep that candys for them. Good luck!', '', 'https://html5.gamemonetize.com/245cr0kjwz25n4ogqrq0d1wb6oeqjevm/', 'html5', 1280, 720, 1576076683, '1', '0'),
(146, 'gamemonetize-1302', 'cute-gnomes-hidden-stars', 'Cute Gnomes Hidden Stars', 'https://img.gamemonetize.com/ev2voyp2jjlvxy8fabi2guafra41o9j2/512x384.jpg', '0', 5, 0, '0', 'Cute Gnomes Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/ev2voyp2jjlvxy8fabi2guafra41o9j2/', 'html5', 1280, 720, 1576076683, '1', '0'),
(147, 'gamemonetize-1301', 'cube-adventures', 'cube adventures', 'https://img.gamemonetize.com/e19zubojvqkf2pmc5j2i6va8iib7l170/512x384.jpg', '0', 5, 0, '0', 'CUBE ADVENTURES is a 3D adventure game in which you must travel a world full of candies and collect them all to be happy but for this you must overcome a series of obstacles and solve the occasional puzzle to reach the goal. Some candies will be harder to catch than others, the most important thing is that you don&#039;t fall into a vacuum so you don&#039;t die.', '', 'https://html5.gamemonetize.com/e19zubojvqkf2pmc5j2i6va8iib7l170/', 'html5', 800, 600, 1576076683, '1', '0'),
(148, 'gamemonetize-1300', 'flying-santa-gifts', 'Flying Santa Gifts', 'https://img.gamemonetize.com/vjlu0uqxjdunj748tipo2x1gxsi7vgmq/512x384.jpg', '0', 5, 0, '0', 'Flying Santa gifts is a single touch-based game. In which you just need to drag flying Santa and collect as many gifts as you can. Just beware of evil enemies. While flying collecting gifts you will get some powers like magnet and shield. Use them to make your own high score.', '', 'https://html5.gamemonetize.com/vjlu0uqxjdunj748tipo2x1gxsi7vgmq/', 'html5', 1260, 720, 1576076683, '1', '0'),
(149, 'gamemonetize-1299', 'geometry-rash-challenge', 'Geometry Rash Challenge', 'https://img.gamemonetize.com/fnrod7u7vn6tkzhtipmt7yq95y745cul/512x384.jpg', '0', 4, 0, '0', 'Geometry Rush Challenge is an online game that you can play for free. Your objective is to go through all obstacles, collect as many stars as possible and hit its finish line. Shop new characters when collecting a stars. Have fun', '', 'https://html5.gamemonetize.com/fnrod7u7vn6tkzhtipmt7yq95y745cul/', 'html5', 1280, 720, 1576076683, '1', '0'),
(150, 'gamemonetize-1298', 'zombinators', 'Zombinators', 'https://img.gamemonetize.com/44r77e6a2s6lvd2qokv5uoecbffj0094/512x384.jpg', '0', 2, 0, '0', 'In troubled times, when the Earth is exposed to global catastrophes, all people try to protect themselves by any means available. In the game Zombinators you will get to our planet in the terrible period of the spread of the zombie virus. It was artificially created in secret underground laboratories, but could not be kept. A spooky virus escaped to the surface began to infect people. The cities are empty, the streets are not visible to the townspeople, only the green zombies are wandering about in search of a victim. Healthy people have to risk their lives to get to the store. Our character i', '', 'https://html5.gamemonetize.com/44r77e6a2s6lvd2qokv5uoecbffj0094/', 'html5', 854, 600, 1576076683, '1', '0'),
(151, 'gamemonetize-1297', 'fz-pixel-jumper', 'FZ Pixel Jumper', 'https://img.gamemonetize.com/758ohcjj2plbmr6eynb88t5l59sk2ms9/512x384.jpg', '0', 4, 0, '0', 'FZ Pixel Jumper as high as possible and try not to fall, many obstacles, colorful graphics and many characters with individual abilities. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/758ohcjj2plbmr6eynb88t5l59sk2ms9/', 'html5', 800, 600, 1576076683, '1', '0'),
(152, 'gamemonetize-1296', 'bmw-2-series-puzzle', 'BMW 2-Series Puzzle', 'https://img.gamemonetize.com/7x4dwecdpti6u8rsvq587mvrxjh5nw4v/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: BMW 2-Series Puzzle. All images is with the bmw 2-series. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/7x4dwecdpti6u8rsvq587mvrxjh5nw4v/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(153, 'gamemonetize-1295', 'fishy-differences', 'Fishy Differences', 'https://img.gamemonetize.com/lpqlpmt6vhoyu993b3w96fvejjge34wo/512x384.jpg', '0', 5, 0, '0', 'Fishy Differences is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/lpqlpmt6vhoyu993b3w96fvejjge34wo/', 'html5', 960, 540, 1576076683, '1', '0'),
(154, 'gamemonetize-1294', 'spookiz-jigsaw', 'Spookiz Jigsaw', 'https://img.gamemonetize.com/nm9tnniu16w0p00fgbiivgt25mikdfi1/512x384.jpg', '0', 5, 0, '0', 'Spookiz are popular cartoon where these wacky monsters creep out for their own slapstick adventures. And you can have an adventure while playing this game. Click on the image and choose how hard you wanna play.', '', 'https://html5.gamemonetize.com/nm9tnniu16w0p00fgbiivgt25mikdfi1/', 'html5', 1280, 720, 1576076683, '1', '0'),
(155, 'gamemonetize-1293', 'winter-clash-3d', 'Winter Clash 3D', 'https://img.gamemonetize.com/ya6quof6a1n40xzz3thz9xekh349abp8/512x384.jpg', '0', 3, 0, '0', 'This Christmas the evil elves plan to take over the Santa’s secret place, and summon the evil Baba Yaga, also known as Pagan Idol to this world. Don’t let this happen. Take your gun and impose punishment on all who confront you in a brand new overwhelming team shooter Winter Clash 3D. Take a role of a mighty Santa Clause and capture the Pagan Idol from a deserted lighthouse island, and burn it to ashes in your Christmas fire.', '', 'https://html5.gamemonetize.com/ya6quof6a1n40xzz3thz9xekh349abp8/', 'html5', 1000, 562, 1576076683, '1', '1'),
(156, 'gamemonetize-1292', 'gravity-control', 'Gravity Control', 'https://img.gamemonetize.com/qjgxyoeahnkrbb0rfj0udwwd2imqis38/512x384.jpg', '0', 3, 0, '0', 'Gravity Control is a puzzle platformer where you don&#039;t control the player directly but indirectly by changing the gravity direction. Guide the player to the wormhole that brings you to the next level. There are 60 levels to overcome.', '', 'https://html5.gamemonetize.com/qjgxyoeahnkrbb0rfj0udwwd2imqis38/', 'html5', 800, 600, 1576076683, '1', '0'),
(157, 'gamemonetize-1291', 'grate-cut-slice', 'Grate Cut Slice', 'https://img.gamemonetize.com/5d8l9y6xsbi5a81q67dx8vcnj8ewwpk2/512x384.jpg', '0', 4, 0, '0', 'Here Tap to Grate the Fruits, Vegetables, all Items, Most Satisfying game. Single-player and Multiplayer modes with 100+ Levels. Enjoy the TOP Trending game.', '', 'https://html5.gamemonetize.com/5d8l9y6xsbi5a81q67dx8vcnj8ewwpk2/', 'html5', 450, 750, 1576076683, '1', '0'),
(158, 'gamemonetize-1290', 'super-flight-hero', 'Super Flight Hero', 'https://img.gamemonetize.com/d08323oqpmy96g8t8446088edj71pee3/512x384.jpg', '0', 4, 0, '0', 'Get ready to fly through the sky, face monsters and gain superpowers. Super Flight Hero is a fun jumping and flying game, your mission is to achieve the highest possible score by defeating all monsters and by passing obstacles. [SUPER POWERS] Try to catch all the super powers for the Super Hero to get stronger with invincibility, super leap, firepower and others.', '', 'https://html5.gamemonetize.com/d08323oqpmy96g8t8446088edj71pee3/', 'html5', 800, 450, 1576076683, '1', '0'),
(159, 'gamemonetize-1289', 'tennis-championship', 'Tennis Championship', 'https://img.gamemonetize.com/kf4yksc266yafcdl02xoxwiq71gf6fbr/512x384.jpg', '0', 8, 0, '0', 'Mini Tennis 3D is a mouse-controlled tennis game with a tournament-style competition. If you don’t want to deal with any settings, you can simply start playing right away. Your objective will be to win every match!', '', 'https://html5.gamemonetize.com/kf4yksc266yafcdl02xoxwiq71gf6fbr/', 'html5', 800, 600, 1576076683, '1', '0'),
(160, 'gamemonetize-1288', 'farm-heroes-saga', 'Farm Heroes Saga', 'https://img.gamemonetize.com/2x9ow1a1omne0pm0n7153987rud7ut8w/512x384.jpg', '0', 5, 0, '0', 'Farm Heroes Saga, Head on down to the farm and find out if you can match up all of these very cool veggies.', '', 'https://html5.gamemonetize.com/2x9ow1a1omne0pm0n7153987rud7ut8w/', 'html5', 800, 600, 1576076683, '1', '1'),
(161, 'gamemonetize-1287', 'tractor-mania', 'Tractor Mania', 'https://img.gamemonetize.com/0ndhkhnwm3xovngzxu4oosncsy1m5zj6/512x384.jpg', '0', 2, 0, '0', 'Farm Tractor Hill Racing is new super easy farm racing game! Race with cool tractor and enjoy hill climb racing!', '', 'https://html5.gamemonetize.com/0ndhkhnwm3xovngzxu4oosncsy1m5zj6/', 'html5', 800, 600, 1576076683, '1', '0'),
(162, 'gamemonetize-1286', 'kawaii-high-school-teacher-dress-up', 'Kawaii High School Teacher Dress Up', 'https://img.gamemonetize.com/17a6uq0nnqijo58u2cl099hvs8gkuckv/512x384.jpg', '0', 4, 0, '0', 'In Kawaii High School Teacher Dress Up you can design the Asian teacher&#039;s college uniform as well as casual outfits and many other, for different occasions. 8 high-detail backgrounds will define the setting. Choose from 4 skin colors, pick facial features and makeup, then rummage through the vast selection of fashionable garments to train your fashion designer skills.', '', 'https://html5.gamemonetize.com/17a6uq0nnqijo58u2cl099hvs8gkuckv/', 'html5', 500, 750, 1576076683, '1', '0'),
(163, 'gamemonetize-1285', 'gold-miner-jack', 'Gold Miner Jack', 'https://img.gamemonetize.com/v6cdutjcdxh525bpn3xmdauguub66z02/512x384.jpg', '0', 4, 0, '0', 'Jack heard that gold miner can be very rich, he is so excited and decides to be a gold miner too! But he doesn&#039;t know how to do this job, help him aim the gold and avoid those stones. It&#039;s all depend on you whether he can become rich. Have fun!', '', 'https://html5.gamemonetize.com/v6cdutjcdxh525bpn3xmdauguub66z02/', 'html5', 800, 450, 1576076683, '1', '0'),
(164, 'gamemonetize-1284', 'anime-girl-fashion-dress-up-amp-makeup', 'Anime Girl Fashion Dress Up &amp; Makeup', 'https://img.gamemonetize.com/h2w2xyezqmknv397m90zoi58299h5bpm/512x384.jpg', '0', 4, 0, '0', 'If you are both a fashionista and a fan of Japan and asian pop culture of anime comics, this new beauty &amp; styling app is for you. Design amazing outfits for cute animatronic characters drawn in manga style. Start with make-up for the beautiful virtual girl, then pick a fancy hairstyle, the garments and accessories from an awesome selection of 200+ articles.', '', 'https://html5.gamemonetize.com/h2w2xyezqmknv397m90zoi58299h5bpm/', 'html5', 500, 750, 1576076683, '1', '0'),
(165, 'gamemonetize-1283', 'galactic-car-stunts', 'Galactic Car Stunts', 'https://img.gamemonetize.com/gylgd0ter5t4hmlzzicwoscvbimfuz3a/512x384.jpg', '0', 2, 0, '0', 'Fasten your seatbelt and get prepared to fly with your car up in space in the most amazing stunts. Features • Multiple cars • Multiple levels', '', 'https://html5.gamemonetize.com/gylgd0ter5t4hmlzzicwoscvbimfuz3a/', 'html5', 960, 540, 1576076683, '1', '0'),
(166, 'gamemonetize-1282', 'car-traffic-sim', 'Car Traffic Sim', 'https://img.gamemonetize.com/su206jbvo10ines32pg2bv1zrco0594y/512x384.jpg', '0', 2, 0, '0', 'Car Traffic Sim is a realistic driving game, you have a busy street with many cars and you have to take your fuel or driving under the pressure of time, if you want to be relaxed you have endless road and complete freedom to drive. Be careful and avoid to collide with the other cars. Features • 3 game modes • Multiple levels to acomplish • Good graphics • Realistic gameplay', '', 'https://html5.gamemonetize.com/su206jbvo10ines32pg2bv1zrco0594y/', 'html5', 960, 540, 1576076683, '1', '0'),
(167, 'gamemonetize-1281', 'princesses-crazy-about-black-friday', 'Princesses Crazy About Black Friday', 'https://img.gamemonetize.com/vphdbl1fs227jgkkoewzq6w6jglep4il/512x384.jpg', '0', 1, 0, '0', 'Hooray! “Black Friday” has arrived. Princesses are in a hurry to sell. Eliza is a famous fashionista. She goes to the boutique in order to find discounts on fashionable dresses. Princess Elen loves accessories. Now is the time to pick up a handbag, glasses and cosmetics. Marmaid is a sweet tooth; she cannot resist discounts in an ice cream parlor. Well, Jacqueline prefers online shopping. She is pleased to purchase a new gadget at a great discount. Help the princesses find their favorite items on sale, because Princesses crazy about Black Friday!', '', 'https://html5.gamemonetize.com/vphdbl1fs227jgkkoewzq6w6jglep4il/', 'html5', 800, 600, 1576076683, '1', '0'),
(168, 'gamemonetize-1280', 'leap-and-jump', 'Leap and Jump', 'https://img.gamemonetize.com/0gubk7cuex9dtqdki74qnhaxzfrig7rh/512x384.jpg', '0', 4, 0, '0', 'You are running on the dangerous place. There will be many dangerous obstacles and useful tools to make you run more difficult and longer. So why not have a try? Good luck!', '', 'https://html5.gamemonetize.com/0gubk7cuex9dtqdki74qnhaxzfrig7rh/', 'html5', 720, 1280, 1576076683, '1', '0'),
(169, 'gamemonetize-1279', 'city-defender', 'City Defender', 'https://img.gamemonetize.com/twrai09v5vxeqz75ew5zxfnh3upmhlcb/512x384.jpg', '0', 3, 0, '0', 'You play as a tank that have to defend your city against invaders who are trying to bomb it. Bombs are dropping down and you have to shoot and destroy them before they reach the ground. Bombs have different speed and you have to shoot the faster ones first. If a bomb reaches the ground, you will lose one life and you will lose the game when you run out of lives.', '', 'https://html5.gamemonetize.com/twrai09v5vxeqz75ew5zxfnh3upmhlcb/', 'html5', 800, 600, 1576076683, '1', '0'),
(170, 'gamemonetize-1278', 'memory-christmas-challenge', 'Memory Christmas Challenge', 'https://img.gamemonetize.com/k72b16lg30dg1ppu58r28q91vguovz1g/512x384.jpg', '0', 5, 0, '0', 'This game tests and challenges your memory! In each level, 12 cards (6 images in total) are shown to you for a few seconds and then they are turned to their back and you have to match cards with the same image with each other. But you have to be quick because there is a time limit in each level and if you run out of time, you will lose. As you progress through the game, your time in each level will decrease and so the game will become more difficult. It has unlimited number of levels and your aim is to complete as many level as you can and earn more score. There are 63 images in this game in t', '', 'https://html5.gamemonetize.com/k72b16lg30dg1ppu58r28q91vguovz1g/', 'html5', 950, 530, 1576076683, '1', '0'),
(171, 'gamemonetize-1277', 'christmas-vehicles-hidden-keys', 'Christmas Vehicles Hidden Keys', 'https://img.gamemonetize.com/v8m46zr1ptjjwdwel4o91xw0cuyml9bh/512x384.jpg', '0', 5, 0, '0', 'Christmas Vehicles Hidden Keys is a free online Christmas and hidden object game. Find out the hidden keys in the specified images. Each level has 10 hidden keys. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/v8m46zr1ptjjwdwel4o91xw0cuyml9bh/', 'html5', 960, 540, 1576076683, '1', '0'),
(172, 'gamemonetize-1276', 'save-the-santa', 'Save the Santa', 'https://img.gamemonetize.com/pv415t1ikycumwh4pgdrkr929bx2o6xe/512x384.jpg', '0', 5, 0, '0', 'Save the Santa is a physics puzzle game. In this game, you must help Santa Claus to reach the ground by destroying ice cubes that are beneath his feet. This game has 20 levels and all graphical elements of the game can be easily changed', '', 'https://html5.gamemonetize.com/pv415t1ikycumwh4pgdrkr929bx2o6xe/', 'html5', 800, 600, 1576076683, '1', '0'),
(173, 'gamemonetize-1275', 'crazy-monster-trucks-difference', 'Crazy Monster Trucks Difference', 'https://img.gamemonetize.com/go3lk7n75b7uq8kdd5m7dfq5j2lhs8f9/512x384.jpg', '0', 5, 0, '0', 'Crazy Monster Trucks Difference is an online game that you can play for free. Do you have a keen insight? Play the game Crazy Monster Trucks Difference to have a test. The two images about the monster trucks are very similar. However, there are five differences between them. Good luck!', '', 'https://html5.gamemonetize.com/go3lk7n75b7uq8kdd5m7dfq5j2lhs8f9/', 'html5', 960, 540, 1576076683, '1', '0'),
(174, 'gamemonetize-1274', 'christmas-coloring-book', 'Christmas Coloring Book', 'https://img.gamemonetize.com/retc6t9dnu7vroxptaub0b67x2wdyv9p/512x384.jpg', '0', 5, 0, '0', 'In this Christmas coloring game you can choose your favorite image and to coloring it. Start to color the image as you want. Choose your favorite colors and color this Christmas in your way.', '', 'https://html5.gamemonetize.com/retc6t9dnu7vroxptaub0b67x2wdyv9p/', 'html5', 1280, 720, 1576076683, '1', '0'),
(175, 'gamemonetize-1273', 'basketball-master', 'Basketball Master', 'https://img.gamemonetize.com/zzyslce7s2i01wotz4rrtls0j1gz9np9/512x384.jpg', '0', 8, 0, '0', 'The challenge for real basketball and streetball players! Jump with the ball and shoot the basket within the time limit. Reach the highest score and collect coins. Unlock all balls and locations. Try 2 game modes. You need precise timing, good aiming and a bit of luck.', '', 'https://html5.gamemonetize.com/zzyslce7s2i01wotz4rrtls0j1gz9np9/', 'html5', 600, 800, 1576076683, '1', '0'),
(176, 'gamemonetize-1272', 'zombie-massacre', 'Zombie Massacre', 'https://img.gamemonetize.com/td0f69t6s6x6opcenflbd1iqi87zqerk/512x384.jpg', '0', 3, 0, '0', 'Zombies are invading the wild west! Grab your guns and protect innocent people from those pesky lifeless folk. Help them and they will help you back! You have to master and upgrade your guns to survive. You can hire companions and escorts, equip yourself with medikits, ammunition and adrenaline. Many types of zombies are attacking! How long will you survive?', '', 'https://html5.gamemonetize.com/td0f69t6s6x6opcenflbd1iqi87zqerk/', 'html5', 800, 600, 1576076683, '1', '0'),
(177, 'gamemonetize-1271', 'warfare-area', 'Warfare Area', 'https://img.gamemonetize.com/3fnk3e4rstcjsqolnpx158fe8ptp74eb/512x384.jpg', '0', 3, 0, '0', 'It&#039;s war and enemies have captured your base. You are the last soldier from your troop in the base so only you can fight it back. Take the rifle and get ready for the battle.', '', 'https://html5.gamemonetize.com/3fnk3e4rstcjsqolnpx158fe8ptp74eb/', 'html5', 800, 450, 1576076683, '1', '0'),
(178, 'gamemonetize-1270', 'super-drift-3d', 'Super Drift 3D', 'https://img.gamemonetize.com/7cw38ely978i4wa5n6vto8ixhqb0detk/512x384.jpg', '0', 2, 0, '0', 'Take it to the track in the super car of your choice. Customize your car and race! Do well and earn stars that you can use to unlock other cars!', '', 'https://html5.gamemonetize.com/7cw38ely978i4wa5n6vto8ixhqb0detk/', 'html5', 800, 600, 1576076683, '1', '0'),
(179, 'gamemonetize-1269', 'anime-fantasy-rpg-dress-up', 'Anime Fantasy RPG Dress Up', 'https://img.gamemonetize.com/kciq011y46z6tmfbsgjkeydwsyqmejtz/512x384.jpg', '0', 4, 0, '0', 'Do you like manga or anime girl dress up games? Sure you do! And what&#039;s you&#039;ve really missed is fantasy anime dress up in a Role Playing Games style! 6 cute anime girls are looking for a good RPG fan to dress them up!', '', 'https://html5.gamemonetize.com/kciq011y46z6tmfbsgjkeydwsyqmejtz/', 'html5', 500, 750, 1576076683, '1', '0'),
(180, 'gamemonetize-1268', '2048-legend', '2048 Legend', 'https://img.gamemonetize.com/iqv0wswiozpaxs6s7rdtqdj24ibdrgsa/512x384.jpg', '0', 5, 0, '0', '2048 is a simple game where you add up numbers. That&#039;s it. Although, it&#039;s not as easy as it seems. It can prove to be quite a challenge. If you don&#039;t already know this classic, then you&#039;re in for a treat! Are you ready to test your wit and get as much score as possible? Then what are you waiting for? Go on and play it!', '', 'https://html5.gamemonetize.com/iqv0wswiozpaxs6s7rdtqdj24ibdrgsa/', 'html5', 600, 800, 1576076683, '1', '0'),
(181, 'gamemonetize-1267', 'neon-painter', 'Neon Painter', 'https://img.gamemonetize.com/rcu0yjmimamunjfg7v4j5hljeuw1k24b/512x384.jpg', '0', 5, 0, '0', 'A new revolution in puzzle games. Can you find the thing hidden in the neon? Use the neon water and swipe controls to move the water through the object and try to complete it. Try to find different shapes with 300+ levels. You will have fun with the Christmas theme &quot;Neon Painter&quot;.', '', 'https://html5.gamemonetize.com/rcu0yjmimamunjfg7v4j5hljeuw1k24b/', 'html5', 720, 1280, 1576076683, '1', '0'),
(182, 'gamemonetize-1266', 'pyramid-tower-puzzle', 'Pyramid Tower Puzzle', 'https://img.gamemonetize.com/iitpq4wmj3du0b40f7nm7pv1g5fztrsc/512x384.jpg', '0', 5, 0, '0', 'Are you ready to have fun while learning? Can you sort the puzzle cubes from block A to block C in order of size? You will not understand how time passes while playing this game that requires attention and thought. Get ready for brain training with different levels.', '', 'https://html5.gamemonetize.com/iitpq4wmj3du0b40f7nm7pv1g5fztrsc/', 'html5', 900, 600, 1576076683, '1', '0'),
(183, 'gamemonetize-1265', 'angry-ork', 'Angry Ork', 'https://img.gamemonetize.com/53xnmv6zwwm44rn7zg8g5ngp5jcv6z3c/512x384.jpg', '0', 5, 0, '0', 'Angry Ork is a fun puzzle physics game of action. Launch your skulls at the angry orks but keep in mind you only have 8 tries to try and kill the orks. It will take the right strategy to solve each of the challenging levels so get ready to kill some angry orks and have fun!', '', 'https://html5.gamemonetize.com/53xnmv6zwwm44rn7zg8g5ngp5jcv6z3c/', 'html5', 800, 600, 1576076683, '1', '0'),
(184, 'gamemonetize-1264', 'solitaire-legend', 'Solitaire Legend', 'https://img.gamemonetize.com/2izh2qx25m39748dyh661dursymeh1ij/512x384.jpg', '0', 5, 0, '0', 'Do you remember the times without internet? Passing time playing the same old game on the computer. The classic card sorting game – Solitaire! Everybody knows it, and if not, it&#039;s very easy to learn. There are also unlimited hints and undos at your disposal. And as you collect coins by winning, you can unlock different skins.', '', 'https://html5.gamemonetize.com/2izh2qx25m39748dyh661dursymeh1ij/', 'html5', 800, 600, 1576076683, '1', '0'),
(185, 'gamemonetize-1263', 'jewel-blocks', 'Jewel Blocks', 'https://img.gamemonetize.com/6h80yq62uiqar6jst96wgjdb2bv6khjr/512x384.jpg', '0', 5, 0, '0', 'Train your brain in this addictive logical arcade challenge with classic block shapes! Play endlessly to beat your high score and collect rewards! Easy to learn and fun to master. Also with lots of skins available.', '', 'https://html5.gamemonetize.com/6h80yq62uiqar6jst96wgjdb2bv6khjr/', 'html5', 600, 800, 1576076683, '1', '0'),
(186, 'gamemonetize-1262', 'get-ready-for-halloween', 'Get Ready For Halloween', 'https://img.gamemonetize.com/pj5rozn19e0zszozkbbc89wqhy9epusf/512x384.jpg', '0', 1, 0, '0', 'The best Bffs Mia,Emma and Bella are going to shopping for the upcoming Halloween party. Could you help them to choose best outfits for the Halloween Party? Wish them for the Happy Halloween.', '', 'https://html5.gamemonetize.com/pj5rozn19e0zszozkbbc89wqhy9epusf/', 'html5', 800, 600, 1576076683, '1', '0'),
(187, 'gamemonetize-1261', 'ear-doctor', 'Ear Doctor', 'https://img.gamemonetize.com/81mm6s6qd2mvr7k04u0qmscnun2t1eca/512x384.jpg', '0', 4, 0, '0', 'If you want to become the best ear specialist you are at the right place Do not move Start treatment as the most famous ear doctor in this great game Ear Doctor', '', 'https://html5.gamemonetize.com/81mm6s6qd2mvr7k04u0qmscnun2t1eca/', 'html5', 450, 750, 1576076683, '1', '0'),
(188, 'gamemonetize-1260', 'assault-fury', 'Assault Fury', 'https://img.gamemonetize.com/4genqjou76k2edgbmqvj9692cat382kd/512x384.jpg', '0', 3, 0, '0', 'Soldier, you’re under attack! The enemy troops have defeated the majority of our soldiers and surrounded you. Use your weapons and try to escape. You can use different objects that surrounds you (oil cans) as a weapon against the enemy or to hide. Fight! Features • Multiple weapons • 40 levels • Multiple npc types • Upgrade system', '', 'https://html5.gamemonetize.com/4genqjou76k2edgbmqvj9692cat382kd/', 'html5', 960, 600, 1576076683, '1', '0'),
(189, 'gamemonetize-1259', 'monster-truck-rally', 'Monster Truck Rally', 'https://img.gamemonetize.com/hphlgf6n4b8u62u28grxlmt8fscrhmay/512x384.jpg', '0', 2, 0, '0', 'Monster Truck Racer is a 3D game where you will find awesome monsters trucks, challenging races and offroad tracks. Choose your monster truck, enjoy the race and have fun. Features • 3 game modes • Multiple levels • Multiple monster truck skins', '', 'https://html5.gamemonetize.com/hphlgf6n4b8u62u28grxlmt8fscrhmay/', 'html5', 960, 540, 1576076683, '1', '0'),
(190, 'gamemonetize-1258', 'vegas-crime-city', 'Vegas Crime City', 'https://img.gamemonetize.com/55n0nnfl3la813jt63v77p408kslcfdi/512x384.jpg', '0', 3, 0, '0', 'Are you ready to enter the crime city? The big battle begins with gangs in San Andreas. A realistic game like a GT. Welcome to the Vegas crime town. Vegas gangster city brings you a real street of vegas. Play a gangster, advance in vegas city.', '', 'https://html5.gamemonetize.com/55n0nnfl3la813jt63v77p408kslcfdi/', 'html5', 960, 640, 1576076683, '1', '0'),
(191, 'gamemonetize-1257', 'romantic-anime-couples-dress-up', 'Romantic Anime Couples Dress Up', 'https://img.gamemonetize.com/3ete0he6xcuh5gk2gjj8vswvj6eqzf42/512x384.jpg', '0', 4, 0, '0', 'Make the lovers look adorable on their romantic date! They had a crush on each other in high school, and they are still in love after graduation. They will have a wedding soon! It will be so much fun to pick a wedding dress and all those important accessories which comprise a fancy bridal outfit. In her diary the girl already dreams about the wedding party, the honeymoon (with a romantic world tour!) and the future marriage life.', '', 'https://html5.gamemonetize.com/3ete0he6xcuh5gk2gjj8vswvj6eqzf42/', 'html5', 500, 750, 1576076683, '1', '0')";
$db[18] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(192, 'gamemonetize-1256', 'city-bus-driver', 'City Bus Driver', 'https://img.gamemonetize.com/afw50rmkfj0v5061jcfdf7z05eca4wxe/512x384.jpg', '0', 2, 0, '0', 'Enjoy a real bus simulator where you have to take your job seriously, all you have to do is to pick passengers from bus station, drop them at the end point, always try to use different camera angles and be careful, don’t hit with the traffic and passengers. Features • Multiple levels • Multiple bus skins • Bus store', '', 'https://html5.gamemonetize.com/afw50rmkfj0v5061jcfdf7z05eca4wxe/', 'html5', 960, 600, 1576076683, '1', '0'),
(193, 'gamemonetize-1255', 'bentley-flying-spur-puzzle', 'Bentley Flying Spur Puzzle', 'https://img.gamemonetize.com/9mf9sl0x9msu601go0l3hzxje0ic8lth/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Bentley Flying Spur Puzzle. All images is with the bentler flying spur. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/9mf9sl0x9msu601go0l3hzxje0ic8lth/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(194, 'gamemonetize-1254', 'car-stunt-driver', 'Car Stunt Driver', 'https://img.gamemonetize.com/6stwp4ao05o39lbea0e39wqd9zlrkv1q/512x384.jpg', '0', 2, 0, '0', 'Car Stunt Driver is a challenging 3D car stunt simulation game. Keeping your car on track on a road full of obstacles will not be that easy and it will test all your driving skills. Features: • Multiple cars • Multiple challenging levels', '', 'https://html5.gamemonetize.com/6stwp4ao05o39lbea0e39wqd9zlrkv1q/', 'html5', 960, 600, 1576076683, '1', '0'),
(195, 'gamemonetize-1253', 'merge-hit-weapons', 'Merge Hit Weapons', 'https://img.gamemonetize.com/s3iyol9izo3f8kyglpnrl2u49vsfttql/512x384.jpg', '0', 1, 0, '0', 'Merge Hit Weapons is a challenging knife throwing game where you have to merge the weapons and create new ones in order to defeat the evil planets. Be careful not to run out of ammo! Features: • Weapon upgrades • Multiple levels • Challenging and addictive gameplay', '', 'https://html5.gamemonetize.com/s3iyol9izo3f8kyglpnrl2u49vsfttql/', 'html5', 480, 768, 1576076683, '1', '0'),
(196, 'gamemonetize-1252', 'christmas-memory-challenge', 'Christmas Memory Challenge', 'https://img.gamemonetize.com/w8hl1b2wd82rijm5f1toqtbnn4wux8ru/512x384.jpg', '0', 5, 0, '0', 'Concentration has always been popular because you can play it on many different levels, and always challenge yourself to do better next time', '', 'https://html5.gamemonetize.com/w8hl1b2wd82rijm5f1toqtbnn4wux8ru/', 'html5', 800, 600, 1576076683, '1', '0'),
(197, 'gamemonetize-1251', 'eliza-dawn-of-frost-magic', 'Eliza - Dawn of Frost Magic', 'https://img.gamemonetize.com/p0zbam6lnqgoh11ml8midop5c79wv1jl/512x384.jpg', '0', 1, 0, '0', 'Young Princess Eliza sets off on an adventure. She is helped by a sister and a magical snowman. Let&#039;s join this amazing journey. Play a fun game first - guess what objects or characters the snowman represents. Now you need to dress up and you can hit the road. Choose outfits, hairstyles and accessories for Eliza and her sister. Pay attention to their new hiking style!', '', 'https://html5.gamemonetize.com/p0zbam6lnqgoh11ml8midop5c79wv1jl/', 'html5', 800, 600, 1576076683, '1', '0'),
(198, 'gamemonetize-1250', 'surfer-bus', 'Surfer Bus', 'https://img.gamemonetize.com/4oyt28u6jluujageun20s197kgluh2um/512x384.jpg', '0', 2, 0, '0', 'Did you ever think how hard is to drive a bus on sand? Now you can give it a try in Water Surfer Bus where you are driving on a beach and you can surf with your bus on water. Have fun! Features • Multiple levels • Multiple bus models', '', 'https://html5.gamemonetize.com/4oyt28u6jluujageun20s197kgluh2um/', 'html5', 960, 600, 1576076683, '1', '0'),
(199, 'gamemonetize-1249', 'christmas-2019-match-3', 'Christmas 2019 Match 3', 'https://img.gamemonetize.com/iuqocoz2kpixxezpnkv4mex01x4t7bhq/512x384.jpg', '0', 5, 0, '0', 'Christmas 2019 Match-3 is a good match-3 games with 16 levels. In each level, you need to clear the dirty cells. Make a column or row of three or more christmas symbols of the same type to make them disappears. You can&#039;t swap the locked symbols. If you match 3 or more symbols with a specific shape you will get special symbol, such as bomb symbol, crump symbol, flash symbol and time symbol. Break all the dirty cells in time to complete the level.', '', 'https://html5.gamemonetize.com/iuqocoz2kpixxezpnkv4mex01x4t7bhq/', 'html5', 800, 600, 1576076683, '1', '0'),
(200, 'gamemonetize-1248', 'fire-truck-jigsaw', 'Fire Truck Jigsaw', 'https://img.gamemonetize.com/uyf9ecn3w8cjrf57onlat04vzfetq0zk/512x384.jpg', '0', 5, 0, '0', 'Try to solve this jigsaw game. Start to play with first image and solve it, than go to the next level and try to finish all levels. Choose in which mode you want to play and enjoy in the game.', '', 'https://html5.gamemonetize.com/uyf9ecn3w8cjrf57onlat04vzfetq0zk/', 'html5', 1280, 720, 1576076683, '1', '0'),
(201, 'gamemonetize-1247', 'christmas-tap-tap', 'Christmas tap tap', 'https://img.gamemonetize.com/uwvaqvunuttemjb670viiql41dknfo99/512x384.jpg', '0', 4, 0, '0', 'Get as many stars as possible to beat your record.', '', 'https://html5.gamemonetize.com/uwvaqvunuttemjb670viiql41dknfo99/', 'html5', 512, 300, 1576076683, '1', '0'),
(202, 'gamemonetize-1246', 'santa-ski', 'Santa Ski', 'https://img.gamemonetize.com/2dkzcj3s7gro267qwbsc4441hp8x5im8/512x384.jpg', '0', 4, 0, '0', 'So Christmas is here and a xmas cannot be celebrated without playing santa&#039;s game. Here we come with another cool new game Santa Ski. Get your skis ice skates snowboard and Make your records on the ice. Added some cool swings for more fun. Just tap on purple and yellow strips to make scoreTap and hold for power booster. Do play tutorial mode to understand gameplay', '', 'https://html5.gamemonetize.com/2dkzcj3s7gro267qwbsc4441hp8x5im8/', 'html5', 740, 1136, 1576076683, '1', '0'),
(203, 'gamemonetize-1245', 'bts-rabbit-coloring-book', 'BTS Rabbit Coloring Book', 'https://img.gamemonetize.com/16c0slvg2o9fv8j8m7ejvy1lk1ikp5br/512x384.jpg', '0', 5, 0, '0', 'Bts Rabbit Coloring Book is an online game that you can play for free. Bts Rabbit Coloring Book is an addictive coloring game for babies and kids. You can play it in any spare time. There are four pictures you can choose and they are all about sweet rabbits. Show us your creation and paint to make these pictures beautiful. Have fun with Bts Rabbit Coloring Book!', '', 'https://html5.gamemonetize.com/16c0slvg2o9fv8j8m7ejvy1lk1ikp5br/', 'html5', 854, 480, 1576076683, '1', '0'),
(204, 'gamemonetize-1244', 'ninja-run', 'Ninja Run', 'https://img.gamemonetize.com/6fatqw4ycespo7uzyv6rkcsd48dwaa0g/512x384.jpg', '0', 5, 0, '0', 'Run as fast as you can! An infinite runner game where the goal is to collect shurikens and avoid the obstacles on the way.Ninja Run is an amazing ninja running and jumping adventure game to play and is an online HTML5 game.Can you help him to do the task? Have fun!', '', 'https://html5.gamemonetize.com/6fatqw4ycespo7uzyv6rkcsd48dwaa0g/', 'html5', 960, 540, 1576076683, '1', '0'),
(205, 'gamemonetize-1243', 'super-buddy-kick-2', 'Super Buddy Kick 2', 'https://img.gamemonetize.com/5619zg9qpx36cf48dkcof8v06wl4q00w/512x384.jpg', '0', 5, 0, '0', 'The most exciting action game is back to help you relieve stress in an unconventional way. Choose from an arsenal of weapons and devices to take out the Buddyman and he’ll respawn when you’re finished. Buddyman acts as an object to concentrate your aggression on without actually causing harm. Give it your best shot.', '', 'https://html5.gamemonetize.com/5619zg9qpx36cf48dkcof8v06wl4q00w/', 'html5', 800, 480, 1576076683, '1', '0'),
(206, 'gamemonetize-1242', 'stickman-gun-shooter-3d', 'Stickman Gun Shooter 3D', 'https://img.gamemonetize.com/55uewxpgw5fg83ahhosllieq3819vzw0/512x384.jpg', '0', 9, 0, '0', 'Warning: contains blood and shooting!! You are a stickman!!!! Kill and snipe the enemy stickmen - you have to strike first or they will kill you! How long will you survive the before you are dead? In this amazing 3D shooter game, there will be everything you ever wanted: Features - Fully 3D stickman and level - Blood!! Lots of Blooood effects! - Ragdoll / physics based death animations - Many Weapons! guns, a shotgun, a machine gun, mp5, m16, ak-47, uzi - Hours of shooting fun! - Lots of death! Instructions - Try to not die for as long as possible! :) Every enemy stickman should fear you, as y', '', 'https://html5.gamemonetize.com/55uewxpgw5fg83ahhosllieq3819vzw0/', 'html5', 1280, 720, 1576076683, '1', '0'),
(207, 'gamemonetize-1241', 'ludo-online', 'Ludo Online', 'https://img.gamemonetize.com/8qdk9clkiv3bzcmbgkh0ehtxwpgzjhjr/512x384.jpg', '0', 7, 0, '0', 'Have fun with friends by playing Ludo Online game. The game has 3 modes: - Vs Bot: Playing against the computer (offline) - Online: Playing with randomly matched people - Private: Playing with your friends. Simply share a private code and connect to each other. Play now!', '', 'https://html5.gamemonetize.com/8qdk9clkiv3bzcmbgkh0ehtxwpgzjhjr/', 'html5', 960, 540, 1576076683, '1', '0'),
(208, 'gamemonetize-1240', 'anime-kawaii-school-girls-dress-up', 'Anime Kawaii School Girls Dress Up', 'https://img.gamemonetize.com/aw6kelln7ybxd3kjrwlab8r7s6shh63r/512x384.jpg', '0', 4, 0, '0', 'Modern street Japanese fashion coming to you with this great colourful animated &quot;dress up&quot; game! 6 cute School Girls of different looks are ready to dress a stylish outfit which is a mixture of styles such as kawaii, daily European fashion, fairy tales, futuristic sci-fi and more. Create anime avatar and picture her!', '', 'https://html5.gamemonetize.com/aw6kelln7ybxd3kjrwlab8r7s6shh63r/', 'html5', 500, 750, 1576076683, '1', '0'),
(209, 'gamemonetize-1239', 'stunt-racers-extreme', 'Stunt Racers Extreme', 'https://img.gamemonetize.com/hkg6zwr4l76syf4otpd1li0d6m75u9gc/512x384.jpg', '0', 2, 0, '0', 'Take it to the track in the super car of your choice. Customize your car and race! Do well and earn stars that you can use to unlock other cars!', '', 'https://html5.gamemonetize.com/hkg6zwr4l76syf4otpd1li0d6m75u9gc/', 'html5', 800, 640, 1576076683, '1', '0'),
(210, 'gamemonetize-1238', 'smart-hand-doctor', 'Smart Hand Doctor', 'https://img.gamemonetize.com/uk98df7hgqgz50tfyxxnepcngl4xd9y8/512x384.jpg', '0', 4, 0, '0', 'Today you’re doctors on a special mission to cure all hand injuries of your clumsy patients! Hand Doctor game offers all an incredible virtual surgery experience that’ll make you feel like real doctor working in a hospital.', '', 'https://html5.gamemonetize.com/uk98df7hgqgz50tfyxxnepcngl4xd9y8/', 'html5', 450, 750, 1576076683, '1', '0'),
(211, 'gamemonetize-1237', 'cs-war-gun-king-fps', 'CS War Gun King FPS', 'https://img.gamemonetize.com/81yx4vhookq71afomip3nhz7jzgib09k/512x384.jpg', '0', 3, 0, '0', 'The game is produced with the unity3d engine and presented to the players in a first-person real-life perspective. Clear city streets, cool gun weapons, and powerful explosion effects all show the vastness and cruelty of the war.', '', 'https://html5.gamemonetize.com/81yx4vhookq71afomip3nhz7jzgib09k/', 'html5', 960, 600, 1576076683, '1', '0'),
(212, 'gamemonetize-1236', 'gangster-city-crime', 'Gangster City Crime', 'https://img.gamemonetize.com/t318hsbrsh6dxkxwzco6j1f291r1z8gt/512x384.jpg', '0', 3, 0, '0', 'You are new in town and you have to find out how things work here so you get involved in some gangsters fights, you have to make yourself clear in this gangs dirty games.If you don’t like to fight you can go for a city ride, there are many cars and motorcycles and you can drive any car you like, with or without a driver. Features • 2 game modes • Multiple levels', '', 'https://html5.gamemonetize.com/t318hsbrsh6dxkxwzco6j1f291r1z8gt/', 'html5', 960, 600, 1576076683, '1', '0'),
(213, 'gamemonetize-1235', 'color-pin', 'Color Pin', 'https://img.gamemonetize.com/j3tiebyw6cv4p3lrh03yhh1p01ql18ol/512x384.jpg', '0', 3, 0, '0', 'Are you bored in work or school? You need to forget daily stress? This simple and colorfull amalgamate of attention, accuracy and correct timing will help. This game is suitable for anyone, especially those who love to overcome challenges with your wits and agility.', '', 'https://html5.gamemonetize.com/j3tiebyw6cv4p3lrh03yhh1p01ql18ol/', 'html5', 600, 800, 1576076683, '1', '0'),
(214, 'gamemonetize-1234', 'indian-cargo-driver', 'Indian Cargo Driver', 'https://img.gamemonetize.com/1jyilfgsoko0ab6ywq8eo2ico205znf1/512x384.jpg', '0', 2, 0, '0', 'You are a cargo driver and you have to deliver safely , to the given destination, the goods you have in your truck. Drive carefully,you can fall off from the road and fail the mission. Features • Multiple levels • Multiple trucks', '', 'https://html5.gamemonetize.com/1jyilfgsoko0ab6ywq8eo2ico205znf1/', 'html5', 960, 540, 1576076683, '1', '0'),
(215, 'gamemonetize-1233', 'bull-racing', 'Bull Racing', 'https://img.gamemonetize.com/qn42kht2x03of1pf8bo38cpaev6etpxj/512x384.jpg', '0', 2, 0, '0', 'Bull Racing is a 3D racing game with a crazy gameplay. Run, collect money and boosters to win the race! Features: • Crazy gameplay • A lot of boosters • Good graphics', '', 'https://html5.gamemonetize.com/qn42kht2x03of1pf8bo38cpaev6etpxj/', 'html5', 960, 600, 1576076683, '1', '0'),
(216, 'gamemonetize-1232', 'sugar-match', 'Sugar Match', 'https://img.gamemonetize.com/0eks867gszt9mozqw60vnaje9jdnb68c/512x384.jpg', '0', 5, 0, '0', 'Match sweet colorful candies and join Bella in her mission to bake the most tasteful cakes in the world for her friends. Features: • Multiple levels • Boosters • Delicious gameplay', '', 'https://html5.gamemonetize.com/0eks867gszt9mozqw60vnaje9jdnb68c/', 'html5', 480, 720, 1576076683, '1', '0'),
(217, 'gamemonetize-1231', 'pick-a-lock', 'Pick a Lock', 'https://img.gamemonetize.com/p9c6nj25nv0h55lgfw6b6rjnjhqbwdmm/512x384.jpg', '0', 4, 0, '0', 'Get ready for popping locks in this simple, yet exciting game! Challenge your senses in this fast-paced madness! Each lock is harder to unlock than the previous one. If you make one mistake you have to start all over again, so be careful! Kill the boredom now and pop some locks!', '', 'https://html5.gamemonetize.com/p9c6nj25nv0h55lgfw6b6rjnjhqbwdmm/', 'html5', 600, 800, 1576076683, '1', '0'),
(218, 'gamemonetize-1230', 'christmas-monster-truck', 'Christmas Monster Truck', 'https://img.gamemonetize.com/qxbvxf7z1d8cytxn4etq8fj6ru98psmg/512x384.jpg', '0', 2, 0, '0', 'Monster truck stunts? No problem. Choose your truck, race, collect all the coins and prove your driving skills. The green light is on! Go! Features: • Christmas theme • Multiple monster trucks • Multiple levels', '', 'https://html5.gamemonetize.com/qxbvxf7z1d8cytxn4etq8fj6ru98psmg/', 'html5', 960, 600, 1576076683, '1', '0'),
(219, 'gamemonetize-1229', 'christmas-maze', 'Christmas Maze', 'https://img.gamemonetize.com/y7ttdq2bpjw15lnbup1ygan6h2rirqgq/512x384.jpg', '0', 5, 0, '0', 'Christmas Maze is an online game that you can play for free. Christmas Maze is a simple but very challenging arcade game. Your only task is to guide the gift box to the green one. Do it and you will enter a new level. During the process, you need to pay more attention to the walls on the road. Have fun and good luck!', '', 'https://html5.gamemonetize.com/y7ttdq2bpjw15lnbup1ygan6h2rirqgq/', 'html5', 854, 480, 1576076683, '1', '0'),
(220, 'gamemonetize-1228', 'tap-tank', 'Tap Tank', 'https://img.gamemonetize.com/v5e1i7chvm1tvz70t3d3rdzvgfq3itld/512x384.jpg', '0', 5, 0, '0', 'In this platform game you need to tap on the screen to change direction of the tank and to collect diamonds. But watch on the boxes, try to avoid them or you will start again from the beginning.', '', 'https://html5.gamemonetize.com/v5e1i7chvm1tvz70t3d3rdzvgfq3itld/', 'html5', 860, 480, 1576076683, '1', '0'),
(221, 'gamemonetize-1227', 'santa-driver-coloring-book', 'Santa Driver Coloring Book', 'https://img.gamemonetize.com/qo6til52bnuurr6xdiwwnxaydjwr5rdw/512x384.jpg', '0', 5, 0, '0', 'Here are the pictures of Santa Claus presented as a driver that you can paint. Player can choose one available picture and freely play with different colours. In this game you can select one of the 10 photos, you also have the option to select some of the shapes you have given in the game itself.', '', 'https://html5.gamemonetize.com/qo6til52bnuurr6xdiwwnxaydjwr5rdw/', 'html5', 960, 540, 1576076683, '1', '0'),
(222, 'gamemonetize-1226', 'bmw-1-series-uk-puzzle', 'BMW 1-Series UK Puzzle', 'https://img.gamemonetize.com/2nb9jxiry62zhocchebwgxd5s7p9k78n/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: BMW 1-Series UK Puzzle. All images is with the bmw 1-series uk. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/2nb9jxiry62zhocchebwgxd5s7p9k78n/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(223, 'gamemonetize-1225', 'rc-125-slide', 'RC 125 Slide', 'https://img.gamemonetize.com/4wstl0uv3mp0aqx3tw0dv2ahujne8cbc/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of rc 125. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/4wstl0uv3mp0aqx3tw0dv2ahujne8cbc/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(224, 'gamemonetize-1224', 'fz-rabid-rabbit', 'FZ Rabid Rabbit', 'https://img.gamemonetize.com/l5bhqos3lid9l2ma4xqfn6c94n3plnh7/512x384.jpg', '0', 4, 0, '0', 'FZ Rabid Rabbit - Help the rabbit collect as many more carrots as possible, many different bonuses and obstacles that you need to jump over are waiting for you to continue playing and collecting more and more carrots. Compete with friends who will collect more carrots! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/l5bhqos3lid9l2ma4xqfn6c94n3plnh7/', 'html5', 800, 600, 1576076683, '1', '0'),
(225, 'gamemonetize-1223', 'fastlane-revenge-online', 'Fastlane Revenge Online', 'https://img.gamemonetize.com/a1fumc1k0bx2te6e4hmg530f3xkbb6ml/512x384.jpg', '0', 4, 0, '0', 'Recover your place in as number 1 and break through by beating the rest of the players and the extravagant bosses of the most terrifying bands in Fastlane Revenge! Have fun in Kiz10', '', 'https://html5.gamemonetize.com/a1fumc1k0bx2te6e4hmg530f3xkbb6ml/', 'html5', 527, 700, 1576076683, '1', '0'),
(226, 'gamemonetize-1222', 'temple-quest', 'Temple Quest', 'https://img.gamemonetize.com/wfpm0h4x8a3f63snpkqvfp3b7mhx9z25/512x384.jpg', '0', 4, 0, '0', 'You shouldn&#039;t have stolen that artifact! Now you have to run for your life in an endless maze of temple ruins! Collect golden idols, ancient coins and power-ups. Master various obstacles, upgrade power-ups and fulfill objectives to grow your score multiplier. Try out different outfits with special abilities to get even further. How far can you get?', '', 'https://html5.gamemonetize.com/wfpm0h4x8a3f63snpkqvfp3b7mhx9z25/', 'html5', 600, 800, 1576076683, '1', '0'),
(227, 'gamemonetize-1221', 'chained-tractor-towing-train', 'Chained Tractor Towing Train', 'https://img.gamemonetize.com/yv2hbmzw22as2ic7xfvfnhw2m908isuh/512x384.jpg', '0', 4, 0, '0', 'Did you ever drive a tractor on the railway? Now you can find out how it is in Tractor Towning Train game. Acomplish each level requirements and keep the train on rails. Features • Multiple levels • Good graphics', '', 'https://html5.gamemonetize.com/yv2hbmzw22as2ic7xfvfnhw2m908isuh/', 'html5', 960, 540, 1576076683, '1', '0'),
(228, 'gamemonetize-1220', 'unpark-me', 'Unpark Me', 'https://img.gamemonetize.com/hufe1xavunq9j67hacd3vuq1293goj55/512x384.jpg', '0', 5, 0, '0', 'Unpark Me is a challenging and addictive puzzle game. Help get your car out of many difficult parking situations. Try to finish the game in as little moves as possible and increase your IQ and logical thinking. You need to get your car out the Exit gate. To accomplish this just move the blocking vehicles out of the way. The game comes with 4 difficulties ranging from Beginner to Expert.', '', 'https://html5.gamemonetize.com/hufe1xavunq9j67hacd3vuq1293goj55/', 'html5', 600, 800, 1576076683, '1', '0'),
(229, 'gamemonetize-1219', 'minigolf-master', 'Minigolf Master', 'https://img.gamemonetize.com/snrww5vdb2fpx6ivtwdvfwgxx35wtigm/512x384.jpg', '0', 8, 0, '0', 'Joyful minigolf game. Enjoy various minigolf courses full of obstacles and animated by simulated physics. Reach the par or an even better outcome to unlock another levels, difficulty settings and controls. Each difficulty brings its own control scheme. Can you play everything under the par?', '', 'https://html5.gamemonetize.com/snrww5vdb2fpx6ivtwdvfwgxx35wtigm/', 'html5', 800, 600, 1576076683, '1', '0'),
(230, 'gamemonetize-1218', 'darts-pro-multiplayer', 'Darts Pro Multiplayer', 'https://img.gamemonetize.com/v75bhmn4rk5wbsovgrvbjzfzx1bqpclk/512x384.jpg', '0', 7, 0, '0', 'Darts Pro Multiplayer is a HTML5 Sports Game. Enjoy this stylish version of the classic Darts Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/v75bhmn4rk5wbsovgrvbjzfzx1bqpclk/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(231, 'gamemonetize-1217', 'merge-tower-animals', 'Merge Tower Animals', 'https://img.gamemonetize.com/mhxa39qjobayhncqi1zqtutvr8gpna79/512x384.jpg', '0', 4, 0, '0', 'Merge Tower Animals is one of the Best casual games in 2019. Merge the cute animals to improve their power. Collect millions of coins to buy new animals, destroy thousands of enemies and reach higher levels.', '', 'https://html5.gamemonetize.com/mhxa39qjobayhncqi1zqtutvr8gpna79/', 'html5', 450, 750, 1576076683, '1', '0'),
(232, 'gamemonetize-1216', 'checkers-legend', 'Checkers Legend', 'https://img.gamemonetize.com/78izsars8sldmlgna8zeor2fxspu07x8/512x384.jpg', '0', 5, 0, '0', 'The classic and very simple board game everyone knows from their childhood. It comes in many variants, so the game provides rules settings. You can play against the simple AI or you can use this app to play against a friend on the same device.', '', 'https://html5.gamemonetize.com/78izsars8sldmlgna8zeor2fxspu07x8/', 'html5', 600, 800, 1576076683, '1', '0'),
(233, 'gamemonetize-1215', 'mahjong-master-2', 'Mahjong Master 2', 'https://img.gamemonetize.com/7wjgkt6tp78mkrvri6qe4rrsboxee72m/512x384.jpg', '0', 5, 0, '0', 'The classic solitaire game of matching Chinese tiles in your pocket, thanks to Inlogic. Carefully consider every move and clear the field full of tiles piled in thoughtful pyramids. Look for similar free tiles to match and remove them. Matching is possible only those which are free from at least one side. Quick playing gives you bonus points. Can you earn all the golden stars in all game modes?', '', 'https://html5.gamemonetize.com/7wjgkt6tp78mkrvri6qe4rrsboxee72m/', 'html5', 600, 800, 1576076683, '1', '0'),
(234, 'gamemonetize-1214', 'mafia-agent', 'Mafia Agent', 'https://img.gamemonetize.com/xervpxr6g9l9m2l2rms7n6worksw9n57/512x384.jpg', '0', 5, 0, '0', 'Your hitman must complete a range of different contracted kills within the city against other Mafia syndicates', '', 'https://html5.gamemonetize.com/xervpxr6g9l9m2l2rms7n6worksw9n57/', 'html5', 800, 600, 1576076683, '1', '0'),
(235, 'gamemonetize-1213', 'classic-jeep-parking', 'Classic Jeep Parking', 'https://img.gamemonetize.com/lwebb3v23odskicclplhd4hrxp45ivk3/512x384.jpg', '0', 2, 0, '0', 'Ready to drive the luxurious 4x4 jeep parking 3D game; one of the most new and latest parking and driving game, you will drive and park the awesome jeep around corners, obstacles, and parking lot boundaries with high speed and accuracy. Do you want to test your driving skills with parking?', '', 'https://html5.gamemonetize.com/lwebb3v23odskicclplhd4hrxp45ivk3/', 'html5', 960, 640, 1576076683, '1', '0'),
(236, 'gamemonetize-1212', 'plane-go', 'PLANE GO!', 'https://img.gamemonetize.com/ibqdzu3r2aoptvnzn3xnkqojf4iuqsl9/512x384.jpg', '0', 2, 0, '0', 'Plane GO! Fun plane game is coming! Plane Go is really a challenging game! You control your plane and get all stars to unlock super star to win the level. It has four world: GRASS, ICE, SAND and SPACE, 40 levels and every world has a boss level, very wonderful! Once you played two levels, you must have strong desire to finish them all! Enjoy this!', '', 'https://html5.gamemonetize.com/ibqdzu3r2aoptvnzn3xnkqojf4iuqsl9/', 'html5', 480, 854, 1576076683, '1', '0'),
(237, 'gamemonetize-1211', 'gravity-snowman-christmas', 'Gravity Snowman Christmas', 'https://img.gamemonetize.com/i27j4xccuciyh6unzxk6m8npjm6qryp9/512x384.jpg', '0', 2, 0, '0', 'Switch the gravity to control your Snowman to avoid the obstacles and reach the magic gate. 30 levels to go. Play now!', '', 'https://html5.gamemonetize.com/i27j4xccuciyh6unzxk6m8npjm6qryp9/', 'html5', 960, 540, 1576076683, '1', '0'),
(238, 'gamemonetize-1210', 'slenderman-must-die-silent-streets', 'Slenderman Must Die: Silent Streets', 'https://img.gamemonetize.com/7t16334mqlw1a830fs90m8haygcjv2q3/512x384.jpg', '0', 2, 0, '0', 'Slenderman Must Die - Silent Streets + Christmas Special - Explore City Streets and Winter Forest (Christmas Special). - Awesome Graphics - Get ready for Holidays with Best Slenderman game ever! Silent streets in Silent City. Find 8 pages before he gets you. Are you a hunter or a prey ? Christmas Special. Find 7 presents to defeat Slenderman and his evil companions! Good Luck!', '', 'https://html5.gamemonetize.com/7t16334mqlw1a830fs90m8haygcjv2q3/', 'html5', 800, 600, 1576076683, '1', '0'),
(239, 'gamemonetize-1209', 'pony-pet-salon', 'Pony Pet Salon', 'https://img.gamemonetize.com/tbn92fxdq7ij9erwq32cmnpy5x478ts2/512x384.jpg', '0', 4, 0, '0', 'In Pony Pet Salon, get ready for some styling! These ponies are adorable, but each wants to have a new look. As one of the most talented stylists in the Ponyville, can you help these adorable animals?', '', 'https://html5.gamemonetize.com/tbn92fxdq7ij9erwq32cmnpy5x478ts2/', 'html5', 450, 750, 1576076683, '1', '0'),
(240, 'gamemonetize-1208', 'bts-santa-claus-coloring', 'BTS Santa Claus Coloring', 'https://img.gamemonetize.com/kihnl3n95b8x6e30lvu6pzkftukw66mq/512x384.jpg', '0', 5, 0, '0', 'BTS Santa Claus Coloring is an online game that you can play for free. Christmas day is coming! Let&#039;s add some color to Santa! There are many colors for you to choose, Pick your favorite color and draw it. Create your own artwork! Have a good time with BTS Santa Claus Coloring!', '', 'https://html5.gamemonetize.com/kihnl3n95b8x6e30lvu6pzkftukw66mq/', 'html5', 854, 480, 1576076683, '1', '0'),
(241, 'gamemonetize-1207', 'dino-run', 'Dino Run', 'https://img.gamemonetize.com/cnkbbcs5d7crf8dpjo5ehff5acvj21qf/512x384.jpg', '0', 5, 0, '0', 'Run away from birds and jump away from cactus! Take control of a Dino fighting for his life. Run as quickly as possible, and stomp on other cactus in your path. Jump over obstacles, and don&#039;t get caught in pits. Avoid total extinction at all costs! Press the up and down keys on the keyboard or the on-screen buttons to jump or slide. Dino Run is the best free running game where you can run with your dinosaur friends,and tray to make the highest score!', '', 'https://html5.gamemonetize.com/cnkbbcs5d7crf8dpjo5ehff5acvj21qf/', 'html5', 1280, 720, 1576076683, '1', '0'),
(242, 'gamemonetize-1206', 'west-shooter', 'west shooter', 'https://img.gamemonetize.com/8r8iztumykpcmqme5hhjy176uo0ct4p1/512x384.jpg', '0', 3, 0, '0', 'West shooter is a 3d game in which you have to reach the maximum possible score and for this you have to shoot some zombie boards using three different weapons. If you run out of time, spend the coins you earn and buy more time or if you get tired of using the same weapon, buy a different one from the ones on the table.', '', 'https://html5.gamemonetize.com/8r8iztumykpcmqme5hhjy176uo0ct4p1/', 'html5', 800, 600, 1576076683, '1', '0'),
(243, 'gamemonetize-1205', 'bomber-truck', 'Bomber Truck', 'https://img.gamemonetize.com/k3l7od3vqvk6pu9l2x8tq43oliq8pu4a/512x384.jpg', '0', 2, 0, '0', 'In this game you need to transport bombs with the truck. But the terrain is hard and with roughness and you drive will be hard. Try to balance truck and to watch not to drop the bomb or pass the time given for each level, or you will loose.', '', 'https://html5.gamemonetize.com/k3l7od3vqvk6pu9l2x8tq43oliq8pu4a/', 'html5', 860, 480, 1576076683, '1', '0'),
(244, 'gamemonetize-1204', 'squirrel-hop', 'Squirrel Hop', 'https://img.gamemonetize.com/tliitpvyfxwi60pk72immp6ujm5yp7pj/512x384.jpg', '0', 2, 0, '0', '&quot;Squirrel Hop&quot; is a really fun platform game. You have to tap left and right buttons to jump on platforms. Collect walnut to get some seconds. Tap and jump fast to make a high score. To make this game more interesting for kids, we have added cute graphics in it. With funny sounds, it would be fun playing with squirrel characters. Theme and characters get change as you make a nice score while playing the game.', '', 'https://html5.gamemonetize.com/tliitpvyfxwi60pk72immp6ujm5yp7pj/', 'html5', 1260, 720, 1576076683, '1', '0'),
(245, 'gamemonetize-1203', 'food-stand-difference', 'Food Stand Difference', 'https://img.gamemonetize.com/1zam8w6c8jqj56cdn2ysf6gy6qnbxm5z/512x384.jpg', '0', 5, 0, '0', 'Food Stand Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/1zam8w6c8jqj56cdn2ysf6gy6qnbxm5z/', 'html5', 1280, 720, 1576076683, '1', '0'),
(246, 'gamemonetize-1202', 'my-dream-doctor', 'My Dream Doctor', 'https://img.gamemonetize.com/2w9loyt6xf5bg82210siv7rn1c2p6w48/512x384.jpg', '0', 1, 0, '0', 'Perform emergency surgery doctor with advanced operation tools in the kids’ hospital. Get ready to play the full bunch of the doctor &amp; hospital game! Now start your virtual doctor challenging journey here! Treat all different kinds of patients as like professional doctor into this virtual hospital.', '', 'https://html5.gamemonetize.com/2w9loyt6xf5bg82210siv7rn1c2p6w48/', 'html5', 500, 750, 1576076683, '1', '0'),
(247, 'gamemonetize-1201', 'connect-the-christmas', 'Connect The Christmas', 'https://img.gamemonetize.com/rzxjcund9jj4xjvwwptr00crtaa0bwp2/512x384.jpg', '0', 5, 0, '0', 'Connect pairs of matching Christmas characters by creating a path between them. Click / Tap and drag to connect the Christmas. Play now!', '', 'https://html5.gamemonetize.com/rzxjcund9jj4xjvwwptr00crtaa0bwp2/', 'html5', 540, 960, 1576076683, '1', '0'),
(248, 'gamemonetize-1200', 'maja-the-bee-puzzle', 'Maja the Bee Puzzle', 'https://img.gamemonetize.com/shq76ow0qfj7do56w78b4aeh5lwyx5kp/512x384.jpg', '0', 5, 0, '0', 'Maja The Bee Jigsaw is an online game that you can play for free. Are you a lover of jigsaw puzzle game? If you are, welcome to play the game! This game is about our cute Maja the Bee and it gives you the perfect jigsaw puzzle experience. Solve all puzzles and keep your brain sharp. You have three modes for each picture, easy, medium and hard. Have fun!', '', 'https://html5.gamemonetize.com/shq76ow0qfj7do56w78b4aeh5lwyx5kp/', 'html5', 854, 480, 1576076683, '1', '0'),
(249, 'gamemonetize-1199', 'lets-kill-jane-the-killer-don-t-go-to-sleep', 'Lets Kill Jane The Killer: Don&#039;t Go to Sleep', 'https://img.gamemonetize.com/zg0gysoiq9hcfn2a5p3twqczwpvf3oo3/512x384.jpg', '0', 5, 0, '0', 'Jane The Killer is not a threat. While She may have experienced homicidal urges during the first 90 seconds of her transformation, She eventually calmed down and is currently a s snarky, ruthless, yet kind-hearted person who is willing to aid the world of evil. However, due to her abilities, she can be violent and wrathful if irritated. Nevertheless, she MUST BE STOPPED! You need to find 8 bottles of liquid hate and try to kill Jane The Killer. Good luck! Features: * Awesome 3D Graphics * Intuitive controls that are easy to pick up and play * Nice weapon arsenal * NEW - Chainsaw weapon!', '', 'https://html5.gamemonetize.com/zg0gysoiq9hcfn2a5p3twqczwpvf3oo3/', 'html5', 800, 600, 1576076683, '1', '0'),
(250, 'gamemonetize-1198', 'city-taxi-driver-sim', 'City Taxi Driver Sim', 'https://img.gamemonetize.com/nbhuoimm7yjqic8g4g94idxxtqcguswh/512x384.jpg', '0', 2, 0, '0', 'City Taxi Driver Sim is a marvelous city taxi driving game available for smart phone. Multiple cars and realistic scenes combine to the whole game. Keep the brain occupied and obey traffic rules. Drunk driving is a very serious crime in the US. The police will arrest you. A friendly passenger may call your taxi. Earn enough money for new taxi. The taxi is given to you in perpetuity. Are you ready to start a new adventure? I can foresee you will be a professional city taxi driver!', '', 'https://html5.gamemonetize.com/nbhuoimm7yjqic8g4g94idxxtqcguswh/', 'html5', 960, 640, 1576076683, '1', '0'),
(251, 'gamemonetize-1197', 'jasmine-and-elsa-school-bag-design-contest', 'Jasmine and Elsa - School Bag Design Contest', 'https://img.gamemonetize.com/ji0arncg51f58jhx5r9bf2ii2wj3z9vj/512x384.jpg', '0', 1, 0, '0', 'It&#039;s time to go back to school! Young princesses Jasmine and Elsa are known for their art talents. They decided to surprise everyone with their new school backpacks. Each of the girls came up with their own unique design and created a cool school backpack, unlike everyone else. Who will be the best designer, Elsa or Jasmine? Use a palette of colors and textures, as well as many decorations, stickers and decorative elements. Participate in this contest with the princesses and help defeat your favorite!', '', 'https://html5.gamemonetize.com/ji0arncg51f58jhx5r9bf2ii2wj3z9vj/', 'html5', 800, 600, 1576076683, '1', '0'),
(252, 'gamemonetize-1196', 'dragon-queen-wedding-dress', 'Dragon Queen Wedding Dress', 'https://img.gamemonetize.com/zpvft1dlow9eufcm0js5mbl9wk4zhj1h/512x384.jpg', '0', 1, 0, '0', 'Daenerys Stormborn of House Targaryen, Rightful heir to the Iron Throne, Rightful Queen of the Andals and the First Men, Protector of the Seven Kingdoms, the Mother of Dragons, the Khaleesi of the Great Grass Sea, the Unburnt, the Breaker of Chains getting married. Help her choose a traditional white dress, shoes and accessories. Braid her gorgeous silver hair in a wedding hairstyle and enjoy the triumph!', '', 'https://html5.gamemonetize.com/zpvft1dlow9eufcm0js5mbl9wk4zhj1h/', 'html5', 800, 600, 1576076683, '1', '0'),
(253, 'gamemonetize-1195', 'rolling-domino-3d', 'Rolling Domino 3D', 'https://img.gamemonetize.com/uczscd6sestm06yn94shq48ryvv27bs2/512x384.jpg', '0', 5, 0, '0', 'Rolling Domino 3D - arcade game, take control of the ball and choose its direction to knock down all the dominoes.', '', 'https://html5.gamemonetize.com/uczscd6sestm06yn94shq48ryvv27bs2/', 'html5', 800, 600, 1576076683, '1', '0'),
(254, 'gamemonetize-1194', 'santa-claus-jump', 'Santa Claus Jump', 'https://img.gamemonetize.com/nfsim3mjcxy54t0ngarrvn2vnxdjh384/512x384.jpg', '0', 4, 0, '0', 'Tap/Click and hold to control jumping power. Release to jump. Collect little-Santa to revive your Santa Clous. Avoid the rockets. Eat the candies to power up. How far can you jump? Play now!', '', 'https://html5.gamemonetize.com/nfsim3mjcxy54t0ngarrvn2vnxdjh384/', 'html5', 480, 640, 1576076683, '1', '0'),
(255, 'gamemonetize-1193', 'eg-red-ball', 'EG Red Ball', 'https://img.gamemonetize.com/6if8r2p39yifeng01olu00k51m0wvt12/512x384.jpg', '0', 5, 0, '0', 'EG Red Ball - This is a minimalistic puzzle about a small red ball. The ball from the beginning of the level is in the pocket. It must be transferred to another pocket. You can rotate some blocks that specify the direction of the rebound of the ball. Also on the field there are teleports, gates and blocks that you can move between the two fields. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/6if8r2p39yifeng01olu00k51m0wvt12/', 'html5', 800, 600, 1576076683, '1', '0'),
(256, 'gamemonetize-1192', 'audi-rs6-avant-puzzle', 'Audi RS6 Avant Puzzle', 'https://img.gamemonetize.com/g6dwpus6ox4ld2zbr26k8my5x9nrlm31/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Audi RS6 Avant Puzzle. All images is with the audi rs6 avant. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/g6dwpus6ox4ld2zbr26k8my5x9nrlm31/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(257, 'gamemonetize-1191', 'santa-claus-gift-bag-jigsaw', 'Santa Claus Gift Bag Jigsaw', 'https://img.gamemonetize.com/03gjzgweuw4i56po4yse5igcf5j4dhwe/512x384.jpg', '0', 5, 0, '0', 'Santa Claus Gift Bag Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/03gjzgweuw4i56po4yse5igcf5j4dhwe/', 'html5', 1280, 720, 1576076683, '1', '0'),
(258, 'gamemonetize-1190', 'amusement-park-hidden-stars', 'Amusement Park Hidden Stars', 'https://img.gamemonetize.com/0ca7jckeo49opujmol6wyk1sb6atrv8r/512x384.jpg', '0', 5, 1, '0', 'Amusement Park Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/0ca7jckeo49opujmol6wyk1sb6atrv8r/', 'html5', 1280, 720, 1576076683, '1', '0'),
(259, 'gamemonetize-1189', 'santa-gift-bike-race', 'Santa Gift Bike Race', 'https://img.gamemonetize.com/bd1tgteolx8wbaozqa5rwbj2iey7sw33/512x384.jpg', '0', 2, 0, '0', 'Hip Hip Hurrrryyy!!! Merry Christmas to all of you and now it&#039;s time to deliver some Christmas gifts as a santa in santa gift delivery games and christmas gift ...', '', 'https://html5.gamemonetize.com/bd1tgteolx8wbaozqa5rwbj2iey7sw33/', 'html5', 800, 600, 1576076683, '1', '0'),
(260, 'gamemonetize-1188', 'winter-frozen', 'Winter Frozen', 'https://img.gamemonetize.com/n6h8m1lbcpx2hhby9hiwri9gc4xddgx0/512x384.jpg', '0', 5, 0, '0', 'The glittering crystals of ice of different shapes resemble shining diamonds. They will become your main elements in the game Frozen Winter. To complete the level, it is necessary to collect a specified number of blocks. Form the rows or columns of three or more identical ice figures to take them off the field. Have fun!', '', 'https://html5.gamemonetize.com/n6h8m1lbcpx2hhby9hiwri9gc4xddgx0/', 'html5', 450, 800, 1576076683, '1', '0'),
(261, 'gamemonetize-1187', 'kids-cartoon-puzzle', 'Kids Cartoon Puzzle', 'https://img.gamemonetize.com/hgtlx62ydln4eay72zr8dcd2819ppa96/512x384.jpg', '0', 5, 0, '0', 'Kids Cartoon Puzzle is a great game to help children improve their abilities and speed in solving problems. There are 9 beautiful puzzles for kids to play with. Have fun with this amazing puzzle for kids!', '', 'https://html5.gamemonetize.com/hgtlx62ydln4eay72zr8dcd2819ppa96/', 'html5', 960, 540, 1576076683, '1', '0'),
(262, 'gamemonetize-1186', 'music-board', 'MUSIC BOARD', 'https://img.gamemonetize.com/vcdsxppbvhy776sgwtiepnx6ucij9bv4/512x384.jpg', '0', 5, 0, '0', 'Music Board is a funny music game, follow the note and finish all the rhythm, you will play a good music.', '', 'https://html5.gamemonetize.com/vcdsxppbvhy776sgwtiepnx6ucij9bv4/', 'html5', 480, 854, 1576076683, '1', '0'),
(263, 'gamemonetize-1185', 'monster-4x4-offroad-jeep-stunt-racing-2019', 'Monster 4x4 Offroad Jeep Stunt Racing 2019', 'https://img.gamemonetize.com/s5an6toilrn2483ntx5ciy06j5ton6lf/512x384.jpg', '0', 2, 1, '0', 'Steer your 6x6 monster jeep or 4x4 jeep as a professional stunt driver. If you are ready to experience real jeep stunt racing than drive your Prado 4x4 jeep and hill offroad climb on the mountain, off-road tracks drive. Drive the offroad 6x6 jeep on mountain tracks to become a modern expert, 6x6 monster or 4x4 crazy offroad jeep driver or trick master.', '', 'https://html5.gamemonetize.com/s5an6toilrn2483ntx5ciy06j5ton6lf/', 'html5', 960, 600, 1576076683, '1', '0'),
(264, 'gamemonetize-1184', 'turkey-cooking-simulator', 'Turkey Cooking Simulator', 'https://img.gamemonetize.com/cyhvque9hu8rxaxlrtu35x6498x7n0dz/512x384.jpg', '0', 1, 0, '0', 'Cooking simulator is a simulator games to cook a turkey.', '', 'https://html5.gamemonetize.com/cyhvque9hu8rxaxlrtu35x6498x7n0dz/', 'html5', 800, 600, 1576076683, '1', '0'),
(265, 'gamemonetize-1183', 'juice-maker', 'Juice Maker', 'https://img.gamemonetize.com/xs5zr7xcjy0h97ofg67nif2gszsdu89s/512x384.jpg', '0', 1, 0, '0', 'Fruit Juice Maker features: - multiple game modes - good graphics', '', 'https://html5.gamemonetize.com/xs5zr7xcjy0h97ofg67nif2gszsdu89s/', 'html5', 960, 540, 1576076683, '1', '0'),
(266, 'gamemonetize-1182', 'rx7-drift-3d', 'RX7 Drift 3D', 'https://img.gamemonetize.com/364yytcfv0c4qv0lskcl2gwhbhowm4kq/512x384.jpg', '0', 2, 0, '0', 'Between many of the famous tuning machines sits the one and only Rotary powered beast. We&#039;re talking about the RX-7 of course. A popular car from the world of cars, both at racing and drifting. Today you will be given the chance to drive your own. No consequences and fun ahead. Just pure driving freedom. Have fun!', '', 'https://html5.gamemonetize.com/364yytcfv0c4qv0lskcl2gwhbhowm4kq/', 'html5', 960, 600, 1576076683, '1', '0'),
(267, 'gamemonetize-1181', 'tower-mania', 'Tower Mania', 'https://img.gamemonetize.com/z4zbtwyd6xxwvobxt7mtx80zv174jpgi/512x384.jpg', '0', 3, 0, '0', 'How high can you get? Build your ancient or modern towers in a fantastic futuristic world in the simplest one-click manner! Place floating blocks as precisely as you can to earn coins, which you can use too boost your next tower even further into space or to discover other wonderful locations! Let&#039;s get building!', '', 'https://html5.gamemonetize.com/z4zbtwyd6xxwvobxt7mtx80zv174jpgi/', 'html5', 600, 800, 1576076683, '1', '0'),
(268, 'gamemonetize-1180', 'domino', 'Domino', 'https://img.gamemonetize.com/jejbeoj5vgeqduwxf0ypzo4lby8bh4t0/512x384.jpg', '0', 3, 1, '0', 'Domino Breaker features: - multiple levels - multiple skins', '', 'https://html5.gamemonetize.com/jejbeoj5vgeqduwxf0ypzo4lby8bh4t0/', 'html5', 460, 720, 1576076683, '1', '0'),
(269, 'gamemonetize-1179', 'real-estate-sim', 'Real Estate Sim', 'https://img.gamemonetize.com/v5umwqp6aa7u04itarijhuibb72iiyhd/512x384.jpg', '0', 1, 0, '0', 'Real Estate Tycoon features: - multiple game modes - strategy gameplay', '', 'https://html5.gamemonetize.com/v5umwqp6aa7u04itarijhuibb72iiyhd/', 'html5', 960, 540, 1576076683, '1', '0'),
(270, 'gamemonetize-1178', 'jewel-bubbles-3', 'Jewel Bubbles 3', 'https://img.gamemonetize.com/uftncr0ipxekmqifx58vd9u9a2dtstcm/512x384.jpg', '0', 5, 0, '0', 'Jewel Bubbles back again in dazzling colours! The classic turn-based match 3 with lots of challenging levels to beat! Various goals in different game modes and useful bubble combinations to use tactically. Warning! Includes a bonus pack of levels for the best!', '', 'https://html5.gamemonetize.com/uftncr0ipxekmqifx58vd9u9a2dtstcm/', 'html5', 600, 800, 1576076683, '1', '0'),
(271, 'gamemonetize-1177', 'penguin-deep-sea-fishing', 'Penguin Deep Sea Fishing', 'https://img.gamemonetize.com/ko69ukmjsg88fhut90nyqem6455u3h4o/512x384.jpg', '0', 4, 0, '0', 'Its a nice sunny day and our little friend the Happy Penguin decided to go on a fishing trip for cute sea animals and fishes to put in his little aquarium come and experience the joy', '', 'https://html5.gamemonetize.com/ko69ukmjsg88fhut90nyqem6455u3h4o/', 'html5', 960, 640, 1576076683, '1', '0'),
(272, 'gamemonetize-1176', 'streets-of-anarchy-fists-of-war', 'Streets Of Anarchy: Fists Of War', 'https://img.gamemonetize.com/mlwez2ugdm1olz3rzlpl46hijj30vfdi/512x384.jpg', '0', 4, 0, '0', 'There is too much crime in the streets. It&#039;s your duty as a hero to stop them! Clean up the streets and stop the villains. Good Luck Crime Fighter.', '', 'https://html5.gamemonetize.com/mlwez2ugdm1olz3rzlpl46hijj30vfdi/', 'html5', 800, 600, 1576076683, '1', '0'),
(273, 'gamemonetize-1175', 'jewel-and-crazy-birds', 'Jewel And Crazy Birds', 'https://img.gamemonetize.com/0k2br3yplxcbcohwwf2wiop3ckv4imvj/512x384.jpg', '0', 5, 0, '0', 'Break the jewel-obstacles to help the crazy bird back to its nest. 30 levels to enjoy. Play now!', '', 'https://html5.gamemonetize.com/0k2br3yplxcbcohwwf2wiop3ckv4imvj/', 'html5', 960, 540, 1576076683, '1', '0'),
(274, 'gamemonetize-1174', 'pizza-cutter', 'Pizza Cutter', 'https://img.gamemonetize.com/twg7f9i2pu09r362iu5n39nqibtfjzcc/512x384.jpg', '0', 1, 0, '0', 'Cut Cut Pizza features: - fun gameplay - multiple levels', '', 'https://html5.gamemonetize.com/twg7f9i2pu09r362iu5n39nqibtfjzcc/', 'html5', 800, 600, 1576076683, '1', '0'),
(275, 'gamemonetize-1173', 'christmas-tom-differences', 'Christmas Tom Differences', 'https://img.gamemonetize.com/j398mnps8wz8b8ix8em7kx2y0gob04fk/512x384.jpg', '0', 5, 0, '0', 'Christmas Tom Differences is an online game that you can play for free. Find all differences between two pictures with our lovley Tom. Your job is to find five differences at each picture to clear the level. No time limit just enjoy playing and come back for more.', '', 'https://html5.gamemonetize.com/j398mnps8wz8b8ix8em7kx2y0gob04fk/', 'html5', 480, 854, 1576076683, '1', '0'),
(276, 'gamemonetize-1172', 'extermination-of-flies', 'Extermination of Flies', 'https://img.gamemonetize.com/pv53xvubcwt5xx9ke1k5cm2jz1a09hsz/512x384.jpg', '0', 3, 0, '0', 'Jimmy feels that his kitchen is being a the playground of flies recently, you can hear them buzzing with the lamp off, but he can&#039;t find them when he turns the light on, that is so annoying, so Jimmy wants a full extermination of his kitchen, kill all the flies! but these evil creatures are so sneaky, please help Jimmy kill them, the amount and lethality of the flies will increase while the challenge goes on. Be careful of the flies&#039; attack, and have fun!', '', 'https://html5.gamemonetize.com/pv53xvubcwt5xx9ke1k5cm2jz1a09hsz/', 'html5', 854, 480, 1576076683, '1', '0'),
(277, 'gamemonetize-1171', 'christmas-blocks-collapse', 'Christmas Blocks Collapse', 'https://img.gamemonetize.com/qjkvzn7a62fx6kqi2vkvlyav9df54e8v/512x384.jpg', '0', 5, 0, '0', 'Collapse christmas blocks by connecting 2 or more similar blocks. Collapse 6 or more blocks to get a bomb. More points are awarded as larger connections are made.', '', 'https://html5.gamemonetize.com/qjkvzn7a62fx6kqi2vkvlyav9df54e8v/', 'html5', 640, 960, 1576076683, '1', '0'),
(278, 'gamemonetize-1170', 'flappy-color-ball', 'Flappy Color Ball', 'https://img.gamemonetize.com/7c592cm2eq43tgpaz9lx3xy6ffl7qmdy/512x384.jpg', '0', 5, 0, '0', 'Get the ball through the matching colors of the lines ahead of you while trying to keep yourself flying. Tap or click on the screen to get the ball to go up. Get the ball through the matching color lines by the obstacles ahead of it.Heave Fun!', '', 'https://html5.gamemonetize.com/7c592cm2eq43tgpaz9lx3xy6ffl7qmdy/', 'html5', 720, 1280, 1576076683, '1', '0'),
(279, 'gamemonetize-1169', 'desert-racing', 'Desert Racing', 'https://img.gamemonetize.com/19dantuu5kn3u1284jf9ecg7h3g1iclk/512x384.jpg', '0', 2, 7, '0', 'Desert Racing is an awesome driving game in which you can experience the true thrill of racing through the immense desert on a 4x4 quad bike. ... In free ride you can explore the desert on your own and drive to your hearts content across the open sands.', '', 'https://html5.gamemonetize.com/19dantuu5kn3u1284jf9ecg7h3g1iclk/', 'html5', 800, 600, 1576076683, '1', '0'),
(280, 'gamemonetize-1168', 'learning-kids-memory', 'Learning Kids Memory', 'https://img.gamemonetize.com/m989khmblaukmzc6ntuejhhyuaugkfl6/512x384.jpg', '0', 5, 0, '0', 'This is memory game for learning kids. There is images with learning kids, they are happy and want to learn. Pair two same images and try to finish level before time over. You can learn also with this game.', '', 'https://html5.gamemonetize.com/m989khmblaukmzc6ntuejhhyuaugkfl6/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(281, 'gamemonetize-1167', 'christmas-gift-adventure', 'Christmas Gift Adventure', 'https://img.gamemonetize.com/putkdylymjnrozk3y1lnj3b848ez1xkq/512x384.jpg', '0', 5, 0, '0', 'Christamas Gift Adventure is fun online game suitable for all ages. This time you need to stay on the platforms and collect as many gifts as possible. Try to stay away from the top of the screen or do not fall of the screen as well. Have fun playing and come back for more.', '', 'https://html5.gamemonetize.com/putkdylymjnrozk3y1lnj3b848ez1xkq/', 'html5', 480, 854, 1576076683, '1', '0')";
$db[19] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(282, 'gamemonetize-1166', 'my-christmas-items', 'My Christmas Items', 'https://img.gamemonetize.com/wvdwzoosaqs6afgqrl2lhe7ud89bhg2d/512x384.jpg', '0', 5, 0, '0', 'My Christmas Items is a free online game from genre of memory and kids games. You have come to the right place! My Christmas Items is the ultimate challenge that will leave thrilled and alert and you will want to play again and again until you have unlocked and won all levels! Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/wvdwzoosaqs6afgqrl2lhe7ud89bhg2d/', 'html5', 960, 540, 1576076683, '1', '0'),
(283, 'gamemonetize-1165', 'gold-gun-fury', 'Gold Gun Fury', 'https://img.gamemonetize.com/l2xrtfcxpcuf23qa21jqogvoii40hu82/512x384.jpg', '0', 3, 0, '0', '3D first person shooter game. Your team was ambush during your mission. Being the lone survivor, you must fight your enemies alone. Your troop has found out the position of an enemy secret laboratory. Take your gun and eliminate all the guards of the laboratory.', '', 'https://html5.gamemonetize.com/l2xrtfcxpcuf23qa21jqogvoii40hu82/', 'html5', 800, 680, 1576076683, '1', '0'),
(284, 'gamemonetize-1164', 'heart-box', 'Heart Box', 'https://img.gamemonetize.com/m4qrp2locszmxh6vtcaibgi4phewv6yh/512x384.jpg', '0', 5, 0, '0', 'Take the robot through all the experimental puzzle rooms of Professor Rat to release him from the charger! Use the properties of 20 physical objects for complete all puzzles: test-cube, bowling ball, spring trampoline, dynamite, movable platform, conveyor, fan, pneumatic tube, laser, portal, dynamic saw, switch button and others!', '', 'https://html5.gamemonetize.com/m4qrp2locszmxh6vtcaibgi4phewv6yh/', 'html5', 800, 600, 1576076683, '1', '0'),
(285, 'gamemonetize-1163', 'adventures-of-flig', 'Adventures of Flig', 'https://img.gamemonetize.com/u45zjrq1d00d39ic4p4eq2m6y0zo2i1w/512x384.jpg', '0', 5, 0, '0', '&quot;Adventures of Flig&quot; - opens a new world in hockey games without glow and neon! It&#039;s interesting story which combines three games in one - air hockey, runner and labyrinth. Explore beautiful and mysterious worlds and fight the unique enemies to help save Flig&#039;s beloved from the clutches of the vile Spider! And don&#039;t forget the tiny spider Spidey! Guide him through the dangerous mazes and he&#039;ll play a significant role in the adventure!', '', 'https://html5.gamemonetize.com/u45zjrq1d00d39ic4p4eq2m6y0zo2i1w/', 'html5', 800, 600, 1576076683, '1', '0'),
(286, 'gamemonetize-1162', 'subway-runner', 'Subway Runner', 'https://img.gamemonetize.com/xfqaymtsmmb5di5z2k0sj8okbvhh31g1/512x384.jpg', '0', 4, 0, '0', 'Enter the railway! Run as far as you possibly can, evade obstacles of the railway and finish all the achievements in an everchanging and gradually more difficult level design! Collect coins and use them to upgrade your collectible power up capabilities. Challenge your skills and beat your highscore!', '', 'https://html5.gamemonetize.com/xfqaymtsmmb5di5z2k0sj8okbvhh31g1/', 'html5', 800, 600, 1576076683, '1', '0'),
(287, 'gamemonetize-1161', 'cut-it-fair', 'Cut it Fair', 'https://img.gamemonetize.com/mxl7ch0aseiihwtgceqemfvmpyoaqhud/512x384.jpg', '0', 5, 0, '0', 'Don&#039;t Spill It is a slicing game where you will have to slice the fruits with a knife according to the glasses. Cut precisely to complete levels. Good Luck', '', 'https://html5.gamemonetize.com/mxl7ch0aseiihwtgceqemfvmpyoaqhud/', 'html5', 900, 540, 1576076683, '1', '1'),
(288, 'gamemonetize-1160', 'boat-amp-dash', 'Boat &amp; Dash!', 'https://img.gamemonetize.com/k4k527gzxb11q3uqv9y23yy5lhsrnn68/512x384.jpg', '0', 4, 0, '0', 'Boat &amp; Dash is fun game with one finger control. Control the running boat and smash the boxes, wheels, drums placed on the way. Avoid striking the rocks else you end your life. It simple game to play but hard to clear the higher levels.', '', 'https://html5.gamemonetize.com/k4k527gzxb11q3uqv9y23yy5lhsrnn68/', 'html5', 500, 750, 1576076683, '1', '0'),
(289, 'gamemonetize-1159', 'zombiecraft-2', 'ZombieCraft 2', 'https://img.gamemonetize.com/iobi9v9jlrt01fmizjbm1rtsi1x2akat/512x384.jpg', '0', 4, 0, '0', 'ZombieCraft is a adventure rpg game. Select your favourite character, gear up axe, swords or any item and kill the zombies. Show your friends how many you kill zombies ? if you kill 50 zombies you will go next level.', '', 'https://html5.gamemonetize.com/iobi9v9jlrt01fmizjbm1rtsi1x2akat/', 'html5', 960, 600, 1576076683, '1', '0'),
(290, 'gamemonetize-1158', 'roll-this-ball', 'Roll This Ball', 'https://img.gamemonetize.com/ga60e46mqmsgc2a4n8ec42u9aqnshs0y/512x384.jpg', '0', 5, 0, '0', 'Do you like classic sliding and unblocking puzzles? Then this game is just for you! Move the wooden tiles to unblock the path and make a way for the steel ball to reach the red, shiny goal. Enjoy the fun with this wildly popular brain-teasing game and test your wits!', '', 'https://html5.gamemonetize.com/ga60e46mqmsgc2a4n8ec42u9aqnshs0y/', 'html5', 600, 800, 1576076683, '1', '0'),
(291, 'gamemonetize-1157', 'jewel-pets-match', 'Jewel Pets Match', 'https://img.gamemonetize.com/20ntpuqciwjuzsijq6zmke0pz8v037w5/512x384.jpg', '0', 5, 0, '0', 'Get your mood up with happy pets! Match them in greater numbers to erase a bigger portion of the board! It can help you crush through blocks standing in your way. Classic turn based match-3 arcade with lots of challenging levels awaits you!', '', 'https://html5.gamemonetize.com/20ntpuqciwjuzsijq6zmke0pz8v037w5/', 'html5', 800, 600, 1576076683, '1', '0'),
(292, 'gamemonetize-1156', 'mahjong-mania', 'Mahjong Mania!', 'https://img.gamemonetize.com/0ea8nd6q0sakjc8fh9q036yf22xch4xi/512x384.jpg', '0', 5, 0, '0', 'The ancient Chinese game in your pocket. Clear the boards full of beautiful tiles, piled in thoughtful pyramids. Hone your skills, strategy and calculations to win all available cups in all game modes. Can you hadle it? It&#039;s time for Mahjong Mania!', '', 'https://html5.gamemonetize.com/0ea8nd6q0sakjc8fh9q036yf22xch4xi/', 'html5', 600, 600, 1576076683, '1', '0'),
(293, 'gamemonetize-1155', 'police-cars-parking', 'Police Cars Parking', 'https://img.gamemonetize.com/xd0b8w4wiikrpsakz76ym4cknjbzyf3w/512x384.jpg', '0', 2, 0, '0', 'It starts off nice and easy where you just need to avoid barriers and cones. As you advance the levels become bigger and the spots further away and more difficult to get to. So race around, avoiding cars and jam packed streets of cars, ambulances and obstacles. This parking simulation is a real challenge where you will really need your best driving skills to complete the missions.', '', 'https://html5.gamemonetize.com/xd0b8w4wiikrpsakz76ym4cknjbzyf3w/', 'html5', 900, 600, 1576076683, '1', '0'),
(294, 'gamemonetize-1154', 'bouncy-musical-ball', 'Bouncy Musical Ball', 'https://img.gamemonetize.com/3o3t995jp39lqusdheoq6z9the6wpzvt/512x384.jpg', '0', 2, 0, '0', 'Bouncy Ball features: - endless gameplay - fun music', '', 'https://html5.gamemonetize.com/3o3t995jp39lqusdheoq6z9the6wpzvt/', 'html5', 420, 720, 1576076683, '1', '0'),
(295, 'gamemonetize-1153', 'murder-the-homicidal-liu-into-damnation', 'Murder The Homicidal Liu - Into Damnation', 'https://img.gamemonetize.com/ljclklz8lf0h21wmbrct8xrdnjxhtegf/512x384.jpg', '0', 3, 0, '0', 'You are about to kill Jeff The Killer. Finally he is dead. You&#039;re going home to eat and rest. Those are your plans but someone has other plans for you... Enter the Liu Dimension where all the monsters are. Find some clues and try to stop him. It won&#039;t be easy! Features: - Four Weapons: Knife, Dual Pistols, Shotgun, SMG - 18 levels to complete - Good story - Good graphics - Intuitive controls that are easy to pick up and play - Gameplay from Poison Games that you love.', '', 'https://html5.gamemonetize.com/ljclklz8lf0h21wmbrct8xrdnjxhtegf/', 'html5', 800, 650, 1576076683, '1', '0'),
(296, 'gamemonetize-1152', 'finger-soccer-hd', 'Finger Soccer HD', 'https://img.gamemonetize.com/86kbn5nq7jhzzkkxp1camtsg78gkvqy4/512x384.jpg', '0', 1, 0, '0', 'Finger Soccer features: - fun gameplay - multiple game modes', '', 'https://html5.gamemonetize.com/86kbn5nq7jhzzkkxp1camtsg78gkvqy4/', 'html5', 960, 600, 1576076683, '1', '0'),
(297, 'gamemonetize-1151', 'fishing-sim', 'Fishing Sim', 'https://img.gamemonetize.com/ermkhnoto46oor8cng3zbo3losk43osh/512x384.jpg', '0', 1, 0, '0', 'Fisherman features: - fun gameplay - multiple environments', '', 'https://html5.gamemonetize.com/ermkhnoto46oor8cng3zbo3losk43osh/', 'html5', 400, 720, 1576076683, '1', '0'),
(298, 'gamemonetize-1150', 'army-commando', 'Army Commando', 'https://img.gamemonetize.com/kvs3849rw9d64489g28f2mrhu618jcr4/512x384.jpg', '0', 3, 0, '0', 'A ruthless group of terrorists is determined to create chaos on a global scale! You’ll need to stop them at all costs in this first-person shooter game. Take them down, one by one, as you infiltrate their secret headquarters and attempt to meet each one of your objectives.', '', 'https://html5.gamemonetize.com/kvs3849rw9d64489g28f2mrhu618jcr4/', 'html5', 960, 640, 1576076683, '1', '0'),
(299, 'gamemonetize-1149', 'mafia-car-3d-time-record-challenge', 'Mafia Car 3D - Time Record Challenge', 'https://img.gamemonetize.com/v187f8sdvbo3lbfdwg9frzvxov3xi70d/512x384.jpg', '0', 2, 0, '0', 'Are you in for a little challenge? If yes, then let&#039;s see if you can be the quickest in town with your mafia car. In this game you have to drive through the city as fast as you can. Reach to the end point and see what time you got. Hold tight on the steering wheel and good luck!', '', 'https://html5.gamemonetize.com/v187f8sdvbo3lbfdwg9frzvxov3xi70d/', 'html5', 800, 600, 1576076683, '1', '0'),
(300, 'gamemonetize-1148', 'balls-rotate', 'Balls Rotate', 'https://img.gamemonetize.com/5dojngoowdie0lhx3yxx49h0ktg1pxpv/512x384.jpg', '0', 1, 0, '0', 'Balls Rotate 3D features: - fun gameplay - multiple skins', '', 'https://html5.gamemonetize.com/5dojngoowdie0lhx3yxx49h0ktg1pxpv/', 'html5', 420, 720, 1576076683, '1', '0'),
(301, 'gamemonetize-1147', 'office-horror-story', 'Office Horror Story', 'https://img.gamemonetize.com/n8k0tmcc6ou0mrxb3pmaw9owf8f9lc68/512x384.jpg', '0', 1, 0, '0', 'Office Horror Story Explore Office, Stairs and Basement. Find out the horrifying story about the Mad Killer. - 16 levels to play - 2 melee weapons - Puzzles to solve and objects to find. - If you like Horror Games, this one is for you.', '', 'https://html5.gamemonetize.com/n8k0tmcc6ou0mrxb3pmaw9owf8f9lc68/', 'html5', 830, 650, 1576076683, '1', '0'),
(302, 'gamemonetize-1146', 'wild-wolves', 'Wild Wolves', 'https://img.gamemonetize.com/3wkyhqybeoa8t6lit1desrgdjn1gwexz/512x384.jpg', '0', 1, 0, '0', 'You are a becoming alpha wolf and you have to accomplish your duty like a leader by protecting and feeding your pack. Features • Multiple levels • Good graphics', '', 'https://html5.gamemonetize.com/3wkyhqybeoa8t6lit1desrgdjn1gwexz/', 'html5', 960, 600, 1576076683, '1', '0'),
(303, 'gamemonetize-1145', 'fz-santa-dream', 'FZ Santa Dream', 'https://img.gamemonetize.com/p0lu74jw5647ewy3u0ihwejf5mzapfye/512x384.jpg', '0', 4, 0, '0', 'FZ Santa Dream - You will control the falling Santa Claus. Move left and right, avoid obstacles! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/p0lu74jw5647ewy3u0ihwejf5mzapfye/', 'html5', 800, 600, 1576076683, '1', '0'),
(304, 'gamemonetize-1144', 'fz-ball-hopper', 'FZ Ball Hopper', 'https://img.gamemonetize.com/mav1xx2gu3yfz8ug0b9ggh24wutik9k7/512x384.jpg', '0', 4, 0, '0', 'FZ Ball Hopper is one of the Best casual games in 2018 Chill your mind with the most addictive Idle game! Swipe your finger to control your balls and destroy all the incoming blocks. Collect millions of coins to buy your upgrades, improve your stats and reach higher levels. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/mav1xx2gu3yfz8ug0b9ggh24wutik9k7/', 'html5', 800, 600, 1576076683, '1', '0'),
(305, 'gamemonetize-1143', 'halloween-matching', 'Halloween Matching', 'https://img.gamemonetize.com/h1yl1pq2knavkroajfi7fixpti1arfr9/512x384.jpg', '0', 5, 0, '0', 'Match 3 or more identical halloween avatars to make them explode before time runs out. If you match 4 or more identical halloween avatars you&#039;ll get extra time. Match 4 identical avatars in a row / column to get a bomb. Match 5 identical avatars in a row / column to get a changing avatar, that will destroy all identical avatars and will give you extra time for each exploded avatars. If you are lucky, you&#039;ll get extra time in the board.', '', 'https://html5.gamemonetize.com/h1yl1pq2knavkroajfi7fixpti1arfr9/', 'html5', 540, 960, 1576076683, '1', '0'),
(306, 'gamemonetize-1142', 'bear-chase', 'Bear Chase', 'https://img.gamemonetize.com/x70qdl7hih5fl5gm93m9t3wdkffkrgjp/512x384.jpg', '0', 5, 0, '0', 'In this platform game your job is to collect presents jumping around platforms and to earn points. But suddenly from your shadow will came more bears who will follow you and you need to avoid them, The black bears will chase you.', '', 'https://html5.gamemonetize.com/x70qdl7hih5fl5gm93m9t3wdkffkrgjp/', 'html5', 1280, 720, 1576076683, '1', '0'),
(307, 'gamemonetize-1141', 'santa-claus-adventure', 'Santa Claus Adventure', 'https://img.gamemonetize.com/1x2fpsweyn38651h73xg6kso8fl4a81c/512x384.jpg', '0', 5, 0, '0', 'Santa Claus Adventure is fun arcade game suitable for all ages. Your task is to collect as many gifts as possible and the more gifts you collect the more kids will be happy at the end. Avoid the ice blocks on the way and have fun. Merry Christmas to you!', '', 'https://html5.gamemonetize.com/1x2fpsweyn38651h73xg6kso8fl4a81c/', 'html5', 854, 480, 1576076683, '1', '0'),
(308, 'gamemonetize-1140', 'christmas-connection', 'Christmas Connection', 'https://img.gamemonetize.com/40tekqzn0qclnqypm92k4ckw89rbixqm/512x384.jpg', '0', 5, 0, '0', 'Christmas Connection is puzzle Match 3 game with a Christmas theme. The wizard chanted a spell and the Christmas items turned into balls, you need to line 3 or more same Christmas items for the rescue. Your mission is to get high score in short time as fast as you can. Have fun!', '', 'https://html5.gamemonetize.com/40tekqzn0qclnqypm92k4ckw89rbixqm/', 'html5', 960, 540, 1576076683, '1', '0'),
(309, 'gamemonetize-1139', 'merge-amp-hit-knives', 'Merge &amp; Hit  Knives', 'https://img.gamemonetize.com/mjj2vo5nkjgd2uakxqljiot530945o8r/512x384.jpg', '0', 4, 0, '0', 'Merge &amp; Hit Knives is a mix of two famous games: Merge and Knife Hit. Start with a simple knife, merge the similar knives to unlock new and better weapon. Keep doing so to unlock exciting fantasy weapons, swords, daggers and much more. Gain experience and challenge yourself. When you will be readu try to hit knifes game and complete all levels.', '', 'https://html5.gamemonetize.com/mjj2vo5nkjgd2uakxqljiot530945o8r/', 'html5', 500, 750, 1576076683, '1', '0'),
(310, 'gamemonetize-1138', 'geometry-dash-bloodbath', 'Geometry Dash Bloodbath', 'https://img.gamemonetize.com/vprj427n2nce955l5x81ewf1t3hohmfd/512x384.jpg', '0', 4, 0, '0', 'Welcome to Geometry dash Bloodbath game, the most harded game out there. Jump and fly your way through danger in this rhythm-based action platformer! is back with a brand new adventure, New levels, new music, new monsters, new everything. Run as fast as you can and be alert of your surroundings. Tap to jump whenever you see an obstacles a head. Be fast and accurate. Collect as many coins to beat your friends high scores today. Enjoy!', '', 'https://html5.gamemonetize.com/vprj427n2nce955l5x81ewf1t3hohmfd/', 'html5', 800, 600, 1576076683, '1', '1'),
(311, 'gamemonetize-1137', 'music-line-2-christmas', 'MUSIC LINE 2 CHRISTMAS', 'https://img.gamemonetize.com/vdkk80ahb95lnasx53bj2siy8u43vllq/512x384.jpg', '0', 4, 0, '0', 'Listen to the christmas songs’ melodies and dance the line through snowy worlds in the game Dancing Line 2: Christmas!', '', 'https://html5.gamemonetize.com/vdkk80ahb95lnasx53bj2siy8u43vllq/', 'html5', 414, 736, 1576076683, '1', '1'),
(312, 'gamemonetize-1136', 'animal-daycare-pet-vet', 'Animal Daycare Pet Vet', 'https://img.gamemonetize.com/mvf3v8k9q60yqnovp1py6vuc6b8q69ps/512x384.jpg', '0', 4, 0, '0', 'Pet care games with levels offer hours of fun to boys and girls who love animals and dream of becoming veterinarians, dog and cat groomers or animal hairdressers! Do you want to take care of your own pet in real life? Learn how to take care of pets properly by playing exciting pet grooming mini games', '', 'https://html5.gamemonetize.com/mvf3v8k9q60yqnovp1py6vuc6b8q69ps/', 'html5', 450, 750, 1576076683, '1', '0'),
(313, 'gamemonetize-1135', 'gun-strike', 'Gun Strike', 'https://img.gamemonetize.com/jy5urd3fco46rpwc1d0ce2vjwqwec87v/512x384.jpg', '0', 3, 0, '0', 'Gun Strike is a high-level 3D FPS game. Specially designed for commando game lovers. You&#039;re playing a role of a brave soldier, to experience the true absolute hot stimulating shootout. With access to a variety of light and heavy weapons, as well as powerful grenade too! In the game you can not only choose to play in village combat but can also enjoy city like buildings environment to fight, I believe this variety of terrain will be able to ignite the passion of your research.', '', 'https://html5.gamemonetize.com/jy5urd3fco46rpwc1d0ce2vjwqwec87v/', 'html5', 960, 640, 1576076683, '1', '0'),
(314, 'gamemonetize-1134', 'train-travels', 'Train Travels', 'https://img.gamemonetize.com/ly4mldex0wqejztovtthg8a5i1kttkue/512x384.jpg', '0', 3, 0, '0', 'You are a train driver and i tell you that it’s really hard to keep a train on the railway, so first you have to take the passengers from the station and drive to reach the destination where they need to arrive. Features • Multiple levels • Fun gameplay', '', 'https://html5.gamemonetize.com/ly4mldex0wqejztovtthg8a5i1kttkue/', 'html5', 960, 600, 1576076683, '1', '0'),
(315, 'gamemonetize-1133', 'horse-rider', 'Horse Rider', 'https://img.gamemonetize.com/d0nm3wfycn3qtbmpjhe150w0r64l10hf/512x384.jpg', '0', 2, 0, '0', 'Did you ever think how is to be an equestrian in horse sports? Now you have the chance to ride a horse and jump all over the obstacles in a tight competition. Win all the races in tournement and be the horse riding champion.', '', 'https://html5.gamemonetize.com/d0nm3wfycn3qtbmpjhe150w0r64l10hf/', 'html5', 960, 600, 1576076683, '1', '0'),
(316, 'gamemonetize-1132', 'taxi-simulator', 'Taxi Simulator', 'https://img.gamemonetize.com/llon0jnm4c5dd8daux4jca8boqs93j3o/512x384.jpg', '0', 2, 0, '0', 'Take the passengers and drive them to the destination while making car stunts. Features: • Multiple cars • Multiple levels', '', 'https://html5.gamemonetize.com/llon0jnm4c5dd8daux4jca8boqs93j3o/', 'html5', 960, 600, 1576076683, '1', '0'),
(317, 'gamemonetize-1131', 'mister-shooter', 'Mister Shooter', 'https://img.gamemonetize.com/utk5d1ocpjv1i7dqb1e1um12vzx8y32t/512x384.jpg', '0', 3, 0, '0', 'Mister Shooter features: - 60 levels - challenging levels', '', 'https://html5.gamemonetize.com/utk5d1ocpjv1i7dqb1e1um12vzx8y32t/', 'html5', 420, 720, 1576076683, '1', '0'),
(318, 'gamemonetize-1130', 'drift-scooter-infinite', 'Drift Scooter - Infinite', 'https://img.gamemonetize.com/wg4wzluvnxb9ldkykd76e2tyf1qemddj/512x384.jpg', '0', 2, 0, '0', 'Drift Scooter, the busy streets collect all the coins to score your points, and avoid all incoming obstacles in this 3D scooter driving game in perspective!', '', 'https://html5.gamemonetize.com/wg4wzluvnxb9ldkykd76e2tyf1qemddj/', 'html5', 854, 480, 1576076683, '1', '0'),
(319, 'gamemonetize-1129', 'ninja-action-2', 'Ninja Action 2', 'https://img.gamemonetize.com/731442zyj2mzsp6iro98yur7u8vyb81i/512x384.jpg', '0', 2, 0, '0', 'Did you played Ninja Action? Now try Ninja Action 2 A Enhanced one of the first game with going highRules are same turn on gravity shoesTap to change platform and collect coin magnet and other power to make your highscore', '', 'https://html5.gamemonetize.com/731442zyj2mzsp6iro98yur7u8vyb81i/', 'html5', 768, 1024, 1576076683, '1', '0'),
(320, 'gamemonetize-1128', 'angry-fish-coloring', 'Angry Fish Coloring', 'https://img.gamemonetize.com/lhmkn59ulhqqi5b9dwvdya1j06pydyoz/512x384.jpg', '0', 5, 0, '0', 'Angry Fish Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/lhmkn59ulhqqi5b9dwvdya1j06pydyoz/', 'html5', 1280, 720, 1576076683, '1', '0'),
(321, 'gamemonetize-1127', 'fire-trucks-memory', 'Fire Trucks Memory', 'https://img.gamemonetize.com/px720t71i0i6hs5q7l3y0utc6xr8qakg/512x384.jpg', '0', 5, 0, '0', 'Fire Truck Memory is memory game where you need to find the matching pair of cards and complete each level. You can earn bonuses if you finish before time. So test how good is your memory.', '', 'https://html5.gamemonetize.com/px720t71i0i6hs5q7l3y0utc6xr8qakg/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(322, 'gamemonetize-1126', 'bounce-amp-roll', 'Bounce &amp; Roll!', 'https://img.gamemonetize.com/qr3xjyawk39rtxvym6rx6i0ffdizeol5/512x384.jpg', '0', 5, 0, '0', 'Bounce &amp; Roll! is pretty simple. You need to lead your cute character, bounce and roll it to reach the treasure at the end of the levels. Be careful, you must use your brain if you want to solve all the levels. Collect all the stars to unlock new pets and characters. T', '', 'https://html5.gamemonetize.com/qr3xjyawk39rtxvym6rx6i0ffdizeol5/', 'html5', 900, 600, 1576076683, '1', '0'),
(323, 'gamemonetize-1125', 'crazynite-io', 'Crazynite.io', 'https://img.gamemonetize.com/zlmz9xiuo5s5dntkcmx2cw2vvto5ox0o/512x384.jpg', '0', 7, 0, '0', 'Crazynite.io was inspired by popular new game Fortnite. Is a free unblocked online 2d io game with elements from Fortnite. Battles take place on an island full of explosive barrels. It is better to stay away from them, otherwise you can be exploded to pieces, if an clever player notices you near the barrel - he will shoot it. Ammunition: a knife, a revolver, a shotgun, a double-barrel, a tommy gun, a machine gun, a grenade launcher, a rocket launcher, a cannon, a sniper rifle and a laser, a bandage, a armor. You can save yourself by building walls. You will need the wood for the wooden wall, t', '', 'https://html5.gamemonetize.com/zlmz9xiuo5s5dntkcmx2cw2vvto5ox0o/', 'html5', 1000, 800, 1576076683, '1', '0'),
(324, 'gamemonetize-1124', 'worldcraft-3d-build-amp-craft', 'WorldCraft: 3D Build &amp; Craft', 'https://img.gamemonetize.com/uzoh1tpbufb67uia8pjwzr028wl0drv7/512x384.jpg', '0', 1, 4, '0', 'If you are a craft master. World Craft winter exploration ready for you. Show your skills craft your cubes and build cities, garden, your own house call your friends. Play with your friends new adventures. Features - Crafting cube - Graphics Improved - New worlds', '', 'https://html5.gamemonetize.com/uzoh1tpbufb67uia8pjwzr028wl0drv7/', 'html5', 800, 650, 1576076683, '1', '1'),
(325, 'gamemonetize-1123', 'cake-shop', 'Cake Shop', 'https://img.gamemonetize.com/bh0vw23vjfj3cwt6a1aonddfqrqog26r/512x384.jpg', '0', 1, 0, '0', 'You own your very own Cake Shop! Take orders and make sure you get them right to keep your customers happy!', '', 'https://html5.gamemonetize.com/bh0vw23vjfj3cwt6a1aonddfqrqog26r/', 'html5', 960, 640, 1576076683, '1', '0'),
(326, 'gamemonetize-1122', 'the-floor-is-lava-3d', 'The Floor is Lava 3D', 'https://img.gamemonetize.com/z45ux9mv8jv3greew00xe7i3wg5r75b7/512x384.jpg', '0', 4, 0, '0', 'We are happy to announce you clone of famous hyper casual game - The Floor is Lava 3D! Your goal is simple. Jump across your living room, but keep in mind that at any point in time… the floor can turn into hot lava! Use the hearts to your advantage and keep jumping as long as possible.', '', 'https://html5.gamemonetize.com/z45ux9mv8jv3greew00xe7i3wg5r75b7/', 'html5', 500, 750, 1576076683, '1', '0'),
(327, 'gamemonetize-1121', 'multi-storey-modern-car-parking-2019', 'Multi Storey Modern Car Parking 2019', 'https://img.gamemonetize.com/dztug6gm62gchfejha946e930ow154yi/512x384.jpg', '0', 2, 0, '0', 'Here you come to test your drive experience! let&#039;s start a car parking driving test, Where you have to find a parking lot and do perfect parking. The car parking test is placed in a MultiStory car parking lot, which is built for difficulty levels. It&#039;s like a parking lot mania and thinks you can become the master of precision parking problems by the end of this game? Think again! Park your car in a multi-story plaza and enhance your accuracy in public parking.', '', 'https://html5.gamemonetize.com/dztug6gm62gchfejha946e930ow154yi/', 'html5', 960, 600, 1576076683, '1', '0'),
(328, 'gamemonetize-1120', 'ultimate-car-tracks', 'Ultimate Car Tracks', 'https://img.gamemonetize.com/6cvn1124ixd64bo994f2wn2eqnnv2qp9/512x384.jpg', '0', 2, 0, '0', 'Ultimate Car Tracks features: - multiple levels - multiple cars - challenging gameplay', '', 'https://html5.gamemonetize.com/6cvn1124ixd64bo994f2wn2eqnnv2qp9/', 'html5', 960, 600, 1576076683, '1', '0'),
(329, 'gamemonetize-1119', 'police-simulator-transport-2019', 'Police Simulator Transport 2019', 'https://img.gamemonetize.com/14cw4l8r5nkyqc22iphtlcfdvmboxjcz/512x384.jpg', '0', 2, 0, '0', 'Ready for police transport? Much mission waiting you to drive a cool car as police.Enjoy!', '', 'https://html5.gamemonetize.com/14cw4l8r5nkyqc22iphtlcfdvmboxjcz/', 'html5', 800, 600, 1576076683, '1', '0'),
(330, 'gamemonetize-1118', 'zombie-derby', 'Zombie Derby', 'https://img.gamemonetize.com/2vs14l9pnwvmjcfjetrai72uld2235u6/512x384.jpg', '0', 2, 0, '0', 'Car vs Zombie Derby features: - multiple cars - upgrades - multiple levels - fun gameplay', '', 'https://html5.gamemonetize.com/2vs14l9pnwvmjcfjetrai72uld2235u6/', 'html5', 960, 540, 1576076683, '1', '0'),
(331, 'gamemonetize-1117', 'santa-claus-jumping-adventure', 'Santa Claus Jumping Adventure', 'https://img.gamemonetize.com/4hny6d5gmaxdbci51f090u60hfk24608/512x384.jpg', '0', 2, 0, '0', 'Santa Claus Jumping Adventure is fun online game suitable for all ages. Help our lovley Santa to collect as many gifts as possible. Avoid little red devils on the way up. Have fun playing.', '', 'https://html5.gamemonetize.com/4hny6d5gmaxdbci51f090u60hfk24608/', 'html5', 480, 854, 1576076683, '1', '0'),
(332, 'gamemonetize-1116', 'audi-rs-q3-puzzle', 'Audi RS Q3 Puzzle', 'https://img.gamemonetize.com/rbx9stv0rzcfucylhgq9samnaond7gty/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Audi RS Q3 Puzzle. All images is with the audi rs q3. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/rbx9stv0rzcfucylhgq9samnaond7gty/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(333, 'gamemonetize-1115', 'crazy-cowboy-match-3', 'Crazy Cowboy Match 3', 'https://img.gamemonetize.com/tof8tpccm0yan98k5q8ama93em0gsp9l/512x384.jpg', '0', 5, 0, '0', 'Crazy Cowboy Match 3 – this cool game three in a row, in which you have to put the blocks of the same image in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. Enjoy the game!', '', 'https://html5.gamemonetize.com/tof8tpccm0yan98k5q8ama93em0gsp9l/', 'html5', 1280, 720, 1576076683, '1', '0'),
(334, 'gamemonetize-1114', 'cookies-match-3', 'Cookies Match 3', 'https://img.gamemonetize.com/tk84wd54bt6kb6enlj1sx7iadw6ymz0f/512x384.jpg', '0', 5, 0, '0', 'In this game you need to matching 3 or more cookies and to destroy them. With ten moves you need to destroy the given cookies. In every level there is different cookies and number of cookies. Pass all levels and enjoy in this game.', '', 'https://html5.gamemonetize.com/tk84wd54bt6kb6enlj1sx7iadw6ymz0f/', 'html5', 720, 1280, 1576076683, '1', '0'),
(335, 'gamemonetize-1113', 'sailor-warriors-new-era', 'Sailor Warriors New Era', 'https://img.gamemonetize.com/nvzn96v742ryi9qczstvvwcf7s8420tq/512x384.jpg', '0', 1, 0, '0', 'Evil does not sleep. A new threat is coming from outer space. But modern Sailor Warriors stand guard over the earth. These girls are not only strong - but also beautiful, create your own unique Sailor-Warrior of the New Era and join the fight against Evil. Choose a suit consisting of a top and a skirt, as well as unique shoes and bows. Color your suit in any color. Do not forget to pick up magic weapons, hairstyle and accessories for girls. It remains to choose a stylish background - and your image of the Sailor Warrior of the New Era is ready!', '', 'https://html5.gamemonetize.com/nvzn96v742ryi9qczstvvwcf7s8420tq/', 'html5', 800, 600, 1576076683, '1', '0'),
(336, 'gamemonetize-1112', 'penguin-cafe', 'Penguin Cafe', 'https://img.gamemonetize.com/0mjsijcjq9rshjsxf4hv4lw8wht5u15u/512x384.jpg', '0', 1, 0, '0', 'In a snowy land where penguins, polar bears and walruses live side by side, you need to help overworked Berta run her struggling cafe. Happily, the cafe floats on an iceberg, so there’s adventure to be had…', '', 'https://html5.gamemonetize.com/0mjsijcjq9rshjsxf4hv4lw8wht5u15u/', 'html5', 960, 540, 1576076683, '1', '0'),
(337, 'gamemonetize-1111', 'crazysteve-io', 'CrazySteve.io', 'https://img.gamemonetize.com/uqzbzhkjckdjj96mn9sm0mcyoz68tagn/512x384.jpg', '0', 7, 0, '0', 'The game Crazy Steve io was created for fun and fast fighting. The main task in Crazy Steve is to score as many points as possible and be the coolest. To do this, you need to collect diamonds and apples that appear on the map. For diamonds, you charge more experience than apples, but thanks to apples you can recovery your health. A lot of diamonds fall out of the killed rival. Do you understand what we are inclined to? Yes! You need to scatter around the dynamic checkers, shoot from the bow, attack with the sword, shoot from the fireball and use other weapon in every way to kill the rivals, an', '', 'https://html5.gamemonetize.com/uqzbzhkjckdjj96mn9sm0mcyoz68tagn/', 'html5', 1000, 800, 1576076683, '1', '1'),
(338, 'gamemonetize-1110', 'airport-manager', 'Airport Manager', 'https://img.gamemonetize.com/jy14lwyggfpnvl4rd0jlgnowbwfwy0ui/512x384.jpg', '0', 1, 0, '0', 'Airport Manager Simulator game is easy and interesting simple games for everyone whose dream job is to be flight attendants when they grow up Keep passengers happy cook and serve food on the plane clean the cabin after each landing and do much more', '', 'https://html5.gamemonetize.com/jy14lwyggfpnvl4rd0jlgnowbwfwy0ui/', 'html5', 960, 640, 1576076683, '1', '0'),
(339, 'gamemonetize-1109', 'european-football', 'European Football', 'https://img.gamemonetize.com/avbwl97t4aupzxi433vl0i7ivx9jhofr/512x384.jpg', '0', 1, 0, '0', 'Soccer Simulator features: - 2 game modes - fun simulation gameplay', '', 'https://html5.gamemonetize.com/avbwl97t4aupzxi433vl0i7ivx9jhofr/', 'html5', 960, 540, 1576076683, '1', '0'),
(340, 'gamemonetize-1108', 'sweet-candy-mania', 'Sweet Candy Mania', 'https://img.gamemonetize.com/yffsgao8y28tlwvlmh37ld053j7kt2mr/512x384.jpg', '0', 5, 0, '0', 'Little Fluffy needs your help! His family was captured after crash landing on the Candy Planet. Shoot and match colourful candies to progress further. Overcoming various obstacles to free them you will enter the tasty world of candy, chocolate and the goofy indinginous! Can you free all family members and collect all items needed to progress to the end?', '', 'https://html5.gamemonetize.com/yffsgao8y28tlwvlmh37ld053j7kt2mr/', 'html5', 600, 800, 1576076683, '1', '0'),
(341, 'gamemonetize-1107', 'gun-mayhem', 'Gun Mayhem', 'https://img.gamemonetize.com/rvbwa94ae5euj1q0l12e6zr8hooczaqr/512x384.jpg', '0', 3, 0, '0', 'Play the original Gun Mayhem game where the goal is to stay on the island without getting knocked off. Choose your weapon wisely so that you can knock your opponents off. Grab creates to to get firearm upgrades.', '', 'https://html5.gamemonetize.com/rvbwa94ae5euj1q0l12e6zr8hooczaqr/', 'html5', 800, 680, 1576076683, '1', '0'),
(342, 'gamemonetize-1106', 'pirate-bomber-jewel-hunter', 'Pirate Bomber - Jewel Hunter', 'https://img.gamemonetize.com/qdf4j4iww1j30m7vqrjfp5biecievbxl/512x384.jpg', '0', 4, 0, '0', 'Grab the jewels and divert the bombs, grab the power ups to help the pirate not get caught for a limited time. The more points you earn the greater will be the speed and quantity of items.', '', 'https://html5.gamemonetize.com/qdf4j4iww1j30m7vqrjfp5biecievbxl/', 'html5', 404, 720, 1576076683, '1', '0'),
(343, 'gamemonetize-1105', 'superhero-tower', 'Superhero Tower', 'https://img.gamemonetize.com/b7764pvzaofcjckp8mfszc9338hq7qlj/512x384.jpg', '0', 1, 0, '0', 'Superhero Tower features: - 100 levels - good graphics', '', 'https://html5.gamemonetize.com/b7764pvzaofcjckp8mfszc9338hq7qlj/', 'html5', 960, 600, 1576076683, '1', '0'),
(344, 'gamemonetize-1104', 'cake-master-3d', 'Cake Master 3D', 'https://img.gamemonetize.com/dl9ijps610qgjvgm21l5uemdy97fds2r/512x384.jpg', '0', 1, 0, '0', 'Cake Maker features: - Endless gameplay - Multiple skins - Rating system', '', 'https://html5.gamemonetize.com/dl9ijps610qgjvgm21l5uemdy97fds2r/', 'html5', 540, 720, 1576076683, '1', '0'),
(345, 'gamemonetize-1103', 'spin-basketball', 'Spin Basketball', 'https://img.gamemonetize.com/7octolc1loh5loj4p8mww3g97e5xm01t/512x384.jpg', '0', 5, 0, '0', 'Spin Basketball is fun basketball game suitable for all ages. The aim of the game is simple, just get the basketball to the hoop and you are done. Collect coins on the way for more points. Avoid spikes. Clear all levels and become a Basketball Master!', '', 'https://html5.gamemonetize.com/7octolc1loh5loj4p8mww3g97e5xm01t/', 'html5', 960, 640, 1576076683, '1', '0'),
(346, 'gamemonetize-1102', 'fullscreen-mario', 'Fullscreen Mario', 'https://img.gamemonetize.com/w75fparbaawjjml77vzq46cnifmj38kz/512x384.jpg', '0', 5, 0, '0', 'Full Mario game remake in HTML5 for your enjoyment!', '', 'https://html5.gamemonetize.com/w75fparbaawjjml77vzq46cnifmj38kz/', 'html5', 800, 600, 1576076683, '1', '0'),
(347, 'gamemonetize-1101', 'christmas-adventure', 'Christmas adventure', 'https://img.gamemonetize.com/w5d9x8b44b1eklmwx87mrxe0nlhs4ch1/512x384.jpg', '0', 5, 0, '0', 'Christmas Adventure is a simple 2d game.Hope you enjoy.', '', 'https://html5.gamemonetize.com/w5d9x8b44b1eklmwx87mrxe0nlhs4ch1/', 'html5', 800, 480, 1576076683, '1', '0'),
(348, 'gamemonetize-1100', 'jumping-to-the-tree', 'Jumping to the tree', 'https://img.gamemonetize.com/y3zhnvnxgcjszijtwhhthcrmplw46kv5/512x384.jpg', '0', 5, 0, '0', 'Beat the jumping levels from platform to platform until you reach the tree, where the gift belongs', '', 'https://html5.gamemonetize.com/y3zhnvnxgcjszijtwhhthcrmplw46kv5/', 'html5', 300, 512, 1576076683, '1', '0'),
(349, 'gamemonetize-1099', 'christmas-tree-difference', 'Christmas Tree Difference', 'https://img.gamemonetize.com/b9p4goddyv42hcqoaema40822qaaii0t/512x384.jpg', '0', 5, 0, '0', 'Christmas Tree Difference is an online game that you can play for free. Play the game Christmas Tree Difference and test your skills. The two images about the Christmas are very similar. However, there are five differences between them. Try you find the difference in less time. Good luck!', '', 'https://html5.gamemonetize.com/b9p4goddyv42hcqoaema40822qaaii0t/', 'html5', 480, 854, 1576076683, '1', '0'),
(350, 'gamemonetize-1098', 'lone-pistol-zombies-in-the-streets', 'Lone Pistol : Zombies in the Streets', 'https://img.gamemonetize.com/jjovgo10keaea7vaiy6dlxxgayzz0u1k/512x384.jpg', '0', 3, 0, '0', 'Fast paced shooting game. Make a stand against countless waves of roaming zombies.', '', 'https://html5.gamemonetize.com/jjovgo10keaea7vaiy6dlxxgayzz0u1k/', 'html5', 1300, 732, 1576076683, '1', '0'),
(351, 'gamemonetize-1097', 'cartoon-trucks-slide', 'Cartoon Trucks Slide', 'https://img.gamemonetize.com/mrlki6k4qdlb98kobuy5xkhdxqgzq7cd/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of cartoon trucks. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/mrlki6k4qdlb98kobuy5xkhdxqgzq7cd/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(352, 'gamemonetize-1096', 'death-alley', 'Death Alley', 'https://img.gamemonetize.com/hpahlzpztap662ocahhwp7ol85swxpcf/512x384.jpg', '0', 3, 0, '0', 'Death Alley, you need to stop the zombies from passing you, you need to destroy them all with your deadly chain!', '', 'https://html5.gamemonetize.com/hpahlzpztap662ocahhwp7ol85swxpcf/', 'html5', 860, 1280, 1576076683, '1', '0'),
(353, 'gamemonetize-1095', 'santa-claus-jigsaw', 'Santa Claus Jigsaw', 'https://img.gamemonetize.com/118a4n7qc0ht5ffdne2is9lj2xuw6ro7/512x384.jpg', '0', 5, 0, '0', 'Santa Claus Jigsaw is a free online game from genre of puzzle and jigsaw games. In this game you have a total of 12 jigsaw puzzles. You need to start from the first one and to unlock the next image. You have three modes for each picture: Easy with 25 pieces, Medium with 49 pieces and Hard with 100 pieces.', '', 'https://html5.gamemonetize.com/118a4n7qc0ht5ffdne2is9lj2xuw6ro7/', 'html5', 960, 540, 1576076683, '1', '0'),
(354, 'gamemonetize-1094', 'colorful-skull-jigsaw', 'Colorful Skull Jigsaw', 'https://img.gamemonetize.com/vjowr1n2qa9z5k5f753m9z0ds3zfc378/512x384.jpg', '0', 5, 0, '0', 'Colorful Skull Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/vjowr1n2qa9z5k5f753m9z0ds3zfc378/', 'html5', 1280, 720, 1576076683, '1', '0'),
(355, 'gamemonetize-1093', 'christmas-rooms-differences', 'Christmas Rooms Differences', 'https://img.gamemonetize.com/dmt02uq2fx80eu62r0xnzqconp6xxxla/512x384.jpg', '0', 5, 0, '0', 'Before Christmas Holidays we offer you a game with Christmas decor rooms. But there is seven differences in each rooms. Can you find it all before times up.', '', 'https://html5.gamemonetize.com/dmt02uq2fx80eu62r0xnzqconp6xxxla/', 'html5', 1280, 720, 1576076683, '1', '0'),
(356, 'gamemonetize-1092', 'little-dino-adventure-returns', 'Little Dino Adventure Returns', 'https://img.gamemonetize.com/ekbkavxg3kti7qxgp32serzf1mu866wl/512x384.jpg', '0', 5, 0, '0', 'Little Dino Adventure Returns is a super fun and challenging 2D sidescroller game in the same style as blockbuster games like Super Mario, Donkey Kong and Sonic. The game features 06 levels that will challenge you to beat it. The designs are very colorful and beautiful! In this platform adventure game, where the little Dinosaur must cross the valley of fear, where he encounters many challenges. Collect all the golden eggs to reach three stars in each stage. Play through the arrow keys or even the touch buttons on your phone’s screen.', '', 'https://html5.gamemonetize.com/ekbkavxg3kti7qxgp32serzf1mu866wl/', 'html5', 960, 540, 1576076683, '1', '0'),
(357, 'gamemonetize-1091', 'dark-ninja-adventure', 'Dark Ninja Adventure', 'https://img.gamemonetize.com/qdl1x3nh6uq8hoq2ia82epo3ss356mvw/512x384.jpg', '0', 5, 0, '0', 'This is not an ordinary ninja, in fact, this is a skillful collector of stars and the main goal of this ninja is to collect all the stars that are scattered in the scenario being invisible. Your job is to take on the role of the ninja, start the adventure and as soon as you get all the stars, you will open the portal, and only need to enter the portal that will appear so you can finish the level.', '', 'https://html5.gamemonetize.com/qdl1x3nh6uq8hoq2ia82epo3ss356mvw/', 'html5', 1280, 720, 1576076683, '1', '0'),
(358, 'gamemonetize-1090', 'little-dino-adventure', 'Little Dino Adventure', 'https://img.gamemonetize.com/2qbikpttpfnm2r1bn4xci5er6d3s4x66/512x384.jpg', '0', 5, 0, '0', 'Platform adventure game, where the little Dinosaur walk through the stages to collect as many small eggs as you can to score many points, tap the little dinosaur&#039;s head on the yellow blocks to collect even more eggs to score. Each of the three stages has three large golden eggs, try to pass the stage collecting the three to complete 100%. Jump on the enemies to gain points and destroy them. Play through the arrow keys or touch buttons on your mobile device.', '', 'https://html5.gamemonetize.com/2qbikpttpfnm2r1bn4xci5er6d3s4x66/', 'html5', 960, 540, 1576076683, '1', '0'),
(359, 'gamemonetize-1089', 'tower-of-hanoi-3d', 'Tower of Hanoi 3D', 'https://img.gamemonetize.com/t47j51em6ubkyf683eqwhbalty0lw20p/512x384.jpg', '0', 5, 0, '0', 'Tower of Hanoi is a puzzle game originally invented by the French mathematician François Édouard Anatole Lucas in 1883. The objective of the game is to move all the disks from the leftmost rod to the rightmost rod. Only one disk may be moved at a time and it is not possible to place a bigger disk on top of a smaller disk.', '', 'https://html5.gamemonetize.com/t47j51em6ubkyf683eqwhbalty0lw20p/', 'html5', 900, 600, 1576076683, '1', '0'),
(360, 'gamemonetize-1088', 'neon-splash', 'Neon Splash', 'https://img.gamemonetize.com/hsoh2p6ej8jp90vk69er7w4qhzs61zuj/512x384.jpg', '0', 5, 0, '0', 'Neon Splash is a brand new hypercasual puzzle game. Your goal is to guide glowing fluid into the dark, to find a hidden neon beauty! 150+ levels are waiting for you, can you finish them all?', '', 'https://html5.gamemonetize.com/hsoh2p6ej8jp90vk69er7w4qhzs61zuj/', 'html5', 550, 790, 1576076683, '1', '0'),
(361, 'gamemonetize-1087', 'fz-traffic-jam', 'FZ Traffic Jam', 'https://img.gamemonetize.com/tpvi9orn0m7laa350jgjn62tz8k7a5y4/512x384.jpg', '0', 8, 0, '0', 'FZ Traffic Jam you have to prevent crashes. You can stop and start cars by tapping on them.Game is quite challenging after few seconds. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/tpvi9orn0m7laa350jgjn62tz8k7a5y4/', 'html5', 800, 600, 1576076683, '1', '0'),
(362, 'gamemonetize-1086', 'elsa-magic-zoo', 'Elsa Magic Zoo', 'https://img.gamemonetize.com/mhcod1qu8eat8hwd3f2ov3kdy3on97dv/512x384.jpg', '0', 1, 0, '0', 'Rather, come to Elsa’s magical zoo. Look at how many wonderful fairy-tale animals are here: griffin, unicorn and even a dragon! Help the princess take care of these fantastic creatures. Have a great time with the game Elsa Magic Zoo.', '', 'https://html5.gamemonetize.com/mhcod1qu8eat8hwd3f2ov3kdy3on97dv/', 'html5', 800, 600, 1576076683, '1', '0'),
(363, 'gamemonetize-1085', 'extreme-bike-rider', 'Extreme Bike Rider', 'https://img.gamemonetize.com/mim63hfu0s829wzqjktpf6o53adou70g/512x384.jpg', '0', 2, 0, '0', 'Extreme Bike Rider is a fun platform game with cool levels and score system. Features: • Amazing graphics • 9 levels • Score system', '', 'https://html5.gamemonetize.com/mim63hfu0s829wzqjktpf6o53adou70g/', 'html5', 960, 600, 1576076683, '1', '0'),
(364, 'gamemonetize-1084', 'fz-water-crisis', 'FZ Water Crisis', 'https://img.gamemonetize.com/kcsq9qdfx2ey2c20lubx78knuttrikb2/512x384.jpg', '0', 5, 0, '0', 'Addictive puzzle game the aim is find the correct path to lead water to trees, increasing your brain bower IO with this amazing challenge game. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/kcsq9qdfx2ey2c20lubx78knuttrikb2/', 'html5', 800, 600, 1576076683, '1', '0'),
(365, 'gamemonetize-1083', 'fun-run-race-2-multiplayer', 'Fun Run Race 2 : Multiplayer', 'https://img.gamemonetize.com/p3hmuse2872voxmmw3lsd8g23hz0j078/512x384.jpg', '0', 4, 0, '0', 'Fun Run Race 2 is fun addictive adventure casual racing game and also the extension of Fun Run Race 3D .Clear all the hurdles and defeat your opponents to win the level .', '', 'https://html5.gamemonetize.com/p3hmuse2872voxmmw3lsd8g23hz0j078/', 'html5', 400, 600, 1576076683, '1', '0'),
(366, 'gamemonetize-1082', 'cute-pony-coloring-book', 'Cute Pony Coloring Book', 'https://img.gamemonetize.com/pc3yilnz0vowz15pbnwq1xx354mji8v7/512x384.jpg', '0', 1, 0, '0', 'Welcome, young artist! Show everyone your talents. Rather color these lovely pony. Choose cute shades and experiment. Take a screenshot and share the result with your friends!', '', 'https://html5.gamemonetize.com/pc3yilnz0vowz15pbnwq1xx354mji8v7/', 'html5', 800, 600, 1576076683, '1', '0'),
(367, 'gamemonetize-1081', 'princess-cool-graffiti', 'Princess Cool Graffiti', 'https://img.gamemonetize.com/che5za4ffk4sgos6lhkleeo4g3thc96o/512x384.jpg', '0', 1, 0, '0', 'Hey! Join street artists! Help turn dull walls into works of art. Use vibrant colors to create graffiti. Princess Jasmine also loves to dress up as a simple street artist and draw cool positive inscriptions. Go with her to vivid impressions right now!', '', 'https://html5.gamemonetize.com/che5za4ffk4sgos6lhkleeo4g3thc96o/', 'html5', 800, 600, 1576076683, '1', '0'),
(368, 'gamemonetize-1080', 'cowboy-hidden-stars', 'Cowboy Hidden Stars', 'https://img.gamemonetize.com/mix0si1jx152stg3446epx69sgpkifd4/512x384.jpg', '0', 5, 0, '0', 'Cowboy Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/mix0si1jx152stg3446epx69sgpkifd4/', 'html5', 1280, 720, 1576076683, '1', '0'),
(369, 'gamemonetize-1079', 'truck-hidden-cargo', 'Truck Hidden Cargo', 'https://img.gamemonetize.com/vxlfgj91ea1za2imfte8ivt1m3wntifo/512x384.jpg', '0', 5, 0, '0', 'In this Hidden Game you need to find 10 cargo&#039;s on each picture. You have time of 50 seconds. It will be easy and fun. Don&#039;t click more time wherever you want in the game or you will lose 5 seconds. Be focus on the game and enjoy.', '', 'https://html5.gamemonetize.com/vxlfgj91ea1za2imfte8ivt1m3wntifo/', 'html5', 1280, 720, 1576076683, '1', '0'),
(370, 'gamemonetize-1078', 'roasted-duck-2', 'roasted duck 2', 'https://img.gamemonetize.com/h4vxn1bqqd6lbn3mxf0det9fx3whidj0/512x384.jpg', '0', 5, 0, '0', 'Overcome the obstacles to collect all the eggs and pass the level. Game for one or two players play it on computer and smartphones', '', 'https://html5.gamemonetize.com/h4vxn1bqqd6lbn3mxf0det9fx3whidj0/', 'html5', 800, 600, 1576076683, '1', '0'),
(371, 'gamemonetize-1077', 'baby-bath-jigsaw', 'Baby Bath Jigsaw', 'https://img.gamemonetize.com/kqg4gx79gd09sq3d1cjlxehq4lpgfnlz/512x384.jpg', '0', 5, 0, '0', 'Baby Bath Jigsaw is a fun online puzzle game. Drag the pieces into right position using mouse. Solving puzzles is relaxing, rewarding, and keeps your brain sharp. You need to spend $1000 to be able to purchase one of the following pictures. You have three modes for each picture from which the hardest mode brings more money. You have a total of 10 pictures.', '', 'https://html5.gamemonetize.com/kqg4gx79gd09sq3d1cjlxehq4lpgfnlz/', 'html5', 960, 640, 1576076683, '1', '0'),
(372, 'gamemonetize-1076', 'christmas-time-difference', 'Christmas Time Difference', 'https://img.gamemonetize.com/ekdvn2ay9w87c060bubj2ehxg1bcskp7/512x384.jpg', '0', 5, 0, '0', 'Christmas Time Difference is an online game that you can play for free. Do you have a keen insight? Play the game Christmas Time Difference to have a test. The two images about the Christmas are very similar. However, there are five differences between them. Try you find the difference in less time. Good luck!', '', 'https://html5.gamemonetize.com/ekdvn2ay9w87c060bubj2ehxg1bcskp7/', 'html5', 960, 540, 1576076683, '1', '0'),
(373, 'gamemonetize-1075', 'fruit-sudoku', 'Fruit Sudoku', 'https://img.gamemonetize.com/rpnmlvdgvuepxe9gezrexptly2wkhfb8/512x384.jpg', '0', 5, 0, '0', 'Sudoku is a famous logic puzzle games. If you like sudoku games, this Fruit Sudoku games is for you. In Fruit Sudoku, you task is to fill all the cells with fruit. Each row, column or 3x3 cells must contain a fruit exactly once.', '', 'https://html5.gamemonetize.com/rpnmlvdgvuepxe9gezrexptly2wkhfb8/', 'html5', 1280, 1920, 1576076683, '1', '0'),
(374, 'gamemonetize-1074', 'leap-space', 'leap space', 'https://img.gamemonetize.com/cxq9h02itm10xr2tv6uvw4w8xuuh1g4d/512x384.jpg', '0', 4, 0, '0', 'The moon you were on was destroyed. jump into space to survive', '', 'https://html5.gamemonetize.com/cxq9h02itm10xr2tv6uvw4w8xuuh1g4d/', 'html5', 800, 600, 1576076683, '1', '0'),
(375, 'gamemonetize-1073', 'super-onion-boy', 'Super Onion Boy', 'https://img.gamemonetize.com/jtnau6xam3feocnkwi3xn5i4qc0l1kpk/512x384.jpg', '0', 4, 0, '0', 'Super Onion Boy is a fun platform game, your mission is to save the princess from the terrible monster that imprisoned her in a magic bubble, defeat all the monsters along the way and dodge obstacles until you reach the final boss and save the princess!', '', 'https://html5.gamemonetize.com/jtnau6xam3feocnkwi3xn5i4qc0l1kpk/', 'html5', 800, 450, 1576076683, '1', '0')";
$db[20] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(376, 'gamemonetize-1072', 'happy-fun-rider-wheels-2019', 'Happy Fun Rider Wheels 2019', 'https://img.gamemonetize.com/n8uatw6krd2hkbf87e2v2n16age0uv7i/512x384.jpg', '0', 4, 0, '0', 'happy rider wheels is a fun and free game is fairly easy to understand and play. happy rider wheels is an obstacle rag-doll extreme sports game, your goals is to reach the finish line.', '', 'https://html5.gamemonetize.com/n8uatw6krd2hkbf87e2v2n16age0uv7i/', 'html5', 800, 600, 1576076683, '1', '0'),
(377, 'gamemonetize-1071', 'mine-craft-io', 'Mine-Craft.io', 'https://img.gamemonetize.com/i004avdmt9jezvey9tjvuzv9h1l2e9kx/512x384.jpg', '0', 7, 0, '0', 'Mine-craft.io is a game based on minecraft. In Mine Craft, you can do the same thing as in a regular minecraft and even more! Get resources, build houses and various mechanisms, make friends, protect themselves from evil mobs at night and aggressive players.', '', 'https://html5.gamemonetize.com/i004avdmt9jezvey9tjvuzv9h1l2e9kx/', 'html5', 1000, 800, 1576076683, '1', '1'),
(378, 'gamemonetize-1070', 'super-mario-run', 'Super Mario Run', 'https://img.gamemonetize.com/pooszvaulpq40v81v8z3cfdpzau4hro6/512x384.jpg', '0', 7, 0, '0', 'Run with Mario and friends and help to rescue the princess, tap the screen to jump and make some tricks movements, Rush all the worlds and stomp the enemies to kill them, collect coins and buy Mario friend mask in the shop, be carefull with the spikes and saws, Run Fasters As possible and Help Mario to reach the best scores, Enjoy in Kiz10', '', 'https://html5.gamemonetize.com/pooszvaulpq40v81v8z3cfdpzau4hro6/', 'html5', 800, 400, 1576076683, '1', '1'),
(379, 'gamemonetize-1069', 'super-mario-run-2', 'Super Mario Run 2', 'https://img.gamemonetize.com/1pmkqzfdiaku4jk7bzalhaqj8muvtclv/512x384.jpg', '0', 7, 0, '0', 'A new kind of Mario game that you can play with one hand, to rescue the princess and save the world. You have to time your taps to pull off stylish jumps, midair spins, and wall jumps to gather coins and reach the goal… Buy new characters on shop and play all levels to find the princess. Have fun in Kiz10', '', 'https://html5.gamemonetize.com/1pmkqzfdiaku4jk7bzalhaqj8muvtclv/', 'html5', 800, 450, 1576076683, '1', '1'),
(380, 'gamemonetize-1068', 'soccer-physics-online', 'Soccer Physics Online', 'https://img.gamemonetize.com/dq2rg4zptft7an13oyo8pj4mx5rwpq23/512x384.jpg', '0', 1, 0, '0', 'Challenge an online player or a friend in two player mode in this fun 3D online soccer game.', '', 'https://html5.gamemonetize.com/dq2rg4zptft7an13oyo8pj4mx5rwpq23/', 'html5', 800, 600, 1576076683, '1', '0'),
(381, 'gamemonetize-1067', 'torture-the-trollface', 'Torture the Trollface', 'https://img.gamemonetize.com/oaja4x2n601capzpfvqx6ubvhlkgbl5z/512x384.jpg', '0', 1, 0, '0', 'Got some time to kick the trollface? You can torture this dummy in this awesome action game. Do it slowly or get it over quickly if you’d prefer. Collect coins and unlock all weapons. There are lot tools and weapons you can use to kick the troll. Some of them are knifes, machineguns, Shotgun, Spikes, bombs, traps etc.', '', 'https://html5.gamemonetize.com/oaja4x2n601capzpfvqx6ubvhlkgbl5z/', 'html5', 540, 720, 1576076683, '1', '0'),
(382, 'gamemonetize-1066', 'maya', 'maya', 'https://img.gamemonetize.com/2l9vbobcqs99g85dqrymy5oehlf4dwvg/512x384.jpg', '0', 4, 0, '0', 'The direction key controls the emitter&#039;s left and right directions, the space bar launches bubbles, after launching bubbles if there are three or more of the same color bubbles connected, can eliminate these bubbles and score... Very lovely painting style, good game.', '', 'https://html5.gamemonetize.com/2l9vbobcqs99g85dqrymy5oehlf4dwvg/', 'html5', 800, 600, 1576076683, '1', '0'),
(383, 'gamemonetize-1065', 'offroad-mania', 'Offroad Mania', 'https://img.gamemonetize.com/817p7wyrnobq1pt7zuq7sbxkygcb2f5b/512x384.jpg', '0', 2, 0, '0', 'OFFROAD MANIA — FUN OFF-ROADING TRAILS GAME Like off road games? Like 4×4 cars? Like challenge? You just have to see it! This car physics based game is for everyone, who like off road and challenge. WHAT WE’VE PREPARED FOR YOU? 120 levels with rocks, trees, bridges, springboards etc. 5 amazing 4×4 off road cars for fun Car physics based game Car and driver customizing Fun driving gameplay Colorful and clean game graphics', '', 'https://html5.gamemonetize.com/817p7wyrnobq1pt7zuq7sbxkygcb2f5b/', 'html5', 800, 600, 1576076683, '1', '0'),
(384, 'gamemonetize-1064', 'tangram-king', 'Tangram King', 'https://img.gamemonetize.com/42pektghaixaurm5cw46mzbh7xyito5x/512x384.jpg', '0', 5, 0, '0', 'The Tangram King is a dissection puzzle consisting of seven flat shapes, called tans, which are put together to form shapes. The objective of the puzzle is to form a specific shape (given only an outline or silhouette) using all seven pieces, which may not overlap. It is reputed to have been invented in China during the Song Dynasty, and then carried over to Europe by trading ships in the early 19th century.', '', 'https://html5.gamemonetize.com/42pektghaixaurm5cw46mzbh7xyito5x/', 'html5', 480, 600, 1576076683, '1', '0'),
(385, 'gamemonetize-1063', 'supra-drift-3d', 'Supra Drift 3D', 'https://img.gamemonetize.com/snoo7xzfsr69fyrqj7xpbsg3mcyx0obs/512x384.jpg', '0', 2, 0, '0', 'The Toyota Supra is known for many things in the automotive world. Not only because it&#039;s a cool car from the movies, but also because of it&#039;s great performance and overall a good machine to tune, race and drift. Now you&#039;re given the chance driving one of them in a realistic city environment. No worries about the consequences or running out of fuel. Just pure driving freedom. Go ahead and pick your colour, a nice body-kit and don&#039;t forget to put some new wheels on it when you&#039;re out in the city. The tuning options are also available there by clicking on the Gear icon. H', '', 'https://html5.gamemonetize.com/snoo7xzfsr69fyrqj7xpbsg3mcyx0obs/', 'html5', 960, 600, 1576076683, '1', '0'),
(386, 'gamemonetize-1062', 'chop-amp-mine', 'Chop &amp; Mine', 'https://img.gamemonetize.com/a9odqry1clp1ol7bvdfv9ibvvfwjvko6/512x384.jpg', '0', 4, 0, '0', 'Collect resources, woods, crystals and ancient bones of dinosaurs in this unique Idle game. Let your lumberjacks chop the woods, or go yourself under the ground to dig &amp; mine valuable resources Go underground and carve the way to your character to collect resources, but do not touch the explosive dynamites and bombs. The mining is endlessly generated.', '', 'https://html5.gamemonetize.com/a9odqry1clp1ol7bvdfv9ibvvfwjvko6/', 'html5', 500, 600, 1576076683, '1', '0'),
(387, 'gamemonetize-1061', 'santa-claus-adventures', 'Santa Claus Adventures', 'https://img.gamemonetize.com/y9yf2gei1fljwpp47tn34u2lp193rfuq/512x384.jpg', '0', 4, 0, '0', 'Santa Claus Adventures is a kids christmas game. Adventure with Santa. You need to collect colorful balls and avoid dangers. Press and tap the screen to send the Santa. There are 20 levels waiting for you. Have fun!', '', 'https://html5.gamemonetize.com/y9yf2gei1fljwpp47tn34u2lp193rfuq/', 'html5', 900, 540, 1576076683, '1', '0'),
(388, 'gamemonetize-1060', 'bts-dinosaur-coloring-book', 'BTS Dinosaur Coloring Book', 'https://img.gamemonetize.com/kzlmwitetark0ww8vx1cf7bgeyvptgsd/512x384.jpg', '0', 4, 0, '0', 'BTS Dinosaur Coloring Book is an online game that you can play for free. BTS Dinosaur Coloring Book is a coloring and drawing game for kids. In this game, we have four different dinosaur pictures. You can use different colors for coloring. You can choose your favorite dinosaur picture for the draw. Have a good time.', '', 'https://html5.gamemonetize.com/kzlmwitetark0ww8vx1cf7bgeyvptgsd/', 'html5', 854, 480, 1576076683, '1', '0'),
(389, 'gamemonetize-1059', 'monster-candy', 'Monster Candy', 'https://img.gamemonetize.com/hrbuibxld8bi3ua7ws84irdde5qbk1g2/512x384.jpg', '0', 5, 0, '0', 'In this game monsters want to eat candy. your job is to make to be 3 or more candy in the row and monster will eat them. Pass all levels and have fun in this matching game.', '', 'https://html5.gamemonetize.com/hrbuibxld8bi3ua7ws84irdde5qbk1g2/', 'html5', 720, 1280, 1576076683, '1', '0'),
(390, 'gamemonetize-1058', 'christmas-defense-for-gifts', 'Christmas Defense For Gifts', 'https://img.gamemonetize.com/m5udz0cl7lj3seunmovwj4jbey9ec0py/512x384.jpg', '0', 3, 0, '0', 'Do you like archery games? Don&#039;t let New Year&#039;s presents get to Christmas zombies. Defend your castle and gifts. You&#039;il have three lives in each section. Every time the zombie comes to the castle, he&#039;il steal his presents. Keep your eyes open and hunt the zombies without stealing Christmas presents!', '', 'https://html5.gamemonetize.com/m5udz0cl7lj3seunmovwj4jbey9ec0py/', 'html5', 900, 600, 1576076683, '1', '0'),
(391, 'gamemonetize-1057', 'cad-war-4', 'CAD War 4', 'https://img.gamemonetize.com/5jnnfsh8h9wrr3ndkzbi28c4rwrudqxi/512x384.jpg', '0', 3, 0, '0', 'Most recently, your soldier participated in a hostage rescue operation that ended successfully, all hostages were rescued and terrorists were imprisoned or destroyed. But here again on the control panel received a signal about the capture of hostages, that is, our soldier has no time to relax and need to return to the system. This time it happened in the far East, where a terrorist organization took control of several peaceful settlements.', '', 'https://html5.gamemonetize.com/5jnnfsh8h9wrr3ndkzbi28c4rwrudqxi/', 'html5', 960, 640, 1576076683, '1', '0'),
(392, 'gamemonetize-1056', 'water-crysis', 'Water Crysis', 'https://img.gamemonetize.com/iwewthf6us9b3n8c8djw1lu8xfyxbmyt/512x384.jpg', '0', 5, 0, '0', 'Water Crysis is a brand new addictive puzzle game the aim is find the correct path to lead water to trees, increasing your brain bower IO with this amazing challenge game.', '', 'https://html5.gamemonetize.com/iwewthf6us9b3n8c8djw1lu8xfyxbmyt/', 'html5', 450, 750, 1576076683, '1', '0'),
(393, 'gamemonetize-1055', 'sand-balls', 'Sand Balls', 'https://img.gamemonetize.com/xzhj8ujif2ymu0yf7x0h35z9t4wryiov/512x384.jpg', '0', 4, 0, '0', 'Sand Balls is fun addictive hyper casual game.Make a path for your balls . Avoid and crash obstacles. Get as many balls to finish as you can.', '', 'https://html5.gamemonetize.com/xzhj8ujif2ymu0yf7x0h35z9t4wryiov/', 'html5', 400, 600, 1576076683, '1', '0'),
(394, 'gamemonetize-1054', 'tractor-puzzle-farming', 'Tractor Puzzle Farming', 'https://img.gamemonetize.com/p9ty02pp2c5hqg4n0cttfmhgw6ov8ijx/512x384.jpg', '0', 5, 0, '0', 'In Tractor Puzzle Farming game you need to solve the farming puzzle. The goal of the game is easy. Go through all the areas without leaving any and without going through it twice. Use mouse or Arrows to play.', '', 'https://html5.gamemonetize.com/p9ty02pp2c5hqg4n0cttfmhgw6ov8ijx/', 'html5', 900, 600, 1576076683, '1', '0'),
(395, 'gamemonetize-1053', 'happy-fun-glass-draw-lines', 'Happy Fun Glass Draw Lines', 'https://img.gamemonetize.com/dplqmbo6a75wwp44xpwmh1rezl6a5dcj/512x384.jpg', '0', 5, 0, '0', 'The glass is so sad because it&#039;s empty. Your job is to draw a line and path to make the glass filled up with water and smile again! Try to find the best way to complete each level. You can come up with your own solution so be creative and don&#039;t be afraid to think out of the box!', '', 'https://html5.gamemonetize.com/dplqmbo6a75wwp44xpwmh1rezl6a5dcj/', 'html5', 800, 600, 1576076683, '1', '0'),
(396, 'gamemonetize-1052', 'bomb-the-gost-2019', 'Bomb The Gost 2019', 'https://img.gamemonetize.com/8984efejulti3dst33aih5y27ogze1em/512x384.jpg', '0', 5, 0, '0', 'Shoot the ghost down to keep the Halloween spirit.', '', 'https://html5.gamemonetize.com/8984efejulti3dst33aih5y27ogze1em/', 'html5', 800, 600, 1576076683, '1', '0'),
(397, 'gamemonetize-1051', 'merge-13', 'Merge 13', 'https://img.gamemonetize.com/rgp8js0jwsdt8cmt13ojt3jvks7w7dvy/512x384.jpg', '0', 5, 0, '0', 'Merge 13 is fun addictive puzzle game. Connect the numbers to each other by tapping and dragging them or link a sequence of numbers. You can connect the numbers either diagonally or adjacently.', '', 'https://html5.gamemonetize.com/rgp8js0jwsdt8cmt13ojt3jvks7w7dvy/', 'html5', 350, 600, 1576076683, '1', '0'),
(398, 'gamemonetize-1050', 'cdrone-survival', 'CDrone Survival', 'https://img.gamemonetize.com/mtfdavauo1irrgop1wntbpm1s2b6wk5j/512x384.jpg', '0', 3, 0, '0', 'Using the drone you will attack other robots in space. You must find the best way to deal with all of them. You must be quick enough to react to all their attacks. Just start playing, have fun and don&#039;t be afraid of anything and anyone!', '', 'https://html5.gamemonetize.com/mtfdavauo1irrgop1wntbpm1s2b6wk5j/', 'html5', 1280, 720, 1576076683, '1', '0'),
(399, 'gamemonetize-1049', 'chippolino', 'Chippolino', 'https://img.gamemonetize.com/dv8w8nx1jz749fyddwhgjna21hgo7juk/512x384.jpg', '0', 4, 0, '0', 'Chipollino is a running-jumping game. Run over the obastacles and pickup bloud to make your run more longer then other.', '', 'https://html5.gamemonetize.com/dv8w8nx1jz749fyddwhgjna21hgo7juk/', 'html5', 1280, 720, 1576076683, '1', '0'),
(400, 'gamemonetize-1048', 'arabian-night', 'Arabian Night', 'https://img.gamemonetize.com/53544c98dd6ox6xckaxgo828vb3qw8w1/512x384.jpg', '0', 5, 0, '0', 'Arabian Night Tic-Tac-Toe made impossible due to the computer&#039;s smart counter-move every turn.', '', 'https://html5.gamemonetize.com/53544c98dd6ox6xckaxgo828vb3qw8w1/', 'html5', 450, 800, 1576076683, '1', '0'),
(401, 'gamemonetize-1047', 'sanicball-downhill', 'Sanicball Downhill', 'https://img.gamemonetize.com/bjugz0ce7yzwccr6fbta1te7v9beq181/512x384.jpg', '0', 5, 0, '0', 'It&#039;s time to go fast... Really fast!! Today you will experience what it&#039;s like to be the one and only Sanic. In this endless rolling game you will put your skills to the test by going all the way down in a city filled skyscrapers where only the masters of players can survive. But be aware of the platforms as they get harder after each level. Do you think you can make it? Also don&#039;t forget to pick up boost pads to make the jumps and avoid obstacles along the course at all costs. Collect many rings to buy cool new characters too! Good luck Sanic, gotta go fast!', '', 'https://html5.gamemonetize.com/bjugz0ce7yzwccr6fbta1te7v9beq181/', 'html5', 960, 600, 1576076683, '1', '0'),
(402, 'gamemonetize-1046', 'traffic-io', 'Traffic.io', 'https://img.gamemonetize.com/xq20av1wsdqxsq8tpvvnphtpcljrus1s/512x384.jpg', '0', 1, 0, '0', 'In Traffic.io, you have to prevent crashes. You can stop and start cars by tapping on them. Game is quite challenging after few seconds.', '', 'https://html5.gamemonetize.com/xq20av1wsdqxsq8tpvvnphtpcljrus1s/', 'html5', 900, 600, 1576076683, '1', '0'),
(403, 'gamemonetize-1045', 'fz-sumo-battle', 'FZ Sumo Battle', 'https://img.gamemonetize.com/3ledd66v5zbp3h2pahpbh5maf35xbiaf/512x384.jpg', '0', 4, 0, '0', 'FZ Sumo Battle - is HTML5 game. you will become sumo and use your skill to play game. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/3ledd66v5zbp3h2pahpbh5maf35xbiaf/', 'html5', 800, 600, 1576076683, '1', '0'),
(404, 'gamemonetize-1044', 'boss-business-inc', 'Boss Business Inc.', 'https://img.gamemonetize.com/1rtxmjwhhg2b0791p1huu6sjqj0llaln/512x384.jpg', '0', 4, 0, '0', 'Boss Business Inc. is an office simulator game in which you are the boss. Hire employees and accept or deny their requests. Be careful! Your decisions will make your employees happy or sad. If motivation is too low, employees will do crazy things! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/1rtxmjwhhg2b0791p1huu6sjqj0llaln/', 'html5', 800, 600, 1576076683, '1', '0'),
(405, 'gamemonetize-1043', 'momo-horror-story', 'Momo Horror Story', 'https://img.gamemonetize.com/5fv1qjs4y57ltbk9q74zpteyeq3p6mob/512x384.jpg', '0', 4, 0, '0', 'Momo is a horror game based on the history of the message user &quot;momo&quot;. In the game, you will be a guy that contacts momo by message, and now he will be pursued by the monster of momo. You will have to complete some tasks before get rescued, like turn on the generator, find some keys, close windows etc...The objetive is to survive until the timer reachs 00:00 then, the police will arrive and you would able to escape. There are two modes in game, Classic and Gun mode.', '', 'https://html5.gamemonetize.com/5fv1qjs4y57ltbk9q74zpteyeq3p6mob/', 'html5', 900, 650, 1576076683, '1', '0'),
(406, 'gamemonetize-1042', 'slithercraft-io', 'SlitherCraft.io', 'https://img.gamemonetize.com/evckpufpla0xoqwf0ihlwvxy3pc04dzi/512x384.jpg', '0', 7, 0, '0', 'SlitherCraft.io - is MINECRAFT + SLITHER.IO in one dynamic io game! Grow a snake by eating different Minecraft blocks. Eating a diamond block you get the maximum number of points. Speed up on the left mouse button, but be careful you reduce the length of the snake. Throw TNT at enemies with the right mouse button and get to top one! You can provide insurance for your snake by surrounding yourself with your tail. In this case, you are in safe! You can get a score and blocks by killing enemy snake. Or you can donate your blocks to the enemy. And you can recover your snake by finding your place o', '', 'https://html5.gamemonetize.com/evckpufpla0xoqwf0ihlwvxy3pc04dzi/', 'html5', 1000, 800, 1576076683, '1', '1'),
(407, 'gamemonetize-1041', 'magic-world', 'Magic World', 'https://img.gamemonetize.com/9fjbfcbmwcdb9dgfimtzwbfd0nj5ww76/512x384.jpg', '0', 4, 0, '0', 'Magic World is fun addictive bubble shooter game.Your shiny ball buddies are here and do not expect from them anything less than long hours of fun and entertainment.', '', 'https://html5.gamemonetize.com/9fjbfcbmwcdb9dgfimtzwbfd0nj5ww76/', 'html5', 400, 600, 1576076683, '1', '0'),
(408, 'gamemonetize-1040', 'popcorn-burst', 'Popcorn Burst', 'https://img.gamemonetize.com/n1hbj5jhhvqnsm0x6kh0s1od7w882z1q/512x384.jpg', '0', 4, 0, '0', 'Hold to fill the bucket with popcorn. Do not drop anything and earn top rating! Tons of unique handcrafted levels will keep you entertained for hours!', '', 'https://html5.gamemonetize.com/n1hbj5jhhvqnsm0x6kh0s1od7w882z1q/', 'html5', 480, 600, 1576076683, '1', '0'),
(409, 'gamemonetize-1039', 'train-simulator-3d', 'Train Simulator 3D', 'https://img.gamemonetize.com/ajbxndmn9grs6h5ct1wzmyytym92l7uw/512x384.jpg', '0', 1, 0, '0', 'Train Simulator 3D is a fantastic simulator game in which you must try and become a successful train operator. You must try and drive a series of different trains successfully by balancing the accelerator and brakes. It might sound easy, but the controls are tricky and you must work hard to find the right speed.', '', 'https://html5.gamemonetize.com/ajbxndmn9grs6h5ct1wzmyytym92l7uw/', 'html5', 960, 640, 1576076683, '1', '0'),
(410, 'gamemonetize-1038', 'assault-zone-3d', 'Assault Zone 3D', 'https://img.gamemonetize.com/fpuggug8uub3hgbg33o1tkt8r47yebiu/512x384.jpg', '0', 3, 0, '0', 'Assault Zone 3D is a shooting game that lets you raid the enemy base and shoot them all. Be mindful of your surrounding because they might be just around the corner.', '', 'https://html5.gamemonetize.com/fpuggug8uub3hgbg33o1tkt8r47yebiu/', 'html5', 800, 680, 1576076683, '1', '0'),
(411, 'gamemonetize-1037', 'balls-rotate-3d', 'Balls Rotate 3D', 'https://img.gamemonetize.com/tn24zo7467lsvt7q9myzau6w8dfmwpfp/512x384.jpg', '0', 3, 0, '0', 'Control your 3d ball into the next point.', '', 'https://html5.gamemonetize.com/tn24zo7467lsvt7q9myzau6w8dfmwpfp/', 'html5', 800, 600, 1576076683, '1', '0'),
(412, 'gamemonetize-1036', 'bitcoin-clicker', 'Bitcoin Clicker', 'https://img.gamemonetize.com/jf232ikv637oysftpsufwib245zmjf03/512x384.jpg', '0', 1, 0, '0', 'In this game you can build your mining farm! Earn bitcoin -&gt; exchange them to dollars in dynamic stock exchange -&gt; buy more graphics cards, processors -&gt; mine more bitcoins. You can add up to 10 your cards to every section(rx and gtx).', '', 'https://html5.gamemonetize.com/jf232ikv637oysftpsufwib245zmjf03/', 'html5', 480, 720, 1576076683, '1', '0'),
(413, 'gamemonetize-1035', 'gibbet-archery-2019', 'GIBBET - ARCHERY 2019', 'https://img.gamemonetize.com/ub9zo24xa17paj9xsoxavls6ds07zt4t/512x384.jpg', '0', 1, 0, '0', 'Tired of always losing at Hangman? Now it’s time to get your own back on that noose-wielding bully! It gives you the chance to save the poor victims before they run out of breath!', '', 'https://html5.gamemonetize.com/ub9zo24xa17paj9xsoxavls6ds07zt4t/', 'html5', 800, 600, 1576076683, '1', '0'),
(414, 'gamemonetize-1034', 'bts-winks-coloring-book', 'BTS Winks Coloring Book', 'https://img.gamemonetize.com/cbgaxf4pktgf62v8zzqosvawmtaihynu/512x384.jpg', '0', 1, 0, '0', 'BTS Winks Coloring Book is an online game that you can play for free. Do you like painting? Come and play this game. You can choose the color you like from the color lead. Make the beauty girl more and more beautiful. Maybe you will be an artist! Have fun!', '', 'https://html5.gamemonetize.com/cbgaxf4pktgf62v8zzqosvawmtaihynu/', 'html5', 854, 480, 1576076683, '1', '0'),
(415, 'gamemonetize-1033', 'air-combat-slide', 'Air Combat Slide', 'https://img.gamemonetize.com/lerenj864vyq4q43hra35w486ktigrq1/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of the air combat. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/lerenj864vyq4q43hra35w486ktigrq1/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(416, 'gamemonetize-1032', 'antique-cars-puzzle', 'Antique Cars Puzzle', 'https://img.gamemonetize.com/ciink8d0aanbt91nvsxkxo56sz5yiwev/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Antique Cars Puzzle. All images is with the antique cars. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/ciink8d0aanbt91nvsxkxo56sz5yiwev/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(417, 'gamemonetize-1031', 'knife-ninja', 'Knife Ninja', 'https://img.gamemonetize.com/1tdgxk99fni5o4i6zw9p0p18u7dhxnmy/512x384.jpg', '0', 5, 0, '0', 'Knife Ninja is fun a fun-addicting and really challenging knife throwing game.Your goal is to throw all your knives to a huge target right in the middle of the screen. ... Hit the apples for some extra points and try to get the highest score ever seen!', '', 'https://html5.gamemonetize.com/1tdgxk99fni5o4i6zw9p0p18u7dhxnmy/', 'html5', 400, 600, 1576076683, '1', '0'),
(418, 'gamemonetize-1030', 'police-cars-jigsaw', 'Police Cars Jigsaw', 'https://img.gamemonetize.com/v3mypkeq9gjrmwm3ay7i47fbnzdgzubu/512x384.jpg', '0', 5, 0, '0', 'Police Cars Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/v3mypkeq9gjrmwm3ay7i47fbnzdgzubu/', 'html5', 960, 540, 1576076683, '1', '0'),
(419, 'gamemonetize-1029', 'little-restaurant-difference', 'Little Restaurant Difference', 'https://img.gamemonetize.com/gnr5tui1qpishx7obmb7ummh9rp4rnb7/512x384.jpg', '0', 5, 0, '0', 'Little Restaurant Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/gnr5tui1qpishx7obmb7ummh9rp4rnb7/', 'html5', 1280, 720, 1576076683, '1', '0'),
(420, 'gamemonetize-1028', 'sweet-truck', 'Sweet Truck', 'https://img.gamemonetize.com/o21mw70l8aby1l2lwdicq3nsj92eaq5y/512x384.jpg', '0', 2, 0, '0', 'This is collecting game where you need to collect more cookies as you can in one level. Earn points and try not to crash. Control the truck with arrow keys or click on the buttons on your screen if you play on your cell phone. Pass all levels it is easy and fun.', '', 'https://html5.gamemonetize.com/o21mw70l8aby1l2lwdicq3nsj92eaq5y/', 'html5', 860, 640, 1576076683, '1', '0'),
(421, 'gamemonetize-1027', 'drift-rush-3d', 'Drift Rush 3D', 'https://img.gamemonetize.com/a406jf50iffufz14i5kp6sfxyoi84iwe/512x384.jpg', '0', 2, 0, '0', 'Take it to the track in the super car of your choice. Customize your car and race! This game has 20 different tracks and 20 different game play modes. First, race for place. Second, slalom Race. Third, traffic mode. Finally, fourth is coin collection. Do well and earn stars that you can use to unlock other cars!', '', 'https://html5.gamemonetize.com/a406jf50iffufz14i5kp6sfxyoi84iwe/', 'html5', 800, 680, 1576076683, '1', '1'),
(422, 'gamemonetize-1026', 'basketball-simulator-3d', 'Basketball Simulator 3D', 'https://img.gamemonetize.com/q9ysnq2sz3t4d66xqgwovspl6figdb63/512x384.jpg', '0', 8, 0, '0', 'Basketball Simulator 3D is the sports simulation game in which you can prove your basketball skills by making shots from all different distances. First select your favorite team and then make shots before the time runs out. Make as many as you can to get a high score that you can be proud of.', '', 'https://html5.gamemonetize.com/q9ysnq2sz3t4d66xqgwovspl6figdb63/', 'html5', 960, 600, 1576076683, '1', '0'),
(423, 'gamemonetize-1025', 'princess-dark-phoenix', 'Princess Dark Phoenix', 'https://img.gamemonetize.com/yy4x8nnjcs79ghfufw0jqubg8vpgfl0d/512x384.jpg', '0', 1, 0, '0', 'Beautiful princess Jina reveals the hidden forces. She can command things and read minds. Help the Dark Phoenix Princess choose an outfit worthy of the most powerful superheroine. Just look at these magnificent fitting overalls, high boots and incredible fire accessories. Do not forget to put sparkling fiery makeup and put the fiery hair. Awaken the power of Phoenix in yourself by playing this wonderful game called “Princess Dark Phoenix”!', '', 'https://html5.gamemonetize.com/yy4x8nnjcs79ghfufw0jqubg8vpgfl0d/', 'html5', 800, 600, 1576076683, '1', '0'),
(424, 'gamemonetize-1024', 'military-wars-strike', 'Military Wars Strike', 'https://img.gamemonetize.com/9hpj5t68i7oe3rfb4e8cb3bbzr1ntpw3/512x384.jpg', '0', 3, 0, '0', 'Military Wars Strike is a 3D Multiplayer Shooter. This new version of the &quot;Military Wars&quot;-series has new weapons, new maps, and more. Your mission is to shoot and defeat your enemies. Collect Experience points and climb the rankings. Select between 4 different soldier classes and engage in heated gunfights on various different maps!', '', 'https://html5.gamemonetize.com/9hpj5t68i7oe3rfb4e8cb3bbzr1ntpw3/', 'html5', 800, 600, 1576076683, '1', '0'),
(425, 'gamemonetize-1023', 'maths-challenge', 'Maths Challenge', 'https://img.gamemonetize.com/039u0vmc99wuf5ozkoas4qhy6yyq5835/512x384.jpg', '0', 5, 0, '0', 'Maths Challenge is an online game that you can playfor free. It is math time! Are you ready? In the game, you need to answer some math questions in a limited time. The more you answered correctly, the higher score you will get. Come and have a try!', '', 'https://html5.gamemonetize.com/039u0vmc99wuf5ozkoas4qhy6yyq5835/', 'html5', 480, 854, 1576076683, '1', '0'),
(426, 'gamemonetize-1022', 'xtreme-spike-jumping-square', 'Xtreme Spike Jumping Square', 'https://img.gamemonetize.com/c0zd0b476fmjj6h9pdb6boxdqjy2uuq6/512x384.jpg', '0', 5, 0, '0', 'Prepare for a near impossible challenge in the world of Xtreme Spike Jumping Square. Push your skills to the limit as you jump, fly and flip your way through dangerous passages and spiky obstacles.', '', 'https://html5.gamemonetize.com/c0zd0b476fmjj6h9pdb6boxdqjy2uuq6/', 'html5', 800, 600, 1576076683, '1', '0'),
(427, 'gamemonetize-1021', 'sweet-babies-hidden-stars', 'Sweet Babies Hidden Stars', 'https://img.gamemonetize.com/kyc209zo0rnjpikgmyp42utzqwjsuk9f/512x384.jpg', '0', 5, 0, '0', 'Sweet Babies Hidden Stars is a wonderful online game with babies and hidden objects. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/kyc209zo0rnjpikgmyp42utzqwjsuk9f/', 'html5', 960, 540, 1576076683, '1', '0'),
(428, 'gamemonetize-1020', 'jet-pack-kid', 'Jet Pack Kid', 'https://img.gamemonetize.com/18ky89ytxu1a62lmv5my9wx9w9we7kn9/512x384.jpg', '0', 5, 0, '0', 'Click on screen to jump up and collect all candies. Jet Pack Kid is fun addictive adventure game.', '', 'https://html5.gamemonetize.com/18ky89ytxu1a62lmv5my9wx9w9we7kn9/', 'html5', 350, 600, 1576076683, '1', '0'),
(429, 'gamemonetize-1019', 'scary-tiki-mask-memory', 'Scary Tiki Mask Memory', 'https://img.gamemonetize.com/wijkg8df8uvtdtnnympt46p32nh8102y/512x384.jpg', '0', 5, 0, '0', 'Scary Tiki Mask Memory is a free online game from genre of memory and monsters games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/wijkg8df8uvtdtnnympt46p32nh8102y/', 'html5', 1280, 720, 1576076683, '1', '0'),
(430, 'gamemonetize-1018', 'hover-racer', 'Hover Racer', 'https://img.gamemonetize.com/1u0k8mbp9mo55a8422069we9tb8431u5/512x384.jpg', '0', 2, 0, '0', 'Hover Racer is a fun antigravity racer game. Features: - Hovership selection with upgrades - 3 maps - Reward system for completing each level - Weapon system', '', 'https://html5.gamemonetize.com/1u0k8mbp9mo55a8422069we9tb8431u5/', 'html5', 960, 540, 1576076683, '1', '0'),
(431, 'gamemonetize-1017', 'domino-fun-game-2019', 'Domino Fun Game 2019', 'https://img.gamemonetize.com/mr3c16rgvcwuy0eylgl3miy9e2sgo2ba/512x384.jpg', '0', 2, 0, '0', 'The goal of Domino Smash is to make the dominos topple! You do this by aiming your ball and firing it at the start of the domino chain.', '', 'https://html5.gamemonetize.com/mr3c16rgvcwuy0eylgl3miy9e2sgo2ba/', 'html5', 800, 600, 1576076683, '1', '0'),
(432, 'gamemonetize-1016', 'pixel-bighead-run', 'Pixel BigHead Run', 'https://img.gamemonetize.com/d615qw6tlbsdu5ztq0wmcv1x8gsia9do/512x384.jpg', '0', 2, 0, '0', '​Bighead Run Run is a simple and fun game suitable for people of all ages. Tap wisely to jump on the platforms and run as far as you can. Don’t fall, it hurts!​', '', 'https://html5.gamemonetize.com/d615qw6tlbsdu5ztq0wmcv1x8gsia9do/', 'html5', 800, 600, 1576076683, '1', '0'),
(433, 'gamemonetize-1015', 'gravity-russian-tumbler-toy', 'Gravity Russian Tumbler Toy', 'https://img.gamemonetize.com/0hdhmqgmf90w51tmq1ut9zt8r1twa5xa/512x384.jpg', '0', 2, 0, '0', 'Switch the gravity to control your Russian Tumbler toy to avoid the obstacles and reach the target. 30 levels to go. Play now!', '', 'https://html5.gamemonetize.com/0hdhmqgmf90w51tmq1ut9zt8r1twa5xa/', 'html5', 960, 540, 1576076683, '1', '0'),
(434, 'gamemonetize-1014', 'stack-the-blocks', 'Stack The Blocks', 'https://img.gamemonetize.com/fs6lbvhviey6fqbolelgkcd1wsbq8x5o/512x384.jpg', '0', 4, 0, '0', 'Stack the blocks as many as possible. - Cute and colorful blocks. - Realistic physics. - Fun and addictive Play now!', '', 'https://html5.gamemonetize.com/fs6lbvhviey6fqbolelgkcd1wsbq8x5o/', 'html5', 540, 960, 1576076683, '1', '0'),
(435, 'gamemonetize-1013', 'deep-sea-fishing', 'Deep Sea Fishing', 'https://img.gamemonetize.com/hkx8gtbvif8k13gty0et93x8efb54dim/512x384.jpg', '0', 1, 0, '0', 'Help Jimmy the penguin to catch all the fishes and learn about the Sea creatures.', '', 'https://html5.gamemonetize.com/hkx8gtbvif8k13gty0et93x8efb54dim/', 'html5', 960, 600, 1576076683, '1', '0'),
(436, 'gamemonetize-1012', 'princesses-bff-rush-to-school', 'Princesses BFF Rush to School', 'https://img.gamemonetize.com/4198piltjfchur7d1l99y1vc1lsjy0v2/512x384.jpg', '0', 1, 0, '0', 'The school year has just begun, and the princesses are already full of worries. They need to pack their school backpack. It’s not easy to find textbooks and notebooks scattered throughout the room! Princesses want to look good at school, they will also need fashionable clothes, cosmetics and perfumes. Where is the lipstick stocked ?! Friends just can’t do without your help! Rather, collect all the items from the list below. Play this fun game “Princesses BFF rush to school” on our site dl-girls.com for free!', '', 'https://html5.gamemonetize.com/4198piltjfchur7d1l99y1vc1lsjy0v2/', 'html5', 800, 600, 1576076683, '1', '0'),
(437, 'gamemonetize-1011', 'bottle-pop', 'Bottle Pop!', 'https://img.gamemonetize.com/z415qcx2622vm6a4oh8jn4kryo6fttrs/512x384.jpg', '0', 5, 0, '0', 'You have to pop bottles in the exciting arcade game Bottle Pop! Make the bottle explode, jump or even fly. How? Just tap the bottle! Explore over 100 levels, avoid all sorts of obstacles: lazers, teleporters, fans, gum, spikes, and even aliens! Train your reaction time, develop coordination, control the strength and distance of the pop.', '', 'https://html5.gamemonetize.com/z415qcx2622vm6a4oh8jn4kryo6fttrs/', 'html5', 455, 750, 1576076683, '1', '0'),
(438, 'gamemonetize-1010', 'papers-io-mania', 'Papers.io Mania', 'https://img.gamemonetize.com/l73no8xa3nwn0deb548ycbh3twsazdil/512x384.jpg', '0', 5, 0, '0', 'In this game, you fight for the space you share with other players/AI. But it&#039;s not as simple as it seems. You have to outwit your opponents and take up as much space as possible at the same time. You can choose from a lot of skins for your avatar too. So what are you waiting for? Jump into it and take the whole playing field for yourself!', '', 'https://html5.gamemonetize.com/l73no8xa3nwn0deb548ycbh3twsazdil/', 'html5', 800, 600, 1576076683, '1', '0'),
(439, 'gamemonetize-1009', 'pharaoh-slots-casino', 'Pharaoh Slots Casino', 'https://img.gamemonetize.com/n0t6fdw2j2loe2etg0m775ppzcymnlob/512x384.jpg', '0', 5, 0, '0', 'If you enjoy free slot machine games, then Pharaoh Slots Casino is the game for you. Just spin the wheels and try your luck! No money is required to play it. You win virtual coins. You will experience the full range of emotions without the fear of losing money. Play free slots with Wilds, Free Spins and Bonus game.', '', 'https://html5.gamemonetize.com/n0t6fdw2j2loe2etg0m775ppzcymnlob/', 'html5', 600, 800, 1576076683, '1', '0'),
(440, 'gamemonetize-1008', 'pizza-ninja-3', 'Pizza Ninja 3', 'https://img.gamemonetize.com/7yqbnjq481ur4ocfguckvvrtyzamp5sx/512x384.jpg', '0', 3, 0, '0', 'Pizza ingredients juggling through the air, ninja slicing skills needed! Customers need to be served quickly and also love to see the entertainment. So grab a knife and do your job! Get all the trophies in each game mode and be the best! Also new types of bonuses await!', '', 'https://html5.gamemonetize.com/7yqbnjq481ur4ocfguckvvrtyzamp5sx/', 'html5', 800, 600, 1576076683, '1', '0'),
(441, 'gamemonetize-1007', 'zombie-road', 'Zombie Road', 'https://img.gamemonetize.com/hwir7fgphprumokcu0vwrnd0uio20pmi/512x384.jpg', '0', 4, 0, '0', 'The dangerous post-apocalyptic world with zombies and only the bravest and most experienced drivers and the toughest survivors that are still left standing and fighting the countless armies of the undead. Thrilling racing game. Enjoy driving and smashing zombies', '', 'https://html5.gamemonetize.com/hwir7fgphprumokcu0vwrnd0uio20pmi/', 'html5', 600, 800, 1576076683, '1', '0'),
(442, 'gamemonetize-1006', 'fps-simulator', 'FPS Simulator', 'https://img.gamemonetize.com/ecu9zzlepalr60o2qkvzu2lgyt4510eg/512x384.jpg', '0', 3, 0, '0', 'FPS Simulator features: - multiple weapons - enemy bots', '', 'https://html5.gamemonetize.com/ecu9zzlepalr60o2qkvzu2lgyt4510eg/', 'html5', 960, 540, 1576076683, '1', '0'),
(443, 'gamemonetize-1005', 'candy-monster-jumping', 'Candy Monster Jumping', 'https://img.gamemonetize.com/fuu8hm9jnblsfam0bmc5gxjwkw3dleg0/512x384.jpg', '0', 5, 0, '0', 'Candy Monster Jumping is fun jumping game suitable for all ages. Jump on the platforms, collect candies and stay away from the enemies. Have fun playing and come back for more fun games.', '', 'https://html5.gamemonetize.com/fuu8hm9jnblsfam0bmc5gxjwkw3dleg0/', 'html5', 480, 854, 1576076683, '1', '0'),
(444, 'gamemonetize-1004', 'woodventure', 'Woodventure', 'https://img.gamemonetize.com/dvy8mz7xrfrsxrc0ryzvqua2tggcb3eo/512x384.jpg', '0', 5, 0, '0', 'Take a weekend trip through forest full of cute animals in this classic mahjong connect game. Mahjong connect games have simple rule: two tiles can be connected if path between them has maximum of two turns. Your target is to clear whole board. During game you can use three types of bonuses: - hint: will show you one of next possible match, - bomb: will blast random pair on board, - reshuffle: will reshuffle all tiles on board', '', 'https://html5.gamemonetize.com/dvy8mz7xrfrsxrc0ryzvqua2tggcb3eo/', 'html5', 800, 600, 1576076683, '1', '0'),
(445, 'gamemonetize-1003', 'galaxy-warriors', 'Galaxy Warriors', 'https://img.gamemonetize.com/zablqd95l6pkiw2beu5ahxw8wjdfdtvc/512x384.jpg', '0', 3, 0, '0', 'Take your Starship to fight! Cruise the Galaxy and shoot down formations of alien enemy fleets. Collect credits to upgrade your star fighter. Watch out for enemies shooting back and strong Bosses! Hordes of enemies can also be handled with various boosters at your disposal. Dodge the bullet hell and shoot &#039;em up!', '', 'https://html5.gamemonetize.com/zablqd95l6pkiw2beu5ahxw8wjdfdtvc/', 'html5', 600, 800, 1576076683, '1', '0'),
(446, 'gamemonetize-1002', '4-in-row-mania', '4 in Row Mania', 'https://img.gamemonetize.com/3t30j7l3emxp4fadvk9g4q8pzto3cpng/512x384.jpg', '0', 3, 0, '0', 'The classic and popular two-player connecting game! Be the first to connect four pieces of your colour in a vertically suspended grid. Set the difficulty level and play against the CPU or against a friend by taking turns and dropping your colourful pieces into the grid, trying to outsmart your opponent!', '', 'https://html5.gamemonetize.com/3t30j7l3emxp4fadvk9g4q8pzto3cpng/', 'html5', 800, 600, 1576076683, '1', '0'),
(447, 'gamemonetize-1001', 'basketball-smash', 'Basketball Smash', 'https://img.gamemonetize.com/afw3m1shjnvb288na8izq9i75aztrj72/512x384.jpg', '0', 8, 0, '0', 'In this basketball game all you have to do is keep dunking those shots. However, the time is quicky running out and leaves room for less and less mistakes along the road. Easy to learn, hard to master. Can you unlock all the balls? Jump with the ball and shoot the basket within the time limit. Tap, Dunk, Repeat!', '', 'https://html5.gamemonetize.com/afw3m1shjnvb288na8izq9i75aztrj72/', 'html5', 600, 800, 1576076683, '1', '0'),
(448, 'gamemonetize-1000', 'flat-jewels-match-3', 'Flat Jewels Match 3', 'https://img.gamemonetize.com/c5i3l9vi08js7ioydz06fgjqkxfiad3m/512x384.jpg', '0', 5, 0, '0', 'Flat Jewels Match 3 is classic match 3 game in modern flat design. Enjoy well known game mechanics in this simple yet addictive version. Select either Levels mode or Time Attack gameplay mode. In Levels mode you will go through 150 levels fulfilling simple tasks. In Time Attack mode you will aim to reach highest possible score in limited time.', '', 'https://html5.gamemonetize.com/c5i3l9vi08js7ioydz06fgjqkxfiad3m/', 'html5', 600, 800, 1576076683, '1', '0'),
(449, 'gamemonetize-999', 'mission-to-mars', 'Mission To Mars', 'https://img.gamemonetize.com/m791ho61o9lxleq73gqxhuh8vs9v1dzo/512x384.jpg', '0', 1, 0, '0', 'Control UFO and land on all landing platforms', '', 'https://html5.gamemonetize.com/m791ho61o9lxleq73gqxhuh8vs9v1dzo/', 'html5', 960, 600, 1576076683, '1', '0'),
(450, 'gamemonetize-998', 'roller-magnet', 'Roller Magnet', 'https://img.gamemonetize.com/e37yojflmqdjl945pycazf7t364s9nro/512x384.jpg', '0', 4, 0, '0', 'Roller Magnet is fun addictive hyper casual game.Move the magnet to attract the blocks and cubes but avoid the bombs have fun with this wonderful game.', '', 'https://html5.gamemonetize.com/e37yojflmqdjl945pycazf7t364s9nro/', 'html5', 400, 650, 1576076683, '1', '0'),
(451, 'gamemonetize-997', 'the-running-sheep', 'The Running Sheep', 'https://img.gamemonetize.com/m0wt3meiy5b50iopsm31xhxi9pq4ug9g/512x384.jpg', '0', 4, 0, '0', 'An endless game play full of different obstacles, make your character running through the mysterious forest path endlessly.', '', 'https://html5.gamemonetize.com/m0wt3meiy5b50iopsm31xhxi9pq4ug9g/', 'html5', 400, 650, 1576076683, '1', '0'),
(452, 'gamemonetize-996', 'air-fight', 'Air Fight', 'https://img.gamemonetize.com/uss7i2n5kzmhf6qdmrwztob640ofifnd/512x384.jpg', '0', 4, 0, '0', 'Shoot the enemy planes and make them collide in the ground to destroy them. A battle never seen before, now you can fight the enemies in the skies by making incredible maneuvers, knocking down balloons, destroying airplanes and cars on the ground.', '', 'https://html5.gamemonetize.com/uss7i2n5kzmhf6qdmrwztob640ofifnd/', 'html5', 1280, 720, 1576076683, '1', '0'),
(453, 'gamemonetize-995', 'crazy-shoot', 'Crazy Shoot', 'https://img.gamemonetize.com/tx9ox3k81ew966r85maccoc6q8hijmmc/512x384.jpg', '0', 8, 0, '0', 'Here we go with new Hyper casual game Soccer shoot in Crazy way , try to avoid from opponent players and kick the soccer ball and make it goal .', '', 'https://html5.gamemonetize.com/tx9ox3k81ew966r85maccoc6q8hijmmc/', 'html5', 450, 600, 1576076683, '1', '0'),
(454, 'gamemonetize-994', 'stickman-saw-3d', 'Stickman Saw 3D', 'https://img.gamemonetize.com/0i9u6lcbud4wtkl32km8ens7wfginpoo/512x384.jpg', '0', 9, 0, '0', 'Stickman Saw 3D is a brand new color saw game with true ASMR experience. Move color cubes and cescue the stickman. Avoid obstacles, saw only color cubes and shapes only.', '', 'https://html5.gamemonetize.com/0i9u6lcbud4wtkl32km8ens7wfginpoo/', 'html5', 480, 600, 1576076683, '1', '0'),
(455, 'gamemonetize-993', 'dangerous-racing', 'Dangerous Racing', 'https://img.gamemonetize.com/1niiua16tf3ighrkcas71nz71imiij2k/512x384.jpg', '0', 2, 0, '0', 'Dangerous Racing is fun addictive racing game.Avoid the obstacles in your way and collect fuel,lives and coins to play .Drive as much as you can before the fuel ends .Have fun with this wonderful racing game.', '', 'https://html5.gamemonetize.com/1niiua16tf3ighrkcas71nz71imiij2k/', 'html5', 400, 650, 1576076683, '1', '0'),
(456, 'gamemonetize-992', 'fz-tank-vs-tiles', 'FZ Tank vs Tiles', 'https://img.gamemonetize.com/kd25ns887955u432y3dwasnxweb2f1k0/512x384.jpg', '0', 2, 0, '0', 'FZ Tank vs Tiles - HTML5 Games. You can choose color to shot. Try your best to get high score. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/kd25ns887955u432y3dwasnxweb2f1k0/', 'html5', 800, 600, 1576076683, '1', '0'),
(457, 'gamemonetize-991', 'cartoon-car-jigsaw', 'Cartoon Car Jigsaw', 'https://img.gamemonetize.com/r2nirr9lh7io3y4rjygyj05w0smutlgl/512x384.jpg', '0', 5, 0, '0', 'Cartoon Car Jigsaw is a free online jigsaw puzzle game. You can select one of the three images and then select one of the four modes (16, 36, 64 and 100 pieces). Select your favorite picture and complete the jigsaw in the shortest time possible! Have fun and enjoy!', '', 'https://html5.gamemonetize.com/r2nirr9lh7io3y4rjygyj05w0smutlgl/', 'html5', 960, 540, 1576076683, '1', '0'),
(458, 'gamemonetize-990', 'sea-treasure-match-3', 'Sea Treasure Match 3', 'https://img.gamemonetize.com/lv6xalk0mqrnnqff99f9sdxb1l8o9mkv/512x384.jpg', '0', 5, 0, '0', 'Sea Treasure Match 3 is an online game that you can play for free. In the game Sea Treasure Match 3 you do this, incidentally solving a puzzle. Create lines of three or more identical shells, sea stars and other elements to accomplish the task set on the level. Time is limited.', '', 'https://html5.gamemonetize.com/lv6xalk0mqrnnqff99f9sdxb1l8o9mkv/', 'html5', 450, 800, 1576076683, '1', '0'),
(459, 'gamemonetize-989', 'angry-birds-racers-jigsaw', 'Angry Birds Racers Jigsaw', 'https://img.gamemonetize.com/me6r6i1d1ms6ohnn1slip0vddqnv87jv/512x384.jpg', '0', 5, 0, '0', 'Angry Birds Racers Jigsaw is a free online jigsaw puzzle game. You can select one of the three images and then select one of the four modes (16, 36, 64 and 100 pieces). Select your favorite picture and complete the jigsaw in the shortest time possible! Have fun and enjoy!', '', 'https://html5.gamemonetize.com/me6r6i1d1ms6ohnn1slip0vddqnv87jv/', 'html5', 960, 540, 1576076683, '1', '0'),
(460, 'gamemonetize-988', 'haunted-house-hidden-ghost', 'Haunted House Hidden Ghost', 'https://img.gamemonetize.com/f1s28b0d58fpb1744qsz33yva0v3bogq/512x384.jpg', '0', 5, 0, '0', 'Haunted House Hidden Ghost is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/f1s28b0d58fpb1744qsz33yva0v3bogq/', 'html5', 960, 540, 1576076683, '1', '0'),
(461, 'gamemonetize-987', 'lolirockstars-maker', 'Lolirockstars Maker', 'https://img.gamemonetize.com/n2t66ahlzounlgh7rnv4s26df131gk34/512x384.jpg', '0', 1, 0, '0', 'Girls - let&#039;s create a cool rock band! It&#039;s time for creativity. Rather, gather around herself BBF. Think up for each member of the group your unique image - hairstyle, dress or suit, accessories and of course - favorite song. Our maker will help you with this! You can not only choose different items for your heroine, but also change the color of many items! What rock star do you want to be? Let&#039;s find out with the game &quot;Lolirockstars maker&quot;!', '', 'https://html5.gamemonetize.com/n2t66ahlzounlgh7rnv4s26df131gk34/', 'html5', 800, 600, 1576076683, '1', '0'),
(462, 'gamemonetize-986', 'html5-parking-car', 'HTML5 Parking Car', 'https://img.gamemonetize.com/4ynpg8qokk8483984z658mdddoscwm10/512x384.jpg', '0', 2, 0, '0', 'Drive the car to the spot parking slot. Avoid any collision with other cars or walls. Park fast and safely to get more score. There are 10 challenging levels in this game. Complete all to be a winner.', '', 'https://html5.gamemonetize.com/4ynpg8qokk8483984z658mdddoscwm10/', 'html5', 1360, 540, 1576076683, '1', '0'),
(463, 'gamemonetize-985', 'toy-car-race', 'Toy Car Race', 'https://img.gamemonetize.com/9a7fsrvg23kykc3vgvwuwunnrtxi6nog/512x384.jpg', '0', 2, 0, '0', 'Toy Race Car is fun racing html5 game suitable for all ages. Guide your toy car on the tracks, collect as many coins as possible and stay away from the wooden boxes. Tap on the screen to change car position on the tacks. Ones you click a car goes down one track. Have fun playing.', '', 'https://html5.gamemonetize.com/9a7fsrvg23kykc3vgvwuwunnrtxi6nog/', 'html5', 854, 480, 1576076683, '1', '0'),
(464, 'gamemonetize-984', 'battle-of-tanks-tank-wars-fullscreen-hd-game', 'Battle of Tanks | Tank Wars Fullscreen HD Game', 'https://img.gamemonetize.com/zgxgo3y7bw8f1755azj1vrd2iy6bh35g/512x384.jpg', '0', 2, 0, '0', 'Mobile-friendly, Fullscreen Game. It&#039;s a war zone. You must save your house, your fortress from the enemies. Shoot them, kill all the enemy tanks and make sure they cannot reach your fort and blast it. It&#039;s many against one so your advantage is that you can collect different powers whenever they appear. Go for the kill and win all levels in this multi-level FUN Game by Pixellicious. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even o', '', 'https://html5.gamemonetize.com/zgxgo3y7bw8f1755azj1vrd2iy6bh35g/', 'html5', 800, 600, 1576076683, '1', '0'),
(465, 'gamemonetize-983', 'shooting-the-zombies-fullscreen-hd-shooting-game', 'Shooting the Zombies, Fullscreen HD Shooting Game', 'https://img.gamemonetize.com/osejkvj7e69absspwezl09uw09eildqa/512x384.jpg', '0', 3, 0, '0', 'The Zombie Shooter is on a mission to kill all the zombies but, it&#039;s not that easy, there are obstacles and angles involved. Zombies are not standing right in front your bullets will ricochet from screen edge and objects so pick the right angle to shoot. Have a blast. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile.', '', 'https://html5.gamemonetize.com/osejkvj7e69absspwezl09uw09eildqa/', 'html5', 800, 600, 1576076683, '1', '0'),
(466, 'gamemonetize-982', 'roller-smash', 'Roller Smash', 'https://img.gamemonetize.com/5dsyfrwsvassqhrblq3n3ox8uvl2co5i/512x384.jpg', '0', 4, 0, '0', 'Roll the magnet ball through the level, but what if you can destruct everything by the magnetic force of the ball! Simple controls but hard to master. Avoid the bad stuff and try your best to collect all the cubes!', '', 'https://html5.gamemonetize.com/5dsyfrwsvassqhrblq3n3ox8uvl2co5i/', 'html5', 480, 600, 1576076683, '1', '0')";
$db[21] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(467, 'gamemonetize-981', 'domino-falls-3d', 'Domino Falls 3D', 'https://img.gamemonetize.com/o6x9uwvs5wsz47197ed39zkfd51q71gv/512x384.jpg', '0', 4, 0, '0', 'You will be saved from pressure by the magical domino effect. Aim at one domino and shot it to strike all down! Challenge different levels and see what surprise are waiting for you after the dominos fall.', '', 'https://html5.gamemonetize.com/o6x9uwvs5wsz47197ed39zkfd51q71gv/', 'html5', 480, 600, 1576076683, '1', '0'),
(468, 'gamemonetize-980', 'archery-training', 'Archery Training', 'https://img.gamemonetize.com/i2nupld90wo6ll39mp69t5ifres3u1ic/512x384.jpg', '0', 8, 0, '0', 'Practice your aim by shooting the test arrows to try to catch them in the center of the target. Every time you will be more and more wind to add difficulty to your target.', '', 'https://html5.gamemonetize.com/i2nupld90wo6ll39mp69t5ifres3u1ic/', 'html5', 1280, 720, 1576076683, '1', '0'),
(469, 'gamemonetize-979', 'real-zombie-shooter', 'Real Zombie Shooter', 'https://img.gamemonetize.com/ru7cbh5amgpz4ml0w6d5rtbm42hy2b8t/512x384.jpg', '0', 3, 0, '0', 'Try your skills and fight against blood-thirsty zombies in this cartoon-style game! You are soldier, and soldiers have there own code. Fight hard and die with style, that is death over surrender! Good Luck!', '', 'https://html5.gamemonetize.com/ru7cbh5amgpz4ml0w6d5rtbm42hy2b8t/', 'html5', 960, 600, 1576076683, '1', '0'),
(470, 'gamemonetize-978', 'crown-run-western-zombies', 'Crown Run Western Zombies', 'https://img.gamemonetize.com/dlcluod5bhfj5k1odg3l9ezg6olrht4u/512x384.jpg', '0', 3, 0, '0', 'Welcome to running the crown to become a zombie. This time you are horde of zombie and need to grow by eating Indian and cowboy in this cool polygon environment. Grow in number of zombies to win.', '', 'https://html5.gamemonetize.com/dlcluod5bhfj5k1odg3l9ezg6olrht4u/', 'html5', 800, 600, 1576076683, '1', '0'),
(471, 'gamemonetize-977', 'marble-balls-3d', 'Marble Balls 3D', 'https://img.gamemonetize.com/ziiaj3dpthawl9hzxbha3ka0jfeheove/512x384.jpg', '0', 5, 0, '0', 'Become a marble maze master in this brand new game. Find the right path by knocking marbles against each other, and defeat every level!', '', 'https://html5.gamemonetize.com/ziiaj3dpthawl9hzxbha3ka0jfeheove/', 'html5', 480, 600, 1576076683, '1', '0'),
(472, 'gamemonetize-976', 'word-search', 'Word Search', 'https://img.gamemonetize.com/tgdmjoexdk2rjvfk2eyvmhx4ibugauz3/512x384.jpg', '0', 5, 0, '0', 'An educational puzzle game with more than 2000 levels to solve! Seek Hidden words, find success in different vocabulary categories, and test your English Language skills. Its all about getting better here. Show some word making madness!', '', 'https://html5.gamemonetize.com/tgdmjoexdk2rjvfk2eyvmhx4ibugauz3/', 'html5', 600, 900, 1576076683, '1', '0'),
(473, 'gamemonetize-975', 'water-boat-fun-racing', 'Water Boat Fun Racing', 'https://img.gamemonetize.com/mzesx0ldjhnba8vcp3sdd32b52b5fnf2/512x384.jpg', '0', 4, 0, '0', 'Its fun game with one click control. Control the running boat and smash the boxes, wheels, drums placed on the way. Avoid striking the rocks else you end your life. It simple game to play but hard to clear the higher levels.', '', 'https://html5.gamemonetize.com/mzesx0ldjhnba8vcp3sdd32b52b5fnf2/', 'html5', 500, 700, 1576076683, '1', '0'),
(474, 'gamemonetize-974', 'santa-claus-gift-challenge', 'Santa Claus Gift Challenge', 'https://img.gamemonetize.com/qzoynyrrap7g33zlpq31djx91e6vzv1p/512x384.jpg', '0', 4, 0, '0', 'Santa Claus Gift Challenge is fun jumping html5 game that you can play online for free. In this game you need to help Santa Claus to collect as many gifts as possible. Jump around at the right moment and collect gifts. Have fun playing and Marry Marry Christmas to you all!', '', 'https://html5.gamemonetize.com/qzoynyrrap7g33zlpq31djx91e6vzv1p/', 'html5', 854, 480, 1576076683, '1', '0'),
(475, 'gamemonetize-973', 'color-boxes', 'Color Boxes', 'https://img.gamemonetize.com/flsxwyc7cfov6onp5286jc7y4h8orqs7/512x384.jpg', '0', 5, 0, '0', 'Your aim is to collect boxes that enter the screen. They are in two colors, black and white and you can change the color of your main box by touching or clicking on the screen. In order to collect incoming boxes, central box and these ones should have the same color. So do your best to match the correct color and collect as much boxes as you can!', '', 'https://html5.gamemonetize.com/flsxwyc7cfov6onp5286jc7y4h8orqs7/', 'html5', 480, 640, 1576076683, '1', '0'),
(476, 'gamemonetize-972', 'pretty-butterfly-coloring', 'Pretty Butterfly Coloring', 'https://img.gamemonetize.com/qo4nry64buxxbux4h7geg5nuvt2kl89c/512x384.jpg', '0', 5, 0, '0', 'Pretty Butterfly Coloring is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/qo4nry64buxxbux4h7geg5nuvt2kl89c/', 'html5', 1280, 720, 1576076683, '1', '0'),
(477, 'gamemonetize-971', 'action-super-hero', 'Action Super Hero', 'https://img.gamemonetize.com/5a80lqe2erllkclevasdpt3t4m77sqcx/512x384.jpg', '0', 5, 0, '0', 'Collect more coins as you can and destroy your enemies. Sometimes you need to avoid them, because if you hit with enemies, you will lose energy and you can finish the game earlier.', '', 'https://html5.gamemonetize.com/5a80lqe2erllkclevasdpt3t4m77sqcx/', 'html5', 1280, 720, 1576076683, '1', '0'),
(478, 'gamemonetize-970', 'mr-bean-car-hidden-keys', 'Mr. Bean Car Hidden Keys', 'https://img.gamemonetize.com/667o4xx4ql9sy291ciivb2obotgut3kz/512x384.jpg', '0', 5, 0, '0', 'Mr. Bean Car Hidden Keys is a free online skill and hidden object game. Find out the hidden keys in the specified images. Each level has 10 hidden keys. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/667o4xx4ql9sy291ciivb2obotgut3kz/', 'html5', 960, 540, 1576076683, '1', '0'),
(479, 'gamemonetize-969', 'earth-invaders', 'Earth Invaders', 'https://img.gamemonetize.com/559unolqhttaad73ztpo55jczyfbkevp/512x384.jpg', '0', 3, 0, '0', 'Earth Invaders is an online game that you can play for free. Earth Invaders is an interesting shooting game. Defend the earth from invaders, destroy invaders, open your fighter planes and shoot at invaders! Don&#039;t be afraid of any difficulties. And don&#039;t be afraid that their fighter planes are bigger than ours. Our fighters are the best!', '', 'https://html5.gamemonetize.com/559unolqhttaad73ztpo55jczyfbkevp/', 'html5', 854, 480, 1576076683, '1', '0'),
(480, 'gamemonetize-968', 'balls-fill-3d', 'Balls Fill 3D', 'https://img.gamemonetize.com/sarpphur2an0o1fonlr3m47atzcsvzgo/512x384.jpg', '0', 5, 0, '0', 'Christmas is coming. Santa wants to bring out the twisted eggs for the coming of the festival. Can you help Santa put the twisted eggs into the bottle successfully? How to play: tap to rotate obstacles after finish press &quot;Ready&quot; button and tap to pour out balls.', '', 'https://html5.gamemonetize.com/sarpphur2an0o1fonlr3m47atzcsvzgo/', 'html5', 450, 750, 1576076683, '1', '0'),
(481, 'gamemonetize-967', 'paint-run', 'Paint Run', 'https://img.gamemonetize.com/pmv86c06dk4mu9vybyo3e3ivwvg7t59j/512x384.jpg', '0', 5, 0, '0', 'Paint Run 3D is a brand new satisfying game with color the path. Play like painter to make all path become color with paint. Tap to paint the path, avoid opposite color crowd.', '', 'https://html5.gamemonetize.com/pmv86c06dk4mu9vybyo3e3ivwvg7t59j/', 'html5', 450, 750, 1576076683, '1', '0'),
(482, 'gamemonetize-966', 'ball-fill-3d', 'Ball Fill 3D', 'https://img.gamemonetize.com/bsntj5urnp2jcb11vqtxekbbtmdnfcrq/512x384.jpg', '0', 5, 0, '0', 'Christmas is coming. Santa wants to bring out the twisted eggs for the coming of the festival. Can you help Santa put the twisted eggs into the bottle successfully?', '', 'https://html5.gamemonetize.com/bsntj5urnp2jcb11vqtxekbbtmdnfcrq/', 'html5', 450, 750, 1576076683, '1', '0'),
(483, 'gamemonetize-965', 'super-bowmasters', 'Super Bowmasters', 'https://img.gamemonetize.com/5mkmynq4be442ueej5j4l6pommnieubj/512x384.jpg', '0', 5, 0, '0', 'Test your skills and play one of the most competitive archery games ever created. Master all the places and discover their secrets. Be the best archer and dominate the rankings! Super bowmasters games is the hottest and most realistic archery simulation game for you. Each level you have a certain number of arrows. Your task is to use a bow to shoot arrows The most accurate way to achieve the highest score.', '', 'https://html5.gamemonetize.com/5mkmynq4be442ueej5j4l6pommnieubj/', 'html5', 800, 480, 1576076683, '1', '0'),
(484, 'gamemonetize-964', 'dig-water-puzzle', 'Dig Water Puzzle', 'https://img.gamemonetize.com/tg2fdi08st1du8qfondcf8kqqpj6dom6/512x384.jpg', '0', 5, 0, '0', 'Dig Water is very simple but at the same time very exciting. Just dig sand and flow water to rescue the burning palnts. Dig sand – flow water and rescue.', '', 'https://html5.gamemonetize.com/tg2fdi08st1du8qfondcf8kqqpj6dom6/', 'html5', 450, 750, 1576076683, '1', '0'),
(485, 'gamemonetize-963', 'waterpark-slide-io', 'WaterPark Slide.io', 'https://img.gamemonetize.com/lsq291nk3vjj1niz3b4dw3eq07lgz7jk/512x384.jpg', '0', 4, 0, '0', 'WaterPark Slide.io for Aqua park is a sliding io game. Can you beat all others without hitting blocks and dropping the water? Go to the end of the Aqua park to become the 1st io player! Have fun playing this joyful and colorful water slide game. Push others in Waterpark race.io!', '', 'https://html5.gamemonetize.com/lsq291nk3vjj1niz3b4dw3eq07lgz7jk/', 'html5', 900, 600, 1576076683, '1', '0'),
(486, 'gamemonetize-962', 'path-paint-3d', 'Path Paint 3D', 'https://img.gamemonetize.com/byjwm9qcs0vgzbeoydtpqxjk3zagw5b8/512x384.jpg', '0', 4, 0, '0', 'Path Paint 3D is fun addictive hyper casual arcade game.Click and hold to paint the road. Can you paint all the way to finish line?', '', 'https://html5.gamemonetize.com/byjwm9qcs0vgzbeoydtpqxjk3zagw5b8/', 'html5', 960, 600, 1576076683, '1', '0'),
(487, 'gamemonetize-961', 'roll-run-3d', 'Roll Run 3D', 'https://img.gamemonetize.com/z9ktl7tosune3hu65l1g2wy9cey55bv4/512x384.jpg', '0', 4, 0, '0', 'Roll Run 3D is New Unique Concept with Rolling , Just Tap to Roll Ball and Reach Destination , Be Aware with Obstacles . Have Fun.', '', 'https://html5.gamemonetize.com/z9ktl7tosune3hu65l1g2wy9cey55bv4/', 'html5', 900, 600, 1576076683, '1', '0'),
(488, 'gamemonetize-960', 'zipline-puzzle', 'Zipline Puzzle', 'https://img.gamemonetize.com/d3buksa53xlmapnh6kldj5pjpj6dzb3d/512x384.jpg', '0', 5, 0, '0', 'Here new Brand Top No 1 Puzzle Game with Zipline, Draw Rope Path and Rescue People, Ready for Tune the Brain and Avoid Obstacles. Enjoy the Zipline Draw Path Puzzle and have fun! Don’t Miss the Exclusive Game! Check it now!', '', 'https://html5.gamemonetize.com/d3buksa53xlmapnh6kldj5pjpj6dzb3d/', 'html5', 450, 750, 1576076683, '1', '0'),
(489, 'gamemonetize-959', 'bottle-tap', 'Bottle Tap', 'https://img.gamemonetize.com/z63qfxbqj0b6juqg3m0zw8fhtso5jemj/512x384.jpg', '0', 5, 0, '0', 'Bottle Tap is a very interesting physics puzzle game. You need to tap the bottles and make the juice collect stars. Use your physics knowledge and intelligence to pass more levels. If you like puzzle games, please don&#039;t miss this one, you will fall in love with Bottle Tap!', '', 'https://html5.gamemonetize.com/z63qfxbqj0b6juqg3m0zw8fhtso5jemj/', 'html5', 450, 750, 1576076683, '1', '0'),
(490, 'gamemonetize-958', 'paint-run-3d', 'Paint Run 3D', 'https://img.gamemonetize.com/bd42vn60r9dr4nsw6ejjcxadd8gevu86/512x384.jpg', '0', 4, 0, '0', 'Paint Run 3D is a brand new satisfying game with color the path. Play like painter to make all path become color with paint. Tap to paint the path, avoid opposite color crowd.', '', 'https://html5.gamemonetize.com/bd42vn60r9dr4nsw6ejjcxadd8gevu86/', 'html5', 500, 750, 1576076683, '1', '0'),
(491, 'gamemonetize-957', 'space-ball', 'Space Ball', 'https://img.gamemonetize.com/e9i9a9c5rso12b15y3aio0ymtlzx4qej/512x384.jpg', '0', 4, 0, '0', 'Space Ball is the best endless runner Arcade game.Move the ball and avoid the obstacle .', '', 'https://html5.gamemonetize.com/e9i9a9c5rso12b15y3aio0ymtlzx4qej/', 'html5', 400, 600, 1576076683, '1', '0'),
(492, 'gamemonetize-956', 'bird-simulator', 'Bird Simulator', 'https://img.gamemonetize.com/v0ap03gz77p5idffw3d94p8vql3pg23b/512x384.jpg', '0', 4, 0, '0', 'Features: Physics-based bird controlling Cartoon art Simulation gameplay Bird sounds Tip: To take off, hold Space and S.', '', 'https://html5.gamemonetize.com/v0ap03gz77p5idffw3d94p8vql3pg23b/', 'html5', 960, 600, 1576076683, '1', '0'),
(493, 'gamemonetize-955', 'simple-football-kicking', 'Simple Football Kicking', 'https://img.gamemonetize.com/mu3bqhmu70ch5zzvaaqd1jvtojca4r2r/512x384.jpg', '0', 4, 0, '0', 'Ready for real kicking football? Here you have the chance to use your skill in the Simple Football Kicking game.', '', 'https://html5.gamemonetize.com/mu3bqhmu70ch5zzvaaqd1jvtojca4r2r/', 'html5', 800, 600, 1576076683, '1', '0'),
(494, 'gamemonetize-954', 'formula-1-race', 'Formula 1 Race', 'https://img.gamemonetize.com/0klgiozzdsbppjb16apnxwnxbsjez29z/512x384.jpg', '0', 2, 0, '0', 'Formula One cars are the fastest regulated road-course racing cars in the world, compete against other high speed Formula 1 cars. Unlock new cars for better speed from the prize money. If you can reach up to the final then you are the real boss. Have fun completing this circuit race in time. Track is all yours!', '', 'https://html5.gamemonetize.com/0klgiozzdsbppjb16apnxwnxbsjez29z/', 'html5', 1200, 600, 1576076683, '1', '0'),
(495, 'gamemonetize-953', 'protect-the-car', 'Protect the car', 'https://img.gamemonetize.com/lnxsf15jobn6tucupqcjs8lwl8rmmji7/512x384.jpg', '0', 2, 0, '0', 'In this game you have to move from one side to another to dodge everything that crosses your path. along the way you will find &quot;power up&quot; to be able to move faster', '', 'https://html5.gamemonetize.com/lnxsf15jobn6tucupqcjs8lwl8rmmji7/', 'html5', 320, 300, 1576076683, '1', '0'),
(496, 'gamemonetize-952', 'hand-doctor-hospital', 'Hand Doctor Hospital', 'https://img.gamemonetize.com/ukb2566mju1fk93l7pcqoxtuz5xuehz8/512x384.jpg', '0', 1, 0, '0', 'The hospital is overcrowded and we need your help. Play Hand Doctor and help the patients to be healthy again. Features: • Multiple characters • Good graphics', '', 'https://html5.gamemonetize.com/ukb2566mju1fk93l7pcqoxtuz5xuehz8/', 'html5', 540, 720, 1576076683, '1', '0'),
(497, 'gamemonetize-951', 'snow-war-io', 'Snow War .io', 'https://img.gamemonetize.com/1xi00mabdkhp0rxalrnpjclonywa2no4/512x384.jpg', '0', 1, 0, '0', 'Snow War .io features: - fun io gameplay - good graphics', '', 'https://html5.gamemonetize.com/1xi00mabdkhp0rxalrnpjclonywa2no4/', 'html5', 960, 540, 1576076683, '1', '0'),
(498, 'gamemonetize-950', 'pop-corn-fever', 'Pop Corn Fever', 'https://img.gamemonetize.com/nu3nbyh86tmj4cgwwqcho5mfjy1sjir7/512x384.jpg', '0', 4, 0, '0', 'Pop Corn Fever is fun addictive hyper casual game.Fill the pop corn tub without wasting any popcorn. The shape will change of pop corn tub in every level.Click to Blast the Popcorn Have Fun, How to play: Click the left mouse to hold and fill the tub with pop corns.', '', 'https://html5.gamemonetize.com/nu3nbyh86tmj4cgwwqcho5mfjy1sjir7/', 'html5', 400, 600, 1576076683, '1', '0'),
(499, 'gamemonetize-949', 'dig-water', 'Dig Water', 'https://img.gamemonetize.com/ye1652nv3h6ron154trbwyiwhbtyzhrx/512x384.jpg', '0', 5, 0, '0', 'Help dig channels for water to put out the poor pineapples, a fun game that develops logic.', '', 'https://html5.gamemonetize.com/ye1652nv3h6ron154trbwyiwhbtyzhrx/', 'html5', 450, 750, 1576076683, '1', '0'),
(500, 'gamemonetize-948', 'maglu', 'Maglu', 'https://img.gamemonetize.com/snf957ajslencwmx2m22jny8p1pk3ytw/512x384.jpg', '0', 4, 0, '0', 'An evil wizard took our pet, try to reach the end to retrieve it. With the experience that we will gather along the way, it will help us increase our skills and resist more on the way.', '', 'https://html5.gamemonetize.com/snf957ajslencwmx2m22jny8p1pk3ytw/', 'html5', 512, 300, 1576076683, '1', '0'),
(501, 'gamemonetize-947', 'bug-buddies-match-3', 'Bug Buddies Match 3', 'https://img.gamemonetize.com/ud4yux67889f8kcv0whne3phxmmdtnan/512x384.jpg', '0', 5, 0, '0', 'Bug Buddies Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful summer style! Enjoy the game!', '', 'https://html5.gamemonetize.com/ud4yux67889f8kcv0whne3phxmmdtnan/', 'html5', 960, 540, 1576076683, '1', '0'),
(502, 'gamemonetize-946', 'desert-car', 'Desert car', 'https://img.gamemonetize.com/r6k5q5d9tg4uv6yzny0icem7zy1w22rt/512x384.jpg', '0', 2, 0, '0', 'A &quot;Shoot and jump&quot; style game in which we drive a car in the desert equipped with a missile launcher. You start with 3 lives, the road is long, you have to be fast', '', 'https://html5.gamemonetize.com/r6k5q5d9tg4uv6yzny0icem7zy1w22rt/', 'html5', 800, 450, 1576076683, '1', '0'),
(503, 'gamemonetize-945', 'calculame', 'Calculame', 'https://img.gamemonetize.com/wc3lkbms82ygnpxddfnd24cku67sprml/512x384.jpg', '0', 4, 0, '0', 'Have fun playing with the numbers. Solve mathematical calculations before your time runs out. -Try to reach the third difficulty before time runs out -Unlock skills and aids to achieve the highest possible score -Overcome your limit', '', 'https://html5.gamemonetize.com/wc3lkbms82ygnpxddfnd24cku67sprml/', 'html5', 720, 1280, 1576076683, '1', '0'),
(504, 'gamemonetize-944', 'avocado-mother', 'Avocado Mother', 'https://img.gamemonetize.com/tu374jfdun3k2qclz35pyndyjrkq6x8z/512x384.jpg', '0', 4, 0, '0', 'We need to gather the 6 seeds of each mother avocado in order to gather the scattered avocado family throughout the kitchen', '', 'https://html5.gamemonetize.com/tu374jfdun3k2qclz35pyndyjrkq6x8z/', 'html5', 800, 600, 1576076683, '1', '0'),
(505, 'gamemonetize-943', 'caveman-adventures', 'Caveman Adventures', 'https://img.gamemonetize.com/qgaa3dag801neazaudx55t5wfmlmews4/512x384.jpg', '0', 4, 0, '0', 'With cute background music and funny SFX, we bring you another amazing game Caveman Adventures. In the stone age world, there are rolling rocks and you have to get away from the rocks and grab the food Just use your finger mouse and slide the character to move Game get difficult as you move ahead and face different tiny rocks SLIDE IT', '', 'https://html5.gamemonetize.com/qgaa3dag801neazaudx55t5wfmlmews4/', 'html5', 640, 1136, 1576076683, '1', '0'),
(506, 'gamemonetize-942', 'mummy-candies-fullscreen-hd-game', 'Mummy Candies | Fullscreen HD Game', 'https://img.gamemonetize.com/rwa588ema9uzztqupg5xdrctshtxlbod/512x384.jpg', '0', 4, 0, '0', 'Fullscreen Gameplay! The mummy is trying it&#039;s best to pull up the candies using a hook. The hook keeps moving like a pendulum. What you need to do is time your tap/click such that the HOOK stops and moves in the direction of a select candy. Make sure you tap when the angle is right. The larger candies score more but are very slow to PULL up. Smaller candies move faster but score less. So set your strategy straight and get going to enjoy this fun little game. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfu', '', 'https://html5.gamemonetize.com/rwa588ema9uzztqupg5xdrctshtxlbod/', 'html5', 800, 600, 1576076683, '1', '0'),
(507, 'gamemonetize-941', 'air-combat-puzzle', 'Air Combat Puzzle', 'https://img.gamemonetize.com/cjwn2gm2grtwyhfoly8jy6mb1u7tt045/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Air Combat Puzzle. All images is with the air combat. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/cjwn2gm2grtwyhfoly8jy6mb1u7tt045/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(508, 'gamemonetize-940', 'dotted-girl-ambulance-for-superhero', 'Dotted-Girl Ambulance For Superhero', 'https://img.gamemonetize.com/i3hrp0r6buqyinng2oh413gdka7td3ew/512x384.jpg', '0', 1, 0, '0', 'Oh no! Superheroine Dotted-girl is in trouble. Urgently call an ambulance and take the girl to the hospital. The hospital has everything you need to cure a superheroine. Use x-rays to identify fractures. Treat Dotted-girl wounds and apply plaster. Feel like a real doctor!', '', 'https://html5.gamemonetize.com/i3hrp0r6buqyinng2oh413gdka7td3ew/', 'html5', 800, 600, 1576076683, '1', '0'),
(509, 'gamemonetize-939', 'candy-match-saga-mobile-friendly-fullscreen', 'Candy Match Saga | Mobile-friendly | Fullscreen', 'https://img.gamemonetize.com/tsv0as62m6hv7qr4ni5o4jxbzzcu544y/512x384.jpg', '0', 1, 0, '0', 'Fullscreen Mobile-friendly Game Now don&#039;t crush the candies. Match them. Yeah, you heard it. Match the candies and make them disappear and let the game go one. The only thing stopping you is the timer. If you run out of time, the game restarts from zero. Play this exciting game with great music and pleasing sound effects. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile.', '', 'https://html5.gamemonetize.com/tsv0as62m6hv7qr4ni5o4jxbzzcu544y/', 'html5', 800, 600, 1576076683, '1', '0'),
(510, 'gamemonetize-938', 'city-stunt-cars', 'City Stunt Cars', 'https://img.gamemonetize.com/ugrk9wba57mvrhc47qq65951l8jq7h22/512x384.jpg', '0', 2, 0, '0', 'Play City Stunt Cars in a big urban city and test your stunt driving skills. Choose from many cool to drive sports cars and make cool stunts using all the ramps and loops. With many big jumps try to jump over the houses or try to land on top of them. The coolest 3d race car game of all time!', '', 'https://html5.gamemonetize.com/ugrk9wba57mvrhc47qq65951l8jq7h22/', 'html5', 800, 600, 1576076683, '1', '0'),
(511, 'gamemonetize-937', 'pubg-infinity-battlefield-ops', 'PUBG Infinity BattleField OPS', 'https://img.gamemonetize.com/36ndzupyeru3q06zeaf8mbcsyt30f7yi/512x384.jpg', '0', 3, 0, '0', 'If you want to try more fatal and more strategic battle royale game and enjoy simpler operation, don’t hesitate, play and be a warrior in PUBG Infinity BattleField OPS game right now! The combination of randomness and enjoyment brings you infinite possibilities. But remember the only rule is survival, be survival to the last!', '', 'https://html5.gamemonetize.com/36ndzupyeru3q06zeaf8mbcsyt30f7yi/', 'html5', 900, 600, 1576076683, '1', '0'),
(512, 'gamemonetize-936', 'stickman-prison-escape-story-3d', 'Stickman Prison Escape Story 3D', 'https://img.gamemonetize.com/vdqwhxttg6ujyz9mkidhgn18j46mrm7m/512x384.jpg', '0', 9, 4, '0', 'You are stuck in prison for a crime you did not commit. Framed and imprisoned, but never gives up and plans to self-salvation. Persevere, day after day, year after year. Hope can set him free. Finally, you can take the breath of freedom.', '', 'https://html5.gamemonetize.com/vdqwhxttg6ujyz9mkidhgn18j46mrm7m/', 'html5', 900, 600, 1576076683, '1', '0'),
(513, 'gamemonetize-935', 'hunting-season', 'Hunting Season', 'https://img.gamemonetize.com/h0yczotnsc395ts9uku8hnl9lwau0dqi/512x384.jpg', '0', 3, 1, '0', 'Hunting Season - Hunt or be hunted as simple as that. You have hunter instincts, animals are there, upgrade your weapons for clear shot, nearest you get better chances of hunt it is. As the time runs out, you have to get clear shot before taking hunts out. Some animals are dangerous, they will fight back. If you survive, then you have story to share with freinds and some trophies to take with you in your drawing room. . Challenge is on!', '', 'https://html5.gamemonetize.com/h0yczotnsc395ts9uku8hnl9lwau0dqi/', 'html5', 960, 600, 1576076683, '1', '0'),
(514, 'gamemonetize-934', 'shooterz-io', 'ShooterZ.io', 'https://img.gamemonetize.com/6x8pxf5ylzyu7e1nk19hddg7dl71vb01/512x384.jpg', '0', 7, 2, '0', 'ShooterZ.io is a cool game where you can have a lot of fun with your friends. Enter now and create a lobby as you like, or chose one which is created by someone else and fight in the craziest combat that exists. Features: • Multiplayer game rooms • Multiple environments • Good graphics', '', 'https://html5.gamemonetize.com/6x8pxf5ylzyu7e1nk19hddg7dl71vb01/', 'html5', 960, 600, 1576076683, '1', '0'),
(515, 'gamemonetize-933', 'puzzles-princesses-and-angels-new-look', 'Puzzles - Princesses and Angels New Look', 'https://img.gamemonetize.com/pvdqg625wd8strb8nz568a36r7lbvbxl/512x384.jpg', '0', 5, 0, '0', 'The princesses have prepared a game for you again! But this time they brought beautiful angels. Collect all the puzzles and find out what princesses and angels can be. Set your record and compete with your friends!', '', 'https://html5.gamemonetize.com/pvdqg625wd8strb8nz568a36r7lbvbxl/', 'html5', 800, 600, 1576076683, '1', '0'),
(516, 'gamemonetize-932', 'angry-fun-zombies', 'Angry Fun Zombies', 'https://img.gamemonetize.com/qiwg72yp2in3bgixgkikg3nwl7hive7m/512x384.jpg', '0', 5, 0, '0', 'What should you do with a Catapult loaded with stones? Shoot zombies, of course! ANGRY ZOMBIES is a fun and free arcade game that&#039;s all about destroying zombies! Each level in ANGRY ZOMBIES is packed full of destructible objects and crazy zombie enemies.', '', 'https://html5.gamemonetize.com/qiwg72yp2in3bgixgkikg3nwl7hive7m/', 'html5', 800, 600, 1576076683, '1', '0'),
(517, 'gamemonetize-931', 'miraculous-dream-catcher-coloring-book', 'Miraculous Dream Catcher Coloring Book', 'https://img.gamemonetize.com/3yh8lox073a5iv12hq6xduwtc5wxd6jh/512x384.jpg', '0', 1, 0, '0', 'All children love to paint and paint! Today is the time to create your own mysterious and colorful dream catcher. Dreamcatcher is a home charm that protects against nightmares, drives away bad dreams, allows you to quickly fall asleep and eliminates insomnia. It gives a person good dreams, helps to sleep well and provides a good mood during the day. Use the slide bar on the right to select the desired color. Drag the panel with the palette using the left mouse button. Enjoy this new game “Miraculous Dream Catcher coloring book”! I wish you good dreams!', '', 'https://html5.gamemonetize.com/3yh8lox073a5iv12hq6xduwtc5wxd6jh/', 'html5', 800, 600, 1576076683, '1', '0'),
(518, 'gamemonetize-930', 'american-trucks-coloring', 'American Trucks Coloring', 'https://img.gamemonetize.com/7knybz2duum5g2uqyns5p1nluy5n68ce/512x384.jpg', '0', 5, 0, '0', 'Choose your favorite American truck and start to color it as you wish. You can choose different colors for coloring the images, but you can erase to if you make some mistake, or if you want to change the color. You can save the image in your pc if you want.', '', 'https://html5.gamemonetize.com/7knybz2duum5g2uqyns5p1nluy5n68ce/', 'html5', 1280, 720, 1576076683, '1', '0'),
(519, 'gamemonetize-929', 'happy-dog-memory', 'Happy Dog Memory', 'https://img.gamemonetize.com/2j1k51m5ex0apb7l27awx6yvt9s4v2dy/512x384.jpg', '0', 5, 0, '0', 'Happy Dog Memory is a free online game from genre of memory and kids games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/2j1k51m5ex0apb7l27awx6yvt9s4v2dy/', 'html5', 1280, 720, 1576076683, '1', '0'),
(520, 'gamemonetize-928', 'magical-wizard-match-3', 'Magical Wizard Match 3', 'https://img.gamemonetize.com/5fkw5hdq2l2mkd5fdg6u3ig1tcpq8g4d/512x384.jpg', '0', 5, 0, '0', 'Magical Wizard Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful summer style! Enjoy the game!', '', 'https://html5.gamemonetize.com/5fkw5hdq2l2mkd5fdg6u3ig1tcpq8g4d/', 'html5', 960, 540, 1576076683, '1', '0'),
(521, 'gamemonetize-927', 'mission-in-space-difference', 'Mission in Space Difference', 'https://img.gamemonetize.com/s9fhe50xivzpql5nvlr6rh49xue3fed7/512x384.jpg', '0', 5, 0, '0', 'Now it&#039;s time for wonderful game that&#039;s called Mission in Space difference, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/s9fhe50xivzpql5nvlr6rh49xue3fed7/', 'html5', 960, 540, 1576076683, '1', '0'),
(522, 'gamemonetize-926', 'crazy-mexican-coloring-book', 'Crazy Mexican Coloring Book', 'https://img.gamemonetize.com/gkj8xxzxbkyhhciu5hq2ldhwqjtk7gvn/512x384.jpg', '0', 5, 0, '0', 'Crazy Mexican Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/gkj8xxzxbkyhhciu5hq2ldhwqjtk7gvn/', 'html5', 960, 540, 1576076683, '1', '0'),
(523, 'gamemonetize-925', 'kids-camping-hidden-stars', 'Kids Camping Hidden Stars', 'https://img.gamemonetize.com/r1p7jvenerachi8a9by78478ze5m67uy/512x384.jpg', '0', 5, 0, '0', 'Kids Camping Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/r1p7jvenerachi8a9by78478ze5m67uy/', 'html5', 960, 540, 1576076683, '1', '0'),
(524, 'gamemonetize-924', 'crazy-kitchen-difference', 'Crazy Kitchen Difference', 'https://img.gamemonetize.com/fveecr7xb0nuvqu7j6u69tldt1dah9rw/512x384.jpg', '0', 5, 0, '0', 'Now it&#039;s time for wonderful game that&#039;s called Mission in Space difference, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/fveecr7xb0nuvqu7j6u69tldt1dah9rw/', 'html5', 960, 540, 1576076683, '1', '0'),
(525, 'gamemonetize-923', 'trucks-slide', 'Trucks Slide', 'https://img.gamemonetize.com/67fgsxwvpvxfwj9zr8h9axoix425xzn3/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of the trucks. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/67fgsxwvpvxfwj9zr8h9axoix425xzn3/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(526, 'gamemonetize-922', 'bts-mario-coloring', 'BTS Mario Coloring', 'https://img.gamemonetize.com/uooc26ge6cesgrof1okfresbkws1ueop/512x384.jpg', '0', 5, 0, '0', 'BTS Mario Coloring Book is fun coloring book for kids and adults. If you like Mario then you will love this fun Mario themed coloring book. Choose one of the cute images, pick your favorite color and start coloring.', '', 'https://html5.gamemonetize.com/uooc26ge6cesgrof1okfresbkws1ueop/', 'html5', 854, 480, 1576076683, '1', '0'),
(527, 'gamemonetize-921', 'cotton-candy', 'Cotton Candy', 'https://img.gamemonetize.com/yft9hmqwphgt0c71hxeyj9c3qa8423s1/512x384.jpg', '0', 1, 0, '0', 'Everyone loves Cotton Candy. Have the chance to make your own cotton candy and customize it with everything you want. Let the fun begin! Yummy! Features: • Good graphics • Multiple models to choose from', '', 'https://html5.gamemonetize.com/yft9hmqwphgt0c71hxeyj9c3qa8423s1/', 'html5', 540, 720, 1576076683, '1', '0'),
(528, 'gamemonetize-920', 'lost-kitty-go-home', 'Lost Kitty Go Home', 'https://img.gamemonetize.com/xr75cxqgji44ddze4yy0w0uv8yvli38g/512x384.jpg', '0', 1, 0, '0', 'Move box to save little cat and help her to find way home. Good luck!', '', 'https://html5.gamemonetize.com/xr75cxqgji44ddze4yy0w0uv8yvli38g/', 'html5', 800, 600, 1576076683, '1', '0'),
(529, 'gamemonetize-919', 'tattoo-art-salon', 'Tattoo Art Salon', 'https://img.gamemonetize.com/q93z1bxd0fek3aak9z121d60z61ea4i0/512x384.jpg', '0', 1, 0, '0', 'Always wanted to get a tattoo? This is your chance. Try all the models and choose your favorite one. Features: • Multiple characters • Multiple tattoo designs', '', 'https://html5.gamemonetize.com/q93z1bxd0fek3aak9z121d60z61ea4i0/', 'html5', 540, 720, 1576076683, '1', '0'),
(530, 'gamemonetize-918', 'jump-boy-jump', 'Jump Boy Jump', 'https://img.gamemonetize.com/v24sdp6oph1zwwwwrvnffymo7qmt5nn1/512x384.jpg', '0', 1, 0, '0', 'Jump over obstacles and try to get highest score!', '', 'https://html5.gamemonetize.com/v24sdp6oph1zwwwwrvnffymo7qmt5nn1/', 'html5', 960, 540, 1576076683, '1', '0'),
(531, 'gamemonetize-917', 'jeep-ride', 'Jeep Ride', 'https://img.gamemonetize.com/pmr68chgytd2v3kqgyd6bh0vr9lm4aku/512x384.jpg', '0', 2, 0, '0', 'Drive your jeep over 20 levels to complete game. Watch on obstacles and try to keep balance of your car. Good luck!', '', 'https://html5.gamemonetize.com/pmr68chgytd2v3kqgyd6bh0vr9lm4aku/', 'html5', 1280, 720, 1576076683, '1', '0'),
(532, 'gamemonetize-916', 'green-diamond', 'Green Diamond', 'https://img.gamemonetize.com/q8lmapckmze9b88hy0ig4gw92nvhnhie/512x384.jpg', '0', 5, 0, '0', 'Cut the chain, remove obstacles to get diamond to chess. Enjoy!', '', 'https://html5.gamemonetize.com/q8lmapckmze9b88hy0ig4gw92nvhnhie/', 'html5', 1280, 720, 1576076683, '1', '0'),
(533, 'gamemonetize-915', 'car-backwheel', 'Car Backwheel', 'https://img.gamemonetize.com/qram0gvobslawo8blm7al1s9fx9u0y9r/512x384.jpg', '0', 2, 0, '0', 'You have 20 levels. Select 1 of 5 wheels and go to adventure. Beware of spikes and get over obstacles to reach your goal. Keyboard control on desktop. Touch on mobile. Enjoy!', '', 'https://html5.gamemonetize.com/qram0gvobslawo8blm7al1s9fx9u0y9r/', 'html5', 1280, 720, 1576076683, '1', '0'),
(534, 'gamemonetize-914', 'girl-adventurer', 'Girl Adventurer', 'https://img.gamemonetize.com/ja84q98j84e0eoe9zu8cc1ai7yc22s0m/512x384.jpg', '0', 2, 0, '0', 'Play great platform game Girl Adventurer. Jump on golem&#039;s head to kill them, avoid obstacles and collect 3 keys per level. Good luck!', '', 'https://html5.gamemonetize.com/ja84q98j84e0eoe9zu8cc1ai7yc22s0m/', 'html5', 854, 480, 1576076683, '1', '0'),
(535, 'gamemonetize-913', 'clash-blade-io', 'Clash Blade IO', 'https://img.gamemonetize.com/pg8l1zut8pv47cjqeudrdo7q5mcde184/512x384.jpg', '0', 2, 0, '0', 'How To Play ClashBlade.com – Clash Balde io is have two mode. + Rank mode: this is mode rank war. you will fighting with 50 user more and 90 second to play in 1 room. You will get coin and exp if you reach top 1,2,3. + Endless mode: This is game for fun and you will play with hundred user on the world. Let remember it is for fun, you will not get coin or exp. – Best to collect orb when in low level – Higher level make your move slow but your sword bigger. Use your skill to get high score. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/pg8l1zut8pv47cjqeudrdo7q5mcde184/', 'html5', 800, 600, 1576076683, '1', '0'),
(536, 'gamemonetize-912', 'backflip-parkour', 'Backflip Parkour', 'https://img.gamemonetize.com/0qchqqw52v4mm65gfoo3v437nyelrdfs/512x384.jpg', '0', 8, 0, '0', 'Become a real trickster in our new simulator of parkour madness Backflip Parkour! Have you ever wanted to perform crazy tricks? In our simulator, you can perform flips and backflips. Jumps from heights are not hard if you are playing our parkour madness simulator. Perform jumps from heights and make flips and backflips. You can learn basics of parkour mania in our jumps madness simulator.', '', 'https://html5.gamemonetize.com/0qchqqw52v4mm65gfoo3v437nyelrdfs/', 'html5', 900, 600, 1576076683, '1', '1'),
(537, 'gamemonetize-911', 'army-cargo-drive', 'Army Cargo Drive', 'https://img.gamemonetize.com/5sp46ez8x5blczrdoia5bgemacqwht3n/512x384.jpg', '0', 2, 0, '0', 'Army Cargo Drive the 3D military driving game that will test your truck driving skills. To play just choose a army truck and deliver the cargo on time to the next military base. Drive your car carefully over the obstacles and don&#039;t let your cargo fall down. This game has 10 amazing levels and 3 trucks to choose from.', '', 'https://html5.gamemonetize.com/5sp46ez8x5blczrdoia5bgemacqwht3n/', 'html5', 800, 600, 1576076683, '1', '0'),
(538, 'gamemonetize-910', 'fit', 'Fit', 'https://img.gamemonetize.com/k6ajwhqfwlpw2eqixdo50kbnbacofir0/512x384.jpg', '0', 2, 0, '0', 'Fit is a tetris like arcade game where you need to match the falling shape with its correspondent. You need to act quickly as the shape will explode if not. Features: • Multiple levels • Challenging gameplay', '', 'https://html5.gamemonetize.com/k6ajwhqfwlpw2eqixdo50kbnbacofir0/', 'html5', 960, 600, 1576076683, '1', '0'),
(539, 'gamemonetize-909', 'fruit-shoot-boom', 'Fruit Shoot Boom', 'https://img.gamemonetize.com/1o0duyn7xv13r8kb19xcgrj6jei37n38/512x384.jpg', '0', 3, 0, '0', 'Fruit Shoot Boom is a funny archery game in which you have to collect as much fruit as possible by skewering as many apples, pears, peaches, and other pieces of fruit with a single arrow. Keep firing arrows to stack up the bonus points. Can you defeat the giant fruit boss at the end of every level by bombarding each fruit king with arrows?', '', 'https://html5.gamemonetize.com/1o0duyn7xv13r8kb19xcgrj6jei37n38/', 'html5', 480, 854, 1576076683, '1', '0'),
(540, 'gamemonetize-908', 'sling-car', 'Sling Car', 'https://img.gamemonetize.com/yetvx2cz2va1jcz2v3gbd2xzqqmz59g3/512x384.jpg', '0', 2, 0, '0', 'Sling Car is another kind of drifting game, it has a funny gameplay where you have to connect you car in every curve to proceed the drift. Features • Endless gameplay • Multiple car skins', '', 'https://html5.gamemonetize.com/yetvx2cz2va1jcz2v3gbd2xzqqmz59g3/', 'html5', 520, 720, 1576076683, '1', '0'),
(541, 'gamemonetize-907', 'solitaire-games', 'Solitaire Games', 'https://img.gamemonetize.com/101cuf32wk4hqdqzo811lbwfcgwr67h7/512x384.jpg', '0', 5, 0, '0', 'Features: - multiple games - addictive gameplay', '', 'https://html5.gamemonetize.com/101cuf32wk4hqdqzo811lbwfcgwr67h7/', 'html5', 960, 540, 1576076683, '1', '0'),
(542, 'gamemonetize-906', 'fz-tap-touch-run', 'FZ Tap Touch Run', 'https://img.gamemonetize.com/5lr9fv9l4fqu8hdvqu32ei49ik7j9avf/512x384.jpg', '0', 5, 0, '0', 'FZ Tap Touch Run - HTML5 Games is titles to jump or change direction Do not fall off the path Discover new characters Play with your friends! Give them peppers! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/5lr9fv9l4fqu8hdvqu32ei49ik7j9avf/', 'html5', 800, 600, 1576076683, '1', '0'),
(543, 'gamemonetize-905', 'mouse-jigsaw', 'Mouse Jigsaw', 'https://img.gamemonetize.com/thyjr2addg6n2br4r39zrquj75pelvyf/512x384.jpg', '0', 5, 0, '0', 'Mouse Jigsaw is a fun online puzzle game. Drag the pieces into right position using mouse. Solving puzzles is relaxing, rewarding, and keeps your brain sharp. You need to spend $1000 to be able to purchase one of the following pictures. You have three modes for each picture from which the hardest mode brings more money. You have a total of 10 pictures.', '', 'https://html5.gamemonetize.com/thyjr2addg6n2br4r39zrquj75pelvyf/', 'html5', 960, 640, 1576076683, '1', '0'),
(544, 'gamemonetize-904', 'basketball-hero-jigsaw', 'Basketball Hero Jigsaw', 'https://img.gamemonetize.com/dtv2e9t9ail09rh9asfv1kjbb776km8x/512x384.jpg', '0', 5, 0, '0', 'Basketball Hero Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/dtv2e9t9ail09rh9asfv1kjbb776km8x/', 'html5', 1280, 720, 1576076683, '1', '0'),
(545, 'gamemonetize-903', 'stan-the-man', 'Stan The Man', 'https://img.gamemonetize.com/1na0yvbtljebf4do3o695s39mlwqiu9k/512x384.jpg', '0', 3, 0, '0', 'Play great shooter game Stan The Man. You have 20 levels to kill all zombies. Find perfect angle and shoot &#039;em up!', '', 'https://html5.gamemonetize.com/1na0yvbtljebf4do3o695s39mlwqiu9k/', 'html5', 1280, 720, 1576076683, '1', '0'),
(546, 'gamemonetize-902', 'smiley-ball', 'Smiley Ball', 'https://img.gamemonetize.com/yc1ngy19twqvo2kdothca9ozjrp48lk7/512x384.jpg', '0', 3, 0, '0', 'Get smiley ball to the end of each of 20 levels. Avoid obstacles all the way long. Good luck.', '', 'https://html5.gamemonetize.com/yc1ngy19twqvo2kdothca9ozjrp48lk7/', 'html5', 1280, 720, 1576076683, '1', '0'),
(547, 'gamemonetize-901', 'mega-truck', 'Mega Truck', 'https://img.gamemonetize.com/itz20kwfta3v9hahvfgnio1an0fl39ql/512x384.jpg', '0', 2, 0, '0', 'Drive your truck thru 20 levels avoiding obstacles and try to keep your balance. Keep your cargo all the way. Good luck!', '', 'https://html5.gamemonetize.com/itz20kwfta3v9hahvfgnio1an0fl39ql/', 'html5', 1280, 720, 1576076683, '1', '0'),
(548, 'gamemonetize-900', 'monster-truck-rider', 'Monster Truck Rider', 'https://img.gamemonetize.com/dei5knm8xh6qk5e0ctnlarkqe2og5hqi/512x384.jpg', '0', 2, 0, '0', 'Drive monster truck thry 12 levels avoiding obstacles. Try to keep your balance all the way. Good luck!', '', 'https://html5.gamemonetize.com/dei5knm8xh6qk5e0ctnlarkqe2og5hqi/', 'html5', 854, 480, 1576076683, '1', '0'),
(549, 'gamemonetize-899', 'toto-adventure', 'Toto Adventure', 'https://img.gamemonetize.com/dhkxzw7b9iuhknpl6h6weiwjwwxvinfw/512x384.jpg', '0', 2, 0, '0', 'Play great adventure game Toto Adventure. You have 24 levels. Avoid obstacles, collect 3 keys to get to finish of level. Good luck!', '', 'https://html5.gamemonetize.com/dhkxzw7b9iuhknpl6h6weiwjwwxvinfw/', 'html5', 1280, 720, 1576076683, '1', '0'),
(550, 'gamemonetize-898', 'toto-double-trouble', 'Toto Double Trouble', 'https://img.gamemonetize.com/uy4zr8p8qhzxc47i9hoswlshnzvqip7c/512x384.jpg', '0', 2, 0, '0', 'Play great 2 players game Toto Double Trouble. Lead two players to help each other thru 20 levels. Enjoy!', '', 'https://html5.gamemonetize.com/uy4zr8p8qhzxc47i9hoswlshnzvqip7c/', 'html5', 1280, 720, 1576076683, '1', '0'),
(551, 'gamemonetize-897', 'toto-world', 'Toto World', 'https://img.gamemonetize.com/guzd7yvm7pfh4a1b4n5fqqgmig7gd3st/512x384.jpg', '0', 2, 0, '0', 'Play great adventure game Toto World. Choose between 3 characters and avoid obstacles thru 20 levels to complete this game. Good luck!', '', 'https://html5.gamemonetize.com/guzd7yvm7pfh4a1b4n5fqqgmig7gd3st/', 'html5', 1280, 720, 1576076683, '1', '0'),
(552, 'gamemonetize-896', 'monster-jump', 'Monster Jump', 'https://img.gamemonetize.com/3v1akvojalxo4714zhryfsmiux7uvlpz/512x384.jpg', '0', 4, 0, '0', 'Tap/Click and hold to control jumping power. Release to jump. Collect mini-monsters to revive your monster. Avoid the rockets. Eat the candies to power up. How far can you jump? Play now!', '', 'https://html5.gamemonetize.com/3v1akvojalxo4714zhryfsmiux7uvlpz/', 'html5', 480, 640, 1576076683, '1', '0'),
(553, 'gamemonetize-895', 'cowgirl-shoot-zombies', 'Cowgirl Shoot Zombies', 'https://img.gamemonetize.com/kjfs7zppyg5aeltgen7ea2fgs3utbpxw/512x384.jpg', '0', 3, 0, '0', 'Cowgirl Shoot Zombies is great shooter game. You need to eleminate all zombies on the stage to complete the level. There are 6 bullets in your gun. So, aim carefully! You have 20 levels to complete game. Enjoy!', '', 'https://html5.gamemonetize.com/kjfs7zppyg5aeltgen7ea2fgs3utbpxw/', 'html5', 1280, 720, 1576076683, '1', '0'),
(554, 'gamemonetize-894', 'candy-match', 'Candy Match', 'https://img.gamemonetize.com/54r93ds5tenbjirjgh4ls18vnkonvxr1/512x384.jpg', '0', 5, 0, '0', 'Match 3 game.', '', 'https://html5.gamemonetize.com/54r93ds5tenbjirjgh4ls18vnkonvxr1/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(555, 'gamemonetize-893', 'ben-10-difference', 'Ben 10 Difference', 'https://img.gamemonetize.com/xk2r33hx6odjws99ie7c5k8h9y381roz/512x384.jpg', '0', 4, 0, '0', 'Ben10 Difference is an online game that you can play for free. Do you have a good vision? Let&#039;s have a check. There are 5 levels in the game, every level has two looks the same picture. Your mission is to find the difference between the two pictures, they have 5 or more different points. Can you find it? Have a try!', '', 'https://html5.gamemonetize.com/xk2r33hx6odjws99ie7c5k8h9y381roz/', 'html5', 960, 640, 1576076683, '1', '0'),
(556, 'gamemonetize-892', 'little-car-jigsaw', 'Little Car Jigsaw', 'https://img.gamemonetize.com/djhqrvx82114hff3iq9fbkwa1cqstd77/512x384.jpg', '0', 5, 0, '0', 'Little Car Jigsaw is a free online jigsaw puzzle game. You can select one of the three images and then select one of the four modes (16, 36, 64 and 100 pieces). Select your favorite picture and complete the jigsaw in the shortest time possible! Have fun and enjoy!', '', 'https://html5.gamemonetize.com/djhqrvx82114hff3iq9fbkwa1cqstd77/', 'html5', 960, 540, 1576076683, '1', '0'),
(557, 'gamemonetize-891', 'super-neon-ball', 'Super Neon Ball', 'https://img.gamemonetize.com/nsvw98y6e61iuekrmvqg35j77xwiguy4/512x384.jpg', '0', 5, 0, '0', 'Keep a neon ball in the air in the Super Neon Ball skill game. Your neon ball falls toward the bottom of the screen, knocking out blocks in the platform that prevents it from plummeting into the abyss. Keep the ball in the air, bouncing off the platforms that slide by overhead when they come in handy and collect money icons as they float past.', '', 'https://html5.gamemonetize.com/nsvw98y6e61iuekrmvqg35j77xwiguy4/', 'html5', 480, 854, 1576076683, '1', '1'),
(558, 'gamemonetize-890', 'tuk-tuk-rush', 'Tuk Tuk Rush', 'https://img.gamemonetize.com/i9gkghplkkdbgjw0nbneifzhg0upcdnu/512x384.jpg', '0', 2, 0, '0', 'You have a funny job, you are a tricycle driver and your clients are waiting for a ride in the city, follow the arrow and reach the place where you have to pick them up then go to their requiered destination. Have fun! Features • Multiple levels • Good graphics', '', 'https://html5.gamemonetize.com/i9gkghplkkdbgjw0nbneifzhg0upcdnu/', 'html5', 960, 540, 1576076683, '1', '0'),
(559, 'gamemonetize-889', 'sea-animal-transport-truck', 'Sea Animal Transport Truck', 'https://img.gamemonetize.com/8ppiigm3brlhowck0dia2vrw1lxervkz/512x384.jpg', '0', 2, 0, '0', 'Features: - multiple levels - good graphics', '', 'https://html5.gamemonetize.com/8ppiigm3brlhowck0dia2vrw1lxervkz/', 'html5', 960, 540, 1576076683, '1', '0'),
(560, 'gamemonetize-888', 'heroes-battle', 'Heroes Battle', 'https://img.gamemonetize.com/w1w315637vlmr8ggox5mdpmrk6sywq2s/512x384.jpg', '0', 2, 0, '0', 'Heroes Battle features: - multiple levels - upgrades - good graphics', '', 'https://html5.gamemonetize.com/w1w315637vlmr8ggox5mdpmrk6sywq2s/', 'html5', 960, 540, 1576076683, '1', '0'),
(561, 'gamemonetize-887', 'daily-russian-jigsaw', 'Daily Russian Jigsaw', 'https://img.gamemonetize.com/n3ivie7d14eck804bmhdjtsyh2tdkju7/512x384.jpg', '0', 5, 0, '0', 'Daily Russian Jigsaw is an online game that you can play for free. Are you interested in Russian landscapes and buildings? The Russian Jigsaw is suitable for players who like Russian elements and jigsaw puzzles. Do you have the confidence to complete a picture in the fastest time? The game has three different levels of difficulty to choose from. Have fun with', '', 'https://html5.gamemonetize.com/n3ivie7d14eck804bmhdjtsyh2tdkju7/', 'html5', 854, 480, 1576076683, '1', '0'),
(562, 'gamemonetize-886', 'brick-out-game', 'Brick Out Game', 'https://img.gamemonetize.com/n46u9vz7uyod5c0mf9snvryufjbng6u3/512x384.jpg', '0', 5, 0, '0', 'You have 20 levels. Break all bricks and collect power ups to complete each levels. Enjoy!', '', 'https://html5.gamemonetize.com/n46u9vz7uyod5c0mf9snvryufjbng6u3/', 'html5', 1280, 720, 1576076683, '1', '0'),
(563, 'gamemonetize-885', 'halloween-defence2', 'Halloween Defence2', 'https://img.gamemonetize.com/4zxxpcfwu509f54ckdz5jufi8xdwdewi/512x384.jpg', '0', 3, 0, '0', 'It’s Halloween time and the pumpkin heads are attacking again! If you want to survive, you have to shoot down these pumpkin heads before they reach you. Each pumpkin head that is destroyed is considered as one score point. You have two lives and whenever a pumpkin head reaches you, you lose one life. When you lose your two lives, you will also lose the game.', '', 'https://html5.gamemonetize.com/4zxxpcfwu509f54ckdz5jufi8xdwdewi/', 'html5', 800, 600, 1576076683, '1', '0')";
$db[22] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(564, 'gamemonetize-884', 'puzzle-world-of-the-sead', 'Puzzle World Of The Sead', 'https://img.gamemonetize.com/f7a2z2ioeoxyobeubiamkxcjpfd7c3pr/512x384.jpg', '0', 5, 0, '0', 'Welcome to Puzzle World Of The Sead , this game online is special, Once you start, you will never stop! Zombie will be close to you to destroy.', '', 'https://html5.gamemonetize.com/f7a2z2ioeoxyobeubiamkxcjpfd7c3pr/', 'html5', 800, 600, 1576076683, '1', '0'),
(565, 'gamemonetize-883', 'jumpy-kangaroo', 'Jumpy Kangaroo', 'https://img.gamemonetize.com/h9sp9ja3z0n5di1f4soblxiqrencmt33/512x384.jpg', '0', 5, 0, '0', 'Welcome to the kangaroos world . &quot;Jumpy Kangaroo&quot; is a cute casual game made for kids as well as adult a nice game to kill some time :) Hop Hop on the platforms..Tap on screen to go down and jump on the platform With funny sounds and cute graphics start playing Jumpy Kangaroo', '', 'https://html5.gamemonetize.com/h9sp9ja3z0n5di1f4soblxiqrencmt33/', 'html5', 768, 1024, 1576076683, '1', '0'),
(566, 'gamemonetize-882', 'the-last-spartan', 'the last spartan', 'https://img.gamemonetize.com/aptfkqlz5h82e8kwdxpgcd4voavz2txc/512x384.jpg', '0', 5, 0, '0', 'You are the last Spartan, defend your city', '', 'https://html5.gamemonetize.com/aptfkqlz5h82e8kwdxpgcd4voavz2txc/', 'html5', 800, 600, 1576076683, '1', '0'),
(567, 'gamemonetize-881', 'desert-car-race', 'Desert Car Race', 'https://img.gamemonetize.com/4d5d7l713ywn5gy11xrao903bdcz53oa/512x384.jpg', '0', 2, 0, '0', 'In this game you need to race with car in desert. Get best time and collect more coins and stars to earn more points. Pass all 15 levels and win in this interesting racing game.', '', 'https://html5.gamemonetize.com/4d5d7l713ywn5gy11xrao903bdcz53oa/', 'html5', 1280, 720, 1576076683, '1', '0'),
(568, 'gamemonetize-880', 'funny-princesses-spot-the-difference', 'Funny Princesses - Spot the Difference', 'https://img.gamemonetize.com/fortzgz0w9z2qjzcmypm9bsli977u7i9/512x384.jpg', '0', 1, 0, '0', 'Hi girls and boys! It is time to play another fun game. This time you need to find the differences in two almost identical pictures. You will meet cute and funny princesses and their pets, and practice your attentiveness. Go ahead, keep up the time. If you can’t find all the differences the first time, don’t be discouraged, try again, you will definitely succeed!', '', 'https://html5.gamemonetize.com/fortzgz0w9z2qjzcmypm9bsli977u7i9/', 'html5', 800, 600, 1576076683, '1', '0'),
(569, 'gamemonetize-879', 'miss-charming-unicorn-hairstyle', 'Miss Charming Unicorn Hairstyle', 'https://img.gamemonetize.com/u39lbmseoff88x05goalee10h9h9rp1m/512x384.jpg', '0', 1, 0, '0', 'Princesses Moana, Rapunzel and Harley Queen decided arrange the Miss Charming Unicorn contest. Princess Elsa&#039;s beauty salon is ready to help the participants. Elsa is an unsurpassed master of makeup and face art, she also knows how to make incredible cute hairstyles in fantasy style. Join the girls and help each princess create her own unique image. Use delicate colors to color your hair, makeup with sparkles and rhinestones will help create a magical atmosphere. Lipstick can be non-standard shades. Unleash your imagination by playing the game Miss Charming Unicorn Hairstyle.', '', 'https://html5.gamemonetize.com/u39lbmseoff88x05goalee10h9h9rp1m/', 'html5', 800, 600, 1576076683, '1', '0'),
(570, 'gamemonetize-878', 'way-of-the-samurai', 'Way of the Samurai', 'https://img.gamemonetize.com/lmm5sprf82oxfq7qxfsftkli2rupcpcy/512x384.jpg', '0', 1, 0, '0', 'This samurai wants to go back home, but suddenly he dropped in a very very deep hole. Now he must run out this place, but there are so many deadly obstacles on his way, the only way he can avoid them is jump between the walls. Good luck!', '', 'https://html5.gamemonetize.com/lmm5sprf82oxfq7qxfsftkli2rupcpcy/', 'html5', 450, 800, 1576076683, '1', '0'),
(571, 'gamemonetize-877', 'superhero-race-io', 'Superhero Race.IO', 'https://img.gamemonetize.com/jot9swaetic5t2j3865iyjy0mqr1l2k5/512x384.jpg', '0', 2, 0, '0', 'Superhero Race.IO is racing car game, where you try to beat other players high Scores with this mindset you select your Superhero character car to choose from(Batman, Iron Man, Hulk, Spider Man, Wonder Women, Wolverine, Aqua man ) in total 10 different Superhero racing cars with more than 100 different body parts and colors available for customization. Unlock new characters and get good understanding of racing track, before you play the race. Try to break records and have fun playing this amazing Superhero Race.IO.', '', 'https://html5.gamemonetize.com/jot9swaetic5t2j3865iyjy0mqr1l2k5/', 'html5', 1080, 600, 1576076683, '1', '0'),
(572, 'gamemonetize-876', 'ranger-vs-zombies-mobile-friendly-fullscreen', 'Ranger Vs Zombies | Mobile-friendly | Fullscreen', 'https://img.gamemonetize.com/k7z8u3jaaehnw783bcioj0tyql64ica3/512x384.jpg', '0', 3, 0, '0', 'Mobile-friendly, Fullscreen Game. The Ranger is out with a mission. Zombies are the target. Help the Ranger shoot the zombies by timing his shots and jumps. Beware, the zombies are on the land and also in the air. They won&#039;t die with just one bullet. Keep moving keep shooting. Score more. Collect the coins. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile.', '', 'https://html5.gamemonetize.com/k7z8u3jaaehnw783bcioj0tyql64ica3/', 'html5', 800, 600, 1576076683, '1', '0'),
(573, 'gamemonetize-875', 'car-parts-coloring-book', 'Car Parts Coloring Book', 'https://img.gamemonetize.com/kre6xghho89q152wcj6b2njb2320zi2k/512x384.jpg', '0', 5, 0, '0', 'Car Parts Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/kre6xghho89q152wcj6b2njb2320zi2k/', 'html5', 960, 540, 1576076683, '1', '0'),
(574, 'gamemonetize-874', 'toys-box-blasts', 'Toys Box Blasts', 'https://img.gamemonetize.com/mquggyur49ezpmvzi3ncbapj0uobled8/512x384.jpg', '0', 5, 0, '0', 'Toy Collapse is a simple, challenging, free block and puzzle game. You don’t have to pay a dime to finish the game. Match cubes of the same color and crash or blast the boxes and collect toys and toons to clear a level.', '', 'https://html5.gamemonetize.com/mquggyur49ezpmvzi3ncbapj0uobled8/', 'html5', 800, 600, 1576076683, '1', '0'),
(575, 'gamemonetize-873', 'zombie-buster-fullscreen-hd', 'Zombie Buster - Fullscreen HD', 'https://img.gamemonetize.com/t82iwc61ln74d26z062acriuogvf09mt/512x384.jpg', '0', 3, 0, '0', 'Mobile-friendly Fullscreen Gameplay The zombie buster&#039;s got the grenade launcher. Only difference, the grenades are bouncy and aiming is tricky. So get ready to bust some zombies. Keep a count of your grenade launches, they do get over. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile.', '', 'https://html5.gamemonetize.com/t82iwc61ln74d26z062acriuogvf09mt/', 'html5', 800, 600, 1576076683, '1', '0'),
(576, 'gamemonetize-872', 'top-fun-burger-maker', 'Top Fun Burger Maker', 'https://img.gamemonetize.com/3xsery7d24wfhssz55yiepozs82jx6a1/512x384.jpg', '0', 3, 0, '0', 'You are chief and need to make burgers for different clients, hurry up and finish fast.', '', 'https://html5.gamemonetize.com/3xsery7d24wfhssz55yiepozs82jx6a1/', 'html5', 800, 600, 1576076683, '1', '0'),
(577, 'gamemonetize-871', 'cartoon-battle-sky', 'Cartoon Battle Sky', 'https://img.gamemonetize.com/wd8ymxa80ynyv1d61ln9y5swr7vxi8mf/512x384.jpg', '0', 3, 0, '0', 'Arcade Shoot &#039;Em Up Game has arrived and it brings you one of the most compelling and satisfying experiences in the world! Enjoy the unique atmosphere of WW2 and discover the next-gen air combat shooter with outstanding retro graphic style! Defeat flying enemies and become the WAR HERO!', '', 'https://html5.gamemonetize.com/wd8ymxa80ynyv1d61ln9y5swr7vxi8mf/', 'html5', 800, 600, 1576076683, '1', '0'),
(578, 'gamemonetize-870', 'the-plumber-game-mobile-friendly-fullscreen', 'The Plumber Game - Mobile-friendly Fullscreen', 'https://img.gamemonetize.com/szgc6mpv8nr77pq018wc2vw5iojvy86r/512x384.jpg', '0', 5, 0, '0', 'Mobile-friendly, fullscreen gameplay. The plumber is out to take up challenges. Multiple complex arrangements of pipes are all messed up. Help the plumber to arrange the pipes in the right direction from top to bottom. Beware, of the leakage or your set up will be submerged. Keep an eye on the timer. Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile. Updae 10/11/2019 - AD bug corrected.', '', 'https://html5.gamemonetize.com/szgc6mpv8nr77pq018wc2vw5iojvy86r/', 'html5', 800, 600, 1576076683, '1', '0'),
(579, 'gamemonetize-869', 'bus-subway', 'Bus Subway', 'https://img.gamemonetize.com/s3ibsukeywox4nvof45ckpk087631kfu/512x384.jpg', '0', 1, 0, '0', 'Bus &amp; Subway combines endless runner and multiplayer modes. You run switching between Bus roads and Subway tracks laid through highways, train tracks, Egyptian dunes and many other fun realms.', '', 'https://html5.gamemonetize.com/s3ibsukeywox4nvof45ckpk087631kfu/', 'html5', 960, 640, 1576076683, '1', '0'),
(580, 'gamemonetize-868', 'perfect-ninja-slices', 'Perfect Ninja Slices', 'https://img.gamemonetize.com/jwju7ooikgikpxjmis8mtxz31c19ovs7/512x384.jpg', '0', 4, 0, '0', 'Are you ready to make perfect slices? Chop like a real master. It&#039;s so satisfying! Use mouse to play.', '', 'https://html5.gamemonetize.com/jwju7ooikgikpxjmis8mtxz31c19ovs7/', 'html5', 500, 750, 1576076683, '1', '0'),
(581, 'gamemonetize-867', 'color-saw-3d', 'Color Saw 3D', 'https://img.gamemonetize.com/pipbyg09agxsa167ktx8dscmo1vb2tts/512x384.jpg', '0', 4, 0, '0', 'Ever wanted to do carpentry but like to keep your fingers intact? With Color Saw, you can do both! Shape your rough blocks into various shapes with all kinds of tools. Cut and smash through countless levels.', '', 'https://html5.gamemonetize.com/pipbyg09agxsa167ktx8dscmo1vb2tts/', 'html5', 480, 600, 1576076683, '1', '0'),
(582, 'gamemonetize-866', 'pixel-pubg', 'Pixel PUBG', 'https://img.gamemonetize.com/ii7heccktd96kbljpcl6xv1qaduiuzod/512x384.jpg', '0', 3, 0, '0', 'Pixel PUBG is a 3D shooting game where you have to choose from five different characters and two maps to play. You will find a lot of weapons inside the game, pick them up and start shooting. Prove your skills in this challenging game and kill all your opponents. Have fun! Features: • 5 characters to choose • 2 maps: Battle Royale and Sandbox • Weapons all over the map • Inventory', '', 'https://html5.gamemonetize.com/ii7heccktd96kbljpcl6xv1qaduiuzod/', 'html5', 960, 600, 1576076683, '1', '0'),
(583, 'gamemonetize-865', 'ninja-run-fullscreen-running-game', 'Ninja Run - Fullscreen Running Game', 'https://img.gamemonetize.com/xduab7tp2o60cvmcu0aqp439wz8k7v74/512x384.jpg', '0', 3, 0, '0', 'Mobile-friendly, fullscreen game play experience. The Ninja is running to his destination. Help him time his jump and collect the coins and in the process, beware of the BOMBS!!!! Why embed this game? Optimum, non-intrusive AD timings. Fullscreen support. Note: For full screen support you must add this: allowfullscreen=&quot;true&quot; Let your users enjoy a full screen game even on mobile. Final Upload: AD Bug Corrected 10/11/2019 Update/', '', 'https://html5.gamemonetize.com/xduab7tp2o60cvmcu0aqp439wz8k7v74/', 'html5', 800, 600, 1576076683, '1', '0'),
(584, 'gamemonetize-864', 'ferrari-super-cars-slide', 'Ferrari Super Cars Slide', 'https://img.gamemonetize.com/ko232xhjmje6eoc0vexc23flotdzlt55/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of the ferrari super cars. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/ko232xhjmje6eoc0vexc23flotdzlt55/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(585, 'gamemonetize-863', 'boy-vs-zombies', 'Boy vs Zombies', 'https://img.gamemonetize.com/4za7jk8ti29yvtt258u8d4bdbjrdlhxq/512x384.jpg', '0', 5, 0, '0', 'Jump over obstacles and zombies. You can jump over zombies head to kill them. Good luck!', '', 'https://html5.gamemonetize.com/4za7jk8ti29yvtt258u8d4bdbjrdlhxq/', 'html5', 1280, 720, 1576076683, '1', '0'),
(586, 'gamemonetize-862', 'fz-impossible-dash', 'FZ Impossible Dash', 'https://img.gamemonetize.com/0euej8vx4d0fhywilrx7i2mbozhgelpf/512x384.jpg', '0', 5, 0, '0', 'FZ Impossible Dash – Playing on the reaction to you , test your abilities! Play and test your reaction, thousands of fans fell in love with the game! Interesting gameplay with very beautiful graphics will tighten you for a long time! Buy the game and get 1 more game as a gift! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/0euej8vx4d0fhywilrx7i2mbozhgelpf/', 'html5', 800, 600, 1576076683, '1', '0'),
(587, 'gamemonetize-861', 'clean-road-2', 'Clean Road 2', 'https://img.gamemonetize.com/mtrzcmu297scdhob836r4crghv3abhsx/512x384.jpg', '0', 4, 0, '0', 'Ready for new addictive game for winter road cleaning. In this game touch and drag the snow plowing truck to clean the road and help the people to reach out their homes on time. Avoid the road blocks obstacles and clean the road to help the people to make them safe.', '', 'https://html5.gamemonetize.com/mtrzcmu297scdhob836r4crghv3abhsx/', 'html5', 480, 600, 1576076683, '1', '0'),
(588, 'gamemonetize-860', 'sand-drawing', 'Sand Drawing', 'https://img.gamemonetize.com/fyhb5zr6mp4ylaqih020b7s6t5igk01z/512x384.jpg', '0', 1, 0, '0', 'Summer is coming! Do you enjoy sand drawing? If so, let’s be creative! Features: • Multiple sand textures, stickers and many more', '', 'https://html5.gamemonetize.com/fyhb5zr6mp4ylaqih020b7s6t5igk01z/', 'html5', 540, 720, 1576076683, '1', '0'),
(589, 'gamemonetize-859', 'candy-explosion', 'Candy Explosion', 'https://img.gamemonetize.com/212ezbn54qrzsm3aru3yw7w729vx3ta5/512x384.jpg', '0', 5, 0, '0', 'In this puzzle game you need to connect 3 or more same candy and to destroy them. In that way you earn points and time to play longer. If you connect more candy and make big explosion you will finish the level faster. Start to play and enjoy!', '', 'https://html5.gamemonetize.com/212ezbn54qrzsm3aru3yw7w729vx3ta5/', 'html5', 720, 1280, 1576076683, '1', '0'),
(590, 'gamemonetize-858', 'alien-shoot-zombies', 'Alien Shoot Zombies', 'https://img.gamemonetize.com/pg0z1odvqtab0kd7nmwu64mtnlomau90/512x384.jpg', '0', 3, 0, '0', 'Find accurate angle and kill all zombies!', '', 'https://html5.gamemonetize.com/pg0z1odvqtab0kd7nmwu64mtnlomau90/', 'html5', 854, 480, 1576076683, '1', '0'),
(591, 'gamemonetize-857', 'boy-adventurer', 'Boy Adventurer', 'https://img.gamemonetize.com/mc0iyzw9q57tvaz61yefpv98nqbe8kev/512x384.jpg', '0', 3, 0, '0', 'Boy Adventurer is great platform game. You need to collect 3 keys on the stage to complete the level. You have 12 levels to complete game. Jump zombies on head to kill them, avoid spikes, slide, climb on walls, collect coins. Use magic potion to protect self from bombs and zombies. You have 6 lives on each level. Beware of falling rocks. Double jump is very important to stay alive! Enjoy!', '', 'https://html5.gamemonetize.com/mc0iyzw9q57tvaz61yefpv98nqbe8kev/', 'html5', 854, 480, 1576076683, '1', '0'),
(592, 'gamemonetize-856', 'zombie-tsunami-online', 'Zombie Tsunami Online', 'https://img.gamemonetize.com/dwvcte397don0y485kcpytqjy9iw2qef/512x384.jpg', '0', 3, 0, '0', 'Zombies Tsunami is an endless running game, in which players need to control a group of zombies to keep running. Avoid many obstacles, such as cars and buses, ect. Must ensure the number of zombies in your group.Collect coins and buy special powers like super zombies, a tsunami or alien invasion.Survive and eat all people in the world to make the biggest horde and destroy everything', '', 'https://html5.gamemonetize.com/dwvcte397don0y485kcpytqjy9iw2qef/', 'html5', 800, 480, 1576076683, '1', '1'),
(593, 'gamemonetize-855', 'geometry-neon-dash-world-2', 'Geometry neon dash world 2', 'https://img.gamemonetize.com/vr5vzpds6xp029rxgsjkvfg98l1lrz7m/512x384.jpg', '0', 3, 0, '0', 'Geometry neon dash world is back with the second part with a brand new adventure! New levels, new music, new monsters, new everything! Flex your clicky finger as you jump, fly and flip your way through dark caves and spiky obstacles. Pick stars and unlock new characters and make the best scores', '', 'https://html5.gamemonetize.com/vr5vzpds6xp029rxgsjkvfg98l1lrz7m/', 'html5', 800, 600, 1576076683, '1', '0'),
(594, 'gamemonetize-854', 'tiles-hop-3d', 'Tiles Hop 3D', 'https://img.gamemonetize.com/8w10xmnj9h1shbam6xx0s1w2dymr73tg/512x384.jpg', '0', 4, 0, '0', 'Listen to the magic beat, follow the rhythm and use your musical reflexes to guide the ball from tiles to tiles. Touch, Hold and Drag the ball to make it jump on the Tiles. Don&#039;t Miss the Tiles! Enjoy the awesome music and addictive challenges designed for each song.', '', 'https://html5.gamemonetize.com/8w10xmnj9h1shbam6xx0s1w2dymr73tg/', 'html5', 480, 600, 1576076683, '1', '1'),
(595, 'gamemonetize-853', 'beachball-fun', 'Beachball Fun', 'https://img.gamemonetize.com/2lmqfv7x4rhwjlhzbi82yk3yeahmbkxe/512x384.jpg', '0', 5, 0, '0', 'Drop all of the colered balls in the bucket with the same color. Use left mouse button to cut the chain.', '', 'https://html5.gamemonetize.com/2lmqfv7x4rhwjlhzbi82yk3yeahmbkxe/', 'html5', 1280, 720, 1576076683, '1', '0'),
(596, 'gamemonetize-852', 'crazy-snake-io', 'Crazy Snake io', 'https://img.gamemonetize.com/206emjg52b8oaqr9rjql18eag7tljkhm/512x384.jpg', '0', 5, 0, '0', 'Crazy Snake io features: - 2 game modes - multiple snake skins - addictive gameplay', '', 'https://html5.gamemonetize.com/206emjg52b8oaqr9rjql18eag7tljkhm/', 'html5', 960, 540, 1576076683, '1', '0'),
(597, 'gamemonetize-851', 'hip-hop-ball', 'Hip Hop Ball', 'https://img.gamemonetize.com/5vrke9t25mtmj41e4ev3eqcz8vq9b33g/512x384.jpg', '0', 5, 0, '0', 'Ready for a new flying ball adventure? Enjoy!', '', 'https://html5.gamemonetize.com/5vrke9t25mtmj41e4ev3eqcz8vq9b33g/', 'html5', 800, 600, 1576076683, '1', '0'),
(598, 'gamemonetize-850', 'space-combat', 'Space Combat', 'https://img.gamemonetize.com/tsjni3sh3yui3kyullaqezaw5qn572x0/512x384.jpg', '0', 5, 0, '0', 'Space Combat is a fun spacecraft simulation game in which the player can fight AI enemy opponents. Features: - 3 game modes - Realistic space - Smooth maneuver', '', 'https://html5.gamemonetize.com/tsjni3sh3yui3kyullaqezaw5qn572x0/', 'html5', 960, 600, 1576076683, '1', '0'),
(599, 'gamemonetize-849', 'dino-transport-simulator', 'Dino Transport Simulator', 'https://img.gamemonetize.com/iw4xilcvgh6s432j3lr7rv6hyq4sa3as/512x384.jpg', '0', 5, 0, '0', 'Dino Transport Truck is a 3D game where you are a truck driver and your job is to transport dinosaurs by using your driving skills. Features • Multiple levels • 3 game modes', '', 'https://html5.gamemonetize.com/iw4xilcvgh6s432j3lr7rv6hyq4sa3as/', 'html5', 960, 540, 1576076683, '1', '0'),
(600, 'gamemonetize-848', 'batty-the-bat', 'Batty The Bat', 'https://img.gamemonetize.com/ny52llalul4f7g6alhhjzuskwaopxa9l/512x384.jpg', '0', 5, 0, '0', 'Test your bat flying skill, collect all pumpkins and celebrate Halloween with Batty! Features: - Unique game feel - Simple and convenient controls - Fun adventure story - 24 hand made levels - Batty!', '', 'https://html5.gamemonetize.com/ny52llalul4f7g6alhhjzuskwaopxa9l/', 'html5', 900, 600, 1576076683, '1', '0'),
(601, 'gamemonetize-847', 'puzzleguys-hearts', 'Puzzleguys Hearts', 'https://img.gamemonetize.com/cbmbcfrtq7jruu0y3gbh2vgv35ii0jvd/512x384.jpg', '0', 5, 0, '0', 'Classic Hearts game. It is is an &quot;evasion-type&quot; trick-taking playing card game and, in this version you&#039;ll play against three computer opponents. Can you beat them?', '', 'https://html5.gamemonetize.com/cbmbcfrtq7jruu0y3gbh2vgv35ii0jvd/', 'html5', 768, 432, 1576076683, '1', '0'),
(602, 'gamemonetize-846', 'trump-ragdoll', 'Trump Ragdoll', 'https://img.gamemonetize.com/3pfqnt5vjd39v83oplb7luljs8q07qya/512x384.jpg', '0', 4, 0, '0', 'Trump Ragdoll is an online game that you can play for free. Trump Ragdoll is a parody and should not be taken seriously, but you can have a try in your spare time. The players need to use the mouse or tap on the screen to play around. Hope you can join us and have fun!', '', 'https://html5.gamemonetize.com/3pfqnt5vjd39v83oplb7luljs8q07qya/', 'html5', 854, 480, 1576076683, '1', '0'),
(603, 'gamemonetize-845', 'jigsaw-puzzle-hawaii', 'Jigsaw Puzzle Hawaii', 'https://img.gamemonetize.com/z4ogl071049ghmm9k5ume3tm2u0n44a3/512x384.jpg', '0', 5, 0, '0', 'Some say that Hawaii is the most beautiful place in the world. Take a tour with 16 stunning images of this paradise.', '', 'https://html5.gamemonetize.com/z4ogl071049ghmm9k5ume3tm2u0n44a3/', 'html5', 800, 450, 1576076683, '1', '0'),
(604, 'gamemonetize-844', 'halloween-mahjong-2019', 'Halloween Mahjong 2019', 'https://img.gamemonetize.com/vz1e9p2e97omq90g0mxp4x82fwb5rirm/512x384.jpg', '0', 5, 0, '0', 'Combine 2 of the same halloween mahjong tiles to remove them from the board. You only can use free tiles. A free tile is not covered by another stone and at least 1 side (left or right) is open.You have 15 levels to challenge in this mahjong games. The first 9 levels shapes are &quot;H A L L O W E E N&quot;, and the last 6 levels shapes are random. You can play this mahjong game as many times as you like (with different challenge).', '', 'https://html5.gamemonetize.com/vz1e9p2e97omq90g0mxp4x82fwb5rirm/', 'html5', 800, 480, 1576076683, '1', '0'),
(605, 'gamemonetize-843', 'grow-a-tree-climate', 'Grow A Tree Climate', 'https://img.gamemonetize.com/asl2sn6enc88hfxp2sicxxr5z5pv7iyi/512x384.jpg', '0', 5, 0, '0', 'Are you ready to win climate change? Well .. here you will able to do something about this, try to redirection water to tree to grow fast.', '', 'https://html5.gamemonetize.com/asl2sn6enc88hfxp2sicxxr5z5pv7iyi/', 'html5', 800, 600, 1576076683, '1', '0'),
(606, 'gamemonetize-842', 'holo-ball-2019', 'Holo Ball 2019', 'https://img.gamemonetize.com/lkg67ki7fii2ud3bne9o2kxhti55wm0h/512x384.jpg', '0', 5, 0, '0', 'Try Holo Ball, you need to collect all objects from each level.', '', 'https://html5.gamemonetize.com/lkg67ki7fii2ud3bne9o2kxhti55wm0h/', 'html5', 800, 600, 1576076683, '1', '0'),
(607, 'gamemonetize-841', 'snow-plow-jeep-driving', 'Snow Plow Jeep Driving', 'https://img.gamemonetize.com/nbiwn3fnjz13v089mc8qjmepmuuinnfb/512x384.jpg', '0', 5, 0, '0', 'Plow Jeep Simulator is a 3D simulation game where you need to remove ice and snow from the road and front of houses for cleaning the area for civilians before running out of time. Features: • Multiple cars • Multiple levels to play', '', 'https://html5.gamemonetize.com/nbiwn3fnjz13v089mc8qjmepmuuinnfb/', 'html5', 960, 540, 1576076683, '1', '0'),
(608, 'gamemonetize-840', 'pinball-vs', 'Pinball.VS', 'https://img.gamemonetize.com/yyj26x1766gg6otf1mn22oj3teoutcdr/512x384.jpg', '0', 3, 0, '0', 'PinBall 1V1 battle! [Pretend] Fight with world player 1V1! 6 theme scenes, 20+ pinball layouts and random phalanx for you to challenge! Simple control and rules, shooting down all the opponents, one-hand operation. Random kick-offs, winning upgrades, challenging more difficult pinball layout and phalanx. Ok, I can&#039;t write it any more. It&#039;s just a 1V1 pinball game, casual 3D, welcome to play!', '', 'https://html5.gamemonetize.com/yyj26x1766gg6otf1mn22oj3teoutcdr/', 'html5', 414, 736, 1576076683, '1', '0'),
(609, 'gamemonetize-839', 'ace-air-fighter', 'Ace Air Fighter', 'https://img.gamemonetize.com/bwepeimvy9pdiehthjtuan0m7h1usio4/512x384.jpg', '0', 1, 0, '0', 'Air Fighter is a challenging game that will give you a battle-field like experience. With amazing graphics and theme, all you have to swing with your fighter and kill the enemies travelling your way. just swipe or touch your finger at the screen to move your plane. Keep in mind that you have unlimited amount of bullets to destroy the fighter .', '', 'https://html5.gamemonetize.com/bwepeimvy9pdiehthjtuan0m7h1usio4/', 'html5', 400, 700, 1576076683, '1', '0'),
(610, 'gamemonetize-838', 'wow-words', 'Wow Words', 'https://img.gamemonetize.com/zdojfgyvn4qhy91ozvb1566uyhisrd0q/512x384.jpg', '0', 5, 0, '0', 'Fun and educational game. Connect letters and form words. 30 levels to complete.', '', 'https://html5.gamemonetize.com/zdojfgyvn4qhy91ozvb1566uyhisrd0q/', 'html5', 432, 768, 1576076683, '1', '0'),
(611, 'gamemonetize-837', 'offroad-climb-racing', 'Offroad Climb Racing', 'https://img.gamemonetize.com/14f12ldfj57ku7ve3oucgrgb9k8z7f69/512x384.jpg', '0', 2, 0, '0', 'You are a bike rider and you have an incredible offroad track in front of you. Get your adrenaline and try to avoid collision to get finished each level. Have fun! Features • Good graphics • Multiple levels', '', 'https://html5.gamemonetize.com/14f12ldfj57ku7ve3oucgrgb9k8z7f69/', 'html5', 960, 540, 1576076683, '1', '0'),
(612, 'gamemonetize-836', 'oil-tanker-transporter-truck', 'Oil Tanker Transporter Truck', 'https://img.gamemonetize.com/grotnam8k4c0n49a6jhdgknhdjhvf2yw/512x384.jpg', '0', 2, 0, '0', 'Oil Tanker Truck Drive is a 3D driving simulation. Drive the oil tanker to the pointed direction in order to deliver the cargo safe. Be careful, as the road is full of obstacles. Features: • Multiple truck models • Multiple levels', '', 'https://html5.gamemonetize.com/grotnam8k4c0n49a6jhdgknhdjhvf2yw/', 'html5', 960, 600, 1576076683, '1', '0'),
(613, 'gamemonetize-835', 'sheep-sling', 'Sheep Sling', 'https://img.gamemonetize.com/ht80ejhvyln0mmvz4yl3yb20llpgvzpc/512x384.jpg', '0', 2, 0, '0', 'Sling, bounce and swing your Sheep to the top. Get rid of the dangerous obstacles, collect coins to unlock more cool animals. Are you ready for this endless challenge? Play now!', '', 'https://html5.gamemonetize.com/ht80ejhvyln0mmvz4yl3yb20llpgvzpc/', 'html5', 540, 960, 1576076683, '1', '0'),
(614, 'gamemonetize-834', 'fz-tripolygon', 'FZ Tripolygon', 'https://img.gamemonetize.com/9iy0ce9yqudwwltgq8qaers7k7nkrzb0/512x384.jpg', '0', 5, 0, '0', 'Rotate the triangle, to match the color of the line. How high can you score? Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/9iy0ce9yqudwwltgq8qaers7k7nkrzb0/', 'html5', 800, 600, 1576076683, '1', '0'),
(615, 'gamemonetize-833', 'bowling-fun-2019', 'Bowling Fun 2019', 'https://img.gamemonetize.com/ov624v5ptnjbso7fopn5d27jpo7u9rdx/512x384.jpg', '0', 5, 0, '0', 'Just Aim Target and Strike to fall them all Pins, Have Fun', '', 'https://html5.gamemonetize.com/ov624v5ptnjbso7fopn5d27jpo7u9rdx/', 'html5', 800, 600, 1576076683, '1', '0'),
(616, 'gamemonetize-832', 'overloaded-transport-bus-passagers', 'Overloaded Transport Bus Passagers', 'https://img.gamemonetize.com/5ppwpjx6e1mutt4nbvos4bdqux3ygzim/512x384.jpg', '0', 5, 0, '0', 'You are the buss driver and need to keep the bus do not overload. Use your skill to put passengers inside the bus.', '', 'https://html5.gamemonetize.com/5ppwpjx6e1mutt4nbvos4bdqux3ygzim/', 'html5', 800, 600, 1576076683, '1', '0'),
(617, 'gamemonetize-831', 'prisonier-transport-simulator-2019', 'Prisonier Transport Simulator 2019', 'https://img.gamemonetize.com/em8o0o5nf6675mqkgif7dm4w296l102f/512x384.jpg', '0', 5, 0, '0', 'Ready for simulation of transport of prisoners? You have a chance now in a few awesome levels.', '', 'https://html5.gamemonetize.com/em8o0o5nf6675mqkgif7dm4w296l102f/', 'html5', 800, 600, 1576076683, '1', '0'),
(618, 'gamemonetize-830', 'commando-fps', 'Commando FPS', 'https://img.gamemonetize.com/6qoeneo5204eimucs6j7qdwkk41e00p7/512x384.jpg', '0', 3, 0, '0', 'Commando Attack is a classical shooter with missions type commando. Your main mission is to kill all the terrorists and don’t get killed. Pay attention to the missions description from every level in order to complete the game. Enjoy!', '', 'https://html5.gamemonetize.com/6qoeneo5204eimucs6j7qdwkk41e00p7/', 'html5', 960, 600, 1576076683, '1', '0'),
(619, 'gamemonetize-829', 'unicorn-kitty-coloring-book', 'Unicorn Kitty Coloring Book', 'https://img.gamemonetize.com/blwuesgqm8jz9dx72zwcedjoium8y1za/512x384.jpg', '0', 1, 0, '0', 'Welcome young artist! Show everyone your talents. Rather, color these cute cartoon characters about the unicorn kitty and her friends. Choose delicate shades and experiment. Take a screenshot and share the result with your friends!', '', 'https://html5.gamemonetize.com/blwuesgqm8jz9dx72zwcedjoium8y1za/', 'html5', 800, 600, 1576076683, '1', '0'),
(620, 'gamemonetize-828', 'motor-bike-pizza-delivery-2020', 'Motor Bike Pizza Delivery 2020', 'https://img.gamemonetize.com/p8zsnghay6d6eo2bj7ow6tev1amm1kkr/512x384.jpg', '0', 1, 0, '0', 'Are you ready for delivering pizza? Well ... you have a chance this time to deliver all your pizza with a bike, driving in all the town and deliver the best pizza in town at different clients.', '', 'https://html5.gamemonetize.com/p8zsnghay6d6eo2bj7ow6tev1amm1kkr/', 'html5', 800, 600, 1576076683, '1', '0'),
(621, 'gamemonetize-827', 'marble-rolling-stunt', 'Marble Rolling Stunt', 'https://img.gamemonetize.com/6qb2coa9wh5nkyvqb594za70how0wfb2/512x384.jpg', '0', 1, 0, '0', 'Marble Rolling Stunt is classic Slope game in a new coat. The game is colorful and the platforms you are rolling on are treacherous.', '', 'https://html5.gamemonetize.com/6qb2coa9wh5nkyvqb594za70how0wfb2/', 'html5', 800, 600, 1576076683, '1', '0'),
(622, 'gamemonetize-826', 'break-the-gems', 'Break The Gems', 'https://img.gamemonetize.com/yyngv06qwhumsfenti5qu3kyj1n9wo5v/512x384.jpg', '0', 5, 0, '0', 'Move your gem cleverly, touch the target one to break them. 40 levels to play, can you complete them all? Play now!', '', 'https://html5.gamemonetize.com/yyngv06qwhumsfenti5qu3kyj1n9wo5v/', 'html5', 960, 540, 1576076683, '1', '0'),
(623, 'gamemonetize-825', 'train-driver', 'Train Driver', 'https://img.gamemonetize.com/wr5d6swt9hkjcednob79c7325ez4r9en/512x384.jpg', '0', 5, 0, '0', 'Hello, trainspotters! Train Simulator is a very realistic simulation game where you have three different gameplays. Your mission is to drive the train carefully in a specific amount of time in order to level up. Get on board! Features: • Multiple levels • Realistic simulation • Three game modes', '', 'https://html5.gamemonetize.com/wr5d6swt9hkjcednob79c7325ez4r9en/', 'html5', 800, 540, 1576076683, '1', '0'),
(624, 'gamemonetize-824', 'uphill-bus-drive', 'Uphill Bus Drive', 'https://img.gamemonetize.com/01tq0hm3e1kkdk5zi4oa0g36pdtxitji/512x384.jpg', '0', 2, 0, '0', 'Uphill Bus Simulator is a classic 3D driving simulator. You can choose from multiple bus models and three different game modes. You need to drive the bus in order to pick up the passengers. The map in upper left side of the screen shows you the road to the closest bus station from where you need to pick up the passengers. This is a realistic simulation game where you can test your driving skills. Features: • Different bus models • Multiple levels to play • Three game modes', '', 'https://html5.gamemonetize.com/01tq0hm3e1kkdk5zi4oa0g36pdtxitji/', 'html5', 960, 600, 1576076683, '1', '0'),
(625, 'gamemonetize-823', 'xtreme-racing-car-crash-2019', 'XTREME RACING CAR CRASH 2019', 'https://img.gamemonetize.com/jxrle9j5o0cjglnfgutbn27oimd35o2p/512x384.jpg', '0', 2, 0, '0', 'An new series of demolition car crash 2019 is here with a new stunts map and 20 realistic cars. Destroy cars and gain money so can upgrade your car with nox, color, wheels and much more, each car has its own upgrade. Multiplayer is here to play with your friends and also offline to finish all levels, random car AI will come to you to destroy, drive and speed up to your car and crash into them.', '', 'https://html5.gamemonetize.com/jxrle9j5o0cjglnfgutbn27oimd35o2p/', 'html5', 800, 600, 1576076683, '1', '0'),
(626, 'gamemonetize-822', 'ferrari-488-gt3-evo-puzzle-gm', 'Ferrari 488 GT3 Evo Puzzle - GM', 'https://img.gamemonetize.com/rpduhg9ze052mn0o419ujnscgsig03yr/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Ferrari 488 GT3 Evo Puzzle. All images is with the ferrari 488 gt3 evo. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/rpduhg9ze052mn0o419ujnscgsig03yr/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(627, 'gamemonetize-821', 'halloween-trucks-jigsaw', 'Halloween Trucks Jigsaw', 'https://img.gamemonetize.com/gkyqx2ptq2e1xg0wjkhmd30qphfbrq87/512x384.jpg', '0', 5, 0, '0', 'In this Halloween Jigsaw game you can choose your favorite images with Halloween truck and start to play. You can play with 25,49 or 100 pieces. Drag the pieces with your mouse and put in the right position to get the image with Halloween Truck. Play and enjoy!', '', 'https://html5.gamemonetize.com/gkyqx2ptq2e1xg0wjkhmd30qphfbrq87/', 'html5', 1280, 900, 1576076683, '1', '0'),
(628, 'gamemonetize-820', 'zip-me-up-halloween', 'Zip Me Up Halloween', 'https://img.gamemonetize.com/o4lpd09clm52wbu0szy9zwd6e55h2sur/512x384.jpg', '0', 1, 0, '0', 'Zip Me Up Halloween is fun halloween game that you can play for free. Click on the zippo lighter and see what you are gonna get for halloween.', '', 'https://html5.gamemonetize.com/o4lpd09clm52wbu0szy9zwd6e55h2sur/', 'html5', 854, 480, 1576076683, '1', '0'),
(629, 'gamemonetize-819', 'ladybug-amp-cat-noir-maker', 'Ladybug &amp; Cat Noir Maker', 'https://img.gamemonetize.com/9ocmlgjikk7muri674v1fu64thuynrux/512x384.jpg', '0', 1, 0, '0', 'This maker will help you create your unique character in the style of Ladybug. You can choose for your hero a lot of costumes, shoes, hair, mask and accessories. Color these items in your favorite colors. Create a superhero-girl and superhero-boy so that they can fight together against the villains.', '', 'https://html5.gamemonetize.com/9ocmlgjikk7muri674v1fu64thuynrux/', 'html5', 800, 600, 1576076683, '1', '0'),
(630, 'gamemonetize-818', 'atm-security-van', 'ATM Security Van', 'https://img.gamemonetize.com/g2dkq4xc3jooyg3ns58nav977mazp3p5/512x384.jpg', '0', 1, 0, '0', 'Collect the money from the Bank and make an ATM deposit without getting robbed. Features: •car racing •simulator •multiple levels', '', 'https://html5.gamemonetize.com/g2dkq4xc3jooyg3ns58nav977mazp3p5/', 'html5', 960, 600, 1576076683, '1', '0'),
(631, 'gamemonetize-817', 'arcade-basketball', 'Arcade BasketBall', 'https://img.gamemonetize.com/4ivlxs4mws15wcm4uhqqzahrgwlzfmrk/512x384.jpg', '0', 8, 0, '0', 'Remember back when you used to go to the arcade, put a quarter in, and spend a few minutes playing a thrilling game of beat the clock basketball.', '', 'https://html5.gamemonetize.com/4ivlxs4mws15wcm4uhqqzahrgwlzfmrk/', 'html5', 960, 600, 1576076683, '1', '0'),
(632, 'gamemonetize-816', 'pacmen-9-0', 'Pacmen 9.0', 'https://img.gamemonetize.com/84tkivlwbtejmnsfxpxpay334zlmk2is/512x384.jpg', '0', 8, 0, '0', 'Pacmen 9.0 – this is a great top down shooting arcade game with very beautiful graphics. Enjoy new pacman game with new great gameplay! The game is ideally suited for mobile devices.', '', 'https://html5.gamemonetize.com/84tkivlwbtejmnsfxpxpay334zlmk2is/', 'html5', 800, 600, 1576076683, '1', '0'),
(633, 'gamemonetize-815', 'halloween-where-is-my-zombie', 'Halloween - Where Is My Zombie?', 'https://img.gamemonetize.com/cb2k011hy8vgglq7ers0tdnt9kc6r2l4/512x384.jpg', '0', 8, 0, '0', 'You love playing golf, you also love Halloween, this game is dedicated to you. Lead the Halloween ball into the hole, collect coins to unlock new cool Halloween balls. 40 levels to go. Play now!', '', 'https://html5.gamemonetize.com/cb2k011hy8vgglq7ers0tdnt9kc6r2l4/', 'html5', 960, 540, 1576076683, '1', '0'),
(634, 'gamemonetize-814', 'army-war-cs', 'Army War CS', 'https://img.gamemonetize.com/wdrdg0l6xbfv7bdcspymwbggkbr8bwx7/512x384.jpg', '0', 3, 0, '0', 'Mission: Kill everyone. No other details needed. Features: • 15 levels • Multiple weapons • Amazing graphics', '', 'https://html5.gamemonetize.com/wdrdg0l6xbfv7bdcspymwbggkbr8bwx7/', 'html5', 960, 600, 1576076683, '1', '0'),
(635, 'gamemonetize-813', 'sumo-saga', 'Sumo Saga', 'https://img.gamemonetize.com/8mw23uw5aebfydzzf2obbvqzg38rms9v/512x384.jpg', '0', 3, 0, '0', 'With cool japanese Sfx and cute graphics play Sumo Saga is a single tap based game just tap on screen to jump on poles. Tap fast so sumo can climb to mountains. On every gameover background and poles gets changed to give a nice feel to the game. Start Tapping!', '', 'https://html5.gamemonetize.com/8mw23uw5aebfydzzf2obbvqzg38rms9v/', 'html5', 640, 1136, 1576076683, '1', '0'),
(636, 'gamemonetize-812', 'car-wash', 'Car Wash', 'https://img.gamemonetize.com/i8j2ilop89ykcwj4f8e78xnn0ebx9kzs/512x384.jpg', '0', 1, 0, '0', 'Fun Car Wash for kids. Educational game for kids to learn how to clean many different cars from beginning to end, applying all kinds of cleaning treatment and adding water, soap, polish and more. Also, once your children have cleaned the car they can tune it to be cooler.', '', 'https://html5.gamemonetize.com/i8j2ilop89ykcwj4f8e78xnn0ebx9kzs/', 'html5', 960, 640, 1576076683, '1', '0'),
(637, 'gamemonetize-811', 'hospital-doctor-games', 'Hospital Doctor Games', 'https://img.gamemonetize.com/7ywabtxoubsu42gtmgxlcedzod4fvth3/512x384.jpg', '0', 1, 0, '0', 'Always dreamt of being a doctor? This is your chance! The patients count on you! Features: • Good graphics • Multiple characters', '', 'https://html5.gamemonetize.com/7ywabtxoubsu42gtmgxlcedzod4fvth3/', 'html5', 540, 720, 1576076683, '1', '0'),
(638, 'gamemonetize-810', 'face-paint', 'Face Paint', 'https://img.gamemonetize.com/md2w77044w4fsgmaqkuvfp9wdr2qxqzj/512x384.jpg', '0', 1, 0, '0', 'Hanna needs to get ready on time. Help her choose her dress and do her make up. Be creative and let’s shine! Features: • Multiple gameplays', '', 'https://html5.gamemonetize.com/md2w77044w4fsgmaqkuvfp9wdr2qxqzj/', 'html5', 540, 720, 1576076683, '1', '0'),
(639, 'gamemonetize-809', 'cat-doctor', 'Cat Doctor', 'https://img.gamemonetize.com/fnr702vxm6074y6j7iknitj8bsyqbs9r/512x384.jpg', '0', 1, 0, '0', 'Work as a vet and take care of cute but sick cats. Features • Good graphics • Multiple levels', '', 'https://html5.gamemonetize.com/fnr702vxm6074y6j7iknitj8bsyqbs9r/', 'html5', 540, 720, 1576076683, '1', '0'),
(640, 'gamemonetize-808', 'cartoon-retro-car-parking-2019', 'Cartoon Retro Car Parking 2019', 'https://img.gamemonetize.com/c5fmp8jcp8wa3c6rvxre6tgnqncstmk5/512x384.jpg', '0', 1, 0, '0', 'Try the Cartoon Retro Car Parking 2019 in nice mission of driving. You will have the chance to test your skills here. Have fun!', '', 'https://html5.gamemonetize.com/c5fmp8jcp8wa3c6rvxre6tgnqncstmk5/', 'html5', 800, 600, 1576076683, '1', '0'),
(641, 'gamemonetize-807', 'realistic-street-fight-apocalypse', 'Realistic Street Fight Apocalypse', 'https://img.gamemonetize.com/joqioj2ba18mfrewk8sp3xvszd8zxn4h/512x384.jpg', '0', 1, 0, '0', 'Are you ready for fighting on the street at apocalypse climate change? Well, here you can play in 40 levels with 3 different bosses and smart enemies with different skills attack. Survive Apocalypse by using your skills on the street.', '', 'https://html5.gamemonetize.com/joqioj2ba18mfrewk8sp3xvszd8zxn4h/', 'html5', 800, 600, 1576076683, '1', '0'),
(642, 'gamemonetize-806', 'roller-ball-3d', 'Roller Ball 3D', 'https://img.gamemonetize.com/883xz70yr7vx4xf8f3pss8emzcs3p90y/512x384.jpg', '0', 1, 0, '0', 'Roller Ball 3D, one-click to roll ball in map.', '', 'https://html5.gamemonetize.com/883xz70yr7vx4xf8f3pss8emzcs3p90y/', 'html5', 800, 600, 1576076683, '1', '0'),
(643, 'gamemonetize-805', 'angry-bull-attack', 'Angry Bull Attack', 'https://img.gamemonetize.com/pcvapusui9bs4s4l12et17ru2e2ar8yh/512x384.jpg', '0', 3, 0, '0', 'The bulls have escaped the arena and are a danger to the people. Your mission is to shoot all the aggressive bulls before they become a serious threat to the city inhabitants. Features: • Fun gameplay • Multiple Levels • 2 weapons', '', 'https://html5.gamemonetize.com/pcvapusui9bs4s4l12et17ru2e2ar8yh/', 'html5', 960, 600, 1576076683, '1', '0'),
(644, 'gamemonetize-804', 'fantastic-tower-balance', 'Fantastic Tower Balance', 'https://img.gamemonetize.com/bw8p0brgvddgpz6atsb8bomqlvzo5brg/512x384.jpg', '0', 3, 0, '0', 'Build the earthquake tolerance balanced tower and keep your city safe from earthquake. Tap at the perfect time to place the moving building block in the appropriate position to build the balanced tower.', '', 'https://html5.gamemonetize.com/bw8p0brgvddgpz6atsb8bomqlvzo5brg/', 'html5', 800, 600, 1576076683, '1', '0'),
(645, 'gamemonetize-803', 'chicken-love', 'Chicken Love', 'https://img.gamemonetize.com/vl72h5kenbg24mec0loy2pl8yqxjbg77/512x384.jpg', '0', 3, 0, '0', 'Chicken Love – where you take control of the brave chicken. In this game you will control the chicken, who will have to go through a difficult journey, traveling in a dangerous world filled with evil trolls. Mission is to find his love and save from the dangerous.', '', 'https://html5.gamemonetize.com/vl72h5kenbg24mec0loy2pl8yqxjbg77/', 'html5', 480, 320, 1576076683, '1', '0'),
(646, 'gamemonetize-802', 'halloween-slide-puzzle-2', 'Halloween Slide Puzzle 2', 'https://img.gamemonetize.com/ae6l52mq5puxtz7khgift7od6m7n1onc/512x384.jpg', '0', 5, 0, '0', 'Play this slide puzzle games of halloween. It&#039;s include 3 images and 3 modes to play.', '', 'https://html5.gamemonetize.com/ae6l52mq5puxtz7khgift7od6m7n1onc/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(647, 'gamemonetize-801', 'halloween-bubble-shooter-2019', 'Halloween Bubble Shooter 2019', 'https://img.gamemonetize.com/3pfslukut29r9x542xxxc25c9snassqv/512x384.jpg', '0', 5, 0, '0', 'Halloween bubble shooter is a classical bubble shooter game. To complete a level you need to pop the trapped bubbles to rescue them.Shoot the bubble on the board to make groups of 3 or more bubbles of the same to clear.You will find some interesting bubbles such as mine-bubbles, thunder-bubbles, plus-bubbles, ghost-bubbles and more in some levels.The last levels is random, so you can play it as many times as like (with different challenge).', '', 'https://html5.gamemonetize.com/3pfslukut29r9x542xxxc25c9snassqv/', 'html5', 480, 640, 1576076683, '1', '0'),
(648, 'gamemonetize-800', 'ben-10-coloring-book', 'Ben 10 Coloring Book', 'https://img.gamemonetize.com/hfzza96nc0fw1p3d39jdizllqvtokzf2/512x384.jpg', '0', 4, 0, '0', 'Bts Ben 10 Coloring Book is an online game that you can play for free. Bts Ben 10 Coloring Book is an addictive coloring game for babies and kids. You can play it in any spare time. There are four pictures you can choose and they are all about Ben 10. Show us your creation and paint to make these pictures beautiful. Have fun with Bts Ben 10 Coloring Book!', '', 'https://html5.gamemonetize.com/hfzza96nc0fw1p3d39jdizllqvtokzf2/', 'html5', 854, 480, 1576076683, '1', '0'),
(649, 'gamemonetize-799', 'mario-kart-jigsaw', 'Mario Kart Jigsaw', 'https://img.gamemonetize.com/7y5f3endhrs6nunqgf4oxbcrh5jkbg2j/512x384.jpg', '0', 5, 0, '0', 'Mario Kart Jigsaw is a free online jigsaw puzzle game. You can select one of the three images and then select one of the four modes (16, 36, 64 and 100 pieces). Select your favorite picture and complete the jigsaw in the shortest time possible! Have fun and enjoy!', '', 'https://html5.gamemonetize.com/7y5f3endhrs6nunqgf4oxbcrh5jkbg2j/', 'html5', 960, 540, 1576076683, '1', '0'),
(650, 'gamemonetize-798', 'fast-food-match-3', 'Fast Food Match 3', 'https://img.gamemonetize.com/0w9uy6pjy2l1u0adolw0w1iqpdudx6mx/512x384.jpg', '0', 5, 0, '0', 'Fast Food Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful autumn style! Enjoy the game!', '', 'https://html5.gamemonetize.com/0w9uy6pjy2l1u0adolw0w1iqpdudx6mx/', 'html5', 960, 540, 1576076683, '1', '0'),
(651, 'gamemonetize-797', 'restless-kids-jigsaw', 'Restless Kids Jigsaw', 'https://img.gamemonetize.com/vswlgav5iwbflgr4futucn378e3kfh5b/512x384.jpg', '0', 5, 0, '0', 'Restless Kids Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/vswlgav5iwbflgr4futucn378e3kfh5b/', 'html5', 960, 540, 1576076683, '1', '0'),
(652, 'gamemonetize-796', 'modern-home-difference', 'Modern Home Difference', 'https://img.gamemonetize.com/hyp37xnauhy7ldv7gu7w93e2p5qyg8hx/512x384.jpg', '0', 5, 0, '0', 'Modern Home Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/hyp37xnauhy7ldv7gu7w93e2p5qyg8hx/', 'html5', 960, 540, 1576076683, '1', '0'),
(653, 'gamemonetize-795', 'happy-snowman-coloring', 'Happy Snowman Coloring', 'https://img.gamemonetize.com/5h18b6illgdxo8c0qws9rv0hpw72725c/512x384.jpg', '0', 5, 0, '0', 'Happy Snowman Coloring is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/5h18b6illgdxo8c0qws9rv0hpw72725c/', 'html5', 960, 540, 1576076683, '1', '0'),
(654, 'gamemonetize-794', 'mission-to-mars-coloring', 'Mission to Mars Coloring', 'https://img.gamemonetize.com/dhlfaetzjphd11j2jw8s7uoe76bqfzit/512x384.jpg', '0', 5, 0, '0', 'Mission to Mars Coloring is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/dhlfaetzjphd11j2jw8s7uoe76bqfzit/', 'html5', 960, 540, 1576076683, '1', '0'),
(655, 'gamemonetize-793', 'tropical-paradise-difference', 'Tropical Paradise Difference', 'https://img.gamemonetize.com/vpjoxx9pk9gm7kg4qnctrvyid9qfvaxq/512x384.jpg', '0', 5, 0, '0', 'Tropical Paradise Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/vpjoxx9pk9gm7kg4qnctrvyid9qfvaxq/', 'html5', 960, 540, 1576076683, '1', '0'),
(656, 'gamemonetize-792', 'ancient-samurai-jigsaw', 'Ancient Samurai Jigsaw', 'https://img.gamemonetize.com/wlvyjewswnx2j6a3bz7wx5khyna6gdmc/512x384.jpg', '0', 5, 0, '0', 'Ancient Samurai Jigsaw is a free online game from genre of puzzle and jigsaw games. You need to start from the first one and to unlock the next image.You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/wlvyjewswnx2j6a3bz7wx5khyna6gdmc/', 'html5', 960, 540, 1576076683, '1', '0'),
(657, 'gamemonetize-791', 'monsters-wheels-special', 'Monsters&#039; Wheels Special', 'https://img.gamemonetize.com/mde2rzu4y35gw7d96xo2wrjojaz1nx99/512x384.jpg', '0', 2, 0, '0', 'Drive your huge and powerful car on various trucks. Go over hills, precipices and jump over different obstacles. Participate in races against strong opponents and very powerful cars. Ram your opponents and crush them because in demolition derby you need to win by whatever means necessary. Earn money, unlock new cars and upgrade you engine power, durability, nitro and so on. Get behind the wheel, step on the juice and enjoy these dynamic racing game!', '', 'https://html5.gamemonetize.com/mde2rzu4y35gw7d96xo2wrjojaz1nx99/', 'html5', 800, 500, 1576076683, '1', '0')";
$db[23] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(658, 'gamemonetize-790', 'pixel-combat-multiplayer', 'Pixel Combat Multiplayer', 'https://img.gamemonetize.com/ww0f77mygsqe8vfnllrfanislgtbkklg/512x384.jpg', '0', 7, 0, '0', 'Pixel style action multiplayer fps game,You can fight with friends or other peoples.Try Deathmatch and Team deathmatch.New modern block world in game and pixel style weapons. You can play classmate.Its funny pocket fps block style shooter game.Have Fun ! Features - Skin case system - Quality Graphics - 10 New Weapons - Battle Royale Map Multiplayer Modes Deathmatch and Team Deathmatch World Unique 21 maps with pixel style textures.', '', 'https://html5.gamemonetize.com/ww0f77mygsqe8vfnllrfanislgtbkklg/', 'html5', 960, 650, 1576076683, '1', '1'),
(659, 'gamemonetize-789', 'monster-attack', 'Monster Attack', 'https://img.gamemonetize.com/yexisu2i0wi635ok8y01in4wtouai9lh/512x384.jpg', '0', 7, 0, '0', 'The city is under attack. Use your superhero strength to protect the innocent against the evil monsters. Features • Multiple levels • 3 character skins', '', 'https://html5.gamemonetize.com/yexisu2i0wi635ok8y01in4wtouai9lh/', 'html5', 960, 600, 1576076683, '1', '0'),
(660, 'gamemonetize-788', 'thief-fps-fire-marshal', 'Thief Fps Fire Marshal', 'https://img.gamemonetize.com/lr3vo4rzcqkyhke8e89f06xzop95rzhd/512x384.jpg', '0', 3, 0, '0', 'As a special force, you will receive secret missions to eliminate enemies and terrorist. Sneak into terrorist’s base, find them and zoom lens to aim your enemies! deep breathing …and pull the trigger Scout through immersive environments, engage in rapid-fire combat and build the ultimate super-soldier as you customise their state of the art gear.', '', 'https://html5.gamemonetize.com/lr3vo4rzcqkyhke8e89f06xzop95rzhd/', 'html5', 960, 640, 1576076683, '1', '0'),
(661, 'gamemonetize-787', 'kisan-smart-farmer', 'Kisan Smart Farmer', 'https://img.gamemonetize.com/jkpvl9yxqmv68tdnbeptxm691kbjgwbz/512x384.jpg', '0', 1, 0, '0', 'Welcome to Kisan Smart Farmer game. This game is especially designed for those former’s who are interested in tractor driving and transporting different kinds of cargo towards their farms.', '', 'https://html5.gamemonetize.com/jkpvl9yxqmv68tdnbeptxm691kbjgwbz/', 'html5', 960, 640, 1576076683, '1', '0'),
(662, 'gamemonetize-786', 'amsterdam-truck-garbage-gm', 'Amsterdam Truck Garbage GM', 'https://img.gamemonetize.com/twkgc1wkwkhlnu3q2evqbnun7wx8p9ri/512x384.jpg', '0', 2, 0, '0', 'Are you ready for Simulation of Realistic truck garbage ? Well... You can drive in amsterdam City and colect Garbage from all place of town, hurry to collect garbage and take to the point because you have time also be caeful to not cush to the building and othe vehicle o mission is failed.', '', 'https://html5.gamemonetize.com/twkgc1wkwkhlnu3q2evqbnun7wx8p9ri/', 'html5', 800, 600, 1576076683, '1', '0'),
(663, 'gamemonetize-785', 'city-bus-offroad-driving-sim', 'City Bus Offroad Driving Sim', 'https://img.gamemonetize.com/grzekekzjdpmtsnief2c64a4l3gl93zq/512x384.jpg', '0', 2, 0, '0', 'Experience extreme realistic bus driving in this modern bus racer. Do you have the experience of extreme bus racing with local passengers? Adventure racing madness with this fast bus racer 2019. Enjoy driving local passengers bus on city tracks and highway roads. This bus racing game involves plentiful risks as innocent passengers depends on you. Let go of your bus racing fear in highway speed high roof bus.', '', 'https://html5.gamemonetize.com/grzekekzjdpmtsnief2c64a4l3gl93zq/', 'html5', 800, 600, 1576076683, '1', '0'),
(664, 'gamemonetize-784', 'realistic-sim-car-park-2019', 'Realistic Sim Car Park 2019', 'https://img.gamemonetize.com/2x7ync0fgo32my11z8ndasmoao9gsubu/512x384.jpg', '0', 2, 0, '0', 'Ideal Car Parking Game : Real Car Drive Test : new car driving games 2019 offers ultimate parking experience with multiple cars and Steering Wheel and Button Controls .', '', 'https://html5.gamemonetize.com/2x7ync0fgo32my11z8ndasmoao9gsubu/', 'html5', 800, 600, 1576076683, '1', '0'),
(665, 'gamemonetize-783', 'circle-ninja-2019', 'Circle Ninja 2019', 'https://img.gamemonetize.com/gtgj97lyj3971enyzlw1oif0wfdneaeu/512x384.jpg', '0', 2, 0, '0', 'The mission of the player is help the ninja rescue his girl friend from the evil ninja. To make him moving just tap on screen and drag your finger to make him jump follow the direction. ***You must help him kill all the evil ninja to find the key to open the cage to save the girl.', '', 'https://html5.gamemonetize.com/gtgj97lyj3971enyzlw1oif0wfdneaeu/', 'html5', 800, 600, 1576076683, '1', '0'),
(666, 'gamemonetize-782', 'deadly-dinosaur-hunter', 'Deadly Dinosaur Hunter', 'https://img.gamemonetize.com/01dt74daom2iqztmfkaf2s96ir050pf1/512x384.jpg', '0', 3, 0, '0', 'The dinosaurs escaped the Park. Use your sniper skills to shoot them down in order to prevent the jurassic period from happening. Features: • Multiple levels • Good graphics', '', 'https://html5.gamemonetize.com/01dt74daom2iqztmfkaf2s96ir050pf1/', 'html5', 960, 600, 1576076683, '1', '0'),
(667, 'gamemonetize-781', 'fantasy-fairy-difference', 'Fantasy Fairy Difference', 'https://img.gamemonetize.com/syf1ksrx1x61w6eke7nibfhmh7yns7xl/512x384.jpg', '0', 5, 0, '0', 'Fantasy Fairy Difference is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/syf1ksrx1x61w6eke7nibfhmh7yns7xl/', 'html5', 960, 540, 1576076683, '1', '0'),
(668, 'gamemonetize-780', 'army-vehicles-memory', 'Army Vehicles Memory', 'https://img.gamemonetize.com/luy46p9boslzr7v3mrobc2031kedb0lw/512x384.jpg', '0', 5, 0, '0', 'Army Vehicles Memory is a free online game from genre of memory and military games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/luy46p9boslzr7v3mrobc2031kedb0lw/', 'html5', 960, 540, 1576076683, '1', '0'),
(669, 'gamemonetize-779', 'travelling-kids-memory', 'Travelling Kids Memory', 'https://img.gamemonetize.com/1latx8x37nsv1uljro4dcotozx0rpw5q/512x384.jpg', '0', 5, 0, '0', 'Travelling Kids Memory is a free online game from genre of memory and kids games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/1latx8x37nsv1uljro4dcotozx0rpw5q/', 'html5', 960, 540, 1576076683, '1', '0'),
(670, 'gamemonetize-778', 'outerspace-match-3', 'Outerspace Match 3', 'https://img.gamemonetize.com/cgunaswgo1wugnhkk7fcyp5anlgrsdt5/512x384.jpg', '0', 5, 0, '0', 'Outerspace Match 3 is a interesting addictive match 3 game with a space theme. You can use your free time to enjoy the fun of it. Swap adjacent tiles, make the line of at least three candies of the same color and remove them from the field. Call your friends and enjoy it!', '', 'https://html5.gamemonetize.com/cgunaswgo1wugnhkk7fcyp5anlgrsdt5/', 'html5', 800, 600, 1576076683, '1', '0'),
(671, 'gamemonetize-777', 'autumn-leaves-match-3', 'Autumn Leaves Match 3', 'https://img.gamemonetize.com/ah4kavun78io1fqrywgo4l3neh8gp3vz/512x384.jpg', '0', 5, 0, '0', 'Autumn Leaves Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful autumn style! Enjoy the game!', '', 'https://html5.gamemonetize.com/ah4kavun78io1fqrywgo4l3neh8gp3vz/', 'html5', 800, 600, 1576076683, '1', '0'),
(672, 'gamemonetize-776', 'cat-and-kids-differences', 'Cat And Kids Differences', 'https://img.gamemonetize.com/js347jx6s4x4jclh0m6xgnfyrxtmpaa8/512x384.jpg', '0', 5, 0, '0', 'Now it&#039;s time for wonderful game that&#039;s called Kids And Cat Differences, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/js347jx6s4x4jclh0m6xgnfyrxtmpaa8/', 'html5', 960, 540, 1576076683, '1', '0'),
(673, 'gamemonetize-775', 'ocean-hidden-stars', 'Ocean Hidden Stars', 'https://img.gamemonetize.com/6vspffh3s3anxd2ght0vy2ej8uo58kye/512x384.jpg', '0', 5, 0, '0', 'Ocean Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/6vspffh3s3anxd2ght0vy2ej8uo58kye/', 'html5', 960, 540, 1576076683, '1', '0'),
(674, 'gamemonetize-774', 'cute-unicorn-jigsaw', 'Cute Unicorn Jigsaw', 'https://img.gamemonetize.com/ctrylhmpdckuzvuloskljk9g2i4yk7sw/512x384.jpg', '0', 5, 0, '0', 'Cute Unicorn Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/ctrylhmpdckuzvuloskljk9g2i4yk7sw/', 'html5', 960, 540, 1576076683, '1', '0'),
(675, 'gamemonetize-773', 'mission-to-mars-difference', 'Mission To Mars Difference', 'https://img.gamemonetize.com/yytrjy3gg9c8bsi8tnhfthpydh8510vz/512x384.jpg', '0', 5, 0, '0', 'Halloween Mask Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/yytrjy3gg9c8bsi8tnhfthpydh8510vz/', 'html5', 800, 600, 1576076683, '1', '0'),
(676, 'gamemonetize-772', 'halloween-mask-coloring-book', 'Halloween Mask Coloring Book', 'https://img.gamemonetize.com/dkitij4d1rdr3tu41fdcchmf0g2h0kqe/512x384.jpg', '0', 5, 0, '0', 'Halloween Mask Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/dkitij4d1rdr3tu41fdcchmf0g2h0kqe/', 'html5', 800, 600, 1576076683, '1', '0'),
(677, 'gamemonetize-771', 'pumpkin-parkour', 'pumpkin parkour', 'https://img.gamemonetize.com/rt3k762ig1kehc0agl5tvo4gpcgdqsdh/512x384.jpg', '0', 8, 0, '0', 'jump all platforms and reach the end in this colorful game for android and pc', '', 'https://html5.gamemonetize.com/rt3k762ig1kehc0agl5tvo4gpcgdqsdh/', 'html5', 800, 600, 1576076683, '1', '0'),
(678, 'gamemonetize-770', 'scary-halloween-party', 'Scary Halloween Party', 'https://img.gamemonetize.com/2jiiqoh3fk8rtrkdr2irou423po02xm5/512x384.jpg', '0', 5, 0, '0', 'Scary Halloween Party is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/2jiiqoh3fk8rtrkdr2irou423po02xm5/', 'html5', 800, 600, 1576076683, '1', '0'),
(679, 'gamemonetize-769', 'halloween-blast', 'Halloween Blast', 'https://img.gamemonetize.com/x4elbu2ro2c7i0du50nhvyev82kri8if/512x384.jpg', '0', 5, 0, '0', 'This year you can destroy Halloween. I&#039;m kidding, you can blast Halloween masks in this game. Connect 3 or more Halloween masks and earn points. Earn more points as you can for given time and try to pass all levels. Use mouse to play this game.', '', 'https://html5.gamemonetize.com/x4elbu2ro2c7i0du50nhvyev82kri8if/', 'html5', 720, 1280, 1576076683, '1', '0'),
(680, 'gamemonetize-768', 'halloween-hidden-pumpkins', 'Halloween Hidden Pumpkins', 'https://img.gamemonetize.com/xvc6md0ot8yrhos6x84spw8rtm0s1s0y/512x384.jpg', '0', 5, 0, '0', 'In this game Halloween Hidden Pumpkins there are pictures that are mysterious and scary. Find out the hidden pumpkins in the specified images. Each level has 10 hidden pumpkins. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/xvc6md0ot8yrhos6x84spw8rtm0s1s0y/', 'html5', 960, 540, 1576076683, '1', '0'),
(681, 'gamemonetize-767', 'princess-family-halloween-costume', 'Princess Family Halloween Costume', 'https://img.gamemonetize.com/ewlk3jk7mj60nbcztdp509p39oyzit2x/512x384.jpg', '0', 1, 0, '0', 'Big family is great! Princess Jasmine and Princess Elsa decided to make costumes for the whole family in a single theme. Help the girls choose clothes for each family member - who will they be this Halloween? You decide! Maybe it will be the brave guardians of the galaxy or funny animated toys? Or maybe you want to turn the princesses into characters of a famous series or cartoon? Have fun!', '', 'https://html5.gamemonetize.com/ewlk3jk7mj60nbcztdp509p39oyzit2x/', 'html5', 800, 600, 1576076683, '1', '0'),
(682, 'gamemonetize-766', 'listen-music-jigsaw', 'Listen Music Jigsaw', 'https://img.gamemonetize.com/he8xp8gaao8svx98tynbllr2b1qualgr/512x384.jpg', '0', 5, 0, '0', 'Listen Music Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/he8xp8gaao8svx98tynbllr2b1qualgr/', 'html5', 960, 540, 1576076683, '1', '0'),
(683, 'gamemonetize-765', 'crush-to-party-halloween-edition', 'Crush to Party: Halloween Edition', 'https://img.gamemonetize.com/gcx7tybk6gvjm1pg5pk69acubddg532l/512x384.jpg', '0', 5, 0, '0', 'Crush and match the monsters till you make enough points to decorate your Halloween Party dream. Here you will need to be very skilled and fast, one time you need to crush the head of monsters and the other time you will need to match them. Be fast, and earn more points! After that, use your points to buy different decorations for the party.', '', 'https://html5.gamemonetize.com/gcx7tybk6gvjm1pg5pk69acubddg532l/', 'html5', 1260, 720, 1576076683, '1', '0'),
(684, 'gamemonetize-764', 'mad-truck-challenge-special', 'Mad Truck Challenge Special', 'https://img.gamemonetize.com/mlg18x7fbslpg4i3yoxbykpgq90lisr4/512x384.jpg', '0', 3, 0, '0', 'Gear up for roaring, action-packed race battles against the meanest Monster Trucks you’ve ever seen! They’re waiting for you at the Mad Truck Challenge starting line. Strap up for a relentless racing simulator that will have your adrenaline pumping. Select your truck, armed with rockets, and race against the toughest off-road drivers on the planet. Crush and blast your way to victory while you perform extreme stunts and make your opponents bite the dust to earn the coveted MTC trophy.', '', 'https://html5.gamemonetize.com/mlg18x7fbslpg4i3yoxbykpgq90lisr4/', 'html5', 800, 500, 1576076683, '1', '1'),
(685, 'gamemonetize-763', 'mad-day-2-special', 'Mad Day 2 Special', 'https://img.gamemonetize.com/pl0ny22eyt8lt0zseofcxkc7th9gtlej/512x384.jpg', '0', 2, 0, '0', 'Ride, shoot, jump and smash your way to victory in this addictive runner. Team up with ex-Marine Bob to battle evil aliens who have invaded the planet. To make things even worse, they’ve kidnapped his beloved pet octopus. Needless to say that Bob is on a mission to make this an encounter that the aliens won’t soon forget!', '', 'https://html5.gamemonetize.com/pl0ny22eyt8lt0zseofcxkc7th9gtlej/', 'html5', 800, 500, 1576076683, '1', '1'),
(686, 'gamemonetize-762', 'mad-day-special', 'Mad Day Special', 'https://img.gamemonetize.com/x1pcf3eqnaqhacegno3gkgidfsbz7us4/512x384.jpg', '0', 2, 0, '0', 'Battle the oncoming Alien Invasion of Earth in this epic racer to rescue your beloved pet Octopus Fluffy and escape. Mad Day is a combination of an awesome racing and alien shooting game. Upgrade your Car, Guns, Armor, Clothing and more to beat the bad guys. Take on the aliens lasers and blasters with your own trucks rocket launcher as you climb hills and smash through walls. Then start running on foot with your shotgun, killing and smashing aliens.', '', 'https://html5.gamemonetize.com/x1pcf3eqnaqhacegno3gkgidfsbz7us4/', 'html5', 800, 500, 1576076683, '1', '1'),
(687, 'gamemonetize-761', 'raft-royale', 'Raft Royale', 'https://img.gamemonetize.com/chelhusdfimisgjwk1rjllvct64erpk4/512x384.jpg', '0', 7, 0, '0', 'Build your raft as you try to destroy your enemies rafts. Keep building so that you can top the leaderboard on your server.', '', 'https://html5.gamemonetize.com/chelhusdfimisgjwk1rjllvct64erpk4/', 'html5', 800, 600, 1576076683, '1', '0'),
(688, 'gamemonetize-760', 'killer-io', 'Killer.io', 'https://img.gamemonetize.com/niseadlbd8923kfntkyjjy1ftloz4wss/512x384.jpg', '0', 7, 0, '0', 'Kill and hide bodies in this fun online murder game. Try to kill as many people at the Halloween party as possible. Try not to get caught!', '', 'https://html5.gamemonetize.com/niseadlbd8923kfntkyjjy1ftloz4wss/', 'html5', 800, 600, 1576076683, '1', '0'),
(689, 'gamemonetize-759', 'princess-sweet-candy-cosplay', 'Princess Sweet Candy Cosplay', 'https://img.gamemonetize.com/8fn2gk5gtfmuwirac61no4kbpzxfkk9t/512x384.jpg', '0', 1, 0, '0', 'Princess Elsa, Jasmine and Ariel decided to make an incredible Comic-Con. Girls are crazy about sweets and sweets, so they decided to choose vivid images for themselves in the style of their favorite treats. Princess dresses are strewn with candy, sweets, donuts and cotton candy. Help the girls create a unique costume for the Sweet Candy Comic-Con. Do not forget to use candies for accessories, necklaces and hats. Bright multi-colored hairstyles will also help complement the image. And, now, our princesses are already shining in their new candy dresses!', '', 'https://html5.gamemonetize.com/8fn2gk5gtfmuwirac61no4kbpzxfkk9t/', 'html5', 800, 600, 1576076683, '1', '0'),
(690, 'gamemonetize-758', 'pixel-car-crash-demolition-v1', 'Pixel Car Crash Demolition v1', 'https://img.gamemonetize.com/irefe37prgf4w2qn5mbsfwc0mmadeczx/512x384.jpg', '0', 2, 0, '0', 'Are you ready for Pixel Car Cash Demolition v1 ? Join in 10 hard level where you have possibility to destroy pixel car . Crash into them and gain point to unlock cool car to play.Enjoy !', '', 'https://html5.gamemonetize.com/irefe37prgf4w2qn5mbsfwc0mmadeczx/', 'html5', 800, 600, 1576076683, '1', '0'),
(691, 'gamemonetize-757', 'school-match-3', 'School Match 3', 'https://img.gamemonetize.com/eoa1zux624v8a94svbhubhrbsihh0voe/512x384.jpg', '0', 2, 0, '0', 'Cool match 3 game by freepuzzlesgames. Enjoy this fun game.', '', 'https://html5.gamemonetize.com/eoa1zux624v8a94svbhubhrbsihh0voe/', 'html5', 800, 600, 1576076683, '1', '0'),
(692, 'gamemonetize-756', 'candy-burst', 'Candy Burst', 'https://img.gamemonetize.com/dz6w9uf68hujsfh3ecxmbrirhlv5i28w/512x384.jpg', '0', 5, 0, '0', 'Candy Burst features: - multiple levels - multiple skins - fun one touch gameplay', '', 'https://html5.gamemonetize.com/dz6w9uf68hujsfh3ecxmbrirhlv5i28w/', 'html5', 540, 720, 1576076683, '1', '0'),
(693, 'gamemonetize-755', 'falling-balls', 'Falling Balls', 'https://img.gamemonetize.com/cgrd00561riir8aem2xmw92fsrbbroz3/512x384.jpg', '0', 5, 0, '0', 'Falling Balls features: - multiple levels - fun gameplay', '', 'https://html5.gamemonetize.com/cgrd00561riir8aem2xmw92fsrbbroz3/', 'html5', 480, 768, 1576076683, '1', '0'),
(694, 'gamemonetize-754', 'peppa-pig-hidden-stars', 'Peppa Pig Hidden Stars', 'https://img.gamemonetize.com/ew6ea9x21c5eo5spuwfvbpyql91q5o3k/512x384.jpg', '0', 1, 0, '0', 'Peppa Pig Hidden Stars is an online game that you can play for free. Are you the fan of Peppa Pig? Here is a game Peppa Pig Hidden Stars. Your task is to find all the hidden stars in the five images about Peppa Pig. The game is without time limitation. Enjoy the game.', '', 'https://html5.gamemonetize.com/ew6ea9x21c5eo5spuwfvbpyql91q5o3k/', 'html5', 640, 480, 1576076683, '1', '0'),
(695, 'gamemonetize-753', 'jet-ski-racer', 'Jet Ski Racer', 'https://img.gamemonetize.com/kynwv332ntbi0845usogkwy2j3xko9w9/512x384.jpg', '0', 2, 0, '0', 'Features • Multiple boat and character skins • Multiple game modes • Upgrades', '', 'https://html5.gamemonetize.com/kynwv332ntbi0845usogkwy2j3xko9w9/', 'html5', 960, 600, 1576076683, '1', '0'),
(696, 'gamemonetize-752', 'cute-animals-coloring-book', 'Cute Animals Coloring Book', 'https://img.gamemonetize.com/7y43u1f14rn75ugyy6qwjphpthngcrpj/512x384.jpg', '0', 1, 0, '0', 'Welcome, young artist! Show everyone your talents. Rather color these lovely animals, worthy to become pets at the princess. Choose cute shades and experiment. Take a screenshot and share the result with your friends!', '', 'https://html5.gamemonetize.com/7y43u1f14rn75ugyy6qwjphpthngcrpj/', 'html5', 800, 600, 1576076683, '1', '0'),
(697, 'gamemonetize-751', 'santa-claus-funny-time', 'Santa Claus Funny Time', 'https://img.gamemonetize.com/tfth5lmkqw4ccroc9exlx0mqke4cbnw5/512x384.jpg', '0', 4, 0, '0', 'Santa Claus Funny Time is fun html5 game suitable for all ages. Kids will love this game and our lovley Santa Claus as well. Click around, have some fun and enjoy playing. Winter is coming and Merry Christmas to you all.', '', 'https://html5.gamemonetize.com/tfth5lmkqw4ccroc9exlx0mqke4cbnw5/', 'html5', 640, 360, 1576076683, '1', '0'),
(698, 'gamemonetize-750', 'fz-unlock-blox', 'FZ Unlock Blox', 'https://img.gamemonetize.com/70t1zsayvayms2orp24v3vrbzf6kjy8r/512x384.jpg', '0', 5, 0, '0', 'FZ Unlock Blox is a fun and classic addictive puzzle game. The goal is to unblock the yellow block of the board. Interesting gameplay! Very beautifull graphics! Funny music! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/70t1zsayvayms2orp24v3vrbzf6kjy8r/', 'html5', 800, 600, 1576076683, '1', '0'),
(699, 'gamemonetize-749', 'halloween-block-collapse-delux', 'Halloween Block Collapse Delux', 'https://img.gamemonetize.com/3xqq9j0yy2ignu818fnyvcqoaqpqv4qz/512x384.jpg', '0', 5, 0, '0', 'Collapse halloween blocks by connecting 2 or more similar blocks. Make large chains to get power-ups. Collapse 7 blocks or more to get a bomb. More points are awarded as larger connections are made.', '', 'https://html5.gamemonetize.com/3xqq9j0yy2ignu818fnyvcqoaqpqv4qz/', 'html5', 640, 960, 1576076683, '1', '0'),
(700, 'gamemonetize-748', 'cute-animal-memory', 'Cute Animal Memory', 'https://img.gamemonetize.com/aw94jse9ez8f84uhufz6th9e0rv6p82z/512x384.jpg', '0', 5, 0, '0', 'Cute Animal Memory is a free online game from genre of memory and animal games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/aw94jse9ez8f84uhufz6th9e0rv6p82z/', 'html5', 960, 540, 1576076683, '1', '0'),
(701, 'gamemonetize-747', 'cute-dogs-jigsaw', 'Cute Dogs Jigsaw', 'https://img.gamemonetize.com/9vhoxmdt69o70vh0sr8y9xlhakbn153b/512x384.jpg', '0', 5, 0, '0', 'Cute Dogs Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/9vhoxmdt69o70vh0sr8y9xlhakbn153b/', 'html5', 960, 540, 1576076683, '1', '0'),
(702, 'gamemonetize-746', 'adventure-time-differences', 'Adventure Time Differences', 'https://img.gamemonetize.com/hvqqesbkmynm3tb7scdn9cw51lsfal0r/512x384.jpg', '0', 5, 0, '0', 'Now it&#039;s time for wonderful game that&#039;s called Adventure Time Differences, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/hvqqesbkmynm3tb7scdn9cw51lsfal0r/', 'html5', 960, 540, 1576076683, '1', '0'),
(703, 'gamemonetize-745', 'food-truck-differences', 'Food Truck Differences', 'https://img.gamemonetize.com/bo3xo411ky1ta6p5jctuzvjatnmy08qc/512x384.jpg', '0', 5, 0, '0', 'In this game you need to find seven differences in each picture. There is ten images with food trucks with some differences in it. Try to find all differences for given time. You have time of 2 minutes in each level. Pass all 10 levels and have good fun.', '', 'https://html5.gamemonetize.com/bo3xo411ky1ta6p5jctuzvjatnmy08qc/', 'html5', 1280, 720, 1576076683, '1', '0'),
(704, 'gamemonetize-744', 'temple-runner', 'Temple Runner', 'https://img.gamemonetize.com/9pup3x89l9oozkevu3w4rslg0x6tt9w3/512x384.jpg', '0', 5, 1, '0', 'You&#039;re an adventurous explorer, running through ruined temples. Collecting gold to get cool outfits. Avoiding obstacles along the way, and get help from useful power-ups. Enjoy with new best games Every Week in Kiz10', '', 'https://html5.gamemonetize.com/9pup3x89l9oozkevu3w4rslg0x6tt9w3/', 'html5', 527, 700, 1576076683, '1', '0'),
(705, 'gamemonetize-743', 'ladybug-hidden-stars', 'LadyBug Hidden Stars', 'https://img.gamemonetize.com/vme4jncm4z1qc5njlz52sg2zjxkb6r22/512x384.jpg', '0', 1, 0, '0', 'Ladybug Hidden Stars Html5 is an online game that you can play for free. Can you find the hidden stars on the images of Ladybug? LadyBug Hidden Stars HTML5 is fun hidden objects html5 game.There are total of five group of images and the game is without time limitation. Have fun!', '', 'https://html5.gamemonetize.com/vme4jncm4z1qc5njlz52sg2zjxkb6r22/', 'html5', 400, 600, 1576076683, '1', '0'),
(706, 'gamemonetize-742', 'lara-special-ops', 'Lara Special Ops', 'https://img.gamemonetize.com/lu7coii59ofuke8jlyt00x4ibd9rr6fc/512x384.jpg', '0', 3, 0, '0', 'Features: • 20 awesome levels • Multiple weapon to use', '', 'https://html5.gamemonetize.com/lu7coii59ofuke8jlyt00x4ibd9rr6fc/', 'html5', 960, 600, 1576076683, '1', '0'),
(707, 'gamemonetize-741', 'swing-man', 'Swing Man', 'https://img.gamemonetize.com/xfbu7dqjrh59mkw3axcrby0wnmkm7885/512x384.jpg', '0', 4, 0, '0', 'Be the best and swing to the victory! Try to hang on every ropes and swing to the finish line. Beat all your opponents in this crazy race! Open tons of new skins, ropes, costumes, dancing animation. Use mouse to play.', '', 'https://html5.gamemonetize.com/xfbu7dqjrh59mkw3axcrby0wnmkm7885/', 'html5', 900, 600, 1576076683, '1', '0'),
(708, 'gamemonetize-740', 'supercars-parking', 'Supercars Parking', 'https://img.gamemonetize.com/b239893hm7cuen1v16zq468r06n8og80/512x384.jpg', '0', 2, 0, '0', 'Supercars Parking is a driving-skills game. Drive your Lamborghini and find parking space. You need to pick up 3 stars to see where is your place. Check your driving parking skills in front, back parking or parallel parking on the 10 differents polygon. Good luck!', '', 'https://html5.gamemonetize.com/b239893hm7cuen1v16zq468r06n8og80/', 'html5', 854, 480, 1576076683, '1', '0'),
(709, 'gamemonetize-739', 'knife-hit-3d', 'Knife Hit 3D', 'https://img.gamemonetize.com/7dyqgannomlg9qxzaccl2hxmh8u5v9f3/512x384.jpg', '0', 4, 0, '0', 'Knife Hit 3D is a game where you use knives to break the woods. Game is simple, just tap to throw knife, once enough, the wood is break and you can procced to next level. Just evade others knives to break the wood. And you’ll see yourself a master.', '', 'https://html5.gamemonetize.com/7dyqgannomlg9qxzaccl2hxmh8u5v9f3/', 'html5', 480, 600, 1576076683, '1', '0'),
(710, 'gamemonetize-738', 'stack-ball-3d', 'Stack Ball 3D', 'https://img.gamemonetize.com/69zplt4mr0tgfwyskqe3pw085tlk2038/512x384.jpg', '0', 4, 0, '0', 'Stack Ball Fall features: – Crazy fast speed – Fun gameplay – Bright vibrant graphics – Simple and easy to play', '', 'https://html5.gamemonetize.com/69zplt4mr0tgfwyskqe3pw085tlk2038/', 'html5', 540, 720, 1576076683, '1', '0'),
(711, 'gamemonetize-737', 'arcade-drift', 'Arcade Drift', 'https://img.gamemonetize.com/z177dg23eabh9otwx6cyydy7h97c63z6/512x384.jpg', '0', 2, 0, '0', 'Arcade Drift features: - multiple cars to play - 2 environments - fun drift physics', '', 'https://html5.gamemonetize.com/z177dg23eabh9otwx6cyydy7h97c63z6/', 'html5', 960, 540, 1576076683, '1', '0'),
(712, 'gamemonetize-736', 'back-to-school-memory', 'Back To School Memory', 'https://img.gamemonetize.com/7prh9t1uwbpytkaovox3y4y773r6eyym/512x384.jpg', '0', 5, 0, '0', 'Back To School Memory is a free online game from genre of memory and kids games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/7prh9t1uwbpytkaovox3y4y773r6eyym/', 'html5', 960, 540, 1576076683, '1', '0'),
(713, 'gamemonetize-735', 'fun-monsters-jigsaw', 'Fun Monsters Jigsaw', 'https://img.gamemonetize.com/nyn4r21qa9du3uyzfe8fqr6cr97bvjqj/512x384.jpg', '0', 5, 0, '0', 'Fun Monsters Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/nyn4r21qa9du3uyzfe8fqr6cr97bvjqj/', 'html5', 960, 540, 1576076683, '1', '0'),
(714, 'gamemonetize-734', 'wild-wild-west-memory', 'Wild Wild West Memory', 'https://img.gamemonetize.com/rnj08hic18yxu14fw6mfy5f9080ey78p/512x384.jpg', '0', 5, 0, '0', 'Wild Wild West Memory is a free online game from genre of memory and wild west games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/rnj08hic18yxu14fw6mfy5f9080ey78p/', 'html5', 960, 540, 1576076683, '1', '0'),
(715, 'gamemonetize-733', 'emergency-trucks-match-3', 'Emergency Trucks Match 3', 'https://img.gamemonetize.com/i3qlx7v8tbp5ca7xdxevj6g0q7jg3mbl/512x384.jpg', '0', 5, 0, '0', 'This is Match 3 game with trucks. There is some of emergency trucks and you need to match it with 3 or more in the row to get scores.You can pause the game and to do your move without rush. If you play good your time will increase. start to play this matching truck game and enjoy.', '', 'https://html5.gamemonetize.com/i3qlx7v8tbp5ca7xdxevj6g0q7jg3mbl/', 'html5', 1280, 720, 1576076683, '1', '0'),
(716, 'gamemonetize-732', 'puzzles-so-different-princess', 'Puzzles - So Different Princess', 'https://img.gamemonetize.com/chektlfxr3t93t7n9d36fs87541om9ey/512x384.jpg', '0', 5, 0, '0', 'Princesses are so different, funny and modest, thoughtful and romantic. Collect all puzzles and find out what princesses Elsa, Tiana, Jasmine, Anna, Ariel, Harley Quinn and Rapunzel can be. Set your record and compete with your friends!', '', 'https://html5.gamemonetize.com/chektlfxr3t93t7n9d36fs87541om9ey/', 'html5', 800, 600, 1576076683, '1', '0'),
(717, 'gamemonetize-731', 'halloween-night-jigsaw', 'Halloween Night Jigsaw', 'https://img.gamemonetize.com/0fr8pr7845dnq875jd6jaotcncp8julk/512x384.jpg', '0', 5, 0, '0', 'In this game you can solve images with Halloween nights. You can play with twelve images with Halloween and to have fun in Halloween Night. The music is interesting and little bit scary, so the playing of this game is very realistic and fun. Use mouse to drag the pieces into right position to get the image, or use your finger if you play on your cell phone.', '', 'https://html5.gamemonetize.com/0fr8pr7845dnq875jd6jaotcncp8julk/', 'html5', 1280, 720, 1576076683, '1', '0'),
(718, 'gamemonetize-730', 'basketball-tournament-3d', 'Basketball Tournament 3D', 'https://img.gamemonetize.com/eyl4eee9dleu3foav9j1lqj4xv4k4czj/512x384.jpg', '0', 1, 0, '0', 'Follow our path of a brand new Basketball Tournament 3D game to pursue your dream! Join the free throw competition, practice your skills in six different modes, you will never feel bored in our basketball games! Rules in our basketball games are different. As a free shot game, you get 2 points for throwing basketball into the loop, and 3 points by creating a clean shot, disregard the distance. Receive fire ball bonus by scoring continuously, and use backboard to score to get backboard bonus!', '', 'https://html5.gamemonetize.com/eyl4eee9dleu3foav9j1lqj4xv4k4czj/', 'html5', 480, 600, 1576076683, '1', '0'),
(719, 'gamemonetize-729', 'helix-jump-halloween', 'Helix Jump Halloween', 'https://img.gamemonetize.com/phni4n8ltb8qyk6isfpoorp4k9mz1cpr/512x384.jpg', '0', 4, 0, '0', 'Are you loking for a jump halloween ball game through the helix halloween tower? Let&#039;s play halloween Helix Jump Halloween game of the latest trends on the market. We know that halloween Helix Jump is the best source to give you amazing emotions.', '', 'https://html5.gamemonetize.com/phni4n8ltb8qyk6isfpoorp4k9mz1cpr/', 'html5', 480, 600, 1576076683, '1', '0'),
(720, 'gamemonetize-728', 'elsa-wedding-hairdresser-for-princesses', 'Elsa - Wedding Hairdresser For Princesses', 'https://img.gamemonetize.com/9q1y9r5in3o9nl2qqwyt08tudxkw6o8f/512x384.jpg', '0', 1, 0, '0', 'Three BBF - Ariel, Jasmine and Rapunzel marry the princes. Each of the princesses received as a gift a wonderful engagement ring. The key to a successful wedding is a beautiful looking beauty bride. Go to Princess Elsa&#039;s hairstyles with your friends. Help her create a modern, stylish wedding hairstyle. Decorate brides hair with precious hairpins and flowers. Choose for each princess a luxurious white dress and a sparkling tiara or a wreath of fresh flowers. Enjoy playing this wonderful game «Elsa - Wedding Hairdresser For Princesses».', '', 'https://html5.gamemonetize.com/9q1y9r5in3o9nl2qqwyt08tudxkw6o8f/', 'html5', 800, 600, 1576076683, '1', '0'),
(721, 'gamemonetize-727', 'xtrem-no-brakes-2019', 'Xtrem No Brakes 2019', 'https://img.gamemonetize.com/bss8qsotsgskcjh44bwbos9865lf4cnf/512x384.jpg', '0', 1, 0, '0', 'Your objective is to drive a cube by rotating the world to the right or the left and avoid obstacles.', '', 'https://html5.gamemonetize.com/bss8qsotsgskcjh44bwbos9865lf4cnf/', 'html5', 800, 600, 1576076683, '1', '0'),
(722, 'gamemonetize-726', 'galaxian', 'Galaxian', 'https://img.gamemonetize.com/b1ypcunpy4nujda7utt3kaekpzwdogzz/512x384.jpg', '0', 1, 0, '0', 'Galaxian retro game, classic arcade space shooter game.', '', 'https://html5.gamemonetize.com/b1ypcunpy4nujda7utt3kaekpzwdogzz/', 'html5', 800, 600, 1576076683, '1', '0'),
(723, 'gamemonetize-725', 'kong-hero-2019', 'Kong Hero 2019', 'https://img.gamemonetize.com/dvccx4u62rydm0f95zmg4lqhl3el8sjl/512x384.jpg', '0', 1, 0, '0', 'Help Kong Hero collect as many coins as possible but watch out for all the dangers. Try and collect as much fruit as you can along the way', '', 'https://html5.gamemonetize.com/dvccx4u62rydm0f95zmg4lqhl3el8sjl/', 'html5', 800, 600, 1576076683, '1', '0'),
(724, 'gamemonetize-724', 'endless-submarine-adventure-2019', 'Endless Submarine Adventure 2019', 'https://img.gamemonetize.com/q58qqfd2k1pwmk16lhe25ck296aaale0/512x384.jpg', '0', 1, 0, '0', 'Control the submarine go as far as you can. Use rocket, bullet and the power up items to survive longer.', '', 'https://html5.gamemonetize.com/q58qqfd2k1pwmk16lhe25ck296aaale0/', 'html5', 800, 600, 1576076683, '1', '0'),
(725, 'gamemonetize-723', 'endless-boat-float-2019', 'Endless Boat Float 2019', 'https://img.gamemonetize.com/k61sj8pzo0mnvqz26clwbl83lvf5hrx1/512x384.jpg', '0', 1, 0, '0', 'Get the best score and buy new boat by not crash .', '', 'https://html5.gamemonetize.com/k61sj8pzo0mnvqz26clwbl83lvf5hrx1/', 'html5', 800, 600, 1576076683, '1', '0'),
(726, 'gamemonetize-722', 'bugs-bang-2019', 'Bugs Bang 2019', 'https://img.gamemonetize.com/9gi5hvc7dlh2mzfqq5lbli9jga087ltg/512x384.jpg', '0', 1, 0, '0', 'Tap and drag your finger to hit and smash the bugs - be fast to achieve a high score! Use boosters for the ultimate challenge and even more fun. Created by bestcrazygames.com', '', 'https://html5.gamemonetize.com/9gi5hvc7dlh2mzfqq5lbli9jga087ltg/', 'html5', 800, 600, 1576076683, '1', '0'),
(727, 'gamemonetize-721', 'fz-steam-trucker', 'FZ Steam Trucker', 'https://img.gamemonetize.com/1o8jedztdtvc8yjtget9141gnui0ln5m/512x384.jpg', '0', 1, 0, '0', 'FZ Steam Trucker – jump behind the wheel of this steampunk big rig and see if you can get its cargo to the end of the track. Can you reach the garage without spilling anything?', '', 'https://html5.gamemonetize.com/1o8jedztdtvc8yjtget9141gnui0ln5m/', 'html5', 800, 600, 1576076683, '1', '0'),
(728, 'gamemonetize-720', 'soldier-way', 'Soldier Way', 'https://img.gamemonetize.com/byayvcnqee15593yc4got637nnueptq1/512x384.jpg', '0', 3, 0, '0', 'Soldier way is a great HTML5 platform game. Control soldier in the jungle collect diamonds and medals, unlock the door and finished the levels. 6 levels, 4 differents enemies, use arrows for move, space for shoot or touch controlers for mobile devices. Enjoy!', '', 'https://html5.gamemonetize.com/byayvcnqee15593yc4got637nnueptq1/', 'html5', 1136, 640, 1576076683, '1', '0'),
(729, 'gamemonetize-719', 'dot-color-switch', 'Dot Color Switch', 'https://img.gamemonetize.com/q5ggngdqjh64ymgl4oqe71fakqvv5lrv/512x384.jpg', '0', 4, 0, '0', 'Switch colors to match the color of the moving point. Simple but very addicted. What high score can you reach? Play now!', '', 'https://html5.gamemonetize.com/q5ggngdqjh64ymgl4oqe71fakqvv5lrv/', 'html5', 540, 960, 1576076683, '1', '0'),
(730, 'gamemonetize-718', 'rob-runner', 'Rob Runner', 'https://img.gamemonetize.com/k7z8gkqys5bdoxmmoovsmnsn1xdxnab7/512x384.jpg', '0', 4, 0, '0', 'Rob is without money. Run on the space stage, jump over the obstacle and pick up diamonds. Make a best resault and beat your friends. Good luck!', '', 'https://html5.gamemonetize.com/k7z8gkqys5bdoxmmoovsmnsn1xdxnab7/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(731, 'gamemonetize-717', 'where-s-my-golf', 'Where&#039;s My Golf?', 'https://img.gamemonetize.com/l76hyvu2wrhpuec9hh7y3luy9uhxzatl/512x384.jpg', '0', 8, 0, '0', 'Play golf by drawing. Lead the golf ball into the hole. Collect coins to unlock new golf balls. 40 levels to go. Play now!', '', 'https://html5.gamemonetize.com/l76hyvu2wrhpuec9hh7y3luy9uhxzatl/', 'html5', 960, 540, 1576076683, '1', '0'),
(732, 'gamemonetize-716', 'halloween-night', 'Halloween Night', 'https://img.gamemonetize.com/1rhgqjc307cuwcsq7xmsga6hh3wukf5l/512x384.jpg', '0', 8, 0, '0', 'Are you looking for some fun on the occasion of Halloween? Here we bring an awesome game on festive season halloween. Halloween Night comes up with a funny scary theme. In the game, there is a cute girl dressed up as a witch sitting on her magical broom. Her broom contains so many amazing powers that help her to hit scary pumpkins and clear his way. You need to tap to go high and release to go down. Do not collide with roof, bombs, and ground.', '', 'https://html5.gamemonetize.com/1rhgqjc307cuwcsq7xmsga6hh3wukf5l/', 'html5', 640, 1136, 1576076683, '1', '0'),
(733, 'gamemonetize-715', 'army-frontline-mission', 'Army Frontline Mission', 'https://img.gamemonetize.com/mqp7yz57wplwgsegeiqv9di6mmu793iw/512x384.jpg', '0', 3, 0, '0', 'Features • Multiple challenging missions • Multiple weapons', '', 'https://html5.gamemonetize.com/mqp7yz57wplwgsegeiqv9di6mmu793iw/', 'html5', 960, 600, 1576076683, '1', '0'),
(734, 'gamemonetize-714', 'infinity-ops-fps', 'Infinity Ops FPS', 'https://img.gamemonetize.com/z5lb9f22gwpcsu64v54bwjzz1r3rvycu/512x384.jpg', '0', 3, 0, '0', 'Features • Multiple missions • Multiple weapons', '', 'https://html5.gamemonetize.com/z5lb9f22gwpcsu64v54bwjzz1r3rvycu/', 'html5', 960, 600, 1576076683, '1', '0'),
(735, 'gamemonetize-713', 'deathmatch-combat-io', 'Deathmatch Combat io', 'https://img.gamemonetize.com/ipccjmi2fwd0ac2d5eqgg9dafegoxbcg/512x384.jpg', '0', 7, 0, '0', 'Features - Fast-paced 3D first-person shooter - Game modes: zombie survival, arcade, deathmatch, team deathmatch, battle royale, and doom royale - Option to add bots in the room - Five maps - Power-ups: regeneration, damage, unlimited dash, and shield - 11 weapons - A level system to access weapon skins - Armor and mask customization - Long distance markers in deathmatch and team deathmatch mode', '', 'https://html5.gamemonetize.com/ipccjmi2fwd0ac2d5eqgg9dafegoxbcg/', 'html5', 960, 600, 1576076683, '1', '0'),
(736, 'gamemonetize-712', 'racoon-headball', 'Racoon Headball', 'https://img.gamemonetize.com/4pffpy5wy4ms6yuf8mzmdsvqoyxzczgg/512x384.jpg', '0', 8, 0, '0', 'Racoon Headball is a sport game. Its a sunny day on beach. Let’s play the beach headball with racoons.Beat your opponent, and make first 11 points. Good luck!', '', 'https://html5.gamemonetize.com/4pffpy5wy4ms6yuf8mzmdsvqoyxzczgg/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(737, 'gamemonetize-711', 'motocross', 'Motocross', 'https://img.gamemonetize.com/53mmz6spw36dfaxmzninfs2vv8oo7qac/512x384.jpg', '0', 8, 0, '0', 'Drive your bike on the snow. Use yours skills to finished 8 levels. Very important to use jump on some palces. Good luck.', '', 'https://html5.gamemonetize.com/53mmz6spw36dfaxmzninfs2vv8oo7qac/', 'html5', 1066, 600, 1576076683, '1', '0'),
(738, 'gamemonetize-710', 'road-to-glory', 'Road to Glory', 'https://img.gamemonetize.com/z2eugxcaa0bkz5kfid0v3b0o99q3oz1n/512x384.jpg', '0', 8, 0, '0', 'Road to Glory is a billiard like soccer game. You’ll have to set the angle and power to shoot the ball inside the goal. You’ll better be fast or else the AI will beat you to it!You can win the World Cup!', '', 'https://html5.gamemonetize.com/z2eugxcaa0bkz5kfid0v3b0o99q3oz1n/', 'html5', 854, 480, 1576076683, '1', '0'),
(739, 'gamemonetize-709', 'car-wash-salon', 'Car Wash Salon', 'https://img.gamemonetize.com/r9agiyj3ltcnj3zb2mk1xojzopybi6f9/512x384.jpg', '0', 1, 0, '0', 'Features • Good graphics • Kids game • Multiple cars to wash', '', 'https://html5.gamemonetize.com/r9agiyj3ltcnj3zb2mk1xojzopybi6f9/', 'html5', 960, 600, 1576076683, '1', '0'),
(740, 'gamemonetize-708', 'scary-halloween-match-3', 'Scary Halloween Match 3', 'https://img.gamemonetize.com/6wjc1da2qg7tow36ysfxevn09sfo4xcb/512x384.jpg', '0', 5, 0, '0', 'Scary Halloween Match 3 is a free online game three in a row, in which you have to put the blocks of the same scary halloween pictures in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful colorful style! Have fun!', '', 'https://html5.gamemonetize.com/6wjc1da2qg7tow36ysfxevn09sfo4xcb/', 'html5', 960, 540, 1576076683, '1', '0'),
(741, 'gamemonetize-707', 'fun-zoo-animals-jigsaw', 'Fun Zoo Animals Jigsaw', 'https://img.gamemonetize.com/m6olsdyh8mn6mutsk8sy44bvch6xi7o5/512x384.jpg', '0', 5, 0, '0', 'Fun Zoo Animals Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/m6olsdyh8mn6mutsk8sy44bvch6xi7o5/', 'html5', 960, 540, 1576076683, '1', '0'),
(742, 'gamemonetize-706', 'dinosaur-bone-digging', 'Dinosaur Bone Digging', 'https://img.gamemonetize.com/v0qb86e092fugx3xfx6bju72cljd8fh3/512x384.jpg', '0', 1, 0, '0', 'Features • Multiple levels and activities • Good graphics', '', 'https://html5.gamemonetize.com/v0qb86e092fugx3xfx6bju72cljd8fh3/', 'html5', 960, 600, 1576076683, '1', '0'),
(743, 'gamemonetize-705', 'mandala-coloring', 'Mandala Coloring', 'https://img.gamemonetize.com/xhi2u991z2z41zc0omqj6t6tynipm1ej/512x384.jpg', '0', 1, 0, '0', 'Features: - multiple game modes', '', 'https://html5.gamemonetize.com/xhi2u991z2z41zc0omqj6t6tynipm1ej/', 'html5', 540, 720, 1576076683, '1', '0'),
(744, 'gamemonetize-704', 'racing-beast-puzzle', 'Racing Beast Puzzle', 'https://img.gamemonetize.com/w6h85z2dskafoj74v8z1aepfww5ffq2c/512x384.jpg', '0', 1, 0, '0', 'Racing Beast Puzzle is fun online game suitable for all ages. Car enthusiast will love this game. Choose one of the images and try to get all small pieces on the original spot to get a whole image. No time, no rush. Have fun playing.', '', 'https://html5.gamemonetize.com/w6h85z2dskafoj74v8z1aepfww5ffq2c/', 'html5', 854, 480, 1576076683, '1', '0'),
(745, 'gamemonetize-703', 'cute-bat-coloring-book', 'Cute Bat Coloring Book', 'https://img.gamemonetize.com/znsls7xnjadf0bfipaf30mmzzqlk8k18/512x384.jpg', '0', 1, 0, '0', 'Cute Bat Coloring Book is fun halloween coloring book for kids and adults. Halloween is around the corner and meanwhile play this fun halloween themed coloring book and have fun. Choose one of the cute images, pick your favorite color and start coloring.', '', 'https://html5.gamemonetize.com/znsls7xnjadf0bfipaf30mmzzqlk8k18/', 'html5', 854, 480, 1576076683, '1', '0'),
(746, 'gamemonetize-702', 'kids-memory-game-halloween', 'Kids Memory Game: Halloween', 'https://img.gamemonetize.com/onzczkg9vsn51b1dcgfo0oervx3vx3ol/512x384.jpg', '0', 5, 0, '0', 'This is a memory game with Halloween theme in which you have to match the cards with the same pictures. The used pictures are cartoon images of Halloween related characters and objects which can make the game more interesting for children. This game has nine difficulties which you can choose from in the start screen and it can be very good for improving the kids’ memory.', '', 'https://html5.gamemonetize.com/onzczkg9vsn51b1dcgfo0oervx3vx3ol/', 'html5', 525, 800, 1576076683, '1', '0'),
(747, 'gamemonetize-701', 'shoot-the-zombie', 'Shoot the Zombie', 'https://img.gamemonetize.com/es9ncksznpnwts6fea6s9ko2zy3n8wzm/512x384.jpg', '0', 3, 0, '0', 'Help the hunter to knock the evil zombies residues that are hiding behind the blocks of metal beams and walls. Brave shooter armed with special weapons and ammunition, who know how to rebound from obstacles and destroy targets in inaccessible places. Use hanging heavy beams to crush the monsters, it is enough to smash a shot chain, which is attached to the goods. All means are good against evil stinking zombies.', '', 'https://html5.gamemonetize.com/es9ncksznpnwts6fea6s9ko2zy3n8wzm/', 'html5', 960, 540, 1576076683, '1', '0'),
(748, 'gamemonetize-700', 'adventure-time-coloring-book', 'Adventure Time Coloring Book', 'https://img.gamemonetize.com/fr118llyv70jmggor8m4447yqlomiq0y/512x384.jpg', '0', 5, 0, '0', 'Adventure Time Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/fr118llyv70jmggor8m4447yqlomiq0y/', 'html5', 960, 540, 1576076683, '1', '0'),
(749, 'gamemonetize-699', 'ben-funny-time', 'Ben Funny Time', 'https://img.gamemonetize.com/gwop5clfm02eg90nhw6xwtwdsyye7yvn/512x384.jpg', '0', 4, 0, '0', 'Talking Ben Funny Time is new online game suitable for all ages,especially for kids. Small kids will love this game. Play around with our lovley Ben, pet him, touch his legs, belly, head and have fun. Test your skills in arrow level and try to make your best score. Enjoy playing and come back for more.', '', 'https://html5.gamemonetize.com/gwop5clfm02eg90nhw6xwtwdsyye7yvn/', 'html5', 480, 720, 1576076683, '1', '0'),
(750, 'gamemonetize-698', 'slide-io', 'Slide io', 'https://img.gamemonetize.com/lhg9y1jlf5uuptgt5tqw8g8tvokwha73/512x384.jpg', '0', 1, 0, '0', 'Features: - simple, fun gameplay - good graphics', '', 'https://html5.gamemonetize.com/lhg9y1jlf5uuptgt5tqw8g8tvokwha73/', 'html5', 960, 600, 1576076683, '1', '0')";
$db[24] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(751, 'gamemonetize-697', 'bricks-jenga-3d', 'Bricks Jenga 3D', 'https://img.gamemonetize.com/4uuzzwmphxl7xpcaaj2cp1n8bbtgtnjy/512x384.jpg', '0', 1, 0, '0', 'Jenga is game based on physics. Once the tower is built, the Player number one gets the first move. Moving in Jenga consists of taking one and only one block from any level of the tower, and placing it on the topmost level to complete it.', '', 'https://html5.gamemonetize.com/4uuzzwmphxl7xpcaaj2cp1n8bbtgtnjy/', 'html5', 300, 600, 1576076683, '1', '0'),
(752, 'gamemonetize-696', 'jungle-survival-jurassic-park', 'Jungle Survival Jurassic Park', 'https://img.gamemonetize.com/8b2luv7a438q1snuogk7jllcbvifq8ty/512x384.jpg', '0', 7, 0, '0', 'Join in the great awesome multiplayer and campaign Jurassic park jungle. Here you will fight with different models of dinosaurs from milion years ago but is back in the present so survive with your friends in multiplayer or try our offline campaign and enjoy running and shooting there. Have Fun.', '', 'https://html5.gamemonetize.com/8b2luv7a438q1snuogk7jllcbvifq8ty/', 'html5', 800, 600, 1576076683, '1', '0'),
(753, 'gamemonetize-695', 'connect-pipes-plumber', 'Connect Pipes Plumber', 'https://img.gamemonetize.com/ydzqtkqx3uux0wz11341glomboaei8sh/512x384.jpg', '0', 7, 0, '0', 'In Plumber, you have to reposition the pipes so that water can easily flow from its source to designated destination. In each level, there are a few pipes visible at the start and the rest are hidden behind tiles. You have to quickly turn over other tiles and use the pipes beneath them to guide water to reach its destination.', '', 'https://html5.gamemonetize.com/ydzqtkqx3uux0wz11341glomboaei8sh/', 'html5', 800, 600, 1576076683, '1', '0'),
(754, 'gamemonetize-694', 'xtreme-speed-stunts-bmx-gm', 'Xtreme Speed Stunts BMX GM', 'https://img.gamemonetize.com/3ekpcr4j5zrziz04oj2qq3xnkmvzi4vl/512x384.jpg', '0', 2, 0, '0', 'Are you ready for Xtreme Speed Stunts BMX GM? Well... you can play this game and see if you are good with your virtual BMX. You are a BMX RIDER and you can do tricks on your Moto motor bike, race your way around all the tracks in this fun game madalin super romania stunt 2 game the stick man loves motorsport so hes biking over dirt and tar on his motor cycle, so start racing with lots of action and cycle your way to Bike Heaven. The narrow tracks for bicycle riding are building upon hills and mountains. To master bicycle tricks on the zigzag roads you need to ride slow with accuracy. Have Fun!', '', 'https://html5.gamemonetize.com/3ekpcr4j5zrziz04oj2qq3xnkmvzi4vl/', 'html5', 800, 600, 1576076683, '1', '0'),
(755, 'gamemonetize-693', 'kart-stunts', 'Kart Stunts', 'https://img.gamemonetize.com/g6zg1fewsbtf7gwkq77pp7bmihgfp525/512x384.jpg', '0', 2, 0, '0', 'Features 3 fun maps 3 vehicles to drive', '', 'https://html5.gamemonetize.com/g6zg1fewsbtf7gwkq77pp7bmihgfp525/', 'html5', 960, 600, 1576076683, '1', '0'),
(756, 'gamemonetize-692', 'fz-happy-halloween', 'FZ Happy Halloween', 'https://img.gamemonetize.com/spe9h0xb5af9nsfwhd8nw6m91mmrjjtb/512x384.jpg', '0', 5, 0, '0', 'FZ Happy Halloween – is a HTML5 Memory game. Match all the identical cards before time runs out! This game has 18 levels with a gradually increasing degree of complexity, and the game is ideally suited for mobile devices. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/spe9h0xb5af9nsfwhd8nw6m91mmrjjtb/', 'html5', 800, 600, 1576076683, '1', '0'),
(757, 'gamemonetize-691', 'crazy-bikers-jigsaw', 'Crazy Bikers Jigsaw', 'https://img.gamemonetize.com/bvfdgo74chozto6gj0xedsh4ysraxb98/512x384.jpg', '0', 5, 0, '0', 'Crazy Bikers Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/bvfdgo74chozto6gj0xedsh4ysraxb98/', 'html5', 960, 540, 1576076683, '1', '0'),
(758, 'gamemonetize-690', 'fun-monsters-memory', 'Fun Monsters Memory', 'https://img.gamemonetize.com/2hn0i7g4a7dnpoousykboge7clwfx2u0/512x384.jpg', '0', 5, 0, '0', 'Fun Monsters Memory is a free online game from genre of memory and monsters games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/2hn0i7g4a7dnpoousykboge7clwfx2u0/', 'html5', 960, 540, 1576076683, '1', '0'),
(759, 'gamemonetize-689', 'bubble-shooter-halloween', 'Bubble Shooter Halloween', 'https://img.gamemonetize.com/03d7yfjdawlj2wx08gospclx508ejfxk/512x384.jpg', '0', 5, 0, '0', 'You in the game Bubble Shooter Halloween will have to destroy bubbles all and not let them touch the ground. You will need to fall into the exact same cluster of objects with the given charge. Then these objects will explode, and you will get points.', '', 'https://html5.gamemonetize.com/03d7yfjdawlj2wx08gospclx508ejfxk/', 'html5', 450, 800, 1576076683, '1', '0'),
(760, 'gamemonetize-688', 'granny-jigsaw', 'Granny Jigsaw', 'https://img.gamemonetize.com/y44lvl0x4vq5tca43q1sqqq9lzog78b6/512x384.jpg', '0', 5, 0, '0', 'Granny Jigsaw is a free online game from genre of puzzle and jigsaw games. In this game you have a total of 12 jigsaw puzzles. You need to start from the first one and to unlock the next image. You have three modes for each picture: Easy with 25 pieces, Medium with 49 pieces and Hard with 100 pieces.', '', 'https://html5.gamemonetize.com/y44lvl0x4vq5tca43q1sqqq9lzog78b6/', 'html5', 960, 540, 1576076683, '1', '0'),
(761, 'gamemonetize-687', 'halloween-evil-blast', 'Halloween Evil Blast', 'https://img.gamemonetize.com/1szdp6u7w60rjb81npw3vmdazrcga7ec/512x384.jpg', '0', 5, 0, '0', 'Halloween Evil Blast is an online game that you can play for free. Do you have a fear of demons? Come and clear them in Halloween Evil Blast. Matching 3 or more same demons to clear them. Enjoy!', '', 'https://html5.gamemonetize.com/1szdp6u7w60rjb81npw3vmdazrcga7ec/', 'html5', 500, 800, 1576076683, '1', '0'),
(762, 'gamemonetize-686', 'rally-car-3d-gm', 'Rally Car 3D GM', 'https://img.gamemonetize.com/tm1fpyhmphhhy4ie6kypknr61mgj4ipx/512x384.jpg', '0', 5, 0, '0', 'Drive your car and avoid obstacles in the shortest time.Use your skill to win.', '', 'https://html5.gamemonetize.com/tm1fpyhmphhhy4ie6kypknr61mgj4ipx/', 'html5', 800, 600, 1576076683, '1', '0'),
(763, 'gamemonetize-685', 'planet-clicker', 'Planet Clicker', 'https://img.gamemonetize.com/vvn0u4zyijuhavb7cytf5lxbwvy5qk2l/512x384.jpg', '0', 1, 0, '0', 'Features • Endless clicker gameplay • Upgrades', '', 'https://html5.gamemonetize.com/vvn0u4zyijuhavb7cytf5lxbwvy5qk2l/', 'html5', 500, 768, 1576076683, '1', '0'),
(764, 'gamemonetize-684', 'mini-tanks-io', 'Mini Tanks io', 'https://img.gamemonetize.com/jebtanjq83aj6jecflveavxecmc6p3v9/512x384.jpg', '0', 7, 0, '0', 'Features • Two game modes • Power-ups available', '', 'https://html5.gamemonetize.com/jebtanjq83aj6jecflveavxecmc6p3v9/', 'html5', 960, 600, 1576076683, '1', '0'),
(765, 'gamemonetize-683', 'sweety-mahjong', 'Sweety Mahjong', 'https://img.gamemonetize.com/vdmdkn2jq8zuyd73o3p84wh5xv6qh34d/512x384.jpg', '0', 5, 0, '0', 'Sweety Mahjong is a HTML5 mahjong game. Enjoy this coloroued mahjong game with sweety symbols!', '', 'https://html5.gamemonetize.com/vdmdkn2jq8zuyd73o3p84wh5xv6qh34d/', 'html5', 960, 540, 1576076683, '1', '0'),
(766, 'gamemonetize-682', 'fz-halloween-memory-2', 'FZ Halloween Memory 2', 'https://img.gamemonetize.com/8xahxk6cql6t377mn62n4r7liy3lcoml/512x384.jpg', '0', 5, 0, '0', 'Halloween Memory – is a HTML5 Memory game. Match all the identical cards before time runs out! This game has 14 levels with a gradually increasing degree of complexity, Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/8xahxk6cql6t377mn62n4r7liy3lcoml/', 'html5', 800, 600, 1576076683, '1', '0'),
(767, 'gamemonetize-681', 'narrow-passage-halloween', 'Narrow Passage Halloween', 'https://img.gamemonetize.com/ijxapm70me45neobzo1j19kk4sa83oim/512x384.jpg', '0', 5, 0, '0', 'In Narrow Passage – Halloween game, all you have to do is to tap on the screen to jump, avoid obstacles and move forward. But it is much much harder than it seems. You will face different and challenging obstacles as you progress. Also don’t forget about the side walls! They will keep getting closer to each other which means the longer you stay on an obstacle, the narrower the passage will get. And if you don’t move past the obstacle, you will finally get crushed between the walls! But don’t worry, whenever you past an obstacle, the walls will get to their original place (but they get closer t', '', 'https://html5.gamemonetize.com/ijxapm70me45neobzo1j19kk4sa83oim/', 'html5', 450, 800, 1576076683, '1', '0'),
(768, 'gamemonetize-680', 'scary-halloween-differences', 'Scary Halloween Differences', 'https://img.gamemonetize.com/pu4iqr9dr3odn480d0k2zld7mwrqrm5h/512x384.jpg', '0', 5, 3, '0', 'Scary Halloween Differences is interesting kids game and it&#039;s time for you to have fun!In this game you need to find the differences in these funny kids images. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/pu4iqr9dr3odn480d0k2zld7mwrqrm5h/', 'html5', 960, 540, 1576076683, '1', '0'),
(769, 'gamemonetize-679', 'insect-crush', 'Insect Crush', 'https://img.gamemonetize.com/002hzh2dby6fy2etf4ezp5umvgokloem/512x384.jpg', '0', 3, 0, '0', 'Are you looking for a game where you can have fun? Insect Cush game is for you. Clean up butterflies, ladybugs, ants and other pests. Insect Cush has never been so much fun with its beautiful design and physics. With 56 different levels you will not understand how time passes. Moreover, now supported by fun animations. Remember that you must hunt different pests in each section.', '', 'https://html5.gamemonetize.com/002hzh2dby6fy2etf4ezp5umvgokloem/', 'html5', 800, 600, 1576076683, '1', '0'),
(770, 'gamemonetize-678', 'motocross-xtreme-stunts', 'Motocross Xtreme Stunts', 'https://img.gamemonetize.com/fb2b5cnhme0nhdlwf0m9jkbpam608ono/512x384.jpg', '0', 2, 1, '0', 'In this motocross game you need to pass all nine levels and to earn points. Collect coins and do some stunts for extra points. Balance bike with arrow keys or with buttons on your screen. Unlock more bikes and have fun in this motocross game. Enjoy!', '', 'https://html5.gamemonetize.com/fb2b5cnhme0nhdlwf0m9jkbpam608ono/', 'html5', 860, 480, 1576076683, '1', '0'),
(771, 'gamemonetize-677', 'dragon-city-destroyer', 'Dragon City Destroyer', 'https://img.gamemonetize.com/5k2viak2g7b1rgvqgjp6xsjxbcsz48ra/512x384.jpg', '0', 1, 0, '0', 'The scene of Dragon City Destroyer is all set for the new contesters of flying dragon games in which there are long lists of interesting episodes of dragon flying games. The people of city dragon games have forgotten about your super powers of dragon city attack games for which you were famous for. Come and launch a severe attack of flying attack city dragon games to attest the past authority of your strong powers Dragon City Destroyer.', '', 'https://html5.gamemonetize.com/5k2viak2g7b1rgvqgjp6xsjxbcsz48ra/', 'html5', 960, 640, 1576076683, '1', '0'),
(772, 'gamemonetize-676', 'toilet-rush', 'Toilet Rush', 'https://img.gamemonetize.com/jbfqqewsrr8ru56d5zbfxtr4ein5mrq5/512x384.jpg', '0', 9, 0, '0', 'Toilet rush is a puzzle platmer game.Find your way and dump your load on the lavatory before you explode. It&#039;s a everyday struggle to find peace on toilet.', '', 'https://html5.gamemonetize.com/jbfqqewsrr8ru56d5zbfxtr4ein5mrq5/', 'html5', 800, 500, 1576076683, '1', '0'),
(773, 'gamemonetize-675', 'east-princess-through-the-ages', 'East Princess - Through the Ages', 'https://img.gamemonetize.com/r1v84ii7xf4b2wf7qex78128otgmokcf/512x384.jpg', '0', 1, 0, '0', 'Salam-alaikum, dear friend. Welcome to the palace of the mysterious Princess of the East. Here you are waiting for extraordinary miracles. Rather, sit down on a soft carpet and listen to fairy tales worthy of the padishah himself. Admire the gorgeous princess outfits, contemplate how precious stones sparkle in her hair. Truly, the beauty of the princess can not be described in words. Help the most worthy of the Princesses of the East to get ready to receive guests. Choose a silk dress or an open top with puffy pants. Cover the thick black hair of a princess in a braid or lay it in a ponytail. ', '', 'https://html5.gamemonetize.com/r1v84ii7xf4b2wf7qex78128otgmokcf/', 'html5', 800, 600, 1576076683, '1', '0'),
(774, 'gamemonetize-674', 'happy-halloween-princess-card-designer', 'Happy Halloween - Princess Card Designer', 'https://img.gamemonetize.com/yhspfr7merttb60e1mzhh3cy5qohskbr/512x384.jpg', '0', 1, 0, '0', 'Soon your favorite holiday! Halloween is a time of miracles, horror and sweets. Hurry to congratulate your loved ones with the help of a unique card that you can create in this game. Use ghosts, witches, pumpkins, abandoned houses, bats and much more as decoration elements. The received postcard can be printed!', '', 'https://html5.gamemonetize.com/yhspfr7merttb60e1mzhh3cy5qohskbr/', 'html5', 800, 600, 1576076683, '1', '0'),
(775, 'gamemonetize-673', 'sonic-io', 'Sonic.io', 'https://img.gamemonetize.com/fx569hmddhs57tgur1ysblb7lomadz3s/512x384.jpg', '0', 4, 0, '0', 'Sonic.io is an action io game where your goal is to run away and dodge everything coming at you while collecting rings.', '', 'https://html5.gamemonetize.com/fx569hmddhs57tgur1ysblb7lomadz3s/', 'html5', 1200, 720, 1576076683, '1', '0'),
(776, 'gamemonetize-672', 'rooftop-shooters', 'Rooftop Shooters', 'https://img.gamemonetize.com/2wba9raumb0w8zfhtrqllct22n8vi89l/512x384.jpg', '0', 3, 1, '0', 'Try to shoot your opponent off of the rooftop in this action packed shooter game. 3 different modes to play: Online multiplayer, local two player and local practice mode. Win matches to unlock new skins in the latest .io game from Lagged.com.', '', 'https://html5.gamemonetize.com/2wba9raumb0w8zfhtrqllct22n8vi89l/', 'html5', 800, 600, 1576076683, '1', '0'),
(777, 'gamemonetize-671', 'fighter-aircraft-simulator', 'Fighter Aircraft Simulator', 'https://img.gamemonetize.com/h6s0wcnwz4q7l2outlm8088flqr9l9n3/512x384.jpg', '0', 3, 0, '0', 'Features Multiple weapons Three missions AI enemy airplanes', '', 'https://html5.gamemonetize.com/h6s0wcnwz4q7l2outlm8088flqr9l9n3/', 'html5', 960, 540, 1576076683, '1', '0'),
(778, 'gamemonetize-670', 'falling-balls-2019-gm', 'Falling Balls 2019 GM', 'https://img.gamemonetize.com/lto0wx7amng48zfq2w48emt3ehv6wgei/512x384.jpg', '0', 3, 0, '0', 'Create a path for you balls and avoid obstacles to rich the level.', '', 'https://html5.gamemonetize.com/lto0wx7amng48zfq2w48emt3ehv6wgei/', 'html5', 800, 600, 1576076683, '1', '0'),
(779, 'gamemonetize-669', 'jumping-bouncy-ball-gm', 'Jumping Bouncy Ball GM', 'https://img.gamemonetize.com/axw68l3i55267mmpl0kag623os5slsgv/512x384.jpg', '0', 3, 0, '0', 'Bouncy Ball 3D is a 3D music game and your only challenge is to keep the ball jumping on the music tiles while listening to the beat drops.', '', 'https://html5.gamemonetize.com/axw68l3i55267mmpl0kag623os5slsgv/', 'html5', 800, 600, 1576076683, '1', '0'),
(780, 'gamemonetize-668', 'super-3d-world-adventure-gm', 'Super 3D World Adventure GM', 'https://img.gamemonetize.com/g99syj0jd8cexk1qpaokvn30cfpw05bg/512x384.jpg', '0', 3, 0, '0', 'Super 3d World Adventure a simple 3d platform game for Android, you have to avoid obstacles to get coins and buy characters.', '', 'https://html5.gamemonetize.com/g99syj0jd8cexk1qpaokvn30cfpw05bg/', 'html5', 800, 600, 1576076683, '1', '0'),
(781, 'gamemonetize-667', 'pixel-circuit-racing-car-crash-gm', 'Pixel Circuit Racing Car Crash GM', 'https://img.gamemonetize.com/nxgwbjk7aa4usoron7l125ijyks286tv/512x384.jpg', '0', 2, 0, '0', 'Pixel Circuit Racing Car Crash is a 3d racing game, tap the screen to change lanes. Avoid collisions with another car.', '', 'https://html5.gamemonetize.com/nxgwbjk7aa4usoron7l125ijyks286tv/', 'html5', 800, 600, 1576076683, '1', '0'),
(782, 'gamemonetize-666', 'running-crowd-city-gm', 'Running Crowd City GM', 'https://img.gamemonetize.com/ijjb27x7zblnf0q77smjitxdjugw4vnm/512x384.jpg', '0', 2, 0, '0', 'Become the biggest crowd in town! Gather people accross the city and crush your opponents with your overwhelming leadership!', '', 'https://html5.gamemonetize.com/ijjb27x7zblnf0q77smjitxdjugw4vnm/', 'html5', 800, 600, 1576076683, '1', '0'),
(783, 'gamemonetize-665', 'chaos-in-the-city-gm', 'Chaos In The City GM', 'https://img.gamemonetize.com/jt8siruxc60uieczz4f1s9krihku40ro/512x384.jpg', '0', 2, 0, '0', 'Control different monsters and destroy the small town, earn points and coins for the unlock monsters. Be careful of the police and the army trying to stop you.', '', 'https://html5.gamemonetize.com/jt8siruxc60uieczz4f1s9krihku40ro/', 'html5', 800, 600, 1576076683, '1', '0'),
(784, 'gamemonetize-664', 'fantastic-pixel-car-racing-gm-multiplayer', 'Fantastic Pixel Car  Racing GM Multiplayer', 'https://img.gamemonetize.com/ph5sj1plfidbx0y8by101ej3tyymvobk/512x384.jpg', '0', 2, 0, '0', 'Are you ready for the great racing car multiplayer? Well now you have the chance to show your friends how good are your skills, you can get skills by playing offline and unlock new tracks and powerful cars.', '', 'https://html5.gamemonetize.com/ph5sj1plfidbx0y8by101ej3tyymvobk/', 'html5', 800, 600, 1576076683, '1', '0'),
(785, 'gamemonetize-663', 'fidget-spinner-io', 'Fidget Spinner.io', 'https://img.gamemonetize.com/mjmcfuzbsy8eblsvnhfxyh9d3gf2hjp3/512x384.jpg', '0', 2, 0, '0', 'Fidget Spinner.io is an online game that you can play for free. Fidget Spinner.io is a fun io game suitable for all ages. The operation of the game is very simple. You just need to control your fidget spinner to move on the map by mouse or simply tap on the screen. Absorb the energy points on the map to make you stronger. Destroy your enemy by letting them crash on your trail. Have fun playing.', '', 'https://html5.gamemonetize.com/mjmcfuzbsy8eblsvnhfxyh9d3gf2hjp3/', 'html5', 854, 480, 1576076683, '1', '0'),
(786, 'gamemonetize-662', 'puppy-race', 'Puppy Race', 'https://img.gamemonetize.com/x6o0nu3pjx8v5mnd6kqf9d3eo4zldqyb/512x384.jpg', '0', 2, 0, '0', 'Drive car with your favorite puppy and beat your opponent. Four different trucks in this funny games on the great places. Be fast, drive carefull and win the game! Good Luck!', '', 'https://html5.gamemonetize.com/x6o0nu3pjx8v5mnd6kqf9d3eo4zldqyb/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(787, 'gamemonetize-661', 'pirate-run', 'Pirate Run', 'https://img.gamemonetize.com/9oj139kr9ljtwbevirhehwbihfinvf25/512x384.jpg', '0', 2, 0, '0', 'Pirate Run a great HTML5 platform game. Control pirate on the lone island and pick up all diamond. The island have a guard to protect his treasure. Avoid them and be fast the game is harder and harder after time. Beat your friends , make highest score!', '', 'https://html5.gamemonetize.com/9oj139kr9ljtwbevirhehwbihfinvf25/', 'html5', 1280, 720, 1576076683, '1', '0'),
(788, 'gamemonetize-660', 'panda-space-adventure', 'Panda Space Adventure', 'https://img.gamemonetize.com/ovco31xaiufx1qroqugmqzrq32ar5uxu/512x384.jpg', '0', 3, 0, '0', 'Panda Space Adventure is a great HTML5 shooting-action game. Control Panda in a little space ship in his war with evil bears. Colect the money and kill all enemies. Good Luck', '', 'https://html5.gamemonetize.com/ovco31xaiufx1qroqugmqzrq32ar5uxu/', 'html5', 1280, 720, 1576076683, '1', '0'),
(789, 'gamemonetize-659', 'paint-them-all', 'Paint them all', 'https://img.gamemonetize.com/4rtd0e9ygugc2jebymviomror54kuyxz/512x384.jpg', '0', 3, 0, '0', 'Paint them all is a shooting game. Defend your base. Kill all those creatures by filling them with paint until they explode! Survive all the waves!', '', 'https://html5.gamemonetize.com/4rtd0e9ygugc2jebymviomror54kuyxz/', 'html5', 1280, 720, 1576076683, '1', '0'),
(790, 'gamemonetize-658', 'ben-10-hidden-keys', 'Ben 10 Hidden Keys', 'https://img.gamemonetize.com/i324uou43hzzs66ld1hyv1vzrhd6tjrb/512x384.jpg', '0', 5, 0, '0', 'Ben 10 Hidden Keys is a free online skill and hidden object game. Find out the hidden keys in the specified images. Each level has 10 hidden keys. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/i324uou43hzzs66ld1hyv1vzrhd6tjrb/', 'html5', 960, 540, 1576076683, '1', '0'),
(791, 'gamemonetize-657', 'russian-trucks-differences', 'Russian Trucks Differences', 'https://img.gamemonetize.com/kkwouzjlt0fi7tfkfyyo8sa0pdllzybj/512x384.jpg', '0', 5, 0, '0', 'Russian trucks are one of the most powerful vehicles. Here you will find the best trucks coming from Russia. In this game you need to find the differences in these beautiful trucks. Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Have fun!', '', 'https://html5.gamemonetize.com/kkwouzjlt0fi7tfkfyyo8sa0pdllzybj/', 'html5', 960, 540, 1576076683, '1', '0'),
(792, 'gamemonetize-656', 'electrical-monsters-match-3', 'Electrical Monsters Match 3', 'https://img.gamemonetize.com/02j98fqcnstiycvlo7vye5qe8unk9nra/512x384.jpg', '0', 5, 0, '0', 'Electrical Monsters Match 3 is a interesting addictive match 3 game with a monsters theme. You can use your free time to enjoy the fun of it. Swap adjacent tiles, make the line of at least three candies of the same color and remove them from the field. Call your friends and enjoy it!', '', 'https://html5.gamemonetize.com/02j98fqcnstiycvlo7vye5qe8unk9nra/', 'html5', 960, 540, 1576076683, '1', '0'),
(793, 'gamemonetize-655', 'fz-halloween-bubble-shooter', 'FZ Halloween Bubble Shooter', 'https://img.gamemonetize.com/qf3kny1vjrmd2bi67rpe1iebfi6fjlma/512x384.jpg', '0', 5, 0, '0', 'FZ Halloween Bubble Shooter - HTML5 Halloween Bubble Shooter is a simple match game, shoot in 3 or more balls with same colors, and get high score! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/qf3kny1vjrmd2bi67rpe1iebfi6fjlma/', 'html5', 800, 600, 1576076683, '1', '0'),
(794, 'gamemonetize-654', 'zombie-fun-jigsaw', 'Zombie Fun Jigsaw', 'https://img.gamemonetize.com/16h2apo1utbgqwu9yf10yrx784s7qu6s/512x384.jpg', '0', 5, 0, '0', 'Zombie Fun Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/16h2apo1utbgqwu9yf10yrx784s7qu6s/', 'html5', 960, 540, 1576076683, '1', '0'),
(795, 'gamemonetize-653', 'halloween-defence-1', 'Halloween Defence 1', 'https://img.gamemonetize.com/ft56rb0j4ptitxtznscjjc8ioyu7i4fy/512x384.jpg', '0', 1, 0, '0', 'It’s Halloween time and the pumpkin heads are attacking again! If you want to survive, you have to shoot down these pumpkin heads before they reach you. Each pumpkin head that is destroyed is considered as one score point. You have two lives and whenever a pumpkin head reaches you, you lose one life. When you lose your two lives, you will also lose the game. But you are given a second chance! Choose one of the 4 pumpkin heads shown to you and if you are lucky enough, you will find an extra lives in it and can continue playing. So do your best and shoot down the evil pumpkin heads!', '', 'https://html5.gamemonetize.com/ft56rb0j4ptitxtznscjjc8ioyu7i4fy/', 'html5', 1366, 768, 1576076683, '1', '0'),
(796, 'gamemonetize-652', 'mrs-bullet-perfect-gunshot', 'Mrs. Bullet: Perfect Gunshot', 'https://img.gamemonetize.com/082sslaazto8g5lew4sl0yk5f8evctkd/512x384.jpg', '0', 3, 0, '0', 'Are you ready to become a super hot shooter babe? Solve puzzling challenges, show off your deadly accuracy and take aim at the enemies. Use your brain in this unique puzzle game. You will need precise aim and laser focus to take down enemies, swat, inmates and many other bad guys you will encounter in this world! Start your Shooting Adventure now! The one thing you have to ask yourself is: can you do it in one shot? Game Features: 1. Destroy them all and save the world! Mrs Bullet is on a secret mission. Use your deadly accuracy and precision to keep the bad guys! Whether it is a swat, inmate,', '', 'https://html5.gamemonetize.com/082sslaazto8g5lew4sl0yk5f8evctkd/', 'html5', 1100, 700, 1576076683, '1', '0'),
(797, 'gamemonetize-651', 'master-chess-multiplayer', 'Master Chess Multiplayer', 'https://img.gamemonetize.com/0j27h8fp1no93ybdnpp61khjmpgubcqb/512x384.jpg', '0', 7, 0, '0', 'Master Chess Multiplayer is a HTML5 Board Game. Enjoy this stylish version of the classic Chess Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/0j27h8fp1no93ybdnpp61khjmpgubcqb/', 'html5', 1280, 1920, 1576076683, '1', '0'),
(798, 'gamemonetize-650', 'battleship-war-multiplayer', 'Battleship War Multiplayer', 'https://img.gamemonetize.com/a7bwcxz63gw2p42jijlkycq11iqhkt6u/512x384.jpg', '0', 7, 0, '0', 'Battleship War is a HTML5 Multiplayer Game. Hit all the ships of your enemy and lead your fleet to the victory! Collect points and buy special power-up!', '', 'https://html5.gamemonetize.com/a7bwcxz63gw2p42jijlkycq11iqhkt6u/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(799, 'gamemonetize-649', 'connect-4-multiplayer', 'Connect 4 Multiplayer', 'https://img.gamemonetize.com/c4qb2t0thmon0si5chlhqep3ejzj02pc/512x384.jpg', '0', 7, 0, '0', 'Connect 4 is a HTML5 Logic Game. Drop your discs into the columns of the game grid and make a line of at least four chips either vertically, diagonally, or horizontally before your opponent! Enjoy challenging other players!', '', 'https://html5.gamemonetize.com/c4qb2t0thmon0si5chlhqep3ejzj02pc/', 'html5', 1700, 768, 1576076683, '1', '0'),
(800, 'gamemonetize-648', 'halloween-defence', 'Halloween Defence', 'https://img.gamemonetize.com/uu3o4i3yambcl9yuoghanh114h2f3ktx/512x384.jpg', '0', 7, 0, '0', 'It’s Halloween time and the pumpkin heads are attacking again! If you want to survive, you have to shoot down these pumpkin heads before they reach you. Each pumpkin head that is destroyed is considered as one score point. You have two lives and whenever a pumpkin head reaches you, you lose one life. When you lose your two lives, you will also lose the game. But you are given a second chance! Choose one of the 4 pumpkin heads shown to you and if you are lucky enough, you will find an extra lives in it and can continue playing. So do your best and shoot down the evil pumpkin heads!', '', 'https://html5.gamemonetize.com/uu3o4i3yambcl9yuoghanh114h2f3ktx/', 'html5', 960, 540, 1576076683, '1', '0'),
(801, 'gamemonetize-647', 'extreme-ball-balance-3d', 'Extreme Ball Balance 3D', 'https://img.gamemonetize.com/rx3vmy0662zdatefaownzws2eohmskfk/512x384.jpg', '0', 1, 0, '0', 'Impossible ball runner game will take you engaged for long hours. Enjoy all the bridge balance game levels to balance the ball on impossible tracks. There are 10 different tracks for hell ball runner challenge. You can be the best scorer or coin collector of this ball balancer mania. Its thrilling game play provided quality graphics and environment best of all other balance games.', '', 'https://html5.gamemonetize.com/rx3vmy0662zdatefaownzws2eohmskfk/', 'html5', 960, 640, 1576076683, '1', '0'),
(802, 'gamemonetize-646', 'urban-derby-stunt-and-drift', 'Urban Derby Stunt And Drift', 'https://img.gamemonetize.com/g1pdb30jmob4f5pf3xadcsycl8b7ubsa/512x384.jpg', '0', 2, 0, '0', 'Are you ready to enjoy ultimate car driving? Fun and enjoyment filled stunt car game with casual fun and also challenging levels. Performe stunts and collect coins to earn money to unlock new vehicles! This realistic simulation game gives you a real feel into how the different vehicles handles and how you have to master the controls to keep this beast moving. You can roam freely throughout the map and discover the beautiful landscape...', '', 'https://html5.gamemonetize.com/g1pdb30jmob4f5pf3xadcsycl8b7ubsa/', 'html5', 750, 548, 1576076683, '1', '0'),
(803, 'gamemonetize-645', 'master-checkers-multiplayer', 'Master Checkers Multiplayer', 'https://img.gamemonetize.com/dh1384zvw7f5eev7yszdfp4h537lzwwc/512x384.jpg', '0', 7, 0, '0', 'Master Checkers Multiplayer is a HTML5 Board Game. Enjoy this stylish version of the classic Checkers Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/dh1384zvw7f5eev7yszdfp4h537lzwwc/', 'html5', 1280, 1920, 1576076683, '1', '0'),
(804, 'gamemonetize-644', 'stickman-dismount', 'Stickman Dismount', 'https://img.gamemonetize.com/d2pe3o8rrt57q6mro0vjkor7q0xequ04/512x384.jpg', '0', 9, 0, '0', 'Features: • Fun physics gameplay • Multiple levels to play • Score system', '', 'https://html5.gamemonetize.com/d2pe3o8rrt57q6mro0vjkor7q0xequ04/', 'html5', 960, 600, 1576076683, '1', '0'),
(805, 'gamemonetize-643', 'one-hand-cowboy', 'One Hand Cowboy', 'https://img.gamemonetize.com/eo5qsv190nxifqhdzwntdedjay9bp7j4/512x384.jpg', '0', 3, 0, '0', 'A wild west Sherriff who must practice his aim if he hopes to survive. Shoot your way through 12 levels of challenging target practice and prove you have what it takes to be a law gun man.', '', 'https://html5.gamemonetize.com/eo5qsv190nxifqhdzwntdedjay9bp7j4/', 'html5', 1280, 720, 1576076683, '1', '0'),
(806, 'gamemonetize-642', 'rummy-multiplayer', 'Rummy Multiplayer', 'https://img.gamemonetize.com/3v46j2mwch01pteg5do49xw7a1otu69x/512x384.jpg', '0', 7, 0, '0', 'Rummy Multiplayer is a HTML5 Card Game. Enjoy this stylish version of the classic Rummy card game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/3v46j2mwch01pteg5do49xw7a1otu69x/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(807, 'gamemonetize-641', 'penalty-challenge-multiplayer', 'Penalty Challenge Multiplayer', 'https://img.gamemonetize.com/czy29ldafw7pdecjo7irqipcld83ovn1/512x384.jpg', '0', 8, 0, '0', 'Penalty Challenge Multiplayer is a HTML5 Sport Game. Select between 32 different team your favorite one. You have 5 attempts to pass the goalie and other 5 to save your opponent’s kicks! It’s all in your hands and feet! 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/czy29ldafw7pdecjo7irqipcld83ovn1/', 'html5', 1280, 640, 1576076683, '1', '0'),
(808, 'gamemonetize-640', 'night-dress', 'Night Dress', 'https://img.gamemonetize.com/9oigppnph07qvn2ic1xahyc07rkw0rd9/512x384.jpg', '0', 4, 0, '0', 'Night dress is a great dress up HTML5 game. Are you ready for go out? Are you ready for a Party? Help Jenny to choose best clothes for tonight. Choose dress and place to go. Enjoy!', '', 'https://html5.gamemonetize.com/9oigppnph07qvn2ic1xahyc07rkw0rd9/', 'html5', 800, 480, 1576076683, '1', '0'),
(809, 'gamemonetize-639', 'spongebob-coin-adventure', 'Spongebob Coin Adventure', 'https://img.gamemonetize.com/b3jcrzw9816h4bypk8ifm3z8czivqfp1/512x384.jpg', '0', 4, 0, '0', 'Spongebob Coin Adventure is fun arcade game suitable for all ages. If you are big fan of Spongebob you will love this game. Guid Spongebob on the platforms, collect as many coins as possible and try not to crush with the blocks. Tap on the screen to guid Spongebob. Have fun playing.', '', 'https://html5.gamemonetize.com/b3jcrzw9816h4bypk8ifm3z8czivqfp1/', 'html5', 854, 480, 1576076683, '1', '0'),
(810, 'gamemonetize-638', 'neon-strike', 'Neon Strike', 'https://img.gamemonetize.com/fw6wz3qi2x99oo17nqoejb29ev0okg10/512x384.jpg', '0', 5, 0, '0', 'Welcome to our latest game Neon Strike. In this game you have two squares one of which is red and the other is blue. Horizontal line is given which for some time changes color from red to blue and vice versa. The task in the game is to touch the squares of the horizontal line with the appropriate color. If the square is red then the line should also be red. With each touch square you get one point. Make as many points as possible.', '', 'https://html5.gamemonetize.com/fw6wz3qi2x99oo17nqoejb29ev0okg10/', 'html5', 720, 1280, 1576076683, '1', '0'),
(811, 'gamemonetize-637', 'one-jump-bomb', 'One Jump Bomb', 'https://img.gamemonetize.com/gzefstciafgcp8o2t95xzv22pppf78ho/512x384.jpg', '0', 5, 0, '0', 'A peaceful walk turns into a jurney in the world of [b]Mr. Evilsun[/b]’s psychedelic shadows. Mr. Evilsun, with no apparent reason, kidnaps Bella, Ball’s girlfriend. Ball will have to go through dozens of levels to free his well-rounded girlfriend, but he needs to finish every level before the fuse on his head explodes. Help Ball save his girlfriend from the fearsome Mr. Evilsun! Bella’s destiny is in your hands, and if you choose not to help Ball she…well, never mind! SPECS[/b] - 23 compelling levels, full of brain teasers (which can be easier or harder, depending on the programmers’ will to ', '', 'https://html5.gamemonetize.com/gzefstciafgcp8o2t95xzv22pppf78ho/', 'html5', 960, 540, 1576076683, '1', '0'),
(812, 'gamemonetize-636', 'sweet-candy-match-3-html5', 'Sweet Candy Match 3 HTML5', 'https://img.gamemonetize.com/17do0z9fhbk8okmh3tugv7hbxo225df7/512x384.jpg', '0', 5, 0, '0', 'Sweet Candy Match 3 is a good match 3 games with 17 levels. In each level, you need to clear the dirty cells. Make a column or row of three or more sweet candy of the same type to make them disappears. Break all the dirty cells in time to complete.', '', 'https://html5.gamemonetize.com/17do0z9fhbk8okmh3tugv7hbxo225df7/', 'html5', 320, 420, 1576076683, '1', '0'),
(813, 'gamemonetize-635', 'guess-who-multiplayer', 'Guess Who Multiplayer', 'https://img.gamemonetize.com/eiu1zohggl1fujh1q5k8pqra20s7r1q6/512x384.jpg', '0', 7, 0, '0', 'Guess Who Multiplayer is a HTML5 Board Game. The goal of the game is to be the first to guess which character one’s opponent has selected. 2 Game’s Mode: - Multiplayer mode - Play against the pc', '', 'https://html5.gamemonetize.com/eiu1zohggl1fujh1q5k8pqra20s7r1q6/', 'html5', 1600, 768, 1576076683, '1', '0'),
(814, 'gamemonetize-634', 'snake-and-ladders-multiplayer', 'Snake and Ladders Multiplayer', 'https://img.gamemonetize.com/cn3nwmpoxnc0k3csach2u3w8jjelp8e1/512x384.jpg', '0', 7, 0, '0', 'Snake and Ladders Multiplayer is a HTML5 Board Game. Enjoy this funny version of the classic Snake and Ladders Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/cn3nwmpoxnc0k3csach2u3w8jjelp8e1/', 'html5', 1360, 640, 1576076683, '1', '0'),
(815, 'gamemonetize-633', 'slendrina-must-die-the-celar', 'Slendrina Must Die: The Celar', 'https://img.gamemonetize.com/gts86cizclwy1wdcb9gpmjfdikgnre17/512x384.jpg', '0', 3, 0, '0', 'After you searched the house and found all 8 pieces of painting, Slenderman knock you out. You know the secret of Slendrina, and now you can&#039;t leave the house. They throw you in their cellar. This place looks more like The Bunker. You must find 8 books if you want to leave this place alive! Good Luck! * Four weapons: - Knife - Gun - Shotgun - MP5 * Awesome 3D Graphics', '', 'https://html5.gamemonetize.com/gts86cizclwy1wdcb9gpmjfdikgnre17/', 'html5', 1100, 700, 1576076683, '1', '0'),
(816, 'gamemonetize-632', 'mahjong-deluxe', 'Mahjong Deluxe', 'https://img.gamemonetize.com/v59mmp02iwzbalkuhf9anjz5frd6xyet/512x384.jpg', '0', 5, 0, '0', 'Mahjong Deluxe is a HTML5 mahjong game. Enjoy this stylish mahjong game with wooden tiles!!', '', 'https://html5.gamemonetize.com/v59mmp02iwzbalkuhf9anjz5frd6xyet/', 'html5', 960, 540, 1576076683, '1', '0'),
(817, 'gamemonetize-631', 'spider-solitaire', 'Spider Solitaire', 'https://img.gamemonetize.com/lhkdxz7nzhznxzoll29up5windogyqsk/512x384.jpg', '0', 5, 0, '0', 'Spider Solitaire is a HTML5 Game. Enjoy this stylish version of the classic Spider Solitaire!', '', 'https://html5.gamemonetize.com/lhkdxz7nzhznxzoll29up5windogyqsk/', 'html5', 1600, 768, 1576076683, '1', '0'),
(818, 'gamemonetize-630', 'goose-game-multiplayer', 'Goose Game Multiplayer', 'https://img.gamemonetize.com/k8a44th90typsbsvgnwpo64eurxee44y/512x384.jpg', '0', 7, 0, '0', 'Goose Game Multiplayer is a HTML5 Board Game. Enjoy this funny version of the classic Goose Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/k8a44th90typsbsvgnwpo64eurxee44y/', 'html5', 1360, 640, 1576076683, '1', '0'),
(819, 'gamemonetize-629', 'dots-vs-dots', 'Dots VS Dots', 'https://img.gamemonetize.com/whpeaw7jl60fcz0q44zfacvrjjjc5012/512x384.jpg', '0', 5, 0, '0', 'In this game your job is to make to hit small dot with bigger dots with same color. Small dot will change color instantly, so you need to react fast. Try to play longer as you can and to get the best score.', '', 'https://html5.gamemonetize.com/whpeaw7jl60fcz0q44zfacvrjjjc5012/', 'html5', 720, 1280, 1576076683, '1', '0'),
(820, 'gamemonetize-628', 'reversi-multiplayer', 'Reversi Multiplayer', 'https://img.gamemonetize.com/8jq35lr1f8fyrmzyb8qq2r0qj5hpd7vl/512x384.jpg', '0', 7, 0, '0', 'Reversi Multiplayer is a HTML5 Board Game. Enjoy this stylish version of the classic Reversi Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/8jq35lr1f8fyrmzyb8qq2r0qj5hpd7vl/', 'html5', 1280, 1920, 1576076683, '1', '0'),
(821, 'gamemonetize-627', 'backgammon-multiplayer', 'Backgammon Multiplayer', 'https://img.gamemonetize.com/z0nhx4fgfzopjkpuz1rg5gfh1qh0bwva/512x384.jpg', '0', 7, 0, '0', 'Backgammon Multiplayer is a HTML5 Board Game. Enjoy this stylish version of the classic Backgammon Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/z0nhx4fgfzopjkpuz1rg5gfh1qh0bwva/', 'html5', 1360, 840, 1576076683, '1', '0'),
(822, 'gamemonetize-626', 'domino-multiplayer', 'Domino Multiplayer', 'https://img.gamemonetize.com/09soxm6hx6smds3q2s326sqnpxtyyqtz/512x384.jpg', '0', 7, 3, '0', 'Domino Multiplayer is a HTML5 Board Game. Enjoy this stylish version of the classic Domino Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/09soxm6hx6smds3q2s326sqnpxtyyqtz/', 'html5', 768, 1440, 1576076683, '1', '0'),
(823, 'gamemonetize-625', 'tic-tac-toe-multiplayer', 'Tic Tac Toe Multiplayer', 'https://img.gamemonetize.com/iut12grhli3sophlmh6gkz3bj1k9wduf/512x384.jpg', '0', 7, 0, '0', 'Ultimate Tic Tac Toe is a HTML5 Board Game. Enjoy this nice version of the classic Tic Tac Toe Game. 3 Game’s Mode: - Multiplayer mode - Play against the pc - Challenge a friend playing on the same device', '', 'https://html5.gamemonetize.com/iut12grhli3sophlmh6gkz3bj1k9wduf/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(824, 'gamemonetize-624', 'halloween-parkour', 'Halloween Parkour', 'https://img.gamemonetize.com/f4s1mo0lbse5gvty78y4i2v8gj013wci/512x384.jpg', '0', 8, 0, '0', 'CLICK ON THE SCREEN TO PLAY !! Hallowen Parkour is a 3D game in which you have to jump and not fall. You have to reach the end !!!', '', 'https://html5.gamemonetize.com/f4s1mo0lbse5gvty78y4i2v8gj013wci/', 'html5', 800, 600, 1576076683, '1', '0'),
(825, 'gamemonetize-623', 'bombers-io', 'Bombers.IO', 'https://img.gamemonetize.com/rpt737bxi94s2bd6yguit1kihd2clm6c/512x384.jpg', '0', 8, 0, '0', 'Bombers.io is a unique battle arena game, only weapon that you have is range weapon and have to use it to kill others. Take precised and predictive shots for confirmed kills and unlock powerful weapons. Good Luck', '', 'https://html5.gamemonetize.com/rpt737bxi94s2bd6yguit1kihd2clm6c/', 'html5', 900, 540, 1576076683, '1', '0'),
(826, 'gamemonetize-622', 'happy-bubble-shooter', 'Happy Bubble Shooter', 'https://img.gamemonetize.com/fa62hcs762tikpz760gb3hct0ysw88vo/512x384.jpg', '0', 5, 0, '0', 'Happy bubble shooter is a fresh new version of the well-known game bubble shooter. Help the cute yellow bird to pop all bubbles. Make combinations of 3 or more bubbles to make them pop. Clear all bubbles to win.', '', 'https://html5.gamemonetize.com/fa62hcs762tikpz760gb3hct0ysw88vo/', 'html5', 800, 450, 1576076683, '1', '0'),
(827, 'gamemonetize-621', 'fast-extreme-track-racing', 'Fast Extreme Track Racing', 'https://img.gamemonetize.com/zk5135z1ixqb8uuaguefotehblaeiati/512x384.jpg', '0', 2, 0, '0', 'Fast Extreme Track Racing is a fast-paced street car racing game with various challenges and features.', '', 'https://html5.gamemonetize.com/zk5135z1ixqb8uuaguefotehblaeiati/', 'html5', 800, 600, 1576076683, '1', '0'),
(828, 'gamemonetize-620', 'horrible-lovely-manicure-halloween-2019', 'Horrible Lovely Manicure Halloween 2019', 'https://img.gamemonetize.com/gt0xig8t7e2rn4ol0vioc78omjgtl9k1/512x384.jpg', '0', 1, 0, '0', 'Princess Elsa is getting ready for Halloween. She decided to turn into a charming witch. This Halloween must be special. Elsa wants to work out her image to the smallest detail. Let us help her with this. First, the princess needs a festive make-up - use the traditional Halloween colors - black, orange and red. Then, you need to prepare Elsa&#039;s hands for manicure. Treat your nails with a nail file, get rid of defects and apply cream from irritation. It is time to turn the princess nails into a work of art. Use nail polish, texture and decoration. Create your own unique composition. And fin', '', 'https://html5.gamemonetize.com/gt0xig8t7e2rn4ol0vioc78omjgtl9k1/', 'html5', 800, 600, 1576076683, '1', '0'),
(829, 'gamemonetize-619', 'crossbar-challenge', 'Crossbar Challenge', 'https://img.gamemonetize.com/57b3u5s0l0ig28ps6dy5ppaeipf9u9gz/512x384.jpg', '0', 8, 0, '0', 'Crossbar Challenge is a HTML5 Sport Game. If you are a fun of Penalty Games you must try this challenging variation. Your aim is to hit the crossbar, not scoring a goal. There is no Goalkeeper to defeat, it’s only you and the crossbar. Do you think it’s easier? Try it now!', '', 'https://html5.gamemonetize.com/57b3u5s0l0ig28ps6dy5ppaeipf9u9gz/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(830, 'gamemonetize-618', 'city-drive', 'City Drive', 'https://img.gamemonetize.com/5q7pzlqbdiah4ouoc4okzx7j6z0cl05r/512x384.jpg', '0', 2, 0, '0', 'Features • 3 game modes • Multiple customizable cars', '', 'https://html5.gamemonetize.com/5q7pzlqbdiah4ouoc4okzx7j6z0cl05r/', 'html5', 960, 540, 1576076683, '1', '0'),
(831, 'gamemonetize-617', 'galactic-snakes-io', 'Galactic Snakes io', 'https://img.gamemonetize.com/ihir7go1fwhq6t97q8um1pm9t7brz7ui/512x384.jpg', '0', 2, 0, '0', 'Features • Addictive gameplay • Single player game mode', '', 'https://html5.gamemonetize.com/ihir7go1fwhq6t97q8um1pm9t7brz7ui/', 'html5', 960, 600, 1576076683, '1', '0'),
(832, 'gamemonetize-616', 'nadja-dressup', 'Nadja DressUp', 'https://img.gamemonetize.com/sxb3mif2mqg5knie5hk33ka6mhaks8lk/512x384.jpg', '0', 1, 0, '0', 'Nadja Dressup is a great game for girls. Nadja is invited for a Model Party and she has to pick out the perfect outfit! Nadja has to look phenomenal in this unique fashion event!', '', 'https://html5.gamemonetize.com/sxb3mif2mqg5knie5hk33ka6mhaks8lk/', 'html5', 800, 480, 1576076683, '1', '0'),
(833, 'gamemonetize-615', 'moto-beach-ride', 'Moto Beach Ride', 'https://img.gamemonetize.com/ddljm9ifjz5b2981mg0zdezc9az5od21/512x384.jpg', '0', 2, 0, '0', 'Moto Beach Ride is a great driving HTML5game. Moto Beach Ride is a driving platform HTML5game. Moto Beach Ride is a fun new side driving game, in which you will be attempting to reach the finish line of each level, as fast as you can while collecting gold coins. 8 levels and two different location, enjoy and good luck!', '', 'https://html5.gamemonetize.com/ddljm9ifjz5b2981mg0zdezc9az5od21/', 'html5', 1280, 720, 1576076683, '1', '0'),
(834, 'gamemonetize-614', 'bubble-shooter', 'Bubble Shooter', 'https://img.gamemonetize.com/wt1tfo8ol71fabn4cvsojilamtozjfqg/512x384.jpg', '0', 1, 0, '0', 'Bubble shooter is a puzzle HTML5 game . The goal of the game is to clear all the bubbles from the level avoiding any bubble crossing the bottom line.', '', 'https://html5.gamemonetize.com/wt1tfo8ol71fabn4cvsojilamtozjfqg/', 'html5', 870, 1504, 1576076683, '1', '0'),
(835, 'gamemonetize-613', 'fatboy-dream', 'Fatboy Dream', 'https://img.gamemonetize.com/05a5q9lx1lchneeh44ctqsn01jms7py8/512x384.jpg', '0', 1, 0, '0', 'FatBoy Dream is a HTML5 Skill Game. Jump from donuts to donuts and bounce on the walls to eat as many flying donuts as you can!', '', 'https://html5.gamemonetize.com/05a5q9lx1lchneeh44ctqsn01jms7py8/', 'html5', 1120, 1400, 1576076683, '1', '0'),
(836, 'gamemonetize-612', 'egg-jump-up', 'Egg Jump Up', 'https://img.gamemonetize.com/gxojejacccjh0ylcw2lhvhumuu27xuge/512x384.jpg', '0', 4, 0, '0', 'Control your colorful egg jumping up from nest to nest. Many challenges are waiting for you. Play now and have fun!', '', 'https://html5.gamemonetize.com/gxojejacccjh0ylcw2lhvhumuu27xuge/', 'html5', 540, 960, 1576076683, '1', '0'),
(837, 'gamemonetize-611', 'halloween-jigsaw-puzzle', 'Halloween Jigsaw Puzzle', 'https://img.gamemonetize.com/9gpps23egwb1v0ur83xmj252wpvx01pa/512x384.jpg', '0', 5, 0, '0', 'You love Jigsaw puzzles, you also love the Halloween holiday. So this game is dedicated to you. Play now and have fun!', '', 'https://html5.gamemonetize.com/9gpps23egwb1v0ur83xmj252wpvx01pa/', 'html5', 960, 540, 1576076683, '1', '0'),
(838, 'gamemonetize-610', 'spider-zombie', 'Spider Zombie', 'https://img.gamemonetize.com/g8tlvwrxvemrej3tr07do4jnmqyeolw5/512x384.jpg', '0', 5, 0, '0', 'Spider Zombie is a challenging game with a lot of levels to play. Swing your Spider-zombie by shooting spider web to avoid the obstacles, keep as many as possible its body-parts and reach the destination to be fully restored. PLAY NOW!', '', 'https://html5.gamemonetize.com/g8tlvwrxvemrej3tr07do4jnmqyeolw5/', 'html5', 960, 540, 1576076683, '1', '0'),
(839, 'gamemonetize-609', 'monster-color-match', 'Monster Color Match', 'https://img.gamemonetize.com/zy4153mttoq6anpy0m8s1q1kigk3lxrl/512x384.jpg', '0', 5, 0, '0', 'Monster Color Match is a match-3 type game, match-3 is a popular type of casual puzzle game. The objective of Monster Color Match is to swap one monster with an adjacent monster to form a horizontal or vertical chain of three or more jewels of the same color.', '', 'https://html5.gamemonetize.com/zy4153mttoq6anpy0m8s1q1kigk3lxrl/', 'html5', 600, 1166, 1576076683, '1', '0'),
(840, 'gamemonetize-608', 'mad-taxi-driver', 'Mad Taxi Driver', 'https://img.gamemonetize.com/3cl3sjguql2ahb5g4jfbrv813d3ks5uw/512x384.jpg', '0', 2, 0, '0', 'Mad Taxi Driver is a great HTML5 racing game. Drive your cab and stay a live. Pick up nitro and fuel to make your drive longer. Drive or die…. Good luck!', '', 'https://html5.gamemonetize.com/3cl3sjguql2ahb5g4jfbrv813d3ks5uw/', 'html5', 720, 1280, 1576076683, '1', '0'),
(841, 'gamemonetize-607', 'zombie-shooter', 'Zombie Shooter', 'https://img.gamemonetize.com/lolhh3h0uzznxupsi0atxz6tk6mfis94/512x384.jpg', '0', 3, 0, '0', 'Zombie Shooter – a super cool game in which you must kill all the zombies, direct hits of bullets, as well as the rebound! Share what you’re capable of and destroy all the zombies as fast as possible!', '', 'https://html5.gamemonetize.com/lolhh3h0uzznxupsi0atxz6tk6mfis94/', 'html5', 800, 600, 1576076683, '1', '0'),
(842, 'gamemonetize-606', 'flappy-talking-tom', 'Flappy Talking Tom', 'https://img.gamemonetize.com/fdqes0v8cszbsepgq0wqoqh6eqhgpkk4/512x384.jpg', '0', 1, 0, '0', 'Flappy Talking Tom is an online game that you can play for free. You may have played the classic game Flappy Bird, it must have left a deep impression on you. Today, our protagonist is replaced by a cute Talking Tom. Using the mouse to tap the screen to control Tom&#039;s movement, you must avoid all dangerous obstacles and try to reach further distances. Have fun playing.', '', 'https://html5.gamemonetize.com/fdqes0v8cszbsepgq0wqoqh6eqhgpkk4/', 'html5', 480, 854, 1576076683, '1', '0'),
(843, 'gamemonetize-605', 'spider-robot-warrior-web-robot-spider', 'Spider Robot Warrior Web Robot Spider', 'https://img.gamemonetize.com/iz2dkzm8jpldf7zn8c6avb70c2yzv8ke/512x384.jpg', '0', 1, 0, '0', 'Dare To Play Future Web Robot Spider Game City survival rescue mission Futuristic robots war &amp; Mutant Spider war practice! Robot missions after transforming robot games Futuristic Robot Transformation in real Spider &amp; evil spider robot warrior Spider Climb &amp; transforming Robot Shooting Missions.', '', 'https://html5.gamemonetize.com/iz2dkzm8jpldf7zn8c6avb70c2yzv8ke/', 'html5', 900, 600, 1576076683, '1', '0')";
$db[25] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(844, 'gamemonetize-604', 'waterpark-io', 'Waterpark.io', 'https://img.gamemonetize.com/2kfsm145vayydl23ldlbrdc7y22fv08y/512x384.jpg', '0', 1, 0, '0', 'No more Aquparks try Waterpark.io! Reach to the end of the water slide, try to be the first. Bump other players during the race and have fun playing this colorful and sunny water slide game.', '', 'https://html5.gamemonetize.com/2kfsm145vayydl23ldlbrdc7y22fv08y/', 'html5', 800, 600, 1576076683, '1', '0'),
(845, 'gamemonetize-603', 'klondike', 'Klondike', 'https://img.gamemonetize.com/ex9kt08rb3kt32mfd6e16alzlj1gqu34/512x384.jpg', '0', 5, 0, '0', 'Klondike Solitaire is a HTML5 Game. Enjoy this stylish version of the classic Klondike Solitaire!', '', 'https://html5.gamemonetize.com/ex9kt08rb3kt32mfd6e16alzlj1gqu34/', 'html5', 1600, 768, 1576076683, '1', '0'),
(846, 'gamemonetize-602', 'relic-runway', 'Relic Runway', 'https://img.gamemonetize.com/ralnzjj3b624rjg6a31vl3m7tz7p8tf0/512x384.jpg', '0', 5, 0, '0', 'Are you ready for crazy adventures? Run as far as you can, collect coins and upgrade useful bonuses, pick up relic parts to discover ancient artifacts, break idols to unlock amazing characters, and compete with your friends to be the best relic runner!', '', 'https://html5.gamemonetize.com/ralnzjj3b624rjg6a31vl3m7tz7p8tf0/', 'html5', 800, 600, 1576076683, '1', '1'),
(847, 'gamemonetize-601', 'skate-hooligans', 'Skate Hooligans', 'https://img.gamemonetize.com/vy07es6s71vci1su3wzcqrp7e3ym0vtw/512x384.jpg', '0', 5, 0, '0', 'Cowabunga! Little hooligans are on the way! Choose your hero and arrange an amazing disorder ^_^ Collect coins, upgrade bonuses, buy cool skateboards, avoid dangerous obstacles and get scores as much as you can.', '', 'https://html5.gamemonetize.com/vy07es6s71vci1su3wzcqrp7e3ym0vtw/', 'html5', 800, 600, 1576076683, '1', '1'),
(848, 'gamemonetize-600', 'gap-ball-3d', 'Gap Ball 3D', 'https://img.gamemonetize.com/ow6e89ecj2nbn0po5p6frf9h2pu7laka/512x384.jpg', '0', 5, 0, '0', 'Gap Ball 3D features: - multiple levels - simple gameplay', '', 'https://html5.gamemonetize.com/ow6e89ecj2nbn0po5p6frf9h2pu7laka/', 'html5', 960, 600, 1576076683, '1', '0'),
(849, 'gamemonetize-599', 'top-shootout-the-pirate-ship', 'Top Shootout: The Pirate Ship', 'https://img.gamemonetize.com/bilg6x7fqqeq6rswg8dsz0qu4b7zignt/512x384.jpg', '0', 5, 0, '0', 'Ahoy! An old pirate ship full of golden treasures and beautiful hostages sails in the Caribbean Sea. Reload your cannon to defeat all pirates and get scores as much as you can in amazing Top Shootout!', '', 'https://html5.gamemonetize.com/bilg6x7fqqeq6rswg8dsz0qu4b7zignt/', 'html5', 800, 600, 1576076683, '1', '0'),
(850, 'gamemonetize-598', 'top-shootout-the-saloon', 'Top Shootout: The Saloon', 'https://img.gamemonetize.com/ura5go5y2lqurlc6zalyt1wm3jocax35/512x384.jpg', '0', 5, 0, '0', 'Become the best shooter in Wild West ever! Evil bandits kidnapped hostages and are keeping them in The Saloon. Only you can save them! Reload your gun and shoot up all bandits with their bosses!', '', 'https://html5.gamemonetize.com/ura5go5y2lqurlc6zalyt1wm3jocax35/', 'html5', 800, 600, 1576076683, '1', '0'),
(851, 'gamemonetize-597', 'yeti-sensation', 'Yeti Sensation', 'https://img.gamemonetize.com/ieco9m12x4vrouir7ytnupfddkucj1u2/512x384.jpg', '0', 5, 0, '0', 'OH NOOO! Bigfoot wanted! Help embarrassed Yeti to find a way to his new home, avoid sly snowmen, dangerous traps and other obstacles, buy new boosts in the supermarket and run away as further as possible.', '', 'https://html5.gamemonetize.com/ieco9m12x4vrouir7ytnupfddkucj1u2/', 'html5', 800, 600, 1576076683, '1', '1'),
(852, 'gamemonetize-596', 'halloween-differences', 'Halloween Differences', 'https://img.gamemonetize.com/msuwmh3490ah40f6d9du3avvh63fonwa/512x384.jpg', '0', 5, 0, '0', 'Now, it&#039;s a Halloween, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same. Enjoy the Halloween holiday!', '', 'https://html5.gamemonetize.com/msuwmh3490ah40f6d9du3avvh63fonwa/', 'html5', 960, 540, 1576076683, '1', '0'),
(853, 'gamemonetize-595', 'king-of-drag', 'King of Drag', 'https://img.gamemonetize.com/4091aham5ij3pnfqpi048oha5d7ob2tg/512x384.jpg', '0', 2, 0, '0', 'Great racing game with 5 levels and 10 differents supercars. Drive the best vehicles in the world and beat your opponent. Win all cups and become King of Drag!', '', 'https://html5.gamemonetize.com/4091aham5ij3pnfqpi048oha5d7ob2tg/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(854, 'gamemonetize-594', 'koby-jump-escape', 'Koby Jump Escape', 'https://img.gamemonetize.com/c6rh35iz1jhzonwhxomyseq46gpxu2a6/512x384.jpg', '0', 4, 0, '0', 'Koby Jump Escape is a great HTML5 platform game. Help Koby to escape from prison. On every level you need to pickup the 3 money bags to unlock the door. This prison have 13 levels. Good luck!', '', 'https://html5.gamemonetize.com/c6rh35iz1jhzonwhxomyseq46gpxu2a6/', 'html5', 1280, 720, 1576076683, '1', '0'),
(855, 'gamemonetize-593', 'king-way', 'King Way', 'https://img.gamemonetize.com/7ll8dxj2iywfsgw5i0hpy9gvrajzcc5j/512x384.jpg', '0', 4, 0, '0', 'Your job is to guide the charismatic King through 28 levels, in search of all cheeses scattered throughout the stages! Use the propeller to move the balloon that holds King&#039;s body around the screen, being careful of obstacles.', '', 'https://html5.gamemonetize.com/7ll8dxj2iywfsgw5i0hpy9gvrajzcc5j/', 'html5', 854, 480, 1576076683, '1', '0'),
(856, 'gamemonetize-592', 'queen-mal-mistress-of-evil', 'Queen Mal Mistress of Evil', 'https://img.gamemonetize.com/xswyt4h7o3b1yfzezb1xv73uftke6bu4/512x384.jpg', '0', 1, 0, '0', 'Among the marshy swamps lives a fairy with incredible beauty and power. Her name is Mal. She is the queen of those places and the protector of the magical kingdom. Queen Mal can be kind or furious if angry with her. Create your own image for the fairies, use unusual makeup and hairstyles. Mal&#039;s wardrobe has long black dresses with decor, cloaks and capes. Do not forget the magic accessories and staff.', '', 'https://html5.gamemonetize.com/xswyt4h7o3b1yfzezb1xv73uftke6bu4/', 'html5', 800, 600, 1576076683, '1', '0'),
(857, 'gamemonetize-591', 'shoot-up', 'Shoot Up!', 'https://img.gamemonetize.com/hkbbi8hgfx3kbyqth0wwf5gmm7sxyutg/512x384.jpg', '0', 8, 0, '0', 'Shoot Up is a sport soccer games. Try to score so many goals. You can miss only tree times. Beat you friends and be the best penalty taker in the world!', '', 'https://html5.gamemonetize.com/hkbbi8hgfx3kbyqth0wwf5gmm7sxyutg/', 'html5', 720, 1280, 1576076683, '1', '0'),
(858, 'gamemonetize-590', 'scary-faces-jigsaw', 'Scary Faces Jigsaw', 'https://img.gamemonetize.com/ub3l1pa9nn48nuctoe0b4lj8hs1k97c4/512x384.jpg', '0', 5, 0, '0', 'There are a lot of scary faces here. In this game you have a total of 12 jigsaw puzzles. You need to start from the first one and to unlock the next image. You have three modes for each picture: Easy with 25 pieces, Medium with 49 pieces and Hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/ub3l1pa9nn48nuctoe0b4lj8hs1k97c4/', 'html5', 960, 540, 1576076683, '1', '0'),
(859, 'gamemonetize-589', 'hit-the-glow', 'Hit The Glow', 'https://img.gamemonetize.com/goevxom0jwk4a00mam7ym2pucp7ppas5/512x384.jpg', '0', 4, 0, '0', 'Hit The Glow is a tap based casual game to make it interesting we have added neon graphics and glowy particles With 4 Different modes its has 60 levels Just tap on screen to throw glowy ball and hit the circle to clear levels Each mode has 15 levels. CLASSIC ELEMINATE EXPAND ORIGIN Tap to hit the red target and start playing HIT THE GLOW!', '', 'https://html5.gamemonetize.com/goevxom0jwk4a00mam7ym2pucp7ppas5/', 'html5', 640, 1136, 1576076683, '1', '0'),
(860, 'gamemonetize-588', 'city-hero', 'City Hero', 'https://img.gamemonetize.com/gsztwbaia8dpr7sx1r2xpokxcmm4u2nb/512x384.jpg', '0', 3, 0, '0', 'City Hero is a HTML5 action-shooting game. You action hero is got a assignment to save the city. Alians and demons attack the city and you need to save them. Be fast, be carefull shoot enemies and save the city. Good luck!', '', 'https://html5.gamemonetize.com/gsztwbaia8dpr7sx1r2xpokxcmm4u2nb/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(861, 'gamemonetize-587', 'fun-animals-jigsaw', 'Fun Animals Jigsaw', 'https://img.gamemonetize.com/ucg1invtw4b7011xer6fuq0l3gn0uump/512x384.jpg', '0', 5, 0, '0', 'Fun Animals Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/ucg1invtw4b7011xer6fuq0l3gn0uump/', 'html5', 960, 540, 1576076683, '1', '0'),
(862, 'gamemonetize-586', 'animal-kingdom-match-3', 'Animal Kingdom Match 3', 'https://img.gamemonetize.com/k1juve7czlhecit6764d2n7xcxely3xj/512x384.jpg', '0', 5, 0, '0', 'Animal Kingdom Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful summer style! Enjoy the game!', '', 'https://html5.gamemonetize.com/k1juve7czlhecit6764d2n7xcxely3xj/', 'html5', 800, 600, 1576076683, '1', '0'),
(863, 'gamemonetize-585', 'gummy-blocks-evolution', 'Gummy Blocks Evolution', 'https://img.gamemonetize.com/v687jtx9x8wbov754bhkwd14e3wehu6c/512x384.jpg', '0', 5, 0, '0', 'Drop the cubes to create or destroy full lines on the screen, both vertical and horizontal. Get great power-up destroying 2 or more lines at the same time!', '', 'https://html5.gamemonetize.com/v687jtx9x8wbov754bhkwd14e3wehu6c/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(864, 'gamemonetize-584', 'adjust-in-the-wall', 'Adjust in the wall', 'https://img.gamemonetize.com/dbud50ke9q9shey3p02d46w0ba21r5x4/512x384.jpg', '0', 5, 0, '0', 'Adjust in the wall is a timing reflexive game, you need to move the free block to the correct position before it hits the wall. There is only one correct position for this block so there will be no mistakes allowed. Good Luck', '', 'https://html5.gamemonetize.com/dbud50ke9q9shey3p02d46w0ba21r5x4/', 'html5', 960, 540, 1576076683, '1', '0'),
(865, 'gamemonetize-583', '3d-royale', '3D Royale', 'https://img.gamemonetize.com/cbzh1wb86rgapi9wu8td5f2e0qawy47b/512x384.jpg', '0', 3, 0, '0', 'Try to defeat all of the other players in this action packed 3d battle royale game. try to be the last player standing as you aim and shoot your competition.', '', 'https://html5.gamemonetize.com/cbzh1wb86rgapi9wu8td5f2e0qawy47b/', 'html5', 800, 600, 1576076683, '1', '0'),
(866, 'gamemonetize-582', 'army-shooter', 'Army Shooter', 'https://img.gamemonetize.com/vkn2hkckik6sds43gk4rg0w7l7l6y3ut/512x384.jpg', '0', 3, 0, '0', 'Features: • 2 game modes • Multiple weapons to use • Good graphics', '', 'https://html5.gamemonetize.com/vkn2hkckik6sds43gk4rg0w7l7l6y3ut/', 'html5', 960, 600, 1576076683, '1', '0'),
(867, 'gamemonetize-581', 'halloween-multiplayer-shooter', 'Halloween Multiplayer Shooter', 'https://img.gamemonetize.com/hwj7rp3qy9x19oc7jg4mehw8oqdlfbrw/512x384.jpg', '0', 3, 0, '0', 'Features • Multiplayer or single-player gameplay • Multiple game modes • In-game weapons and armor shop', '', 'https://html5.gamemonetize.com/hwj7rp3qy9x19oc7jg4mehw8oqdlfbrw/', 'html5', 960, 600, 1576076683, '1', '0'),
(868, 'gamemonetize-580', 'count-the-animals', 'Count The Animals', 'https://img.gamemonetize.com/u5necgcnxpou2380jgvbg1l5jnxrg3cb/512x384.jpg', '0', 5, 0, '0', 'In this game you need to count the animals that was on the picture. click on the animals shown in the picture, and try to find all the animals of the same species. If sometimes some animal miss, you can click on help button. Remember you can click only five times in help button. Start to play and enjoy. Learn the animals with fun.', '', 'https://html5.gamemonetize.com/u5necgcnxpou2380jgvbg1l5jnxrg3cb/', 'html5', 1366, 768, 1576076683, '1', '0'),
(869, 'gamemonetize-579', 'jelly-way', 'Jelly Way', 'https://img.gamemonetize.com/0rswe06d8noqwclw69mos9wl7shxoo1p/512x384.jpg', '0', 5, 0, '0', 'Jelly Way is a great platform HTML5game. Jelly has lost in the sunny day. You need to help him to get out of there. You need to collect 3 keys on the stage and find his way out. You need to past 6 levels. To control Jelly use arrows keys, you need to take a look on enemies and find way to avoid them. Good luck and enjoy!', '', 'https://html5.gamemonetize.com/0rswe06d8noqwclw69mos9wl7shxoo1p/', 'html5', 1136, 640, 1576076683, '1', '0'),
(870, 'gamemonetize-578', 'jelly-smash', 'Jelly Smash', 'https://img.gamemonetize.com/8hvbqxquhg9dqzl6p1c7mv1it472fjsn/512x384.jpg', '0', 5, 0, '0', 'In the Jelly world, only one can stay. You represent the blue one. Can blue jelly win? Dripping the jelly with it tactically enough, you may cause a perfect splashing chain reaction! So prepare your brains, ‘cause there’s some jelly busting to be done!', '', 'https://html5.gamemonetize.com/8hvbqxquhg9dqzl6p1c7mv1it472fjsn/', 'html5', 480, 800, 1576076683, '1', '0'),
(871, 'gamemonetize-577', 'jigsaw-puzzle', 'Jigsaw Puzzle', 'https://img.gamemonetize.com/c8klq1jp816a8gfru7lqgib5q8udk92x/512x384.jpg', '0', 5, 0, '0', 'Enjoy a beautiful Moscow while playing the Jigsaw Puzzle. There are many customizable grid sizes for you to try. Play now!', '', 'https://html5.gamemonetize.com/c8klq1jp816a8gfru7lqgib5q8udk92x/', 'html5', 960, 540, 1576076683, '1', '0'),
(872, 'gamemonetize-576', '4-pics-1-word', '4 Pics 1 Word', 'https://img.gamemonetize.com/ph4p0k5n7f02bqszejqfmew979y6oq3e/512x384.jpg', '0', 5, 0, '0', '4 Pics 1 Word - HTML5 games. Can you guess the words and unlock the next level? Countless puzzles from easy to tricky are waiting for you! Which word are we looking for? Look at the four pictures; find out what they have in common. Win! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/ph4p0k5n7f02bqszejqfmew979y6oq3e/', 'html5', 800, 600, 1576076683, '1', '0'),
(873, 'gamemonetize-575', 'the-best-pizza', 'The Best Pizza', 'https://img.gamemonetize.com/ei5ni6td9yd7nfb2hy53deosl36qpga4/512x384.jpg', '0', 1, 0, '0', 'Step by step cooking with 6 different types of pizza', '', 'https://html5.gamemonetize.com/ei5ni6td9yd7nfb2hy53deosl36qpga4/', 'html5', 640, 1020, 1576076683, '1', '0'),
(874, 'gamemonetize-574', 'cartoon-truck-jigsaw', 'Cartoon Truck Jigsaw', 'https://img.gamemonetize.com/ulryv0519rrgsa8wgy18y199tup7yfas/512x384.jpg', '0', 5, 0, '0', 'Let&#039;s play our new jigsaw puzzle game called Cartoon Truck Jigsaw. You can select one of the twelve images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/ulryv0519rrgsa8wgy18y199tup7yfas/', 'html5', 1280, 720, 1576076683, '1', '0'),
(875, 'gamemonetize-573', 'princess-curse', 'Princess Curse', 'https://img.gamemonetize.com/atohoxwe3qvt1sdiy6ivlfowm7ukfxtq/512x384.jpg', '0', 1, 0, '0', 'Save the Princess from the curse of the witch Step by step caring, makeup, and dress up.', '', 'https://html5.gamemonetize.com/atohoxwe3qvt1sdiy6ivlfowm7ukfxtq/', 'html5', 640, 1020, 1576076683, '1', '0'),
(876, 'gamemonetize-572', 'baby-bear', 'Baby Bear', 'https://img.gamemonetize.com/pyn3enzw6oodp9qpmwh7r6equh9uc732/512x384.jpg', '0', 1, 0, '0', 'Step by step caring a baby bear with 4 different levels.', '', 'https://html5.gamemonetize.com/pyn3enzw6oodp9qpmwh7r6equh9uc732/', 'html5', 640, 1020, 1576076683, '1', '0'),
(877, 'gamemonetize-571', 'panda-hairdo', 'Panda Hairdo', 'https://img.gamemonetize.com/sijsw3kl4g7ddlrt9k8iq02oo74snzpg/512x384.jpg', '0', 1, 0, '0', 'Tidy up your hair, step by step in Panda Hairdo', '', 'https://html5.gamemonetize.com/sijsw3kl4g7ddlrt9k8iq02oo74snzpg/', 'html5', 1020, 640, 1576076683, '1', '0'),
(878, 'gamemonetize-570', 'racing-cartoons-jigsaw', 'Racing Cartoons Jigsaw', 'https://img.gamemonetize.com/2m70kx8f3zfhtq3dj26dt0o7qo6shysj/512x384.jpg', '0', 5, 0, '0', 'In this kids jigsaw game you can play with cartoon racing images from popular cartoons. Choose one of twelve image and start to play. Choose which mode you want to play and start to solve this puzzle. Put the pieces into right position to get the image with racing cartoons.', '', 'https://html5.gamemonetize.com/2m70kx8f3zfhtq3dj26dt0o7qo6shysj/', 'html5', 1280, 720, 1576076683, '1', '0'),
(879, 'gamemonetize-569', 'formula-drag', 'Formula Drag', 'https://img.gamemonetize.com/ffm89tjt2n2ngdf1hojgbitrcbxkijoy/512x384.jpg', '0', 2, 0, '0', 'Drive Formula the best you can. 4 different formula bolids in this skill game. Use your finger to control formula in this great drifting game. Stay on track and make best resault.', '', 'https://html5.gamemonetize.com/ffm89tjt2n2ngdf1hojgbitrcbxkijoy/', 'html5', 720, 1280, 1576076683, '1', '0'),
(880, 'gamemonetize-568', 'fz-halloween-memory', 'FZ Halloween Memory', 'https://img.gamemonetize.com/n2ulafarnb3favcqpczwrwbb7wk3kd18/512x384.jpg', '0', 5, 0, '0', 'FZ Halloween Memory is -HTML5 games. Just use your brain and your skill to play game. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/n2ulafarnb3favcqpczwrwbb7wk3kd18/', 'html5', 800, 600, 1576076683, '1', '0'),
(881, 'gamemonetize-567', 'fun-airplanes-jigsaw', 'Fun Airplanes Jigsaw', 'https://img.gamemonetize.com/fpqizqdzivbdtqkzhovnqrwjljtqe46t/512x384.jpg', '0', 5, 0, '0', 'Fun Airplanes Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/fpqizqdzivbdtqkzhovnqrwjljtqe46t/', 'html5', 960, 540, 1576076683, '1', '0'),
(882, 'gamemonetize-566', 'crazy-halloween-memory', 'Crazy Halloween Memory', 'https://img.gamemonetize.com/ay6g70kku4uiyeeifmu5rx6rhssj84bj/512x384.jpg', '0', 5, 0, '0', 'Crazy Halloween Memory is a free online game from genre of memory and monsters games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/ay6g70kku4uiyeeifmu5rx6rhssj84bj/', 'html5', 960, 540, 1576076683, '1', '0'),
(883, 'gamemonetize-565', 'stickman-adventure-prison-jail-break-mission', 'Stickman Adventure Prison Jail Break Mission', 'https://img.gamemonetize.com/4vs00umh3emfy9v3syh3lfl8o7oqxiv1/512x384.jpg', '0', 9, 0, '0', 'Stickman Adventure: Prison Jail Break Mission is a league of legendary stickman games and is rated among our best rpg games parkour stickman adventure fights. Take on the challenge of become the highest rated stickman fighting legends fighter games. Prison Jail Break Mission is your main and primary mission in this parkour stickman adventure', '', 'https://html5.gamemonetize.com/4vs00umh3emfy9v3syh3lfl8o7oqxiv1/', 'html5', 900, 600, 1576076683, '1', '0'),
(884, 'gamemonetize-564', 'kiko-adventure', 'Kiko Adventure', 'https://img.gamemonetize.com/je6fcm2a5rfdv8wectle5e5j6ekh0eqk/512x384.jpg', '0', 1, 0, '0', 'Kiko Adventure is adventure platformer games on HTML5, If you enjoy platform games you shouldn’t miss this. Easy to pick up and play thanks to simple controls. Journey through beautifuly designed levels, try to find all fruit and bottles, jump and defeat dangerous enemy.', '', 'https://html5.gamemonetize.com/je6fcm2a5rfdv8wectle5e5j6ekh0eqk/', 'html5', 800, 600, 1576076683, '1', '0'),
(885, 'gamemonetize-563', 'minecraft-coin-adventure', 'Minecraft Coin Adventure', 'https://img.gamemonetize.com/77o5y1zxeta7jybiwoqfcuvia41p96lh/512x384.jpg', '0', 5, 0, '0', 'Minecraft Coin Adventure is fun html5 game and you can play it online for free. The rules are simple, just get the coin on the coin area on the platform. Cut the rope and start playing. Have fun!', '', 'https://html5.gamemonetize.com/77o5y1zxeta7jybiwoqfcuvia41p96lh/', 'html5', 960, 640, 1576076683, '1', '1'),
(886, 'gamemonetize-562', 'tetris-master', 'Tetris Master', 'https://img.gamemonetize.com/ltduz40mntvpvyzu8k5esh0oxobppyma/512x384.jpg', '0', 5, 0, '0', 'Once you start it, you won&#039;t stop ! Classic tetris game! The classic retro Tetris game that we all love! Play on mobile and PC.', '', 'https://html5.gamemonetize.com/ltduz40mntvpvyzu8k5esh0oxobppyma/', 'html5', 800, 600, 1576076683, '1', '0'),
(887, 'gamemonetize-561', 'ragdoll-warriror', 'Ragdoll Warriror', 'https://img.gamemonetize.com/ft3hwzfkxzn9cjv6mpi136r3z4st5jck/512x384.jpg', '0', 4, 0, '0', 'Ragdoll Warrior - is an imposing stickman game, stickman warriors fighting game where you an unleash your anger at waves of enemy stickmen. In order to win and survive you will have to fight to the last drop of your blood. Show you warrior skills to become a winner in unequal battles.', '', 'https://html5.gamemonetize.com/ft3hwzfkxzn9cjv6mpi136r3z4st5jck/', 'html5', 800, 600, 1576076683, '1', '0'),
(888, 'gamemonetize-560', 'offroad-grand-monster-truck-hill-drive', 'Offroad Grand Monster Truck Hill Drive', 'https://img.gamemonetize.com/ewvcg6bnaoh3lcsaijttdxfmnvc48i1m/512x384.jpg', '0', 2, 0, '0', 'If yes then wait is over! We bring an amazing best offroad truck game for you which will be totally based on real physics 4x4 racing. You never drive the hill climb truck before so pick up the opportunity and become an expert driver of hill racing monster truck offroad. To do hill driving you can select heavy engine vehicles from the garage in this monster derby truck racing game.', '', 'https://html5.gamemonetize.com/ewvcg6bnaoh3lcsaijttdxfmnvc48i1m/', 'html5', 960, 640, 1576076683, '1', '0'),
(889, 'gamemonetize-559', '3d-amazing-volleyball', '3D Amazing VolleyBall', 'https://img.gamemonetize.com/sp8uqffvsvmc7vm2ksalhzrm1cbh4iqw/512x384.jpg', '0', 8, 0, '0', 'Over 100 levels to master with more updated weekly Simple to learn yet hard to conquer One-finger control Lots of rewards and upgrades, you will get addicted Beautiful graphics and funny animations Collect varieties of strong athletes', '', 'https://html5.gamemonetize.com/sp8uqffvsvmc7vm2ksalhzrm1cbh4iqw/', 'html5', 450, 750, 1576076683, '1', '0'),
(890, 'gamemonetize-558', 'mulan-s-magic-makeove-r', 'Mulan&#039;s Magic Makeove﻿r', 'https://img.gamemonetize.com/1a4fc5wjfzmrwia2scg5ryguo74s3rb4/512x384.jpg', '0', 1, 0, '0', 'Help Mulan to become a cool city girl. Teach the princess how to apply makeup properly using foundation, concealer, concealer and powder. Emphasize the cheekbones of the girl with rosy lips, and highlight her lipstick. False eyelashes and eye shadow - will help to emphasize the eyes. Mulan can use contact lenses - to change the usual eye color. Experiment!', '', 'https://html5.gamemonetize.com/1a4fc5wjfzmrwia2scg5ryguo74s3rb4/', 'html5', 800, 600, 1576076683, '1', '0'),
(891, 'gamemonetize-557', 'four-colors', 'Four Colors', 'https://img.gamemonetize.com/zl8zf8x70yomf85nmarbn02urgsrrg6q/512x384.jpg', '0', 5, 0, '0', 'Four Colors is a HTML5 Card Games. Face up to 3 computer-controlled opponents. Match cards by color or number, play action cards to mix the game up and be the first to get rid of all cards. Last but not least: Do not forget to press the 1 button when you have only one card left!', '', 'https://html5.gamemonetize.com/zl8zf8x70yomf85nmarbn02urgsrrg6q/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(892, 'gamemonetize-556', 'caveman-hunt', 'caveman hunt', 'https://img.gamemonetize.com/xvmb1520acwcg8nqdz13z5e7u7tho3yl/512x384.jpg', '0', 5, 0, '0', 'Jump as far as you can! The more meters you&#039;ll cross, the more coins you&#039;ll collect to buy special power-ups!', '', 'https://html5.gamemonetize.com/xvmb1520acwcg8nqdz13z5e7u7tho3yl/', 'html5', 1136, 832, 1576076683, '1', '0'),
(893, 'gamemonetize-555', 'hidden-sea-treasure', 'Hidden Sea Treasure', 'https://img.gamemonetize.com/n42y3baij59pcf9i7n6o7e79s8d0obdc/512x384.jpg', '0', 5, 0, '0', 'In this game called Hidden Sea Treasure that belong in genre of hidden objects games, you job is to find all nine hidden treasures in the image. We offer you six images and you need to pass all images to win in this game.', '', 'https://html5.gamemonetize.com/n42y3baij59pcf9i7n6o7e79s8d0obdc/', 'html5', 1280, 720, 1576076683, '1', '0'),
(894, 'gamemonetize-554', 'medieval-vikings-jigsaw', 'Medieval Vikings Jigsaw', 'https://img.gamemonetize.com/aa3zzw6yruh45av694z5xwf6mppbasgk/512x384.jpg', '0', 5, 0, '0', 'Medieval Vikings Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/aa3zzw6yruh45av694z5xwf6mppbasgk/', 'html5', 960, 540, 1576076683, '1', '0'),
(895, 'gamemonetize-553', 'happy-halloween-jigsaw', 'Happy Halloween Jigsaw', 'https://img.gamemonetize.com/m3s5tev78fh6d1xpbteuwqm6il34r9sd/512x384.jpg', '0', 5, 0, '0', 'Happy Halloween Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/m3s5tev78fh6d1xpbteuwqm6il34r9sd/', 'html5', 960, 540, 1576076683, '1', '0'),
(896, 'gamemonetize-552', 'shopkins-coloring-book', 'Shopkins Coloring Book', 'https://img.gamemonetize.com/tro315td7frqbm0ba8lvw8w4ioyhuuvn/512x384.jpg', '0', 5, 0, '0', 'Shopkins Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/tro315td7frqbm0ba8lvw8w4ioyhuuvn/', 'html5', 960, 540, 1576076683, '1', '0'),
(897, 'gamemonetize-551', 'halloween-match-3', 'Halloween Match 3', 'https://img.gamemonetize.com/wxj5iuqyy537z33digle2s3nugrwuzmr/512x384.jpg', '0', 5, 0, '0', 'Halloween Match 3 is a good match 3 games with 17 levels. In each level, you need to clear the dirty cells. Make a column or row of three or more color pets of the same type to make them disappears. Break all the dirty cells in time to complete.', '', 'https://html5.gamemonetize.com/wxj5iuqyy537z33digle2s3nugrwuzmr/', 'html5', 320, 420, 1576076683, '1', '0'),
(898, 'gamemonetize-550', 'monster-truck-way', 'Monster Truck Way', 'https://img.gamemonetize.com/5yzc15wjrepcx8x38585ehyhx471usj0/512x384.jpg', '0', 2, 0, '0', 'Monster Truck Madness is a driving platform HTML5game. Monster Truck Madness is a fun new side driving game, in which you will be attempting to reach the finish line of each level, as fast as you can while collecting gold coins. 8 levels and two different location, enjoy and good luck!', '', 'https://html5.gamemonetize.com/5yzc15wjrepcx8x38585ehyhx471usj0/', 'html5', 854, 600, 1576076683, '1', '0'),
(899, 'gamemonetize-549', 'ninja-action', 'Ninja Action', 'https://img.gamemonetize.com/eosyaqvgdxes13xsjukmpyneby2xexit/512x384.jpg', '0', 4, 0, '0', 'Play this awesome game &quot;Ninja Action&quot;. Who doesn&#039;t like Ninja? Are you familiar with the ninja technique? This one has gravity power. Tap to jump on platforms. Collect coins, magnet and 2X to make high scores. Lets start the game with ninja theme.', '', 'https://html5.gamemonetize.com/eosyaqvgdxes13xsjukmpyneby2xexit/', 'html5', 768, 1024, 1576076683, '1', '0'),
(900, 'gamemonetize-548', 'ice-biker', 'Ice Biker', 'https://img.gamemonetize.com/xkabkwa6tgq9rg5vxb75rbv22cb8184y/512x384.jpg', '0', 2, 0, '0', 'Ice Biker is a fun new side driving game, in which you will be attempting to reach the finish line of each level, as fast as you can while collecting gold coins. 8 levels and two different location, enjoy and good luck!', '', 'https://html5.gamemonetize.com/xkabkwa6tgq9rg5vxb75rbv22cb8184y/', 'html5', 1280, 720, 1576076683, '1', '0'),
(901, 'gamemonetize-547', 'halloween-puzzle-challenge', 'Halloween Puzzle Challenge', 'https://img.gamemonetize.com/rs2f89tskj7tj6dcdewch19tq41tfse6/512x384.jpg', '0', 5, 0, '0', 'Halloween Puzzle Challenge is fun halloween game suitable for all ages. Those who love and care about halloween will love this game. Choose one of the images and try to get all small pieces at the original spot. Test your skill and have fun playing. Happy Halloween!', '', 'https://html5.gamemonetize.com/rs2f89tskj7tj6dcdewch19tq41tfse6/', 'html5', 854, 480, 1576076683, '1', '0'),
(902, 'gamemonetize-546', 'halloween-connection', 'Halloween Connection', 'https://img.gamemonetize.com/pv2a79tstntt01fqwx36w7ds9qffcgc2/512x384.jpg', '0', 5, 0, '0', 'Halloween Connection is puzzle Match 3 game with a scary Halloween theme. In this game you have to connect 3 or more identical heads of scary faces. You have 30 levels to complete the task assigned to you at the bottom of the game. For a certain number of moves you need to connect a certain number of scary heads.', '', 'https://html5.gamemonetize.com/pv2a79tstntt01fqwx36w7ds9qffcgc2/', 'html5', 450, 800, 1576076683, '1', '0'),
(903, 'gamemonetize-545', 'paw-patrol-smash', 'Paw Patrol Smash', 'https://img.gamemonetize.com/b9md3iee30ig2iw3sm3t0l04yiy67zoj/512x384.jpg', '0', 5, 0, '0', 'Smash all balloons with paw Patrols Characters and earn points. But you are not allowed to smash Skye. If you smash Skye you will loose live. If you loose 3 lives, or smash Skye three times game will over. So , sometimes the paw patrols will be fast and you need to be careful.', '', 'https://html5.gamemonetize.com/b9md3iee30ig2iw3sm3t0l04yiy67zoj/', 'html5', 1280, 720, 1576076683, '1', '0'),
(904, 'gamemonetize-544', 'icezag', 'IceZag', 'https://img.gamemonetize.com/8bv6qcnyvcluieefd9fmxtvwbze24e2c/512x384.jpg', '0', 5, 0, '0', 'move as zig zag by clicking mouse, move to next , try to earn the highest score', '', 'https://html5.gamemonetize.com/8bv6qcnyvcluieefd9fmxtvwbze24e2c/', 'html5', 350, 500, 1576076683, '1', '0'),
(905, 'gamemonetize-543', 'tomatorunner', 'TomatoRunner', 'https://img.gamemonetize.com/6nsqzct0xcdls0vk8dwvdt48m1ckndyu/512x384.jpg', '0', 5, 0, '0', 'jump and advance when faced with obstacles or enemy', '', 'https://html5.gamemonetize.com/6nsqzct0xcdls0vk8dwvdt48m1ckndyu/', 'html5', 960, 600, 1576076683, '1', '0'),
(906, 'gamemonetize-542', 'rope-puzzle', 'Rope Puzzle', 'https://img.gamemonetize.com/gpje6y04dhkbic7a131nr21aihi0kam0/512x384.jpg', '0', 4, 0, '0', 'Use your finger to cut the rope and release the ball. Smash all cans to complete a level! Enjoy hundreds of handmade levels of this simple and fun arcade puzzle, wherever you are!', '', 'https://html5.gamemonetize.com/gpje6y04dhkbic7a131nr21aihi0kam0/', 'html5', 450, 800, 1576076683, '1', '0'),
(907, 'gamemonetize-541', 'challenge-of-the-zombies', 'Challenge Of The Zombies', 'https://img.gamemonetize.com/radhogctua5ytkv1xchgrmwl6ty1yyrp/512x384.jpg', '0', 3, 0, '0', 'Make bullet fly to shoot zombies! Challenge of the zombies is a physics-based shooting game where you fire super-bouncy bullets to eliminate all the zombies in each level. The goal is simple, all you have to do is kill the zombies with the least amount of bullets. You must aim carefully and make each bullet count', '', 'https://html5.gamemonetize.com/radhogctua5ytkv1xchgrmwl6ty1yyrp/', 'html5', 960, 640, 1576076683, '1', '0'),
(908, 'gamemonetize-540', 'king-of-the-hill', 'King Of The Hill', 'https://img.gamemonetize.com/w0r18bm1lphbv030c0ogn2ykpdiduvur/512x384.jpg', '0', 1, 0, '0', 'In spite of multitudinous attacks of mythical creatures Trawds, your duty is to protect the castle and your King! Choose one of medieval heroes and beat back monsters attacks by using special weapons and addition abilities of chosen hero. Some creatures may have hidden abilities so you always have to be vigilant! They can cause serious injury to you and the castle. Use an arsenal of each hero entirely.', '', 'https://html5.gamemonetize.com/w0r18bm1lphbv030c0ogn2ykpdiduvur/', 'html5', 960, 640, 1576076683, '1', '0'),
(909, 'gamemonetize-539', 'rope-hero', 'Rope Hero', 'https://img.gamemonetize.com/rzcrz15szqew7nks0p0c1dsknvwjzp9q/512x384.jpg', '0', 1, 0, '0', 'Сlimb the walls, jump on the roofs of buildings! Fulminant maneuvering strategy in the city! Fantastically enthralling gameplay!The gang of offenders appeared in the city and now they threaten entire population. Act as a defender of the people. Use weapons of high level to eliminate enemies. Become the most courageous and fearless hero! After all, soon as you are capable protect the city from offenders', '', 'https://html5.gamemonetize.com/rzcrz15szqew7nks0p0c1dsknvwjzp9q/', 'html5', 960, 640, 1576076683, '1', '0'),
(910, 'gamemonetize-538', 'fz-jet-halloween', 'FZ Jet Halloween', 'https://img.gamemonetize.com/t1vyevxewqg09nrc27k6aqgozx5w9x73/512x384.jpg', '0', 1, 0, '0', 'FZ Jet Halloween is HTML5 games, Jet Halloween, another Flappy game! In this game you control a flappy witch and like always, you have to tap the screen and avoid obstacles such spooky trees and hanging spiders as you move forward. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/t1vyevxewqg09nrc27k6aqgozx5w9x73/', 'html5', 800, 600, 1576076683, '1', '0'),
(911, 'gamemonetize-537', 'express-truck', 'Express Truck', 'https://img.gamemonetize.com/d3m0qgwv8vr5wvchkl2xa46cl7svdk6q/512x384.jpg', '0', 2, 0, '0', 'Express Truck is a driving game. Deliver some goods to destination. Drive through uneven terrain, be quick but careful and deliver the cargo for maximum points.', '', 'https://html5.gamemonetize.com/d3m0qgwv8vr5wvchkl2xa46cl7svdk6q/', 'html5', 1280, 720, 1576076683, '1', '0'),
(912, 'gamemonetize-536', 'chicken-jump', 'Chicken Jump', 'https://img.gamemonetize.com/62bt6tp9cce81ydipfb61nwzf5qa3cca/512x384.jpg', '0', 4, 0, '0', 'Chicken Jump is a casual game. In this gravity game you control chicken. Avoid obstales and run and jump on platforms. Be fast, collect diamonds and complete 12 levels. Good luck!', '', 'https://html5.gamemonetize.com/62bt6tp9cce81ydipfb61nwzf5qa3cca/', 'html5', 1280, 720, 1576076683, '1', '0'),
(913, 'gamemonetize-535', 'grave-drive', 'Grave Drive', 'https://img.gamemonetize.com/tj4s2evzli91ptk7jr3optwao8iwv7cp/512x384.jpg', '0', 2, 0, '0', 'Grave Drive is a driving platform HTML5game. Grave Drive is a fun new side driving game, in which you will be attempting to reach the finish line of each level, as fast as you can while collecting gold coins. 8 levels and two different location, enjoy and good luck!', '', 'https://html5.gamemonetize.com/tj4s2evzli91ptk7jr3optwao8iwv7cp/', 'html5', 1066, 600, 1576076683, '1', '0'),
(914, 'gamemonetize-534', 'green-chick-jump', 'Green Chick Jump', 'https://img.gamemonetize.com/cslrrgm6mwvmc76w9i79oub0si1laxdn/512x384.jpg', '0', 4, 0, '0', 'Green Chick Jump is a great run and jump game. Use mouse or finger on touch screen to jump with this little crazy chicken. After some time chick run faster and faster. Show us your skill and beat your friends. Good luck!', '', 'https://html5.gamemonetize.com/cslrrgm6mwvmc76w9i79oub0si1laxdn/', 'html5', 960, 540, 1576076683, '1', '0'),
(915, 'gamemonetize-533', 'your-queen-destiny', 'Your Queen Destiny', 'https://img.gamemonetize.com/ulk13r0ey45ofsq6hsavzpzv3sk1pk0k/512x384.jpg', '0', 1, 0, '0', 'Take the quiz and unlock good or bad wardrobe set for your Queen', '', 'https://html5.gamemonetize.com/ulk13r0ey45ofsq6hsavzpzv3sk1pk0k/', 'html5', 640, 1020, 1576076683, '1', '0'),
(916, 'gamemonetize-532', 'my-career-quiz', 'My Career Quiz', 'https://img.gamemonetize.com/l1bon0zntm3vzysujfoemw90flci2two/512x384.jpg', '0', 1, 0, '0', 'Find your career with this quiz! Dress up and be ready for your job.', '', 'https://html5.gamemonetize.com/l1bon0zntm3vzysujfoemw90flci2two/', 'html5', 640, 1020, 1576076683, '1', '0'),
(917, 'gamemonetize-531', 'jen-s-princess-potion', 'Jen&#039;s Princess Potion', 'https://img.gamemonetize.com/dpdzqjpnis2n5fhg6gn48i869i22ftrt/512x384.jpg', '0', 5, 0, '0', 'Help Jen to make a princess potion for her customer. Find ingredients in hidden object game, then mix and match the ingredients to unlock the right potion.', '', 'https://html5.gamemonetize.com/dpdzqjpnis2n5fhg6gn48i869i22ftrt/', 'html5', 1020, 640, 1576076683, '1', '0'),
(918, 'gamemonetize-530', 'cute-baby-contest', 'Cute baby contest', 'https://img.gamemonetize.com/9y9j3r6s1f3vhdy28w26c8lsp0wmum93/512x384.jpg', '0', 1, 0, '0', 'Dress-up your baby for the cutest contest!', '', 'https://html5.gamemonetize.com/9y9j3r6s1f3vhdy28w26c8lsp0wmum93/', 'html5', 1020, 64, 1576076683, '1', '0'),
(919, 'gamemonetize-529', 'hoho-s-cupcake-party', 'Hoho&#039;s Cupcake party', 'https://img.gamemonetize.com/m9kqhgtg2lmbvsv6ahkrdfqddb7246oq/512x384.jpg', '0', 1, 0, '0', 'Help hoho to serve the cupcakes for the party.', '', 'https://html5.gamemonetize.com/m9kqhgtg2lmbvsv6ahkrdfqddb7246oq/', 'html5', 640, 1020, 1576076683, '1', '0'),
(920, 'gamemonetize-528', 'hoho-s-burger-stacko', 'Hoho&#039;s Burger Stacko', 'https://img.gamemonetize.com/f34eykevaivg2dxypd1hexq5rimpugl9/512x384.jpg', '0', 1, 0, '0', 'Stack burger and serve it to the customer! Make a perfect stack to gain more money', '', 'https://html5.gamemonetize.com/f34eykevaivg2dxypd1hexq5rimpugl9/', 'html5', 640, 1020, 1576076683, '1', '0'),
(921, 'gamemonetize-527', 'soccer-match-3', 'Soccer Match 3', 'https://img.gamemonetize.com/p6pbvd1vvpsufpjvpgpurz6vrgm2ovad/512x384.jpg', '0', 1, 0, '0', 'Soccer Match 3 is a free online game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful colorful style! Enjoy the game!', '', 'https://html5.gamemonetize.com/p6pbvd1vvpsufpjvpgpurz6vrgm2ovad/', 'html5', 1280, 720, 1576076683, '1', '0'),
(922, 'gamemonetize-526', 'gumball-and-friends-memory', 'Gumball and Friends Memory', 'https://img.gamemonetize.com/mvsqirp2xd3ntiz11endujt2zblvpxwc/512x384.jpg', '0', 5, 0, '0', 'Gumball and Friends Memory is a free online game from genre of memory and kids games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/mvsqirp2xd3ntiz11endujt2zblvpxwc/', 'html5', 960, 540, 1576076683, '1', '0'),
(923, 'gamemonetize-525', 'warship', 'Warship', 'https://img.gamemonetize.com/33cgd9epvx851xp61rakm2fu8kar43s7/512x384.jpg', '0', 3, 0, '0', 'Enter the battlefield with the strongest warship you have. Defeat the enemies and complete the challenges.', '', 'https://html5.gamemonetize.com/33cgd9epvx851xp61rakm2fu8kar43s7/', 'html5', 1020, 640, 1576076683, '1', '0'),
(924, 'gamemonetize-524', 'airport-clash-3d', 'Airport Clash 3D', 'https://img.gamemonetize.com/zva6r0xr0cnux7dink8zpiy3a1ny0dqz/512x384.jpg', '0', 3, 0, '0', 'Lead the Bloodhounds raider gang to capture an important abandoned airport location from a rival gang, the Vipers. Unleash the power and rage of a heavy military minigun and deliver the final blow to enemy goons by nuking their base with a big MF bomb.', '', 'https://html5.gamemonetize.com/zva6r0xr0cnux7dink8zpiy3a1ny0dqz/', 'html5', 1000, 562, 1576076683, '1', '0'),
(925, 'gamemonetize-523', 'talking-tom-hidden-stars', 'Talking Tom Hidden Stars', 'https://img.gamemonetize.com/wt0kf7udw1rrw1dkl7ul9as511fzzscw/512x384.jpg', '0', 5, 0, '0', 'Talking Tom Hidden Stars is a free online kids and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/wt0kf7udw1rrw1dkl7ul9as511fzzscw/', 'html5', 1280, 720, 1576076683, '1', '0'),
(926, 'gamemonetize-522', 'police-car-parking', 'Police Car Parking', 'https://img.gamemonetize.com/tzbem5c34y86kkvhl20qrkls1cs9c256/512x384.jpg', '0', 2, 0, '0', 'This is a crazy police car parking, simulator and simulation game. The police car is back from the routine duty and you are required to park the police&#039;s car in police car parking stand. This is an amazing and interactive police car parking and simulation game.', '', 'https://html5.gamemonetize.com/tzbem5c34y86kkvhl20qrkls1cs9c256/', 'html5', 960, 640, 1576076683, '1', '0'),
(927, 'gamemonetize-521', 'knight-rider', 'Knight Rider', 'https://img.gamemonetize.com/pm6zge1mxh9z0ryg92x5tvwhtvl8a1kz/512x384.jpg', '0', 2, 0, '0', 'Ghost Rider is a fictional bike racing game which is very suitable for players who love movie games. Game has lot of exciting challenges and key to get through it is to control the speed and acceleration of bike. Enjoy the stunning effects at full acceleration. Good Luck', '', 'https://html5.gamemonetize.com/pm6zge1mxh9z0ryg92x5tvwhtvl8a1kz/', 'html5', 960, 540, 1576076683, '1', '0'),
(928, 'gamemonetize-520', 'dinosaur-hunting-dino-attack-3d', 'Dinosaur Hunting Dino Attack 3D', 'https://img.gamemonetize.com/jbn9faiylfvc90dnthq5rcug7rli33pm/512x384.jpg', '0', 3, 0, '0', 'Dinosaur Hunting Dino Attack 3D is the fun new real hunting and sniper shooting and most realistic archery action game 3D simulation game for hunting lovers. Dinosaur Hunting Dino Attack 3D delivers realistic experience between all archetype games, amazing and different color , dinosaur, dino hunter make it more interesting.', '', 'https://html5.gamemonetize.com/jbn9faiylfvc90dnthq5rcug7rli33pm/', 'html5', 960, 640, 1576076683, '1', '0'),
(929, 'gamemonetize-519', 'ninja-turtles-coloring-book', 'Ninja Turtles Coloring Book', 'https://img.gamemonetize.com/q1n4zj7nslmc03yo2uxk2clzdkuobv81/512x384.jpg', '0', 5, 0, '0', 'Ninja Turtles Coloring Book is a free online coloring and kids game! In this game you will find eight different pictures which have to be colored as fast as you can to obtain a great score at the end of the game. You have 23 different colors to choose. You can also save the colored image. Have fun!', '', 'https://html5.gamemonetize.com/q1n4zj7nslmc03yo2uxk2clzdkuobv81/', 'html5', 1280, 720, 1576076683, '1', '0'),
(930, 'gamemonetize-518', 'abc-s-of-halloween', 'ABC&#039;s of Halloween', 'https://img.gamemonetize.com/7pazfjvm0adas1zpdkvem3xcpi4cqc4x/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: ABC&#039;s of Halloween. All images is with the ABC&#039;s of Halloween. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/7pazfjvm0adas1zpdkvem3xcpi4cqc4x/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(931, 'gamemonetize-517', 'save-color-pets', 'Save Color Pets', 'https://img.gamemonetize.com/xgxa95zl4uqdpfu4bcmbjnnvygkf6sq3/512x384.jpg', '0', 5, 0, '0', 'Save Color Pets is a good match 3 games with 16 levels. In each level, you need to rescue the color pets which was traped in the dirty sand. Make a column or row of three or more color pets of the same type to make them disappears. Break all the dirty sand in time to complete.', '', 'https://html5.gamemonetize.com/xgxa95zl4uqdpfu4bcmbjnnvygkf6sq3/', 'html5', 320, 420, 1576076683, '1', '0'),
(932, 'gamemonetize-516', 'frontline-army-commando-war', 'Frontline Army Commando War', 'https://img.gamemonetize.com/6x9koq6k0ig22ud60hekhgh502mzml9t/512x384.jpg', '0', 3, 0, '0', 'Do you love Army battle games and world war games? Are you crazy to be the part of special commando assault in battle war missions? US army battle war mission game in action is part of the elite commando war mission games in which you are the part of last commando squad on the final battleground.', '', 'https://html5.gamemonetize.com/6x9koq6k0ig22ud60hekhgh502mzml9t/', 'html5', 960, 600, 1576076683, '1', '0'),
(933, 'gamemonetize-515', 'halloween-memory', 'Halloween Memory', 'https://img.gamemonetize.com/060olg0cs464btblqnhf5ardtho760q7/512x384.jpg', '0', 5, 0, '0', 'How good is your memory? Can you match the pairs of Halloween characters together? Play this game, train your memory, and enjoy the Halloween holiday!', '', 'https://html5.gamemonetize.com/060olg0cs464btblqnhf5ardtho760q7/', 'html5', 960, 540, 1576076683, '1', '0'),
(934, 'gamemonetize-514', 'alien-way', 'Alien Way', 'https://img.gamemonetize.com/brogkr1qsvl9614uo52xncdhvamgpvd0/512x384.jpg', '0', 1, 0, '0', 'Alien Way is a platform HTML5game. Past 5 differents levels with your favorite Alien. Jump on the enemies to kill them and collect the stars. Collect more points and past 5 levels. Enjoy!', '', 'https://html5.gamemonetize.com/brogkr1qsvl9614uo52xncdhvamgpvd0/', 'html5', 1280, 720, 1576076683, '1', '0'),
(935, 'gamemonetize-513', 'narrow-passage-for-halloween', 'Narrow Passage For Halloween', 'https://img.gamemonetize.com/vnnpxuavfu8sz5quj1r4ut3k7kmun3oj/512x384.jpg', '0', 1, 0, '0', 'In Narrow Passage – Halloween game, all you have to do is to tap on the screen to jump, avoid obstacles and move forward. But it is much much harder than it seems. You will face different and challenging obstacles as you progress. Also don’t forget about the side walls! They will keep getting closer to each other which means the longer you stay on an obstacle, the narrower the passage will get.', '', 'https://html5.gamemonetize.com/vnnpxuavfu8sz5quj1r4ut3k7kmun3oj/', 'html5', 720, 1280, 1576076683, '1', '0'),
(936, 'gamemonetize-512', 'connect-the-halloween', 'Connect The Halloween', 'https://img.gamemonetize.com/7z32p1a6rbrxbwgcddldtxlypsv785eg/512x384.jpg', '0', 5, 0, '0', 'Connect pairs of matching Halloween characters by creating a path between them. Click / Tap and drag to connect the Halloween. Play now!', '', 'https://html5.gamemonetize.com/7z32p1a6rbrxbwgcddldtxlypsv785eg/', 'html5', 540, 960, 1576076683, '1', '0'),
(937, 'gamemonetize-511', 'miami-city-crime-simulator-city-mafia-war', 'Miami City Crime Simulator City Mafia War', 'https://img.gamemonetize.com/6ycz03wcg6ng39hyw4t8zmhw5cyt4otb/512x384.jpg', '0', 1, 0, '0', 'Fighting mafia war game with tactical battle strategies for city survival is in your hands. Fight against the grand gangster Vegas to win the rope hero battle war game title. Miami city crime simulator is from best fighting games in which you have multi war mission to defeat the city mafia.', '', 'https://html5.gamemonetize.com/6ycz03wcg6ng39hyw4t8zmhw5cyt4otb/', 'html5', 960, 600, 1576076683, '1', '0'),
(938, 'gamemonetize-510', 'flying-superhero-revenge-grand-city-captain', 'Flying Superhero Revenge Grand City Captain', 'https://img.gamemonetize.com/b6mr3helmunffzeiomq7qz9qxybzdyzo/512x384.jpg', '0', 1, 0, '0', 'Flying superhero games and new superhero war games are interesting to play in USA city for rescue and war missions. Are you lover of last game superheros then play Flying SuperHero Rescue City Fighter: Superhero war Games, crime city fighter or willing to be the ultimate superhero war survival captain of new superhero game?', '', 'https://html5.gamemonetize.com/b6mr3helmunffzeiomq7qz9qxybzdyzo/', 'html5', 960, 600, 1576076683, '1', '0'),
(939, 'gamemonetize-509', 'call-on-duty-sniper-assassin', 'Call On Duty Sniper Assassin', 'https://img.gamemonetize.com/uqjs7acbduzgwspiakaf7kvh3jr8sfmm/512x384.jpg', '0', 3, 0, '0', 'Modern war fare games are interesting with the totally accurate battle simulator. We are presenting the battle game of guns in warfare duty wars with multi missions. In this Gun games and fighting games, you are going to step forward in shooting game in real life to complete the gun shoot mission.', '', 'https://html5.gamemonetize.com/uqjs7acbduzgwspiakaf7kvh3jr8sfmm/', 'html5', 960, 600, 1576076683, '1', '0'),
(940, 'gamemonetize-508', 'biggy-race', 'Biggy Race', 'https://img.gamemonetize.com/q4d2blerhmgmkcd7xidx782e8nt3ag50/512x384.jpg', '0', 2, 0, '0', 'Drive a monster car on the rugged road, is that sounds crazy and exciting? In this driving game Biggy Race, you can show your skill and talent. Drive your great car, collect money and stars and buy new cars. Can you be the best driver in this world?', '', 'https://html5.gamemonetize.com/q4d2blerhmgmkcd7xidx782e8nt3ag50/', 'html5', 1280, 720, 1576076683, '1', '0'),
(941, 'gamemonetize-507', 'love-balls-halloween', 'Love Balls Halloween', 'https://img.gamemonetize.com/xl2fbyaqv1jhptd1iih9ohqev3xz73a5/512x384.jpg', '0', 5, 0, '0', 'Draw lines to help each pair of the Halloween characters to get back together. Be their hero! Play now!', '', 'https://html5.gamemonetize.com/xl2fbyaqv1jhptd1iih9ohqev3xz73a5/', 'html5', 960, 540, 1576076683, '1', '0')";
$db[26] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(942, 'gamemonetize-506', 'halloween-puzzle', 'Halloween Puzzle', 'https://img.gamemonetize.com/c1bd8ik28ogyrq9doqowuqx7hq1k6z5i/512x384.jpg', '0', 5, 0, '0', 'You love the Tetris game, you also love the Halloween holiday! This game is dedicated to you. Play now!', '', 'https://html5.gamemonetize.com/c1bd8ik28ogyrq9doqowuqx7hq1k6z5i/', 'html5', 540, 960, 1576076683, '1', '0'),
(943, 'gamemonetize-505', 'flick-superhero', 'Flick Superhero', 'https://img.gamemonetize.com/yufarght6xk9elhybzhbcg8ahp4j23r1/512x384.jpg', '0', 8, 0, '0', 'Flick your superhero ball into the basket. Which high score can you reach? Play now and win a new high score!', '', 'https://html5.gamemonetize.com/yufarght6xk9elhybzhbcg8ahp4j23r1/', 'html5', 540, 960, 1576076683, '1', '0'),
(944, 'gamemonetize-504', 'flappy-superhero-dunk', 'Flappy Superhero Dunk', 'https://img.gamemonetize.com/prn68rbs7tmh0k1q3rlzbt2pflsy3lns/512x384.jpg', '0', 4, 0, '0', 'Click or Tap to bounce up. Do perfect dunks to earn bonus points. Get high scores to unlock more superheroes. Happy playing!', '', 'https://html5.gamemonetize.com/prn68rbs7tmh0k1q3rlzbt2pflsy3lns/', 'html5', 960, 540, 1576076683, '1', '0'),
(945, 'gamemonetize-503', 'super-hero-family-jigsaw', 'Super Hero Family Jigsaw', 'https://img.gamemonetize.com/buwvufuth43a8q6m4hjux76rmfrcoymz/512x384.jpg', '0', 5, 0, '0', 'This game is from the family of jigsaw games, and in this game you can play with twelve cartoon images with Super Hero Family. Choose first image and choose the way you wanna play. You can choose to play in easy, normal or hard mode. Start to play and try to pass all levels. Enjoy in this jigsaw game.', '', 'https://html5.gamemonetize.com/buwvufuth43a8q6m4hjux76rmfrcoymz/', 'html5', 1280, 720, 1576076683, '1', '0'),
(946, 'gamemonetize-502', 'sweet-candy-challenge-time', 'Sweet Candy Challenge Time', 'https://img.gamemonetize.com/8p5lyfymvjlk3pqrt2ea3pdaixjqivjq/512x384.jpg', '0', 5, 0, '0', 'Sweet Candy Challenge is html game suitable for all ages. It is fun and interesting game, You need to find candies indicated in the upper right corner to enter a new level. No time no rush. Play and have fun.', '', 'https://html5.gamemonetize.com/8p5lyfymvjlk3pqrt2ea3pdaixjqivjq/', 'html5', 854, 480, 1576076683, '1', '0'),
(947, 'gamemonetize-501', 'funny-pong', 'Funny Pong', 'https://img.gamemonetize.com/hlncae5etqitweehi1f94a70wzsyvfdd/512x384.jpg', '0', 1, 0, '0', 'Funny Pong is an online game that you can play for free. Don&#039;t let the pong ball escape from the screen! Easy play but it is very attracting. Tap on the screen to close the brick cage. Your task to close the cage at the right time, or the ball is drop out and escape. Collect coins for extra points. Do you have enough confidence to challenge the high score? Come on and have fun playing Funny Pong! Thumbnails &amp; Icons', '', 'https://html5.gamemonetize.com/hlncae5etqitweehi1f94a70wzsyvfdd/', 'html5', 854, 480, 1576076683, '1', '0'),
(948, 'gamemonetize-500', 'space-geo-jump', 'Space Geo Jump', 'https://img.gamemonetize.com/mwb1dp3ud1nk7ebs96jq876ggoyhgaz2/512x384.jpg', '0', 5, 0, '0', 'Space Geo Jump is a fast paced dash and jump platfrom game. Touch the left and right screen to control or move player. Have fun!', '', 'https://html5.gamemonetize.com/mwb1dp3ud1nk7ebs96jq876ggoyhgaz2/', 'html5', 540, 960, 1576076683, '1', '0'),
(949, 'gamemonetize-499', '2048-puzzle', '2048 Puzzle', 'https://img.gamemonetize.com/w6hncjwrs6sxd1gme8eegi947gasnc3k/512x384.jpg', '0', 5, 0, '0', '2048 Puzzle is a classic skill number game, simple and addictive. Join the numbers and get to the 2048 tile! When two tiles with the same number touch, they merge into one. Let&#039;s make the best possible result in one of the three levels. Have fun!', '', 'https://html5.gamemonetize.com/w6hncjwrs6sxd1gme8eegi947gasnc3k/', 'html5', 720, 1280, 1576076683, '1', '0'),
(950, 'gamemonetize-498', 'pinball-hallowen', 'PINBALL HALLOWEN', 'https://img.gamemonetize.com/xxxzag2tfih6vinxu6rmzmr91r6kgxze/512x384.jpg', '0', 4, 0, '0', 'pinballhallowen is a game in which you have to overcome the objective score to be able to advance level your objective is to advance as much level as you can', '', 'https://html5.gamemonetize.com/xxxzag2tfih6vinxu6rmzmr91r6kgxze/', 'html5', 800, 600, 1576076683, '1', '0'),
(951, 'gamemonetize-497', 'ninja-pumpkin', 'Ninja Pumpkin', 'https://img.gamemonetize.com/1656h7smo100n3aok1gh6n98b34ie85f/512x384.jpg', '0', 4, 0, '0', 'You play as a Ninja Pumpkin (yes, it is a kind of ninja!) and in each level, you have to do your best to reach the level’s end. You have to be careful not to fall or touch enemies along the way. There are 3 different kind of enemies in the game. The red ones are the most common one and can be killed jumping on their head or tackling them. The yellow ones can be killed in the same way, but be careful because they jump every few seconds! And the third enemies are the most difficult ones. These black enemies are invincible and can’t be killed and you just have to jump over them and avoid touching', '', 'https://html5.gamemonetize.com/1656h7smo100n3aok1gh6n98b34ie85f/', 'html5', 800, 525, 1576076683, '1', '0'),
(952, 'gamemonetize-496', 'slenderman-must-die-dead-space', 'Slenderman Must Die: Dead Space', 'https://img.gamemonetize.com/d5j9cccxgjbqw693mmko4lyiokth4hqh/512x384.jpg', '0', 3, 0, '0', 'Slenderman Must Die: Dead Space is another awesome title from the Slenderman Must Die series. The legend of Slenderman continues and it seems that his terrors and evil will never end! In this episode, you must try and hunt down or escape from Slenderman in an abandoned space station. You must collect different energy cells scattered around the station in order to survive and escape. Look out for the creep villain and use any hi-tech weapon you can find to destroy him!', '', 'https://html5.gamemonetize.com/d5j9cccxgjbqw693mmko4lyiokth4hqh/', 'html5', 1100, 700, 1576076683, '1', '0'),
(953, 'gamemonetize-495', 'pac-game', 'Pac Game', 'https://img.gamemonetize.com/q5kyk7v0nj0gljwg2g2z9bt393jhn7ge/512x384.jpg', '0', 4, 0, '0', 'Do you like the Pacman game? If yes, this game is dedicated to you. Try a new challenge! Play now!', '', 'https://html5.gamemonetize.com/q5kyk7v0nj0gljwg2g2z9bt393jhn7ge/', 'html5', 960, 540, 1576076683, '1', '0'),
(954, 'gamemonetize-494', 'halloween-island-running', 'Halloween Island Running', 'https://img.gamemonetize.com/8wkgosuzsrxr49xbzfp33iud6i5i8kdh/512x384.jpg', '0', 4, 0, '0', 'Happy Halloween! This Halloween special game will show you a good time. Halloween island running is very easy to play. You have to kidnap our character, who was kidnapped by the indigenous people celebrating Halloween on the island. Try to avoid obstacles that get in your way. Don&#039;t be the dinner of the locals on Halloween! Halloween island running game with 3 different characters and different features from you. This Halloween game is with you with the difference of hitgames.', '', 'https://html5.gamemonetize.com/8wkgosuzsrxr49xbzfp33iud6i5i8kdh/', 'html5', 900, 600, 1576076683, '1', '0'),
(955, 'gamemonetize-493', 'pokemon-go-pikachu', 'Pokemon GO Pikachu', 'https://img.gamemonetize.com/f95xz5waq4ppwissk43fcllga2ptt9i9/512x384.jpg', '0', 5, 0, '0', 'Pokemon, takes place on the artificial island of Pasio. Pokemon and their Trainers called sync pairs—share a special bond. Each Pokemon has its own ability to move and you have to match Pokemon to there right places and unlock new Pokemon along the way. Four Elemental type of Pokemon, Earth, Water, Fire and Air ready to be discovered. Find All and be Ultimate one. They will evolve to more powerful forms in later stages. Don&#039;t forget to take as many Poke Balls in lesser moves to get the ultimate Pokemon.', '', 'https://html5.gamemonetize.com/f95xz5waq4ppwissk43fcllga2ptt9i9/', 'html5', 700, 900, 1576076683, '1', '0'),
(956, 'gamemonetize-492', 'wooden-puzzle-game', 'Wooden Puzzle Game', 'https://img.gamemonetize.com/3m3ziuxu7e40xuwht3uxjakgeeuwk8rn/512x384.jpg', '0', 5, 0, '0', 'Do you love the style of the Tetris game? If yes, this game is dedicated to you. Try a new challenge! Play now!', '', 'https://html5.gamemonetize.com/3m3ziuxu7e40xuwht3uxjakgeeuwk8rn/', 'html5', 540, 960, 1576076683, '1', '0'),
(957, 'gamemonetize-491', 'extreme-impossible-tracks-stunt-car-racing-3d', 'Extreme Impossible Tracks Stunt Car Racing 3D', 'https://img.gamemonetize.com/xcklzock41sleonavbimct9xw683lztj/512x384.jpg', '0', 2, 0, '0', 'Welcome to the world of real impossible tracks car racing games. Enjoy the real impossible track race on the endless extreme impossible tracks in the sky highs. If you are a fast speed racer and have a passion for car racing games then be ready to experience the real car rally in the mid of sky with no limits. Rush like a crazy stunt master while riding the beautifully designed real impossible tracks and beat the rival racers in this breathtaking adventure.', '', 'https://html5.gamemonetize.com/xcklzock41sleonavbimct9xw683lztj/', 'html5', 960, 640, 1576076683, '1', '0'),
(958, 'gamemonetize-490', 'mountain-climb-stunt-racing-game', 'Mountain Climb: Stunt Racing Game', 'https://img.gamemonetize.com/zhrfjxasfzv05x6augovreiqc106ffxf/512x384.jpg', '0', 2, 0, '0', 'Mountain Climb: Stunt Racing Game brings real thrilling aspects of teen&#039;s favorite 3D racing form to thrilling drift simulator. Endless car racing games play everything about car racing and surfing on mountains and endless traffic! This car racing game experience fascinates with realistic balance of chassis and mountain traffic racer.', '', 'https://html5.gamemonetize.com/zhrfjxasfzv05x6augovreiqc106ffxf/', 'html5', 960, 640, 1576076683, '1', '0'),
(959, 'gamemonetize-489', 'amazing-redpanda', 'Amazing Redpanda', 'https://img.gamemonetize.com/y9r1vz9vtlhuxab9ou0vjdc7rmzj0hqy/512x384.jpg', '0', 2, 0, '0', 'Jump &amp; Slash! Become the Amazing red panda, avoid the enemies and kill as much as you can!', '', 'https://html5.gamemonetize.com/y9r1vz9vtlhuxab9ou0vjdc7rmzj0hqy/', 'html5', 800, 600, 1576076683, '1', '0'),
(960, 'gamemonetize-488', 'blockwars', 'Blockwars', 'https://img.gamemonetize.com/is23gksj47egdpiz2s0whxhu7uvpd72w/512x384.jpg', '0', 3, 0, '0', 'Collect The part and Build your own ship with the greatest design and strongest part, dominate the wars and conquer the universe.', '', 'https://html5.gamemonetize.com/is23gksj47egdpiz2s0whxhu7uvpd72w/', 'html5', 640, 1020, 1576076683, '1', '0'),
(961, 'gamemonetize-487', 'snake-escape', 'Snake Escape', 'https://img.gamemonetize.com/9c5sxzpphysppp2a3p0og4jnjn6cx4f7/512x384.jpg', '0', 5, 0, '0', 'Classic snake game with furious puzzle', '', 'https://html5.gamemonetize.com/9c5sxzpphysppp2a3p0og4jnjn6cx4f7/', 'html5', 640, 1020, 1576076683, '1', '0'),
(962, 'gamemonetize-486', 'avoid-the-tow-truck', 'Avoid The Tow Truck', 'https://img.gamemonetize.com/9fpojcleapkfbh7sjvn99f0jx2y81cma/512x384.jpg', '0', 5, 0, '0', 'Change your moving direction by touching or clicking the screen and try to avoid tow truck who want to catch you.', '', 'https://html5.gamemonetize.com/9fpojcleapkfbh7sjvn99f0jx2y81cma/', 'html5', 720, 1280, 1576076683, '1', '0'),
(963, 'gamemonetize-485', 'arnie-attack', 'Arnie Attack', 'https://img.gamemonetize.com/kbeg1x15l9rhm2td73k4jgb8nt20yzyi/512x384.jpg', '0', 3, 0, '0', 'Arnie Attack is a great HTML5 platform game. Control soldier in the jungle collect diamonds , kill all enemies for a limited time and finished the level. You need to finished 5 levels to completed this mission. Use arrows keys to move Arnie and space for shoot. Enjoy.', '', 'https://html5.gamemonetize.com/kbeg1x15l9rhm2td73k4jgb8nt20yzyi/', 'html5', 1280, 720, 1576076683, '1', '0'),
(964, 'gamemonetize-484', 'castle-light', 'Castle Light', 'https://img.gamemonetize.com/mrfqmjbkrfzcyn9pd6sd3dh3ew1lk067/512x384.jpg', '0', 4, 0, '0', 'Castle Light is a casual game. You are a Knight in the Castle and you need to turn on light in all rooms in castle to find escape. You have 3 lights in every room to turn on. Good Luck!', '', 'https://html5.gamemonetize.com/mrfqmjbkrfzcyn9pd6sd3dh3ew1lk067/', 'html5', 1280, 720, 1576076683, '1', '0'),
(965, 'gamemonetize-483', 'biggy-way', 'Biggy Way', 'https://img.gamemonetize.com/j4rleqbtpdmzowgf1wcv57jmoskw5c2o/512x384.jpg', '0', 2, 0, '0', 'Drive a monster car on the rugged road, is that sounds crazy and exciting? In this driving game Biggy Way, you can show your skill and talent. Drive your great car, collect money and buy new cars. Can you be the best driver in this world?', '', 'https://html5.gamemonetize.com/j4rleqbtpdmzowgf1wcv57jmoskw5c2o/', 'html5', 800, 600, 1576076683, '1', '0'),
(966, 'gamemonetize-482', 'survival-on-worm-planet', 'Survival On Worm Planet', 'https://img.gamemonetize.com/38ir72nce8e4uvao7yu3j65xu5csprgt/512x384.jpg', '0', 4, 0, '0', 'Worms have invaded our planet. The planet needs you. Try to clean up the planet full of worms that surround your gun. You have to clean all worms to survive. You can play this fun game either as a single player or as a two player player. Survival on Worm Planet game contains realistic physics and different weapons. Let&#039;s! Kill the earthworms and save the planet. Have Fun!', '', 'https://html5.gamemonetize.com/38ir72nce8e4uvao7yu3j65xu5csprgt/', 'html5', 900, 600, 1576076683, '1', '0'),
(967, 'gamemonetize-481', 'journey-of-antibody', 'journey of Antibody', 'https://img.gamemonetize.com/945cr361rtplsihimyydemiqpifqug33/512x384.jpg', '0', 4, 0, '0', 'Be the mighty antibody in your body. Upgrade yourself to be stronger, destroy all the bacteria, and collect ally to help you neutralize your body.', '', 'https://html5.gamemonetize.com/945cr361rtplsihimyydemiqpifqug33/', 'html5', 640, 1020, 1576076683, '1', '0'),
(968, 'gamemonetize-480', 'slime-attack', 'Slime Attack', 'https://img.gamemonetize.com/7rr999mbrq46f51rr943cgeop473sc10/512x384.jpg', '0', 4, 0, '0', 'Protect your HQ with your mightiest finger you have. Tap and destroy every slime you see. Upgrade your skill to help you protect the HQ', '', 'https://html5.gamemonetize.com/7rr999mbrq46f51rr943cgeop473sc10/', 'html5', 640, 1020, 1576076683, '1', '0'),
(969, 'gamemonetize-479', 'gems', 'Gems', 'https://img.gamemonetize.com/ha02tpfjevm2ocj1bih52pnxebgnr4w9/512x384.jpg', '0', 5, 0, '0', 'Gems Merge is simple puzzle game. Swipe to merge equal gems. Perfect for mind relaxing and pass time.', '', 'https://html5.gamemonetize.com/ha02tpfjevm2ocj1bih52pnxebgnr4w9/', 'html5', 700, 960, 1576076683, '1', '0'),
(970, 'gamemonetize-478', 'inky-snakes', 'Inky Snakes', 'https://img.gamemonetize.com/5s5zgsz0oejgblg3h7a8ycib7u1cwtg1/512x384.jpg', '0', 1, 0, '0', 'Paper snakes is slithering io snake game with a touch of paper theme, there is only one rule to play game. Eat others to grow bigger. Choose awesome snakes and join the battle. Good Luck', '', 'https://html5.gamemonetize.com/5s5zgsz0oejgblg3h7a8ycib7u1cwtg1/', 'html5', 960, 540, 1576076683, '1', '0'),
(971, 'gamemonetize-477', 'enchanting-animal-spirits', 'Enchanting Animal Spirits', 'https://img.gamemonetize.com/e49z2rf24zisp1e88iqftxzu8zai2z9h/512x384.jpg', '0', 1, 0, '0', 'In the magical forest there live fabulous creatures - animal spirits. Each of these charming fairies is the patron of his element. Help the enchanting animal spirits solve all the arcana of the mysterious forest and get wonderful outfits and hairstyles for fairies as a reward.', '', 'https://html5.gamemonetize.com/e49z2rf24zisp1e88iqftxzu8zai2z9h/', 'html5', 800, 600, 1576076683, '1', '0'),
(972, 'gamemonetize-476', 'shoot-your-nightmare-halloween-special', 'Shoot Your Nightmare: Halloween Special', 'https://img.gamemonetize.com/834ebp74oeiwlv2tqqhl7mocxo2qi6zr/512x384.jpg', '0', 3, 0, '0', 'Shoot Your Nightmare: Halloween Special is the intense Halloween special version of the game in which you must explore the darkness and find candy bowls to wake up. You are trapped within your nightmares and are trying to escape them, the only way to do this is to find all thirteen candy bowls hidden in various places. The scary part is that the darkness is full of horrible creatures that are trying to grab you at any opportunity. Fight them off with your handgun and shoot all of your nightmares away then continue to search through the darkness. Good luck!', '', 'https://html5.gamemonetize.com/834ebp74oeiwlv2tqqhl7mocxo2qi6zr/', 'html5', 1100, 700, 1576076683, '1', '0'),
(973, 'gamemonetize-475', 'commando-sniper-cs-war', 'Commando Sniper: CS War', 'https://img.gamemonetize.com/bhqauyw29htb2nwgu3wj5mbz79c8pt41/512x384.jpg', '0', 3, 0, '0', 'Modern ultimate army sniper shooter experience is back with the latest installment to the popular commando warfare modern killer adventure, where you take on a more daunting and challenging army commando role of leading of modern army to deadly missions in the enemy territory battle, reclaiming lost battles in swat and engaging in army commando missions ops warfare against mighty modern terrorist oppositions.', '', 'https://html5.gamemonetize.com/bhqauyw29htb2nwgu3wj5mbz79c8pt41/', 'html5', 960, 600, 1576076683, '1', '0'),
(974, 'gamemonetize-474', 'live-aqua-hero-adventure', 'Live Aqua Hero Adventure', 'https://img.gamemonetize.com/h4vk54e5e3gry0xaodwzpockrbiek7u2/512x384.jpg', '0', 1, 0, '0', 'It’s not an escape plan in which you will be escaped once and free it’s all about the real aqua hero who fights against the underwater nation in the dark hustle that is the kings of monsters to prove yourself a real incredible hero.', '', 'https://html5.gamemonetize.com/h4vk54e5e3gry0xaodwzpockrbiek7u2/', 'html5', 960, 600, 1576076683, '1', '0'),
(975, 'gamemonetize-473', 'glory-chef', 'Glory Chef', 'https://img.gamemonetize.com/frkm7tva5ao9epiz42l9ldh3w783fgmv/512x384.jpg', '0', 1, 0, '0', 'Be the Glorious chef of all the time. Serve the best dishes by linking and collecting the ingredients as much and as fast as you can.', '', 'https://html5.gamemonetize.com/frkm7tva5ao9epiz42l9ldh3w783fgmv/', 'html5', 640, 1020, 1576076683, '1', '0'),
(976, 'gamemonetize-472', 'bird-chain', 'Bird Chain', 'https://img.gamemonetize.com/bx7r1nfa23ywowvohskmley79igndd0o/512x384.jpg', '0', 5, 0, '0', 'Playing in the Jungle of colourful birds. Link and match the bird with the longest chain and highest score.', '', 'https://html5.gamemonetize.com/bx7r1nfa23ywowvohskmley79igndd0o/', 'html5', 640, 1020, 1576076683, '1', '0'),
(977, 'gamemonetize-471', 'cubic-planet', 'Cubic Planet', 'https://img.gamemonetize.com/oug2dzppqje97t76fx4po7kulsbdr4xf/512x384.jpg', '0', 5, 0, '0', 'An endless colourful puzzle. Match the colour and reach the highest score from the entire planet.', '', 'https://html5.gamemonetize.com/oug2dzppqje97t76fx4po7kulsbdr4xf/', 'html5', 640, 1020, 1576076683, '1', '0'),
(978, 'gamemonetize-470', 'cube-island', 'Cube Island', 'https://img.gamemonetize.com/d0izec7i784q805q3omvmhzhes4yi3yv/512x384.jpg', '0', 5, 0, '0', 'Create a fruitful cube island by connecting and completing the water puzzle to irrigate the whole island.', '', 'https://html5.gamemonetize.com/d0izec7i784q805q3omvmhzhes4yi3yv/', 'html5', 640, 1020, 1576076683, '1', '0'),
(979, 'gamemonetize-469', 'connect-cube-arcade', 'Connect Cube Arcade', 'https://img.gamemonetize.com/92204lvkk2yf8p40ueja7h22scuazmx9/512x384.jpg', '0', 5, 0, '0', 'Connect all the cube you have to an endless arcade mode. Find the right match to your highest score.', '', 'https://html5.gamemonetize.com/92204lvkk2yf8p40ueja7h22scuazmx9/', 'html5', 800, 1334, 1576076683, '1', '0'),
(980, 'gamemonetize-468', 'box-race', 'Box Race', 'https://img.gamemonetize.com/aioqp6s2likvqri2fn02b9nnxlquuml5/512x384.jpg', '0', 2, 0, '0', 'Box Race is a great HTML5 racing game. Drive your car in Cardboard box and beat your opponent. You need to win in four different stage. Good luck!', '', 'https://html5.gamemonetize.com/aioqp6s2likvqri2fn02b9nnxlquuml5/', 'html5', 1280, 720, 1576076683, '1', '0'),
(981, 'gamemonetize-467', 'crazy-balls', 'Crazy Balls', 'https://img.gamemonetize.com/hqc1tlot78wal024ucqa6exlmts18adq/512x384.jpg', '0', 4, 0, '0', 'Play super addictive game &quot;Crazy Balls&quot;. Just hold, drag and release the bouncing balls to shoot all shapes. Every shape has some numbers. So to destroy the shape you have to hit the shape till 0. It&#039;s an endless game.', '', 'https://html5.gamemonetize.com/hqc1tlot78wal024ucqa6exlmts18adq/', 'html5', 768, 1024, 1576076683, '1', '0'),
(982, 'gamemonetize-466', 'air-force', 'Air Force', 'https://img.gamemonetize.com/v28pz3j8desaqsos1f9l9m1xwnsezszu/512x384.jpg', '0', 3, 0, '0', 'Air force 2018 a great HTML5 aircraft game. Your mission is to fly with super F117 an destroy all enemies. Pick up the emmo, fuel and hearts. Your mission is to stay a live long time as possible. Enjoy!', '', 'https://html5.gamemonetize.com/v28pz3j8desaqsos1f9l9m1xwnsezszu/', 'html5', 720, 1280, 1576076683, '1', '0'),
(983, 'gamemonetize-465', 'fz-zig-zag', 'FZ Zig Zag', 'https://img.gamemonetize.com/omkf0pdeacazdg3falupvz1q222yv69k/512x384.jpg', '0', 3, 0, '0', 'FZ Zig Zag is -HTML5 games. Just tap the screen to change the direction of the line. Try not to touch off the blocks! Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/omkf0pdeacazdg3falupvz1q222yv69k/', 'html5', 800, 600, 1576076683, '1', '0'),
(984, 'gamemonetize-464', 'heavy-machinery-jigsaw', 'Heavy Machinery Jigsaw', 'https://img.gamemonetize.com/nph2uvbpkmn427z71gc1ewwjzwdrifa5/512x384.jpg', '0', 5, 0, '0', 'This is jigsaw game with big machinery and vehicles for construction works. We offer you five images and you can choose image you want to play first, choose game mode and start to play. You can choose from 3 modes with 25.49 or 100 pieces. So, try to solve the pieces in right position to get the image with Heavy Machinery and enjoy in the game.', '', 'https://html5.gamemonetize.com/nph2uvbpkmn427z71gc1ewwjzwdrifa5/', 'html5', 1280, 900, 1576076683, '1', '0'),
(985, 'gamemonetize-463', 'masha-and-the-bear-jigsaw', 'Masha and the Bear Jigsaw', 'https://img.gamemonetize.com/mpxe44o2uxcpqdw6f77euywfy9m2fsz2/512x384.jpg', '0', 5, 0, '0', 'Masha and the Bear Jigsaw Puzzle is an online game that you can play for free. Masha And The Bear Jigsaw is an interesting cartoon image jigsaw puzzle game. If you are interested in the jigsaw puzzle, if you like Masha and the Bear cartoon, you can join us and have a try about Masha And The Bear Jigsaw. This interesting game can exercise your skills. Good luck!', '', 'https://html5.gamemonetize.com/mpxe44o2uxcpqdw6f77euywfy9m2fsz2/', 'html5', 800, 600, 1576076683, '1', '0'),
(986, 'gamemonetize-462', 'bts-ladybug-coloring', 'BTS LadyBug Coloring', 'https://img.gamemonetize.com/5ii5mj4dao7nnxsbz5dpv50bnvz4w3p2/512x384.jpg', '0', 1, 0, '0', 'Bts Ladybug Coloring is an online game that you can play for free. A new coloring game for you! Choose your favorite colors from the palette to paint our lovley LadyBug characters. These coloring pages really stimulate the kids creativity. Color within the lines. You can also download and print the image as well.', '', 'https://html5.gamemonetize.com/5ii5mj4dao7nnxsbz5dpv50bnvz4w3p2/', 'html5', 854, 480, 1576076683, '1', '0'),
(987, 'gamemonetize-461', 'underwater-odyssey-of-the-little-mermaid', 'Underwater Odyssey of the Little Mermaid', 'https://img.gamemonetize.com/72101y2dkqvb6kh522o6srmqoz1ml1ys/512x384.jpg', '0', 1, 0, '0', 'Welcome to the amazing underwater world. Help Ariel deceive the sea witch - Ursula, and find all the treasures before her. Manage to collect all the items until the time runs out. You can use three hits. At the second level, Ariel will have to take care of the environment. We need to remove all the garbage from the ocean. Good luck!', '', 'https://html5.gamemonetize.com/72101y2dkqvb6kh522o6srmqoz1ml1ys/', 'html5', 800, 600, 1576076683, '1', '0'),
(988, 'gamemonetize-460', 'angelic-charm-princess', 'Angelic Charm Princess', 'https://img.gamemonetize.com/0ohd8xc8sqe2atid0revokrmort3f1kg/512x384.jpg', '0', 1, 0, '0', 'Meet the inimitable angel princess! No one knows where this beautiful creature came from, but, undoubtedly, it is magical and mysterious! What do you want to see an angel princess? Light, airy, flying on white wings towards the dawn? Or the mysterious, dark, powerful envoy of the sunset lands? Only you decide! Choose from a variety of amazing magical accessories, weapons, wings and, of course, gorgeous outfits and dresses.', '', 'https://html5.gamemonetize.com/0ohd8xc8sqe2atid0revokrmort3f1kg/', 'html5', 800, 600, 1576076683, '1', '0'),
(989, 'gamemonetize-459', 'scatty-maps-africa', 'Scatty Maps Africa', 'https://img.gamemonetize.com/7smj8nmxffo7yqbg70txkwvc443uz6l6/512x384.jpg', '0', 5, 0, '0', 'Great educational game to learn about geography of Asia. Two modes of play, easy and full map, will amuse both younger and more advanced maps enthusiasts.', '', 'https://html5.gamemonetize.com/7smj8nmxffo7yqbg70txkwvc443uz6l6/', 'html5', 768, 750, 1576076683, '1', '0'),
(990, 'gamemonetize-458', 'fabulous-cute-unicorn-coloring-book', 'Fabulous Cute Unicorn Coloring Book', 'https://img.gamemonetize.com/wv3g1ys171neu7y18jdw148pm4erv37s/512x384.jpg', '0', 1, 0, '0', 'It’s time to draw, young artists! This time we have to color fabulous cute unicorns. Use the slide bar on the right to select the desired color. The palette of this game contains wonderful pastel shades. Drag the panel with the palette using the left mouse button. Enjoy this new game «Fabulous Cute Unicorn Coloring Book»!', '', 'https://html5.gamemonetize.com/wv3g1ys171neu7y18jdw148pm4erv37s/', 'html5', 800, 600, 1576076683, '1', '0'),
(991, 'gamemonetize-457', 'choli-food-drop', 'Choli Food Drop', 'https://img.gamemonetize.com/1n5ivnuyeue7oh1mzzywc9kh0nalalyc/512x384.jpg', '0', 5, 0, '0', 'You are a little (but fat!) cute flightless chicken that is hungry and needs to eat as much as it can! But because you can’t fly, you have to walk on the ground and collect the foods that drop from the sky. No one knows who is dropping these food, just eat them and don’t ask any questions! But pay attention because there also other objects among these foods and if they hit you, you will lose. So do your best and eat as much as you can.', '', 'https://html5.gamemonetize.com/1n5ivnuyeue7oh1mzzywc9kh0nalalyc/', 'html5', 1280, 720, 1576076683, '1', '0'),
(992, 'gamemonetize-456', 'feed-the-frog', 'Feed the Frog', 'https://img.gamemonetize.com/2k6vkkos08zmefdxzmlgjrk2vivlcnif/512x384.jpg', '0', 5, 0, '0', 'Feed the frog with spiders, ant and fish. Avoid bombs and try to eat all insects. If you be hit by bomb then tour game will lose.', '', 'https://html5.gamemonetize.com/2k6vkkos08zmefdxzmlgjrk2vivlcnif/', 'html5', 720, 1280, 1576076683, '1', '0'),
(993, 'gamemonetize-455', 'match-me-more', 'Match Me More', 'https://img.gamemonetize.com/pryejwqvlzrm28r54bn85mdjy46gsuai/512x384.jpg', '0', 5, 0, '0', 'Match Me More is a puzzle game when the player has to match the object with similar looks. Match The Color, Match The Shape, and Match The Number. Have Many Challenges and many other levels. Match them all and Solve all the Puzzle :)', '', 'https://html5.gamemonetize.com/pryejwqvlzrm28r54bn85mdjy46gsuai/', 'html5', 800, 1334, 1576076683, '1', '0'),
(994, 'gamemonetize-454', 'knight-of-light', 'Knight Of Light', 'https://img.gamemonetize.com/kevm904xf9xgbmwujbl8k0ftgt3rnvv8/512x384.jpg', '0', 5, 0, '0', 'Knight of Light is a Puzzle game when you tried to lighten the shadow of the world. move like the Light! fight like the Light! collect the Light and purify the shadow', '', 'https://html5.gamemonetize.com/kevm904xf9xgbmwujbl8k0ftgt3rnvv8/', 'html5', 800, 1334, 1576076683, '1', '0'),
(995, 'gamemonetize-453', 'dumb-pacman', 'Dumb Pacman', 'https://img.gamemonetize.com/3uwoe2havsewdy7r15l1nz226qbvrqvv/512x384.jpg', '0', 5, 0, '0', 'Classic Pacman Game where you need to eat dots and to avoid your enemies. When you eat big dots you can eat your enemies and that is your chance to pass level. But watch on the new born enemies.', '', 'https://html5.gamemonetize.com/3uwoe2havsewdy7r15l1nz226qbvrqvv/', 'html5', 640, 840, 1576076683, '1', '0'),
(996, 'gamemonetize-452', 'jump-box-ninja', 'Jump Box Ninja', 'https://img.gamemonetize.com/9mzd62kqaolvrje4zw0yiuos79b1mjlv/512x384.jpg', '0', 5, 0, '0', 'When a box decides to become a ninja...', '', 'https://html5.gamemonetize.com/9mzd62kqaolvrje4zw0yiuos79b1mjlv/', 'html5', 480, 852, 1576076683, '1', '0'),
(997, 'gamemonetize-451', 'piggy-night', 'Piggy Night', 'https://img.gamemonetize.com/v2q8wbaulr39o9ezhgmog01ein3p9iu4/512x384.jpg', '0', 4, 0, '0', 'With a dark theme and a thriller music we have launched Piggy Night. A mixture of cuteness and shady Tap on screen to move from one circle to another. Collect shield and speed power to make more scoreTurn on audio to experience better', '', 'https://html5.gamemonetize.com/v2q8wbaulr39o9ezhgmog01ein3p9iu4/', 'html5', 640, 1136, 1576076683, '1', '0'),
(998, 'gamemonetize-450', 'mud-truck-russian-offroad', 'Mud Truck Russian Offroad', 'https://img.gamemonetize.com/cnzkej6ztmvfdh80u3zdpfz46vmij0rv/512x384.jpg', '0', 2, 0, '0', 'Mud Truck Russian Offroad is a driving simulation game adventure in which you need to drive extreme 4x4 off-road Mud Truck to climb hills by overcoming the cliff obstacles and dirty roads. For the uphill driver, the sky-high tracks are made up of narrow hills and big dirty mountains. So get ready for some real offroad driving adventure fun by performing impossible truck stunts over dangerous and curvy dirty off-road tracks.', '', 'https://html5.gamemonetize.com/cnzkej6ztmvfdh80u3zdpfz46vmij0rv/', 'html5', 960, 600, 1576076683, '1', '0'),
(999, 'gamemonetize-449', 'table-tug-online', 'Table Tug Online', 'https://img.gamemonetize.com/sagqonptsz8pz6dzhbdugmdo2wz5to6m/512x384.jpg', '0', 7, 0, '0', 'Try to tug the table and bring your opponent across the line. Play local two player mode or challenge players online from around the world.', '', 'https://html5.gamemonetize.com/sagqonptsz8pz6dzhbdugmdo2wz5to6m/', 'html5', 800, 600, 1576076683, '1', '0'),
(1000, 'gamemonetize-448', 'shoot-the-guy', 'Shoot the Guy', 'https://img.gamemonetize.com/d56ms7c3uq87igw2vw3yvfqaqvyj6d6k/512x384.jpg', '0', 7, 0, '0', 'Shoot the guy is a weapon aiming game with a level of precision. There is only rule to play the game, Don&#039;t miss your chance. Aim perfectly to take head shot of racist guy and get power shots. Good Luck', '', 'https://html5.gamemonetize.com/d56ms7c3uq87igw2vw3yvfqaqvyj6d6k/', 'html5', 900, 500, 1576076683, '1', '0'),
(1001, 'gamemonetize-447', 'golf-solitaire', 'Golf Solitaire', 'https://img.gamemonetize.com/aa2lpk5087jb0nulu9sgvpsz9cax654h/512x384.jpg', '0', 5, 0, '0', 'Simple to play but joyously addictive card game Try to clear the course before the deck cards run out.', '', 'https://html5.gamemonetize.com/aa2lpk5087jb0nulu9sgvpsz9cax654h/', 'html5', 640, 360, 1576076683, '1', '0'),
(1002, 'gamemonetize-446', 'rock-paper-scissors', 'Rock Paper Scissors', 'https://img.gamemonetize.com/vgmxldexqzjgzn4g4veh5s4g96tc5h71/512x384.jpg', '0', 1, 0, '0', 'Two people are playing rock, scissors and paper game and you have to announce the winner in each round. The rules are the same as every rock, scissors and paper game and all you have to do is to choose which side has won or in case of draws, call it a draw. You also have a limited time to announce the result and if you fail to do so during that time or accounted the wrong result, you will lose one live. You have 5 lives, so you can make 5 mistakes.', '', 'https://html5.gamemonetize.com/vgmxldexqzjgzn4g4veh5s4g96tc5h71/', 'html5', 525, 800, 1576076683, '1', '0'),
(1003, 'gamemonetize-445', 'bts-lego-coloring-book', 'BTS Lego Coloring Book', 'https://img.gamemonetize.com/0nf1jwqvhya8ry9d1a4dcfasaqc30k31/512x384.jpg', '0', 1, 0, '0', 'Bts Lego Coloring Book is an online game that you can play for free. Do you like drawing? If you like drawing game, we provide BTS Lego Coloring Book for you to enjoy coloring. Choose your favorite scene and show your drawing talents to color the characters. Have fun!', '', 'https://html5.gamemonetize.com/0nf1jwqvhya8ry9d1a4dcfasaqc30k31/', 'html5', 854, 480, 1576076683, '1', '0'),
(1004, 'gamemonetize-444', 'funky-cube-monsters', 'Funky Cube Monsters', 'https://img.gamemonetize.com/7c7za8cnz6l1deo3ef1dxmj8z3653smb/512x384.jpg', '0', 5, 0, '0', 'Funky Cube Monsters is an online game that you can play for free. You need to match three of the same cube monsters to get points. There is no time limit for this game but there is a limited number of steps. Reach the target score of each level to enter the next one. Have a good time playing', '', 'https://html5.gamemonetize.com/7c7za8cnz6l1deo3ef1dxmj8z3653smb/', 'html5', 480, 854, 1576076683, '1', '0'),
(1005, 'gamemonetize-443', 'fun-birds-hidden-stars', 'Fun Birds Hidden Stars', 'https://img.gamemonetize.com/60fn0fqmlqgvxlho2xcq4zz2nmuw6h9d/512x384.jpg', '0', 5, 0, '0', 'Fun Birds Hidden Stars is a free online skill and hidden object game. Find out the hidden stars in the specified images. Each level has 10 hidden stars. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/60fn0fqmlqgvxlho2xcq4zz2nmuw6h9d/', 'html5', 960, 540, 1576076683, '1', '0'),
(1006, 'gamemonetize-442', 'what-s-next', 'What&#039;s Next?', 'https://img.gamemonetize.com/sudylosb01ziactcb2fuzuy6e3aphh99/512x384.jpg', '0', 5, 0, '0', 'A violent war has began, and now you have to save your people, fighting against anything will try to stop you! Features: - Control a Super-Trained Soldier and defeat all your enemies! (will it be really like that?) - Use dozens of different weapons to fight at your best (maybe...) - Complete houndreds of missions (Maybe not...) - Remember: Nothing is as it seems', '', 'https://html5.gamemonetize.com/sudylosb01ziactcb2fuzuy6e3aphh99/', 'html5', 800, 450, 1576076683, '1', '0'),
(1007, 'gamemonetize-441', 'for-an-apple', 'For an Apple', 'https://img.gamemonetize.com/7evvopj0heq6anp1u9tk0pmu4co4ep0l/512x384.jpg', '0', 3, 0, '0', 'A classic avoid and collect game where you are a fly that has to eat as many apples as possible', '', 'https://html5.gamemonetize.com/7evvopj0heq6anp1u9tk0pmu4co4ep0l/', 'html5', 960, 540, 1576076683, '1', '0'),
(1008, 'gamemonetize-440', 'princesses-doll-fantasy', 'Princesses - Doll Fantasy', 'https://img.gamemonetize.com/ctke51t230twnoeqvp5aohzxqlgkrr24/512x384.jpg', '0', 1, 0, '0', 'Princesses love fashion and outfits. Sisters Anna and Elsa decided to create a new fashionable collection of cute doll dresses. The main rule - more ruff, flounces and bows. Help the sisters prepare for the fashion show of their collection. Anna and Elsa will be models at a fashion show of their own collection of dresses. Choose outfits and arrange show with the princesses in the palace.', '', 'https://html5.gamemonetize.com/ctke51t230twnoeqvp5aohzxqlgkrr24/', 'html5', 800, 600, 1576076683, '1', '0'),
(1009, 'gamemonetize-439', 'pokemon-pikachu', 'Pokemon Pikachu', 'https://img.gamemonetize.com/2mk9rfg0v8uvbdbczmg9ke4nn3e4h29j/512x384.jpg', '0', 1, 0, '0', 'Run as fast as you can through an ever-changing Pokemon world with hero Pikachu.', '', 'https://html5.gamemonetize.com/2mk9rfg0v8uvbdbczmg9ke4nn3e4h29j/', 'html5', 800, 600, 1576076683, '1', '0'),
(1010, 'gamemonetize-438', 'hill-climbing', 'Hill Climbing', 'https://img.gamemonetize.com/v33fk4a7b97riw532yhhg9gnawsqrhvn/512x384.jpg', '0', 1, 0, '0', 'Hill climbing is a hill climbing game where you will drive your car through bumpy road. Take control on acceleration to avoid accident. Cover the maximum distance and make a record. Good Luck', '', 'https://html5.gamemonetize.com/v33fk4a7b97riw532yhhg9gnawsqrhvn/', 'html5', 960, 540, 1576076683, '1', '0'),
(1011, 'gamemonetize-437', 'crazy-car-stunts', 'Crazy Car Stunts', 'https://img.gamemonetize.com/stb191iaj21s4yed4zh08m7gdoj2xbop/512x384.jpg', '0', 8, 0, '0', 'Drive your car and perform all the crazy stunts using various ramps on the maps.', '', 'https://html5.gamemonetize.com/stb191iaj21s4yed4zh08m7gdoj2xbop/', 'html5', 1100, 660, 1576076683, '1', '0'),
(1012, 'gamemonetize-436', 'parking-car-crash-demolition-multiplayer', 'Parking Car Crash Demolition Multiplayer', 'https://img.gamemonetize.com/nuc82vrhkdbduo123sns2vzkml7y0zkn/512x384.jpg', '0', 2, 0, '0', 'Welcome to the new parking car crash demolition. In this game you can fight with smart ai cars and also with real players, try multiplayer or campaign and destroy any car you see in maps, you can customize your car by choosing color, Nitro, 45 models of wheels and also 12 cars model, you can play also as police with cool light and stuff :). This is v1 version will come in time more games like this, all is on work, enjoy and support us by playing every day', '', 'https://html5.gamemonetize.com/nuc82vrhkdbduo123sns2vzkml7y0zkn/', 'html5', 800, 600, 1576076683, '1', '0'),
(1013, 'gamemonetize-435', 'max-and-eleven-bff-strange-dressup', 'Max and Eleven BFF Strange DressUp', 'https://img.gamemonetize.com/85p6ztuwnkeyjokpdxzumk2gslw66ofe/512x384.jpg', '0', 1, 0, '0', 'Mysterious events unfold in the city of Hawkins. Eleven or Elli, as always, is at the center of what is happening. She is no longer a child. The girl has a difficult period in her life and she broke up with her boyfriend Mike. Her new best friend, Maxine, helps Elli to believe in herself. Go to the shopping center &quot;Starcourt&quot; with BBF. Try on new look from the fashion of the 80s. Have fun and eat ice cream. Participate in a fashionable photo shoot. This game is for all fans of the show - Stranger Things.', '', 'https://html5.gamemonetize.com/85p6ztuwnkeyjokpdxzumk2gslw66ofe/', 'html5', 800, 600, 1576076683, '1', '0'),
(1014, 'gamemonetize-434', 'fz-knife-up', 'FZ Knife Up', 'https://img.gamemonetize.com/98iakbmidtuk7nbo0k2uq0ud4pxia5rk/512x384.jpg', '0', 1, 0, '0', 'FZ Knife Up - HTML5 games. Throw your knife with best your skill to get more score. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/98iakbmidtuk7nbo0k2uq0ud4pxia5rk/', 'html5', 800, 600, 1576076683, '1', '0'),
(1015, 'gamemonetize-433', 'beautiful-princesses-find-a-pair', 'Beautiful Princesses - Find a Pair', 'https://img.gamemonetize.com/sbinwxk60frgmomwoh8d2vuniufwxeip/512x384.jpg', '0', 5, 0, '0', 'It&#039;s time to practice your memory! Try to find twin princesses Ariel, Jasmine, Elsa, Anna, Rapunzel and Tiana playing this fun game for girls - Beautiful princesses - find a pair. Start at a light level and move on. Hurry up - have time to collect all the pairs before the time runs out!', '', 'https://html5.gamemonetize.com/sbinwxk60frgmomwoh8d2vuniufwxeip/', 'html5', 800, 600, 1576076683, '1', '0'),
(1016, 'gamemonetize-432', 'guns-amp-bottles', 'Guns &amp; Bottles', 'https://img.gamemonetize.com/ieh7z82rrb0zxpjd0wntzl5mgcfk3n3m/512x384.jpg', '0', 4, 0, '0', 'Guns and Bottles is an awesome bottle shooting game in which you need to shoot the rotating bottles to get a high score. The gun is also rotating on his spot which makes the game a little harder. Tap on the screen in order to hit the bottles. Try to hit 3 bottles continuously to get 5 coins. But try to avoid hitting red bottles. If you hit them the game will over. Collect a lot of coins to unlock the super guns. Give your best shots and have fun with &quot;Guns and bottles&quot;.', '', 'https://html5.gamemonetize.com/ieh7z82rrb0zxpjd0wntzl5mgcfk3n3m/', 'html5', 640, 1136, 1576076683, '1', '0'),
(1017, 'gamemonetize-431', 'oracle', 'Oracle', 'https://img.gamemonetize.com/vrr8g4clmo152rrhft50seo6fni69we5/512x384.jpg', '0', 5, 0, '0', 'Meet the heroes of Oracle Harold Hammer, Diana Driver, Wanda Wrench, &amp; Samuel Saw help them to clear the dungeon and Be the Oracle. Oracle is a Strategy puzzle game when all of the Heroes you control move simultaneously. Outsmart the dungeon to fight the enemies and clear the puzzle.', '', 'https://html5.gamemonetize.com/vrr8g4clmo152rrhft50seo6fni69we5/', 'html5', 800, 1334, 1576076683, '1', '0'),
(1018, 'gamemonetize-430', 'perfect-slices-2', 'Perfect Slices 2', 'https://img.gamemonetize.com/nzuvtus9g7kp2vezo9xa7xbkv8r1zp7n/512x384.jpg', '0', 4, 0, '0', 'Chop like a real master. It&#039;s so satisfying! - Easy control - Addictive gameplay - Simple and fun', '', 'https://html5.gamemonetize.com/nzuvtus9g7kp2vezo9xa7xbkv8r1zp7n/', 'html5', 500, 800, 1576076683, '1', '0'),
(1019, 'gamemonetize-429', 'commando-adventure-assassin', 'Commando Adventure Assassin', 'https://img.gamemonetize.com/17smdmq2l7g1l053vtd6l8ledlz4ujmw/512x384.jpg', '0', 3, 0, '0', 'Commando Adventure Assassin is real war game. in, best FPS shooting games offline category, its really challenge for you to complete your mission You are only last person left from your force. It’s your challenge to kill enemies before they kill you and take back your land from enemy and become a hero. They already got information about your mission and they are ready to kill you. Enemy is alert.You have different varieties of weapon and best luck for mission.', '', 'https://html5.gamemonetize.com/17smdmq2l7g1l053vtd6l8ledlz4ujmw/', 'html5', 960, 640, 1576076683, '1', '0'),
(1020, 'gamemonetize-428', 'taleans', 'Taleans', 'https://img.gamemonetize.com/0mamfwz2xj1k2pqobyy10hh1kvdcck9d/512x384.jpg', '0', 5, 0, '0', 'A Fairytale of Hansel and Gretel in Taleans. Trapped in the dark forest. Help them to find their way home. solve the puzzle and save them from evil. Facing an exciting event and find out their fate.', '', 'https://html5.gamemonetize.com/0mamfwz2xj1k2pqobyy10hh1kvdcck9d/', 'html5', 800, 1334, 1576076683, '1', '0'),
(1021, 'gamemonetize-427', 'ludo-wars', 'Ludo Wars', 'https://img.gamemonetize.com/0s5bw73plzx81i9c4i0e0g00n52grscs/512x384.jpg', '0', 7, 0, '0', 'A unique Ludo game! Challenge an online player or challenge a friend in local two player mode. Be the first player to move all of your pieces to the end goal. Watch out for trap spaces and enemy pieces.', '', 'https://html5.gamemonetize.com/0s5bw73plzx81i9c4i0e0g00n52grscs/', 'html5', 800, 600, 1576076683, '1', '0'),
(1022, 'gamemonetize-426', 'kinder-egg-surprise', 'Kinder Egg Surprise', 'https://img.gamemonetize.com/bzwc088qstgw6kd6x88pgv3bbwpzsk84/512x384.jpg', '0', 5, 0, '0', 'Kinde Egg Surprise is fun online game suitable for all ages, especially for kids. This time you need to unwrap your kinder egg by clicking on it, than eat the chocolate and open the yellow container to get a toy. I hope that each time you will get a different toy. Now, go ahead, click and have fun.', '', 'https://html5.gamemonetize.com/bzwc088qstgw6kd6x88pgv3bbwpzsk84/', 'html5', 480, 854, 1576076683, '1', '0'),
(1023, 'gamemonetize-425', 'watermelon-shooting', 'Watermelon Shooting', 'https://img.gamemonetize.com/8j3z4c3racb3vnldwa8h68mv3lug4ztc/512x384.jpg', '0', 3, 0, '0', 'Watermelon Shooting is one of the most fun shooting games in which you will get various kinds of handguns which you can use to shoot watermelons and splatter gooey red juice all over your screen. This fun shooting game has more than 20 levels.', '', 'https://html5.gamemonetize.com/8j3z4c3racb3vnldwa8h68mv3lug4ztc/', 'html5', 960, 640, 1576076683, '1', '0'),
(1024, 'gamemonetize-424', 'car-eat-gas', 'Car Eat Gas', 'https://img.gamemonetize.com/n9cpnsi2mbu87hra8ebm2g6yhgvx346q/512x384.jpg', '0', 5, 5, '0', 'In this game you need to control the car who want to eat gas. This car is thirsty. But is it not so easy as you think. Race against rolling blades who want to destroy the car. You need to avoid blades and to eat all gas tanks to pass the level. But there is a trick. You can eat the only car between gas tanks and then you can pass trough blades. Your car have 3 lives, so use them well.', '', 'https://html5.gamemonetize.com/n9cpnsi2mbu87hra8ebm2g6yhgvx346q/', 'html5', 860, 640, 1576076683, '1', '0'),
(1025, 'gamemonetize-423', 'russian-trucks-jigsaw', 'Russian Trucks Jigsaw', 'https://img.gamemonetize.com/jgh7h1txbreq2e66tv0u2h2yza6cgwf0/512x384.jpg', '0', 5, 1, '0', 'Russian Trucks Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/jgh7h1txbreq2e66tv0u2h2yza6cgwf0/', 'html5', 960, 540, 1576076683, '1', '0'),
(1026, 'gamemonetize-422', 'hippo-jigsaw', 'Hippo Jigsaw', 'https://img.gamemonetize.com/43v0nxto7s56ld8xv7im5c31m3waqffu/512x384.jpg', '0', 5, 0, '0', 'Interesting cartoon Hippo Characters for you to choose to play in this jigsaw game. Click on your favorite image with hippo select with how many pieces you want to play this game and start to play.', '', 'https://html5.gamemonetize.com/43v0nxto7s56ld8xv7im5c31m3waqffu/', 'html5', 1280, 900, 1576076683, '1', '0'),
(1027, 'gamemonetize-421', 'spiders', 'Spiders', 'https://img.gamemonetize.com/od0553fprdlm105js8cj3y7rgekaumhi/512x384.jpg', '0', 4, 0, '0', 'Spiders is easy to play but tough to master game. You need to pass through the blocky area by swinging on roof and blocks. Avoid the obstacles and collect the gems along your way to unlock fantastic new heroes. Good Luck', '', 'https://html5.gamemonetize.com/od0553fprdlm105js8cj3y7rgekaumhi/', 'html5', 960, 528, 1576076683, '1', '1'),
(1028, 'gamemonetize-420', 'chicken-and-crow-shoot', 'Chicken and Crow Shoot', 'https://img.gamemonetize.com/3uh6fso8eyuw0s4mvh9zgz77ckjfa85d/512x384.jpg', '0', 3, 0, '0', 'This best crows shooting game “Chicken and Crow Shoot” reminds you of classic bird hunting games with target shooting adventure in the modern FPS shooting arena. The crows shooter games are real fun and easy to play. In this crows hunting game, you can use your pistol and sniper gun to shoot the crows and double your fun by both shooting adventure and animal hunting missions.', '', 'https://html5.gamemonetize.com/3uh6fso8eyuw0s4mvh9zgz77ckjfa85d/', 'html5', 960, 640, 1576076683, '1', '0'),
(1029, 'gamemonetize-419', 'bts-gta-cars-coloring', 'BTS GTA Cars Coloring', 'https://img.gamemonetize.com/yle3hubjybpkfoub6ln9ghu0d93czg6x/512x384.jpg', '0', 1, 0, '0', 'Bts GTA Cars Coloring is an online game that you can play for free. Coloring pages of cool GTA Cars. Discover the world of GTA with original illustrations. These coloring pages really stimulate the kids creativity. Color within the lines. You can also download and print the coloring pages, to color them in real life, or print a finished image.', '', 'https://html5.gamemonetize.com/yle3hubjybpkfoub6ln9ghu0d93czg6x/', 'html5', 854, 480, 1576076683, '1', '0'),
(1030, 'gamemonetize-418', 'the-lost-joystick', 'The Lost Joystick', 'https://img.gamemonetize.com/apjg2adx9e5odnct7ksrbdgk3exj3y7d/512x384.jpg', '0', 1, 0, '0', 'They stole your joystick… but they don’t know who you are! You will do everything to get it back In this psychedelic pixel-artish platformer, you have to jump around the levels looking for coins and keys, killing monsters and avoiding traps . Simple as that.', '', 'https://html5.gamemonetize.com/apjg2adx9e5odnct7ksrbdgk3exj3y7d/', 'html5', 640, 360, 1576076683, '1', '0'),
(1031, 'gamemonetize-417', 'easter-memory', 'Easter Memory', 'https://img.gamemonetize.com/j9x76p7nvmhaby0u4h0avr6lhszl94wt/512x384.jpg', '0', 5, 0, '0', 'Easter Memory is HTML5 games - Puzzle game and memory games. Match all identical cards before time runs out. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/j9x76p7nvmhaby0u4h0avr6lhszl94wt/', 'html5', 800, 600, 1576076683, '1', '0'),
(1032, 'gamemonetize-416', 'bear-adventure', 'Bear Adventure', 'https://img.gamemonetize.com/s53enctdm8w3hcqp0wagc8r3g95jaqd3/512x384.jpg', '0', 5, 0, '0', 'Bear Adventure is an online fun kids game. Is there something happier than collecting a fish? There is a cute bear who want to collect fish. Can you help him? Find fish and collect them as many as possible. You have to avoid your shadow, or you will lose. How many scores can you get? Have fun!', '', 'https://html5.gamemonetize.com/s53enctdm8w3hcqp0wagc8r3g95jaqd3/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1033, 'gamemonetize-415', 'save-the-egg', 'Save the Egg', 'https://img.gamemonetize.com/a6e4tol14du15uf8nvsdsikrzwta6tyg/512x384.jpg', '0', 5, 0, '0', 'Save The Egg is a hill climbing car game with a egg on top of it There is only one important task DONT DROP THE EGG Drive carefully and cover maximum distance It is not easy as well Good Luck', '', 'https://html5.gamemonetize.com/a6e4tol14du15uf8nvsdsikrzwta6tyg/', 'html5', 960, 540, 1576076683, '1', '0'),
(1034, 'gamemonetize-414', 'dinosaurs-jurassic-survival-world', 'Dinosaurs Jurassic Survival World', 'https://img.gamemonetize.com/9mm0xrchw0mbtzi9xzfpx3firjbfymp7/512x384.jpg', '0', 3, 0, '0', 'Survive the Time Dinosaurs from the Late Cretaceous period, you are spawned there and now you need to live there and survive. Take your friend and play in multiplayer fighting with different models of dinosaurs or you can begin a campaign and fight to win and escape from forest. Enjoy :)', '', 'https://html5.gamemonetize.com/9mm0xrchw0mbtzi9xzfpx3firjbfymp7/', 'html5', 800, 600, 1576076683, '1', '0')";
$db[27] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1035, 'gamemonetize-413', 'the-driver-of-a-mining-truck', 'The Driver Of A Mining Truck', 'https://img.gamemonetize.com/q5p3pqwgnv4sa6l3wbwyqz590ram7ccy/512x384.jpg', '0', 2, 0, '0', 'Best truck driving physics and most realistic hilly mountains cargo transport is here for you.Driving the truck on mountain is very difficult task and a great experience of driving is required to perform it. This is new stunning truck game in which you have to load heavy materials on your truck and move it to the final trucking stations.', '', 'https://html5.gamemonetize.com/q5p3pqwgnv4sa6l3wbwyqz590ram7ccy/', 'html5', 960, 640, 1576076683, '1', '0'),
(1036, 'gamemonetize-412', 'towing-trucks-differences', 'Towing Trucks Differences', 'https://img.gamemonetize.com/p2j5guaaibubkv9wdgqv8oi04mxgjl58/512x384.jpg', '0', 5, 0, '0', 'Find seven differences between two images with towing trucks. If you are good you can pass all ten levels. There is time for 2 minutes to find all differences at each level. Use your mouse to play and enjoy.', '', 'https://html5.gamemonetize.com/p2j5guaaibubkv9wdgqv8oi04mxgjl58/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1037, 'gamemonetize-411', 'run-panda-run', 'Run Panda Run', 'https://img.gamemonetize.com/0wzlg7zsw5oezz5aoeq3cu1tbesprcqr/512x384.jpg', '0', 5, 0, '0', 'Run Panda Run is a cute normal runner game. Just tap to make the panda jump and collect as many coins as you can. Jump through obstacles like penguin snowman and some rock. To make the game more interesting we have designed some cute graphics and added funny sounds in it. So Play Run Panda Run and start jumping on platforms to make a high score.', '', 'https://html5.gamemonetize.com/0wzlg7zsw5oezz5aoeq3cu1tbesprcqr/', 'html5', 768, 1024, 1576076683, '1', '0'),
(1038, 'gamemonetize-410', 'minecraft-survival', 'Minecraft Survival', 'https://img.gamemonetize.com/q3fsolt54w5mt0o0tu4kjrizv8209zuz/512x384.jpg', '0', 5, 0, '0', 'Minecraft Survival is fun html5 game suitable for all minecraft lovers. The aim of the game is simple. You need to get our lovley Steve to the green ground area to clear the level and enter a new one. Click or tap on the objects to remove them of the stage. Have fun playing.', '', 'https://html5.gamemonetize.com/q3fsolt54w5mt0o0tu4kjrizv8209zuz/', 'html5', 854, 480, 1576076683, '1', '0'),
(1039, 'gamemonetize-409', 'rabbit-shooter', 'Rabbit Shooter', 'https://img.gamemonetize.com/q17kvs05yif082wbd9jw05kabox6sskj/512x384.jpg', '0', 3, 0, '0', 'Do you want to be challenged in rabbit hunting while playing rabbit shooting game? This Rabbit Shooter for Rabbit Shoot game of a rabbit hunter is going to evaluate rabbit game skills of the rabbit hunter and challenge him to maximum in rabbit hunting. Rabbit Shooter for Rabbit Shoot is the best rabbit shooting game. Rabbit Shooter for Rabbit Shoot has been developed for all rabbit hunting lovers.', '', 'https://html5.gamemonetize.com/q17kvs05yif082wbd9jw05kabox6sskj/', 'html5', 960, 640, 1576076683, '1', '0'),
(1040, 'gamemonetize-408', 'green-slaughter', 'Green Slaughter', 'https://img.gamemonetize.com/fmxm5mqozxfvfsuyxjb42lmchec1r3h7/512x384.jpg', '0', 3, 0, '0', 'An hacker spotted a big conspiracy, but he is alone, so he can&#039;t do anything to save the world. He can&#039;t call neither the police nor the army, he needs an outsider. Somebody who knows how to fight and has nothing to lose. Prepare your weapons and Kill dozens and dozens of monsters! You’re the last hope to save the world from the reptilians!', '', 'https://html5.gamemonetize.com/fmxm5mqozxfvfsuyxjb42lmchec1r3h7/', 'html5', 800, 450, 1576076683, '1', '0'),
(1041, 'gamemonetize-407', 'floppy-pipe', 'Floppy Pipe', 'https://img.gamemonetize.com/y7naathba921kik6urlnogudr6ewla2k/512x384.jpg', '0', 4, 0, '0', 'A reimagining of the famous &quot;Floppy Bird&quot;. The rules are simple: you are a Flying Pipe and you have to avoid the chickens as long as you can!', '', 'https://html5.gamemonetize.com/y7naathba921kik6urlnogudr6ewla2k/', 'html5', 640, 360, 1576076683, '1', '0'),
(1042, 'gamemonetize-406', 'ben10-jumping-challenge', 'Ben10 Jumping Challenge', 'https://img.gamemonetize.com/0zi1b4fgv4h27h1yspn1dshbz8d12wu3/512x384.jpg', '0', 1, 0, '0', 'Ben 10 Endless Jumping is an online game that you can play for free. Ben 10 Jumping Challenge is an arcade online game suitable for all ages. Help our cool Ben 10 jump as high as possible and make a high score. Collect gold coins and avoid hitting airplanes and helicopters. If you jump on them you will lose your health. Have fun playing.', '', 'https://html5.gamemonetize.com/0zi1b4fgv4h27h1yspn1dshbz8d12wu3/', 'html5', 480, 854, 1576076683, '1', '0'),
(1043, 'gamemonetize-405', 'super-stack', 'Super Stack', 'https://img.gamemonetize.com/s4wlfyx95as6gst9kwgxj80oz0eqsshl/512x384.jpg', '0', 4, 0, '0', 'Stack up the blocks as high as you can! ◉ Simple &amp; Beautiful graphics designed ◉ Compete for the best score in the world', '', 'https://html5.gamemonetize.com/s4wlfyx95as6gst9kwgxj80oz0eqsshl/', 'html5', 900, 600, 1576076683, '1', '0'),
(1044, 'gamemonetize-404', 'ninja-treasure-match-3', 'Ninja Treasure Match 3', 'https://img.gamemonetize.com/04s19i4dhidhfsl01d93hfr05f9xq6qq/512x384.jpg', '0', 5, 0, '0', 'Ninja Treasure Match 3 is an online puzzle game that you can play for free. Easy to play. Help ninja to collect treasures by drawing a line with these same color games! Match 3 or more gems can be eliminated. More than 5 you can get bonus and extra time.', '', 'https://html5.gamemonetize.com/04s19i4dhidhfsl01d93hfr05f9xq6qq/', 'html5', 500, 800, 1576076683, '1', '0'),
(1045, 'gamemonetize-403', 'fish-world-match', 'Fish World Match', 'https://img.gamemonetize.com/ugtn9twdocwyqq3nc426q2l93m0akzpe/512x384.jpg', '0', 5, 0, '0', 'Fish World Match is HTML5 games - Your Fish buddies are here and do not expect from them anything less than long hours of fun and entertainment . Fish World Match3 is fun addicting adventure puzzle match3 game. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/ugtn9twdocwyqq3nc426q2l93m0akzpe/', 'html5', 800, 600, 1576076683, '1', '0'),
(1046, 'gamemonetize-402', 'air-war', 'Air War', 'https://img.gamemonetize.com/xown7l7o78ptdovah5yb0mrlyfarljxi/512x384.jpg', '0', 3, 0, '0', 'The open skies are your battlefield in this scrolling shooter game Pilot your fighter plane as you engage enemy aircraft in thrilling dog fights Move through the level trying to gun down as many enemy airplanes as possible Collect as many coins as possible to make the best score who will win the battle for air superiority', '', 'https://html5.gamemonetize.com/xown7l7o78ptdovah5yb0mrlyfarljxi/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1047, 'gamemonetize-401', 'american-touchdown-game', 'American Touchdown Game', 'https://img.gamemonetize.com/6airkt6chnb0xbgtpjlr9dqhsdahwjz3/512x384.jpg', '0', 1, 0, '0', 'American Touchdown Game features: - fun gameplay - single-player or 2 player game modes', '', 'https://html5.gamemonetize.com/6airkt6chnb0xbgtpjlr9dqhsdahwjz3/', 'html5', 960, 540, 1576076683, '1', '0'),
(1048, 'gamemonetize-400', 'pingu-amp-friends', 'Pingu &amp; Friends', 'https://img.gamemonetize.com/gjjxi70rzl1zj2zu92afqogjfikv6gzn/512x384.jpg', '0', 4, 0, '0', 'Pingu and friends is a really cute and easy game to play. You just have to tap on the screen to make jump the character and make balance on platforms. After collecting the golden egg the character and theme get changes. Help Pingu and friends to reach on top of platforms.', '', 'https://html5.gamemonetize.com/gjjxi70rzl1zj2zu92afqogjfikv6gzn/', 'html5', 640, 1136, 1576076683, '1', '0'),
(1049, 'gamemonetize-399', 'jelly-cube-rolling', 'Jelly Cube Rolling', 'https://img.gamemonetize.com/krwvza3puz06ausy8ua44ey2yafu989t/512x384.jpg', '0', 5, 0, '0', 'Welcome to the fun cube rolling game. In this game you need to take the cubes to the designated points with jelly cube style. Please note that in order to move the cube, there must be a space of 1 cube between it and the other cube. You will have fun with different levels. Don&#039;t forget to play thinking. This fun game is with you with the difference of Hitgames.org.', '', 'https://html5.gamemonetize.com/krwvza3puz06ausy8ua44ey2yafu989t/', 'html5', 900, 600, 1576076683, '1', '0'),
(1050, 'gamemonetize-398', 'burger-chef-restaurant', 'Burger Chef Restaurant', 'https://img.gamemonetize.com/y6pkdtnf21jc7wcuq3armxifq487i73h/512x384.jpg', '0', 1, 0, '0', 'Become the best chef of burgers cook and serve delicious hamburgers in your own burger restaurant. Manage your restaurant in one of the most dynamic and interesting cooking games! 180 levels, big burger chef championship, time attack are waiting you here!', '', 'https://html5.gamemonetize.com/y6pkdtnf21jc7wcuq3armxifq487i73h/', 'html5', 900, 600, 1576076683, '1', '0'),
(1051, 'gamemonetize-397', 'kitty-love-story', 'Kitty Love Story', 'https://img.gamemonetize.com/92ikie3b5ta6hw2z3dsp44ihwbcywtx5/512x384.jpg', '0', 1, 0, '0', 'Kitty&#039;s love is very strong. And as normal lovers, they never want to be separated. But unfortunately, they left each other. Draw a line to help them get together again using physics principle, solve these puzzles and pass all the levels. More than 120 levels are waiting for you.', '', 'https://html5.gamemonetize.com/92ikie3b5ta6hw2z3dsp44ihwbcywtx5/', 'html5', 900, 600, 1576076683, '1', '0'),
(1052, 'gamemonetize-396', 'drink-drive-survive', 'Drink Drive Survive', 'https://img.gamemonetize.com/4ulgcxa0hae6dy29lxx7wztjo183y663/512x384.jpg', '0', 4, 0, '0', 'Have you ever tried to drive while drunk? If the answer is no, good for you! me neither! So, what about a simulator that shows you the all the issues that a drunken driver has to face?', '', 'https://html5.gamemonetize.com/4ulgcxa0hae6dy29lxx7wztjo183y663/', 'html5', 560, 960, 1576076683, '1', '0'),
(1053, 'gamemonetize-395', 'twelve-puzzleguys', 'Twelve PuzzleGuys', 'https://img.gamemonetize.com/quz48yggxry54cyut53juh9olocmm3od/512x384.jpg', '0', 5, 0, '0', 'Hyper-casual puzzle game. Tap on the same numbers to grow them. Can you reach twelve?', '', 'https://html5.gamemonetize.com/quz48yggxry54cyut53juh9olocmm3od/', 'html5', 360, 640, 1576076683, '1', '0'),
(1054, 'gamemonetize-394', 'tomato-explosion', 'Tomato Explosion', 'https://img.gamemonetize.com/nbi2wev2qi5oig1okgvotflqz58w8r8w/512x384.jpg', '0', 5, 0, '0', 'Click on the tomato&#039;s before they explode. The tomato will change the color and you need to destroy the tomato before they become yellow and explode.', '', 'https://html5.gamemonetize.com/nbi2wev2qi5oig1okgvotflqz58w8r8w/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1055, 'gamemonetize-393', 'bts-oddbods-coloring-book', 'BTS OddBods Coloring Book', 'https://img.gamemonetize.com/slu2b2fii5m01qh0rxjap7druxnvjipb/512x384.jpg', '0', 1, 0, '0', 'Bts Oddbods Coloring is an online game that you can play for free. Coloring pages of cute Oddbods. Discover the world of Oddbods with original illustrations. These coloring pages really stimulate the kids creativity. Color within the lines. You can also download and print the coloring pages, to color them in real life, or print a finished image.', '', 'https://html5.gamemonetize.com/slu2b2fii5m01qh0rxjap7druxnvjipb/', 'html5', 854, 480, 1576076683, '1', '0'),
(1056, 'gamemonetize-392', 'pixel-gold-clicker', 'Pixel Gold Clicker', 'https://img.gamemonetize.com/tevecwwtp78nuvdydlrmy02wuqeidfs7/512x384.jpg', '0', 1, 0, '0', 'Get gold, buy all upgrades and eliminate the butterflies to get rich in this great game clicker', '', 'https://html5.gamemonetize.com/tevecwwtp78nuvdydlrmy02wuqeidfs7/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1057, 'gamemonetize-391', 'horse-show-jump-simulator-3d', 'Horse Show Jump Simulator 3D', 'https://img.gamemonetize.com/6l6b10eqc6cyglscfjthnq7plcwl7omd/512x384.jpg', '0', 1, 0, '0', 'Horse Show Jump Simulator 3D is an exciting animal simulator game where you can become a pro rider. The riding championship has begun, so you can test your riding skills easily. We have a futuristic full challenge, waiting for the rider like you!', '', 'https://html5.gamemonetize.com/6l6b10eqc6cyglscfjthnq7plcwl7omd/', 'html5', 900, 600, 1576076683, '1', '0'),
(1058, 'gamemonetize-390', 'my-dream-dentist', 'My Dream Dentist', 'https://img.gamemonetize.com/5woff9g6qaflfvpp9ret1g0ntvhyzej4/512x384.jpg', '0', 1, 0, '0', 'This is a fun and interesting dentist game. If you want to be a dentist doctor, this is a best game for you. In this dentist game, you will cure the teeth of your little patients. Be careful and make use of the right tools.', '', 'https://html5.gamemonetize.com/5woff9g6qaflfvpp9ret1g0ntvhyzej4/', 'html5', 500, 750, 1576076683, '1', '0'),
(1059, 'gamemonetize-389', 'eg-flappy-bounce', 'EG Flappy Bounce', 'https://img.gamemonetize.com/2t36v1okw6nedl0wgmtmjaff7yy6c8ue/512x384.jpg', '0', 1, 0, '0', 'EG Flappy Bounce is HTML5 games and funny. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/2t36v1okw6nedl0wgmtmjaff7yy6c8ue/', 'html5', 800, 600, 1576076683, '1', '0'),
(1060, 'gamemonetize-388', 'hidjigs-spring', 'HidJigs Spring', 'https://img.gamemonetize.com/79k8jdxdr077bd6a27q3rp91b3jgnl1v/512x384.jpg', '0', 5, 0, '0', 'Two games in one. Pick between the hidden objects and jigsaw puzzle mode, and enjoy the atmosphere of spring. 16 beautiful puzzles to solve.', '', 'https://html5.gamemonetize.com/79k8jdxdr077bd6a27q3rp91b3jgnl1v/', 'html5', 800, 450, 1576076683, '1', '0'),
(1061, 'gamemonetize-387', 'tap-heli-tap', 'Tap Heli Tap', 'https://img.gamemonetize.com/uzaom9yonf9yqehroodlxu880yovdtc7/512x384.jpg', '0', 3, 0, '0', 'Tap Heli Tap is fun helicopter flying game suitable for all ages. Tap your heli to the goal and make a high score. Avoid your enemies and collect coins on the way to get more points. Have fun playing.', '', 'https://html5.gamemonetize.com/uzaom9yonf9yqehroodlxu880yovdtc7/', 'html5', 480, 854, 1576076683, '1', '0'),
(1062, 'gamemonetize-386', 'transport-sea-animal', 'Transport Sea Animal', 'https://img.gamemonetize.com/lgtzfuy56qoreqlsigldq3p18sq4r69d/512x384.jpg', '0', 2, 0, '0', 'It is a challenging game in which you have to control a truck and transport huge marine animals from a point on the beach to the aquarium. Show your driver skills of large trucks driving on mountainous road with several slopes, sharp curves and many more dangers.', '', 'https://html5.gamemonetize.com/lgtzfuy56qoreqlsigldq3p18sq4r69d/', 'html5', 960, 640, 1576076683, '1', '0'),
(1063, 'gamemonetize-385', 'flappy-ball', 'Flappy Ball', 'https://img.gamemonetize.com/1ddvl5eu1q248buy8sm10g335fry4ic5/512x384.jpg', '0', 1, 0, '0', 'Flappy Ball is HTML5 games and funny. Foxzin.com with tons of games for all ages and bringing fun to player Play free online games.', '', 'https://html5.gamemonetize.com/1ddvl5eu1q248buy8sm10g335fry4ic5/', 'html5', 800, 600, 1576076683, '1', '0'),
(1064, 'gamemonetize-384', 'candy-rush', 'Candy Rush', 'https://img.gamemonetize.com/qirsk4ogt6r5ixh1j2wg3xtt7pypnhad/512x384.jpg', '0', 5, 0, '0', 'Candy Rush is a puzzle match 3 game with colorful and beautiful graphics, collect three or more of the same candy. The aim of the game is to reach a given number of points in each level to advance to the next. The more candies of the same type matched in a row (vertically or horizontally) - or in a group - the more points you receive! Time is of the essence, so hurry and play Candy Rush today!', '', 'https://html5.gamemonetize.com/qirsk4ogt6r5ixh1j2wg3xtt7pypnhad/', 'html5', 450, 800, 1576076683, '1', '0'),
(1065, 'gamemonetize-383', 'monsters-trucks-match-3', 'Monsters Trucks Match 3', 'https://img.gamemonetize.com/cicz2mk4g97zw91zb80vs6kumipxps21/512x384.jpg', '0', 5, 0, '0', 'In this match 3 game you need to sort three or more monsters truck in a row to destroy them. Try to pass all twelve levels. You need to get the score which is required with given moves. When you have enough points you can click on stop button to stop the game and to go to the next level.', '', 'https://html5.gamemonetize.com/cicz2mk4g97zw91zb80vs6kumipxps21/', 'html5', 800, 600, 1576076683, '1', '0'),
(1066, 'gamemonetize-382', 'cubes-blast', 'Cubes Blast', 'https://img.gamemonetize.com/8k8tl4cr9q5c2s0rlb1psieomsfpuhs3/512x384.jpg', '0', 5, 0, '0', 'Very fun game, it allows you to develop your reaction speed, your skill and your level of perception', '', 'https://html5.gamemonetize.com/8k8tl4cr9q5c2s0rlb1psieomsfpuhs3/', 'html5', 450, 750, 1576076683, '1', '0'),
(1067, 'gamemonetize-381', 'amazing-princess-coloring-book', 'Amazing Princess Coloring Book', 'https://img.gamemonetize.com/5wypw99stenozvq0nhyvzyztpczflrrr/512x384.jpg', '0', 1, 0, '0', 'All kids love to draw and paint! Rather, discover your new coloring with cute incredible princesses. Choose your favorite character and paint her in the traditional style. Or you can create for the princess a new unique multi-colored image. Use the movable panel on the right to select the desired color. Drag the palette panel with the left mouse button. Enjoy this new game «Amazing princess coloring book»!', '', 'https://html5.gamemonetize.com/5wypw99stenozvq0nhyvzyztpczflrrr/', 'html5', 800, 600, 1576076683, '1', '0'),
(1068, 'gamemonetize-380', 'princess-captain-avenger', 'Princess Captain Avenger', 'https://img.gamemonetize.com/5txfmhauja8c1krd2v9cdxax5e1urq2x/512x384.jpg', '0', 1, 0, '0', 'In the kingdom of Ice, all is calm, but the forces of evil are not asleep. Queen Eliza to fight with them. The real heroine must be not only brave, but also look great. Help Eliza choose a superhero costume worthy of great heroes themselves. Use a mix of classic royal outfits and space warrior vestments. Do not forget about the expressive makeup and hair. This will help to complement the image of the superheroine Eliza. Enjoy playing this wonderful game called &quot;Princess Captain Avenger&quot;!', '', 'https://html5.gamemonetize.com/5txfmhauja8c1krd2v9cdxax5e1urq2x/', 'html5', 800, 600, 1576076683, '1', '0'),
(1069, 'gamemonetize-379', 'build-your-robot', 'Build Your Robot', 'https://img.gamemonetize.com/oftx8bazwd1ttonxu70llmlx7zdsshdg/512x384.jpg', '0', 5, 0, '0', 'Who needs a big factory to create robots when you can easily do it on your computer or mobile?! In this game, you can use the available parts to create the robot that you have in mind easily and quickly! You can also save an image of your invention (the camera button on top of the screen) and show it to your friends!', '', 'https://html5.gamemonetize.com/oftx8bazwd1ttonxu70llmlx7zdsshdg/', 'html5', 480, 800, 1576076683, '1', '0'),
(1070, 'gamemonetize-378', 'commander-assualt-duty-2', 'Commander Assualt Duty 2', 'https://img.gamemonetize.com/rsqm7qwzclzar511mvib7p8tw033vmfn/512x384.jpg', '0', 3, 0, '0', 'Join the Special Forces and lead the counter attack on the growing militant group of terrorists that are taking down country by country! Only you can stop them and regain control back for a free society! As part of the Commander Assualt elite paramilitary team SPEAR.', '', 'https://html5.gamemonetize.com/rsqm7qwzclzar511mvib7p8tw033vmfn/', 'html5', 960, 600, 1576076683, '1', '0'),
(1071, 'gamemonetize-377', 'skydiving-iron', 'Skydiving Iron', 'https://img.gamemonetize.com/0x3e3t047p54zeig3eutyba517vmol9p/512x384.jpg', '0', 1, 0, '0', 'In this game you have to manage your own iron man, dodge enemy missiles and collect points that would improve their own equipment', '', 'https://html5.gamemonetize.com/0x3e3t047p54zeig3eutyba517vmol9p/', 'html5', 450, 750, 1576076683, '1', '0'),
(1072, 'gamemonetize-376', 'the-lost-chicken', 'The Lost Chicken', 'https://img.gamemonetize.com/4ndq95demskqk2qa50f4ysmmyzfaakaf/512x384.jpg', '0', 1, 0, '0', 'The Lost Chicken is a 3d arcade game where players smash, bump and bounce through revolving helix platforms to reach the end. Sound easy? You wish!! Your chicken smashes like a brick through colorful trees that block its descent, but if you hit a tree, it’s all over! Your chicken shatters to pieces and you have to start your fall all over again.', '', 'https://html5.gamemonetize.com/4ndq95demskqk2qa50f4ysmmyzfaakaf/', 'html5', 450, 750, 1576076683, '1', '0'),
(1073, 'gamemonetize-375', 'skateboard-adventures', 'Skateboard Adventures', 'https://img.gamemonetize.com/8zubmqrauw6w3n6go6b1ib7mcqikkk6s/512x384.jpg', '0', 5, 0, '0', 'Run with your skate and avoid swords who want to kill you. Tap on the screen to jump and to pass swords. There is two swords, from up and down side. You can jump maximum six times in air, so you need to be careful and to watch swords in what positions are.', '', 'https://html5.gamemonetize.com/8zubmqrauw6w3n6go6b1ib7mcqikkk6s/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1074, 'gamemonetize-374', 'slendrina-must-die-the-house', 'Slendrina Must Die: The House', 'https://img.gamemonetize.com/mbg9gi5xbc30tmujiqrw41bvozh8wqki/512x384.jpg', '0', 5, 0, '0', 'You need to figure out is Slendrina bulletproof. Can she really die... Find 8 pieces of a picture to find out the truth about Slendrina ! If you like Slenderman Must Die or Let&#039;s Kill Jeff The Killer, then you will love this horror fps game. * Three weapons: - Gun - Shotgun - DeathSword for melee attack * Awesome 3D Graphics', '', 'https://html5.gamemonetize.com/mbg9gi5xbc30tmujiqrw41bvozh8wqki/', 'html5', 1000, 700, 1576076683, '1', '0'),
(1075, 'gamemonetize-373', 'bull-shooting', 'Bull Shooting', 'https://img.gamemonetize.com/k9w28rxs8920ss1ockfcuvhetraigkp1/512x384.jpg', '0', 3, 0, '0', 'Return to the bullfight wilderness with this addictive bull fighting game. The terror on the city surpassed with wild bull rampage on the streets where the only solution to restore the peace is to aim and shoot them in the head. Bull Shooting game is designed to equip you with the latest of sniper gun to head the angry bull one by one bullfight.', '', 'https://html5.gamemonetize.com/k9w28rxs8920ss1ockfcuvhetraigkp1/', 'html5', 960, 600, 1576076683, '1', '0'),
(1076, 'gamemonetize-372', 'maze-and-tourist', 'Maze And Tourist', 'https://img.gamemonetize.com/09471h94b3nukipa9saullb8wc7a8uv8/512x384.jpg', '0', 1, 0, '0', 'Explore continent of Africa as a tourist and become familiar with its different countries and tourism attractions. During your long travel, you visit 15 different countries in Africa. Each country is considered as a level and in it, you will become familiar with that country’s name, flag, coat of arms, capital, official language and one of its most famous tourism attractions.', '', 'https://html5.gamemonetize.com/09471h94b3nukipa9saullb8wc7a8uv8/', 'html5', 1074, 540, 1576076683, '1', '0'),
(1077, 'gamemonetize-371', 'in-the-path', 'In The Path', 'https://img.gamemonetize.com/amvwoizgmj3y7izx7e4c0637uqtuhdfr/512x384.jpg', '0', 4, 0, '0', 'In this game your objective is change direction ball for the path for no collision in the walls and obtain gems for purchase more skins and reach the best score.', '', 'https://html5.gamemonetize.com/amvwoizgmj3y7izx7e4c0637uqtuhdfr/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(1078, 'gamemonetize-370', 'color-snake', 'Color Snake', 'https://img.gamemonetize.com/hwfp96ef5zz1wz9kh8x7y5oh444l1x8i/512x384.jpg', '0', 4, 0, '0', 'Color Snake - a classic endless arcade title. Color Snake is a brilliant endless arcade game in which you take control of a colored snake. Your snake can only hit the same objects as its own color – for example, if the snake is red, you can only hit red objects. If you hit any other color, you will die!', '', 'https://html5.gamemonetize.com/hwfp96ef5zz1wz9kh8x7y5oh444l1x8i/', 'html5', 450, 750, 1576076683, '1', '0'),
(1079, 'gamemonetize-369', 'final-night-zombie-street-fight', 'Final Night: Zombie Street Fight', 'https://img.gamemonetize.com/5y7h69xk515dgp01avdgc0ser78qqukv/512x384.jpg', '0', 4, 0, '0', 'It&#039;s been one year since the world went down, one year since the outbreak. We&#039;ve lost a lot of good people and going to lose more, but we&#039;re still going strong and must fight the undead! This is where your story begins. You are the Zombie Street Fighter! *** Features *** - Five different locations - Over 20 levels to play - You can pick up 3 weapons to strike the enemies: Knife, Baseball Bat and Gun - Easy controls - Adrenaline filled fights - Stunning 3d graphics - Action packed missions to compete - Incredible game-physics and fast paced game-play', '', 'https://html5.gamemonetize.com/5y7h69xk515dgp01avdgc0ser78qqukv/', 'html5', 1000, 700, 1576076683, '1', '0'),
(1080, 'gamemonetize-368', 'racing-gta-cars', 'Racing GTA Cars', 'https://img.gamemonetize.com/tid7qh97ozoe9fh2cojl5fvo18d0ald3/512x384.jpg', '0', 5, 0, '0', 'Racing GTA Cars is perfect choice for jigsaw puzzle lovers. This game is about fancy gta cars and it gives you the perfect jigsaw puzzle experience. Solve all puzzles and keep your brain sharp. You have three modes for each picture, easy medium and hard. There is no time limit so you can have a leisurely experience. Have fun playing', '', 'https://html5.gamemonetize.com/tid7qh97ozoe9fh2cojl5fvo18d0ald3/', 'html5', 854, 480, 1576076683, '1', '0'),
(1081, 'gamemonetize-367', 'super-bounce', 'Super Bounce', 'https://img.gamemonetize.com/8vkpsu19dr8up1pye1f59itfc0tanlmw/512x384.jpg', '0', 5, 0, '0', 'Jump on the platforms and beware of thorns! Just tap the screen to jump. Try not to fall! How far can you go?', '', 'https://html5.gamemonetize.com/8vkpsu19dr8up1pye1f59itfc0tanlmw/', 'html5', 960, 640, 1576076683, '1', '0'),
(1082, 'gamemonetize-366', 'foxi-mini-car-parking-2019-car-driving-test', 'Foxi Mini Car Parking 2019 Car Driving Test', 'https://img.gamemonetize.com/6olay5mdc3vieapfklnsecevevwbjimq/512x384.jpg', '0', 2, 0, '0', 'Foxi Mini Car Parking 2019 Car Driving Test, with best graphics, is full of adventure. This car school driving car parking simulator game will boost your car parking driving skills. You can play this speedy car parking simulator game to remove your stress and in spare time too. Fast racing Car parking game has unique and new designs of cars.', '', 'https://html5.gamemonetize.com/6olay5mdc3vieapfklnsecevevwbjimq/', 'html5', 960, 600, 1576076683, '1', '0'),
(1083, 'gamemonetize-365', 'little-cat-doctor', 'Little Cat Doctor', 'https://img.gamemonetize.com/iewxuj27z0vb3p5yjyh04i9nzwx28sbq/512x384.jpg', '0', 1, 0, '0', 'Work as a veterinarian in our animal hospital &amp; do cat surgery on animals - cat care games with funny pets will make you smile and have a great time taking care of cats! Inside the pet hospital game, there are many cute animals that you, as the best pet doctor, have to rescue! Download this fantastic pet vet clinic Little Cat Doctor and see how amazing pet vet games and hospital games are!', '', 'https://html5.gamemonetize.com/iewxuj27z0vb3p5yjyh04i9nzwx28sbq/', 'html5', 450, 750, 1576076683, '1', '0'),
(1084, 'gamemonetize-364', 'spike-avoid', 'Spike Avoid', 'https://img.gamemonetize.com/wruxp7tvl1qqgth8xd5gk9i3455zrexn/512x384.jpg', '0', 4, 0, '0', 'Avoid the spikes and obtain points for reach the best score and gems for purchase new skins.', '', 'https://html5.gamemonetize.com/wruxp7tvl1qqgth8xd5gk9i3455zrexn/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(1085, 'gamemonetize-363', 'cute-cat-doctor', 'Cute Cat Doctor', 'https://img.gamemonetize.com/fy34a7oqo20zjjbx0k9uzn5by5j9krez/512x384.jpg', '0', 1, 0, '0', 'Try new pet hospital game where you as a little pet doctor will take good care of all pet animals in trouble. An expert pet animal doctor is needed to help these cute but poor animals in best animal hospital games. This is an amazing pet vet games 2019.', '', 'https://html5.gamemonetize.com/fy34a7oqo20zjjbx0k9uzn5by5j9krez/', 'html5', 500, 750, 1576076683, '1', '0'),
(1086, 'gamemonetize-362', 'stickworld-io', 'StickWorld.io', 'https://img.gamemonetize.com/z2bw95ww1cb2y4bwkd57c9z69nkm2jz1/512x384.jpg', '0', 7, 1, '0', 'Battle your way to the top of the leaderboard in this fun .io game.', '', 'https://html5.gamemonetize.com/z2bw95ww1cb2y4bwkd57c9z69nkm2jz1/', 'html5', 800, 600, 1576076683, '1', '1'),
(1087, 'gamemonetize-361', 'tricky-impossible-tracks-car-stunt-racing', 'Tricky Impossible Tracks Car Stunt Racing', 'https://img.gamemonetize.com/3bbp6fnc2xbdzknn3i8eap1xc5vwe3wh/512x384.jpg', '0', 2, 0, '0', 'Are you ready to perform driving stunts and the role of a stuntman? Start your crazy monsters drive tour by driving top speed car on these crazy impossible and tricky tracks and be a real car stunt rider. Drive these legendary mid-air stunt cars on impossible tracks with crazy rivals and prove yourself a real stunt hero.', '', 'https://html5.gamemonetize.com/3bbp6fnc2xbdzknn3i8eap1xc5vwe3wh/', 'html5', 960, 640, 1576076683, '1', '0'),
(1088, 'gamemonetize-360', 'my-dream-hospital', 'My Dream Hospital', 'https://img.gamemonetize.com/pjz1zurnhpdqr7y9uli7io5x7iw2v4zl/512x384.jpg', '0', 1, 0, '0', 'To work as a doctor is a vocation, of course you first need to get a medical education, which made the heroine of the new game. over time, of course, she will open her own hospital, but for now the Hospital Of my Dreams will be just a dream, because you need to gain experience and you can do it after receiving a diploma from a medical University.', '', 'https://html5.gamemonetize.com/pjz1zurnhpdqr7y9uli7io5x7iw2v4zl/', 'html5', 960, 640, 1576076683, '1', '0'),
(1089, 'gamemonetize-359', 'fish3d-io', 'Fish3D.io', 'https://img.gamemonetize.com/vqy9q1ox3rpc0tprhyepf42mx5dasfxn/512x384.jpg', '0', 1, 0, '0', 'How to play? Be careful with your life is the red bar !! Eat plankton and grow Approach smaller fish and harm them to finish them dominate the small territory and be the largest fish but do not forget to eat grass and maintain their well-being. Have children as a protection measure since they will accompany you on your trip. The game may have delays on devices with less than 1GB of RAM !!', '', 'https://html5.gamemonetize.com/vqy9q1ox3rpc0tprhyepf42mx5dasfxn/', 'html5', 800, 600, 1576076683, '1', '0'),
(1090, 'gamemonetize-358', 'ice-princess-is-preparing-for-spring-ball', 'Ice Princess is preparing for spring ball', 'https://img.gamemonetize.com/6q1ewdemlo04uymf3cw3xznezog4rc7x/512x384.jpg', '0', 1, 0, '0', 'Spring has come. All residents of the magical kingdom are going to the ball at the Ice Princess Palace. Help Elize prepare the palace for the festival. Rather, start cleaning. Replace the broken glass and sweep the floor. Oh, how clean! It&#039;s time to decorate the throne room. Hang a garland of flowers, arrange treats on the tables and prepare gifts for guests. Balloons will create a festive atmosphere! It&#039;s time to start the fun!', '', 'https://html5.gamemonetize.com/6q1ewdemlo04uymf3cw3xznezog4rc7x/', 'html5', 800, 600, 1576076683, '1', '0'),
(1091, 'gamemonetize-357', 'cute-zoo', 'Cute Zoo', 'https://img.gamemonetize.com/tgds6pimvgjpnctxups1o5xc95ntpwhj/512x384.jpg', '0', 1, 0, '0', 'Welcome to Zoo! There are many cute animals - tigers, elephants, penguins and many others. Baby animals need your help and care. Heal the animals, wash and feed them. Play with the baby animals in fun games. The tiger cub loves to play with a toy mouse, the baby elephant loves balls, and penguins love to dive and swim. Have fun playing the game «Cute Zoo».', '', 'https://html5.gamemonetize.com/tgds6pimvgjpnctxups1o5xc95ntpwhj/', 'html5', 800, 600, 1576076683, '1', '0'),
(1092, 'gamemonetize-356', 'princess-incredible-spring-neon-hairstyles', 'Princess Incredible Spring Neon Hairstyles', 'https://img.gamemonetize.com/i0agujxjkx4f6yr6tp54q24zwmf3j262/512x384.jpg', '0', 1, 0, '0', 'Spring has come! It&#039;s time to try on bright neon outfits and change your hairstyle. Tiara always follows fashion, like a real princess of style. Use her favorite shades of green from emerald to juicy lime. Neon style and futuristic design will highlight the romantic multicolored hairstyles, decorated with blooming flowers. Bright neon makeup accentuates Tiara’s expressive brown eyes. Create your unique image this spring, enjoying the game &quot;Princess Incredible Spring Neon Hairstyles&quot;!', '', 'https://html5.gamemonetize.com/i0agujxjkx4f6yr6tp54q24zwmf3j262/', 'html5', 800, 600, 1576076683, '1', '0'),
(1093, 'gamemonetize-355', 'sea-creatures-coloring-book', 'Sea Creatures Coloring Book', 'https://img.gamemonetize.com/0wgneapegmjphfiun0zwcrvylthe00l1/512x384.jpg', '0', 1, 0, '0', 'All kids love to draw and paint! Today we will find ourselves in the amazing underwater world, where many interesting inhabitants. Do you know what color the octopus is? It turns out that he can change his color. But the crocodile is always green! Test your knowledge by coloring the sea creatures. Use the movable panel on the right to select the desired color. Drag the palette panel with the left mouse button. Enjoy this new game &quot;Sea creatures - coloring book&quot;!', '', 'https://html5.gamemonetize.com/0wgneapegmjphfiun0zwcrvylthe00l1/', 'html5', 800, 600, 1576076683, '1', '0'),
(1094, 'gamemonetize-354', 'world-cup-find-the-differences', 'World Cup Find the Differences', 'https://img.gamemonetize.com/4h4dw3w5640k3qd76sby10trtdrvxeq1/512x384.jpg', '0', 5, 0, '0', 'Now is the World Cup, let&#039;s have fun! Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/4h4dw3w5640k3qd76sby10trtdrvxeq1/', 'html5', 960, 540, 1576076683, '1', '0'),
(1095, 'gamemonetize-353', 'mandala-coloring-book', 'Mandala Coloring Book', 'https://img.gamemonetize.com/jvlhyncmu9ejlcovucyotycmvgat1w5l/512x384.jpg', '0', 1, 0, '0', 'Choose your favorite colors and give your special touch to lots of beautiful drawings, A mind journey which makes you anxiety free and stress relieving! Have fun in this relaxing painting experience, refill the energy and let anxiety fade away through coloring games.', '', 'https://html5.gamemonetize.com/jvlhyncmu9ejlcovucyotycmvgat1w5l/', 'html5', 550, 750, 1576076683, '1', '0'),
(1096, 'gamemonetize-352', 'garden-decoration-flower-decoration', 'Garden Decoration Flower Decoration', 'https://img.gamemonetize.com/iov4q11hzxdjwoq5qbe1rzs0805nikx1/512x384.jpg', '0', 1, 0, '0', 'To all of you who have a green thumb, we prepared a treat! One of the most attractive type of farm games Garden Design Games – Flower Decoration flower arrangements and a simple and easy garden design in one, is here, so make sure you get it and start expressing your creativity! The flower arrangement and design mixed with “garden repairing game” is the best one yet! Show off your gardening skills like planting, tending and harvesting beautiful and colorful buds', '', 'https://html5.gamemonetize.com/iov4q11hzxdjwoq5qbe1rzs0805nikx1/', 'html5', 960, 640, 1576076683, '1', '0'),
(1097, 'gamemonetize-351', 'eg-cartoon-candy', 'EG Cartoon Candy', 'https://img.gamemonetize.com/4ir1fxkl897wmtp6k5orlqy1r4wv2247/512x384.jpg', '0', 5, 0, '0', 'EG Cartoon Candy is HTML5 games. You should link connect image puzzle. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/4ir1fxkl897wmtp6k5orlqy1r4wv2247/', 'html5', 800, 600, 1576076683, '1', '0'),
(1098, 'gamemonetize-350', 'kick-the-buddy-jigsaw', 'Kick the Buddy Jigsaw', 'https://img.gamemonetize.com/6hogi5n52fbhgfw2c8mss4k9znyd07w6/512x384.jpg', '0', 5, 0, '0', 'Kick the Buddy Jigsaw is a free online game from genre of puzzle and jigsaw games. In this game you have a total of 12 pictures. You need to start from the first one and to unlock the next image. You have three modes for each picture: Easy with 25 pieces, Medium with 49 pieces and Hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/6hogi5n52fbhgfw2c8mss4k9znyd07w6/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1099, 'gamemonetize-349', 'king-of-jungle', 'King of Jungle', 'https://img.gamemonetize.com/9repde8lzo4xs0jnceh2ykxzwntlrho1/512x384.jpg', '0', 5, 0, '0', 'King of Jungle is jigsaw game where you can solve the images with jungle animals. Put the pieces in right direction and get the image. You have time to do this. Try to pass all 12 images and to win in this addictive game.', '', 'https://html5.gamemonetize.com/9repde8lzo4xs0jnceh2ykxzwntlrho1/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1100, 'gamemonetize-348', 'black-or-white', 'Black Or White', 'https://img.gamemonetize.com/y34vpwoe60eyx0acbdvfa1q07i401730/512x384.jpg', '0', 5, 0, '0', 'Tap the screen to carefully control the ball through the obstacles. The ball can only cross the obstacles whose color is the same with its. Do not pass through the wrong color, or you’ll have to start again. And be careful, the color of the ball may change randomly.', '', 'https://html5.gamemonetize.com/y34vpwoe60eyx0acbdvfa1q07i401730/', 'html5', 540, 960, 1576076683, '1', '0'),
(1101, 'gamemonetize-347', 'square-jump', 'Square Jump', 'https://img.gamemonetize.com/oehflqbdd1b55cgijo16ocmkw4317olw/512x384.jpg', '0', 4, 0, '0', 'Jump, run and avoid the spikes for no death', '', 'https://html5.gamemonetize.com/oehflqbdd1b55cgijo16ocmkw4317olw/', 'html5', 800, 600, 1576076683, '1', '0'),
(1102, 'gamemonetize-346', 'shoot-your-nightmare-space-isolation', 'Shoot Your Nightmare: Space Isolation', 'https://img.gamemonetize.com/kic1i5wrwd7rn093cpptuxdoszjtggv0/512x384.jpg', '0', 4, 0, '0', 'You are waking up on a planet ML-397. The year is 2299. And you have no idea where you are or who you are... Everything looks empty. It seems that no one is here. You are alone... But soon, very soon, you will find out that is not truth! Shoot Your Nightmare: Space Isolation brings you the best sci-fi/horror FPS experience! Key Features * Slick futuristic 3D graphics - making a game feel like reality. * You alone have yourself to rely on to prevent the apocalypse. * Non-stop Sci-Fi FPS Alien Shooter Action! * Awesome Sci-Fi Weapons * Good known Poison Games GAMEPLAY! * Easy controls Find out w', '', 'https://html5.gamemonetize.com/kic1i5wrwd7rn093cpptuxdoszjtggv0/', 'html5', 860, 660, 1576076683, '1', '0'),
(1103, 'gamemonetize-345', 'bts-minecraft-coloring', 'BTS Minecraft Coloring', 'https://img.gamemonetize.com/i2wygybee40haou3dkkv24unr3ldd9fv/512x384.jpg', '0', 5, 0, '0', 'BTS Minecraft Coloring is an online game that you can play for free alone or with your friends. Come play the nice coloring game! What is your favorite color? You will definitely find it in this game and you can color these cool minecraft figures. Create your own monster and enviroment. Maybe you can become an artist. Share pictures with your friends. You can play the game on your mobile as well. Have a good time in BTS Minecraft Coloring Book!', '', 'https://html5.gamemonetize.com/i2wygybee40haou3dkkv24unr3ldd9fv/', 'html5', 480, 854, 1576076683, '1', '0'),
(1104, 'gamemonetize-344', 'tattoo-salon-art-design', 'Tattoo Salon Art Design', 'https://img.gamemonetize.com/gua3hpi2x2i17zu2oqlxg6w2kycycxvs/512x384.jpg', '0', 1, 0, '0', 'Ever wanted to have a tattoo? Wondering about a sleeve made out of painted pictures on your body? Look no further! Your search is over! You are in the right spot and we guarantee that you will not be disappointed! Download this tattooing game and become the best there is in this area of work! Become the Ink Master that everybody is talking about!', '', 'https://html5.gamemonetize.com/gua3hpi2x2i17zu2oqlxg6w2kycycxvs/', 'html5', 450, 750, 1576076683, '1', '0'),
(1105, 'gamemonetize-343', 'stay-on-road', 'Stay on Road', 'https://img.gamemonetize.com/aycwt4qoh9ra6q6gldkfiyyjj53hfllq/512x384.jpg', '0', 2, 0, '0', 'Drift around the corners as you attempt to complete as many laps as possible without crashing. Your goal is simple: keep your car on the road!', '', 'https://html5.gamemonetize.com/aycwt4qoh9ra6q6gldkfiyyjj53hfllq/', 'html5', 960, 540, 1576076683, '1', '0'),
(1106, 'gamemonetize-342', 'kids-go-shopping-supermarket', 'Kids Go Shopping Supermarket', 'https://img.gamemonetize.com/xeacgeftw6yl9ris5ec2zhgn5i15mnsk/512x384.jpg', '0', 1, 0, '0', 'Ever wondered how supermarkets work Dont hesitate anymore Supermarket Mania Kids Go Shopping is a fun shopping girl game that gives you an idea of how supermarkets and shopping malls work and offers you an unforgettable virtual grocery shopping experience', '', 'https://html5.gamemonetize.com/xeacgeftw6yl9ris5ec2zhgn5i15mnsk/', 'html5', 960, 640, 1576076683, '1', '0'),
(1107, 'gamemonetize-341', 'extreme-atv-quad-racer', 'Extreme ATV Quad Racer', 'https://img.gamemonetize.com/v80zruurtag0g8ezljy5i7q2qrsiqv3m/512x384.jpg', '0', 2, 0, '0', 'Buckle up for ride ATV bike on highway roads with with full blazingly fast speed and win the race. While racing on highway tracks don&#039;t hit any other vehicles you&#039;ll get busted in ATV quad-bike racing games. You can choose from 4 different environmets to drive and 3 modes in each of them. Complete different tasks and have fun!', '', 'https://html5.gamemonetize.com/v80zruurtag0g8ezljy5i7q2qrsiqv3m/', 'html5', 900, 600, 1576076683, '1', '0'),
(1108, 'gamemonetize-340', 'rise-egg-up', 'Rise Egg Up', 'https://img.gamemonetize.com/yv6k0ym76iyck39ijofq6ifber1bx6iw/512x384.jpg', '0', 2, 0, '0', 'Cleverly move your shield to protect the egg from many obstacles. Features: - realistic physics - many types of obstacles - colorful world', '', 'https://html5.gamemonetize.com/yv6k0ym76iyck39ijofq6ifber1bx6iw/', 'html5', 540, 960, 1576076683, '1', '0'),
(1109, 'gamemonetize-339', 'happy-green-earth', 'Happy Green Earth', 'https://img.gamemonetize.com/8ujvupi8brhey2gf6n6t3vamg4r3e1gm/512x384.jpg', '0', 5, 0, '0', 'Mother Earth is running out of water. The flora and fauna on earth are about to die of thirst. Let&#039;s lead the water back to the Earth to save her, the plants, the animals, and save the humans ourselves.', '', 'https://html5.gamemonetize.com/8ujvupi8brhey2gf6n6t3vamg4r3e1gm/', 'html5', 540, 960, 1576076683, '1', '0'),
(1110, 'gamemonetize-338', 'rise-to-sky', 'Rise To Sky', 'https://img.gamemonetize.com/zi4yvwd0gmzs7hwf5bjc9dnb4fljp1gp/512x384.jpg', '0', 4, 0, '0', 'Rise To Sky and avoid the barriers, obtain gems and purchase more spaceships', '', 'https://html5.gamemonetize.com/zi4yvwd0gmzs7hwf5bjc9dnb4fljp1gp/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(1111, 'gamemonetize-337', 'slenderman-history-wwii-faceless-horror', 'Slenderman History: WWII Faceless Horror', 'https://img.gamemonetize.com/7uzir0iy9n7veh6q9pebyrqve139ufk1/512x384.jpg', '0', 4, 0, '0', 'The Nazis have always made great villains and for good reason. During the World War they performed a series of medical experiments on their soldiers, trying to make a super soldier. They even played with the Occult. With powerful ancient artifact they summon the devil himself. His name is Slenderman! Infiltrate the Nazi base, find the secret bunker and recover two briefcases with documents about their experiments. Good Luck! Features: * Awesome 3D Graphics * Intuitive controls that are easy to pick up and play * Lot of levels to play * Good WWII Story * Jumpscares and Scary Sounds', '', 'https://html5.gamemonetize.com/7uzir0iy9n7veh6q9pebyrqve139ufk1/', 'html5', 860, 660, 1576076683, '1', '0'),
(1112, 'gamemonetize-336', 'lego-superhero-race', 'Lego Superhero Race', 'https://img.gamemonetize.com/qnnnq8vd03c0ikoyzxbrhtlesbzbn40e/512x384.jpg', '0', 2, 0, '0', 'Lego Superhero Race is mind blowing racing game for Lego lovers. 10 different racing cars with more than 100 different body parts and colors available for customization. Unlock new cars and get good understanding of racing track, before you play race. Try to break records and have fun playing this amazing Lego Superhero race game.', '', 'https://html5.gamemonetize.com/qnnnq8vd03c0ikoyzxbrhtlesbzbn40e/', 'html5', 1080, 600, 1576076683, '1', '0'),
(1113, 'gamemonetize-335', 'aquarium-game', 'Aquarium Game', 'https://img.gamemonetize.com/04rny1xnhzq7p93ri4wg3xv87svkmm9n/512x384.jpg', '0', 1, 0, '0', 'Have you ever thought of taking care of your own pet fish &amp; building an amazing adventure aquarium for these little water creatures? Sounds fun, doesn’t it? This fish games and water tank cleaning games allows you to be a proud owner of your own fish tank, so take care of your little water creatures, build and cleanit aquarium like a fish doctor. Well well, all you need is to download this water tan cleaning &amp; pet fish games to start adventure aquarium right now!', '', 'https://html5.gamemonetize.com/04rny1xnhzq7p93ri4wg3xv87svkmm9n/', 'html5', 960, 640, 1576076683, '1', '0'),
(1114, 'gamemonetize-334', 'impossible-bike-racing-3d', 'Impossible Bike Racing 3D', 'https://img.gamemonetize.com/m4d6dz74axoia0t6rkl6dg0vgeuvypdl/512x384.jpg', '0', 2, 0, '0', 'Welcome to Impossible Bike Racing 3D game in which you will have to race bike and make real stunts on impossible tracks in the air. Tracks are very risky you have to race your heavy bike carefully on adventurous air tracks. Reduce bike speed while taking sharp turns on monster air tracks. Use WASD or Arrows to drive, Shift - nitro, R - restart.', '', 'https://html5.gamemonetize.com/m4d6dz74axoia0t6rkl6dg0vgeuvypdl/', 'html5', 900, 600, 1576076683, '1', '0'),
(1115, 'gamemonetize-333', 'basketball-swooshes', 'Basketball Swooshes', 'https://img.gamemonetize.com/p8qzdu3823gh1rc092yvjoaqy15ia5pz/512x384.jpg', '0', 8, 0, '0', 'Who plays the best basketball in the world? Great one on one basketball game. Be quicker and more precise than your opponent.', '', 'https://html5.gamemonetize.com/p8qzdu3823gh1rc092yvjoaqy15ia5pz/', 'html5', 800, 450, 1576076683, '1', '0'),
(1116, 'gamemonetize-332', 'snow-plow-jeep-simulator-3d', 'Snow Plow Jeep Simulator 3D', 'https://img.gamemonetize.com/wwgwtprebrdd1ayew0jge99swdgf2s4y/512x384.jpg', '0', 2, 0, '0', 'When winter comes the yard is constantly snowing, which sleeps the whole area. Because of this, the roads come to a dangerous state and quite often various accidents occur on them. Today in the game Snow Plow Jeep Driving you will work with the municipal service of a small town located in a mountainous area. Your duties include cleaning the roads from snow.', '', 'https://html5.gamemonetize.com/wwgwtprebrdd1ayew0jge99swdgf2s4y/', 'html5', 900, 600, 1576076683, '1', '0'),
(1117, 'gamemonetize-331', 'stars-and-clouds', 'Stars and Clouds', 'https://img.gamemonetize.com/ko0k88yuk8ps8h8ps056coqimheuv56f/512x384.jpg', '0', 5, 0, '0', 'Now is the time to collect all the stars from the sky! In this game you have nine levels and for each level you have a certain time to collect the stars between the clouds. In each level you have an hourglass that gives you extra time to complete the level. Have fun!', '', 'https://html5.gamemonetize.com/ko0k88yuk8ps8h8ps056coqimheuv56f/', 'html5', 480, 800, 1576076683, '1', '0'),
(1118, 'gamemonetize-330', 'broken-cars-jigsaw', 'Broken Cars Jigsaw', 'https://img.gamemonetize.com/d7ttv440jhs73p1sg8o3yf39h77pc1ep/512x384.jpg', '0', 5, 0, '0', 'This is interesting jigsaw game with five images of broken cars. Choose your favorite image to start to play and choose with how many pieces you want to play in this puzzle game.', '', 'https://html5.gamemonetize.com/d7ttv440jhs73p1sg8o3yf39h77pc1ep/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1119, 'gamemonetize-329', 'extreme-winter-oil-tanker-truck-drive', 'Extreme Winter Oil Tanker Truck Drive', 'https://img.gamemonetize.com/041nwu5qlcb4ci33miuzq6cs0l4vjsjj/512x384.jpg', '0', 1, 0, '0', 'Winter survival is hard and oil plays an important part in helping with that. People need your help in transporting oil to be used for vehicles and heating. The roads are slippery, the path is treacherous and snowfall is intermittent. Make sure you are extremely careful driving in these dangerous conditions.', '', 'https://html5.gamemonetize.com/041nwu5qlcb4ci33miuzq6cs0l4vjsjj/', 'html5', 900, 600, 1576076683, '1', '0'),
(1120, 'gamemonetize-328', 'sweet-pony-coloring-book', 'Sweet Pony Coloring Book', 'https://img.gamemonetize.com/ilclqlbjpehvpi1git9x09n10t2651jn/512x384.jpg', '0', 1, 0, '0', 'Discover the new coloring book with cute ponies. Sweet Pony Coloring book includes 5 different ponies and after you are done with painting, you can use the image button to save the colored image and show it to your friends!', '', 'https://html5.gamemonetize.com/ilclqlbjpehvpi1git9x09n10t2651jn/', 'html5', 800, 600, 1576076683, '1', '0'),
(1121, 'gamemonetize-327', 'jump-in-the-wall', 'Jump In The Wall', 'https://img.gamemonetize.com/c700vu012jkcgzbblqh9m6ertohgta96/512x384.jpg', '0', 4, 0, '0', 'Jump in the wall and obtain points for reach the best score and gems for purchase new skins.', '', 'https://html5.gamemonetize.com/c700vu012jkcgzbblqh9m6ertohgta96/', 'html5', 1080, 1920, 1576076683, '1', '0'),
(1122, 'gamemonetize-326', 'cotton-candy-shop', 'Cotton Candy Shop', 'https://img.gamemonetize.com/urti71w3ola7bgub80geh5p28du1l6tg/512x384.jpg', '0', 1, 0, '0', 'Cotton Candy Shop is the best candy game Become the creator of great food and surprise your customers in the cooking game with delicious desserts', '', 'https://html5.gamemonetize.com/urti71w3ola7bgub80geh5p28du1l6tg/', 'html5', 450, 750, 1576076683, '1', '0')";
$db[28] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1123, 'gamemonetize-325', 'minecraft-puzzle-time', 'Minecraft Puzzle Time', 'https://img.gamemonetize.com/smo9tjdr3j0yoa5tdoajvr0hp6e2c9m4/512x384.jpg', '0', 5, 0, '0', 'Minecraft Puzzle Time is fun puzzle game suitable for all ages. The aim of the game is simple, just put all small puzzle pieces on the original spot to get a whole image. Have fun playing.', '', 'https://html5.gamemonetize.com/smo9tjdr3j0yoa5tdoajvr0hp6e2c9m4/', 'html5', 854, 480, 1576076683, '1', '0'),
(1124, 'gamemonetize-324', 'muscle-car-robot', 'Muscle Car Robot', 'https://img.gamemonetize.com/6osy0r4ywmipv5jzfl0dinzdo1tnmgls/512x384.jpg', '0', 5, 0, '0', 'What will you do if your country would be under attack by bandits? You will surely transform into a super robot , isn&#039;t it? If yes then let&#039;s fight back with ultimate crazy superhero robot transform &amp; real car transform robots which are bravest warriors to save earth from the speed alien robots.', '', 'https://html5.gamemonetize.com/6osy0r4ywmipv5jzfl0dinzdo1tnmgls/', 'html5', 960, 600, 1576076683, '1', '0'),
(1125, 'gamemonetize-323', 'change-the-color', 'Change The Color', 'https://img.gamemonetize.com/dkgeqtau1juc07rs7zo3yfz4ixlyc5qq/512x384.jpg', '0', 4, 0, '0', 'Change the color in white and black, catch the same color for obtain the best score', '', 'https://html5.gamemonetize.com/dkgeqtau1juc07rs7zo3yfz4ixlyc5qq/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1126, 'gamemonetize-322', 'alice-jump', 'Alice Jump', 'https://img.gamemonetize.com/zunm16e8pjoqjxpgqf1n02obn8doo86n/512x384.jpg', '0', 4, 0, '0', 'Welcome to the world of Magical Island where Alice has to find fairy to save her friends with the help of magical powers throughout the game and collect apple for energy! Reach as much higher as you can to meet fairy. Stay away with skulls or you will loose.', '', 'https://html5.gamemonetize.com/zunm16e8pjoqjxpgqf1n02obn8doo86n/', 'html5', 480, 640, 1576076683, '1', '0'),
(1127, 'gamemonetize-321', 'monster-truck-hidden-keys', 'Monster Truck Hidden Keys', 'https://img.gamemonetize.com/b27kphl4bdykij40sqr25u87tsf4nlwz/512x384.jpg', '0', 5, 0, '0', 'Monster Truck Hidden Keys is a free online skill and hidden object game. Find out the hidden keys in the specified images. Each level has 10 hidden keys. There are 6 levels in total. The time is limited so be fast and find all hidden objects before time runs out. Clicking in the wrong place several times reduces the time by an additional 5 seconds. So, if you are ready start the game and have fun!', '', 'https://html5.gamemonetize.com/b27kphl4bdykij40sqr25u87tsf4nlwz/', 'html5', 960, 540, 1576076683, '1', '0'),
(1128, 'gamemonetize-320', 'pvp-pong-challenge', 'PvP Pong Challenge', 'https://img.gamemonetize.com/in27d5akzcz8bsw9m2d4wlrrbibazopi/512x384.jpg', '0', 5, 0, '0', 'PvP Pong Challenge is fun html pong game suitable for all ages. Play against your friend and try to win. Use keyboard to play or buttons if you play on mobile device. First to is a winner. Have fun!', '', 'https://html5.gamemonetize.com/in27d5akzcz8bsw9m2d4wlrrbibazopi/', 'html5', 854, 480, 1576076683, '1', '0'),
(1129, 'gamemonetize-319', 'impossible-truck-stunt-parking', 'Impossible Truck Stunt Parking', 'https://img.gamemonetize.com/i2ql9vbsbrs90mx0jkgbi47379faa51t/512x384.jpg', '0', 1, 0, '0', 'Are you like driving games? If yes then you will love to play the latest and unique truck driving and impossible parking game. Learn how to drive and park the huge vehicle on the impossible tracks. Steer your truck on the treacherous tracks fast and park it on the right parking spot.', '', 'https://html5.gamemonetize.com/i2ql9vbsbrs90mx0jkgbi47379faa51t/', 'html5', 900, 600, 1576076683, '1', '0'),
(1130, 'gamemonetize-318', 'airplane-parking-mania-3d', 'Airplane Parking Mania 3D', 'https://img.gamemonetize.com/yocodudqrhhe2bzpbx8xrsbrpe0yyefx/512x384.jpg', '0', 1, 0, '0', 'Become the best pilot and fly your own selected Airport plane to the parking destination. Explore the World of airport airplanes and learn parking skills. Parking an huge plane is not so easy, face the difficulties of plane parking on the right slots.', '', 'https://html5.gamemonetize.com/yocodudqrhhe2bzpbx8xrsbrpe0yyefx/', 'html5', 900, 600, 1576076683, '1', '0'),
(1131, 'gamemonetize-317', 'jeff-the-killer-vs-slendrina', 'Jeff The Killer VS Slendrina', 'https://img.gamemonetize.com/oxa7wlh24u1z99y4mx3eaa50hpnk39fs/512x384.jpg', '0', 3, 0, '0', 'Jeff The Killer Story: You got bored from Slendrinas fame. As humans can&#039;t stop her, you must! Take her Teddy Bears, 8 of them and Kill her! Good luck! Slendrina Story: You got bored from Jeff The Killer fame. As humans can&#039;t stop him, you must! Take his lovely photos, 8 of them and Kill him! Good luck! Features: - Third Person Horror Game. - Play as Jeff The Killer Or Slendrina. - Intuitive controls that are easy to pick up and play. - High quality 3D environment graphics. - Gameplay from Poison Games that you love. - Two maps: Jeff The Killer Asylum and Slendrinas House.', '', 'https://html5.gamemonetize.com/oxa7wlh24u1z99y4mx3eaa50hpnk39fs/', 'html5', 960, 600, 1576076683, '1', '0'),
(1132, 'gamemonetize-316', 'kids-secrets-find-the-difference', 'Kids Secrets Find the Difference', 'https://img.gamemonetize.com/tipmm4ak052ihn41xqxb1morq0x621wv/512x384.jpg', '0', 5, 0, '0', 'Behind these pictures are small differences. Can you find them? They are fun designs for you to play with. A game that is fun and educational because it will help you improve your observation and concentration skills. You have 10 levels and 7 differences, for each level you have one minute to finish the same.', '', 'https://html5.gamemonetize.com/tipmm4ak052ihn41xqxb1morq0x621wv/', 'html5', 960, 540, 1576076683, '1', '0'),
(1133, 'gamemonetize-315', 'love-animals', 'Love Animals', 'https://img.gamemonetize.com/gvum0hnhmzu8ww9alsydh84xljlhwd5c/512x384.jpg', '0', 5, 0, '0', 'Draw lines to help each pair of the animals to touch each other.', '', 'https://html5.gamemonetize.com/gvum0hnhmzu8ww9alsydh84xljlhwd5c/', 'html5', 960, 540, 1576076683, '1', '0'),
(1134, 'gamemonetize-314', 'don-t-touch-the-stones', 'Don&#039;t Touch The Stones', 'https://img.gamemonetize.com/zlful5my30wzl1khys3kzbh4jgs9gktf/512x384.jpg', '0', 4, 0, '0', 'Control your owl to avoid the stones! How long can you make it?', '', 'https://html5.gamemonetize.com/zlful5my30wzl1khys3kzbh4jgs9gktf/', 'html5', 540, 960, 1576076683, '1', '0'),
(1135, 'gamemonetize-313', 'connect-the-gems', 'Connect The Gems', 'https://img.gamemonetize.com/b00ak3z6pkj9b6dxwkqvobacjb8do4v0/512x384.jpg', '0', 5, 0, '0', 'Connect pairs of matching gems by creating a path between them.', '', 'https://html5.gamemonetize.com/b00ak3z6pkj9b6dxwkqvobacjb8do4v0/', 'html5', 540, 960, 1576076683, '1', '0'),
(1136, 'gamemonetize-312', 'eg-supercars-puzzle', 'EG Supercars Puzzle', 'https://img.gamemonetize.com/iji12eahfqq7fnqu87iiuo6volhzdyjv/512x384.jpg', '0', 5, 0, '0', 'EG Supercars Puzzle - HTML5 Games - very nice game for kids with sports cars puzzles! Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/iji12eahfqq7fnqu87iiuo6volhzdyjv/', 'html5', 800, 600, 1576076683, '1', '0'),
(1137, 'gamemonetize-311', 'rail-blazers-runner', 'Rail Blazers Runner', 'https://img.gamemonetize.com/dlvr284zpvuo60mf1knok5maumari0lw/512x384.jpg', '0', 4, 0, '0', 'Rail Blazers is on of the best free 3D running games. Run on upto 5 lane monorail and subway tracks, as well as water racing tracks. This running game is packed with fresh and new, original and fun, addicting and captivating play features. Running, Surfing, Racing, Speed boat riding, Flying and Hoverin, as well as, the thrilling Bonus rounds!', '', 'https://html5.gamemonetize.com/dlvr284zpvuo60mf1knok5maumari0lw/', 'html5', 900, 600, 1576076683, '1', '0'),
(1138, 'gamemonetize-310', 'classic-car-parking-3d', 'Classic Car Parking 3D', 'https://img.gamemonetize.com/qsvjioepkv9tnzzxoqfyeqm7mek59h80/512x384.jpg', '0', 1, 0, '0', 'Classic Car Parking 3D is full of fun and enjoyment. This car parking games will develop your driving skills but not car racing skills. Brace yourself to fun with the newest, unique car parking game of 2018. This parking mania game will teach you various parking skills with old vintage car.', '', 'https://html5.gamemonetize.com/qsvjioepkv9tnzzxoqfyeqm7mek59h80/', 'html5', 900, 600, 1576076683, '1', '0'),
(1139, 'gamemonetize-309', 'knife-io', 'Knife.io', 'https://img.gamemonetize.com/98fobvogybhln41bs1hwj35wfuvfllku/512x384.jpg', '0', 4, 0, '0', 'Knife.io is multiplayer new io game. Addictive and innovative io game! Collect blades, knife, weapon and use your spin to slay your enemies in this furious sword mayhem! Who will survive in this crazy IO battle of guts and steel?', '', 'https://html5.gamemonetize.com/98fobvogybhln41bs1hwj35wfuvfllku/', 'html5', 480, 800, 1576076683, '1', '0'),
(1140, 'gamemonetize-308', 'cubic-tower', 'Cubic Tower', 'https://img.gamemonetize.com/9qob4smp4noye93dtafzs2zvdcvb22mb/512x384.jpg', '0', 4, 0, '0', 'Build your own tower? Challenge the classic arcade game, but watch out – the digital edition has some new tricks!', '', 'https://html5.gamemonetize.com/9qob4smp4noye93dtafzs2zvdcvb22mb/', 'html5', 800, 600, 1576076683, '1', '0'),
(1141, 'gamemonetize-307', 'grill-house', 'Grill House', 'https://img.gamemonetize.com/0fscz95eq3ym8pat2g7x4x8jrd5b7vq8/512x384.jpg', '0', 1, 0, '0', 'Who likes cooking? You can become the best chef of burgers, hot dogs or sandwiches. Cook and serve delicious meals to your guests in your own grill house restaurant.', '', 'https://html5.gamemonetize.com/0fscz95eq3ym8pat2g7x4x8jrd5b7vq8/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1142, 'gamemonetize-306', 'animals-rugby-flick', 'Animals Rugby Flick', 'https://img.gamemonetize.com/iks1otd8c9s6pw311j6mtqsv0y9taaws/512x384.jpg', '0', 8, 0, '0', 'Playing rugby by flicking the animals to score goals.', '', 'https://html5.gamemonetize.com/iks1otd8c9s6pw311j6mtqsv0y9taaws/', 'html5', 540, 960, 1576076683, '1', '0'),
(1143, 'gamemonetize-305', 'babysitter-crazy-daycare', 'Babysitter Crazy Daycare', 'https://img.gamemonetize.com/xq8qsvw4w7i6ud8ixbq8daynmlluuzcs/512x384.jpg', '0', 1, 0, '0', 'The parents are tired and confused, their baby queen is restless, and they need a day off after reading a baby story! They are looking for the best nanny in nanny babysitting games for free, in this babysitting madness and they found her! If you want to become the best baby caring caregiver of the babysitter daycare, you are in the right place! Babysitter Crazy Daycare Games - Nanny Mania can give you a babysitter makeover!', '', 'https://html5.gamemonetize.com/xq8qsvw4w7i6ud8ixbq8daynmlluuzcs/', 'html5', 450, 750, 1576076683, '1', '0'),
(1144, 'gamemonetize-304', 'fire-bird', 'Fire Bird', 'https://img.gamemonetize.com/qq1gqiwv6x8xt3nlyxsudz1g70amcd92/512x384.jpg', '0', 1, 0, '0', 'You will play a bird that flying in the sky and avoid the obstacles. Can you do it for higher score and try to beat your friends along the way? Quick and decisive game, for reaction check!', '', 'https://html5.gamemonetize.com/qq1gqiwv6x8xt3nlyxsudz1g70amcd92/', 'html5', 900, 600, 1576076683, '1', '0'),
(1145, 'gamemonetize-303', 'gift-of-alchemy', 'Gift Of Alchemy', 'https://img.gamemonetize.com/p9df7xdknianjytoz02juu21dl143l2s/512x384.jpg', '0', 4, 0, '0', 'Centuries passed, history became legend,legend became myth and for two thousand years the sacred art of alchemy passed out of all knowledge, stumbling in on one of the remains of the alchemist tomb,destiny has chosen you to rekindle the lost art and revive the era of the Alchemist&#039;s..., Alchemy is based on manipulating and altering matter by using natural energy, this is called Transmutation Comprehension, Deconstruction and reconstruction are three cyclic parts of transmutation. ﻿ Hidden people always had some descendants passing this art only to those who had the capacity. Learn spells ', '', 'https://html5.gamemonetize.com/p9df7xdknianjytoz02juu21dl143l2s/', 'html5', 700, 900, 1576076683, '1', '0'),
(1146, 'gamemonetize-302', 'truck-racing-differences', 'Truck Racing Differences', 'https://img.gamemonetize.com/i1lgexikyzv398mi4hgi8k4q5n3thzbz/512x384.jpg', '0', 5, 0, '0', 'In this differences game we offer you ten images with racing trucks. In all images there is seven mistakes or differences, and your job is to find all 7 differences for two minutes. Start to play and pass all levels to win in this game', '', 'https://html5.gamemonetize.com/i1lgexikyzv398mi4hgi8k4q5n3thzbz/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1147, 'gamemonetize-301', 'smart-eq-forfour-puzzle', 'Smart EQ Forfour Puzzle', 'https://img.gamemonetize.com/vyut07g405y0rju2n3qh1yhvuigwyeqt/512x384.jpg', '0', 5, 0, '0', 'Play with 6 images in this perfect jigsaw puzzle game: Smart EQ Forfour Puzzle. All images is with the smart eq forfour. Solve all puzzles and keep your brain sharp. You have four modes for each picture, 16 pieces, 36 pieces, 64 pieces and 100 pieces. Enjoy and have fun.', '', 'https://html5.gamemonetize.com/vyut07g405y0rju2n3qh1yhvuigwyeqt/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1148, 'gamemonetize-300', 'bus-parking-in-the-port', 'Bus Parking in the Port', 'https://img.gamemonetize.com/uqpru5l3t32x3xinm2y53y996s8oif5c/512x384.jpg', '0', 2, 0, '0', 'Bus Parking in the Port is a fun bus simulating game and it has realistic controls as well as great dynamic game play. This game has everything a bus simulator needs to have! Control your bus in a real port parking. Shift your gear forwards or backwards whenever you want to! You can change the angle of your camera and experience 3D parking challenge. There are 104 different levels for testing your skills in parking!', '', 'https://html5.gamemonetize.com/uqpru5l3t32x3xinm2y53y996s8oif5c/', 'html5', 960, 640, 1576076683, '1', '0'),
(1149, 'gamemonetize-299', 'run-race-3', 'Run Race 3', 'https://img.gamemonetize.com/p7zgaiau0psl6ph8gql0re8nffgf1imq/512x384.jpg', '0', 4, 0, '0', 'Play Run Race 3 for free online! Participate in a series of challenging obstacle courses. Time your jumps perfectly and cross the finish line first!', '', 'https://html5.gamemonetize.com/p7zgaiau0psl6ph8gql0re8nffgf1imq/', 'html5', 800, 600, 1576076683, '1', '0'),
(1150, 'gamemonetize-298', 'mr-bullet-2', 'Mr Bullet 2', 'https://img.gamemonetize.com/dw0q3lfmf3azzdjaolch835kw5r145rh/512x384.jpg', '0', 4, 0, '0', 'Mr Bullet 2 is a perfect combination of puzzle game and shooting game which suits both newbies and masters. Play as a special agent with amazing shooting skills, you will do a top-secret mission which is to take down zombies, ninjas, gangsters and more. You must eliminate all targets in each level by using as few bullets as possible. Each stage gives you a certain number of the bullet.', '', 'https://html5.gamemonetize.com/dw0q3lfmf3azzdjaolch835kw5r145rh/', 'html5', 480, 800, 1576076683, '1', '0'),
(1151, 'gamemonetize-297', 'worms-zone-a-slithery-snake', 'Worms Zone a Slithery Snake', 'https://img.gamemonetize.com/vz6qfngm0al4ggz8f3lrvrfrqrm1q19m/512x384.jpg', '0', 1, 0, '0', 'Worms Zone is a game with a dynamic storyline. Start growing your worm right now. Having tried to get a real anaconda, a small worm never gets stuck in one place – he’s ready to bite everyone. However, there is a danger to be eaten by a more successful player. The Worms are real gourmets. They love trying various gelatinous goodies and everything they meet on their route.', '', 'https://html5.gamemonetize.com/vz6qfngm0al4ggz8f3lrvrfrqrm1q19m/', 'html5', 800, 600, 1576076683, '1', '1'),
(1152, 'gamemonetize-296', 'space-invaders', 'Space Invaders', 'https://img.gamemonetize.com/mbrq58hyzwz8x0t9ccbdjd9z2125y30l/512x384.jpg', '0', 3, 0, '0', 'Space invaders is fun shooting game for kids and adults Our planet is under attack and you need to defend it Have fun playing', '', 'https://html5.gamemonetize.com/mbrq58hyzwz8x0t9ccbdjd9z2125y30l/', 'html5', 480, 854, 1576076683, '1', '0'),
(1153, 'gamemonetize-295', 'multiplayer-pong-time', 'Multiplayer Pong Time', 'https://img.gamemonetize.com/krl6g7pxkwbbvw49g355zqgwdk36eplz/512x384.jpg', '0', 1, 0, '0', 'Multiplayer Pong Time is fun sport game suitable for all ages. Type your nick name wait for your opponent and start playing. Have fun!', '', 'https://html5.gamemonetize.com/krl6g7pxkwbbvw49g355zqgwdk36eplz/', 'html5', 854, 480, 1576076683, '1', '0'),
(1154, 'gamemonetize-294', 'scary-granny-basement-escape', 'Scary Granny: Basement Escape', 'https://img.gamemonetize.com/1u15k2letj4ujuxcd69vircg21lzw41x/512x384.jpg', '0', 1, 0, '0', 'Scary Granny: Basement Escape is a brand new game where you will face with Scary Evil Granny that want to find and kill you. You have to find all exit doors and escape from Basement. But beware from Scary Evil Granny.', '', 'https://html5.gamemonetize.com/1u15k2letj4ujuxcd69vircg21lzw41x/', 'html5', 900, 600, 1576076683, '1', '0'),
(1155, 'gamemonetize-293', 'evil-granny-horror-village', 'Evil Granny: Horror Village', 'https://img.gamemonetize.com/24u1p0gfjitbtrirbv7gf7b9sspbmv0p/512x384.jpg', '0', 1, 0, '0', 'Evil Granny: Horror Village is a brand new game where you will face with Scary Evil Granny that want to find and kill you. You have to find all treasure boxes and escape from Horror Village. But beware from Scary Evil Granny.', '', 'https://html5.gamemonetize.com/24u1p0gfjitbtrirbv7gf7b9sspbmv0p/', 'html5', 900, 600, 1576076683, '1', '0'),
(1156, 'gamemonetize-292', 'happy-glass-puzzles', 'Happy Glass Puzzles', 'https://img.gamemonetize.com/28n4a72ig2ztbfe0dmil32ozz21i2zg4/512x384.jpg', '0', 5, 0, '0', 'Three different modes of play with collectable items to unlock.', '', 'https://html5.gamemonetize.com/28n4a72ig2ztbfe0dmil32ozz21i2zg4/', 'html5', 800, 600, 1576076683, '1', '0'),
(1157, 'gamemonetize-291', 'airplane-flying-simulator', 'Airplane Flying Simulator', 'https://img.gamemonetize.com/ibqn6tq9kf90iuv6nuye1u659qoia8ht/512x384.jpg', '0', 1, 0, '0', 'Flight Simulator 3D is an awesome new 3D Airplane Simulator game, become the pilot and fly your commercial Airplane to the destination. Guide and steer your plane through all of the way points to ensure you head to the correct destination, go through all of the way points and land at your destination airport within the time limit to earn yourself more pilot stripes.', '', 'https://html5.gamemonetize.com/ibqn6tq9kf90iuv6nuye1u659qoia8ht/', 'html5', 960, 600, 1576076683, '1', '0'),
(1158, 'gamemonetize-290', 'space-roll', 'Space Roll', 'https://img.gamemonetize.com/ff8i72ewvdh7ixkr7l9wdl5leby7nt93/512x384.jpg', '0', 1, 0, '0', 'Space Roll is an addictive and stunning game Can you roll the space ball safely on a galaxy or neon platform as long as possible Collect gems to buy new colorful balls and avoid obstacles and gaps Have fun', '', 'https://html5.gamemonetize.com/ff8i72ewvdh7ixkr7l9wdl5leby7nt93/', 'html5', 450, 750, 1576076683, '1', '0'),
(1159, 'gamemonetize-289', 'vegas-city-highway-bus-parking-simulator', 'Vegas City Highway Bus: Parking Simulator', 'https://img.gamemonetize.com/pbzehwt77hwdd6omj6y9rgzu0yvlm9gb/512x384.jpg', '0', 2, 0, '0', '“Vegas City Highway: Bus Parking Simulator” is s parking simulator game in a city, the city give a fell as you are in Vegas city of dream. Try this “Vegas City Highway: Bus Parking Simulator”, and enjoy the real driving with new challenge parking one mistake and you are gone. Small vehicles Parking is easy to park. “Vegas City Highway: Bus Parking Simulator” looks easy to park but who know? Experience your real driving and parking skills in this “Vegas City Highway: Bus Parking Simulator”.', '', 'https://html5.gamemonetize.com/pbzehwt77hwdd6omj6y9rgzu0yvlm9gb/', 'html5', 960, 600, 1576076683, '1', '0'),
(1160, 'gamemonetize-288', 'penguin-io', 'Penguin.io', 'https://img.gamemonetize.com/t0uytaxwffwixwvylg3ulcaeoidyilkb/512x384.jpg', '0', 1, 0, '0', 'Penguins at the North pole is never boring, they are constantly busy with something, it can be a search for food, various games, rest or struggle for survival on an ice floe. The latter seems to be a game, but we would call it a game with death. Why so, and not otherwise, it is difficult to answer, one thing is clear-the one who will survive in the game Penguin.IO, the will become the most popular penguin in pack of.', '', 'https://html5.gamemonetize.com/t0uytaxwffwixwvylg3ulcaeoidyilkb/', 'html5', 450, 750, 1576076683, '1', '0'),
(1161, 'gamemonetize-287', 'rolly-cube', 'Rolly Cube', 'https://img.gamemonetize.com/ifeybmnuvigka85g2z9rh5yjkxnbwkof/512x384.jpg', '0', 4, 0, '0', 'Big and beautiful cubic world, just like in the cubic universe, in the background you can see the mountains, the river and the sun with clouds. But there is something very terrible and incomprehensible in this beauty. What is it and whether you can find out where the Role of the Cube is going, and it is better not to know, and with it to try to survive.', '', 'https://html5.gamemonetize.com/ifeybmnuvigka85g2z9rh5yjkxnbwkof/', 'html5', 450, 750, 1576076683, '1', '0'),
(1162, 'gamemonetize-286', 'princesses-trendy-social-networks', 'Princesses - Trendy Social NetWorks', 'https://img.gamemonetize.com/v64ur1fzu1ddk9zfbuwj4tvnd3ttmfoi/512x384.jpg', '0', 1, 0, '0', 'Modern women of fashion can’t live without social networks. Princess girlfriends had a cool idea for a fashion party. Girls decided to make outfits in the style of popular social networks. Aelita is the queen of Instagram. Tiara can’t even a day without talking with her friends in the Snapchate. Jacqueline love to draw and share fashion ideas on Pinterest. Eliza leads her group on Facebook and loves blue colors. Annie always has a smartphone on hand to communicate in WhatsApp.', '', 'https://html5.gamemonetize.com/v64ur1fzu1ddk9zfbuwj4tvnd3ttmfoi/', 'html5', 800, 600, 1576076683, '1', '0'),
(1163, 'gamemonetize-285', 'offroad-snow-jeep-passenger-mountain-uphill-drivin', 'Offroad Snow Jeep Passenger Mountain Uphill Drivin', 'https://img.gamemonetize.com/3c66z0vbag4yb3w0pseaykvqt4l81ag4/512x384.jpg', '0', 2, 0, '0', 'Transport passengers in a fun and exciting manner Mountain Jeep Passenger Transport Driver 19 An ultimate offroad adventure awaits you! Mountain Jeep Passenger Transport Driver 19 is an exceptional game that guarantees limitless fun and excitement. It is an action and adventure packed game with unlimited thrills and delights.', '', 'https://html5.gamemonetize.com/3c66z0vbag4yb3w0pseaykvqt4l81ag4/', 'html5', 960, 600, 1576076683, '1', '0'),
(1164, 'gamemonetize-284', 'spin-the-color', 'Spin The Color', 'https://img.gamemonetize.com/nwvhmtv9gvhb9992uaf97tgd7qhhtfeg/512x384.jpg', '0', 4, 0, '0', 'Change color for pairs the same ball color and obtain the best score', '', 'https://html5.gamemonetize.com/nwvhmtv9gvhb9992uaf97tgd7qhhtfeg/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1165, 'gamemonetize-283', 'ambulance-rescue-driver-simulator-2018', 'Ambulance Rescue Driver Simulator 2018', 'https://img.gamemonetize.com/mzr0rw7p8xxgy8n1zsroig6s77irj456/512x384.jpg', '0', 2, 0, '0', 'Want to rescue the innocent and injured in an all new ambulance rescue driving game? Save those who get into a traffic accident by transporting patients to a hospital. Sound the ambulance sirens and be the best ambulance driver in this rescue game.Nothing is as stimulating as saving a human life. Drive fast! The patients need help and have to see a doctor, they need urgent medical care in this ambulance driving simulator 3D game 2018.', '', 'https://html5.gamemonetize.com/mzr0rw7p8xxgy8n1zsroig6s77irj456/', 'html5', 960, 600, 1576076683, '1', '0'),
(1166, 'gamemonetize-282', 'hexalau', 'HexaLau', 'https://img.gamemonetize.com/zy5jbmeskngdd3idld30tyito7zujfdi/512x384.jpg', '0', 5, 0, '0', 'Puzzle game, similar to the legendary &#039;Lines&#039;, but with a twist. Connect 4, or more hexagons, of the same number, and clear the board as long as you can. While new hexagons appear, your room for maneuver decreases.', '', 'https://html5.gamemonetize.com/zy5jbmeskngdd3idld30tyito7zujfdi/', 'html5', 540, 960, 1576076683, '1', '0'),
(1167, 'gamemonetize-281', 'pet-subway-surfer', 'Pet Subway Surfer', 'https://img.gamemonetize.com/mtnospeklydejensgb3igdd0fpiugly3/512x384.jpg', '0', 5, 0, '0', 'Pet Subway Surfers is an amazing running game. Run along the craziest scenarios in the Pet Subway Train City. Drag to jump or slide and to move left or right. Avoid hitting trucks, buses and subway trains. Run around the Pet Subway Train city, subway, forest and beach and gather all the coins you can.', '', 'https://html5.gamemonetize.com/mtnospeklydejensgb3igdd0fpiugly3/', 'html5', 450, 790, 1576076683, '1', '0'),
(1168, 'gamemonetize-280', 'shark-attack', 'Shark Attack', 'https://img.gamemonetize.com/4pf45zrkuykkl00bji0x8owfj6w4ia9m/512x384.jpg', '0', 1, 0, '0', 'Try to become the biggest shark on the server in this fun online .io game.', '', 'https://html5.gamemonetize.com/4pf45zrkuykkl00bji0x8owfj6w4ia9m/', 'html5', 800, 600, 1576076683, '1', '0'),
(1169, 'gamemonetize-279', 'fps-shooter-3d-city-wars', 'FPS Shooter 3D City Wars', 'https://img.gamemonetize.com/pf7jzmgxhlkpt1er9iszdxlktwdl5evv/512x384.jpg', '0', 3, 0, '0', 'FPS Shooter 3D City Wars is the most exciting and challenging first-person shooter (FPS) game where you and your team fight against terrorists. No time to hesitate, take real action to dismantle terrorist organizations!', '', 'https://html5.gamemonetize.com/pf7jzmgxhlkpt1er9iszdxlktwdl5evv/', 'html5', 960, 640, 1576076683, '1', '0'),
(1170, 'gamemonetize-278', 'domino-legend', 'Domino Legend', 'https://img.gamemonetize.com/o4rpuip107eaw9bvmptvi359wpb48sew/512x384.jpg', '0', 5, 0, '0', 'A classic game of dominoes! Whether you are an experienced player or you haven´t played since your childhood days, this game will provide you with a great experience. You can enjoy the most popular Block and Draw variations of the game. Nothing stands in between you and a quick game of dominoes. Simply boot it up and play!', '', 'https://html5.gamemonetize.com/o4rpuip107eaw9bvmptvi359wpb48sew/', 'html5', 400, 600, 1576076683, '1', '0'),
(1171, 'gamemonetize-277', 'road-fury', 'Road Fury', 'https://img.gamemonetize.com/nmo3l66t97ypoctsdra0k2ct3d60eax2/512x384.jpg', '0', 5, 0, '0', 'Unleash your fury on the highway an shoot down everything that moves! Tip: if you can&#039;t shoot it, take it... those are power-ups! Upgrade your car to withstand a longer ride, beat bosses and get as far as you can so you can compare your highscores with others! Become the furious king of the road!', '', 'https://html5.gamemonetize.com/nmo3l66t97ypoctsdra0k2ct3d60eax2/', 'html5', 400, 600, 1576076683, '1', '0'),
(1172, 'gamemonetize-276', 'tasty-jewel', 'Tasty Jewel', 'https://img.gamemonetize.com/eo5azdz3j0uyrt5ea3myh0skfe9g807n/512x384.jpg', '0', 5, 0, '0', 'This box of sweets contains precious jewel candies! Match and combine them to craft exploding ones! It can help you crush through blocks standing in your way. The classic turn based match-3 arcade with lots of challenging levels and modes awaits you!', '', 'https://html5.gamemonetize.com/eo5azdz3j0uyrt5ea3myh0skfe9g807n/', 'html5', 800, 600, 1576076683, '1', '0'),
(1173, 'gamemonetize-275', 'get-10-plus', 'Get 10 Plus', 'https://img.gamemonetize.com/68iunzfpg3udfzk90tzld8w9cgazvzr1/512x384.jpg', '0', 5, 0, '0', 'Do you like math or logic games? Thanks to this amusing number connecting you will start to love it! Match the same adjacent numbers to convert them to a higher number. Match further to reach 10 and beyond! Easy to play, hard to master!', '', 'https://html5.gamemonetize.com/68iunzfpg3udfzk90tzld8w9cgazvzr1/', 'html5', 400, 600, 1576076683, '1', '0'),
(1174, 'gamemonetize-274', 'granny-horror-village', 'Granny Horror Village', 'https://img.gamemonetize.com/nbdcv5mk3jh3b3cmlbbb3e4gn2mxmt19/512x384.jpg', '0', 5, 0, '0', 'Granny Horror Village is a free online first person horror game. You must look at your surroundings and solve a plethora of challenging puzzles to escape. The 3D graphics are cool, and the gameplay is intense!', '', 'https://html5.gamemonetize.com/nbdcv5mk3jh3b3cmlbbb3e4gn2mxmt19/', 'html5', 960, 600, 1576076683, '1', '1'),
(1175, 'gamemonetize-273', 'princess-eliza-going-to-aquapark', 'Princess Eliza Going To Aquapark', 'https://img.gamemonetize.com/gg9inkn8da32isc7stxcbkrbcan6s6v9/512x384.jpg', '0', 1, 0, '0', 'Eliza is getting bored when spending time in her house. She wants to go to the aquapark. Join her and make sure she looks perfect in the aquapark. Pick the most beautiful summer dresses, hairstyles and accessories.', '', 'https://html5.gamemonetize.com/gg9inkn8da32isc7stxcbkrbcan6s6v9/', 'html5', 800, 600, 1576076683, '1', '0'),
(1176, 'gamemonetize-272', 'surviving-in-the-woods', 'Surviving in the Woods', 'https://img.gamemonetize.com/cxedvwbfyy7xj96rdt8o0thto5yftgz5/512x384.jpg', '0', 1, 0, '0', 'Surviving in the Woods is a brand new survival game where your mission is to survive in the wild forest. The only tool you have is an axe. There are many trees around you, use them to build a shelter in the forest. You can play in two location: day forest and night forest.', '', 'https://html5.gamemonetize.com/cxedvwbfyy7xj96rdt8o0thto5yftgz5/', 'html5', 900, 600, 1576076683, '1', '0'),
(1177, 'gamemonetize-271', 'talking-tom-diamond-hunt', 'Talking Tom Diamond Hunt', 'https://img.gamemonetize.com/mqyiln6hwcecd0jomjxgva48plqeqybd/512x384.jpg', '0', 1, 0, '0', 'Talking Tom Diamond Hunt is an online game that you can play for free. Talking Tom Diamond Hunt is an interesting online game suitable for all ages. Click or tap on the screen at the wright moment to help our lovely Tom collect as many diamonds as possible. Pay attention to let Tom&#039;s feet fall to the ground, or the game will fail. Jump around and have fun!', '', 'https://html5.gamemonetize.com/mqyiln6hwcecd0jomjxgva48plqeqybd/', 'html5', 854, 480, 1576076683, '1', '0'),
(1178, 'gamemonetize-270', 'bicycle-rickshaw-simulator', 'Bicycle Rickshaw Simulator', 'https://img.gamemonetize.com/bis1ig1owg9nk6a8yuyittuv3cmi1jxd/512x384.jpg', '0', 2, 0, '0', 'Welcome to the Public Tricycle Rickshaw Driving Simulator long drive highway, realistic cycle rickshaw drive experience is waiting. You have played many rickshaw simulator games before but this cycle rickshaw is awesome and has many challenging levels. Enjoy your game!', '', 'https://html5.gamemonetize.com/bis1ig1owg9nk6a8yuyittuv3cmi1jxd/', 'html5', 900, 600, 1576076683, '1', '0'),
(1179, 'gamemonetize-269', 'dead-zombie-hunting', 'Dead Zombie Hunting', 'https://img.gamemonetize.com/sr255e0n21l72y29klqgm2dxdnd3c5k5/512x384.jpg', '0', 3, 0, '0', 'Dead Zombie Hunting is #1 first person shooter of eye-popping 3D graphics combined with blood boiling zombie survival strategy game. All survivors are driven by one goal: stay alive as long as you can!', '', 'https://html5.gamemonetize.com/sr255e0n21l72y29klqgm2dxdnd3c5k5/', 'html5', 960, 600, 1576076683, '1', '0'),
(1180, 'gamemonetize-268', 'hex-puzzleguys', 'Hex PuzzleGuys', 'https://img.gamemonetize.com/atcvvge955ef1x6r6lbnv181zyhnn0vx/512x384.jpg', '0', 5, 0, '0', 'Connect 4 hexagons of the same color, it&#039;s that simple!', '', 'https://html5.gamemonetize.com/atcvvge955ef1x6r6lbnv181zyhnn0vx/', 'html5', 960, 615, 1576076683, '1', '0'),
(1181, 'gamemonetize-267', 'geometry-dash-mr-dubstep', 'Geometry Dash: Mr Dubstep', 'https://img.gamemonetize.com/mqr2a987873hwxhmt8ppubbvjzjv01vm/512x384.jpg', '0', 5, 0, '0', 'Seven character to unlock, 15 addictive levels, endless mode are waiting for you in Geometry Dash: Mr. Dubstep game.', '', 'https://html5.gamemonetize.com/mqr2a987873hwxhmt8ppubbvjzjv01vm/', 'html5', 900, 600, 1576076683, '1', '0'),
(1182, 'gamemonetize-266', 'stack-ball-phoenix', 'Stack Ball Phoenix', 'https://img.gamemonetize.com/8mrtwn70m9p5cb5e4omzbguhha02f0on/512x384.jpg', '0', 4, 0, '0', 'Bring the ball to the bottom and win the game in this highly addicting Helix game.', '', 'https://html5.gamemonetize.com/8mrtwn70m9p5cb5e4omzbguhha02f0on/', 'html5', 960, 600, 1576076683, '1', '0'),
(1183, 'gamemonetize-265', 'hitcity-car-parking', 'HitCity Car Parking', 'https://img.gamemonetize.com/yibquxv9l8hnw6gskxgh92gmdq3qasr9/512x384.jpg', '0', 2, 0, '0', 'A realistic parking game with you. You must park in the parking lot without contacting the vehicle with 100+ sections. Earn money to modify your vehicle by passing different tasks. A real parking game Hit Games with you with the difference. Have Fun.', '', 'https://html5.gamemonetize.com/yibquxv9l8hnw6gskxgh92gmdq3qasr9/', 'html5', 900, 600, 1576076683, '1', '0'),
(1184, 'gamemonetize-264', 'punch-box', 'Punch Box', 'https://img.gamemonetize.com/21ctt01gb9ko37my6ajy8hn1fs2jftji/512x384.jpg', '0', 2, 0, '0', 'You are a boxer with very low money and because you can’t afford to train at gyms, you train by punching boxes! You have to tap on the sides of the screen to punch and destroy boxes and be careful to avoid sharp wood that is on some boxes or otherwise you will get knock out! Also, remember that there is a time limit and you have to punch boxes to earn more time. So punch as fast as you can and earn more score!', '', 'https://html5.gamemonetize.com/21ctt01gb9ko37my6ajy8hn1fs2jftji/', 'html5', 768, 1366, 1576076683, '1', '0'),
(1185, 'gamemonetize-263', 'air-stunts-flying-simulator', 'Air Stunts Flying Simulator', 'https://img.gamemonetize.com/gyrwmrfkf13w1p08u6iq05w83t21kf80/512x384.jpg', '0', 1, 0, '0', 'Fly on the plane to destination point and use your parachute. Enjoy your super speed freefall and don’t forget to open your parachute on time! Aim to the giant target, maneuver with the parachute to land there.', '', 'https://html5.gamemonetize.com/gyrwmrfkf13w1p08u6iq05w83t21kf80/', 'html5', 900, 600, 1576076683, '1', '0'),
(1186, 'gamemonetize-262', 'street-fight-3d', 'Street Fight 3D', 'https://img.gamemonetize.com/pdwdo2d5py40zdbmukfog84jdqyh26ir/512x384.jpg', '0', 1, 0, '0', 'You are welcome to fight for your survival in this epic game. Goons up your alley, save yourself by beating some thugs along the way. And do not forget to bring gun in this knives fight. Remember no rules in love and war. You are captain and all we have to say is aye aye Captain!', '', 'https://html5.gamemonetize.com/pdwdo2d5py40zdbmukfog84jdqyh26ir/', 'html5', 1000, 600, 1576076683, '1', '0'),
(1187, 'gamemonetize-261', 'anti-stress-game-2', 'Anti Stress Game 2', 'https://img.gamemonetize.com/yjwti2yuki9iiohvwqscz1abn23i32l1/512x384.jpg', '0', 1, 0, '0', 'Anti Stress Game 2 is an online HTML5 game suitable for all ages. Anti Stress Game is a typical arcade game which is good for relaxation as matter of fact. You are allowed to play with letters, coloring, arrows, the window, the bubbles and the cool stones including the buddy. Here is no space and time limitation in this game. Good luck and have fun relaxing here!', '', 'https://html5.gamemonetize.com/yjwti2yuki9iiohvwqscz1abn23i32l1/', 'html5', 480, 854, 1576076683, '1', '0'),
(1188, 'gamemonetize-260', 'desert-rush', 'Desert Rush', 'https://img.gamemonetize.com/zrrzl1932zgh5phfqaq33axx6tv3pi8p/512x384.jpg', '0', 5, 0, '0', 'Desert Rush is a typical arcade matching game. Your goal is to connect the dots. Three animals surviving their way out from their hunters. Master Chain reactions Bigger the chain stronger the attack. A chain comprising of 12+ gems will yield a surprise Ariel attack. Unique game fun to play, epic adventure. There are about 30+ unique levels for you to challenge yourself. Bosses change with every stage and difficulty becomes more fun after clearing each level.', '', 'https://html5.gamemonetize.com/zrrzl1932zgh5phfqaq33axx6tv3pi8p/', 'html5', 1000, 625, 1576076683, '1', '0'),
(1189, 'gamemonetize-259', 'taxi-driver-simulator-3d', 'Taxi Driver Simulator 3D', 'https://img.gamemonetize.com/yu1zn0azawiota78zd19yrbec862dznc/512x384.jpg', '0', 1, 0, '0', 'Try to become a taxi driver in one of the best taxi simulator. Race your car through the big city traffic, pick up passengers and drive them safely to their destinations. Get in your taxi, fasten your seat belts and become a city traffic racer.', '', 'https://html5.gamemonetize.com/yu1zn0azawiota78zd19yrbec862dznc/', 'html5', 900, 600, 1576076683, '1', '0'),
(1190, 'gamemonetize-258', 'scary-granny-house', 'Scary Granny House', 'https://img.gamemonetize.com/l7b08g1gwob1u5qfye1qh2e03mmrsqfd/512x384.jpg', '0', 1, 0, '0', 'This is a Scary Granny House game where you have to explore the house of Scary Granny and find next door to escape safely before strange midnight woman caught you.', '', 'https://html5.gamemonetize.com/l7b08g1gwob1u5qfye1qh2e03mmrsqfd/', 'html5', 900, 600, 1576076683, '1', '0'),
(1191, 'gamemonetize-257', 'scary-helix', 'Scary Helix', 'https://img.gamemonetize.com/yd01lnira64rbgvkki3len50r95xqzqo/512x384.jpg', '0', 1, 0, '0', 'Bring the ball to the bottom of the Helix maze without touching the colored tiles and win the game.', '', 'https://html5.gamemonetize.com/yd01lnira64rbgvkki3len50r95xqzqo/', 'html5', 960, 600, 1576076683, '1', '0'),
(1192, 'gamemonetize-256', 'trucks-and-digger-jigsaw', 'Trucks and Digger Jigsaw', 'https://img.gamemonetize.com/ycn0fvmwr8gf2zuwm8gv0zpwx7bqnx9m/512x384.jpg', '0', 5, 0, '0', 'Five great images with bulldozers, diggers and trucks in this game. Choose your favorite image and start to play this game. Choose mode to play and enjoy in the game. You can play with 25, 49 or 100 pieces.', '', 'https://html5.gamemonetize.com/ycn0fvmwr8gf2zuwm8gv0zpwx7bqnx9m/', 'html5', 1280, 900, 1576076683, '1', '0'),
(1193, 'gamemonetize-255', 'bts-cute-cats-coloring', 'BTS Cute Cats Coloring', 'https://img.gamemonetize.com/2irzjze72clas5okxy4sbfku076y41a6/512x384.jpg', '0', 5, 0, '0', 'BTS Cute Cats Coloring Book is a fun colorig game suitable for all ages. You can play BTS Cute Cats Coloring Book in your browser for free. Do you like drawing? This is a drawing game, l believe you will like it. You can choose your favorite photos and color it according to your ideas. Use your imagination and start to draw.', '', 'https://html5.gamemonetize.com/2irzjze72clas5okxy4sbfku076y41a6/', 'html5', 854, 480, 1576076683, '1', '0'),
(1194, 'gamemonetize-254', 'jungle-matching', 'Jungle Matching', 'https://img.gamemonetize.com/qsz3jqdb28mcbimv0njaoix1lhi6ctr3/512x384.jpg', '0', 5, 0, '0', 'Jungle Matching is fun html5 game for kids that you can play for free. The aim of the game is to find all matching images in all levels to win the game. The game is time limited but you can buy you some extra time by watching the ad. Have fun playing.', '', 'https://html5.gamemonetize.com/qsz3jqdb28mcbimv0njaoix1lhi6ctr3/', 'html5', 854, 480, 1576076683, '1', '0'),
(1195, 'gamemonetize-253', 'bank-cash-transit-3d-security-van-simulator-2018', 'Bank Cash Transit 3D Security Van Simulator 2018', 'https://img.gamemonetize.com/410558t93g5u9dm5nwzsncpbjqztx7n1/512x384.jpg', '0', 1, 0, '0', 'Play Bank Cash Transit 3D: Security Van Simulator 2018 &amp; Drive for Mega Cash Cash, full of cash. In this simulator you can get cash from a truck from the main bank to other ATMs of the bank with a high degree of security. Enter a police van to secure your cash and drive a van full of cash. Be like a bank teller and carry cash to another ATM machine. These are the best banking simulation games ever.', '', 'https://html5.gamemonetize.com/410558t93g5u9dm5nwzsncpbjqztx7n1/', 'html5', 960, 600, 1576076683, '1', '0'),
(1196, 'gamemonetize-252', 'snow-drift', 'Snow Drift', 'https://img.gamemonetize.com/sky8jtgu5nnewne63th1d7uuuikrk7rc/512x384.jpg', '0', 2, 0, '0', 'Every novice driver always tries to follow all the rules of the road and saves the car, but as soon as the experience and knowledge increase, as well as the level of professionalism, the driver decides that he can afford more, that is, he is not afraid to increase the speed to the limit, he is not afraid to brake sharply and turn sharply.', '', 'https://html5.gamemonetize.com/sky8jtgu5nnewne63th1d7uuuikrk7rc/', 'html5', 450, 750, 1576076683, '1', '0'),
(1197, 'gamemonetize-251', 'metro-bus-simulator', 'Metro Bus Simulator', 'https://img.gamemonetize.com/50tjocfe6yd865gpu0gqfgssxm56gfql/512x384.jpg', '0', 1, 0, '0', 'Now you will drive city metro bus game on special roads in the city and mountains. City metro bus is a double cabin long 8x8 wheeler metro bus that is driven on special decorated roads in city and mountains. Pick passengers, drive this city metro coach bus through the hilly area and drop passengers on their desired destinations. Slow down the speed of metro bus while driving in huge traffic in the city to avoid crashes.', '', 'https://html5.gamemonetize.com/50tjocfe6yd865gpu0gqfgssxm56gfql/', 'html5', 900, 600, 1576076683, '1', '0'),
(1198, 'gamemonetize-250', 'offroad-cycle-3d-racing-simulator', 'Offroad Cycle 3D Racing Simulator', 'https://img.gamemonetize.com/su4m68j4kkt3jsap0867audlbk8hkrpc/512x384.jpg', '0', 2, 0, '0', 'Offroad Cycle 3D Racing Simulator IS a realistic simulator of Bicycle racing, where each player will be able to experience the full drive and extreme! The graphics are unmatched, and a variety of game locations does everything necessary for a rapid immersion in the atmosphere of exciting racing races. Start right now to see how well you will cope with off-road racing!', '', 'https://html5.gamemonetize.com/su4m68j4kkt3jsap0867audlbk8hkrpc/', 'html5', 960, 600, 1576076683, '1', '0'),
(1199, 'gamemonetize-249', 'toy-cars', 'Toy Cars', 'https://img.gamemonetize.com/y29cfydrsvbu33jkp3l3a75avvozocjn/512x384.jpg', '0', 2, 0, '0', 'In the game &quot;Toy Car&quot;, developed in 3D graphics, you can ride on a variety of car models. Select your preferred mode of travel from the available options. There is an opportunity to play in the free race, where quietly explore the big city, admire the local attractions, periodically picking up coins. There is also a mode in which competitions with other cars race, to determine who is worthy of the title of winner, press the pedal, come to the finish line before anyone else.', '', 'https://html5.gamemonetize.com/y29cfydrsvbu33jkp3l3a75avvozocjn/', 'html5', 960, 600, 1576076683, '1', '0'),
(1200, 'gamemonetize-248', 'monster-truck-speed-race', 'Monster Truck Speed Race', 'https://img.gamemonetize.com/ftjtbtpz9cbxiaexb1291w988r12mxz1/512x384.jpg', '0', 2, 0, '0', 'Do you like 3D Monster Trucks Racing game with monster effects and realistic 3D tracks? Enjoy extreme &amp; Exciting real monster truck rally racing. Truck driving simulator at its best and extremely dangerous Up Hill, full of dirt deserts race tracks involving hills and desert which only 4×4 trucks can conquer.', '', 'https://html5.gamemonetize.com/ftjtbtpz9cbxiaexb1291w988r12mxz1/', 'html5', 960, 600, 1576076683, '1', '0'),
(1201, 'gamemonetize-247', 'zombie-x-city-apocalypse', 'Zombie X City Apocalypse', 'https://img.gamemonetize.com/8h2s8wnpsqdql10uu0sa8i04me24apri/512x384.jpg', '0', 1, 0, '0', 'Zombie X City Apocalypse continues the classic story shooter in the style of zombie shooters. In your city, a secret experiment was conducted, as a result of which the city was flooded with zombies, the only thing left to do is to pave the way to victory through a zombie apocalypse!', '', 'https://html5.gamemonetize.com/8h2s8wnpsqdql10uu0sa8i04me24apri/', 'html5', 900, 600, 1576076683, '1', '0'),
(1202, 'gamemonetize-246', 'real-car-parking-drive', 'Real Car Parking Drive', 'https://img.gamemonetize.com/udgvhdr46m8bixkdda203tp1h9j7wpur/512x384.jpg', '0', 2, 0, '0', 'It is the best car-racing journey in latest style of best parking simulator games, which is available with outstanding but interesting car parking games. You can be slave of many bike-parking games but this classic innovative car parking makes you a proficient car-parking driver in the world of parking and driving games.', '', 'https://html5.gamemonetize.com/udgvhdr46m8bixkdda203tp1h9j7wpur/', 'html5', 960, 600, 1576076683, '1', '0'),
(1203, 'gamemonetize-245', 'drift-car-simulator', 'Drift Car Simulator', 'https://img.gamemonetize.com/5imbevykx6wglqqg18fdoy8dqolboblu/512x384.jpg', '0', 2, 0, '0', 'Ground breaking drift game seen for first time in browsers. Not every driver can drift successfully, we have some burn outs and stunts to perform. Grab the wheel and leave some crazy trails on the road in this crazy epic game. Unlock trails, many new cars to be bought. Can not reveal more details, check us out, and the leader of the pack. Have fun, track is all yours!', '', 'https://html5.gamemonetize.com/5imbevykx6wglqqg18fdoy8dqolboblu/', 'html5', 960, 600, 1576076683, '1', '0'),
(1204, 'gamemonetize-244', 'funny-animals-coloring-book', 'Funny Animals Coloring Book', 'https://img.gamemonetize.com/dpx0x5xbhyqo4ctl483yodvmvvb8u437/512x384.jpg', '0', 1, 0, '0', 'Who loves drawing and painting ? In this beautiful coloring book, we are in a jungle and there are 5 animals to paint. Do you know the colors of the different animals? Use the movable panel on the right to select the desired color. Drag the palette panel with the left mouse button. Enjoy this new coloring book..', '', 'https://html5.gamemonetize.com/dpx0x5xbhyqo4ctl483yodvmvvb8u437/', 'html5', 800, 600, 1576076683, '1', '0'),
(1205, 'gamemonetize-243', 'candy-monster', 'Candy Monster', 'https://img.gamemonetize.com/7cyictge6sz306k7j6sgindv6qteffin/512x384.jpg', '0', 1, 0, '0', 'Candy Monster is an online game that you can play for free. Candy Monster Eater is an interesting relaxation match game. Swap adjacent candy tiles make the line of at least three gems of the same candy and remove them from the field Unlock all levels and have fun', '', 'https://html5.gamemonetize.com/7cyictge6sz306k7j6sgindv6qteffin/', 'html5', 480, 854, 1576076683, '1', '0'),
(1206, 'gamemonetize-242', 'scatty-maps-europe', 'Scatty Maps: Europe', 'https://img.gamemonetize.com/ssz6aalb4hw8wy7u66r4b3zocgtyuhrm/512x384.jpg', '0', 5, 0, '0', 'Maps of European countries are scattered around. Place them where they should be.', '', 'https://html5.gamemonetize.com/ssz6aalb4hw8wy7u66r4b3zocgtyuhrm/', 'html5', 1024, 1000, 1576076683, '1', '0'),
(1207, 'gamemonetize-241', 'footyzag', 'FootyZag', 'https://img.gamemonetize.com/v0re5iv7fc887jwvc5lb22ni5pv05hb0/512x384.jpg', '0', 1, 0, '0', 'Pass the ball to your teammate and score! Complete challenging levels and unlock crazier and stronger teams. Make sure not to pass the ball to the opponent team!', '', 'https://html5.gamemonetize.com/v0re5iv7fc887jwvc5lb22ni5pv05hb0/', 'html5', 450, 800, 1576076683, '1', '0'),
(1208, 'gamemonetize-240', 'pintown', 'Pintown', 'https://img.gamemonetize.com/f7ofk2nhhh6krr6a8djz0kcrtvvy4qgj/512x384.jpg', '0', 5, 0, '0', 'Pin Town is a physics puzzle game. There&#039;s a lot to do in Pin Town: Find a house, visit the beach, go to the movies and a lot more!', '', 'https://html5.gamemonetize.com/f7ofk2nhhh6krr6a8djz0kcrtvvy4qgj/', 'html5', 800, 600, 1576076683, '1', '0'),
(1209, 'gamemonetize-239', 'toby-s-adventures', 'Toby&#039;s Adventures', 'https://img.gamemonetize.com/h62dgrmcey2vgsmiques05h6a0x6b7ks/512x384.jpg', '0', 5, 0, '0', 'Toby&#039;s Adventures is a puzzle-platformer. Collect all food and reach the door to finish the level. Break bricks, avoid obstacles and enemies on your way.', '', 'https://html5.gamemonetize.com/h62dgrmcey2vgsmiques05h6a0x6b7ks/', 'html5', 750, 500, 1576076683, '1', '0'),
(1210, 'gamemonetize-238', 'gun-fu-stickman', 'Gun Fu Stickman', 'https://img.gamemonetize.com/j5izu1gqhu56oiqr8k853byr5jellyn4/512x384.jpg', '0', 5, 0, '0', 'Gun Fu: Stickman 2 online offical game. Armed with a pistol in each hand, take control of the famous Stickman from the &quot;Gun Fu&quot; series and blast through hordes of enemies! Play online Gun Fu Stickman 2 - Fun Shooting Games', '', 'https://html5.gamemonetize.com/j5izu1gqhu56oiqr8k853byr5jellyn4/', 'html5', 800, 600, 1576076683, '1', '1'),
(1211, 'gamemonetize-237', 'stack-jump', 'Stack Jump', 'https://img.gamemonetize.com/ca56n5vqjh3ohjbsonjzop0r9mo59y9m/512x384.jpg', '0', 4, 0, '0', 'Stack Jump online in HTML5! How high can you climb? Jump to stack blocks and build the biggest tower imaginable!', '', 'https://html5.gamemonetize.com/ca56n5vqjh3ohjbsonjzop0r9mo59y9m/', 'html5', 800, 600, 1576076683, '1', '1'),
(1212, 'gamemonetize-236', 'jewel-legend', 'Jewel Legend', 'https://img.gamemonetize.com/m72qlxevb7p361rfry6nhy7neet2emo0/512x384.jpg', '0', 5, 0, '0', 'Let the great Jewel Legend begin! The travelers from all around the world have come to the mines to dig those diamonds out. Join them in the effort to find as much diamonds as possible while engaging in various challenges that will keep you entertained for long stretches of time! So, what are you waiting for?', '', 'https://html5.gamemonetize.com/m72qlxevb7p361rfry6nhy7neet2emo0/', 'html5', 600, 800, 1576076683, '1', '0'),
(1213, 'gamemonetize-235', 'mafia-driver-vice-city-crime', 'Mafia Driver Vice City Crime', 'https://img.gamemonetize.com/deh61tjjzbo5j7r3po5d84l4p2htvw88/512x384.jpg', '0', 2, 0, '0', 'Step in the shoes of a real gangster and take over the big italian city in this amazing mafia game. You just came back out of jail and it’s time to retake your position in Mafia Driver Vice Crime City! Start from the bottom and work your way up mobster and it won’t be easy in our mafia driving simulator.', '', 'https://html5.gamemonetize.com/deh61tjjzbo5j7r3po5d84l4p2htvw88/', 'html5', 960, 640, 1576076683, '1', '0')";
$db[29] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1214, 'gamemonetize-234', 'city-coach-bus-simulator-2018', 'City Coach Bus Simulator 2018', 'https://img.gamemonetize.com/sbtpkzkyaj3i1tvrwfzbbz41g61jfn07/512x384.jpg', '0', 2, 0, '0', 'City Coach Bus Simulator 2018 is interesting, exciting and addictive tourist transportation bus driving game that will offer you the chance to become a real bus driver! City and highway bus simulator provides realistic maps, incredible vehicles and high-quality graphics of real bus simulator that will make you feel like driving a real bus!', '', 'https://html5.gamemonetize.com/sbtpkzkyaj3i1tvrwfzbbz41g61jfn07/', 'html5', 960, 600, 1576076683, '1', '0'),
(1215, 'gamemonetize-233', 'lada-russian-car-drift', 'Lada Russian Car Drift', 'https://img.gamemonetize.com/w0s45ejvd0dblv2yif8vp548b4nifzuc/512x384.jpg', '0', 2, 0, '0', 'Have you ever wanted to build your own Lada, VAZ? Now here is your chance to customize your 2105 and take it out on the track for some drifting!', '', 'https://html5.gamemonetize.com/w0s45ejvd0dblv2yif8vp548b4nifzuc/', 'html5', 960, 640, 1576076683, '1', '0'),
(1216, 'gamemonetize-232', 'car-mechanic-simulator', 'Car Mechanic Simulator', 'https://img.gamemonetize.com/ebhya4h6tp27evqu6utwq0r6334p8vcn/512x384.jpg', '0', 1, 0, '0', 'Play this Car Mechanic Simulator in a realistic workshop of car fixing games environment where you will experience car service modify model kit with oil change, painting and so on.', '', 'https://html5.gamemonetize.com/ebhya4h6tp27evqu6utwq0r6334p8vcn/', 'html5', 900, 600, 1576076683, '1', '0'),
(1217, 'gamemonetize-231', 'fire-storm', 'Fire Storm', 'https://img.gamemonetize.com/hayrh9w3n9hrdjqjbebccaumo7e6jfs0/512x384.jpg', '0', 3, 0, '0', 'The fight has begun. Only a few elite fighters went to the streets. Are you one of them? Almost no one gets out of the gouse. Gangs dominated the city and the only way to save humanity is to get rid of them. The game has several levels, and in each you will have to accomplish your goal without dying. Shoot 100 enemies, destroy their cars.', '', 'https://html5.gamemonetize.com/hayrh9w3n9hrdjqjbebccaumo7e6jfs0/', 'html5', 960, 600, 1576076683, '1', '0'),
(1218, 'gamemonetize-230', 'honeydrop', 'HoneyDrop', 'https://img.gamemonetize.com/y13zpununnmw36g7bqjixqrpmxnvffed/512x384.jpg', '0', 3, 0, '0', 'Bees are very hardworking insects and produce lots of honey, but their aiming skill is not very well and so they can also waste lots of honey! So you have to help these bees to drop the honey that they have gathered with much efforts in to the pot!', '', 'https://html5.gamemonetize.com/y13zpununnmw36g7bqjixqrpmxnvffed/', 'html5', 400, 640, 1576076683, '1', '0'),
(1219, 'gamemonetize-229', 'wild-hunter-sniper-buck', 'Wild Hunter Sniper Buck', 'https://img.gamemonetize.com/zydvgg0x9opy2p3rbrjd2ag4xfxq5cp4/512x384.jpg', '0', 3, 0, '0', 'A jungle like African jungle is here in this game in which deers and other wild animals are wondering, you have to find them and hunt them. Different powerful guns and pistols are available for you which have different shooting ranges, you have to select any gun according to your own choice and perform deer hunting. Use Mouse to shoot, R - reload, E - turn night vision.', '', 'https://html5.gamemonetize.com/zydvgg0x9opy2p3rbrjd2ag4xfxq5cp4/', 'html5', 900, 600, 1576076683, '1', '0'),
(1220, 'gamemonetize-228', 'demolition-derby-challenge', 'Demolition Derby Challenge', 'https://img.gamemonetize.com/h3eunhht4qs85222ayb1484gi9sfxkee/512x384.jpg', '0', 2, 0, '0', 'Demolition Derby Challenge is xtreme game for those who likes to demolition or destruction challenge with their car. The game task is so simple that you have to speed way your car from other cars and then the dare devil is that you have hit and hit hard other cars so those cars can fall from track or into the whirlpool. Don’t let other cars damage you show them your maneuver as its death race.', '', 'https://html5.gamemonetize.com/h3eunhht4qs85222ayb1484gi9sfxkee/', 'html5', 900, 600, 1576076683, '1', '1'),
(1221, 'gamemonetize-227', 'horse-jumping-show-3d', 'Horse Jumping Show 3D', 'https://img.gamemonetize.com/a51iohzju6rwi29hmk9qeg592gm158bg/512x384.jpg', '0', 1, 0, '0', 'Nothing is batter then riding a horse. Horse Horse Jumping Show 3D is a horse running games which require you to ride horse on the given track and cross obstacles by jumping. This game is designed to introduce you the beauty of horse riding and to fulfill your riding passion. So just play our new riding game and get yourself ready for amazing and challenging game horse ride Horse Jumping Show 3D.', '', 'https://html5.gamemonetize.com/a51iohzju6rwi29hmk9qeg592gm158bg/', 'html5', 960, 600, 1576076683, '1', '0'),
(1222, 'gamemonetize-226', 'real-gangster-city-crime-vegas-3d-2018', 'Real Gangster City Crime Vegas 3D 2018', 'https://img.gamemonetize.com/qy6y3b82lhc4gn6u2kpvywh157qb6t3w/512x384.jpg', '0', 1, 0, '0', 'Welcome to Real Gangster City Crime Vegas 3D 2018, Explore the city of vegas of gangster crime, Become the most notable gangsters in vegas city crime of US Streets by using guns, cars, bikes, planes, trucks, buses. As a real gangster in this finest of vegas crime games play as a crime lord to deal with vegas gangsters to be one of the best crime gangster. Instructions: WASD - move. LKM - atack. Shift - run. Space - jump. F - use car', '', 'https://html5.gamemonetize.com/qy6y3b82lhc4gn6u2kpvywh157qb6t3w/', 'html5', 960, 600, 1576076683, '1', '0'),
(1223, 'gamemonetize-225', 'forest-survival-simulator', 'Forest Survival Simulator', 'https://img.gamemonetize.com/90ylic74x9geuu30qsi1jz0ddtf8xr87/512x384.jpg', '0', 1, 0, '0', 'Forest Survival Simulator game is dedicated to survival on an inhabited forest: a game character who has fallen in the forest as a result of a plane crash must find food and shelter, as well as defend himself from frightening native cannibals.', '', 'https://html5.gamemonetize.com/90ylic74x9geuu30qsi1jz0ddtf8xr87/', 'html5', 900, 600, 1576076683, '1', '0'),
(1224, 'gamemonetize-224', 'heavy-duty-tractor-pull', 'Heavy Duty Tractor Pull', 'https://img.gamemonetize.com/5jzsic6niph96zimoc5qceuwtgeuat9g/512x384.jpg', '0', 1, 0, '0', 'I am sure you will enjoy real stunt tractor pulling and chained tractor transportations simulation game. In this tractor of crew &amp; tractor pulling simulator game, you enjoy a lot tractor drive and thrilling fun of riding.', '', 'https://html5.gamemonetize.com/5jzsic6niph96zimoc5qceuwtgeuat9g/', 'html5', 900, 600, 1576076683, '1', '0'),
(1225, 'gamemonetize-223', 'currency-symbols', 'Currency Symbols', 'https://img.gamemonetize.com/bkgym3ex7zgbouvz47tuqng9vy6wodi0/512x384.jpg', '0', 5, 0, '0', 'Currency Symbols is a fun memory game. Match all identical cards before time runs out. You have 4 levels in total, the first being the easiest and the last most difficult. Gather the most points by getting the identical cards as fast as you can. Enjoy!', '', 'https://html5.gamemonetize.com/bkgym3ex7zgbouvz47tuqng9vy6wodi0/', 'html5', 960, 540, 1576076683, '1', '0'),
(1226, 'gamemonetize-222', 'the-chilling-adventures-of-sabrina', 'The Chilling Adventures of Sabrina', 'https://img.gamemonetize.com/8yo9yi4lv2hczmbgxsb4iejtz7kklygu/512x384.jpg', '0', 1, 0, '0', 'Sabrina is getting older, and in her life there are typical teenage problems. Choose a teen or a real witch for Sabrina. Also in this game you will be able to dress strange sisters - Prudence, Agatha and Dorcas. Choose an outfit for the sisters to practice at the Academy of the Unseen Arts, for the witchcraft rite and for the pj party.', '', 'https://html5.gamemonetize.com/8yo9yi4lv2hczmbgxsb4iejtz7kklygu/', 'html5', 800, 600, 1576076683, '1', '0'),
(1227, 'gamemonetize-221', 'princess-neko-girl', 'Princess Neko Girl', 'https://img.gamemonetize.com/ij5hfv977ki8gzqncukr0zuvncxvgx5z/512x384.jpg', '0', 1, 0, '0', 'Tiana and Elsa try on a new image. Turn princesses into kawaii cat girls. Use funny ears, paws and tails, as well as eyes and lips in the anime style, to create an image. Try on cute t-shirts, shirts, skirts, shorts and leggings. Do not forget about unusual hairstyles for princesses. Enjoy the game!', '', 'https://html5.gamemonetize.com/ij5hfv977ki8gzqncukr0zuvncxvgx5z/', 'html5', 800, 600, 1576076683, '1', '0'),
(1228, 'gamemonetize-220', 'aliens-bubble-shooter', 'Aliens Bubble Shooter', 'https://img.gamemonetize.com/2luzmu0nb6u7xd4r838jou42h7c7udhx/512x384.jpg', '0', 5, 0, '0', 'Another Bubble game where you need to destroy 3 or more balls with same ball. Sometimes for extra points there is Aliens Balls. Click on mouse to shoot and aim. Play this game and enjoy!', '', 'https://html5.gamemonetize.com/2luzmu0nb6u7xd4r838jou42h7c7udhx/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1229, 'gamemonetize-219', 'storm-city', 'Storm City', 'https://img.gamemonetize.com/yj62rzp2zy844zzm3nbj2ppwapn9sjlq/512x384.jpg', '0', 3, 0, '0', 'Storm City is a cyberpunk themed shooting game. Shoot your enemies and collect the boosters in order to level up. And remember: Shoot first, ask questions never!', '', 'https://html5.gamemonetize.com/yj62rzp2zy844zzm3nbj2ppwapn9sjlq/', 'html5', 960, 600, 1576076683, '1', '0'),
(1230, 'gamemonetize-218', 'real-gangster-city-crime-vegas-3d', 'Real Gangster City Crime Vegas 3D', 'https://img.gamemonetize.com/rwy72xpdxz7gp0bhv32cq9rwihfw0o4r/512x384.jpg', '0', 1, 0, '0', 'Welcome to Real Gangster City Crime Vegas 3D 2018, Explore the city of vegas of gangster crime, Become the most notable gangsters in vegas city crime of US Streets by using guns, cars, bikes, planes, trucks, buses. As a real gangster in this finest of vegas crime games play as a crime lord to deal with vegas gangsters to be one of the best crime gangster. This Vegas neighbor fighting 3D game is best game in mafia games to steal, drive and fight with different scary and muscular tough neighbors.', '', 'https://html5.gamemonetize.com/rwy72xpdxz7gp0bhv32cq9rwihfw0o4r/', 'html5', 900, 600, 1576076683, '1', '0'),
(1231, 'gamemonetize-217', 'mexican-master-chef', 'Mexican Master Chef', 'https://img.gamemonetize.com/zyseax67xpvpmls59ixcfq8dugnlm9bl/512x384.jpg', '0', 1, 0, '0', 'Are you street food lover? If yes, then join us our new game Mexican Master Chef, a virtual cooking fun game. There are french fries stall, hotdog stall, pizza stall, burger stall, noodles stall and churros stall! This sounds so amazing that you can get all yummy food at only one place. Cooking fever will start in this carnival food festival. Get ready for this.', '', 'https://html5.gamemonetize.com/zyseax67xpvpmls59ixcfq8dugnlm9bl/', 'html5', 960, 600, 1576076683, '1', '0'),
(1232, 'gamemonetize-216', 'princess-russian-hooligans', 'Princess Russian Hooligans', 'https://img.gamemonetize.com/wzfq99fwa0z61nc75606gji0w8u5mkfi/512x384.jpg', '0', 1, 0, '0', 'Princesses Rapunzel, Belle and Elsa are sent to Russia. Meet these daring Russian hooligans. Pick up the girls dresses for their hard travel. Use unusual accessories - a hat with ear flaps, a balalaika, a nesting doll and a replica AK-47.', '', 'https://html5.gamemonetize.com/wzfq99fwa0z61nc75606gji0w8u5mkfi/', 'html5', 800, 600, 1576076683, '1', '0'),
(1233, 'gamemonetize-215', 'public-tricycle-rickshaw-driver', 'Public Tricycle Rickshaw Driver', 'https://img.gamemonetize.com/g0fsj1bwnjce9gjrzv24tr5iym8x74vo/512x384.jpg', '0', 1, 0, '0', 'Welcome to the Public Tricycle Rickshaw Driver long drive highway, realistic cycle rickshaw drive experience is waiting. You have played many rickshaw simulator games before but this cycle rickshaw is awesome and has many challenging levels. Enjoy your game', '', 'https://html5.gamemonetize.com/g0fsj1bwnjce9gjrzv24tr5iym8x74vo/', 'html5', 960, 600, 1576076683, '1', '0'),
(1234, 'gamemonetize-214', 'real-impossible-track-2', 'Real Impossible Track 2', 'https://img.gamemonetize.com/bwokuo3pjq4bjemkp4plebupihlvsqr3/512x384.jpg', '0', 1, 0, '0', 'Welcome to the world of Real Impossible Track 2 car racing. Enjoy the real impossible track race on the extreme impossible tracks in the sky highs. If you are a fast speed racer and have a passion for car racing games then be ready to experience the real car rally in the mid of sky with no limits. Press R to restart from checkpoint. Use WASD or Arrows to drive.', '', 'https://html5.gamemonetize.com/bwokuo3pjq4bjemkp4plebupihlvsqr3/', 'html5', 900, 600, 1576076683, '1', '1'),
(1235, 'gamemonetize-213', 'multiplayer-battle-royale', 'Multiplayer Battle Royale', 'https://img.gamemonetize.com/nc9jvoov7pq14864dwajcg4mykcap8wc/512x384.jpg', '0', 7, 0, '0', 'Multiplayer Battle Royale is an online 3D battle royale themed game with a last man standing game concept. You can choose from different characters and enter an online battle.', '', 'https://html5.gamemonetize.com/nc9jvoov7pq14864dwajcg4mykcap8wc/', 'html5', 960, 600, 1576076683, '1', '0'),
(1236, 'gamemonetize-212', 'hunter', 'Hunter', 'https://img.gamemonetize.com/k8dnn9ekjx6ejc8hsjqewp1pummcz5pj/512x384.jpg', '0', 3, 0, '0', 'Hunter is a 3D game where you can get prepared for hunting, a great simulator where your shooting skills will be improved. Take your sniper and practice over the moving mechanical targets and get the best score to be prepared for the real hunt.', '', 'https://html5.gamemonetize.com/k8dnn9ekjx6ejc8hsjqewp1pummcz5pj/', 'html5', 960, 600, 1576076683, '1', '0'),
(1237, 'gamemonetize-211', 'princess-cupcake', 'Princess Cupcake', 'https://img.gamemonetize.com/rxz14qgewlpk9izaujceh6afy0kukjeb/512x384.jpg', '0', 1, 0, '0', 'Ariel, Tiana and Elsa are very fond of baking cakes. They bake cakes to all their friends. Join the princesses - choose outfits and muffins. In the wardrobe you will find a lot of bright dresses, skirts, shorts, blouses. Try it all!', '', 'https://html5.gamemonetize.com/rxz14qgewlpk9izaujceh6afy0kukjeb/', 'html5', 800, 600, 1576076683, '1', '0'),
(1238, 'gamemonetize-210', 'taxi-simulator-2019', 'Taxi Simulator 2019', 'https://img.gamemonetize.com/7fbwjssoyc0i6zlbxnvol2aowosum5lu/512x384.jpg', '0', 2, 0, '0', 'Start your day behind the wheel of a yellow taxicab! This is no ordinary driving game; compete with other drivers for customers! Use your skills to navigate tight, urban streets and crowded roads to reach destinations under the time limit. Compete for parking spots and avoid crashing into other vehicles while sharing the road with trucks, jeeps, and motorbikes!', '', 'https://html5.gamemonetize.com/7fbwjssoyc0i6zlbxnvol2aowosum5lu/', 'html5', 960, 600, 1576076683, '1', '0'),
(1239, 'gamemonetize-209', 'mini-cars', 'Mini Cars', 'https://img.gamemonetize.com/19ahs8z2t5djcms1vs3ljsp1c62tcw7e/512x384.jpg', '0', 2, 0, '0', 'Select your favorite vehicle (the shop includes a tank and a helicopter) and start riding. You have the option to choose from three different game modes: free ride (collect coins, explore the city) , highway (collect coins,dodge the traffic) and arena (defeat your enemies), and day and night option.', '', 'https://html5.gamemonetize.com/19ahs8z2t5djcms1vs3ljsp1c62tcw7e/', 'html5', 960, 600, 1576076683, '1', '0'),
(1240, 'gamemonetize-208', 'city-cargo-trailer-transport', 'City Cargo Trailer Transport', 'https://img.gamemonetize.com/1d64z2qrs2cyz9z31vq5115zymno8hh9/512x384.jpg', '0', 2, 0, '0', 'Get behind the wheels of a big trailer to deliver cargo to dangerous mountains and steep hills. Drive epic truck trailers on challenging and bumpy maneuvers to complete the transport job on time. This off road truck trailer is a truck simulator game for those who love tough challenges on unsolved roads.', '', 'https://html5.gamemonetize.com/1d64z2qrs2cyz9z31vq5115zymno8hh9/', 'html5', 960, 600, 1576076683, '1', '0'),
(1241, 'gamemonetize-207', 'marvelous-hot-wheels', 'Marvelous Hot Wheels', 'https://img.gamemonetize.com/6nno1orvmftp5yvnilao0l8d6pbnp0tw/512x384.jpg', '0', 2, 0, '0', 'Stunts take you to a realistic journey of stunt driving and hot wheels race . Modern highway train car stunt is one of the best and much popular train vs car stunt riding 3d game. Enjoy the real train vs car jumping simulation game to become the crazy stunt driver and Hot Wheels stunt rider on city traffic roads.', '', 'https://html5.gamemonetize.com/6nno1orvmftp5yvnilao0l8d6pbnp0tw/', 'html5', 960, 600, 1576076683, '1', '0'),
(1242, 'gamemonetize-206', 'bus-parking-simulator', 'Bus Parking Simulator', 'https://img.gamemonetize.com/35nij09kjcgcbfdi68mvxplks5vm8whb/512x384.jpg', '0', 1, 0, '0', 'In Bus Parking Simulator you will play and enjoy the bus parking game with the bus simulator gameplay. If you like to play bus parking games then try this urban bus parking game and become the pro driver.', '', 'https://html5.gamemonetize.com/35nij09kjcgcbfdi68mvxplks5vm8whb/', 'html5', 900, 600, 1576076683, '1', '0'),
(1243, 'gamemonetize-205', 'talking-tom-math-test', 'Talking Tom Math Test', 'https://img.gamemonetize.com/n3sukh6jvui5metcm8s3x8lrhwjo3a4q/512x384.jpg', '0', 4, 0, '0', 'Talking Tom Math Test Challenge is an online game that you can play for free. This is a challenging math game that you can play with Tom. If you think that you are good at math than try this game and make a high score. This time we only use the plus and minus so what are you waiting for? Come and challenge! Have fun!', '', 'https://html5.gamemonetize.com/n3sukh6jvui5metcm8s3x8lrhwjo3a4q/', 'html5', 854, 480, 1576076683, '1', '0'),
(1244, 'gamemonetize-204', 'tattoo-salon', 'Tattoo Salon', 'https://img.gamemonetize.com/73kq6l561d0r3k4xigntjmj9z90ga0wh/512x384.jpg', '0', 1, 0, '0', 'In Tattoo Salon game you need to become the best tattoo artists in the area. Become the Ink Master that everybody is talking about! Try to mix and match the traditional tattoo with the temporary, and get all the beautiful creations which you can only imagine.', '', 'https://html5.gamemonetize.com/73kq6l561d0r3k4xigntjmj9z90ga0wh/', 'html5', 500, 750, 1576076683, '1', '0'),
(1245, 'gamemonetize-203', 'extreme-drift-cars', 'Extreme Drift Cars', 'https://img.gamemonetize.com/jxwfde1dd11yto6i5187szzjg2vjx82h/512x384.jpg', '0', 2, 0, '0', 'Extreme Drift Cars features: • Customizable car; • 5 amazing tracks for drifting; • Cool graphics; • 12 awesome sport cars;', '', 'https://html5.gamemonetize.com/jxwfde1dd11yto6i5187szzjg2vjx82h/', 'html5', 960, 600, 1576076683, '1', '0'),
(1246, 'gamemonetize-202', 'domestic-animals-memory', 'Domestic Animals Memory', 'https://img.gamemonetize.com/pv8rm5a6frsqipzstee16186knl3xpdm/512x384.jpg', '0', 5, 0, '0', 'Domestic Animals Memory is a free online game from genre of memory and animals games. Match all identical cards before time runs out. You have 4 levels in total, the first being the easiest and the last most difficult. Gather the most points by getting the identical cards as fast as you can. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/pv8rm5a6frsqipzstee16186knl3xpdm/', 'html5', 960, 540, 1576076683, '1', '0'),
(1247, 'gamemonetize-201', 'foot-doctor-2', 'Foot Doctor 2', 'https://img.gamemonetize.com/d4z3lskezgyf5w6d0x4oagep3htdtoz6/512x384.jpg', '0', 1, 0, '0', 'In Foot Doctor 2 game you will perform various treatments for healing all sorts of wounds and have tons of fun playing emergency room games. It&#039;s the best way to start practicing if you’re dreaming of becoming a surgeon and save lives when you grow up!', '', 'https://html5.gamemonetize.com/d4z3lskezgyf5w6d0x4oagep3htdtoz6/', 'html5', 500, 750, 1576076683, '1', '0'),
(1248, 'gamemonetize-200', 'car-mechanic-2017', 'Car Mechanic 2017', 'https://img.gamemonetize.com/f9jvh1mhjbmvn0urziozg6lbamgfrxe6/512x384.jpg', '0', 1, 0, '0', 'If you have not play any career oriented game then here is a great game for you. It’s not just career oriented game it got so many things to learn with some real fun. It a fun realistic game.in this game you have to be an auto mechanic.', '', 'https://html5.gamemonetize.com/f9jvh1mhjbmvn0urziozg6lbamgfrxe6/', 'html5', 960, 600, 1576076683, '1', '0'),
(1249, 'gamemonetize-199', 'zombie-survival-shooter', 'Zombie Survival Shooter', 'https://img.gamemonetize.com/74gpakqnrfrjg2v1ib2waa3k1tg724k9/512x384.jpg', '0', 3, 0, '0', 'Zombies and zombie dog attack in modern city kill all zombie and save your city !!! - More than 5 brand new Zombie missions to compete in and complete - 8 Weapons (PISTOL, 9mm SILENCER, M16A4, SHOT GUN, MACHINE GUN, A400 SHOT GUN, MP44, HAND GRENADE) - Armor And Grenade option - Unique City MAPS TO CHOOSE - REALISTIC SETTINGS FOR INTENSE BATTLES - EASY TO LEARN GAMEPLAY', '', 'https://html5.gamemonetize.com/74gpakqnrfrjg2v1ib2waa3k1tg724k9/', 'html5', 960, 600, 1576076683, '1', '0'),
(1250, 'gamemonetize-198', 'real-taxi-driver-3d', 'Real Taxi Driver 3D', 'https://img.gamemonetize.com/kee9alti3wn6i1fuz2i3dhzdtbpgau6u/512x384.jpg', '0', 2, 0, '0', 'Tie up your belts and get ready for the ride, where you will live to the end of a fabulous taxi simulatord excitement. REAL TAXI DRIVER MODELS • TASK MODE • FREE MODE • PARK MODE • MULTIPLAYER REAL TAXI DRIVER FEATURES • Fun Visual and Sound Effects • Night and Day Modes • Realistic Vehicle Physics • Navigation System • A systematic city and 3D graphics • Realistic Animation Passengers • Intelligent Traffic System • Exciting Sensitive Taxi Driving Experience • Level System • 2 Different Language Options • Improved Market System • 14+ Different Vehicle Models • and we are happy to see you in th', '', 'https://html5.gamemonetize.com/kee9alti3wn6i1fuz2i3dhzdtbpgau6u/', 'html5', 900, 600, 1576076683, '1', '0'),
(1251, 'gamemonetize-197', 'forest-survival', 'Forest Survival', 'https://img.gamemonetize.com/bvhqzp4k7v2k6qcu1ohvcuf0dcu0k9dv/512x384.jpg', '0', 3, 0, '0', 'Forest Survival is a shooter game with a pixelated theme where beside shooting and fighting you can craft different things, upgrade your inventory and take care about the needs of your character such as eating and drinking.', '', 'https://html5.gamemonetize.com/bvhqzp4k7v2k6qcu1ohvcuf0dcu0k9dv/', 'html5', 960, 600, 1576076683, '1', '0'),
(1252, 'gamemonetize-196', 'scatty-maps-asia', 'Scatty Maps: Asia', 'https://img.gamemonetize.com/m5bu0yq8o87ppjtu1miilg3lz3pkf1x1/512x384.jpg', '0', 5, 0, '0', 'Great educational game to learn about geography of Asia. Two modes of play, easy and full map, will amuse both younger and more advanced maps enthusiasts.', '', 'https://html5.gamemonetize.com/m5bu0yq8o87ppjtu1miilg3lz3pkf1x1/', 'html5', 1024, 1000, 1576076683, '1', '0'),
(1253, 'gamemonetize-195', 'masha-puzzle-time', 'Masha Puzzle Time', 'https://img.gamemonetize.com/z317hfk29ips1es2uam0uzya3g3dekwe/512x384.jpg', '0', 5, 0, '0', 'Masha And The Bear Puzzle is an online game that you can play on for free. Masha and the Bear Puzzle is fun puzzle game for kids. You can complete good jigsaw of Masha with her friends or connect points to form sharks and stars. Have a good time.', '', 'https://html5.gamemonetize.com/z317hfk29ips1es2uam0uzya3g3dekwe/', 'html5', 800, 500, 1576076683, '1', '0'),
(1254, 'gamemonetize-194', 'horror-granny-escape', 'Horror Granny Escape', 'https://img.gamemonetize.com/17cny9076f3ov9fjvqvnq35b5y507f38/512x384.jpg', '0', 5, 0, '0', 'First you need to figure out how to get out of the room. Somewhere there should be a key. Carefully look around, search the furniture and study the contents of the drawers. You’ll have to do this quite often, so start getting used to it right now. There are quite a number of such rooms in the house, and in each there is something necessary to escape. Only by collecting all the needed items you can turn off the alarm and unlock the front door.', '', 'https://html5.gamemonetize.com/17cny9076f3ov9fjvqvnq35b5y507f38/', 'html5', 960, 600, 1576076683, '1', '0'),
(1255, 'gamemonetize-193', 'under-water-racing-game', 'Under Water Racing Game', 'https://img.gamemonetize.com/2gkpn4rhz63rxcwdlxpopio7sj5qswdu/512x384.jpg', '0', 1, 0, '0', 'First time in the history of racing or simulation underwater games this underwater cycling adventure will provide you the concept of the gaming you can set the world records on water surfer or underwater survivals. Underwater 3d games give you the desired sensation of riding the amazing and modern BMX underwater bicycle like real life experience. This best racing game in the world of a bicycle is based on the BMX racing but the concept of this game is based underwater and fishes.', '', 'https://html5.gamemonetize.com/2gkpn4rhz63rxcwdlxpopio7sj5qswdu/', 'html5', 960, 600, 1576076683, '1', '0'),
(1256, 'gamemonetize-192', 'princess-earth-chan', 'Princess Earth-Chan', 'https://img.gamemonetize.com/zcusaou4yuu7w5rgf9ei5ac68dftb2ya/512x384.jpg', '0', 1, 0, '0', 'Our planet Earth has its soul. This is a sweet Earth-chan. Turn the princess into your favorite planet, and embody the image of the planet in the form of a cute anime girl. Choose one of the planets of our solar system - Mars, Venus, Earth, Jupiter, Moon and others. Also you can make the Sun-chan. Dress up the girls in costumes in the style of the Japanese school uniform. Play this fun game for girls, and take care of the planet!', '', 'https://html5.gamemonetize.com/zcusaou4yuu7w5rgf9ei5ac68dftb2ya/', 'html5', 800, 600, 1576076683, '1', '0'),
(1257, 'gamemonetize-191', 'real-impossible-tracks-race', 'Real Impossible Tracks Race', 'https://img.gamemonetize.com/y4rpuk9hjt8727jk0n39itlxnjow5wj3/512x384.jpg', '0', 2, 0, '0', 'The Real Impossible Track Race game is also helpful for improving driving skills. Take sharp turns on high driving asphalt tracks and obstacles with muscle stunt car with race car driving. This off-road car drifting 3D simulator game will improve your skills and help you in critical situations. Unlock your favorite sports cars in this cars racing game. Show your superb driving skills and complete all the missions of this amazing car game.', '', 'https://html5.gamemonetize.com/y4rpuk9hjt8727jk0n39itlxnjow5wj3/', 'html5', 960, 600, 1576076683, '1', '0'),
(1258, 'gamemonetize-190', 'impossible-moto-bike-track-stunts', 'Impossible Moto Bike Track Stunts', 'https://img.gamemonetize.com/vkbyz5bcx7fxo1n6ydcsr6vg40anglpb/512x384.jpg', '0', 2, 0, '0', 'In this Impossible Moto Bike Track Stunts, you must have a real motorbike stunt driving skills. We believe that you will enjoy ramp bike game a lot of addictive fun by playing this real moto bike stunt game that is most attractive impossible bike track stunt in the sky road environment.', '', 'https://html5.gamemonetize.com/vkbyz5bcx7fxo1n6ydcsr6vg40anglpb/', 'html5', 960, 600, 1576076683, '1', '0'),
(1259, 'gamemonetize-189', 'offroad-indian-truck-hill-drive', 'Offroad Indian Truck Hill Drive', 'https://img.gamemonetize.com/6az7mhx5d7r5g8uwriufsje0wdj4cqei/512x384.jpg', '0', 1, 0, '0', 'Offroad Indian Truck Hill Drive is a fun truck driving simulator to practice your skills as a truck driver. Welcome to India, where you will start your new job of taking goods from one spot to another. Choose a truck and maneuver it through narrow paths following the signs that will take you to your destination. Avoid dropping your cargo or you will automatically lose.', '', 'https://html5.gamemonetize.com/6az7mhx5d7r5g8uwriufsje0wdj4cqei/', 'html5', 960, 640, 1576076683, '1', '0'),
(1260, 'gamemonetize-188', 'hand-doctor', 'Hand Doctor', 'https://img.gamemonetize.com/evuvwpot0scgid1zdg1ko2mfjh84li3z/512x384.jpg', '0', 1, 0, '0', 'Today you’re doctors on a special mission to cure all hand injuries of your clumsy patients! Hand Doctor game offers all an incredible virtual surgery experience that’ll make you feel like real doctor working in a hospital.', '', 'https://html5.gamemonetize.com/evuvwpot0scgid1zdg1ko2mfjh84li3z/', 'html5', 500, 750, 1576076683, '1', '0'),
(1261, 'gamemonetize-187', 'bts-boat-coloring', 'BTS Boat Coloring', 'https://img.gamemonetize.com/swev3t41j0x7urn0nculftjgb170xkpq/512x384.jpg', '0', 1, 0, '0', 'BTS Boat Coloring Book is an online game that you can play for free. In this coloring book that belongs to you, you can create your own color world. In this game, choose any cartoon boat you want to paint to fill it, then use the brush to choose the color you like. I believe that you can make a colorful and perfect painting. Enjoy this game and have fun!', '', 'https://html5.gamemonetize.com/swev3t41j0x7urn0nculftjgb170xkpq/', 'html5', 854, 480, 1576076683, '1', '0'),
(1262, 'gamemonetize-186', 'car-traffic', 'Car Traffic', 'https://img.gamemonetize.com/5jq8m9p19wmg1vtx6tcj2x85zjlb7mpc/512x384.jpg', '0', 2, 0, '0', 'It’s time to show your driving skills on high speed among the multitude of cars on the highway. All you have to do is to avoid colliding with other cars and collecting as many points as possible.', '', 'https://html5.gamemonetize.com/5jq8m9p19wmg1vtx6tcj2x85zjlb7mpc/', 'html5', 960, 600, 1576076683, '1', '0'),
(1263, 'gamemonetize-185', 'best-emergency-ambulance-rescue-drive-sim', 'Best Emergency Ambulance Rescue Drive Sim', 'https://img.gamemonetize.com/5tcw863q3qxg79opkfd2gg0x8llb6e3c/512x384.jpg', '0', 2, 0, '0', 'You are a city ambulance driver, &amp; you have to prove yourself an amazing city ambulance driver by providing highly efficient city ambulance rescue service round the clock. So just start driving the best city Ambulance, accept this city Ambulance driving challenge &amp; make your mark in the gaming world.', '', 'https://html5.gamemonetize.com/5tcw863q3qxg79opkfd2gg0x8llb6e3c/', 'html5', 960, 600, 1576076683, '1', '0'),
(1264, 'gamemonetize-184', 'proton-coach-bus-simulator', 'ProTon Coach Bus Simulator', 'https://img.gamemonetize.com/2joekz8a5sa4a49jbv2yjgi4de17va4x/512x384.jpg', '0', 2, 0, '0', 'ProTon Coach Bus Simulator is driving game that will teach you to drive a real coach bus across different scenarios! Take people from a city to another, show them amazing places and landscapes. Open world map, incredible vehicles, wonderful interiors will make you feel a realistic Proton experience! and a wonderful Journey with this public bus.', '', 'https://html5.gamemonetize.com/2joekz8a5sa4a49jbv2yjgi4de17va4x/', 'html5', 960, 600, 1576076683, '1', '0'),
(1265, 'gamemonetize-183', 'farmer-tractor-cargo-simulation', 'Farmer Tractor Cargo Simulation', 'https://img.gamemonetize.com/c0rcvrjt8mhnoue95izz7vki9cesqtj2/512x384.jpg', '0', 1, 0, '0', 'Farmer Tractor Cargo Simulation is the mostpopular tractor cargo simulator game of 2017.Show us your heavytractor driving skills while riding an off-road cargo trucksimulator. Drive a heavy cargo transporter tractor full of goodsand crops on off-road muddy farms. Use your modern transporter offroad cargo truck to deliver the goods to the destinations and bethe world No.1 cargo transport heavy truck driver.', '', 'https://html5.gamemonetize.com/c0rcvrjt8mhnoue95izz7vki9cesqtj2/', 'html5', 960, 600, 1576076683, '1', '0'),
(1266, 'gamemonetize-182', 'punch-superhero', 'Punch Superhero', 'https://img.gamemonetize.com/3emawoikvonl1eabiiblp1n1frr9i5mm/512x384.jpg', '0', 1, 0, '0', 'Superhero war games are an amazing way to perform a secret agent duty. Many flying superhero adventures have been completed before the final battle. The superhuman battlefield is full of innocent people, so being an elastigirl and bravo shooter, be the savior of city people from the city gangster to complete mission D-Day.', '', 'https://html5.gamemonetize.com/3emawoikvonl1eabiiblp1n1frr9i5mm/', 'html5', 960, 600, 1576076683, '1', '0'),
(1267, 'gamemonetize-181', 'dead-target-zombie-shooter', 'Dead Target Zombie Shooter', 'https://img.gamemonetize.com/xsu4rrnxjk480134olpm0zbazidakibi/512x384.jpg', '0', 3, 0, '0', 'Dead Target Zombie Shooter is the best test of your temperament and nerves because when storms of zombies will thrive at you, you will need to stand still and study. Among number zombie shooting games, this game presents you horrible dead zombies with fierce environment effects.', '', 'https://html5.gamemonetize.com/xsu4rrnxjk480134olpm0zbazidakibi/', 'html5', 960, 600, 1576076683, '1', '0'),
(1268, 'gamemonetize-180', 'race-monster-truck', 'Race Monster Truck', 'https://img.gamemonetize.com/r2q7v0lejtd5k94pofrbqal3koim5vux/512x384.jpg', '0', 2, 0, '0', 'There are multiple off road monster trucks available to ride in this truck simulation game 3D. Use the cash rewards to unlock your favorite monster truck SIM and enjoy the crazy monster racing games mission. Water slide monster truck race game has three different and thrilling racing modes i.e. practice mode, career mode and survival mode.', '', 'https://html5.gamemonetize.com/r2q7v0lejtd5k94pofrbqal3koim5vux/', 'html5', 960, 600, 1576076683, '1', '0'),
(1269, 'gamemonetize-179', 'water-slide-car-race', 'Water Slide Car Race', 'https://img.gamemonetize.com/j4jnk8wkxpvjkmcadvi87cke5p8xa7hu/512x384.jpg', '0', 2, 0, '0', 'Are you fan of ship games like boat, yacht or sailboat?Get thrill of boat racing on water in your car and think of being in the next century.Drive your car like a boat in deep sea and experience the thrill. Be a ship captain and drive your car like a boat and enjoy thrilling jet boat racing and be the champion. Yes this is a super car!', '', 'https://html5.gamemonetize.com/j4jnk8wkxpvjkmcadvi87cke5p8xa7hu/', 'html5', 960, 600, 1576076683, '1', '0'),
(1270, 'gamemonetize-178', 'sports-car-dock-parking', 'Sports Car Dock Parking', 'https://img.gamemonetize.com/n72hyunh3vi0qwl73tgmcvmooc6cymum/512x384.jpg', '0', 1, 0, '0', 'Park your sports car without crashing barriers. Complete all levels. Modify your super car the way you want. All this you can do in awesome game - Sports Car Dock Parking. Use WASD / Arrows - Drive. C - change camera view.', '', 'https://html5.gamemonetize.com/n72hyunh3vi0qwl73tgmcvmooc6cymum/', 'html5', 900, 600, 1576076683, '1', '0'),
(1271, 'gamemonetize-177', 'zombify-me', 'Zombify Me', 'https://img.gamemonetize.com/yi6znbucf9v6hooyq3yzn5blp9qqxicw/512x384.jpg', '0', 1, 0, '0', 'One day, when you wake up and realize that all the things are changes ? the people around you, the city you live, the scenes? become other types! OMG, you see the ghost and zombies. How would your life be? Fight or run away? ( well, I suggest running away, run as fast and far as you could ?)', '', 'https://html5.gamemonetize.com/yi6znbucf9v6hooyq3yzn5blp9qqxicw/', 'html5', 800, 600, 1576076683, '1', '0'),
(1272, 'gamemonetize-176', 'super-car-stunts', 'Super Car Stunts', 'https://img.gamemonetize.com/idqd3hxa9vuofdofj68qm3bax9cjj9h2/512x384.jpg', '0', 2, 0, '0', 'Are you ready to enjoy extreme Super Car Stunts? Fasten your seat belt and accelerate the engine. Amazing 3D environment presents the most challenging stunts! The game is filled with awesome animations, real time car driving, car stunts and much more! Staying on tracks, pulling out jumps on time, complete challenge is what makes you a perfect driver of the stunts arena.', '', 'https://html5.gamemonetize.com/idqd3hxa9vuofdofj68qm3bax9cjj9h2/', 'html5', 960, 600, 1576076683, '1', '0'),
(1273, 'gamemonetize-175', 'eg-math-kid', 'EG Math Kid', 'https://img.gamemonetize.com/hmvptae7axhtdp5jf4wkk048s9vhp8e6/512x384.jpg', '0', 5, 0, '0', 'EG Math Kid is HTML5 games - very nice game for kids with mathematics! Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/hmvptae7axhtdp5jf4wkk048s9vhp8e6/', 'html5', 800, 600, 1576076683, '1', '0'),
(1274, 'gamemonetize-174', 'desert-robbery-car-chase', 'DESERT ROBBERY CAR CHASE', 'https://img.gamemonetize.com/6ybiehkwqbukmuu9p4ire5fkbhe6k3lr/512x384.jpg', '0', 5, 0, '0', 'Desert Robbery is a fun car game where we aim high score by carefully avoiding police cars in the desert with the car we robbed. There&#039;s a robber in the game. This robber is running from the cops in a car. We make sharp maneuvers while fleeing the cops so that the police cars collide with each other. You get points along with bumper police cars. At the same time without accidental long stay in the game we get points. We maintain our high score target with the scores we have achieved. Desert Robbery is an entertaining car game prepared for us who love adventure games. This game is with you', '', 'https://html5.gamemonetize.com/6ybiehkwqbukmuu9p4ire5fkbhe6k3lr/', 'html5', 900, 600, 1576076683, '1', '0'),
(1275, 'gamemonetize-173', 'monster-truck-stunt', 'Monster Truck Stunt', 'https://img.gamemonetize.com/f87wr4fqna59wxgcl8jbr6m9yz452alh/512x384.jpg', '0', 2, 0, '0', 'Monster truck stunts? No problem. Choose your truck, race, collect all the coins and prove your driving skills.', '', 'https://html5.gamemonetize.com/f87wr4fqna59wxgcl8jbr6m9yz452alh/', 'html5', 960, 600, 1576076683, '1', '0'),
(1276, 'gamemonetize-172', 'battle-simulator', 'Battle Simulator', 'https://img.gamemonetize.com/37uc3gxks7hess6gmex9gybbgrc2o51r/512x384.jpg', '0', 2, 0, '0', 'You need to set up an army in order to defeat the enemy troops. You can choose from three different types of soldiers which you need to place strategically on the map in order to win.', '', 'https://html5.gamemonetize.com/37uc3gxks7hess6gmex9gybbgrc2o51r/', 'html5', 960, 600, 1576076683, '1', '0'),
(1277, 'gamemonetize-171', 'bootle-target-shooting-3d', 'Bootle Target Shooting 3D', 'https://img.gamemonetize.com/f7aej66fdgnkezk3hlk1wmwqwu3h6lol/512x384.jpg', '0', 3, 0, '0', 'A real new bottle shotter trend in the epic era of bottle shot 3d games. Let’s start a fun to break the bottles with good shooting expertise. Multiple environments in this bottle shot expert simulator game. Broken the bottles with bullets in bottle shotter stones 3d choices!', '', 'https://html5.gamemonetize.com/f7aej66fdgnkezk3hlk1wmwqwu3h6lol/', 'html5', 960, 600, 1576076683, '1', '0'),
(1278, 'gamemonetize-170', 'pacman-adventure', 'Pacman Adventure', 'https://img.gamemonetize.com/mwhvxacvhiny3ceqzqzc5etmw00mxphj/512x384.jpg', '0', 3, 0, '0', 'Pacman Adventure is fun arcade game suitable for all ages. The aim of the game is to stay alive as long time as possible. Under that time eat as many dots as posssible and destroy your enemies. Have fun playing.', '', 'https://html5.gamemonetize.com/mwhvxacvhiny3ceqzqzc5etmw00mxphj/', 'html5', 640, 956, 1576076683, '1', '0'),
(1279, 'gamemonetize-169', 'underwater-cycling-adventure', 'Underwater Cycling Adventure', 'https://img.gamemonetize.com/fjt1hwvo3bi7avrpak95nwvijip1nef2/512x384.jpg', '0', 1, 0, '0', 'First time in the history of racing or simulation underwater games this underwater cycling adventure will provide you the concept of the gaming you can set the world records on water surfer or underwater survivals. This best racing game in the world of a bicycle is based on the BMX racing but the concept of this game is based underwater and fishes. WASD or Arrows to drive, Shift - nitro, C - change camera.', '', 'https://html5.gamemonetize.com/fjt1hwvo3bi7avrpak95nwvijip1nef2/', 'html5', 900, 600, 1576076683, '1', '0'),
(1280, 'gamemonetize-168', 'real-bottle-shooter-game', 'Real Bottle Shooter Game', 'https://img.gamemonetize.com/z86uw8u4ruorofl63ndqvpij17zmu34u/512x384.jpg', '0', 3, 1, '0', 'A new bottle shooter trend in the era of bottle shoot games let’s have a fun to break the bottles with your good shooting expertise. There are multiple environment in this bottle shoot expert simulator game you can broken the bottles with bullets and with bottle shooter stones 3d choices. Did you like shooting games like 3d bottle shooting crazy simulator and so on start your carrier?', '', 'https://html5.gamemonetize.com/z86uw8u4ruorofl63ndqvpij17zmu34u/', 'html5', 900, 600, 1576076683, '1', '0'),
(1281, 'gamemonetize-167', 'sweets-match-3', 'Sweets Match 3', 'https://img.gamemonetize.com/pi0kxzlwpdpp4djpjss4ztay9ua6fd55/512x384.jpg', '0', 5, 4, '0', 'Sweets Match 3 – this cool game three in a row, in which you have to put the blocks of the same color in a series of three pieces or more to achieve the highest possible score, be careful to account the scale to the left did not fall too low, otherwise the game will be over. The game is done to a beautiful summer style! Enjoy the game!', '', 'https://html5.gamemonetize.com/pi0kxzlwpdpp4djpjss4ztay9ua6fd55/', 'html5', 960, 540, 1576076683, '1', '0'),
(1282, 'gamemonetize-166', 'airplane-memory', 'Airplane Memory', 'https://img.gamemonetize.com/wi2wmi4be84yljwau74z3v053mwo57w1/512x384.jpg', '0', 5, 0, '0', 'Airplane Memory is a free online game from genre of memory and airplane games. Flip the tiles and try to match them up in pairs. Pair up all the tiles to win. Try to complete the game in as few moves as possible! There are is 4 levels. Use mouse to click or tap to screen on the squares. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/wi2wmi4be84yljwau74z3v053mwo57w1/', 'html5', 960, 540, 1576076683, '1', '0'),
(1283, 'gamemonetize-165', 'wild-animals-memory', 'Wild Animals Memory', 'https://img.gamemonetize.com/k8xz6rdg0j94g4ucub7jhxwtcvutksw4/512x384.jpg', '0', 5, 0, '0', 'Wild Animals Memory is a free online game from genre of memory and animals games. Match all identical cards before time runs out. You have 4 levels in total, the first being the easiest and the last most difficult. Gather the most points by getting the identical cards as fast as you can. Concentrate yourself and start to play. Enjoy!', '', 'https://html5.gamemonetize.com/k8xz6rdg0j94g4ucub7jhxwtcvutksw4/', 'html5', 960, 540, 1576076683, '1', '0'),
(1284, 'gamemonetize-164', 'agent-77', 'Agent 77', 'https://img.gamemonetize.com/0tzb5k62d7n1q63wj42fiozid0z1vo8v/512x384.jpg', '0', 5, 1, '0', 'Mission: Kill the targets on the minimap. No questions will be asked. Further missions details will be received from your immediate superior.', '', 'https://html5.gamemonetize.com/0tzb5k62d7n1q63wj42fiozid0z1vo8v/', 'html5', 960, 600, 1576076683, '1', '0'),
(1285, 'gamemonetize-163', 'red-boy-and-blue-girl', 'Red Boy and Blue Girl', 'https://img.gamemonetize.com/36pj4h7gwn49ehk53ry62o09lrpiwii0/512x384.jpg', '0', 5, 0, '0', 'Red Boy and Blue Girl is an adorable platformer puzzle where you guide this couple to escape various mazes. Swap between the worlds to solve unique puzzles. Overcome all obstacles with the power of teamwork!', '', 'https://html5.gamemonetize.com/36pj4h7gwn49ehk53ry62o09lrpiwii0/', 'html5', 800, 550, 1576076683, '1', '1'),
(1286, 'gamemonetize-162', 'real-garbage-truck', 'Real Garbage Truck', 'https://img.gamemonetize.com/e5btee689g0zlxp4gn03at5gfdzy1qqf/512x384.jpg', '0', 1, 0, '0', 'Real Garbage Truck highways while driving like pro truck driver in City Cleaner Simulator: Garbage Truck Driver 2 city. With Futuristic Garbage Truck auto Cleaner Service enjoy the most realistic truck simulation ever. Stop your garbage loader truck near the dust bins koradan at the marked places using your perfect complete technical driving parking skills.', '', 'https://html5.gamemonetize.com/e5btee689g0zlxp4gn03at5gfdzy1qqf/', 'html5', 960, 600, 1576076683, '1', '0'),
(1287, 'gamemonetize-161', 'impossible-truck-driving-simulator-3d', 'Impossible Truck Driving Simulator 3D', 'https://img.gamemonetize.com/b68upvyvvf15115rbj7lj5zcu9iedd2p/512x384.jpg', '0', 2, 0, '0', 'Hey truckers welcome to new Impossible Truck Tracks Simulator game where you can drive amazing trucks on massive heights to touch the skies like a legend. Driving big trucks on impossible tracks that are sky high is dangerous task for this you need real truck driving skills. If you love driving big truck or heavy vehicles then this truck simulator game is for you.', '', 'https://html5.gamemonetize.com/b68upvyvvf15115rbj7lj5zcu9iedd2p/', 'html5', 960, 600, 1576076683, '1', '0'),
(1288, 'gamemonetize-160', 'impossible-tracks-moto-bike-race', 'Impossible Tracks Moto Bike Race', 'https://img.gamemonetize.com/c40ndo8zu61vrkbkmoqnv03pd9d6if4u/512x384.jpg', '0', 2, 0, '0', 'Welcome to the definitive motorbike impossible track race experience! Impossible Moto Bike Track Race must have a game for all motor riders! Enjoy the real rusty containers track race on the endless extreme impossible tracks in the sky highs. Ultimate moto Stunt racing is one of the best GP stunt racing game in difficult stunt area without road rash', '', 'https://html5.gamemonetize.com/c40ndo8zu61vrkbkmoqnv03pd9d6if4u/', 'html5', 960, 600, 1576076683, '1', '0'),
(1289, 'gamemonetize-159', 'shooter-battlegrounds', 'Shooter Battlegrounds', 'https://img.gamemonetize.com/a0n78rr89tcrq9b97z0t7kfj2ufg49jf/512x384.jpg', '0', 3, 0, '0', 'Shooter Battlegrounds is a classic 3D shooting game where you have to choose from five different characters and two maps to play.', '', 'https://html5.gamemonetize.com/a0n78rr89tcrq9b97z0t7kfj2ufg49jf/', 'html5', 960, 600, 1576076683, '1', '0'),
(1290, 'gamemonetize-158', 'snow-plow-jeep-simulator', 'Snow Plow Jeep Simulator', 'https://img.gamemonetize.com/4vx3x522bia16lgp4i78woqkaojfgmol/512x384.jpg', '0', 1, 0, '0', 'When winter comes the yard is constantly snowing, which sleeps the whole area. Because of this, the roads come to a dangerous state and quite often various accidents occur on them. Today in the game Snow Plow Jeep Driving you will work with the municipal service of a small town located in a mountainous area. Your duties include cleaning the roads from snow.', '', 'https://html5.gamemonetize.com/4vx3x522bia16lgp4i78woqkaojfgmol/', 'html5', 960, 600, 1576076683, '1', '0'),
(1291, 'gamemonetize-157', 'talking-tom-in-laboratory', 'Talking Tom in Laboratory', 'https://img.gamemonetize.com/kbwrpbglbdu7ijc54q99itb3gra325im/512x384.jpg', '0', 1, 0, '0', 'Talking Tom In Laboratory is an online game that you can play for free. Do you like Tom Cat? Come to the Talking Tom In Laboratory to see what surprise Tom will bring to you this time! You will be able to explore the wonderful performance of Tom in different scenarios. This game is suitable for children and game characters to interact. Have fun playing with this game.', '', 'https://html5.gamemonetize.com/kbwrpbglbdu7ijc54q99itb3gra325im/', 'html5', 854, 480, 1576076683, '1', '0'),
(1292, 'gamemonetize-156', 'car-wash-amp-gas-station-simulator', 'Car Wash &amp; Gas Station Simulator', 'https://img.gamemonetize.com/a0cg5lopieybbawvm9kqkz3c3elibxom/512x384.jpg', '0', 1, 7, '0', 'This Car Wash &amp; Gas Station Simulator game offers you three different task: driving, fuel refilling, and wash &amp; parking on a specific location. It has a wonderful driving and parking experience for you. It has lot of challenge missions with amazing car driving. Car Wash Simulator has smooth and easy game play with beautiful environment. Use WASD or Arrows to drive, mouse to start engine and park car.', '', 'https://html5.gamemonetize.com/a0cg5lopieybbawvm9kqkz3c3elibxom/', 'html5', 960, 600, 1576076683, '1', '0'),
(1293, 'gamemonetize-155', 'classic-chicken-shooting', 'Classic Chicken Shooting', 'https://img.gamemonetize.com/0hol58mckhotx577jzyg3n7x3sxnblob/512x384.jpg', '0', 3, 0, '0', 'Shoot down all the chickens you can in the Chicken shooter game. You must kill the required number of chickens to clear each level.', '', 'https://html5.gamemonetize.com/0hol58mckhotx577jzyg3n7x3sxnblob/', 'html5', 960, 600, 1576076683, '1', '0'),
(1294, 'gamemonetize-154', 'frozen-princess-hidden-object', 'Frozen Princess Hidden Object', 'https://img.gamemonetize.com/clrbcki8xmb71t86lb83zuxa7svrx56a/512x384.jpg', '0', 1, 0, '0', 'Find all cute girly fashion accessories hidden in the castle where the ice princess lives: makeup items, bows and ribbons, bags and shoes, everything our princess needs in order to get dressed for the winter party is lost inside the magical castle! So, be a good friend and help her search and find hidden objects before it’s too late!', '', 'https://html5.gamemonetize.com/clrbcki8xmb71t86lb83zuxa7svrx56a/', 'html5', 960, 600, 1576076683, '1', '0'),
(1295, 'gamemonetize-153', 'eg-tank-wars', 'EG Tank Wars', 'https://img.gamemonetize.com/u03payiqacoi1ry1x4toqclfp0pbwa9q/512x384.jpg', '0', 3, 0, '0', 'EG Tank Wars are good old arcade tanks! In battle, gentlemen! Our opponents are well armed, so try to use both terrain, as camouflage and protection, and bonuses on the battlefield that will help improve weapons, turn enemies into wreckage or water into ice for ferrying. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/u03payiqacoi1ry1x4toqclfp0pbwa9q/', 'html5', 800, 600, 1576076683, '1', '0'),
(1296, 'gamemonetize-152', 'cute-little-horse-jigsaw', 'Cute Little Horse Jigsaw', 'https://img.gamemonetize.com/zotv24n6nrnthpqn22hahz32vsfsfkse/512x384.jpg', '0', 5, 0, '0', 'Cute Little Horse Jigsaw is a fun online puzzle game. Drag the pieces into right position using mouse. Solving puzzles is relaxing, rewarding, and keeps your brain sharp. You must solve the first picture and win over $1,000 in order to be able to purchase one of the following pictures. You have three modes for each picture from which the hardest mode brings more money. You have a total of 10 pictures.', '', 'https://html5.gamemonetize.com/zotv24n6nrnthpqn22hahz32vsfsfkse/', 'html5', 960, 640, 1576076683, '1', '0')";
$db[30] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1297, 'gamemonetize-151', 'eg-super-pongoal', 'EG Super PonGoal', 'https://img.gamemonetize.com/1myzm3nxltu3mt27uxq3nby2hebut3ku/512x384.jpg', '0', 8, 1, '0', 'EG Super PonGoal is HTML5 games - It is currently the most advanced version of the game of ping pong, right in the game menu you can change the ball to any of the presented the menu, choose the cards to change the level of difficulty of the enemy robot, able to choose the duration of the game round from 1 to 10 minutes, can also be choose flight speed and rotation of the ball! Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/1myzm3nxltu3mt27uxq3nby2hebut3ku/', 'html5', 800, 600, 1576076683, '1', '0'),
(1298, 'gamemonetize-150', 'real-dog-racing-simulator-3d', 'Real Dog Racing Simulator 3D', 'https://img.gamemonetize.com/v4r0v3ci7w7k95pslmtshnxc4yicl3vh/512x384.jpg', '0', 2, 0, '0', 'Real Dog Racing Simulator 3D is dog racing game for dog lovers. This game has very exciting features like dog selection, color selection level selection, and many other options. In-store manager, you can find any type of pets and breed. This Amazing dog racing game has three different types of mode arcade, endless and knockout model for every type of users. Use WASD or Arrows to control your pet.', '', 'https://html5.gamemonetize.com/v4r0v3ci7w7k95pslmtshnxc4yicl3vh/', 'html5', 960, 600, 1576076683, '1', '0'),
(1299, 'gamemonetize-149', 'mermaid-princess', 'Mermaid Princess', 'https://img.gamemonetize.com/ngx2fysved7v56qv6h8nvbbg15tbiif6/512x384.jpg', '0', 1, 0, '0', 'Have you ever dreamed of visiting a real underwater city, where a beautiful mermaid princess lives? Embark on an amazing under sea adventure and live a mermaid life with our mermaid games free for girls with levels!', '', 'https://html5.gamemonetize.com/ngx2fysved7v56qv6h8nvbbg15tbiif6/', 'html5', 960, 600, 1576076683, '1', '0'),
(1300, 'gamemonetize-148', 'stupid-zombies-hunt', 'Stupid Zombies Hunt', 'https://img.gamemonetize.com/3ea3uxhfc0ttvz5q77vodlh5qluhe6ri/512x384.jpg', '0', 3, 0, '0', 'The deads are rising. Open fire against the zombies in one of the best free zombie shooting games! Survive killing zombies in a post apocalypse wasteland, take your sniper rifle and start shooting into the living deads, as if it were the last day on earth, before they murder your fellow humans.', '', 'https://html5.gamemonetize.com/3ea3uxhfc0ttvz5q77vodlh5qluhe6ri/', 'html5', 960, 600, 1576076683, '1', '0'),
(1301, 'gamemonetize-147', 'funny-helicopter-memory', 'Funny Helicopter Memory', 'https://img.gamemonetize.com/pw4hs8txvwyqvns7dss0lcry7zl0vs1l/512x384.jpg', '0', 5, 0, '0', 'Funny Helicopter Memory is a free online game from genre of memory games. Flip the tiles and try to match them up in pairs. You have 4 levels in total, the first being the easiest and the last most difficult. Gather the most points by getting the identical cards as fast as you can. Enjoy!', '', 'https://html5.gamemonetize.com/pw4hs8txvwyqvns7dss0lcry7zl0vs1l/', 'html5', 960, 540, 1576076683, '1', '0'),
(1302, 'gamemonetize-146', 'airplane-fight', 'Airplane Fight', 'https://img.gamemonetize.com/6ffazodaae76d1w2nqx1vxt16083xe43/512x384.jpg', '0', 3, 0, '0', 'Airplane Fight is an online game that you can play for free. A group of evil airplane appeared in the sky, and they attempted to wage war. As a good pilot, you must fight for the country and honor at this moment! Fly your plane, manipulate the direction and aim at the enemy, and shoot continuously to destroy the enemy plane. Have fun playing.', '', 'https://html5.gamemonetize.com/6ffazodaae76d1w2nqx1vxt16083xe43/', 'html5', 720, 960, 1576076683, '1', '0'),
(1303, 'gamemonetize-145', 'blocks-puzzle', 'Blocks Puzzle', 'https://img.gamemonetize.com/xs1cq9ck9keydlvnqvlghncinfbfaw48/512x384.jpg', '0', 5, 0, '0', 'Blocks Puzzle or also called 1010 is a simple HTML5 puzzle game. Drag blocks into grid board until board grid vertical or horizontal line are full filled, then blocks that get filled will be removed, and make sure there is a possible moves for available blocks.', '', 'https://html5.gamemonetize.com/xs1cq9ck9keydlvnqvlghncinfbfaw48/', 'html5', 720, 1080, 1576076683, '1', '0'),
(1304, 'gamemonetize-144', 'driver', 'Driver', 'https://img.gamemonetize.com/ortdft8zc85plj575i6gd3w8wk5yisy6/512x384.jpg', '0', 2, 0, '0', 'Driver features various cars and motorcycles to drive; Complete freedom to take the cars from the other people.', '', 'https://html5.gamemonetize.com/ortdft8zc85plj575i6gd3w8wk5yisy6/', 'html5', 960, 600, 1576076683, '1', '0'),
(1305, 'gamemonetize-143', 'car-transport-truck-simulator', 'Car Transport Truck Simulator', 'https://img.gamemonetize.com/690vs85ooqpsw2u9t1zhqf3akfnuwx82/512x384.jpg', '0', 1, 0, '0', 'Car Transport Truck Simulator Game is a fun and challenging car transporting truck driving game. Drive a car transporter truck across beautiful levels and transport super fast luxury cars from one city to the other. Feel like a real trucker in this exciting truck driving game. Get behind the wheel and drive through real life traffic to transport super fast luxury cars from one city to another.', '', 'https://html5.gamemonetize.com/690vs85ooqpsw2u9t1zhqf3akfnuwx82/', 'html5', 960, 600, 1576076683, '1', '0'),
(1306, 'gamemonetize-142', 'anti-stress-game', 'Anti Stress Game', 'https://img.gamemonetize.com/79vu9bkqef3ufo3fi21vax5mefm9fdbn/512x384.jpg', '0', 1, 0, '0', 'Anti Stress Game is fun html5 game suitable for all ages. Play around and try to relax. Stress is not good option for you. Say good buy to stress. Have fun and stress free time.', '', 'https://html5.gamemonetize.com/79vu9bkqef3ufo3fi21vax5mefm9fdbn/', 'html5', 480, 854, 1576076683, '1', '0'),
(1307, 'gamemonetize-141', 'boeing-flight-simulator-3d', 'Boeing Flight Simulator 3D', 'https://img.gamemonetize.com/4zjwsessxzxue46dzk9jlfcbu2ln30y8/512x384.jpg', '0', 1, 0, '0', 'Boeing Flight Simulator 3D is an awesome flight simulator game that will show you how to fly a plane like a pilot! This realistic airplane pilot simulator teaches you how to pilot your aircraft safely from the ground into the sky and land back on the ground. Put yourself on the pilot’s seat and play this amazing flying simulator game. Use Arrows to control plane and mouse to enable additional option such as acceleration and chassis release and closure.', '', 'https://html5.gamemonetize.com/4zjwsessxzxue46dzk9jlfcbu2ln30y8/', 'html5', 960, 600, 1576076683, '1', '0'),
(1308, 'gamemonetize-140', 'the-island-survival-challenge', 'The Island Survival Challenge', 'https://img.gamemonetize.com/hm7lz708o2gtk33pgrkffsbprpf1b3us/512x384.jpg', '0', 1, 0, '0', 'The Island Survival Challenge game will check your abilities to survive on the island. Can you do that? Use WASD and mouse to walk and look. E - to interact. Tab - inventory. C - character inventory.', '', 'https://html5.gamemonetize.com/hm7lz708o2gtk33pgrkffsbprpf1b3us/', 'html5', 900, 600, 1576076683, '1', '0'),
(1309, 'gamemonetize-139', 'heavy-crane-simulator', 'Heavy Crane Simulator', 'https://img.gamemonetize.com/iql2z4va6k9rugtxcuf93c96eof45rln/512x384.jpg', '0', 1, 0, '0', 'In this Heavy Crane Simulator game, you’ll experience operating crane to do different jobs in different place. Moreover, you also have chance to drive heavy truck, which you’ll drive and work together with cranes to transport containers.', '', 'https://html5.gamemonetize.com/iql2z4va6k9rugtxcuf93c96eof45rln/', 'html5', 960, 640, 1576076683, '1', '0'),
(1310, 'gamemonetize-138', 'watermelon-shooting-3d', 'Watermelon Shooting 3D', 'https://img.gamemonetize.com/tq28c3japlynzvr2wmeyknfqg80o82h1/512x384.jpg', '0', 3, 0, '0', 'Watermelon Shooting 3D is one of the most fun shooting games in which you will get various kinds of handguns which you can use to shoot watermelons and splatter gooey red juice all over your screen.', '', 'https://html5.gamemonetize.com/tq28c3japlynzvr2wmeyknfqg80o82h1/', 'html5', 900, 600, 1576076683, '1', '0'),
(1311, 'gamemonetize-137', 'street-food-master-chef', 'Street Food Master Chef', 'https://img.gamemonetize.com/uap4ej0fsk6fxd11ma9bwrk5n80w74q1/512x384.jpg', '0', 1, 0, '0', 'Are you street food lover? If yes, then join us our new game Street Food Master Chef, a virtual cooking fun game. There are french fries stall, hotdog stall, pizza stall, burger stall, noodles stall and churros stall! This sounds so amazing that you can get all yummy food at only one place. Cooking fever will start in this carnival food festival. Get ready for this.', '', 'https://html5.gamemonetize.com/uap4ej0fsk6fxd11ma9bwrk5n80w74q1/', 'html5', 900, 600, 1576076683, '1', '0'),
(1312, 'gamemonetize-136', 'euro-cargo-transporter-truck-driver-simulator-2019', 'Euro Cargo Transporter Truck Driver Simulator 2019', 'https://img.gamemonetize.com/h3ke66kpqw2a7pzmxzy2x1vvjpkwdjjv/512x384.jpg', '0', 2, 0, '0', 'Let&#039;s become the cargo transporter of 2019 by driving the oversized or overloaded cargo trucks to the destination. Cargo transporter has the skillful driver, who drives the oversized Cargo Trucks &amp; Trala in a very professional way. This is a great test to know how good are you behind the wheel in an awesome and amazing top offroad big machine Public transportation game of 2019.', '', 'https://html5.gamemonetize.com/h3ke66kpqw2a7pzmxzy2x1vvjpkwdjjv/', 'html5', 960, 600, 1576076683, '1', '0'),
(1313, 'gamemonetize-135', 'pipe-mania', 'Pipe Mania', 'https://img.gamemonetize.com/gonbteehe041dhx5dytql4w9864z26si/512x384.jpg', '0', 5, 0, '0', 'In this game, you will become a plumber. The main mission is to connect the pipes to drain water to target pipe without any leak. Each level have a different difficulties, you must complete each level to unlock the next level.', '', 'https://html5.gamemonetize.com/gonbteehe041dhx5dytql4w9864z26si/', 'html5', 720, 1080, 1576076683, '1', '0'),
(1314, 'gamemonetize-134', 'wood-block-puzzle', 'Wood Block Puzzle', 'https://img.gamemonetize.com/vv344kmkdd9idhkmjoth4obh4e43fcsb/512x384.jpg', '0', 5, 0, '0', 'Wood Block Puzzle is a classic and addictive puzzle block game! Block Puzzle is a fun puzzle game for all adults and children. It is simple, but difficult to master. You can play this wood style block puzzle to relax and train your brain. More crush wood blocks,more score.', '', 'https://html5.gamemonetize.com/vv344kmkdd9idhkmjoth4obh4e43fcsb/', 'html5', 500, 800, 1576076683, '1', '0'),
(1315, 'gamemonetize-133', 'speed-bumps', 'Speed Bumps', 'https://img.gamemonetize.com/3f492rybupaddyzardiohvlpn49xgxwk/512x384.jpg', '0', 2, 0, '0', 'If you&#039;re looking for thrilling game experience then you&#039;re at the right place. Enjoy the best speed bumps game and drive your car on 300+ speed breakers and have an experience of your life time speeding. Not like many other racing cars game, its a different version of speed bump crossing game.', '', 'https://html5.gamemonetize.com/3f492rybupaddyzardiohvlpn49xgxwk/', 'html5', 960, 600, 1576076683, '1', '0'),
(1316, 'gamemonetize-132', 'boxkid', 'BoxKid', 'https://img.gamemonetize.com/5n457bokojcj6nllso7q8hwq0km8dapi/512x384.jpg', '0', 5, 0, '0', 'BoxKid is a simple puzzle game. Push boxes or crates into target point or goals to complete a level, there are built-in 70-levels with different difficulty.there is 4 different game control type, Keyboard (Arrow key), Swipe (Touch), Control button left and right.', '', 'https://html5.gamemonetize.com/5n457bokojcj6nllso7q8hwq0km8dapi/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1317, 'gamemonetize-131', 'lava-boy-and-blue-girl', 'Lava Boy And Blue Girl', 'https://img.gamemonetize.com/3yrhygs5xeevnonmhvc2unau0tx98flb/512x384.jpg', '0', 5, 0, '0', 'Lava Boy And Blue Girl Adventure is one of the most addictive game! Play this fire and water style game. New and nice challenge level design.', '', 'https://html5.gamemonetize.com/3yrhygs5xeevnonmhvc2unau0tx98flb/', 'html5', 900, 550, 1576076683, '1', '1'),
(1318, 'gamemonetize-130', 'endless-helix-jump', 'Endless Helix Jump', 'https://img.gamemonetize.com/6vtb2msadqw43d05oh5e0i0ui1vpv611/512x384.jpg', '0', 5, 0, '0', 'Fun arcade game in which you must help a falling ball navigate to the endless helix maze.', '', 'https://html5.gamemonetize.com/6vtb2msadqw43d05oh5e0i0ui1vpv611/', 'html5', 800, 600, 1576076683, '1', '0'),
(1319, 'gamemonetize-129', 'hexa-blocks', 'Hexa Blocks', 'https://img.gamemonetize.com/9vys7egjnqbq3b81ynwcoe0rd4yeibjs/512x384.jpg', '0', 5, 0, '0', 'Hexa Blocks is a HTML5 tetris style puzzle game, simple and addictive block puzzle game. There is 2 game mode in this game: Level: Your mission is to reach target score without run out of moves, then next level will be unlocked. the higher the level, the harder it will be. Endless: Fill the grid lines as much as possible and reach highscore!', '', 'https://html5.gamemonetize.com/9vys7egjnqbq3b81ynwcoe0rd4yeibjs/', 'html5', 720, 1080, 1576076683, '1', '0'),
(1320, 'gamemonetize-128', 'the-gladiators', 'The Gladiators', 'https://img.gamemonetize.com/0c13lyj78bcuxikfqj9fizehhjr5m1rm/512x384.jpg', '0', 5, 0, '0', 'Defeat all enemies and be a winner! Connect 3 or more element with same element type, if elements that are connected are match you will get a bonus coin, if element type is same as enemy element target, player will attack the enemy. There is 6 different place in this game, each place has 5 levels. You can upgrade your hero and unlock a new hero with game coins that you get after winning a level. You can use Gems to buy special item.', '', 'https://html5.gamemonetize.com/0c13lyj78bcuxikfqj9fizehhjr5m1rm/', 'html5', 720, 1080, 1576076683, '1', '0'),
(1321, 'gamemonetize-127', 'snow-track-racing-3d', 'Snow Track Racing 3D', 'https://img.gamemonetize.com/vcrkkbncma2kwublu6bt9cbzm9n93oey/512x384.jpg', '0', 2, 0, '0', 'Snow Track Racing 3D game allows you to explore the most exciting car racing simulation experience while drifting over the heavily snowed car racing tracks. Unlike other snow drifting games, this car drift game has real snow drifting while driving new and luxurious formula cars on asphalt tracks. Enjoy the cool car racing games for free and become the champion of online racing car games.', '', 'https://html5.gamemonetize.com/vcrkkbncma2kwublu6bt9cbzm9n93oey/', 'html5', 960, 600, 1576076683, '1', '0'),
(1322, 'gamemonetize-126', 'off-track-jungle-race', 'Off Track Jungle Race', 'https://img.gamemonetize.com/5cv9bg1xgmk899ehx3ay9et15h79bkmh/512x384.jpg', '0', 2, 0, '0', 'Fastest drivers under no fear despite lack of city highway roads, rough terrains &amp; bumpy tracks are perfect challenge for car driver off road parking. Defeat rivals in time attack mode while driving ruthlessly towards the destination. Pick up trucks for the delivery and transportation purposes are also wandering around in off road parking environment.', '', 'https://html5.gamemonetize.com/5cv9bg1xgmk899ehx3ay9et15h79bkmh/', 'html5', 960, 600, 1576076683, '1', '0'),
(1323, 'gamemonetize-125', 'trump-ragdoll-2', 'Trump Ragdoll 2', 'https://img.gamemonetize.com/845rrw1hiuiw38gxowjelc46rtgrw1k4/512x384.jpg', '0', 5, 0, '0', 'Trump Ragdoll 2 is an online game that you can play for free. Trump Ragdoll 2 is a parody and should not be taken seriously, but you can have a try in your spare time. The players need to use the mouse or tap on the screen to play around. Hope you can join us and have fun!', '', 'https://html5.gamemonetize.com/845rrw1hiuiw38gxowjelc46rtgrw1k4/', 'html5', 854, 480, 1576076683, '1', '0'),
(1324, 'gamemonetize-124', 'eg-zombie-uprising', 'EG Zombie Uprising', 'https://img.gamemonetize.com/sy1fticxen2uaa0aoxl3e2zbw97lsk4l/512x384.jpg', '0', 5, 0, '0', 'EG Zombie Uprising is destroy zombie uprising at all costs! An interesting and addictive game with different types of zombies and difficulty levels, nice graphics and sounds. Connected storage function s top score and final score. Also in the game there are more bombs and life for the player in the role makes the game more attractive! Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/sy1fticxen2uaa0aoxl3e2zbw97lsk4l/', 'html5', 800, 600, 1576076683, '1', '0'),
(1325, 'gamemonetize-123', 'truck-loads-simulator-3d', 'Truck Loads Simulator 3D', 'https://img.gamemonetize.com/1vqxd1ofcjw0iukz3g2axor6cr88epcf/512x384.jpg', '0', 2, 0, '0', 'Truck Loads Simulator 3D is a unique truck game in the categories of cargo truck games lovers with much popular traditional music of Rabab (traditional guitar) which is very popular throughout Middle East, East Asia &amp; Central Asia in Pashto &amp; Persian speaking community. Idea behind this unique games is purely perceived by very capable Trucks Arts Artists. It’s an excellent truck simulator where you will play the role of cargo truck transporter driver.', '', 'https://html5.gamemonetize.com/1vqxd1ofcjw0iukz3g2axor6cr88epcf/', 'html5', 960, 600, 1576076683, '1', '0'),
(1326, 'gamemonetize-122', 'offroad-oil-tanker-truck-drive', 'Offroad Oil Tanker Truck Drive', 'https://img.gamemonetize.com/h463jx9u2f0b58lj4k89xwnes8g7njr4/512x384.jpg', '0', 2, 0, '0', 'Drive your Oil Tanker Truck Drive 3D for transportation in wonderful and amazing top offroad truck driving game. Transport oil with the driving of heavy duty tanker to destination in oil tanker simulator. You will enjoy uphill Oil Tanker drive transporting while driving heavy duty truck with offroad hill climbing as a tanker driver. Oil truck simulator 3D game is for the lovers of oil tankers games or truck driving games.', '', 'https://html5.gamemonetize.com/h463jx9u2f0b58lj4k89xwnes8g7njr4/', 'html5', 960, 600, 1576076683, '1', '0'),
(1327, 'gamemonetize-121', 'foot-doctor', 'Foot Doctor', 'https://img.gamemonetize.com/i5rcwm3x0gd0rda24il59eg7s22mh8mz/512x384.jpg', '0', 1, 0, '0', 'Hello friends, today you are going to play coolest hospital games and be a doctor on a mission to cure all injuries of little clumsy patients that come to your clinic! Download Little Foot Doctor Games to perform various treatments for healing all sorts of wounds and have tons of fun playing emergency room games! Doctor games are the best way to start practicing if you&#039;re dreaming of becoming a surgeon and save lives!', '', 'https://html5.gamemonetize.com/i5rcwm3x0gd0rda24il59eg7s22mh8mz/', 'html5', 500, 700, 1576076683, '1', '0'),
(1328, 'gamemonetize-120', 'towing-train', 'Towing Train', 'https://img.gamemonetize.com/1pmlg652l7r368ng4ztwvgey96p4ootq/512x384.jpg', '0', 1, 0, '0', 'Love Tractor Pull, Chained Transport Games, Trainline and Train Station Games? Hero is the best Farm Tractor Simulation Game with awesome new Idea on arail rush trainline! Tractor Pull towing Train - Trainline Rail Rush Use your tractor to drag the train over 300 feet to get a full pull towards train Station.', '', 'https://html5.gamemonetize.com/1pmlg652l7r368ng4ztwvgey96p4ootq/', 'html5', 960, 600, 1576076683, '1', '0'),
(1329, 'gamemonetize-119', 'cube-endless-jumping', 'Cube Endless Jumping', 'https://img.gamemonetize.com/wunfy9l4jvv4yr22qtx6epgeqqb98gq4/512x384.jpg', '0', 1, 0, '0', 'Cube Endless Jumping is fun platform jumping game suitable for all ages. Jump as high as posssible and collect as many points as possible. Stay away from birds and baloons but jump on them to get more points. Eat food for even more points.', '', 'https://html5.gamemonetize.com/wunfy9l4jvv4yr22qtx6epgeqqb98gq4/', 'html5', 480, 854, 1576076683, '1', '0'),
(1330, 'gamemonetize-118', 'eg-smiles', 'EG Smiles', 'https://img.gamemonetize.com/odnzqiijmnu2ibmdnditjw1n8jg4s62g/512x384.jpg', '0', 5, 0, '0', 'The goal is to crushes all the smiles.. except the red one! So simple! Touch or click as fast as you can. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/odnzqiijmnu2ibmdnditjw1n8jg4s62g/', 'html5', 800, 600, 1576076683, '1', '0'),
(1331, 'gamemonetize-117', 'stone-merge', 'Stone Merge', 'https://img.gamemonetize.com/qtw5gfrxr8dzo9eyrsp7x24goes0eew5/512x384.jpg', '0', 5, 0, '0', 'Drag the rock into another one with the same number and color. After similar rock combine, rock color and number will be increased. Merge them into a bigger number!', '', 'https://html5.gamemonetize.com/qtw5gfrxr8dzo9eyrsp7x24goes0eew5/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1332, 'gamemonetize-116', 'bubble-farm', 'Bubble Farm', 'https://img.gamemonetize.com/ro3dv4ao0nwpqfi0nf2ugfd3jhn8zi3r/512x384.jpg', '0', 5, 0, '0', 'Bubble Farm is a fun and Addictive shooting bubble buster game. Complete a level to unlock the next level, each level have a different difficulty and challenge', '', 'https://html5.gamemonetize.com/ro3dv4ao0nwpqfi0nf2ugfd3jhn8zi3r/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1333, 'gamemonetize-115', 'highway-traffic-bike-stunts', 'Highway Traffic Bike Stunts', 'https://img.gamemonetize.com/xnzdxgtyamibl3cyg65dx2imo9vi2fa0/512x384.jpg', '0', 2, 0, '0', 'Highway traffic bike stunts is the most addictive superbike racing game specially designed for the furious stunt bike riders to boost their highway stunt bike simulation skills. Buckle up yourself for the ultimate superbike stunt racing game and explore the world of best superbike stunt racing in the mid of highway traffic rush. Ride the crazy asphalt racing tracks in the mid of city highway traffic rush.', '', 'https://html5.gamemonetize.com/xnzdxgtyamibl3cyg65dx2imo9vi2fa0/', 'html5', 960, 600, 1576076683, '1', '0'),
(1334, 'gamemonetize-114', 'sports-car-wash-gas-station', 'Sports Car Wash Gas Station', 'https://img.gamemonetize.com/gt31gz944mj7xdm8med9a2k8ntw1inby/512x384.jpg', '0', 2, 0, '0', 'Sports Car Wash Gas Station 3d is new free simulation game for cars game lovers. Learn unique washing system to clean the dirty cars. Wash dusty cars from city car washing station to understand the best fun of cars cleaning. New city car wash simulator 3d provide you outstanding car washing service with an amazing parking zone. Are you looking for new style car wash driving games?', '', 'https://html5.gamemonetize.com/gt31gz944mj7xdm8med9a2k8ntw1inby/', 'html5', 960, 600, 1576076683, '1', '0'),
(1335, 'gamemonetize-113', 'transport-dinos-to-the-dino-zoo', 'Transport Dinos To The Dino Zoo', 'https://img.gamemonetize.com/k9iv5v4bvcu291oh4b7xsytwtlw824am/512x384.jpg', '0', 2, 0, '0', 'Transport Dinos To The Dino Zoo is an advance dino truck simulation game in the realistic jungle environment. Experience the real adventure while transporting an angry dino to the Jurassic zoo in the wild beast territory. The transport truck simulator is a real challenge to drive as you are surrounded by most furious dinosaurs of the world. So brace yourself for ultimate adventure and real thrilling action while playing the real dino transport truck simulation game.', '', 'https://html5.gamemonetize.com/k9iv5v4bvcu291oh4b7xsytwtlw824am/', 'html5', 960, 600, 1576076683, '1', '0'),
(1336, 'gamemonetize-112', 'ice-cream-making', 'Ice Cream Making', 'https://img.gamemonetize.com/cbicfmvy1zq55zn0qn8uaj5rmhecuye6/512x384.jpg', '0', 1, 0, '0', 'You can now create ice cream easily and quickly with the tap of your fingers! Tons of ice cream flavors to choose from… and plenty more toppings to add onto them! Try many different combinations and challenge yourself. See how many awesome ice creams you can make! Start now and create a huge collection to share with your friends and your family.', '', 'https://html5.gamemonetize.com/cbicfmvy1zq55zn0qn8uaj5rmhecuye6/', 'html5', 500, 800, 1576076683, '1', '0'),
(1337, 'gamemonetize-111', 'cowboy-runner', 'Cowboy Runner', 'https://img.gamemonetize.com/t2ehpqeu50bnyofnafagl3xdq3ro26kv/512x384.jpg', '0', 1, 0, '0', 'Cowboy Runner is the best looking Endless Runner type of game. Your task is to collect as much money as you can before you die and the More you Play the More Fun you Get!', '', 'https://html5.gamemonetize.com/t2ehpqeu50bnyofnafagl3xdq3ro26kv/', 'html5', 960, 600, 1576076683, '1', '0'),
(1338, 'gamemonetize-110', 'tiny-planet', 'Tiny Planet', 'https://img.gamemonetize.com/f4v6975r6s0fnxrwuidr8tljn9ct0wrf/512x384.jpg', '0', 4, 0, '0', 'Tiny Planet game a very interesting game in casual style. In this game, players need to constantly rotate to avoid danger, and pay attention to changing the shape of the route to avoid.', '', 'https://html5.gamemonetize.com/f4v6975r6s0fnxrwuidr8tljn9ct0wrf/', 'html5', 500, 800, 1576076683, '1', '0'),
(1339, 'gamemonetize-109', 'candy-block', 'Candy Block', 'https://img.gamemonetize.com/m246tco4r9eslaxcenjbu0q8pj4d7bft/512x384.jpg', '0', 5, 0, '0', 'Move the blocks to fill the empty tiles and collect the pieces of blocks to level up!', '', 'https://html5.gamemonetize.com/m246tco4r9eslaxcenjbu0q8pj4d7bft/', 'html5', 720, 1280, 1576076683, '1', '0'),
(1340, 'gamemonetize-108', 'teen-titans-jigsaw', 'Teen Titans Jigsaw', 'https://img.gamemonetize.com/exl608b1aio57ikgo7b996nbxiu0opj2/512x384.jpg', '0', 5, 0, '0', 'Teen Titans Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/exl608b1aio57ikgo7b996nbxiu0opj2/', 'html5', 960, 540, 1576076683, '1', '0'),
(1341, 'gamemonetize-107', 'sumo-io', 'Sumo.io', 'https://img.gamemonetize.com/k6e3cq9jiwzu5sq5zwvbdfcoij895w2q/512x384.jpg', '0', 1, 0, '0', 'The most addictive game! First Sumo.io game ever! Bump your sumo enemy and win epic sumo.io fight! Fight beetwen players in epic sumo io fight! Get ready and start real sumo wrestler fights, start practice with this ultimate world sumo wrestling champion’s game. Experience the real sumo fighting!', '', 'https://html5.gamemonetize.com/k6e3cq9jiwzu5sq5zwvbdfcoij895w2q/', 'html5', 800, 600, 1576076683, '1', '0'),
(1342, 'gamemonetize-106', 'seesaw-ramp-car-balance-driving-challenge', 'SeeSaw Ramp Car Balance Driving Challenge', 'https://img.gamemonetize.com/c9h61m5xdln00r79sicnp23jtodn96xl/512x384.jpg', '0', 1, 0, '0', 'HERE! we came with a new idea for adventure game players, it&#039;s a seesaw car balance where you have to balance your car on a SeeSaw Ramp with an opponent or alone as a training mode. An inclined plane, also known as a mini ramp stunt, is a flat supporting surface tilted at an angle, with one end of ramp higher than the other ramp, used as an aid for raising or lowering a load.', '', 'https://html5.gamemonetize.com/c9h61m5xdln00r79sicnp23jtodn96xl/', 'html5', 960, 600, 1576076683, '1', '0'),
(1343, 'gamemonetize-105', 'hopscotch', 'HopScotch', 'https://img.gamemonetize.com/dtooj0khu5crow3luiiv66qvwqk0l0az/512x384.jpg', '0', 4, 0, '0', 'A childhood flashback! Remember when life was easy, the only you had to worry which game to play during recess! Don’t look further, hopscotch is here, dive into your childhood memories and just enjoy!', '', 'https://html5.gamemonetize.com/dtooj0khu5crow3luiiv66qvwqk0l0az/', 'html5', 500, 800, 1576076683, '1', '0'),
(1344, 'gamemonetize-104', 'gun-shot', 'Gun Shot', 'https://img.gamemonetize.com/63q2w1wajel1xvgzjf21kvkwes65ea9l/512x384.jpg', '0', 4, 0, '0', 'Gun Shot is Brand New Bottle Shooting Game With Gun , How to Play Twist Gun Game Aim the bottle and Shoot with Gun release the bullet', '', 'https://html5.gamemonetize.com/63q2w1wajel1xvgzjf21kvkwes65ea9l/', 'html5', 450, 800, 1576076683, '1', '0'),
(1345, 'gamemonetize-103', 'xtreme-real-city-car-parking', 'Xtreme Real City Car Parking', 'https://img.gamemonetize.com/xkquf2fyvfx2uea7lma86dz9m2khhszf/512x384.jpg', '0', 2, 0, '0', 'Driving challenge come with Advance Features in this game. Park your cars in supermarket building and enhance your parking skills. In this the vital parking, driving, and simulation! This is a Multi-level simulation game that you never play before! Park your Car without hitting any obstacles! Avoid crashing into barriers and other vehicles! This is quite the challenge. Do you think you can park the amazing cars accurately? Get ready for this supermarket modern car parking game!', '', 'https://html5.gamemonetize.com/xkquf2fyvfx2uea7lma86dz9m2khhszf/', 'html5', 960, 600, 1576076683, '1', '0'),
(1346, 'gamemonetize-102', 'sniper-clash-3d', 'Sniper Clash 3D', 'https://img.gamemonetize.com/20qv2eol679xos3gu39edys4yvn2b8ed/512x384.jpg', '0', 3, 0, '0', 'Take a role of a secret agent sniper to infiltrate and seize the trophy relic from the evil desert nomads. Aim and shoot to kill. There are also many hidden objects and secret weapons on the level. Find them all to make your tactical comeback. Survive the storm in the desert surrounded by greeny palm trees against the sunset evening sky.', '', 'https://html5.gamemonetize.com/20qv2eol679xos3gu39edys4yvn2b8ed/', 'html5', 1000, 562, 1576076683, '1', '1'),
(1347, 'gamemonetize-101', 'rocket-clash-3d', 'Rocket Clash 3D', 'https://img.gamemonetize.com/jiybs4emy2vc1utvpov7qgfmgnzdwcaf/512x384.jpg', '0', 3, 0, '0', 'Lead the resistance squad of special forces opposed to attempts of enemy intelligence agents to establish control over the missile base. In this battle you’ll harness the power of a tactical shortened version of the famous AK and a secret weapon hidden in the depths of the level. Be wary of acid pools of toxic rocket fuel and explore the network of underground tunnels.', '', 'https://html5.gamemonetize.com/jiybs4emy2vc1utvpov7qgfmgnzdwcaf/', 'html5', 1000, 562, 1576076683, '1', '1'),
(1348, 'gamemonetize-100', 'farm-clash-3d', 'Farm Clash 3D', 'https://img.gamemonetize.com/7zxmieik4zri4g6wkcrphqrk8v05emll/512x384.jpg', '0', 3, 0, '0', 'Lead a noble squad of gallant Cowboys and punish the evil Apaches, raiding on the farm&#039;s ripe pumpkins. Use the deadly shotgun or secret weapon hidden in the depths of the level to stop the enemies. Rumble around the houses in search of useful secrets.', '', 'https://html5.gamemonetize.com/7zxmieik4zri4g6wkcrphqrk8v05emll/', 'html5', 1000, 562, 1576076683, '1', '0'),
(1349, 'gamemonetize-99', 'subway-clash-3d', 'Subway Clash 3D', 'https://img.gamemonetize.com/nduhdua0yup2i0k4llj5wjplk62np2md/512x384.jpg', '0', 3, 1, '0', 'You fight in an underground area of Moscow metro full of angry KGB soldiers trying to bring you down. Pick up various weapons to defend yourself and lead to the top of rank table!', '', 'https://html5.gamemonetize.com/nduhdua0yup2i0k4llj5wjplk62np2md/', 'html5', 1000, 562, 1576076683, '1', '1'),
(1350, 'gamemonetize-98', 'block-pusher', 'Block Pusher', 'https://img.gamemonetize.com/6us7arqh9q9sf33kcb7lhg982rat9hrf/512x384.jpg', '0', 4, 0, '0', 'Simple control with just swipes. Move the player, and push off objects as many as you can! It is so satisfying to destroy a huge structure or push many things at the same time! You won&#039;t be able to stop playing it!', '', 'https://html5.gamemonetize.com/6us7arqh9q9sf33kcb7lhg982rat9hrf/', 'html5', 450, 800, 1576076683, '1', '0'),
(1351, 'gamemonetize-97', 'sweet-candy-saga', 'Sweet Candy Saga', 'https://img.gamemonetize.com/84txxwbq8xhe7i91v06x8vduxwmuijrq/512x384.jpg', '0', 5, 0, '0', 'Sweet Candy Saga is a HTML5 match-3 type game, match-3 is a popular type of casual puzzle game. The objective of Sweet Candy Saga is to swap one candy with another candy on a horizontal or vertical chain of three or more candy of the same color.', '', 'https://html5.gamemonetize.com/84txxwbq8xhe7i91v06x8vduxwmuijrq/', 'html5', 720, 1080, 1576076683, '1', '0'),
(1352, 'gamemonetize-96', 'snow-patrol', 'Snow Patrol', 'https://img.gamemonetize.com/eovtmu8vfg1sbkob0erxszu1xss0tr17/512x384.jpg', '0', 5, 0, '0', 'Gather as many balls as possible and push them into the hole. Got enough balls? Keep going into the next session. Do that until you finish the level.', '', 'https://html5.gamemonetize.com/eovtmu8vfg1sbkob0erxszu1xss0tr17/', 'html5', 450, 800, 1576076683, '1', '0'),
(1353, 'gamemonetize-95', 'miner-dash', 'Miner Dash', 'https://img.gamemonetize.com/2mtyeefch9ddhxz9in65ortz1pj122j4/512x384.jpg', '0', 5, 0, '0', 'Try to reach the earth&#039;s core within 30 days to win! Dig down deep, collect precious elements and materials, then craft new items. Keep reaping this process until you reach the core to see your final high score. Unlock new recipes so that you can craft new items in this super fun mining game.', '', 'https://html5.gamemonetize.com/2mtyeefch9ddhxz9in65ortz1pj122j4/', 'html5', 800, 600, 1576076683, '1', '1'),
(1354, 'gamemonetize-94', 'car-vs-cops-2', 'Car vs Cops 2', 'https://img.gamemonetize.com/slhy1eedkyf3g5zx989fz220e3mspgii/512x384.jpg', '0', 2, 0, '0', 'Car vs Cops 2?! Escape from cop cars in this endless high speed chase game. Maneuver around by either using the joystick or tap controls. Enable combo scoring by letting cops come close to you.', '', 'https://html5.gamemonetize.com/slhy1eedkyf3g5zx989fz220e3mspgii/', 'html5', 800, 600, 1576076683, '1', '1'),
(1355, 'gamemonetize-93', 'race-down', 'Race Down', 'https://img.gamemonetize.com/ngirkj4jmmbgpshtiou9ttvcn9ppkel8/512x384.jpg', '0', 2, 0, '0', 'Race Down is fun car game that you can play online for free. You must race down but stay on the platforms while you drive and collect as many coins as possible. If you hit the top or bottom of the screen the game is over. Have fun.', '', 'https://html5.gamemonetize.com/ngirkj4jmmbgpshtiou9ttvcn9ppkel8/', 'html5', 480, 854, 1576076683, '1', '0'),
(1356, 'gamemonetize-92', 'anime-dress-up', 'Anime Dress Up', 'https://img.gamemonetize.com/s1qp0r1frycqhaj1c8thljz9z6vct0vm/512x384.jpg', '0', 1, 0, '0', 'Description: Create you perfect anime character! Make a screenshot and use it as your avatar. Features: Graphics in anime style 10 692 000 combinations of the appearance Many unusual items Cute cats Screenshot button Random button Controls: Touch Mouse Platforms: Desktop browsers Mobile browsers', '', 'https://html5.gamemonetize.com/s1qp0r1frycqhaj1c8thljz9z6vct0vm/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1357, 'gamemonetize-91', 'angry-checkers', 'Angry Checkers', 'https://img.gamemonetize.com/skma0pcrooj5rpuhitzk7etjqfsctr3l/512x384.jpg', '0', 1, 0, '0', 'Description: Common checkers are boring? Try angry checkers! Try to beat enemy checkers out of the board. Game modes 1. Multiplayer - you play versus another random player via internet. 2. Single Player - you play versus AI. 3. Hot Seat - you play versus your friend on the same device. Features: Multiplayer Endless replayability Well polished art and sound Controls: Touch Mouse Platforms: Desktop browsers Mobile browsers Game modes: 1. Multiplayer - you play versus another random player via internet. 2. Single Player - you play versus AI. 3. Hot Seat - you play versus your friend on the same d', '', 'https://html5.gamemonetize.com/skma0pcrooj5rpuhitzk7etjqfsctr3l/', 'html5', 960, 640, 1576076683, '1', '0'),
(1358, 'gamemonetize-90', 'snaker-io', 'Snaker.io', 'https://img.gamemonetize.com/o34kce319kqqcdxpqyl4wso901bg8shw/512x384.jpg', '0', 1, 0, '0', 'Snaker.io is addictive online io game! Enter the arena and face the other snakes in a fierce battle. Eat all energy in sight with your snake and grow it to win ! Show off who is the biggest snake in town!', '', 'https://html5.gamemonetize.com/o34kce319kqqcdxpqyl4wso901bg8shw/', 'html5', 800, 600, 1576076683, '1', '1'),
(1359, 'gamemonetize-89', 'break-the-key', 'Break The Key', 'https://img.gamemonetize.com/yfq9fxr09gg8gxjxtkhr1h5ddd3t03ry/512x384.jpg', '0', 5, 0, '0', 'With the block moving, break the key! You can move the block up, down, left, and right. How far can your mind take you?', '', 'https://html5.gamemonetize.com/yfq9fxr09gg8gxjxtkhr1h5ddd3t03ry/', 'html5', 405, 720, 1576076683, '1', '0'),
(1360, 'gamemonetize-88', 'stickman-war', 'Stickman War', 'https://img.gamemonetize.com/x2z5jicm546h5i0oje0mfy8w1l1sefrb/512x384.jpg', '0', 5, 1, '0', 'Stickman War is an Action/Shooter game where your mission is kill all the stickman to complete the game.', '', 'https://html5.gamemonetize.com/x2z5jicm546h5i0oje0mfy8w1l1sefrb/', 'html5', 720, 480, 1576076683, '1', '0'),
(1361, 'gamemonetize-87', 'billiards-city', 'Billiards City', 'https://img.gamemonetize.com/7gmg5jgpnvi33j7d252rj7kg57hklw3t/512x384.jpg', '0', 8, 0, '0', 'Billiards City is online HTML5 version of worldwide popular Pooking -Billiards City game! The BEST &amp; STUNNING 8 ball pool challenge billiard game with lot of fun and many levels!', '', 'https://html5.gamemonetize.com/7gmg5jgpnvi33j7d252rj7kg57hklw3t/', 'html5', 1280, 720, 1576076683, '1', '1'),
(1362, 'gamemonetize-86', 'talking-baby-ginger', 'Talking Baby Ginger', 'https://img.gamemonetize.com/osr07ywg24oox8hrr6swdujgph3skux9/512x384.jpg', '0', 8, 0, '0', 'Talking Baby Ginger Funny Time is an online game that you can play for free. This game gives you the chance to get along with your favorite Talking Baby Ginger! You can bathe him, dry his hair or let him make a cute expression! You must be eager to start the game. Have a nice time!', '', 'https://html5.gamemonetize.com/osr07ywg24oox8hrr6swdujgph3skux9/', 'html5', 480, 854, 1576076683, '1', '1'),
(1363, 'gamemonetize-85', 'bts-monster-truck-coloring', 'BTS Monster Truck Coloring', 'https://img.gamemonetize.com/egee6h4lxgleujv39bb6b5yp9nyy0dye/512x384.jpg', '0', 8, 0, '0', 'BTS Monster Truck Coloring is an online game that you can play for free alone or with your friends. Come play the nice coloring game! What is your favorite color? You will definitely find it in this game and you can color these cool monster trucks. Create your own truck and enviroment. Maybe you can become an artist. Share pictures with your friends. You can play the game on your mobile as well. Have a good time in BTS Monster Truck Coloring Book!', '', 'https://html5.gamemonetize.com/egee6h4lxgleujv39bb6b5yp9nyy0dye/', 'html5', 854, 480, 1576076683, '1', '0'),
(1364, 'gamemonetize-84', 'candy-match3', 'Candy Match3', 'https://img.gamemonetize.com/z25kovuzu67m0p07pxgqfvgcdvj550b5/512x384.jpg', '0', 8, 0, '0', 'Candy Match3 is an online game that you can play for free You need to match three of the same candies to get points There is no time limit for this game but there is a limited number of steps Reach the target score of each level to enter the next one Have a good time playing', '', 'https://html5.gamemonetize.com/z25kovuzu67m0p07pxgqfvgcdvj550b5/', 'html5', 640, 960, 1576076683, '1', '0'),
(1365, 'gamemonetize-83', 'funny-monster-jigsaw', 'Funny Monster Jigsaw', 'https://img.gamemonetize.com/nwxzt76z3ucmuzpqq82wshamdhj21j5p/512x384.jpg', '0', 5, 0, '0', 'Funny Monster Jigsaw is a free online game from genre of puzzle and jigsaw games. You can select one of the 12 images and then select one of the three modes: easy with 25 pieces, medium with 49 pieces and hard with 100 pieces. Have fun and enjoy!', '', 'https://html5.gamemonetize.com/nwxzt76z3ucmuzpqq82wshamdhj21j5p/', 'html5', 960, 540, 1576076683, '1', '0'),
(1366, 'gamemonetize-82', 'oink-run', 'Oink Run', 'https://img.gamemonetize.com/22sj41wx49z14a3uknv1gna9n26wff8h/512x384.jpg', '0', 5, 0, '0', 'Welcome to our game with the wonderful piglet called Oink Run. The task in this game is with the little pig to run as far as possible. You need to collect diamonds to shoot down the poisonous mushrooms that are an obstacle in this game. For a while the pig will get wings and you can fly. You can also use the parachute by pressing the X button when you are up. You shoot by pressing the Z button. Have fun!', '', 'https://html5.gamemonetize.com/22sj41wx49z14a3uknv1gna9n26wff8h/', 'html5', 960, 540, 1576076683, '1', '0'),
(1367, 'gamemonetize-81', 'temple-run-tomb', 'Temple Run Tomb', 'https://img.gamemonetize.com/dlnobuyrrwc6y2x6uq86c6xp2esa1vwe/512x384.jpg', '0', 5, 0, '0', 'Best running game in mysterious temple.', '', 'https://html5.gamemonetize.com/dlnobuyrrwc6y2x6uq86c6xp2esa1vwe/', 'html5', 480, 800, 1576076683, '1', '1'),
(1368, 'gamemonetize-80', 'basketball-bounce', 'Basketball Bounce', 'https://img.gamemonetize.com/8nq8ljwynti3arlyd33bl19akmyjajyj/512x384.jpg', '0', 5, 0, '0', 'Basketball Bounce 2 is an online game that you can play for free. This game is an online game which you can perform for totally free. The gamers need to use the mouse to prevent the ball escape from the screen. You need to faucet on the screen to close the brick cage. The procedure is definitely fascinating and enjoyable. Hope you can have fun!', '', 'https://html5.gamemonetize.com/8nq8ljwynti3arlyd33bl19akmyjajyj/', 'html5', 854, 480, 1576076683, '1', '0'),
(1369, 'gamemonetize-79', 'airplane-io', 'Airplane IO', 'https://img.gamemonetize.com/1i9ar314046uj5v6p91kcl8em378zm60/512x384.jpg', '0', 1, 0, '0', 'Airplan io is an online game that you can play for free Airplan Io is a fun game suitable for all ages The operation of the game is very simple You just need to control your airplan to move on the map Absorb the energy points on the map to make you stronger Be careful not to hit your enemy or you will lose the game Have fun playing with Airplanio', '', 'https://html5.gamemonetize.com/1i9ar314046uj5v6p91kcl8em378zm60/', 'html5', 854, 480, 1576076683, '1', '0'),
(1370, 'gamemonetize-78', '3d-ball-pool', '3D Ball Pool', 'https://img.gamemonetize.com/ozjq3f4vbq3z9l5gfhq7q7bd4bvo7vbv/512x384.jpg', '0', 8, 0, '0', 'This is authentic 3D pool experience like you’ve never seen on PC. Unlike other pool games, 3D Pool Ball offers playing pool (a.k.a pocket billiards) in 3D view as it should be played in real world. Play on PC or on mobile this 3D Ball pool in HTML5.', '', 'https://html5.gamemonetize.com/ozjq3f4vbq3z9l5gfhq7q7bd4bvo7vbv/', 'html5', 800, 600, 1576076683, '1', '0'),
(1371, 'gamemonetize-77', 'monopoly-online', 'Monopoly Online', 'https://img.gamemonetize.com/rb9b7ctnmy1rjphxzuwlmy8c4b7mw9po/512x384.jpg', '0', 5, 0, '0', 'MONOPOLY online game. It&#039;s the classic game of Monopoly that you know and love with an online twist. Relive one of the most iconic board game series of all time, the classic Business game Monopoly now online', '', 'https://html5.gamemonetize.com/rb9b7ctnmy1rjphxzuwlmy8c4b7mw9po/', 'html5', 800, 600, 1576076683, '1', '1'),
(1372, 'gamemonetize-76', 'pacman', 'PACMAN', 'https://img.gamemonetize.com/o5n36b1vs9x75c4g9rn3w8kgz7b1m8ma/512x384.jpg', '0', 5, 0, '0', 'Classic pacman game. If you like pacman game, come here and we prepared it for you! This game is easy, just collect all the dots on the map and you will win, but there will be many obstacles, be careful.', '', 'https://html5.gamemonetize.com/o5n36b1vs9x75c4g9rn3w8kgz7b1m8ma/', 'html5', 800, 600, 1576076683, '1', '1'),
(1373, 'gamemonetize-75', 'glow-hockey', 'Glow Hockey', 'https://img.gamemonetize.com/khlp8mhhg97yfb5wnnl5l3iq725kaldv/512x384.jpg', '0', 8, 0, '0', 'Glow Hockey delivers a new style of online hockey game. Easy to play, hard to master. Challenge yourself with the computer opponents! Play on mobile and on PC.', '', 'https://html5.gamemonetize.com/khlp8mhhg97yfb5wnnl5l3iq725kaldv/', 'html5', 480, 800, 1576076683, '1', '0'),
(1374, 'gamemonetize-74', 'brawl-royale', 'Brawl Royale', 'https://img.gamemonetize.com/kg0aah69u3sn55b3tfs550mscfs5277m/512x384.jpg', '0', 8, 0, '0', 'Join battle royale squad with Brawl Royale Stars! Fast-paced battles with brawl stars gameplay! Battle solo in arena and fight with other enemies!', '', 'https://html5.gamemonetize.com/kg0aah69u3sn55b3tfs550mscfs5277m/', 'html5', 800, 600, 1576076683, '1', '1'),
(1375, 'gamemonetize-73', 'air-fighter', 'Air Fighter', 'https://img.gamemonetize.com/ei9kymexre5gn1mat4p8jajb7p6lxogb/512x384.jpg', '0', 8, 0, '0', 'The gorgeous evolution of a retro shooting game! Shoot&#039;em up! Space arcade shooting game! Invaders are taking over the galaxy you must eliminate them!', '', 'https://html5.gamemonetize.com/ei9kymexre5gn1mat4p8jajb7p6lxogb/', 'html5', 800, 600, 1576076683, '1', '0'),
(1376, 'gamemonetize-72', 'galaxy-sky-war', 'Galaxy Sky War', 'https://img.gamemonetize.com/wsxzv44njz1d7dey67w24nd9v9wv4we1/512x384.jpg', '0', 8, 0, '0', 'Galaxy Sky War is a fast-paced top-down perspective shoot space war game. Shoot galaxy fruits on your way and complete all crazy levels!', '', 'https://html5.gamemonetize.com/wsxzv44njz1d7dey67w24nd9v9wv4we1/', 'html5', 480, 800, 1576076683, '1', '0'),
(1377, 'gamemonetize-71', 'doom-dr-scifi', 'Doom Dr SciFi', 'https://img.gamemonetize.com/xpxpsd7x8dpibgff79d6h3bmyxaae0vc/512x384.jpg', '0', 8, 0, '0', 'Destroy the slime aliens and explore magic space maze in Doom Dr SciFi Shooter.', '', 'https://html5.gamemonetize.com/xpxpsd7x8dpibgff79d6h3bmyxaae0vc/', 'html5', 800, 600, 1576076683, '1', '0'),
(1378, 'gamemonetize-70', 'lara-croft-tomb-raider', 'Lara Croft Tomb Raider', 'https://img.gamemonetize.com/zbddnexm8v6ne6fhjy84tqcsmiboi3zi/512x384.jpg', '0', 8, 0, '0', 'Explore magic maze with Lara Croft in epic adventure through magic temple - Play online Lara Croft Tomb Raider!', '', 'https://html5.gamemonetize.com/zbddnexm8v6ne6fhjy84tqcsmiboi3zi/', 'html5', 800, 600, 1576076683, '1', '0'),
(1379, 'gamemonetize-69', 'traffic-run-2', 'Traffic Run 2', 'https://img.gamemonetize.com/1bxfpwz3mjl0ixo5xqoqjyjiwbevh8ri/512x384.jpg', '0', 4, 0, '0', 'Traffic Run in HTML5 version! Cross the streets without hitting cars and get to the goal. Let&#039;s go for a drive! Cross the streets without hitting cars and get to the goal. Simple control with a tap. It is super addictive.', '', 'https://html5.gamemonetize.com/1bxfpwz3mjl0ixo5xqoqjyjiwbevh8ri/', 'html5', 800, 600, 1576076683, '1', '1'),
(1380, 'gamemonetize-68', 'zombie-pacman', 'Zombie PACMAN', 'https://img.gamemonetize.com/b3hvimnc15nz8h6y8qhmsxzxg8bdroy3/512x384.jpg', '0', 4, 0, '0', 'Avoid the zombies running around this huge pacman maze.', '', 'https://html5.gamemonetize.com/b3hvimnc15nz8h6y8qhmsxzxg8bdroy3/', 'html5', 1280, 720, 1576076683, '1', '0'),
(1381, 'gamemonetize-67', 'fruit-ninja-online', 'Fruit Ninja Online', 'https://img.gamemonetize.com/lrllu2q2wli15xal5rlmnkiguxqxj6s5/512x384.jpg', '0', 4, 0, '0', 'Fruit ninja online is classic slicing game! Test your speed and accuracy. How many fruit can you slash before losing three or being blown up?', '', 'https://html5.gamemonetize.com/lrllu2q2wli15xal5rlmnkiguxqxj6s5/', 'html5', 800, 600, 1576076683, '1', '1'),
(1382, 'gamemonetize-66', 'nyan-cat-flappy', 'Nyan Cat Flappy', 'https://img.gamemonetize.com/p2plk8zctrp4laba4sze0xtgiir8vmck/512x384.jpg', '0', 4, 0, '0', 'Do you think that only a bird can flap it&#039;s wings and fly? Ask Nyan Cat for the answer in her newest adventure in Flappy Nyan!', '', 'https://html5.gamemonetize.com/p2plk8zctrp4laba4sze0xtgiir8vmck/', 'html5', 800, 600, 1576076683, '1', '0'),
(1383, 'gamemonetize-65', 'bingo-pop', 'Bingo Pop', 'https://img.gamemonetize.com/q3x8ivbu57u5s28smw0zsjyjcr58cwa2/512x384.jpg', '0', 5, 0, '0', 'Enjoy bingo games free to play!!! If you enjoy playing bingo with friends then our bingo multiplayer feature is perfect for you.', '', 'https://html5.gamemonetize.com/q3x8ivbu57u5s28smw0zsjyjcr58cwa2/', 'html5', 800, 600, 1576076683, '1', '0'),
(1384, 'gamemonetize-64', 'pottery', 'Pottery', 'https://img.gamemonetize.com/1bvkgx27h23ed8iw7tw7uu8hskgtgmmh/512x384.jpg', '0', 4, 0, '0', 'Pottery in HTML5 version! Sculpt your own pots and match the target shapes! Play on PC or mobile devices!', '', 'https://html5.gamemonetize.com/1bvkgx27h23ed8iw7tw7uu8hskgtgmmh/', 'html5', 800, 600, 1576076683, '1', '0'),
(1385, 'gamemonetize-63', 'helix-jump-ball', 'Helix Jump Ball', 'https://img.gamemonetize.com/ofet6ctkqripge28zpv30tk3kv50s10g/512x384.jpg', '0', 4, 0, '0', 'Please beware of the Most addictive Endless Helix Jump Bouncing ball game ‼️ Swipe the screen to jump ball and fall through helix tower!', '', 'https://html5.gamemonetize.com/ofet6ctkqripge28zpv30tk3kv50s10g/', 'html5', 480, 800, 1576076683, '1', '0'),
(1386, 'gamemonetize-62', 'monster-craft', 'Monster Craft', 'https://img.gamemonetize.com/2wm7w9pxe13cbvsg91ji86adcqzmdh4f/512x384.jpg', '0', 4, 0, '0', 'Explore magic minecraft maze and complete all levels and tasks.', '', 'https://html5.gamemonetize.com/2wm7w9pxe13cbvsg91ji86adcqzmdh4f/', 'html5', 800, 600, 1576076683, '1', '1'),
(1387, 'gamemonetize-61', 'survival-craft', 'Survival Craft', 'https://img.gamemonetize.com/nkq351xyqdf5aqk9m4j3wq3t0k9qjh36/512x384.jpg', '0', 4, 0, '0', 'Survival Craft is one of the most addictive maze games in the world! Your main goal in this game is to try to survive in this labyrinth!', '', 'https://html5.gamemonetize.com/nkq351xyqdf5aqk9m4j3wq3t0k9qjh36/', 'html5', 800, 600, 1576076683, '1', '0'),
(1388, 'gamemonetize-60', 'real-car-parking', 'Real Car Parking', 'https://img.gamemonetize.com/0uw0plw79dn9q49n90bu1ncp3e4b3dc4/512x384.jpg', '0', 4, 0, '0', 'Get ready to practice in this best parking simulator. This car parking games will develop your driving skills but not car racing skills.', '', 'https://html5.gamemonetize.com/0uw0plw79dn9q49n90bu1ncp3e4b3dc4/', 'html5', 800, 600, 1576076683, '1', '0'),
(1389, 'gamemonetize-59', 'master-craft', 'Master Craft', 'https://img.gamemonetize.com/7e2kqom9rkxc0rlhkxhzxjptlak3uit1/512x384.jpg', '0', 4, 0, '0', 'This world is endless and you will never get bored! Survive in beautiful minecraft world and build buildings with blocks.', '', 'https://html5.gamemonetize.com/7e2kqom9rkxc0rlhkxhzxjptlak3uit1/', 'html5', 800, 600, 1576076683, '1', '1')";
$db[31] = "INSERT INTO `gm_games` (`game_id`, `catalog_id`, `game_name`, `name`, `image`, `import`, `category`, `plays`, `rating`, `description`, `instructions`, `file`, `game_type`, `w`, `h`, `date_added`, `published`, `featured`) VALUES
(1390, 'gamemonetize-58', 'mountain-climb-4x4', 'Mountain Climb 4x4', 'https://img.gamemonetize.com/brry5qcwx1zf01gwfvxxx53vi8mir5d2/512x384.jpg', '0', 2, 0, '0', 'Mountain Climb 4x4 Offroad car drive is a realistic simulation and racing game that you need to climb hills by overcoming the obstacles by an off-road vehicle.', '', 'https://html5.gamemonetize.com/brry5qcwx1zf01gwfvxxx53vi8mir5d2/', 'html5', 800, 600, 1576076683, '1', '1'),
(1391, 'gamemonetize-57', 'sling-drift-online', 'Sling Drift Online', 'https://img.gamemonetize.com/2qsndb2n9u61ubjpfdjampps51tcqbdt/512x384.jpg', '0', 2, 0, '0', 'Sling Drift is the simple drift game! Keep your car right on the middle of the path and try to pass all roads.', '', 'https://html5.gamemonetize.com/2qsndb2n9u61ubjpfdjampps51tcqbdt/', 'html5', 480, 800, 1576076683, '1', '0'),
(1392, 'gamemonetize-56', 'fire-balls', 'Fire Balls', 'https://img.gamemonetize.com/okiye416t7was7cd60sukxfb799eiw76/512x384.jpg', '0', 2, 0, '0', 'Fire Balls 3D is a casual balls game in which your goal is to destroy tower from different geometric shapes with fire balls while avoiding obstacles.', '', 'https://html5.gamemonetize.com/okiye416t7was7cd60sukxfb799eiw76/', 'html5', 480, 800, 1576076683, '1', '1'),
(1393, 'gamemonetize-55', 'mr-gun', 'Mr Gun', 'https://img.gamemonetize.com/4ejqvzc0g400zmim793k7cj9rnziciug/512x384.jpg', '0', 2, 0, '0', 'Rise up the stairs, shoot at the bad guys, earn bullets and buy steep cannons and more guns! Have fun with Mr Gun', '', 'https://html5.gamemonetize.com/4ejqvzc0g400zmim793k7cj9rnziciug/', 'html5', 800, 600, 1576076683, '1', '0'),
(1394, 'gamemonetize-54', 'paint-hit', 'Paint Hit', 'https://img.gamemonetize.com/ylx3v8bpvclcmzh21kgpey09drl56br5/512x384.jpg', '0', 2, 0, '0', 'Paint Hit in html version Enjoy painting and color balls shooting simulation Splash your drops color on the tower and paint it all the way', '', 'https://html5.gamemonetize.com/ylx3v8bpvclcmzh21kgpey09drl56br5/', 'html5', 800, 600, 1576076683, '1', '0'),
(1395, 'gamemonetize-53', 'plane-merge', 'Plane Merge', 'https://img.gamemonetize.com/i66u8tco3owxdgyptdki6gouiwvt7l0p/512x384.jpg', '0', 2, 0, '0', 'Merge planes and be a pilot Buy merge and manage your planes', '', 'https://html5.gamemonetize.com/i66u8tco3owxdgyptdki6gouiwvt7l0p/', 'html5', 800, 600, 1576076683, '1', '0'),
(1396, 'gamemonetize-52', 'training-race', 'Training Race', 'https://img.gamemonetize.com/9873khsgwxi4iqd4z9xfc3lwitax3pxd/512x384.jpg', '0', 2, 0, '0', 'It&#039;s time to start street racing on roads for winning against endless racers. Enjoy fast driving with cars.', '', 'https://html5.gamemonetize.com/9873khsgwxi4iqd4z9xfc3lwitax3pxd/', 'html5', 800, 600, 1576076683, '1', '0'),
(1397, 'gamemonetize-51', 'city-driving', 'City Driving', 'https://img.gamemonetize.com/lxyriz12kmnzz7mvo55i5l9v9eq16nwr/512x384.jpg', '0', 2, 0, '0', 'City Driving is a realistic simulation and racing game. Just drift and enjoy this car driving simulator. Drive the most furious sports cars!', '', 'https://html5.gamemonetize.com/lxyriz12kmnzz7mvo55i5l9v9eq16nwr/', 'html5', 800, 600, 1576076683, '1', '0'),
(1398, 'gamemonetize-50', 'sniper-fantasy-shooting', 'Sniper Fantasy Shooting', 'https://img.gamemonetize.com/c2n8tk67k327x0qt4g0l28xob471ot51/512x384.jpg', '0', 2, 0, '0', 'Intercept, eliminate and extract. It’s time to engage the enemy! Best Sniper is back, stronger than ever...', '', 'https://html5.gamemonetize.com/c2n8tk67k327x0qt4g0l28xob471ot51/', 'html5', 800, 600, 1576076683, '1', '0'),
(1399, 'gamemonetize-49', 'traffic-racer', 'Traffic Racer', 'https://img.gamemonetize.com/7yo6mwy6wj4jkoqfegvix2sm4g363dfb/512x384.jpg', '0', 2, 0, '0', 'Traffic Racer is a milestone in the genre of endless arcade racing. Drive your car through highway traffic, earn cash, upgrade your car and buy new ones. Endless racing is now redefined!', '', 'https://html5.gamemonetize.com/7yo6mwy6wj4jkoqfegvix2sm4g363dfb/', 'html5', 800, 600, 1576076683, '1', '0'),
(1400, 'gamemonetize-48', 'bus-rush', 'Bus Rush', 'https://img.gamemonetize.com/k8pntef9is1lvl1mb4c1xsqg69cs9msu/512x384.jpg', '0', 2, 0, '0', 'Bus Rush is an amazing arcade game with an endless mechanism. Try to pull off some epic stunts and tricks and show off what you can do! Look out for the power-ups too that will give you a boost. Have fun today and try the different skateboard models available.', '', 'https://html5.gamemonetize.com/k8pntef9is1lvl1mb4c1xsqg69cs9msu/', 'html5', 800, 600, 1576076683, '1', '1'),
(1401, 'gamemonetize-47', 'helix-jump', 'Helix Jump', 'https://img.gamemonetize.com/ghzimuehf6yw4vkdaywk1s9x3mrbgq0w/512x384.jpg', '0', 2, 0, '0', 'Exciting adventure of the bouncing ball through the helix tower labyrinth. One-tap easy-to-learn controls, rich visual effects and addictive gameplay mechanics.', '', 'https://html5.gamemonetize.com/ghzimuehf6yw4vkdaywk1s9x3mrbgq0w/', 'html5', 500, 790, 1576076683, '1', '0'),
(1402, 'gamemonetize-46', 'russian-car-driving', 'Russian Car Driving', 'https://img.gamemonetize.com/71bm57x78u7i2rjerysnhanpf8p2pmbw/512x384.jpg', '0', 2, 0, '0', 'Have you ever ridden a Russian car? Then you know exactly what a real extreme!', '', 'https://html5.gamemonetize.com/71bm57x78u7i2rjerysnhanpf8p2pmbw/', 'html5', 800, 600, 1576076683, '1', '0'),
(1403, 'gamemonetize-45', 'twist-hit', 'Twist Hit', 'https://img.gamemonetize.com/r37qc9iqt3jzr0e75bqxky9es4kr8q00/512x384.jpg', '0', 2, 0, '0', 'Fill the rings to plant trees and save the whole forest. How many trees can you grow? Hold to fill the ring. Be careful to the obstacles!', '', 'https://html5.gamemonetize.com/r37qc9iqt3jzr0e75bqxky9es4kr8q00/', 'html5', 500, 750, 1576076683, '1', '0'),
(1404, 'gamemonetize-44', 'gta-crime-simulator', 'GTA Crime Simulator', 'https://img.gamemonetize.com/ywgsu1e8jqboj8d4tbnomnm111ro0vpy/512x384.jpg', '0', 2, 0, '0', 'GTA Crime Simulator brings you to the streets full citizens, cops, gangsters and boss of mafia. Become a chief on the streets of criminality in Grand City! Unlock all the weapons and find secrets hidden on the map.', '', 'https://html5.gamemonetize.com/ywgsu1e8jqboj8d4tbnomnm111ro0vpy/', 'html5', 800, 600, 1576076683, '1', '1'),
(1405, 'gamemonetize-43', 'block-world', 'Block World', 'https://img.gamemonetize.com/ztj2w5e5pdnhdomxkoufe27b35sk1ng1/512x384.jpg', '0', 2, 0, '0', 'Block World is #1 sandbox block world crafting simulator. If you can imagine it, you can build it!', '', 'https://html5.gamemonetize.com/ztj2w5e5pdnhdomxkoufe27b35sk1ng1/', 'html5', 800, 600, 1576076683, '1', '1'),
(1406, 'gamemonetize-42', 'geometry-fresh', 'Geometry Fresh', 'https://img.gamemonetize.com/53mr80y2f4usmyga4liz6xa8xqnlrdox/512x384.jpg', '0', 5, 0, '0', 'Train you math skills! Give as much right answers as possible during 60 seconds. Procedural generation of game situations Addition, substraction and multiplication are supported Endless replayability', '', 'https://html5.gamemonetize.com/53mr80y2f4usmyga4liz6xa8xqnlrdox/', 'html5', 640, 960, 1576076683, '1', '0'),
(1407, 'gamemonetize-41', 'halloween-remembers', 'Halloween Remembers', 'https://img.gamemonetize.com/ttmf9zqvq7l6sjci4qae7u7l4tqxynvs/512x384.jpg', '0', 5, 0, '0', 'Test your memory. Try to remember the sequence of moving pumpkins. Reproduce it according to your memory. Compare the results with your friends!', '', 'https://html5.gamemonetize.com/ttmf9zqvq7l6sjci4qae7u7l4tqxynvs/', 'html5', 640, 960, 1576076683, '1', '0'),
(1408, 'gamemonetize-40', 'subway-surf-2', 'Subway Surf 2', 'https://img.gamemonetize.com/2yt62p579mmz88c9tqnjxewosr678cmb/512x384.jpg', '0', 5, 0, '0', 'Subway Surf 2 is an endless runner game. As the hooligans run, they grab gold coins out of the air while simultaneously dodging collisions with railway cars.', '', 'https://html5.gamemonetize.com/2yt62p579mmz88c9tqnjxewosr678cmb/', 'html5', 800, 600, 1576076683, '1', '1'),
(1409, 'gamemonetize-39', 'alien-invasion', 'Alien Invasion', 'https://img.gamemonetize.com/nsokbfw2d4xb9rgrt61gy7sef8rpmmj9/512x384.jpg', '0', 5, 0, '0', 'Alien Invasion is an online game that you can play on 4J.Com for free. Aliens have invaded the earth and your work is to protect the earth. The universe is your battlefield, and you are attacked from all sides. Attempt to ruin all the aliens and win this war!', '', 'https://html5.gamemonetize.com/nsokbfw2d4xb9rgrt61gy7sef8rpmmj9/', 'html5', 680, 780, 1576076683, '1', '0'),
(1410, 'gamemonetize-38', 'talking-tom-funny-time', 'Talking Tom Funny Time', 'https://img.gamemonetize.com/3akbz67hgmul9shcxc7oqnt0gdqvt4ow/512x384.jpg', '0', 5, 0, '0', 'Talking Tom Funny Time is an online game that you can play for free. Talking Tom comes back! Today Tom is your pet cat, click the screen to do a funny stuff. You can pet him, poke him or grab his tail. What are you waiting for? Have fun!', '', 'https://html5.gamemonetize.com/3akbz67hgmul9shcxc7oqnt0gdqvt4ow/', 'html5', 640, 480, 1576076683, '1', '0'),
(1411, 'gamemonetize-37', 'arkanoid-for-painters', 'Arkanoid For Painters', 'https://img.gamemonetize.com/i9xspbqv11qgr7hr5fj8th4ilgvwjha2/512x384.jpg', '0', 5, 0, '0', 'Draw the line under the ball to prevent it from falling and to make it destroy blocks', '', 'https://html5.gamemonetize.com/i9xspbqv11qgr7hr5fj8th4ilgvwjha2/', 'html5', 640, 960, 1576076683, '1', '0'),
(1412, 'gamemonetize-36', 'endless-neon', 'Endless Neon', 'https://img.gamemonetize.com/jyasm2iybecqp3aahsevmd2hgbshlhs4/512x384.jpg', '0', 5, 0, '0', '5 games in 1! All games are endless! There is a total score.', '', 'https://html5.gamemonetize.com/jyasm2iybecqp3aahsevmd2hgbshlhs4/', 'html5', 960, 640, 1576076683, '1', '0'),
(1413, 'gamemonetize-35', 'hand-aimer', 'Hand Aimer', 'https://img.gamemonetize.com/5g472nyzs4giuklrkocb422hr57em9ts/512x384.jpg', '0', 4, 0, '0', 'Try to hit the aim with a ball. Change speed and direction of the mech-hand. Perform bounces to make gain more score!', '', 'https://html5.gamemonetize.com/5g472nyzs4giuklrkocb422hr57em9ts/', 'html5', 960, 640, 1576076683, '1', '0'),
(1414, 'gamemonetize-34', 'ouija-voices', 'Ouija Voices', 'https://img.gamemonetize.com/77zsaqkplva53evpm6nevoajw6vymcqu/512x384.jpg', '0', 4, 0, '0', 'Have you ever played ouija board? You should try:) Use your voice to ask questions. Creatures from other worlds will give you the answers!', '', 'https://html5.gamemonetize.com/77zsaqkplva53evpm6nevoajw6vymcqu/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1415, 'gamemonetize-33', '3d-air-racer', '3D Air Racer', 'https://img.gamemonetize.com/ebkusg44h2su1qsxvupz498x2f5m85im/512x384.jpg', '0', 4, 0, '0', '3D Air Racer is brand new 3D airplane simulation game. Complete levels by flying your airplane through the rings. As you progress in the game you unlock new airplanes with which you can do cool tricks. Complete all 20 levels and show that you have what it takes to be a good pilot!', '', 'https://html5.gamemonetize.com/ebkusg44h2su1qsxvupz498x2f5m85im/', 'html5', 700, 550, 1576076683, '1', '0'),
(1416, 'gamemonetize-32', 'tank-arena', 'Tank Arena', 'https://img.gamemonetize.com/kay1w5j6tlna41q0px3clyzkvjug26em/512x384.jpg', '0', 4, 0, '0', 'Battle high tech Alien Tanks in the arena with your super tank.', '', 'https://html5.gamemonetize.com/kay1w5j6tlna41q0px3clyzkvjug26em/', 'html5', 800, 600, 1576076683, '1', '0'),
(1417, 'gamemonetize-31', 'drag-racing', 'Drag Racing', 'https://img.gamemonetize.com/2sjubkdae1jkmk2v97u0x754b5reugox/512x384.jpg', '0', 4, 3, '0', 'Try yourself in a role of the one of drag-racers of the flat world and partitipate in regular night races! Drag Racing is online fuelled racing game!', '', 'https://html5.gamemonetize.com/2sjubkdae1jkmk2v97u0x754b5reugox/', 'html5', 800, 600, 1576076683, '1', '0'),
(1418, 'gamemonetize-30', 'rise-up-balloon', 'Rise Up Balloon', 'https://img.gamemonetize.com/5jwn8b2ufm7rdafdtnslr9cvioaoh76m/512x384.jpg', '0', 4, 0, '0', 'Roll and Rise up balloon. Move your shield with one finger to protect your balloon. Clear your way as you reach higher and higher!', '', 'https://html5.gamemonetize.com/5jwn8b2ufm7rdafdtnslr9cvioaoh76m/', 'html5', 800, 600, 1576076683, '1', '0'),
(1419, 'gamemonetize-29', 'fruit-samurai', 'Fruit Samurai', 'https://img.gamemonetize.com/aipfpvr4mj35c01n5xc28183vu3d49rf/512x384.jpg', '0', 4, 0, '0', 'Fruit Samurai is a classic cutting fruit game,welcome to cut the sweet and delicious fruit.', '', 'https://html5.gamemonetize.com/aipfpvr4mj35c01n5xc28183vu3d49rf/', 'html5', 800, 600, 1576076683, '1', '0'),
(1420, 'gamemonetize-28', 'santa-run', 'Santa Run', 'https://img.gamemonetize.com/67frcc7wy2rd8hs62vy8ehu7cxldbbsi/512x384.jpg', '0', 4, 0, '0', 'The Santa lost his presents. Now you need to help the emu collect these gifts and protect them from dangerous elves, evil deer, cookies and snowmen.', '', 'https://html5.gamemonetize.com/67frcc7wy2rd8hs62vy8ehu7cxldbbsi/', 'html5', 800, 600, 1576076683, '1', '0'),
(1421, 'gamemonetize-27', 'brick-breaker-unicorn', 'Brick Breaker Unicorn', 'https://img.gamemonetize.com/lyv5r7ru6ghxtqbd5hrrvpd4df72dfby/512x384.jpg', '0', 4, 0, '0', 'Swipe your finger to throw the candy balls and break the sweet candy bricks. Have fun with Brick Breaker Unicorn.', '', 'https://html5.gamemonetize.com/lyv5r7ru6ghxtqbd5hrrvpd4df72dfby/', 'html5', 800, 600, 1576076683, '1', '0'),
(1422, 'gamemonetize-26', 'bomber-man', 'Bomber Man', 'https://img.gamemonetize.com/tw52bh54wt1kqyvw5ovyd67mi69iz5rs/512x384.jpg', '0', 4, 0, '0', 'Bomber Man is fun puzzle game. Push boxes or crates into target point or goals to complete a level, there are built-in 70-levels with different difficulty. You can extend or create your own level design using “Level Editor” , so, make a level or design a game level will be quick and easy.', '', 'https://html5.gamemonetize.com/tw52bh54wt1kqyvw5ovyd67mi69iz5rs/', 'html5', 800, 600, 1576076683, '1', '0'),
(1423, 'gamemonetize-25', 'zoo-run', 'Zoo Run', 'https://img.gamemonetize.com/spxguurk8alq1pbuocd72jawcah34x5x/512x384.jpg', '0', 4, 0, '0', 'Zoo Run is awesome endless isometric runner game, with 8 animal characters to choose from, background elements changing every fixed seconds and increasing difficulty', '', 'https://html5.gamemonetize.com/spxguurk8alq1pbuocd72jawcah34x5x/', 'html5', 800, 600, 1576076683, '1', '0'),
(1424, 'gamemonetize-24', 'candy-blocks', 'Candy Blocks', 'https://img.gamemonetize.com/c49fv8oy8wsitu6dcs1l1fvl1kzeqrb2/512x384.jpg', '0', 4, 0, '0', 'Candy Blocks is a super fun puzzle game. It`s simple yet addictive gameplay that challenges your brain, Just move the blocks to fill the empty tiles and collect the pieces of blocks to level up!', '', 'https://html5.gamemonetize.com/c49fv8oy8wsitu6dcs1l1fvl1kzeqrb2/', 'html5', 800, 600, 1576076683, '1', '0'),
(1425, 'gamemonetize-23', 'draw-pixels-heroes-face', 'Draw Pixels Heroes Face', 'https://img.gamemonetize.com/92y7hez415zqqumpr5ut0nj54g7j3rgc/512x384.jpg', '0', 4, 0, '0', 'Your mission is to draw the same image as the image below. Draw the right color in the right place.', '', 'https://html5.gamemonetize.com/92y7hez415zqqumpr5ut0nj54g7j3rgc/', 'html5', 800, 600, 1576076683, '1', '0'),
(1426, 'gamemonetize-22', 'ludo-classic', 'Ludo Classic', 'https://img.gamemonetize.com/luqaexjt6itsaz00dfeooewpgm14xs9j/512x384.jpg', '0', 4, 0, '0', 'Ludo Classic Game is the most played board game between family &amp; friends.', '', 'https://html5.gamemonetize.com/luqaexjt6itsaz00dfeooewpgm14xs9j/', 'html5', 480, 800, 1576076683, '1', '0'),
(1427, 'gamemonetize-21', 'fastlane-road-to-revenge', 'Fastlane: Road to Revenge', 'https://img.gamemonetize.com/lnquy874mrycj5mcqmp6vtmxa63qvjvg/512x384.jpg', '0', 4, 0, '0', 'Fastlane: Road to Revenge is online racing game! Select your fastest vehicle and most powerful weapon to clear all the barriers on the street, fight with the most fierce and cruel wanted man. Race like lights and fight for survive.', '', 'https://html5.gamemonetize.com/lnquy874mrycj5mcqmp6vtmxa63qvjvg/', 'html5', 800, 600, 1576076683, '1', '0'),
(1428, 'gamemonetize-20', 'crazy-maze', 'Crazy Maze', 'https://img.gamemonetize.com/qo8dgh8iro0dqum6qzcv4s5y1bjc4t8u/512x384.jpg', '0', 4, 0, '0', 'Crazy Maze is a simple but a very challenging game. Your only task is to guide the black box to the green one. Do it and you will enter a new level. Have fun.', '', 'https://html5.gamemonetize.com/qo8dgh8iro0dqum6qzcv4s5y1bjc4t8u/', 'html5', 854, 480, 1576076683, '1', '0'),
(1429, 'gamemonetize-19', 'paper-monster-truck-race', 'Paper Monster Truck Race', 'https://img.gamemonetize.com/42hpivoebnvcnp339c73resqh6mst34x/512x384.jpg', '0', 2, 0, '0', 'Paper Monster Truck Race is fun driving html5 game suitable for all ages. Collect as many coins as possible and uppgrade your monster truck. Use mouse or tap on the screen if you get some obstacles in front of you, like boxes, ragdoll or ball. No time no rush. Have fun playing.', '', 'https://html5.gamemonetize.com/42hpivoebnvcnp339c73resqh6mst34x/', 'html5', 854, 480, 1576076683, '1', '0'),
(1430, 'gamemonetize-18', 'police-chase', 'Police Chase', 'https://img.gamemonetize.com/fr7ard6ror1sh7ji1ji5o6abnk50wt2c/512x384.jpg', '0', 2, 0, '0', 'Police Chase is fun driving game suitable for all ages. The aim of the game is to collect all diamonds in the game and stay away from the police. Use rockets to eliminate the police cars. Drive, shoot and have fun.', '', 'https://html5.gamemonetize.com/fr7ard6ror1sh7ji1ji5o6abnk50wt2c/', 'html5', 854, 480, 1576076683, '1', '0'),
(1431, 'gamemonetize-17', 'stickjet-challenge', 'Stickjet Challenge', 'https://img.gamemonetize.com/6llmqld55g7qwo4edn405xfjip6o1t37/512x384.jpg', '0', 2, 0, '0', 'Dodge the obstacles on the way and collect all the stars you find in order to complete the game like a king. Have fun! Good luck!', '', 'https://html5.gamemonetize.com/6llmqld55g7qwo4edn405xfjip6o1t37/', 'html5', 720, 480, 1576076683, '1', '0'),
(1432, 'gamemonetize-16', 'abstract-golf', 'Abstract Golf', 'https://img.gamemonetize.com/466350rvtva1sk6ouuoumuplc2eoefyj/512x384.jpg', '0', 5, 0, '0', 'Become king of the swing in this minimalist golf game in abstract design! Aim for the hole and drag and release to hit the ball. Can you make a hole-in-one and complete all levels?', '', 'https://html5.gamemonetize.com/466350rvtva1sk6ouuoumuplc2eoefyj/', 'html5', 720, 405, 1576076683, '1', '0'),
(1433, 'gamemonetize-15', 'ball-challenge', 'Ball Challenge', 'https://img.gamemonetize.com/bqwkcwye412uu971td4au2gzr7ox71xj/512x384.jpg', '0', 5, 0, '0', 'Move between the top and bottom of the screen as you attempt to avoid obstacles, collect points, and smash helpful power-ups. Try to survive as long as you can!', '', 'https://html5.gamemonetize.com/bqwkcwye412uu971td4au2gzr7ox71xj/', 'html5', 720, 405, 1576076683, '1', '0'),
(1434, 'gamemonetize-14', 'fill-line', 'Fill Line', 'https://img.gamemonetize.com/1h2vp9wrwncvruaxd97ccff0kys7pmyr/512x384.jpg', '0', 5, 0, '0', 'Sharpen your mind with a connect-the-block-style one-line brain training puzzle game. A simple but addictive one-line puzzle game that’s completely free to play.', '', 'https://html5.gamemonetize.com/1h2vp9wrwncvruaxd97ccff0kys7pmyr/', 'html5', 480, 720, 1576076683, '1', '0'),
(1435, 'gamemonetize-13', 'hard-truck', 'Hard Truck', 'https://img.gamemonetize.com/rvfxjqttcrho4kx09djpygsinr4w8xwz/512x384.jpg', '0', 2, 0, '0', 'Drive a monster truck along hard tracks and become a pro monster truck racer. Have Luck!', '', 'https://html5.gamemonetize.com/rvfxjqttcrho4kx09djpygsinr4w8xwz/', 'html5', 720, 405, 1576076683, '1', '0'),
(1436, 'gamemonetize-12', 'just-one', 'Just One', 'https://img.gamemonetize.com/gdvf5gjedlf6gw2d00vgviv8s37cv32b/512x384.jpg', '0', 2, 0, '0', 'Get ready to become the biggest scorer with just one shoot! Enjoy this abstract free throw game where you must choose the right power and angle for your shots. Use walls to bounce and get combos to win more score!', '', 'https://html5.gamemonetize.com/gdvf5gjedlf6gw2d00vgviv8s37cv32b/', 'html5', 480, 720, 1576076683, '1', '0'),
(1437, 'gamemonetize-11', 'yellow-lines', 'Yellow Lines', 'https://img.gamemonetize.com/ms4trixlk5f86zss1rs9w907ibsf8tlv/512x384.jpg', '0', 2, 0, '0', 'Yellow Lines is a simple game to play but a hard one to master! Complete each level, challenge yourself and have fun with this classic ball game!', '', 'https://html5.gamemonetize.com/ms4trixlk5f86zss1rs9w907ibsf8tlv/', 'html5', 480, 720, 1576076683, '1', '0'),
(1438, 'gamemonetize-10', 'hole-in-one', 'Hole in One', 'https://img.gamemonetize.com/393xc6qs7lcxgl8u45p602md5xv3p3ts/512x384.jpg', '0', 8, 0, '0', 'Flick, score, repeat. Gear up to solve unique challenging physics puzzles just by flicking a ball into a glass bowl. Sounds easy, doesn&#039;t it? Well, not as easy as you think.', '', 'https://html5.gamemonetize.com/393xc6qs7lcxgl8u45p602md5xv3p3ts/', 'html5', 480, 720, 1576076683, '1', '0'),
(1439, 'gamemonetize-9', 'bounce-ball', 'Bounce Ball', 'https://img.gamemonetize.com/bwqvo9lb1otu4f5yncfj6gto2jxhc2gn/512x384.jpg', '0', 5, 0, '0', 'Bounce Ball is an elegant, relaxing and inspiring puzzle game. Challenge your brain with a game experience that pushes the limits of your logic.', '', 'https://html5.gamemonetize.com/bwqvo9lb1otu4f5yncfj6gto2jxhc2gn/', 'html5', 720, 405, 1576076683, '1', '0'),
(1440, 'gamemonetize-8', 'eg-hot-jewels', 'EG Hot Jewels', 'https://img.gamemonetize.com/i3cedoe8m7v7wr5ejflcj5dl8z3b8f9q/512x384.jpg', '0', 5, 0, '0', 'EG Hot Jewels is a simple match 3 game, tap screen drag and drop the jewel get high score. Ecaps Games with tons of games for all ages and bringing fun to player Play free online games Have fun!', '', 'https://html5.gamemonetize.com/i3cedoe8m7v7wr5ejflcj5dl8z3b8f9q/', 'html5', 800, 600, 1576076683, '1', '0'),
(1441, 'gamemonetize-7', 'neon-slimes', 'Neon Slimes', 'https://img.gamemonetize.com/39ym7ekx2tlc96018bi11j37mbz33on6/512x384.jpg', '0', 1, 0, '0', 'Make your opponent fall Jump on his had to make him weak and small Use double jump to be cool Have fun!', '', 'https://html5.gamemonetize.com/39ym7ekx2tlc96018bi11j37mbz33on6/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1442, 'gamemonetize-6', 'physics-knife', 'Physics Knife', 'https://img.gamemonetize.com/cz6v1iqup5djdbj4bmojwit15cp10khc/512x384.jpg', '0', 1, 0, '0', 'Take knife like a real thing and interact with it. Throw, rotate your weapon and etc. Knife is not enough? Take axe or shuriken! First game ever with realistic physics of knife throwing', '', 'https://html5.gamemonetize.com/cz6v1iqup5djdbj4bmojwit15cp10khc/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1443, 'gamemonetize-5', 'rat-arena', 'Rat Arena', 'https://img.gamemonetize.com/p29gkdsenripcjdoy9p3xow6tmqfw1fm/512x384.jpg', '0', 1, 0, '0', 'Try to defeat the enemy rat! Use magic wand, sword and shield. Perfect AI 3 types of weapons Cute rats', '', 'https://html5.gamemonetize.com/p29gkdsenripcjdoy9p3xow6tmqfw1fm/', 'html5', 960, 640, 1576076683, '1', '0'),
(1444, 'gamemonetize-4', 'sound-guess', 'Sound Guess', 'https://img.gamemonetize.com/2dcgsh7fevqhwqxc1cpa30vc8u51j09m/512x384.jpg', '0', 1, 0, '0', 'Listen to the sound and try to guess it Spell your answer Difficult? A hint will appear in a few seconds:)', '', 'https://html5.gamemonetize.com/2dcgsh7fevqhwqxc1cpa30vc8u51j09m/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1445, 'gamemonetize-3', 'tanking-tanks', 'Tanking Tanks', 'https://img.gamemonetize.com/x0pfxk710m9z64y80rhm4budpq283gs1/512x384.jpg', '0', 1, 0, '0', 'Do you like tanks? Everyone likes:) Try to destroy your enemies in a hard battle!', '', 'https://html5.gamemonetize.com/x0pfxk710m9z64y80rhm4budpq283gs1/', 'html5', 1920, 1080, 1576076683, '1', '0'),
(1446, 'gamemonetize-2', 'tap-amp-clapp', 'Tap &amp; Clapp', 'https://img.gamemonetize.com/rbubtg20cfy7yw47af6ojo5wy3z5ydwq/512x384.jpg', '0', 5, 0, '0', 'Do you like puzzles? It&#039;s one of the best! Help the blue square to reach the bucket, it makes sense!', '', 'https://html5.gamemonetize.com/rbubtg20cfy7yw47af6ojo5wy3z5ydwq/', 'html5', 960, 640, 1576076683, '1', '0'),
(1447, 'gamemonetize-1', 'parking-space', 'Parking Space', 'https://img.gamemonetize.com/fqlk4iyjezi097cis8nk7khn9rtarax6/512x384.jpg', '0', 2, 0, '0', 'Parking is an online game that you can play for free. In this fun parking game, you will challenge multiple levels. You must drive the car to a free parking space and park the car. Be sure not to hit anywhere or your car will crash. If some cars are blocking the road just move it and continue driving. Use your excellent driving skills to complete this game! Do you have confidence in your parking skill? Have fun with Parking!', '', 'https://html5.gamemonetize.com/fqlk4iyjezi097cis8nk7khn9rtarax6/', 'html5', 854, 480, 1576076683, '1', '0')";

    # >>
    $db[11] = "CREATE TABLE IF NOT EXISTS `gm_media` (
                `id` int(250) NOT NULL AUTO_INCREMENT,
                `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                `extension` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
                `type` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
                `url` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[12] = "CREATE TABLE IF NOT EXISTS `gm_setting` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `site_name` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
                `site_url` varchar(500) CHARACTER SET utf8 NOT NULL,
                `site_theme` varchar(500) CHARACTER SET utf8 NOT NULL,
                `site_description` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Best Free Online Games',
                `site_keywords` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'games, online, arcade, html5, gamemonetize',
                `ads_status` enum('0','1') CHARACTER SET utf8 NOT NULL DEFAULT '0',
                `ad_time` int(11) NOT NULL DEFAULT '10',
                `language` varchar(250) CHARACTER SET utf8 NOT NULL,
                `featured_game_limit` int(11) NOT NULL,
                `mp_game_limit` int(11) NOT NULL,
                `xp_play` int(11) NOT NULL,
                `xp_report` int(11) NOT NULL,
                `xp_register` int(11) NOT NULL,
                `plays` int(255) NOT NULL,
                `settings_1` varchar(500) NOT NULL,
                `settings_2` varchar(500) NOT NULL,
                `settings_3` varchar(500) NOT NULL,
                `settings_4` varchar(500) NOT NULL,
                `settings_5` varchar(500) NOT NULL,
                `settings_6` varchar(500) NOT NULL,
                `settings_7` varchar(500) NOT NULL,
                `settings_8` varchar(500) NOT NULL,
                `settings_9` varchar(500) NOT NULL,
                `settings_10` varchar(500) NOT NULL,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[13] = "INSERT INTO `gm_setting` (`id`, `site_name`, `site_url`, `site_theme`, `ad_time`, `language`, `featured_game_limit`, `mp_game_limit`, `xp_play`, `xp_report`, `xp_register`) VALUES (1, '{$site_title}', '{$site_url}', 'modern', 10, 'english', 8, 12, 50, 100, 10)";
    # >>
    $db[14] = "CREATE TABLE IF NOT EXISTS `gm_theme` (
                `theme_id` int(11) NOT NULL AUTO_INCREMENT,
                `theme_class` varchar(250) CHARACTER SET utf8 NOT NULL,
                PRIMARY KEY (`theme_id`), 
                UNIQUE KEY `theme_class` (`theme_class`), 
                UNIQUE KEY `theme_class_3` (`theme_class`), 
                KEY `theme_class_2` (`theme_class`)
            ) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    # >>
    $db[15] = "INSERT INTO `gm_theme` (`theme_id`, `theme_class`) VALUES (1, 'style-1'), (2, 'style-1-image'), (3, 'style-2'), (4, 'style-2-image'), (5, 'style-3'), (6, 'style-3-image'), (7, 'style-4'), (8, 'style-5'), (9, 'style-6'), (10, 'style-7')";
    # >>

    return (array) $db;
}

function addGameXml(string $gameUrl)
{
    $largestXml = findLargestXml('games');

    if (is_null($largestXml)) {
        echo "not found";die;
    }

    // Load the XML file
    $xml = simplexml_load_file($largestXml->filePath);
    // var_dump($largestXml);die;    

    // count xml child
    $xmlChild = count($xml->children());
    // var_dump($xmlChild);die;    
    if($xmlChild > 1000){
        $xmlGames = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?>' . '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"></urlset>');
        $urlElement = $xmlGames->addChild('url');
        $urlElement->addChild('loc', $gameUrl);
        $xml->asXML('./' . ($largestXml->largestNumber + 1000) . 'games.xml');
    }else{
        // Add child
        $urlElement = $xml->addChild('url');
        $urlElement->addChild('loc', $gameUrl);
        // Save
        $xml->asXML($largestXml->filePath);
    }
}

function findLargestXml($title = 'games')
{
    $directory = $_SERVER['DOCUMENT_ROOT'];
    $files = glob($directory . '/*.xml');
    if (empty($files)) {
        return null;
    }

    $largestNumber = 0;
    $largestFile = '';

    foreach ($files as $file) {
        $fileName = basename($file);

        // Extract numeric part of the file name using regular expression
        if (preg_match('/(\d+)' . $title . '\.xml/', $fileName, $matches)) {
            $currentNumber = (int)$matches[1];

            if ($currentNumber > $largestNumber) {
                $largestNumber = $currentNumber;
                $largestFile = $fileName;
            }
        }
    }

    
    if (!empty($largestFile)) {
        return (object) [
            'filePath' => $directory . '/' . $largestFile,
            'largestNumber' => $largestNumber
        ];
    } 
    return null;
}

function addCategoryXml(string $categoryName)
{
    // Load the XML file
    $xml = simplexml_load_file('categories.xml');

    // Add child
    $xml->addChild('url')->addChild('loc', siteUrl() . '/' . $categoryName);
    // Save
    $xml->asXML('categories.xml');
}